/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Country;
import game.Game;
import game.Global;
import game.ResearchArea;
import game.Technology;
import game.XRandAndCalc;
import game.p_resource.PResource;
import game.unit.Unit;
import java.io.Serializable;

public class Research
implements Serializable {
    private static final long serialVersionUID = 74L;
    Country country;
    ResearchArea[] researchArea = new ResearchArea[5];
    Technology[] techs = new Technology[15];
    public static final int INFANTRY_ATTACK_COST = 30;
    public static final int INFANTRY_DEFENCE_COST = 35;
    public static final int ANTI_TANK_WEAPONS_COST = 35;
    public static final int BLITZ_COST = 30;
    public static final int ARMOR_COST = 30;
    public static final int TANK_COMBAT_COST = 25;
    public static final int DOG_FIGHT_COST = 25;
    public static final int GROUND_SUPPORT_COST = 20;
    public static final int BOMBING_COST = 20;
    public static final int SURFACE_COMBAT_COST = 25;
    public static final int ASW_COST = 20;
    public static final int SUBMARINE_COST = 15;
    public static final int INDUSTRY_COST = 35;
    public static final int ORGANISATION_COST = 55;
    public static final int RADAR_COST = 25;
    int focusChangesLeft = 2;

    public Research(Country cc, int a, int b, int c, int d, int e, int f, int g, int h, int i, int j, int k, int l, int m, int n, int o) {
        this.country = cc;
        this.techs[0] = new Technology(cc, "Artillery", Global.TECHNOLOGY_ATTRIBUTES.getTranslationName(0), 30, a);
        this.techs[1] = new Technology(cc, "Fixed_Defences", Global.TECHNOLOGY_ATTRIBUTES.getTranslationName(6), 35, b);
        this.techs[2] = new Technology(cc, "Anti_Tank_Guns", Global.TECHNOLOGY_ATTRIBUTES.getTranslationName(12), 35, c);
        this.techs[3] = new Technology(cc, "Blitzkrieg", Global.TECHNOLOGY_ATTRIBUTES.getTranslationName(18), 30, d);
        this.techs[4] = new Technology(cc, "Armour", Global.TECHNOLOGY_ATTRIBUTES.getTranslationName(24), 30, e);
        this.techs[5] = new Technology(cc, "Tank_Destroyers", Global.TECHNOLOGY_ATTRIBUTES.getTranslationName(30), 25, f);
        this.techs[6] = new Technology(cc, "Dog_Fight", Global.TECHNOLOGY_ATTRIBUTES.getTranslationName(36), 25, g);
        this.techs[7] = new Technology(cc, "Close_Air_Support", Global.TECHNOLOGY_ATTRIBUTES.getTranslationName(42), 20, h);
        this.techs[8] = new Technology(cc, "Strategic_Operations", Global.TECHNOLOGY_ATTRIBUTES.getTranslationName(48), 20, i);
        this.techs[9] = new Technology(cc, "Surface_Ships", Global.TECHNOLOGY_ATTRIBUTES.getTranslationName(54), 25, j);
        this.techs[10] = new Technology(cc, "ASW", Global.TECHNOLOGY_ATTRIBUTES.getTranslationName(60), 20, k);
        this.techs[11] = new Technology(cc, "Submarines", Global.TECHNOLOGY_ATTRIBUTES.getTranslationName(66), 15, l);
        this.techs[12] = new Technology(cc, "Industry", Global.TECHNOLOGY_ATTRIBUTES.getTranslationName(72), 35, m);
        this.techs[13] = new Technology(cc, "Organisation", Global.TECHNOLOGY_ATTRIBUTES.getTranslationName(78), 55, n);
        this.techs[14] = new Technology(cc, "Radar", Global.TECHNOLOGY_ATTRIBUTES.getTranslationName(84), 25, o);
        Technology[] tempTechs = new Technology[]{this.techs[0], this.techs[1], this.techs[2]};
        this.researchArea[0] = new ResearchArea(this, tempTechs, Global.getMessage(390), "infantry");
        Technology[] tempTechs2 = new Technology[]{this.techs[3], this.techs[4], this.techs[5]};
        this.researchArea[1] = new ResearchArea(this, tempTechs2, Global.getMessage(391), "armour");
        Technology[] tempTechs3 = new Technology[]{this.techs[6], this.techs[7], this.techs[8]};
        this.researchArea[2] = new ResearchArea(this, tempTechs3, Global.getMessage(392), "air");
        Technology[] tempTechs4 = new Technology[]{this.techs[9], this.techs[10], this.techs[11]};
        this.researchArea[3] = new ResearchArea(this, tempTechs4, Global.getMessage(393), "navy");
        Technology[] tempTechs5 = new Technology[]{this.techs[12], this.techs[13], this.techs[14]};
        this.researchArea[4] = new ResearchArea(this, tempTechs5, Global.getMessage(394), "general");
    }

    public ResearchArea getResearchArea(Technology t) {
        int i = 0;
        while (i < this.researchArea.length) {
            int j = 0;
            while (j < this.researchArea[i].tech.length) {
                if (this.researchArea[i].tech[j] == t) {
                    return this.researchArea[i];
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public ResearchArea getResearchArea(int i) {
        return this.researchArea[i];
    }

    public ResearchArea[] getResearchAreas() {
        return this.researchArea;
    }

    public void setTechLevels(int a, int b, int c, int d, int e, int f, int g, int h, int i, int j, int k, int l, int m, int n, int o) {
        this.techs[0].setLevel(a);
        this.techs[1].setLevel(b);
        this.techs[2].setLevel(c);
        this.techs[3].setLevel(d);
        this.techs[4].setLevel(e);
        this.techs[5].setLevel(f);
        this.techs[6].setLevel(g);
        this.techs[7].setLevel(h);
        this.techs[8].setLevel(i);
        this.techs[9].setLevel(j);
        this.techs[10].setLevel(k);
        this.techs[11].setLevel(l);
        this.techs[12].setLevel(m);
        this.techs[13].setLevel(n);
        this.techs[14].setLevel(o);
    }

    public Technology[] getTechs() {
        return this.techs;
    }

    public int getfocusChangesLeft() {
        return this.focusChangesLeft;
    }

    public void incFocusChangesLeft() {
        ++this.focusChangesLeft;
    }

    public void decFocusChangesLeft() {
        --this.focusChangesLeft;
    }

    public int currentLabPrice() {
        return Math.max(Global.LAB_BUY_START_PRICE, Global.LAB_BUY_START_PRICE + this.getNumLabs() * Global.LAB_BUY_PRICE_INCREASE - this.country.getGame().monthsPassed(this.country.getGame().getCalendar()));
    }

    public int getNumLabs() {
        int labs = 0;
        int i = 0;
        while (i < this.researchArea.length) {
            labs += this.researchArea[i].getLabs();
            ++i;
        }
        return labs;
    }

    public double getProgress(int tech) {
        return this.techs[tech].getLevelProgress();
    }

    public int getLevel(int tech) {
        return this.techs[tech].getLevel();
    }

    public int getMaxLevel(int tech) {
        return this.techs[tech].getMaxLevel();
    }

    public int getPResourceTechBonus(PResource pr, int column) {
        int bonus = 0;
        int i = 0;
        while (i < this.techs.length) {
            bonus += this.techs[i].getPResourceTechBonus(pr, column);
            ++i;
        }
        return bonus;
    }

    public int getIndustryTechBonus() {
        int bonus = 0;
        int i = 0;
        while (i < this.techs.length) {
            bonus += this.techs[i].getIndustryTechBonus();
            ++i;
        }
        return bonus;
    }

    public void doAction(int action, ResearchArea ra, boolean forFree, boolean hereFirst) {
        int index = 0;
        int i = 0;
        while (i < this.researchArea.length) {
            if (this.researchArea[i] == ra) {
                index = i;
            }
            ++i;
        }
        this.doAction(action, index, forFree, hereFirst);
    }

    public void doAction(int action, int researchAre, boolean forFree, boolean hereFirst) {
        ResearchArea ra = this.researchArea[researchAre];
        switch (action) {
            case 0: {
                ra.setFocus(-1);
                this.decFocusChangesLeft();
                break;
            }
            case 1: {
                ra.setFocus(0);
                this.decFocusChangesLeft();
                break;
            }
            case 2: {
                ra.setFocus(1);
                this.decFocusChangesLeft();
                break;
            }
            case 3: {
                ra.setFocus(2);
                this.decFocusChangesLeft();
                break;
            }
            case 10: {
                this.country.payPP(this.currentLabPrice());
                ra.changeLabs(1);
                break;
            }
            case 20: {
                this.country.addPP(this.currentLabPrice() * Global.LAB_SELL_FACTOR / 100);
                ra.changeLabs(-1);
            }
        }
        if (hereFirst) {
            Game game = this.country.getGame();
            game.getWarWindow().showPP(false);
            if (game.getGameMode() == 3000) {
                int forFre = 0;
                if (forFree) {
                    forFre = 1;
                }
                game.sendDataToOpponent("z " + action + " " + this.country.getCountryIndex() + " " + researchAre + " " + forFre);
            }
        }
    }

    public Country getCountry() {
        return this.country;
    }

    public int getMaxUpgrades(Unit u) {
        int upgrades = 0;
        int i = 0;
        while (i < this.techs.length) {
            upgrades += this.techs[i].getMaxUpgrades(u);
            ++i;
        }
        return upgrades;
    }

    public int getUpgradesHeld(Unit u) {
        int upgrades = 0;
        int i = 0;
        while (i < this.techs.length) {
            upgrades += this.techs[i].getUpgradesHeld(u, u.getTechLevels().getTechLevel(i));
            ++i;
        }
        return upgrades;
    }

    public int getCountryUpgradesHeld(Unit u) {
        int upgrades = 0;
        int i = 0;
        while (i < this.techs.length) {
            upgrades += this.techs[i].getUpgradesHeld(u, u.getCountry().getResearch().getTechs()[i].getLevel());
            ++i;
        }
        return upgrades;
    }

    public void minorTechPiggyback() {
        Country countryInCharge = this.country.getGame().countryInCharge(this.country);
        if (countryInCharge != this.country) {
            Technology[] t = countryInCharge.getResearch().getTechs();
            int i = 0;
            while (i < this.techs.length) {
                if (this.techs[i].getLevel() < t[i].getLevel() - 2) {
                    this.techs[i].setLevel(t[i].getLevel() - 2);
                }
                ++i;
            }
        }
    }

    public void endTurn(Game g, int r1, int r2, int r3, int r4, int r5, int r6, int r7, int r8, int r9, int r10, int r11, int r12, int r13, int r14, int r15) {
        int roll15;
        int roll14;
        int roll13;
        int roll12;
        int roll11;
        int roll10;
        int roll9;
        int roll8;
        int roll7;
        int roll6;
        int roll5;
        int roll4;
        int roll3;
        int roll2;
        int roll1;
        int maxRnd = 30;
        if (r1 != -1) {
            roll1 = r1;
            roll2 = r2;
            roll3 = r3;
            roll4 = r4;
            roll5 = r5;
            roll6 = r6;
            roll7 = r7;
            roll8 = r8;
            roll9 = r9;
            roll10 = r10;
            roll11 = r11;
            roll12 = r12;
            roll13 = r13;
            roll14 = r14;
            roll15 = r15;
        } else {
            roll1 = XRandAndCalc.rand(30);
            roll2 = XRandAndCalc.rand(30);
            roll3 = XRandAndCalc.rand(30);
            roll4 = XRandAndCalc.rand(30);
            roll5 = XRandAndCalc.rand(30);
            roll6 = XRandAndCalc.rand(30);
            roll7 = XRandAndCalc.rand(30);
            roll8 = XRandAndCalc.rand(30);
            roll9 = XRandAndCalc.rand(30);
            roll10 = XRandAndCalc.rand(30);
            roll11 = XRandAndCalc.rand(30);
            roll12 = XRandAndCalc.rand(30);
            roll13 = XRandAndCalc.rand(30);
            roll14 = XRandAndCalc.rand(30);
            roll15 = XRandAndCalc.rand(30);
            if (g.getGameMode() == 3000) {
                g.sendDataToOpponent("h " + this.country.getCountryIndex() + " " + roll1 + " " + roll2 + " " + roll3 + " " + roll4 + " " + roll5 + " " + roll6 + " " + roll7 + " " + roll8 + " " + roll9 + " " + roll10 + " " + roll11 + " " + roll12 + " " + roll13 + " " + roll14 + " " + roll15);
            }
        }
        this.researchArea[0].progress(g, roll1, roll2, roll3);
        this.researchArea[1].progress(g, roll4, roll5, roll6);
        this.researchArea[2].progress(g, roll7, roll8, roll9);
        this.researchArea[3].progress(g, roll10, roll11, roll12);
        this.researchArea[4].progress(g, roll13, roll14, roll15);
        this.minorTechPiggyback();
    }
}

