/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Game;
import game.TransportationLoop;
import game.XThread;
import game.hex.Hex;
import game.hex.LoopHex;
import game.hex.LoopHex2;
import game.unit.Sub;
import game.unit.Unit;
import gui.WarWindow;
import java.awt.Point;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mover
extends XThread {
    WarWindow warWindow;
    boolean unitMoving;

    public Mover(WarWindow w) {
        this.warWindow = w;
        this.setPriority(10);
    }

    public void setUnitMoving(boolean b) {
        this.unitMoving = b;
    }

    public boolean getUnitMoving() {
        return this.unitMoving;
    }

    public boolean moveUnit(Vector<Integer> routeHexes, boolean airMove) {
        Game game = this.warWindow.getGame();
        boolean surprised = false;
        Unit movingUnit = this.warWindow.getGame().getHex(routeHexes.get(0)).getUnit();
        boolean canSeeUnitWhenStartingMovement = this.warWindow.getGame().canSeeUnit(movingUnit, game.viewingSide());
        movingUnit.setHasMoved(true);
        this.unitMoving = true;
        int size = routeHexes.size();
        int i = 0;
        while (i < Math.max(size - 1, 1)) {
            int first = routeHexes.get(i);
            int second = size == 1 ? routeHexes.get(0).intValue() : routeHexes.get(i + 1).intValue();
            if (game.FOWenemyAdjacent(first, movingUnit)) {
                game.deSelect();
                surprised = true;
                break;
            }
            Unit couldBeEnemyFOW = this.warWindow.getGame().getHex(second).getUnit();
            if (couldBeEnemyFOW != null && couldBeEnemyFOW.getCountry().getSide() != movingUnit.getCountry().getSide()) {
                if (couldBeEnemyFOW instanceof Sub && (game.getGameMode() != 3000 || game.whosTurn() == game.playerSide())) {
                    game.resolveBattle(game.getHex(second), this.warWindow.getGame().getHex(first), true, true);
                }
                game.deSelect();
                surprised = true;
                break;
            }
            int steps = 2;
            if (this.warWindow.getGame().whosTurn() != this.warWindow.getGame().playerSide()) {
                steps = 3;
            }
            if (!airMove) {
                int j = 1;
                while (j < steps + 1) {
                    Point p2 = game.northwestHexEdge(second);
                    Point p1 = game.northwestHexEdge(first);
                    int diffX = p2.x - p1.x;
                    int diffY = p2.y - p1.y;
                    this.warWindow.getGame().getHex(routeHexes.get(i)).getUnit().setOffsets(j * diffX / steps, j * diffY / steps);
                    if (this.warWindow.getGame().canSeeUnit(movingUnit, game.viewingSide())) {
                        this.warWindow.oneImmediateFrame();
                        Mover.delay(10 / steps);
                    }
                    ++j;
                }
            }
            Hex enterHex = this.warWindow.getGame().getHex(routeHexes.get(i + 1));
            if (!(game.getGameMode() != 4000 && game.getGameMode() != 2000 || movingUnit.isInvisible())) {
                game.markArrow(routeHexes.get(i), routeHexes.get(i + 1));
            }
            boolean adjacentOwnershipChange = true;
            if (i == routeHexes.size() - 2) {
                adjacentOwnershipChange = false;
            }
            this.warWindow.getGame().getHex(routeHexes.get(i)).getUnit().enterHex(enterHex, adjacentOwnershipChange);
            this.warWindow.getGame().setActionHex(this.warWindow.getGame().getHex(routeHexes.get(i + 1)));
            if (!canSeeUnitWhenStartingMovement && this.warWindow.getGame().canSeeUnit(movingUnit, game.viewingSide())) {
                this.warWindow.getMapCanvas().setMapViewPosition(movingUnit.getOnHex(), false);
                canSeeUnitWhenStartingMovement = true;
                Mover.delay(500L);
            }
            ++i;
        }
        this.warWindow.getGame().spotAroundUnit(movingUnit);
        this.warWindow.getGame().createOwningBorders();
        this.unitMoving = false;
        Hex afterMove = movingUnit.getOnHex();
        if (afterMove != null) {
            boolean entryHex;
            if (afterMove instanceof LoopHex) {
                TransportationLoop africaLoop = this.warWindow.getGame().getGameState().getAfricaLoop();
                entryHex = false;
                if (this.warWindow.getGame().getHexIndex(afterMove) == africaLoop.getEntryHex()) {
                    entryHex = true;
                }
                if (movingUnit.getSide() == africaLoop.getControllingSide()) {
                    this.warWindow.getGame().getGameState().getAfricaLoop().enterLoop(movingUnit, entryHex);
                    surprised = true;
                }
            } else if (afterMove instanceof LoopHex2) {
                TransportationLoop suezLoop = this.warWindow.getGame().getGameState().getSuezLoop();
                entryHex = false;
                if (this.warWindow.getGame().getHexIndex(afterMove) == suezLoop.getEntryHex()) {
                    entryHex = true;
                }
                if (movingUnit.getSide() == suezLoop.getControllingSide()) {
                    this.warWindow.getGame().getGameState().getSuezLoop().enterLoop(movingUnit, entryHex);
                    surprised = true;
                }
            }
        }
        this.warWindow.getMapCanvas().setPaintFullCanvas(true);
        if (!movingUnit.getFOWed() || this.warWindow.getGame().whosTurn() == movingUnit.getCountry().getSide()) {
            this.warWindow.oneImmediateFrame();
        }
        this.warWindow.getMiniMap().repaint();
        this.warWindow.getLeftUnitPanel().updateAll(true, false);
        return surprised;
    }

    @Override
    public void run() {
    }
}

