/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.GeneralData;
import game.LeadersData;
import game.MediaTrackerThread;
import game.Messages;
import game.SettingsData;
import game.SoundPlayer;
import game.TechnologyAttributes;
import game.TerrainPenalties;
import game.UnitAttributes;
import gui.OkDialog;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.io.File;
import java.net.InetAddress;
import java.net.URL;
import javax.swing.JFrame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Global {
    public static SoundPlayer SOUND_PLAYER;
    public static int machineSpec;
    private static GraphicsDevice graphicsDevice;
    private static DisplayMode defaultDisplayMode;
    private static String installPath;
    private static String terrainPath;
    private static String PResourcesPath;
    private static String hexPath;
    private static String soundPath;
    private static String dataPath;
    private static String trackPath;
    private static String unitPath;
    private static String leaderPath;
    private static String backgroundPath;
    private static String imagePath;
    private static String scenarioPath;
    private static String savePath;
    private static String hotseatPath;
    private static String pbemPath;
    private static String tcpipPath;
    private static String overlayPath;
    private static String root;
    private static int language;
    public static boolean hadFullScreen;
    public static boolean hidden;
    public static double SCREEN_RATIO;
    public static SettingsData SETTINGS_DATA;
    public static GeneralData GENERAL_DATA;
    public static UnitAttributes UNIT_ATTRIBUTES;
    public static TerrainPenalties BATTLE_PENALTIES;
    public static TechnologyAttributes TECHNOLOGY_ATTRIBUTES;
    public static LeadersData LEADERS_DATA;
    public static Messages MESSAGES;
    public static final int GAME_PORT = 6770;
    public static final int ROLLS_SENT_DURING_BATTLE = 30;
    public static final int HORIZONTAL_HEXES = 150;
    public static final int VERTICAL_HEXES = 72;
    public static final int HEX_SIDE = 10;
    public static final int HEX_SMALL_WIDTH = 16;
    public static final int HEX_BIG_WIDTH = 20;
    public static final int STEPS_PER_HEX = 2;
    public static final int STEPS_PER_HEX_WATCHING = 3;
    public static final double MINI_MAP_FACTOR = 8.52;
    public static final int MAP_IMAGE_WIDTH = 2250;
    public static final int MAP_IMAGE_HEIGHT = 1160;
    public static final int TERRAIN_WIDTH = 30;
    public static final int UNIT_WIDTH = 16;
    public static final int UNIT_HEIGHT = 16;
    public static final int PRESOURCE_WIDTH = 16;
    public static final int PRESOURCE_HEIGHT = 16;
    public static final int INFO_DIALOG_DELAY = 2500;
    public static int DEFAULT_ZOOM;
    public static int MAX_ZOOM;
    public static long SOUND_INTERRUPT;
    public static String bigFontName1;
    public static String smallFontName1;
    public static final int COLOR_INTERVAL1 = 60;
    public static final int COLOR_INTERVAL2 = 40;
    public static final int COLOR_INTERVAL3 = 20;
    public static final int ALPHA_VALUE_90 = 229;
    public static final int ALPHA_VALUE_80 = 204;
    public static final int ALPHA_VALUE_70 = 178;
    public static final int ALPHA_VALUE_60 = 153;
    public static final int ALPHA_VALUE_50 = 127;
    public static final int ALPHA_VALUE_40 = 101;
    public static final int ALPHA_VALUE_35 = 89;
    public static final int ALPHA_VALUE_25 = 63;
    public static final int ALPHA_VALUE_20 = 51;
    public static final int NORTH = 0;
    public static final int EAST = 1;
    public static final int SOUTH = 2;
    public static final int WEST = 3;
    public static final int GERMANY = 0;
    public static final int ITALY = 1;
    public static final int UK = 2;
    public static final int FRANCE = 3;
    public static final int USA = 4;
    public static final int USSR = 5;
    public static final int HOLLAND = 6;
    public static final int BELGIUM = 7;
    public static final int DENMARK = 8;
    public static final int NORWAY = 9;
    public static final int SWEDEN = 10;
    public static final int FINLAND = 11;
    public static final int HUNGARY = 12;
    public static final int ROMANIA = 13;
    public static final int BULGARIA = 14;
    public static final int YUGOSLAVIA = 15;
    public static final int GREECE = 16;
    public static final int TURKEY = 17;
    public static final int PERSIA = 18;
    public static final int IRAQ = 19;
    public static final int SPAIN = 20;
    public static final int PORTUGAL = 21;
    public static final int IRELAND = 22;
    public static final int POLAND = 23;
    public static final int FREE_ALGERIA = 24;
    public static final int SWITZERLAND = 25;
    public static final int NO_COUNTRY = 26;
    public static final int ESTONIA = 27;
    public static final int LATVIA = 28;
    public static final int LITHUANIA = 29;
    public static final int LIBYA = 30;
    public static final int EGYPT = 31;
    public static final int SYRIA = 32;
    public static final int CANADA = 33;
    public static final int CROATIA = 34;
    public static final int UKRAINE = 35;
    public static final int SPARE_COUNTRY_1 = 36;
    public static final int AXIS = 100;
    public static final int ALLIES = 200;
    public static final int NEUTRAL = 300;
    public static final int NEW_GAME = 1000;
    public static final int HOTSEAT_GAME = 2000;
    public static final int TCPIP_GAME = 3000;
    public static final int PBEM_GAME = 4000;
    public static final int ARMOUR_IMAGES = 6;
    public static final int FIGHTER_IMAGES = 5;
    public static final int TACTICAL_BOMBER_IMAGES = 3;
    public static final int STRATEGIC_BOMBER_IMAGES = 3;
    public static final Color WATER_COLOR;
    public static final Color NEUTRAL_COLOR;
    public static final Color GERMAN_MINOR_COLOR;
    public static final Color GERMAN_MINOR_HIGHLIGHT_COLOR;
    public static final Color ALLIED_MINOR_COLOR;
    public static final Color ALLIED_MINOR_HIGHLIGHT_COLOR;
    public static final int MAX_ROLL = 1000;
    public static final int SCAPA_FLOW = 4618;
    public static final int GLASGOW = 4262;
    public static final int EDINBURGH = 4624;
    public static final int LIVERPOOL = 4340;
    public static final int LONDON = 4776;
    public static final int CARDIFF = 4201;
    public static final int HALIFAX = 822;
    public static int BASE_YEAR;
    public static int BASE_MONTH;
    public static int BASE_DATE;
    public static int DAYS_PER_TURN;
    public static int OCCUPIED_PRODUCTION_RATE;
    public static int MAX_DEFICIT_BEFORE_SPENDING_STOP;
    public static int RAIL_MOVE_COST;
    public static int TRANSPORT_COST;
    public static int MANPOWER_INCREASE;
    public static int QUARTERLY_PEACE_PRODUCTION_INCREASE;
    public static int AT_WAR_PRODUCTION_INCREASE;
    public static int FULL_MOBILIZATION_PRODUCTION_INCREASE;
    public static int MAX_RAILROAD_DISTANCE;
    public static int AXIS_FREE_RAIL_MOVES;
    public static int ALLIES_FREE_RAIL_MOVES;
    public static int USSR_FREE_RAIL_MOVES;
    public static int SUPPLY_PENALTY_DISTANCE;
    public static int AXIS_WINTER_SUFFER;
    public static int ALLIES_WINTER_SUFFER;
    public static int WINTER_DURATION;
    public static int RETREAT_REMAINING_EFFICIENCY_THRESHOLD;
    public static int RETREAT_CASUALTY_THRESHOLD;
    public static int RETREAT_FROM_CITY_CAPITAL_FORTRESS;
    public static int RETREAT_FROM_NON_CLEAR;
    public static int RETREAT_FROM_CLEAR;
    public static int EXTRA_ATTACKS;
    public static int EFFICIENCY_REGAIN;
    public static int EFFICIENCY_LOSS_FROM_SHOCK;
    public static int EFFICIENCY_LOSS_CASUALTY_FACTOR;
    public static int EFFICIENCY_LOSS_FROM_DEPLOY;
    public static int EFFICIENCY_LOSS_FROM_MOVEMENT;
    public static int EFFICIENCY_LOSS_FROM_RAIL_MOVEMENT;
    public static int EFFICIENCY_LOSS_FROM_UNLOAD;
    public static int EFFICIENCY_LOSS_LACK_SUPPLY;
    public static int CASUALTY_FACTOR;
    public static int AIR_DUEL_CASUALTY_FACTOR;
    public static int STRATEGIC_CASUALTY_FACTOR;
    public static int SHOCK_FACTOR;
    public static int LOWEST_MAX_EFFICIENCY;
    public static int EXPERIENCE_PER_QUALITY_INCREASE;
    public static int EXPERIENCE_PER_SURVIVABILITY_INCREASE;
    public static int COMMANDER_BUILDING_TIME;
    public static int COMMANDER_RANGE;
    public static int COMMANDER_REASSIGN_COST;
    public static int COMMANDER_REASSIGN_DISTANCE_PER_TURN;
    public static int COMMANDER_MAX_INJURY;
    public static int MAX_SUPPLY;
    public static int HALF_SUPPLY;
    public static int LOW_SUPPLY;
    public static int NAVY_SUPPLY_CONSUMPTION;
    public static int ALLIED_TURNS_BETWEEN_CONVOYS;
    public static int NORTH_ATLANTIC_CONVOY_SIZE;
    public static int MID_ATLANTIC_CONVOY_SIZE;
    public static int SOUTH_ATLANTIC_CONVOY_SIZE;
    public static int AFRICA_LOOP_TURNS;
    public static int SUEZ_LOOP_TURNS;
    public static int AXIS_DOW_PENALTY;
    public static int AXIS_DOW_PENALTY_INCREASE;
    public static int ALLIES_DOW_PENALTY;
    public static int ALLIES_DOW_PENALTY_INCREASE;
    public static int RANDOM_WAR_ENTRY;
    public static int MAX_LABS;
    public static int LAB_BUY_START_PRICE;
    public static int LAB_BUY_PRICE_INCREASE;
    public static int LAB_SELL_FACTOR;
    public static int UPGRADE_MINIMUM_COST;
    public static int UPGRADE_FRACTION_COST;
    public static int UPGRADE_EFFICIENCY_LOSS;
    public static int MILITARY_INFLUENCE_FACTOR;
    public static int AGGRESSION_IMPORTANCE;
    public static int AXIS_1939_AGGRESSION;
    public static int ALLIES_1939_AGGRESSION;
    public static int AGGRESSION_YEARLY_INCREASE;
    public static int DOW_DECREASE;
    public static int DOW_THRESHOLD;
    public static int MAX_DOW_RANDOM;
    public static int TARGET_MAJOR_INCREASE;
    public static int TARGET_MINOR_DECREASE;
    public static int TARGET_THRESHOLD;
    public static int MAX_TARGET_RANDOM;
    public static int AT_WAR;
    public static int RECONQUEST_MAJOR;
    public static int SAME_SIDE;
    public static int OIL_BUFFER_BEFORE_DESPERATION;
    public static int OIL_IMPORTANCE;
    public static int MAX_CAPITAL_TO_CAPITAL_DISTANCE;
    public static int DISTANCE_BONUS_PER_HEX;
    public static int SAME_CONTINENT;
    public static int CAPITAL_DEFENCE;
    public static int DEFENCE_REACTION;
    public static int CONVOY_NATION;
    public static int SAFE_AIR_DISTANCE;
    public static MediaTrackerThread mt;

    static {
        machineSpec = 0;
        graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        defaultDisplayMode = graphicsDevice.getDisplayMode();
        hadFullScreen = false;
        hidden = false;
        SCREEN_RATIO = 1.0;
        SOUND_INTERRUPT = 2000L;
        WATER_COLOR = new Color(15, 15, 225);
        NEUTRAL_COLOR = new Color(225, 225, 210);
        GERMAN_MINOR_COLOR = new Color(170, 170, 170);
        GERMAN_MINOR_HIGHLIGHT_COLOR = new Color(200, 200, 200);
        ALLIED_MINOR_COLOR = new Color(230, 230, 110);
        ALLIED_MINOR_HIGHLIGHT_COLOR = new Color(240, 240, 150);
    }

    public static int getLanguage() {
        return language;
    }

    public static String getLanguageString() {
        String ret = "";
        switch (language) {
            case 1: {
                ret = "eng";
                break;
            }
            case 2: {
                ret = "fre";
                break;
            }
            case 3: {
                ret = "ita";
                break;
            }
            case 4: {
                ret = "spa";
                break;
            }
            case 5: {
                ret = "pol";
                break;
            }
            case 6: {
                ret = "ger";
                break;
            }
            case 7: {
                ret = "rus";
                break;
            }
            case 8: {
                ret = "chi";
            }
        }
        return ret;
    }

    public static boolean reverseBoolean(boolean b) {
        return !b;
    }

    public static int reverseBooleanToInt(boolean b) {
        if (b) {
            return 0;
        }
        return 1;
    }

    public static int booleanToInt(boolean b) {
        if (b) {
            return 1;
        }
        return 0;
    }

    public static boolean intToBoolean(int i) {
        return i != 0;
    }

    public static boolean intToReverseBoolean(int i) {
        return i == 0;
    }

    public static String getInstallPath() {
        return installPath;
    }

    public static String getSoundPath() {
        return soundPath;
    }

    public static String getDataPath() {
        return dataPath;
    }

    public static String getTrackPath() {
        return trackPath;
    }

    public static String getUnitPath() {
        return unitPath;
    }

    public static String getLeaderPath() {
        return leaderPath;
    }

    public static String createLanguageMessage(int mess, String[] var) {
        if (SETTINGS_DATA.getVal("DEBUG_MESSAGES") == 1) {
            return "y-y-y";
        }
        return Global.replaceAll(MESSAGES.getMessage(mess), var);
    }

    public static String replaceAll(String s, String[] var) {
        int i = 0;
        while (i < var.length) {
            String next = "%s" + (i + 1);
            s = s.replaceAll(next, var[i]);
            ++i;
        }
        return s;
    }

    public static String getBackgroundPath() {
        return backgroundPath;
    }

    public static String getPResourcesPath() {
        return PResourcesPath;
    }

    public static String getHexPath() {
        return hexPath;
    }

    public static String getTerrainPath() {
        return terrainPath;
    }

    public static String getImagePath() {
        return imagePath;
    }

    public static String getOverlayPath() {
        return overlayPath;
    }

    public static String getScenarioPath() {
        return scenarioPath;
    }

    public static String getSavePath() {
        return savePath;
    }

    public static String getHotSeatPath() {
        return hotseatPath;
    }

    public static String getpbemPath() {
        return pbemPath;
    }

    public static String gettcpipPath() {
        return tcpipPath;
    }

    public static String getIP() {
        String s = "IP Address Unknown";
        try {
            s = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return s;
    }

    public static boolean bigFontFound() {
        return bigFontName1.compareTo("Haettenschweiler") == 0;
    }

    public static boolean smallFontFound() {
        return smallFontName1.compareTo("Franklin Gothic Medium") == 0;
    }

    public static void fixFonts() {
        Font testFont2;
        bigFontName1 = "Haettenschweiler";
        smallFontName1 = "Franklin Gothic Medium";
        Font testFont = new Font("Haettenschweiler", 0, 12);
        if (testFont.getFontName().compareTo("Haettenschweiler") != 0) {
            bigFontName1 = "Impact";
        }
        if ((testFont2 = new Font("Franklin Gothic Medium", 0, 12)).getFontName().compareTo("Franklin Gothic Medium") != 0) {
            smallFontName1 = "Times New Roman";
        }
        if (SETTINGS_DATA.getVal("DEBUG_ALTERNATIVE_FONT") == 1) {
            bigFontName1 = "Impact";
            smallFontName1 = "Times New Roman";
        }
    }

    public static void fixPaths() {
        try {
            SOUND_PLAYER = new SoundPlayer();
            SOUND_PLAYER.start();
            installPath = String.valueOf(new File("").getAbsolutePath()) + "/CEAW.app/Contents/Resources/Java/";
            root = String.valueOf(new File("").getAbsolutePath()) + "/CEAW.app/Contents/";
            soundPath = String.valueOf(installPath) + "sound/";
            imagePath = String.valueOf(installPath) + "image/";
            terrainPath = String.valueOf(installPath) + "image/" + "terrain/";
            unitPath = String.valueOf(installPath) + "image/" + "unit/";
            leaderPath = String.valueOf(installPath) + "image/" + "commander/";
            backgroundPath = String.valueOf(installPath) + "image/" + "background/";
            PResourcesPath = String.valueOf(installPath) + "image/" + "p_resource/";
            hexPath = String.valueOf(installPath) + "image/" + "hex/";
            overlayPath = String.valueOf(installPath) + "image/" + "overlay/";
            dataPath = String.valueOf(installPath) + "data/";
            scenarioPath = String.valueOf(dataPath) + "scenario/";
            savePath = String.valueOf(root) + "save/";
            hotseatPath = String.valueOf(root) + "hotseat/";
            pbemPath = String.valueOf(root) + "pbem/";
            tcpipPath = String.valueOf(root) + "tcpip/";
            SETTINGS_DATA = new SettingsData();
            Global.setLanguage(SETTINGS_DATA.getVal("LANGUAGE"));
            Global.setMahineSpec(SETTINGS_DATA.getVal("LOW_RAM"));
            Global.fixFonts();
        }
        catch (Exception e) {
            System.exit(110);
        }
    }

    public static URL locateClass(Class<URL> pClass) {
        String className = pClass.getName();
        String resourcePath = "/" + className.replace('.', '/') + ".class";
        URL classURL = pClass.getResource(resourcePath);
        return classURL;
    }

    public static void setLanguage(int lang) {
        language = lang;
    }

    public static void setMahineSpec(int mem) {
        machineSpec = mem;
    }

    public static int getMachineSpec() {
        return machineSpec;
    }

    public static boolean isFullScreen(JFrame window) {
        return graphicsDevice.getFullScreenWindow() == window;
    }

    public static void setFullScreen_reserv(JFrame window, boolean on) {
        window.setVisible(on);
    }

    public static void setFullScreen(JFrame window, boolean on) {
        if (!on) {
            graphicsDevice.setDisplayMode(defaultDisplayMode);
            graphicsDevice.setFullScreenWindow(null);
        } else if (graphicsDevice.isFullScreenSupported() && SCREEN_RATIO < 991.4) {
            try {
                DisplayMode[] disp = graphicsDevice.getDisplayModes();
                DisplayMode best = new DisplayMode(1024, 768, 32, defaultDisplayMode.getRefreshRate());
                System.out.println("Display Setting Count = " + disp.length + "\n");
                int i = 0;
                while (i < disp.length) {
                    if (disp[i].getWidth() == best.getWidth() && disp[i].getHeight() == best.getHeight() && disp[i].getBitDepth() == best.getBitDepth()) {
                        graphicsDevice.setFullScreenWindow(window);
                        graphicsDevice.setDisplayMode(best);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                Global.showOkDialog(Global.createLanguageMessage(98, new String[]{"1024x768"}), false);
            }
        } else {
            window.setVisible(true);
        }
    }

    public static String getMessage(int index) {
        if (SETTINGS_DATA.getVal("DEBUG_MESSAGES") == 1) {
            return "x-x-x";
        }
        return MESSAGES.getMessage(index);
    }

    public static void showOkDialog(String s, boolean exitGame) {
        OkDialog wrongResolutionDialog = new OkDialog(null, null);
        wrongResolutionDialog.showDialog(s);
        if (exitGame) {
            System.exit(131);
        }
    }

    public static JFrame showBlackWindow() {
        JFrame blackWindow = new JFrame();
        blackWindow.setBackground(Color.black);
        blackWindow.setUndecorated(true);
        if (SETTINGS_DATA.getVal("WINDOWED_MODE") == 0) {
            Global.setFullScreen(blackWindow, true);
        } else {
            blackWindow.setVisible(true);
        }
        return blackWindow;
    }

    public static void fixVariables2() {
        if (Global.getMachineSpec() < 2) {
            DEFAULT_ZOOM = 2;
            MAX_ZOOM = 2;
        } else {
            DEFAULT_ZOOM = 4;
            MAX_ZOOM = 4;
        }
    }

    public static void fixVariables() {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        SCREEN_RATIO = d.getWidth() / d.getHeight();
        GENERAL_DATA = new GeneralData();
        UNIT_ATTRIBUTES = new UnitAttributes();
        BATTLE_PENALTIES = new TerrainPenalties();
        TECHNOLOGY_ATTRIBUTES = new TechnologyAttributes();
        LEADERS_DATA = new LeadersData();
        MESSAGES = new Messages();
        BASE_YEAR = GENERAL_DATA.getVal("BASE_YEAR");
        BASE_MONTH = GENERAL_DATA.getVal("BASE_MONTH");
        BASE_DATE = GENERAL_DATA.getVal("BASE_DATE");
        DAYS_PER_TURN = GENERAL_DATA.getVal("DAYS_PER_TURN");
        OCCUPIED_PRODUCTION_RATE = GENERAL_DATA.getVal("OCCUPIED_PRODUCTION_RATE");
        MAX_DEFICIT_BEFORE_SPENDING_STOP = GENERAL_DATA.getVal("MAX_DEFICIT_BEFORE_SPENDING_STOP");
        RAIL_MOVE_COST = GENERAL_DATA.getVal("RAIL_MOVE_COST");
        TRANSPORT_COST = GENERAL_DATA.getVal("TRANSPORT_COST");
        MANPOWER_INCREASE = GENERAL_DATA.getVal("MANPOWER_INCREASE");
        QUARTERLY_PEACE_PRODUCTION_INCREASE = GENERAL_DATA.getVal("QUARTERLY_PEACE_PRODUCTION_INCREASE");
        AT_WAR_PRODUCTION_INCREASE = GENERAL_DATA.getVal("AT_WAR_PRODUCTION_INCREASE");
        FULL_MOBILIZATION_PRODUCTION_INCREASE = GENERAL_DATA.getVal("FULL_MOBILIZATION_PRODUCTION_INCREASE");
        MAX_RAILROAD_DISTANCE = GENERAL_DATA.getVal("MAX_RAILROAD_DISTANCE");
        AXIS_FREE_RAIL_MOVES = GENERAL_DATA.getVal("AXIS_FREE_RAIL_MOVES");
        ALLIES_FREE_RAIL_MOVES = GENERAL_DATA.getVal("ALLIES_FREE_RAIL_MOVES");
        USSR_FREE_RAIL_MOVES = GENERAL_DATA.getVal("USSR_FREE_RAIL_MOVES");
        SUPPLY_PENALTY_DISTANCE = GENERAL_DATA.getVal("SUPPLY_PENALTY_DISTANCE");
        AXIS_WINTER_SUFFER = GENERAL_DATA.getVal("AXIS_WINTER_SUFFER");
        ALLIES_WINTER_SUFFER = GENERAL_DATA.getVal("ALLIES_WINTER_SUFFER");
        WINTER_DURATION = GENERAL_DATA.getVal("WINTER_DURATION");
        RETREAT_REMAINING_EFFICIENCY_THRESHOLD = GENERAL_DATA.getVal("RETREAT_REMAINING_EFFICIENCY_THRESHOLD");
        RETREAT_CASUALTY_THRESHOLD = GENERAL_DATA.getVal("RETREAT_CASUALTY_THRESHOLD");
        RETREAT_FROM_CITY_CAPITAL_FORTRESS = GENERAL_DATA.getVal("RETREAT_CASUALTY_THRESHOLD");
        RETREAT_FROM_NON_CLEAR = GENERAL_DATA.getVal("RETREAT_FROM_NON_CLEAR");
        RETREAT_FROM_CLEAR = GENERAL_DATA.getVal("RETREAT_FROM_CLEAR");
        EXTRA_ATTACKS = GENERAL_DATA.getVal("EXTRA_ATTACKS");
        EFFICIENCY_REGAIN = GENERAL_DATA.getVal("EFFICIENCY_REGAIN");
        EFFICIENCY_LOSS_FROM_SHOCK = GENERAL_DATA.getVal("EFFICIENCY_LOSS_FROM_SHOCK");
        EFFICIENCY_LOSS_CASUALTY_FACTOR = GENERAL_DATA.getVal("EFFICIENCY_LOSS_CASUALTY_FACTOR");
        EFFICIENCY_LOSS_FROM_DEPLOY = GENERAL_DATA.getVal("EFFICIENCY_LOSS_FROM_DEPLOY");
        EFFICIENCY_LOSS_FROM_MOVEMENT = GENERAL_DATA.getVal("EFFICIENCY_LOSS_FROM_MOVEMENT");
        EFFICIENCY_LOSS_FROM_RAIL_MOVEMENT = GENERAL_DATA.getVal("EFFICIENCY_LOSS_FROM_RAIL_MOVEMENT");
        EFFICIENCY_LOSS_FROM_UNLOAD = GENERAL_DATA.getVal("EFFICIENCY_LOSS_FROM_UNLOAD");
        EFFICIENCY_LOSS_LACK_SUPPLY = GENERAL_DATA.getVal("EFFICIENCY_LOSS_LACK_SUPPLY");
        CASUALTY_FACTOR = GENERAL_DATA.getVal("CASUALTY_FACTOR");
        AIR_DUEL_CASUALTY_FACTOR = GENERAL_DATA.getVal("AIR_DUEL_CASUALTY_FACTOR");
        STRATEGIC_CASUALTY_FACTOR = GENERAL_DATA.getVal("STRATEGIC_CASUALTY_FACTOR");
        SHOCK_FACTOR = GENERAL_DATA.getVal("SHOCK_FACTOR");
        LOWEST_MAX_EFFICIENCY = GENERAL_DATA.getVal("LOWEST_MAX_EFFICIENCY");
        EXPERIENCE_PER_QUALITY_INCREASE = GENERAL_DATA.getVal("EXPERIENCE_PER_QUALITY_INCREASE");
        EXPERIENCE_PER_SURVIVABILITY_INCREASE = GENERAL_DATA.getVal("EXPERIENCE_PER_SURVIVABILITY_INCREASE");
        COMMANDER_BUILDING_TIME = GENERAL_DATA.getVal("COMMANDER_BUILDING_TIME");
        COMMANDER_RANGE = GENERAL_DATA.getVal("COMMANDER_RANGE");
        COMMANDER_REASSIGN_COST = GENERAL_DATA.getVal("COMMANDER_REASSIGN_COST");
        COMMANDER_REASSIGN_DISTANCE_PER_TURN = GENERAL_DATA.getVal("COMMANDER_REASSIGN_DISTANCE_PER_TURN");
        COMMANDER_MAX_INJURY = GENERAL_DATA.getVal("COMMANDER_MAX_INJURY");
        MAX_SUPPLY = GENERAL_DATA.getVal("MAX_SUPPLY");
        HALF_SUPPLY = GENERAL_DATA.getVal("HALF_SUPPLY");
        LOW_SUPPLY = GENERAL_DATA.getVal("LOW_SUPPLY");
        NAVY_SUPPLY_CONSUMPTION = GENERAL_DATA.getVal("NAVY_SUPPLY_CONSUMPTION");
        ALLIED_TURNS_BETWEEN_CONVOYS = GENERAL_DATA.getVal("ALLIED_TURNS_BETWEEN_CONVOYS");
        NORTH_ATLANTIC_CONVOY_SIZE = GENERAL_DATA.getVal("NORTH_ATLANTIC_CONVOY_SIZE");
        MID_ATLANTIC_CONVOY_SIZE = GENERAL_DATA.getVal("MID_ATLANTIC_CONVOY_SIZE");
        SOUTH_ATLANTIC_CONVOY_SIZE = GENERAL_DATA.getVal("SOUTH_ATLANTIC_CONVOY_SIZE");
        AFRICA_LOOP_TURNS = GENERAL_DATA.getVal("AFRICA_LOOP_TURNS");
        SUEZ_LOOP_TURNS = GENERAL_DATA.getVal("SUEZ_LOOP_TURNS");
        AXIS_DOW_PENALTY = GENERAL_DATA.getVal("AXIS_DOW_PENALTY");
        AXIS_DOW_PENALTY_INCREASE = GENERAL_DATA.getVal("AXIS_DOW_PENALTY_INCREASE");
        ALLIES_DOW_PENALTY = GENERAL_DATA.getVal("ALLIES_DOW_PENALTY");
        ALLIES_DOW_PENALTY_INCREASE = GENERAL_DATA.getVal("ALLIES_DOW_PENALTY_INCREASE");
        RANDOM_WAR_ENTRY = GENERAL_DATA.getVal("RANDOM_WAR_ENTRY");
        MAX_LABS = GENERAL_DATA.getVal("MAX_LABS");
        LAB_BUY_START_PRICE = GENERAL_DATA.getVal("LAB_BUY_START_PRICE");
        LAB_BUY_PRICE_INCREASE = GENERAL_DATA.getVal("LAB_BUY_PRICE_INCREASE");
        LAB_SELL_FACTOR = GENERAL_DATA.getVal("LAB_SELL_FACTOR");
        UPGRADE_MINIMUM_COST = GENERAL_DATA.getVal("UPGRADE_MINIMUM_COST");
        UPGRADE_FRACTION_COST = GENERAL_DATA.getVal("UPGRADE_FRACTION_COST");
        UPGRADE_EFFICIENCY_LOSS = GENERAL_DATA.getVal("UPGRADE_EFFICIENCY_LOSS");
        MILITARY_INFLUENCE_FACTOR = GENERAL_DATA.getVal("MILITARY_INFLUENCE_FACTOR");
        AGGRESSION_IMPORTANCE = GENERAL_DATA.getVal("AGGRESSION_IMPORTANCE");
        AXIS_1939_AGGRESSION = GENERAL_DATA.getVal("AXIS_1939_AGGRESSION");
        ALLIES_1939_AGGRESSION = GENERAL_DATA.getVal("ALLIES_1939_AGGRESSION");
        AGGRESSION_YEARLY_INCREASE = GENERAL_DATA.getVal("AGGRESSION_YEARLY_INCREASE");
        DOW_DECREASE = GENERAL_DATA.getVal("DOW_DECREASE");
        DOW_THRESHOLD = GENERAL_DATA.getVal("DOW_THRESHOLD");
        MAX_DOW_RANDOM = GENERAL_DATA.getVal("MAX_DOW_RANDOM");
        TARGET_MAJOR_INCREASE = GENERAL_DATA.getVal("TARGET_MAJOR_INCREASE");
        TARGET_MINOR_DECREASE = GENERAL_DATA.getVal("TARGET_MINOR_DECREASE");
        TARGET_THRESHOLD = GENERAL_DATA.getVal("TARGET_THRESHOLD");
        MAX_TARGET_RANDOM = GENERAL_DATA.getVal("MAX_TARGET_RANDOM");
        AT_WAR = GENERAL_DATA.getVal("AT_WAR");
        RECONQUEST_MAJOR = GENERAL_DATA.getVal("RECONQUEST_MAJOR");
        SAME_SIDE = GENERAL_DATA.getVal("SAME_SIDE");
        OIL_BUFFER_BEFORE_DESPERATION = GENERAL_DATA.getVal("OIL_BUFFER_BEFORE_DESPERATION");
        OIL_IMPORTANCE = GENERAL_DATA.getVal("OIL_IMPORTANCE");
        MAX_CAPITAL_TO_CAPITAL_DISTANCE = GENERAL_DATA.getVal("MAX_CAPITAL_TO_CAPITAL_DISTANCE");
        DISTANCE_BONUS_PER_HEX = GENERAL_DATA.getVal("DISTANCE_BONUS_PER_HEX");
        SAME_CONTINENT = GENERAL_DATA.getVal("SAME_CONTINENT");
        CAPITAL_DEFENCE = GENERAL_DATA.getVal("CAPITAL_DEFENCE");
        DEFENCE_REACTION = GENERAL_DATA.getVal("DEFENCE_REACTION");
        CONVOY_NATION = GENERAL_DATA.getVal("CONVOY_NATION");
        SAFE_AIR_DISTANCE = GENERAL_DATA.getVal("SAFE_AIR_DISTANCE");
    }
}

