/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Global;
import game.TechAdvance;
import game.TransportationLoop;
import game.Tutorial;
import java.io.Serializable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameState
implements Serializable {
    private static final long serialVersionUID = 70L;
    Vector<TechAdvance> techAdvances = new Vector(20, 1);
    private boolean FOW = false;
    private boolean end1945 = true;
    private boolean randomResearch = true;
    private boolean oilConsumption = false;
    private int alliedBias = 4;
    private boolean natoSymbols = false;
    private boolean hexGrid = true;
    private boolean tooltips = true;
    private boolean darkOverlay = false;
    private int wintersDone = 0;
    private boolean hasStartedMoving = false;
    private boolean gameOver = false;
    private final Tutorial tutorial;
    private int zoom = Global.DEFAULT_ZOOM;
    private int turn = 0;
    private boolean scenario = false;
    private boolean AIvsAI = false;
    private int playerSide = 100;
    private int gameMode = 1000;
    private int AxisOperatesLeft = Global.AXIS_FREE_RAIL_MOVES;
    private int AlliesOperatesLeft = Global.ALLIES_FREE_RAIL_MOVES;
    private int USSROperatesLeft = Global.USSR_FREE_RAIL_MOVES;
    private int axisMorale = 0;
    private int alliesMorale = 0;
    private int axisPenaltyLevel = Global.AXIS_DOW_PENALTY;
    private int alliesPenaltyLevel = Global.ALLIES_DOW_PENALTY;
    private final TransportationLoop africaLoop = new TransportationLoop(0);
    private final TransportationLoop suezLoop = new TransportationLoop(1);
    private final int version = 106;
    private String axisPassword = "";
    private String alliesPassword = "";
    private String gameName = "";

    public GameState() {
        this.tutorial = new Tutorial();
    }

    public Vector<TechAdvance> getTechAdvancesVector() {
        return this.techAdvances;
    }

    public void resetZoom() {
        this.zoom = Global.DEFAULT_ZOOM;
    }

    public void setAxisPassword(String text) {
        this.axisPassword = text;
    }

    public void setAlliesPassword(String text) {
        this.alliesPassword = text;
    }

    public String getAxisPassword() {
        return this.axisPassword;
    }

    public String getAlliesPassword() {
        return this.alliesPassword;
    }

    public void setHexGrid(boolean on) {
        this.hexGrid = on;
    }

    public void setDarkOverlay(boolean on) {
        this.darkOverlay = on;
    }

    public void setTooltips(boolean on) {
        this.tooltips = on;
    }

    public void setHasStartedMoving(boolean on) {
        this.hasStartedMoving = on;
    }

    public boolean getHasStartedMoving() {
        return this.hasStartedMoving;
    }

    public void setgameOver(boolean on) {
        this.gameOver = on;
    }

    public boolean getGameOver() {
        return this.gameOver;
    }

    public void setWintersDone(int winters) {
        this.wintersDone = winters;
    }

    public void incWinterDone() {
        ++this.wintersDone;
    }

    public int getWintersDone() {
        return this.wintersDone;
    }

    public boolean getDarkOverlay() {
        return this.darkOverlay;
    }

    public boolean getHexGrid() {
        return this.hexGrid;
    }

    public boolean getTooltips() {
        return this.tooltips;
    }

    public Tutorial getTutorial() {
        return this.tutorial;
    }

    public void changeZoom(boolean zoomIn, boolean turnAround) {
        this.zoom = zoomIn ? (this.zoom *= 2) : (this.zoom /= 2);
        if (this.zoom > Global.MAX_ZOOM) {
            this.zoom = !turnAround ? Global.MAX_ZOOM : 1;
        }
        this.zoom = Math.max(this.zoom, 1);
    }

    public void setZoom(int z) {
        this.zoom = z;
    }

    public int getZoom() {
        return this.zoom;
    }

    public int getTurn() {
        return this.turn;
    }

    public void setTurn(int t) {
        this.turn = t;
    }

    public void setScenario(boolean b) {
        this.scenario = b;
    }

    public boolean getScenario() {
        return this.scenario;
    }

    public int whosTurn() {
        if (this.turn % 2 == 0) {
            return 100;
        }
        return 200;
    }

    public boolean getNatoSymbols() {
        return this.natoSymbols;
    }

    public boolean getFOW() {
        return this.FOW;
    }

    public boolean getEnd1945() {
        return this.end1945;
    }

    public boolean getRandomResearch() {
        return this.randomResearch;
    }

    public boolean getOilConsumption() {
        return this.oilConsumption;
    }

    public TransportationLoop getAfricaLoop() {
        return this.africaLoop;
    }

    public TransportationLoop getSuezLoop() {
        return this.suezLoop;
    }

    public void setNatoSymbols(boolean b) {
        this.natoSymbols = b;
    }

    public void setFOW(boolean b) {
        this.FOW = b;
    }

    public void setEnd1945(boolean b) {
        this.end1945 = b;
    }

    public void setRandomResearch(boolean b) {
        this.randomResearch = b;
    }

    public void setOilConsumption(boolean b) {
        this.oilConsumption = b;
    }

    public boolean getAIvsAI() {
        return this.AIvsAI;
    }

    public void setAIvsAI(boolean b) {
        this.AIvsAI = b;
    }

    public void updateSideMorale() {
        if (this.whosTurn() == 100) {
            if (this.axisMorale > 0) {
                --this.axisMorale;
            } else if (this.axisMorale < 0) {
                ++this.axisMorale;
            }
        } else if (this.alliesMorale > 0) {
            --this.alliesMorale;
        } else if (this.alliesMorale < 0) {
            ++this.alliesMorale;
        }
    }

    public int getAxisMorale() {
        return this.axisMorale;
    }

    public int getAlliesMorale() {
        return this.alliesMorale;
    }

    public void increaseAxisPenaltyLevel() {
        this.axisPenaltyLevel += Global.AXIS_DOW_PENALTY_INCREASE;
    }

    public void increaseAlliesPenaltyLevel() {
        this.alliesPenaltyLevel += Global.ALLIES_DOW_PENALTY_INCREASE;
    }

    public void changeAxisMorale(int amount) {
        this.axisMorale += amount;
    }

    public void changeAlliesMorale(int amount) {
        this.alliesMorale += amount;
    }

    public int playerSide() {
        return this.playerSide;
    }

    public int getGameMode() {
        return this.gameMode;
    }

    public String getGameName() {
        return this.gameName;
    }

    public int getAxisOperatesLeft() {
        return this.AxisOperatesLeft;
    }

    public int getAlliesOperatesLeft() {
        return this.AlliesOperatesLeft;
    }

    public int getUSSROperatesLeft() {
        return this.USSROperatesLeft;
    }

    public void incTurn() {
        ++this.turn;
    }

    public void setPlayerSide(int side) {
        this.playerSide = side;
    }

    public void setGameMode(int mode) {
        this.gameMode = mode;
    }

    public void resetOperatesLeft() {
        this.AxisOperatesLeft = Global.AXIS_FREE_RAIL_MOVES;
        this.AlliesOperatesLeft = Global.ALLIES_FREE_RAIL_MOVES;
        this.USSROperatesLeft = Global.USSR_FREE_RAIL_MOVES;
        if (this.gameMode == 1000) {
            if (this.getAlliedBias() > 4) {
                this.AlliesOperatesLeft += this.getAlliedBias() - 4;
                this.USSROperatesLeft += this.getAlliedBias() - 4;
            } else if (this.alliedBias < 4) {
                this.AxisOperatesLeft += 4 - this.alliedBias;
            }
        }
    }

    public void decOperatesLeft(int side) {
        switch (side) {
            case 100: {
                --this.AxisOperatesLeft;
                this.AxisOperatesLeft = Math.max(0, this.AxisOperatesLeft);
                break;
            }
            case 200: {
                --this.AlliesOperatesLeft;
                this.AlliesOperatesLeft = Math.max(0, this.AlliesOperatesLeft);
                break;
            }
            case 5: {
                --this.USSROperatesLeft;
                this.USSROperatesLeft = Math.max(0, this.USSROperatesLeft);
            }
        }
    }

    public void setAlliedBias(int bias) {
        this.alliedBias = bias;
    }

    public int getAlliedBias() {
        return this.alliedBias;
    }

    public int getVersion() {
        return 106;
    }

    public void setGameName(String s) {
        this.gameName = s;
    }
}

