/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.AI;
import game.Chat;
import game.ChatMessages;
import game.ClientServer;
import game.Clock;
import game.Country;
import game.CountryData;
import game.GameState;
import game.Global;
import game.MouseClick;
import game.Mover;
import game.Node;
import game.NodePriorityQueue;
import game.OddsAndPenalties;
import game.OggPlayer;
import game.OrderThread;
import game.Research;
import game.SaveGame;
import game.SoundPlayer;
import game.TerrainPenalties;
import game.TimeSystem;
import game.Tutorial;
import game.XRandAndCalc;
import game.XThread;
import game.hex.Hex;
import game.hex.LandHex;
import game.hex.LoopHex;
import game.hex.LoopHex2;
import game.hex.WaterHex;
import game.p_resource.Capital;
import game.p_resource.City;
import game.p_resource.Fortress;
import game.p_resource.Mine;
import game.p_resource.OilField;
import game.p_resource.PResource;
import game.p_resource.SeaPort;
import game.terrain.Clear;
import game.terrain.Terrain;
import game.unit.AirUnit;
import game.unit.Armour;
import game.unit.Battleship;
import game.unit.Carrier;
import game.unit.Commander;
import game.unit.Convoy;
import game.unit.Corps;
import game.unit.Destroyer;
import game.unit.Fighter;
import game.unit.Garrison;
import game.unit.GroundUnit;
import game.unit.HeavyTank;
import game.unit.MotorisedCorps;
import game.unit.NavalUnit;
import game.unit.StrategicBomber;
import game.unit.Sub;
import game.unit.TacticalBomber;
import game.unit.Transport;
import game.unit.Unit;
import gui.ChatDialog;
import gui.MainMenu;
import gui.OkDialogLarge;
import gui.TheScreen;
import gui.VictoryPanel;
import gui.WarWindow;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Port;
import javax.swing.Renderer;
import javax.swing.ToolTipManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Game
extends XThread
implements Serializable {
    private static final long serialVersionUID = 69L;
    boolean startGame = false;
    GregorianCalendar endDate = new GregorianCalendar(1945, 5, 1);
    String modName = "ww2";
    TheScreen theScreen;
    ToolTipManager tooltipManager;
    Renderer renderer;
    ClientServer clientServer;
    Chat chat;
    SoundPlayer clickSoundPlayer;
    SoundPlayer moveSoundPlayer;
    SoundPlayer moveSoundPlayer2;
    SoundPlayer attackSoundPlayer;
    SoundPlayer planeSoundPlayer;
    OggPlayer musicSoundPlayer;
    Clock clock;
    OrderThread orderThread;
    ChatMessages chatMessages;
    AI ai;
    boolean outOfMemory = false;
    boolean closeDialogsRequested = false;
    boolean active = false;
    FileWriter fw;
    BufferedWriter bw;
    PrintWriter outFile;
    private FileReader fileReader;
    private BufferedReader inFile;
    private StringTokenizer stringTokenizer;
    WarWindow warWindow;
    MainMenu mainMenu;
    VictoryPanel victoryPanel;
    Mover mover;
    GameState gameState = new GameState();
    Country[] country;
    Hex[] hex;
    TimeSystem timeSystem;
    GregorianCalendar calendar;
    int scrollingRight;
    int scrollingUp;
    boolean rightPressed;
    boolean leftPressed;
    boolean upPressed;
    boolean downPressed;
    int oneScrollRight;
    int oneScrollUp;
    int mouseScroll = 0;
    String infoDialogText = "";
    Vector<MouseClick> mouseClick = new Vector(10, 5);
    boolean busy = false;
    public boolean scrolling = false;
    boolean endTurnRequested = false;
    boolean chatDialogRequested = false;
    int nextreadyUnit = 0;
    int nowShowing = 0;
    int selectedCountry = -1;
    Hex selectedHex = null;
    Hex actionHex = null;
    Hex enemyHex = null;
    Unit tmpUnit = null;
    boolean exploitMove = false;

    public Game(TheScreen tc) {
        this.theScreen = tc;
        this.adjustToolTipManager(this.getTooltips());
        this.setTimeSystem(true, -693185120);
        this.createMap();
        this.country = new Country[37];
        this.country[0] = new Country(this, "Germany", Global.getMessage(151), Global.getMessage(152), new Color(100, 100, 100), new Color(160, 160, 160), 0, 100, 0, 800, 39, 100, true, true, new GregorianCalendar(9999, 9, 9), "");
        this.country[1] = new Country(this, "Italy", Global.getMessage(153), Global.getMessage(154), new Color(224, 173, 100), new Color(254, 203, 130), 1, 100, 0, 450, 9, 80, false, true, new GregorianCalendar(1940, 5, 1), "");
        this.country[2] = new Country(this, "UK", Global.getMessage(155), Global.getMessage(156), new Color(225, 225, 50), new Color(255, 255, 80), 2, 200, 0, 550, 45, 70, true, true, new GregorianCalendar(9999, 9, 9), "");
        this.country[3] = new Country(this, "France", Global.getMessage(157), Global.getMessage(158), new Color(85, 185, 255), new Color(115, 215, 255), 3, 200, 0, 600, 15, 70, true, true, new GregorianCalendar(9999, 9, 9), "");
        this.country[4] = new Country(this, "USA", Global.getMessage(159), Global.getMessage(160), new Color(10, 150, 10), new Color(30, 180, 40), 4, 200, 20, 550, 50, 20, false, true, new GregorianCalendar(1941, 11, 1), Global.getMessage(487));
        this.country[5] = new Country(this, "USSR", Global.getMessage(161), Global.getMessage(162), new Color(255, 90, 0), new Color(255, 150, 110), 5, 200, 40, 1500, 100, 0, false, true, new GregorianCalendar(1941, 9, 5), "");
        this.country[6] = new Country(this, "Holland", Global.getMessage(163), Global.getMessage(164), Global.NEUTRAL_COLOR, new Color(255, 150, 110), 6, 300, 0, 50, 1, 0, false, false, new GregorianCalendar(9999, 9, 9), "");
        this.country[7] = new Country(this, "Belgium", Global.getMessage(165), Global.getMessage(166), Global.NEUTRAL_COLOR, new Color(255, 150, 110), 7, 300, 0, 50, 1, 0, false, false, new GregorianCalendar(9999, 9, 9), "");
        this.country[8] = new Country(this, "Denmark", Global.getMessage(167), Global.getMessage(168), Global.NEUTRAL_COLOR, new Color(255, 150, 110), 8, 300, 0, 50, 1, 0, false, false, new GregorianCalendar(9999, 9, 9), "");
        this.country[9] = new Country(this, "Norway", Global.getMessage(169), Global.getMessage(170), Global.NEUTRAL_COLOR, new Color(255, 150, 110), 9, 300, 0, 50, 1, 0, false, false, new GregorianCalendar(9999, 9, 9), "");
        this.country[10] = new Country(this, "Sweden", Global.getMessage(171), Global.getMessage(172), Global.NEUTRAL_COLOR, new Color(255, 150, 110), 10, 300, 0, 50, 1, 0, false, false, new GregorianCalendar(9999, 9, 9), "");
        this.country[11] = new Country(this, "Finland", Global.getMessage(173), Global.getMessage(174), Global.NEUTRAL_COLOR, new Color(255, 150, 110), 11, 100, 0, 50, 1, 0, false, false, new GregorianCalendar(1941, 5, 22), Global.getMessage(483));
        this.country[12] = new Country(this, "Hungary", Global.getMessage(175), Global.getMessage(176), Global.NEUTRAL_COLOR, new Color(255, 150, 110), 12, 100, 0, 50, 1, 0, false, false, new GregorianCalendar(1940, 9, 10), Global.getMessage(484));
        this.country[13] = new Country(this, "Romania", Global.getMessage(177), Global.getMessage(178), Global.NEUTRAL_COLOR, new Color(255, 150, 110), 13, 100, 0, 50, 1, 0, false, false, new GregorianCalendar(1940, 10, 13), Global.getMessage(485));
        this.country[14] = new Country(this, "Bulgaria", Global.getMessage(179), Global.getMessage(180), Global.NEUTRAL_COLOR, new Color(255, 150, 110), 14, 100, 0, 50, 1, 0, false, false, new GregorianCalendar(1941, 1, 21), Global.getMessage(486));
        this.country[15] = new Country(this, "Yugoslavia", Global.getMessage(181), Global.getMessage(182), Global.NEUTRAL_COLOR, new Color(255, 150, 110), 15, 300, 0, 50, 1, 0, false, false, new GregorianCalendar(9999, 9, 9), "");
        this.country[16] = new Country(this, "Greece", Global.getMessage(183), Global.getMessage(184), Global.NEUTRAL_COLOR, new Color(255, 150, 110), 16, 300, 0, 50, 1, 0, false, false, new GregorianCalendar(9999, 9, 9), "");
        this.country[17] = new Country(this, "Turkey", Global.getMessage(185), Global.getMessage(186), Global.NEUTRAL_COLOR, new Color(255, 150, 110), 17, 300, 0, 50, 1, 0, false, false, new GregorianCalendar(9999, 9, 9), "");
        this.country[18] = new Country(this, "Persia", Global.getMessage(187), Global.getMessage(188), Global.NEUTRAL_COLOR, new Color(255, 150, 110), 18, 200, 0, 50, 1, 0, false, false, new GregorianCalendar(9999, 9, 9), "");
        this.country[19] = new Country(this, "Iraq", Global.getMessage(189), Global.getMessage(190), Global.NEUTRAL_COLOR, new Color(255, 150, 110), 19, 200, 0, 50, 1, 0, false, false, new GregorianCalendar(9999, 9, 9), "");
        this.country[20] = new Country(this, "Spain", Global.getMessage(191), Global.getMessage(192), Global.NEUTRAL_COLOR, new Color(255, 150, 110), 20, 300, 0, 50, 1, 0, false, false, new GregorianCalendar(9999, 9, 9), "");
        this.country[21] = new Country(this, "Portugal", Global.getMessage(193), Global.getMessage(194), Global.NEUTRAL_COLOR, new Color(255, 150, 110), 21, 300, 0, 50, 1, 0, false, false, new GregorianCalendar(9999, 9, 9), "");
        this.country[22] = new Country(this, "Ireland", Global.getMessage(195), Global.getMessage(196), Global.NEUTRAL_COLOR, new Color(255, 150, 110), 22, 200, 0, 50, 1, 0, false, false, new GregorianCalendar(9999, 9, 9), "");
        this.country[23] = new Country(this, "Poland", Global.getMessage(197), Global.getMessage(198), Global.NEUTRAL_COLOR, new Color(255, 150, 110), 23, 200, 0, 50, 1, 0, false, false, new GregorianCalendar(1939, 1, 1), Global.getMessage(482));
        this.country[24] = new Country(this, "Algeria", Global.getMessage(199), Global.getMessage(200), Global.NEUTRAL_COLOR, new Color(255, 150, 110), 24, 200, 0, 50, 1, 0, false, false, new GregorianCalendar(9999, 9, 9), "");
        this.country[25] = new Country(this, "Switzerland", Global.getMessage(201), Global.getMessage(202), Global.NEUTRAL_COLOR, new Color(255, 150, 110), 25, 100, 0, 50, 1, 0, false, false, new GregorianCalendar(9999, 9, 9), "");
        this.country[27] = new Country(this, "Estonia", Global.getMessage(203), Global.getMessage(204), Global.NEUTRAL_COLOR, new Color(255, 150, 110), 27, 300, 0, 50, 1, 0, false, false, new GregorianCalendar(9999, 9, 9), "");
        this.country[28] = new Country(this, "Latvia", Global.getMessage(205), Global.getMessage(206), Global.NEUTRAL_COLOR, new Color(255, 150, 110), 28, 300, 0, 50, 1, 0, false, false, new GregorianCalendar(9999, 9, 9), "");
        this.country[29] = new Country(this, "Lithuania", Global.getMessage(207), Global.getMessage(208), Global.NEUTRAL_COLOR, new Color(255, 150, 110), 29, 300, 0, 50, 1, 0, false, false, new GregorianCalendar(9999, 9, 9), "");
        this.country[30] = new Country(this, "Libya", Global.getMessage(209), Global.getMessage(210), Global.NEUTRAL_COLOR, new Color(255, 150, 110), 30, 300, 0, 50, 1, 0, false, false, new GregorianCalendar(9999, 9, 9), "");
        this.country[31] = new Country(this, "Egypt", Global.getMessage(211), Global.getMessage(212), Global.NEUTRAL_COLOR, new Color(255, 150, 110), 32, 300, 0, 50, 1, 0, false, false, new GregorianCalendar(9999, 9, 9), "");
        this.country[32] = new Country(this, "Syria", Global.getMessage(213), Global.getMessage(214), Global.NEUTRAL_COLOR, new Color(255, 150, 110), 31, 300, 0, 50, 1, 0, false, false, new GregorianCalendar(9999, 9, 9), "");
        this.country[33] = new Country(this, "Canda", Global.getMessage(215), Global.getMessage(216), Global.NEUTRAL_COLOR, new Color(255, 150, 110), 33, 300, 0, 50, 1, 0, false, false, new GregorianCalendar(9999, 9, 9), "");
        this.country[34] = new Country(this, "Croatia", Global.getMessage(217), Global.getMessage(218), Global.NEUTRAL_COLOR, new Color(255, 150, 110), 34, 300, 0, 50, 1, 0, false, false, new GregorianCalendar(9999, 9, 9), "");
        this.country[35] = new Country(this, "Ukraine", Global.getMessage(219), Global.getMessage(220), Global.NEUTRAL_COLOR, new Color(255, 150, 110), 35, 300, 0, 50, 1, 0, false, false, new GregorianCalendar(9999, 9, 9), "");
        this.country[36] = new Country(this, "SpareCountry", Global.getMessage(221), Global.getMessage(222), Global.NEUTRAL_COLOR, new Color(255, 150, 110), 36, 300, 0, 50, 1, 0, false, false, new GregorianCalendar(9999, 9, 9), "");
        this.country[26] = new Country(this, "NoCountry", Global.getMessage(97), Global.getMessage(97), new Color(0, 0, 0), new Color(255, 255, 255), 26, 300, 0, 50, 5, 0, false, false, new GregorianCalendar(9999, 9, 9), "");
        this.country[26].setAsNonCountry();
        this.clickSoundPlayer = new SoundPlayer();
        this.clickSoundPlayer.setMaxSounds(2);
        this.clickSoundPlayer.start();
        this.moveSoundPlayer = new SoundPlayer();
        this.moveSoundPlayer.start();
        this.moveSoundPlayer2 = new SoundPlayer();
        this.moveSoundPlayer2.start();
        this.attackSoundPlayer = new SoundPlayer();
        this.attackSoundPlayer.setMaxSounds(2);
        this.attackSoundPlayer.start();
        this.planeSoundPlayer = new SoundPlayer();
        this.planeSoundPlayer.setMaxSounds(2);
        this.planeSoundPlayer.start();
        this.musicSoundPlayer = new OggPlayer(1, true);
        this.musicSoundPlayer.start();
        this.clock = new Clock(this);
        this.clock.start();
        this.ai = new AI(this);
        this.ai.start();
        this.saveGame(true, false, "", "");
        this.createScenarios();
        this.victoryPanel = new VictoryPanel(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getBackgroundPath()) + "fe_background.png"), this);
        this.start();
    }

    public void networkInit() {
        if (this.clientServer == null) {
            this.clientServer = new ClientServer(true, "0.0.0.0", this);
            this.clientServer.start();
        }
        if (this.chat == null) {
            this.chat = new Chat(true, "0.0.0.0", this);
            this.chat.start();
        }
        if (!this.orderThread.isAlive()) {
            this.orderThread.start();
        }
    }

    public void closeDialogsRequest() {
        this.closeDialogsRequested = true;
    }

    public boolean getSoundEffect() {
        return this.clickSoundPlayer.getRunning();
    }

    public void setSoundEffectOption(boolean b) {
        this.clickSoundPlayer.setRunning(b);
        this.moveSoundPlayer.setRunning(b);
        this.moveSoundPlayer2.setRunning(b);
        this.attackSoundPlayer.setRunning(b);
        this.planeSoundPlayer.setRunning(b);
    }

    public void setServer(boolean b) {
        this.networkInit();
        this.clientServer.setServer(b);
        this.chat.setServer(b);
    }

    public void setConnectToIP(String s) {
        this.clientServer.setConnectToIP(s);
        this.chat.setConnectToIP(s);
    }

    public void setConnectPhase(boolean b) {
        if (this.clientServer != null) {
            this.clientServer.setConnectPhase(b);
        }
        if (this.chat != null) {
            this.chat.setConnectPhase(b);
        }
    }

    public void setMusicOption(boolean b) {
        this.musicSoundPlayer.setMusicOption(b);
    }

    public boolean getMusicOption() {
        return this.musicSoundPlayer.getMusicOption();
    }

    public void adjustToolTipManager(boolean enabled) {
        ToolTipManager.sharedInstance().setEnabled(enabled);
        ToolTipManager.sharedInstance().setInitialDelay(300);
        ToolTipManager.sharedInstance().setDismissDelay(1200);
        ToolTipManager.sharedInstance().setReshowDelay(0);
    }

    public int oilConsumptionMovingAllUnits(int faction) {
        int oil = 0;
        int i = 0;
        while (i < this.country.length) {
            if (this.country[i].getFaction() == faction && this.country[i].getAtWar()) {
                Vector<Unit> v = this.country[i].getUnits();
                int j = 0;
                while (j < v.size()) {
                    oil += v.get(j).getOilConsumption();
                    ++j;
                }
            }
            ++i;
        }
        return oil;
    }

    public void repaintAllDialogs() {
        this.warWindow.repaintDialogs();
        this.mainMenu.repaintDialogs();
    }

    public ClientServer getClientServer() {
        return this.clientServer;
    }

    public GameState getGameState() {
        return this.gameState;
    }

    public TheScreen getTheScreen() {
        return this.theScreen;
    }

    public MainMenu getMainMenu() {
        return this.mainMenu;
    }

    public int getMouseScroll() {
        return this.mouseScroll;
    }

    public void setMouseScroll(int scroll) {
        this.mouseScroll = scroll;
    }

    public void resetMouseScroll() {
        this.mouseScroll = 0;
    }

    public void requestShowInfoDialog(String text) {
        this.infoDialogText = text;
    }

    public void requestStartGame() {
        this.startGame = true;
    }

    public GregorianCalendar getCalendar() {
        return this.calendar;
    }

    public int getNoTimeLimit() {
        int ret = 0;
        if (this.timeSystem.getNoTimeLimit()) {
            ret = 1;
        }
        return ret;
    }

    public void setAlliedBias(int bias) {
        this.gameState.setAlliedBias(bias);
    }

    public void reset() {
        this.ai.setActive(false);
        if (this.getGameMode() == 1000) {
            Game.delay(6000L);
        } else {
            Game.delay(100L);
        }
        this.active = false;
        this.loadGame(1000, true, false, "", "");
        if (this.calendar == null) {
            this.loadGame(1000, false, true, Global.getScenarioPath(), "1939.data");
        }
        this.mainMenu.reset();
        this.warWindow.reset();
        this.orderThread.reset();
        this.setConnectPhase(false);
        this.resetScrolling();
        System.gc();
    }

    public int getScrollingRight() {
        return this.scrollingRight;
    }

    public int getScrollingUp() {
        return this.scrollingUp;
    }

    public Country[] getCountries() {
        return this.country;
    }

    public OrderThread getOrderThread() {
        return this.orderThread;
    }

    public void setOrderThread(OrderThread o) {
        this.orderThread = o;
    }

    public void setEndTurnRequested(boolean b) {
        this.endTurnRequested = b;
    }

    public void setChatDialogRequested(boolean b) {
        this.chatDialogRequested = b;
    }

    public boolean getFullScreenMode() {
        return Global.isFullScreen(this.theScreen);
    }

    public boolean getBusy() {
        return this.busy;
    }

    public void setBusy(boolean b) {
        this.busy = b;
    }

    public void setFOW(boolean b) {
        this.gameState.setFOW(b);
    }

    public void setHexGrid(boolean b) {
        this.gameState.setHexGrid(b);
    }

    public void setNatoSymbols(boolean b) {
        this.gameState.setNatoSymbols(b);
    }

    public boolean getNatoSymbols() {
        return this.gameState.getNatoSymbols();
    }

    public void setTooltips(boolean b) {
        this.gameState.setTooltips(b);
    }

    public void setDarkOverlay(boolean b) {
        this.gameState.setDarkOverlay(b);
    }

    public boolean getDarkOverlay() {
        return this.gameState.getDarkOverlay();
    }

    public boolean getHexGrid() {
        return this.gameState.getHexGrid();
    }

    public Clock getClock() {
        return this.clock;
    }

    public int getGameMode() {
        return this.gameState.getGameMode();
    }

    public boolean canSeeUnit(Unit u, int viewingSide) {
        if (this.gameState.getGameOver()) {
            return true;
        }
        boolean ret = false;
        int side = u.getCountry().getSide();
        Hex h = u.getOnHex();
        ret = h == null ? false : (side == viewingSide ? true : (u.isInvisible() ? false : (!u.getFOWed() ? true : (side == 100 && !h.getFOW(200) ? true : side == 200 && !h.getFOW(100)))));
        return ret;
    }

    public boolean canSeeHex(int hexIndex, int viewingSide) {
        if (this.gameState.getGameOver()) {
            return true;
        }
        Hex h = this.hex[hexIndex];
        boolean ret = false;
        if (viewingSide == 100 && !h.getFOW(100)) {
            ret = true;
        } else if (viewingSide == 200 && !h.getFOW(200)) {
            ret = true;
        }
        return ret;
    }

    public int viewingSide() {
        if (this.gameState.getAIvsAI()) {
            return this.opponentSide();
        }
        return this.playerSide();
    }

    public int getZoom() {
        return this.gameState.getZoom();
    }

    public void unfowCountry(int country) {
        if (this.gameState.getFOW()) {
            int j = 0;
            while (j < this.hex.length) {
                if (this.hex[j].getOwningCountry() == country && this.hex[j] instanceof LandHex && this.notNeutralHex(this.hex[j]) && this.country[this.hex[j].getOwningCountry()].getAtWar()) {
                    this.spotAroundHex(j, 1, 1, 0);
                }
                ++j;
            }
        }
    }

    public void partialFOWprocedure(int aroundHex) {
        int maxSpottingRange = 13;
        if (!this.gameState.getFOW()) {
            int i = 0;
            while (i < this.hex.length) {
                this.hex[i].setAxisFOW(false);
                this.hex[i].setAlliesFOW(false);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.hex.length) {
                if (!(this.hex[i].getUnit() != null && this.hex[i].getUnit().getSide() == this.whosTurn() && this.hex[i].getUnit().getHasMoved() || this.shortestPath(aroundHex, i) > 13)) {
                    this.hex[i].setAxisFOW(true);
                    this.hex[i].setAlliesFOW(true);
                }
                ++i;
            }
            int j = 0;
            while (j < this.hex.length) {
                if (this.shortestPath(aroundHex, j) <= 26) {
                    Unit u = this.hex[j].getUnit();
                    if (u != null && u.getCountry().getAtWar()) {
                        this.spotAroundUnit(u);
                    } else if (this.hex[j] instanceof LandHex && this.notNeutralHex(this.hex[j]) && this.country[this.hex[j].getOwningCountry()].getAtWar()) {
                        this.spotAroundHex(j, 1, 1, 0);
                    }
                }
                ++j;
            }
        }
    }

    public void fowProcedure() {
        if (!this.gameState.getFOW()) {
            int i = 0;
            while (i < this.hex.length) {
                this.hex[i].setAxisFOW(false);
                this.hex[i].setAlliesFOW(false);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.hex.length) {
                if (this.hex[i].getUnit() == null || this.hex[i].getUnit().getSide() != this.whosTurn() || !this.hex[i].getUnit().getHasMoved()) {
                    this.hex[i].setAxisFOW(true);
                    this.hex[i].setAlliesFOW(true);
                }
                ++i;
            }
            int j = 0;
            while (j < this.hex.length) {
                Unit u = this.hex[j].getUnit();
                if (u != null && u.getCountry().getAtWar()) {
                    this.spotAroundUnit(u);
                } else if (this.hex[j] instanceof LandHex && this.notNeutralHex(this.hex[j]) && this.country[this.hex[j].getOwningCountry()].getAtWar()) {
                    this.spotAroundHex(j, 1, 1, 0);
                }
                ++j;
            }
        }
    }

    public void spotAroundUnit(Unit u) {
        this.resettmpMovesleft();
        Hex baseCaseHex = u.getOnHex();
        if (baseCaseHex != null) {
            boolean axisUnit = false;
            if (u.getCountry().getSide() == 100) {
                axisUnit = true;
            }
            if (axisUnit) {
                baseCaseHex.setAxisFOW(false);
            } else {
                baseCaseHex.setAlliesFOW(false);
            }
            int landSpotting = u.getLandSpotting();
            int seaSpotting = u.getSeaSpotting();
            this.recursiveAirMoveHighlight2(this.getHexIndex(baseCaseHex), Math.max(u.getLandSpotting(), u.getSeaSpotting()), u.getCountryIndex(), u, false, true);
            int i = 0;
            while (i < this.hex.length) {
                if (this.hex[i].getHighlighted()) {
                    int shortest = this.shortestPath(this.getHexIndex(baseCaseHex), i);
                    if (landSpotting >= shortest && this.hex[i].isLandHex()) {
                        if (axisUnit) {
                            this.hex[i].setAxisFOW(false);
                        } else {
                            this.hex[i].setAlliesFOW(false);
                        }
                    } else if (seaSpotting >= shortest && this.hex[i].isWaterHex()) {
                        if (axisUnit) {
                            this.hex[i].setAxisFOW(false);
                        } else {
                            this.hex[i].setAlliesFOW(false);
                        }
                    }
                }
                ++i;
            }
            this.deHighlightdeTargetAll();
        }
    }

    public void spotAroundHex(int hex, int movesLeft, int landSpotting, int seaSpotting) {
        this.resettmpMovesleft();
        Hex baseCaseHex = this.hex[hex];
        if (baseCaseHex != null) {
            Country c = this.country[this.hex[hex].getOwningCountry()];
            boolean axisUnit = false;
            if (c.getSide() == 100) {
                axisUnit = true;
            }
            if (axisUnit) {
                baseCaseHex.setAxisFOW(false);
            } else {
                baseCaseHex.setAlliesFOW(false);
            }
            this.recursiveAirMoveHighlight2(this.getHexIndex(baseCaseHex), Math.max(landSpotting, seaSpotting), c.getCountryIndex(), null, false, true);
            int i = 0;
            while (i < this.hex.length) {
                if (this.hex[i].getHighlighted()) {
                    int shortest = this.shortestPath(this.getHexIndex(baseCaseHex), i);
                    if (landSpotting >= shortest && this.hex[i].isLandHex()) {
                        if (axisUnit) {
                            this.hex[i].setAxisFOW(false);
                        } else {
                            this.hex[i].setAlliesFOW(false);
                        }
                    } else if (seaSpotting >= shortest && !this.hex[i].isLandHex()) {
                        if (axisUnit) {
                            this.hex[i].setAxisFOW(false);
                        } else {
                            this.hex[i].setAlliesFOW(false);
                        }
                    }
                }
                ++i;
            }
            this.deHighlightdeTargetAll();
        }
    }

    public boolean notNeutralHex(Hex h) {
        if (h instanceof LandHex) {
            int side = this.country[h.getOwningCountry()].getSide();
            if (side == 100) {
                return true;
            }
            if (side == 200) {
                return true;
            }
        }
        return false;
    }

    public Rectangle areaOnScreen() {
        int hex = this.mousePointedHex(0, 0, true);
        int col1 = this.getColumn(hex);
        int row1 = this.getRow(hex);
        hex = this.mousePointedHex(this.warWindow.getMapCanvas().getWidth(), 0, true);
        int col2 = hex == -1 ? 149 : this.getColumn(hex);
        hex = this.mousePointedHex(0, this.warWindow.getMapCanvas().getHeight(), true);
        int row2 = hex == -1 ? 71 : this.getRow(hex);
        return new Rectangle(col1, row1, col2 - col1 + 1, row2 - row1);
    }

    public static double angle(Point p1, Point p2) {
        double ang = Math.atan(p2.x / p2.y) - Math.atan(p1.x / p1.y);
        return 180.0 * (ang / Math.PI);
    }

    public boolean fitOnSameScreen(int hex1, int hex2) {
        int columnDiff = Math.abs(this.getColumn(hex2) - this.getColumn(hex1));
        int rowDiff = Math.abs(this.getRow(hex2) - this.getRow(hex1));
        return columnDiff <= 68 / this.getZoom() && rowDiff <= 32 / this.getZoom();
    }

    public void centerOnBattleIfNeeded(int hex1, int hex2) {
        if (!(!this.fitOnSameScreen(hex1, hex2) || this.onScreen(hex1) && this.onScreen(hex2))) {
            int newCol = Math.abs((this.getColumn(hex2) + this.getColumn(hex1)) / 2);
            int newRow = Math.abs((this.getRow(hex2) + this.getRow(hex1)) / 2);
            this.warWindow.getMapCanvas().setMapViewPosition(this.hex[this.getHex(newCol, newRow)], false);
            this.pauseIfNeeded(200L, false);
        }
    }

    public boolean onScreen(int hex1) {
        int hex = this.mousePointedHex(0, 0, true);
        int col1 = this.getColumn(hex);
        int row1 = this.getRow(hex);
        hex = this.mousePointedHex(this.warWindow.getMapCanvas().getWidth(), 0, true);
        int col2 = hex == -1 ? 149 : this.getColumn(hex);
        hex = this.mousePointedHex(0, this.warWindow.getMapCanvas().getHeight(), true);
        int row2 = hex == -1 ? 71 : this.getRow(hex);
        return this.getColumn(hex1) >= col1 && this.getColumn(hex1) <= col2 && this.getRow(hex1) >= row1 && this.getRow(hex1) <= row2;
    }

    public ChatMessages getChatMessages() {
        return this.chatMessages;
    }

    public boolean allowInput() {
        return !this.scrolling && this.seingMap() && !this.busy && this.whosTurn() == this.playerSide() && !this.warWindow.getMapCanvas().getAutomaticMoving() && !this.getWarWindow().isShowingDialog();
    }

    public boolean seingMap() {
        return this.nowShowing == 0 || this.nowShowing == 2 || this.nowShowing == 5 || this.nowShowing == 6 || this.nowShowing == 7 || this.nowShowing == 8;
    }

    public void nextReadyUnit(boolean increase) {
        if (this.whosTurn() == this.gameState.playerSide() && this.seingMap() && !this.warWindow.getMapCanvas().getAutomaticMoving() && !this.busy) {
            Vector<Unit> tmp = new Vector<Unit>(50, 30);
            int side = this.whosTurn();
            int i = 0;
            while (i < this.country.length) {
                if (this.country[i].getSide() == side && this.country[i].getAtWar()) {
                    Vector<Unit> coun = this.country[i].units;
                    int j = 0;
                    while (j < coun.size()) {
                        Unit u = coun.get(j);
                        if (!(u.getHasMoved() || u.getOnHex() == null || u.getSentry() || u instanceof GroundUnit && u.getOnHex() instanceof WaterHex)) {
                            tmp.add(coun.get(j));
                        }
                        ++j;
                    }
                }
                ++i;
            }
            if (tmp.size() != 0) {
                this.nextreadyUnit = increase ? ++this.nextreadyUnit : --this.nextreadyUnit;
                if (this.nextreadyUnit >= tmp.size()) {
                    this.nextreadyUnit = 0;
                } else if (this.nextreadyUnit == -1) {
                    this.nextreadyUnit = tmp.size() - 1;
                }
                Hex h = ((Unit)tmp.get(this.nextreadyUnit)).getOnHex();
                this.warWindow.getMapCanvas().setMapViewPosition(h, false);
                this.mouseClickedPixel(-1, -1, h, true);
            }
        }
    }

    public int numCities(int country) {
        int num = 0;
        int i = 0;
        while (i < this.hex.length) {
            PResource pr = this.hex[i].getPResource();
            if (this.hex[i].getOwningCountry() == country && pr != null) {
                if (pr instanceof Capital) {
                    ++num;
                } else if (pr instanceof City) {
                    ++num;
                }
            }
            ++i;
        }
        return num;
    }

    public int numMines(int country) {
        int num = 0;
        int i = 0;
        while (i < this.hex.length) {
            PResource pr = this.hex[i].getPResource();
            if (this.hex[i].getOwningCountry() == country && pr != null && pr instanceof Mine) {
                ++num;
            }
            ++i;
        }
        return num;
    }

    public int numOilFields(int country) {
        int num = 0;
        int i = 0;
        while (i < this.hex.length) {
            PResource pr = this.hex[i].getPResource();
            if (this.hex[i].getOwningCountry() == country && pr != null && pr instanceof OilField) {
                ++num;
            }
            ++i;
        }
        return num;
    }

    public int numFortresses(int country) {
        int num = 0;
        int i = 0;
        while (i < this.hex.length) {
            PResource pr = this.hex[i].getPResource();
            if (this.hex[i].getOwningCountry() == country && pr != null && pr instanceof Fortress) {
                ++num;
            }
            ++i;
        }
        return num;
    }

    public int numSeaPorts(int country) {
        int num = 0;
        int i = 0;
        while (i < this.hex.length) {
            PResource pr = this.hex[i].getPResource();
            if (this.hex[i].getOwningCountry() == country && pr != null && pr instanceof Port) {
                ++num;
            }
            ++i;
        }
        return num;
    }

    public void selectTab(int tab) {
        this.warWindow.selectTab(tab);
    }

    public void selectButton(int button) {
        this.warWindow.selectButton(button);
    }

    public void resetLastShowing() {
        int oldShowing = this.nowShowing;
        switch (oldShowing) {
            case 0: {
                this.resetMapDependancy();
                break;
            }
            case 1: {
                this.warWindow.closePurchasePanel();
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.warWindow.closeResearchPanel();
                break;
            }
            case 4: {
                this.warWindow.closeReportPanel();
                break;
            }
            case 5: {
                break;
            }
        }
    }

    public void setNowShowing(int i) {
        this.nowShowing = i;
        if (this.nowShowing == 2) {
            this.warWindow.setCursor(2);
        } else if (this.nowShowing == 7) {
            this.warWindow.setCursor(7);
        } else if (this.nowShowing == 8) {
            this.warWindow.setCursor(8);
        } else if (this.whosTurn() == this.playerSide()) {
            this.warWindow.setCursor(99);
        }
        this.deHighlightdeTargetAll();
        this.warWindow.oneSlowFrame();
    }

    public boolean friendlyReadyUnit(Unit u) {
        return u.getCountry().getSide() == this.playerSide() && !u.getHasMoved();
    }

    public int getNowShowing() {
        return this.nowShowing;
    }

    public boolean getFOW() {
        return this.gameState.getFOW();
    }

    public boolean getTooltips() {
        return this.gameState.getTooltips();
    }

    public void resetMapDependancy() {
        this.deHighlightdeTargetAll();
        this.selectedHex = null;
        this.actionHex = null;
        this.enemyHex = null;
    }

    public void setTimeSystem(boolean noTimeLimit, int timePerTurn) {
        this.timeSystem = new TimeSystem(noTimeLimit, 4 * timePerTurn, 4 * timePerTurn, timePerTurn);
    }

    public void switchHexGrid() {
        this.warWindow.getMapCanvas().switchHexGrid();
    }

    public AI getAI() {
        return this.ai;
    }

    public Unit createUnit(int country, int unit, int commander, int strength) {
        Unit u = null;
        switch (unit) {
            case 0: {
                u = this.country[country].getCommander(commander);
                break;
            }
            case 1: {
                u = new Garrison(this.country[country]);
                break;
            }
            case 2: {
                u = new Corps(this.country[country]);
                break;
            }
            case 3: {
                u = new MotorisedCorps(this.country[country]);
                break;
            }
            case 4: {
                u = new Armour(this.country[country]);
                break;
            }
            case 5: {
                u = new HeavyTank(this.country[country]);
                break;
            }
            case 6: {
                u = new Fighter(this.country[country]);
                break;
            }
            case 7: {
                u = new TacticalBomber(this.country[country]);
                break;
            }
            case 8: {
                u = new StrategicBomber(this.country[country]);
                break;
            }
            case 9: {
                u = new Sub(this.country[country]);
                break;
            }
            case 10: {
                u = new Destroyer(this.country[country]);
                break;
            }
            case 11: {
                u = new Battleship(this.country[country]);
                break;
            }
            case 12: {
                u = new Carrier(this.country[country]);
                break;
            }
            case 99: {
                u = new Convoy(this.country[country], strength);
            }
        }
        return u;
    }

    public static int verticalCentering(int fontSize) {
        return fontSize / 4;
    }

    public static int horizontalCentering(int fontSize, int num) {
        return Game.horizontalCentering(fontSize, Integer.toString(num));
    }

    public static int horizontalCentering(int fontSize, String s) {
        int ret = (int)(-0.2 * (double)(s.length() * fontSize));
        return ret;
    }

    public Hex getActionHex() {
        return this.actionHex;
    }

    public void setActionHex(Hex h) {
        this.actionHex = h;
    }

    public Hex getEnemyActionHex() {
        return this.enemyHex;
    }

    public static String minutesAndSeconds(long millis) {
        long tempSum = millis;
        String stringTime = "" + tempSum / 60000L;
        stringTime = String.valueOf(stringTime) + ":";
        if ((tempSum %= 60000L) / 1000L < 10L) {
            stringTime = String.valueOf(stringTime) + "0";
        }
        stringTime = String.valueOf(stringTime) + tempSum / 1000L;
        return stringTime;
    }

    public void newSecond(long currentTime) {
        boolean noTimeLeft = false;
        if (this.whosTurn() == 100) {
            this.timeSystem.newSecond(true);
        } else {
            this.timeSystem.newSecond(false);
        }
        if (this.getGameMode() == 3000) {
            if (this.timeSystem.timeIsUp(this.gameState.playerSide())) {
                noTimeLeft = true;
            }
        } else if (this.timeSystem.timeIsUp(this.whosTurn())) {
            noTimeLeft = true;
        }
        if (!this.timeSystem.getNoTimeLimit() && !this.busy) {
            this.showTimeLeft();
        }
        if (noTimeLeft && this.whosTurn() == this.playerSide()) {
            this.setEndTurnRequested(true);
        }
    }

    public void showTimeLeft() {
        this.warWindow.showTimeLeft(Game.minutesAndSeconds(this.timeSystem.getAxisTimeLeft()), Game.minutesAndSeconds(this.timeSystem.getAlliesTimeLeft()));
    }

    public void setClientServer(ClientServer cs) {
        this.clientServer = cs;
    }

    public void playSoundSimultaneously(String file, int player, boolean interrupt) {
        switch (player) {
            case 0: {
                this.clickSoundPlayer.addSound(new File(file));
                break;
            }
            case 1: {
                long moveSoundTime = this.moveSoundPlayer.getLastSoundStartTime();
                long moveSoundTime2 = this.moveSoundPlayer2.getLastSoundStartTime();
                int choice = 1;
                choice = moveSoundTime > moveSoundTime2 ? 1 : 2;
                long currentTime = System.currentTimeMillis();
                if (choice == 1 && currentTime - moveSoundTime > Global.SOUND_INTERRUPT) {
                    choice = 2;
                } else if (choice == 2 && currentTime - moveSoundTime2 > Global.SOUND_INTERRUPT) {
                    choice = 1;
                }
                if (choice == 1) {
                    this.moveSoundPlayer.addSound(new File(file));
                    break;
                }
                this.moveSoundPlayer2.addSound(new File(file));
                break;
            }
            case 2: {
                this.attackSoundPlayer.addSound(new File(file));
                break;
            }
            case 3: {
                this.musicSoundPlayer.addSound(new File(file));
            }
        }
    }

    public void sendDataToOpponent(String data) {
        String data2 = String.valueOf(this.orderThread.getOutgoingMessageID()) + " " + data;
        this.orderThread.incOutgoingMessageID();
        if (this.getGameMode() == 3000) {
            try {
                this.clientServer.getooStream().flush();
                this.clientServer.getooStream().writeObject(data2);
                this.clientServer.getooStream().flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void sendChatToOpponent(String data) {
        String data2 = String.valueOf(this.orderThread.getOutgoingMessageID()) + " " + data;
        this.orderThread.incOutgoingMessageID();
        if (this.getGameMode() == 3000) {
            try {
                this.chat.getooStream().flush();
                this.chat.getooStream().writeObject(data2);
                this.chat.getooStream().flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void sendSaveGameToOpponent() {
        if (this.getGameMode() == 3000) {
            try {
                SaveGame saveGame = new SaveGame(this.gameState, this.country, this.hex, this.calendar, this.timeSystem);
                this.clientServer.getooStream().flush();
                this.clientServer.getooStream().writeObject(saveGame);
                this.clientServer.getooStream().flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void playAudioFileAndWait(String fileName) {
        try {
            File soundFile = new File(fileName);
            AudioFileFormat format = AudioSystem.getAudioFileFormat(soundFile);
            long len = (long)((double)format.getFrameLength() * 1000.0 / (double)format.getFormat().getFrameRate());
            System.out.println("playAndWait for " + len + "ms");
            this.planeSoundPlayer.addSound(soundFile);
            Game.delay(len - 70L);
        }
        catch (Exception e) {
            System.out.println("Problem with file " + fileName + ":");
            e.printStackTrace();
        }
    }

    public void createChatMessage(String text, boolean thisPlayer) {
        this.warWindow.createChatMessage(text, thisPlayer);
    }

    public int playerSide() {
        return this.gameState.playerSide();
    }

    public int opponentSide() {
        if (this.playerSide() == 100) {
            return 200;
        }
        return 100;
    }

    public int oppositeSide(int friendly) {
        if (friendly == 100) {
            return 200;
        }
        if (friendly == 200) {
            return 100;
        }
        return -1;
    }

    public void setWarWindow(WarWindow w) {
        this.warWindow = w;
        this.mover = new Mover(w);
        this.chatMessages = new ChatMessages(this.warWindow);
        this.chatMessages.start();
    }

    public void setMainMenu(MainMenu s) {
        this.mainMenu = s;
    }

    public void setSelectedCountry(int t) {
        this.selectedCountry = t;
    }

    public int getOperatesLeft(int faction) {
        int val = faction == 100 ? this.gameState.getAxisOperatesLeft() : (faction == 200 ? this.gameState.getAlliesOperatesLeft() : (faction == 5 ? this.gameState.getUSSROperatesLeft() : 0));
        return val;
    }

    public void resetRailroad() {
        this.gameState.resetOperatesLeft();
    }

    public void addManpower() {
        int i = 0;
        while (i < this.country.length) {
            if (this.country[i].getSide() == this.whosTurn() && !this.country[i].isConquered()) {
                this.country[i].storeLastManpower();
            }
            ++i;
        }
        i = 0;
        while (i < this.country.length) {
            if (this.country[i].getSide() == this.whosTurn() && !this.country[i].isConquered()) {
                this.country[i].manpowerIncrease();
            }
            ++i;
        }
    }

    private void updateTransportationLoopsOwnership() {
        Country owner;
        int portSaidOwningSide;
        int preowningSide = this.gameState.getSuezLoop().getControllingSide();
        if (preowningSide != (portSaidOwningSide = (owner = this.country[this.hex[this.portSaidCity()].getOwningCountry()]).getSide())) {
            this.gameState.getAfricaLoop().setControllingSide(portSaidOwningSide);
            this.gameState.getSuezLoop().setControllingSide(portSaidOwningSide);
            this.getWarWindow().showInfoDialog(Global.createLanguageMessage(115, new String[]{owner.getSideName(false)}));
        }
    }

    private void updateTransportationLoops() {
        this.gameState.getAfricaLoop().updateLoop(this.whosTurn());
        this.gameState.getSuezLoop().updateLoop(this.whosTurn());
    }

    public void setPlayerSide(int i) {
        this.gameState.setPlayerSide(i);
    }

    private void resetMovedRaided() {
        int i = 0;
        while (i < this.country.length) {
            if (this.country[i] != null) {
                this.country[i].resetMovedRaided();
            }
            ++i;
        }
    }

    private void incEntrenchments() {
        int i = 0;
        while (i < this.hex.length) {
            Unit u;
            if (this.hex[i].getUnit() != null && (u = this.hex[i].getUnit()).getSide() != this.whosTurn() && u.getCountry().getAtWar()) {
                this.hex[i].getUnit().incEntrenchment();
            }
            ++i;
        }
    }

    public void switchPlayerSide() {
        if (this.playerSide() == 100) {
            this.setPlayerSide(200);
        } else {
            this.setPlayerSide(100);
        }
    }

    public void setGameMode(int i) {
        this.gameState.setGameMode(i);
    }

    public void storeMouseClick(int x, int y, boolean leftClick) {
        MouseClick mc = new MouseClick();
        mc.setValues(x, y, leftClick);
        this.mouseClick.add(mc);
    }

    public Hex getSelectedHex() {
        return this.selectedHex;
    }

    public void aaddddddvanceCalendar() {
        if (this.calendar.get(2) > 10 || this.calendar.get(2) < 3) {
            this.calendar.add(5, 14);
        } else {
            this.calendar.add(5, 7);
        }
    }

    public void advanceCalendar() {
        int year = this.calendar.get(1);
        int month = this.calendar.get(2);
        int day = this.calendar.get(5);
        day = month > 9 || month < 2 ? (day += Global.DAYS_PER_TURN) : (day += Global.DAYS_PER_TURN);
        this.calendar.set(year, month, day);
        if (month == 5 && this.calendar.get(2) == 6) {
            this.incFocusChangesLeft();
        }
        if (month == 11 && this.calendar.get(2) == 0) {
            this.incFocusChangesLeft();
        }
    }

    private void incFocusChangesLeft() {
        int i = 0;
        while (i < this.country.length) {
            if (this.country[i].getAtWar()) {
                this.country[i].incFocusChangesLeft();
            }
            ++i;
        }
    }

    public void createOwningBorders() {
        int i = 0;
        while (i < this.hex.length) {
            if (this.hex[i] instanceof LandHex && this.getRow(i) > 0) {
                boolean b;
                int hex = this.getNorthEastHex(i);
                if (hex != -1 && this.hex[hex] instanceof LandHex) {
                    b = this.needOwningBorder(i, hex);
                    ((LandHex)this.hex[i]).setOwningBorderNE(b);
                }
                if ((hex = this.getSouthEastHex(i)) != -1 && this.hex[hex] instanceof LandHex) {
                    b = this.needOwningBorder(i, hex);
                    ((LandHex)this.hex[i]).setOwningBorderSE(b);
                }
                if ((hex = this.getSouthHex(i)) != -1 && this.hex[hex] instanceof LandHex) {
                    b = this.needOwningBorder(i, hex);
                    ((LandHex)this.hex[i]).setOwningBorderS(b);
                }
            }
            ++i;
        }
    }

    private boolean needOwningBorder(int hexA, int hexB) {
        boolean atWar = this.country[this.hex[hexA].getOwningCountry()].getAtWar();
        boolean atWar2 = this.country[this.hex[hexB].getOwningCountry()].getAtWar();
        boolean ret = true;
        if (atWar && atWar2) {
            if (this.sameOwningSide(hexA, hexB)) {
                ret = false;
            }
        } else if (!atWar && !atWar2 && this.hex[hexA].getOwningCountry() == this.hex[hexB].getOwningCountry()) {
            ret = false;
        }
        return ret;
    }

    public boolean isPlayerTurn() {
        return this.whosTurn() == this.playerSide();
    }

    public int whosTurn() {
        return this.gameState.whosTurn();
    }

    public int getCapitalHex(int country) {
        return this.country[country].activeCapital();
    }

    public Country countryInCharge(Country countr) {
        int side = countr.getSide();
        Country ret = countr.isMajorCountry() ? countr : (side == 100 && countr.getAtWar() ? (this.country[0].getAtWar() ? this.country[0] : this.country[1]) : (side == 200 && countr.getAtWar() ? (this.country[2].getAtWar() ? this.country[2] : (this.country[4].getAtWar() ? this.country[4] : (this.country[3].getAtWar() ? this.country[3] : this.country[5]))) : countr));
        return ret;
    }

    public Country factionLeader(int faction) {
        Country ret = null;
        if (faction == 100) {
            if (this.country[0].getAtWar()) {
                ret = this.country[0];
            } else if (this.country[1].getAtWar()) {
                ret = this.country[1];
            }
        } else if (faction == 200) {
            if (this.country[2].getAtWar()) {
                ret = this.country[2];
            } else if (this.country[4].getAtWar()) {
                ret = this.country[4];
            } else if (this.country[3].getAtWar()) {
                ret = this.country[3];
            }
        } else if (faction == 5 && this.country[5].getAtWar()) {
            ret = this.country[5];
        }
        return ret;
    }

    private void addPP() {
        int i = 0;
        while (i < this.country.length) {
            if (this.country[i].getSide() == this.whosTurn() && !this.country[i].isConquered()) {
                this.country[i].storeLastPP();
            }
            ++i;
        }
        this.pResourcesPP();
        this.offMapPP();
    }

    private void pResourcesPP() {
        int i = 0;
        while (i < this.hex.length) {
            Country c;
            Hex h = this.hex[i];
            if (h.hasPResource() && (c = this.country[h.getOwningCountry()]).getSide() == this.whosTurn() && !c.isConquered()) {
                double pp = h.getPP(this);
                double productionFactor = this.industrialEffort(c.getCountryIndex());
                c.addPP(productionFactor * pp);
            }
            ++i;
        }
    }

    public void addOil() {
        int i = 0;
        while (i < this.country.length) {
            if (this.country[i].getSide() == this.whosTurn() && !this.country[i].isConquered()) {
                this.country[i].storeLastOil();
            }
            ++i;
        }
        this.pResourcesOil();
        this.offMapOil();
    }

    private void pResourcesOil() {
        int i = 0;
        while (i < this.hex.length) {
            Hex h = this.hex[i];
            Country c = this.country[h.getOwningCountry()];
            if (c.getSide() == this.whosTurn() && c.getAtWar()) {
                double oil = h.getOil(this);
                double productionFactor = this.industrialEffort(c.getCountryIndex());
                c.changeOil(productionFactor * oil);
            }
            ++i;
        }
    }

    private void offMapOil() {
        int i = 0;
        while (i < this.country.length) {
            Country c = this.country[i];
            double productionFactor = this.industrialEffort(c.getCountryIndex());
            double oil = c.getOffMapOil();
            if (c.getSide() == this.whosTurn() && c.getAtWar()) {
                c.changeOil(productionFactor * oil);
            }
            ++i;
        }
    }

    public double getOil(int faction) {
        double oil = 0.0;
        int i = 0;
        while (i < this.country.length) {
            if (this.country[i].getFaction() == faction) {
                oil += this.country[i].ownOil();
            }
            ++i;
        }
        return oil;
    }

    private void partisansProcedure() {
        int i = 0;
        while (i < this.hex.length) {
            if (this.hex[i] instanceof LandHex && this.hex[i].getUnit() == null && this.hex[i].getPResource() == null && this.owningSide(i) != this.whosTurn() && this.owningSide(i) == this.oppositeSide(this.coreOwningSide(i)) && this.country[this.hex[i].getCoreOwningCountry()].getAtWar() && this.country[this.hex[i].getOwningCountry()].getAtWar() && this.country[this.hex[i].getCoreOwningCountry()].getPrimaryCapital() != -1) {
                int chance = 4;
                if (!(this.hex[i].getTerrain() instanceof Clear)) {
                    chance *= 6;
                }
                int rnd = XRandAndCalc.rand(10000);
                if (rnd <= chance) {
                    Country partisanCountry = this.country[this.hex[i].getCoreOwningCountry()];
                    double rnd2 = Math.random();
                    if (rnd2 < 0.7) {
                        this.createAndPlaceUnit(new Garrison(partisanCountry), partisanCountry.getCountryIndex(), this.getColumn(i), this.getRow(i));
                    } else {
                        this.createAndPlaceUnit(new Corps(partisanCountry), partisanCountry.getCountryIndex(), this.getColumn(i), this.getRow(i));
                    }
                    this.warWindow.getMapCanvas().setMapViewPosition(this.hex[i], false);
                    Game.delay(1000L);
                    this.warWindow.showInfoDialog(Global.createLanguageMessage(134, new String[]{partisanCountry.getName()}));
                }
            }
            ++i;
        }
    }

    private void convoysProcedure() {
        this.fowProcedure();
        if (!this.country[4].isConquered()) {
            this.warWindow.disableButtons();
            this.warWindow.getMapCanvas().setAutomaticMoving(true);
            this.warWindow.showWarMap();
            this.warWindow.getButtonPanel2().selectTab(0);
            this.warWindow.requestFocus();
            this.warWindow.showInfoDialog(Global.createLanguageMessage(116, new String[0]));
            this.moveConvoys();
            if (this.gameState.getTurn() / 2 % Global.ALLIED_TURNS_BETWEEN_CONVOYS == 0) {
                this.createAndDeployConvoys(true);
            }
        }
    }

    public void setConvoyDestination(int unitHex, int dest, boolean hereFirst) {
        Unit u = this.hex[unitHex].getUnit();
        u.setDestinationHex(this.hex[dest]);
        if (hereFirst && hereFirst && this.getGameMode() == 3000) {
            String s = "x " + unitHex + " " + dest + " ";
            this.sendDataToOpponent(s);
        }
    }

    private void moveConvoys() {
        this.warWindow.getMapCanvas().setAutomaticMoving(true);
        int i = 0;
        while (i < this.country.length) {
            if (!this.country[i].isConquered()) {
                Vector<Unit> units = this.country[i].getUnits();
                int j = 0;
                while (j < units.size()) {
                    Unit u = units.get(j);
                    if (u instanceof Convoy) {
                        Hex moveToHex;
                        int unitHex = this.getHexIndex(u.getOnHex());
                        if (u.getCountry() == this.country[2]) {
                            int destination = this.updateConvoyDestination();
                            if (destination != -1) {
                                this.setConvoyDestination(unitHex, destination, true);
                            }
                        } else if (u.getCountry() == this.country[5]) {
                            this.setConvoyDestination(unitHex, this.northernmostPort(), true);
                        }
                        if ((moveToHex = this.decideWhereToMove(unitHex, this.getHexIndex(u.getDestinationHex()))) != null) {
                            Vector<Integer> route = new Vector<Integer>(10, 5);
                            this.calcGroundUnitRoute2(route, unitHex, this.getHexIndex(moveToHex), u.getMaxMovement(), u.getCountryIndex());
                            this.moveUnit(route, true, false, true);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.warWindow.getMapCanvas().setAutomaticMoving(false);
    }

    private double convoyFactor() {
        double factor = (1.0 * this.industrialEffort(2) + this.industrialEffort(4)) / 2.0;
        return factor;
    }

    private void createAndDeployConvoys(boolean hereFirst) {
        if (this.country[4].controlledBySide() == 200) {
            Vector<Integer> deployHexes = new Vector<Integer>(30, 10);
            Convoy northConvoy = null;
            int convoyStrength = this.convoyStrength((int)(this.convoyFactor() * (double)XRandAndCalc.rand(Global.NORTH_ATLANTIC_CONVOY_SIZE)));
            if (convoyStrength > 0) {
                if (!this.country[5].getAtWar() && this.country[2].controlledBySide() == 200) {
                    northConvoy = new Convoy(this.country[2], convoyStrength);
                    this.calcNorthConvoyDeployHexes(deployHexes);
                    this.deployConvoy(northConvoy, deployHexes, hereFirst);
                } else if (this.country[5].controlledBySide() == 200) {
                    northConvoy = new Convoy(this.country[5], convoyStrength);
                    this.calcNorthConvoyDeployHexes(deployHexes);
                    this.deployConvoy(northConvoy, deployHexes, hereFirst);
                }
            }
            if ((convoyStrength = this.convoyStrength((int)(this.convoyFactor() * (double)XRandAndCalc.rand(Global.MID_ATLANTIC_CONVOY_SIZE)))) > 0 && this.country[2].controlledBySide() == 200) {
                deployHexes.removeAllElements();
                Convoy midConvoy = new Convoy(this.country[2], convoyStrength);
                this.calcMidConvoyDeployHexes(deployHexes);
                this.deployConvoy(midConvoy, deployHexes, hereFirst);
            }
            if ((convoyStrength = this.convoyStrength((int)(this.convoyFactor() * (double)XRandAndCalc.rand(Global.SOUTH_ATLANTIC_CONVOY_SIZE)))) > 0 && this.country[2].controlledBySide() == 200) {
                deployHexes.removeAllElements();
                Convoy southConvoy = new Convoy(this.country[2], convoyStrength);
                this.calcSouthConvoyDeployHexes(deployHexes);
                this.deployConvoy(southConvoy, deployHexes, hereFirst);
            }
        }
    }

    private int convoyStrength(int strength) {
        int ret = strength;
        while (ret < 11 && ret > 0) {
            double rnd = Math.random();
            if (rnd < 0.5) {
                ret *= 2;
                continue;
            }
            ret = 0;
        }
        return ret;
    }

    public void centerOnCapital(Country c) {
        if (c.activeCapital() != -1) {
            this.warWindow.getMapCanvas().setMapViewPosition(this.hex[c.activeCapital()], false);
        }
    }

    private void calcNorthConvoyDeployHexes(Vector<Integer> deployHexes) {
        int i = 0;
        while (i < 6) {
            int column = 0;
            while (this.hex[this.getHex(column, i)] instanceof LandHex || this.hex[this.getHex(column, i)].getUnit() != null) {
                ++column;
            }
            deployHexes.add(new Integer(this.getHex(column, i)));
            ++i;
        }
    }

    private void calcMidConvoyDeployHexes(Vector<Integer> deployHexes) {
        int usCapitalRow;
        int i = usCapitalRow = this.getRow(this.country[4].activeCapital());
        while (i < usCapitalRow + 7) {
            int column = 0;
            while (this.hex[this.getHex(column, i)] instanceof LandHex || this.hex[this.getHex(column, i)].getUnit() != null) {
                ++column;
            }
            deployHexes.add(new Integer(this.getHex(column, i)));
            ++i;
        }
    }

    private void calcSouthConvoyDeployHexes(Vector<Integer> deployHexes) {
        int column = 1;
        while (column < 12) {
            int row = 71;
            while (this.hex[this.getHex(column, row)] instanceof LandHex || this.hex[this.getHex(column, row)].getUnit() != null) {
                --row;
            }
            deployHexes.add(new Integer(this.getHex(column, row)));
            ++column;
        }
    }

    private void deployConvoy(Convoy convoy, Vector<Integer> hexIndexes, boolean hereFirst) {
        if (hexIndexes.size() > 0) {
            String s;
            int rand = XRandAndCalc.rand(hexIndexes.size()) - 1;
            int deployHex = hexIndexes.get(rand);
            convoy.getCountry().boughtUnit(convoy);
            int unit = convoy.getCountry().deployUnit(convoy, deployHex);
            if (hereFirst && this.getGameMode() == 3000) {
                s = "p " + convoy.getCountryIndex() + " " + 99 + " " + -1 + " " + convoy.getStrength() + " " + this.getHexIndex(convoy.getDestinationHex()) + " ";
                this.sendDataToOpponent(s);
            }
            if (hereFirst && this.getGameMode() == 3000) {
                s = "y " + deployHex + " " + convoy.getCountryIndex() + " " + unit + " ";
                this.sendDataToOpponent(s);
            }
        }
    }

    public Country owningCountry(int hex) {
        return this.country[this.hex[hex].getOwningCountry()];
    }

    public int owningSide(int hex) {
        return this.country[this.hex[hex].getOwningCountry()].getSide();
    }

    public int coreOwningSide(int hex) {
        return this.country[this.hex[hex].getCoreOwningCountry()].getSide();
    }

    public boolean hasFriendlyActiveSeaPort(int hex, int side) {
        return this.owningSide(hex) == side && this.hex[hex].getAttachedPort() != null && this.country[this.hex[hex].getOwningCountry()].activeFriendly(side);
    }

    public int closestFriendlyActiveSeaPort(int hex, Unit friend) {
        int bestPort = -1;
        int i = 0;
        while (i < this.hex.length) {
            Hex tmp = this.hex[i];
            if (this.hasFriendlyActiveSeaPort(i, friend.getSide())) {
                int portHex = this.getHexIndex(tmp.getAttachedPort());
                if (bestPort == -1) {
                    bestPort = portHex;
                } else if (this.shortestPath(hex, i) < this.shortestPath(hex, bestPort)) {
                    bestPort = portHex;
                }
            }
            ++i;
        }
        return bestPort;
    }

    public int northernmostPort() {
        int bestPort = -1;
        int i = 0;
        while (i < this.hex.length) {
            Hex tmp = this.hex[i];
            if (tmp.getPResource() instanceof SeaPort) {
                if (bestPort == -1) {
                    bestPort = i;
                } else if (this.getRow(i) < this.getRow(bestPort)) {
                    bestPort = i;
                }
            }
            ++i;
        }
        return bestPort;
    }

    public int updateConvoyDestination() {
        int destination = -1;
        if (this.hex[4776].getOwningCountry() == 2) {
            destination = this.hex[4618].getOwningCountry() == 2 ? 4618 : (this.hex[4262].getOwningCountry() == 2 ? 4262 : (this.hex[4624].getOwningCountry() == 2 ? 4624 : (this.hex[4340].getOwningCountry() == 2 ? 4340 : (this.hex[4201].getOwningCountry() == 2 ? 4201 : 4776))));
        } else if (this.hex[822].getOwningCountry() == 2) {
            destination = 822;
        } else if (this.hex[4618].getOwningCountry() == 2) {
            destination = 4618;
        } else if (this.hex[4262].getOwningCountry() == 2) {
            destination = 4262;
        } else if (this.hex[4624].getOwningCountry() == 2) {
            destination = 4624;
        } else if (this.hex[4340].getOwningCountry() == 2) {
            destination = 4340;
        } else if (this.hex[4201].getOwningCountry() == 2) {
            destination = 4201;
        }
        return destination;
    }

    public int westernmostPort(int country, boolean primaryContinentOnly) {
        Country c = this.country[country];
        int bestPort = -1;
        int i = 0;
        while (i < this.hex.length) {
            Hex tmp = this.hex[i];
            if (!(tmp.getCoreOwningCountry() != country || tmp.getOwningCountry() != country || tmp.getPResource() == null || tmp.getAttachedPort() == null || primaryContinentOnly && tmp.getContinent() != this.hex[c.getPrimaryCapital()].getContinent())) {
                int portHex = this.getHexIndex(tmp.getAttachedPort());
                if (bestPort == -1) {
                    bestPort = portHex;
                } else if (this.getColumn(i) < this.getColumn(bestPort)) {
                    bestPort = portHex;
                }
            }
            ++i;
        }
        return bestPort;
    }

    public boolean isMainland(int hex) {
        return this.insideMap(hex) && this.hex[hex].getContinent() == this.hex[this.country[0].getPrimaryCapital()].getContinent();
    }

    public boolean inAfrica(int hex) {
        if (this.isMainland(hex)) {
            int nextHex = hex;
            while (this.insideMap(this.getNorthHex(nextHex)) && (this.isMainland(this.getNorthHex(nextHex)) || this.hex[this.getNorthHex(nextHex)].getContinent() == -1)) {
                nextHex = this.getNorthHex(nextHex);
            }
            if (this.insideMap(this.getNorthHex(nextHex)) && this.hex[this.getNorthHex(nextHex)].getContinent() == this.mediterraneanOceanIndex()) {
                return true;
            }
        }
        return false;
    }

    public GregorianCalendar getEndDate() {
        return this.endDate;
    }

    public int portOwner(PResource port) {
        int i = 0;
        while (i < this.hex.length) {
            if (this.hex[i].getAttachedPort() != null && this.hex[i].getAttachedPort().getPResource() == port) {
                return this.hex[i].getOwningCountry();
            }
            ++i;
        }
        return -1;
    }

    public boolean friendlyPort(int hex, int side) {
        int portOwner;
        PResource pr = this.hex[hex].getPResource();
        return pr instanceof SeaPort && (portOwner = this.portOwner(pr)) != -1 && side == this.getCountry(portOwner).getSide();
    }

    public boolean insideEnemyPort(Unit u) {
        return u.getOnHex() != null && u.getOnHex().getPResource() instanceof SeaPort && !this.friendlyPort(this.getHexIndex(u.getOnHex()), u.getSide());
    }

    public int portSaidCity() {
        return this.easternMostPortCity(31);
    }

    public int easternMostPortCity(int country) {
        int bestCity = -1;
        int i = 0;
        while (i < this.hex.length) {
            Hex tmp = this.hex[i];
            if (tmp.getCoreOwningCountry() == country && tmp.getPResource() != null && tmp.getAttachedPort() != null) {
                if (bestCity == -1) {
                    bestCity = i;
                } else if (this.getColumn(i) > this.getColumn(bestCity)) {
                    bestCity = i;
                }
            }
            ++i;
        }
        return bestCity;
    }

    public Hex decideConvoyTargetForSubs(int subSide) {
        Hex ret = null;
        int friendlySubs = 0;
        int enemyShips = 0;
        int i = 0;
        while (i < this.country.length) {
            if (this.country[i].getAtWar() && this.country[i].getSide() == subSide) {
                friendlySubs += this.country[i].numSubs();
            }
            ++i;
        }
        i = 0;
        while (i < this.country.length) {
            if (this.country[i].getAtWar() && this.country[i].getSide() != subSide) {
                enemyShips += this.country[i].numShips();
            }
            ++i;
        }
        if ((double)friendlySubs >= 0.3 * (double)enemyShips && friendlySubs > 2) {
            double bestScore = 0.0;
            int i2 = 0;
            while (i2 < this.hexLength()) {
                Unit u = this.hex[i2].getUnit();
                double score = 0.0;
                if (u != null && u.getCountry().getAtWar() && u.getSide() != subSide && u instanceof Convoy) {
                    score = 100.0 * this.militaryAdvantageRatioOverHex(subSide, i2) - (double)this.getColumn(i2) + (double)XRandAndCalc.rand(100) - 100.0;
                }
                if (score > bestScore) {
                    bestScore = score;
                    ret = this.hex[i2];
                }
                ++i2;
            }
        }
        return ret;
    }

    public Hex decideConvoyTargetForEscort(int shipSide, Unit friendlyUnit) {
        Hex ret = null;
        int friendlyShips = 0;
        int enemySubs = 0;
        int friendlyUnitHex = this.getHexIndex(friendlyUnit.getOnHex());
        int i = 0;
        while (i < this.country.length) {
            if (this.country[i].getAtWar() && this.country[i].getSide() == shipSide) {
                friendlyShips += this.country[i].numShips();
            }
            ++i;
        }
        i = 0;
        while (i < this.country.length) {
            if (this.country[i].getAtWar() && this.country[i].getSide() != shipSide) {
                enemySubs += this.country[i].numSubs();
            }
            ++i;
        }
        if (friendlyShips >= enemySubs) {
            int bestScore = 0;
            int i2 = 0;
            while (i2 < this.hexLength()) {
                Unit u = this.hex[i2].getUnit();
                int score = 0;
                if (u != null && u.getCountry().getAtWar() && u.getSide() == shipSide && u instanceof Convoy && this.nearestOceanIndex(i2) == this.nearestOceanIndex(friendlyUnitHex)) {
                    score = 8 * this.militaryInfluenceOverHex(this.oppositeSide(shipSide), i2) + this.getColumn(i2) - this.getColumn(friendlyUnitHex) - 80 * this.numberUnitsChasing(i2, shipSide) + XRandAndCalc.rand(100 + this.getStrategicAggression(shipSide)) + u.getStrength() - 280;
                    score = friendlyUnit instanceof Destroyer ? (score += 20) : (score -= 20);
                }
                if (score > bestScore) {
                    bestScore = score;
                    ret = this.hex[i2];
                }
                ++i2;
            }
        }
        return ret;
    }

    public int centerOfMap() {
        int column = 75;
        int row = 36;
        return this.getHex(75, 36);
    }

    public int numberUnitsChasing(int chaseHex, int side) {
        int ret = 0;
        int i = 0;
        while (i < this.hex.length) {
            Unit u = this.hex[i].getUnit();
            if (u != null && u.getSide() == side && this.getHexIndex(u.getChasePoint()) == chaseHex) {
                ++ret;
            }
            ++i;
        }
        return ret;
    }

    public Hex decideWhereToAirAttack(Unit u) {
        Hex ret = null;
        int bestScore = -99999;
        if (u instanceof AirUnit && (double)u.getStrength() > 0.7 * (double)u.maxStrength()) {
            this.targetAroundUnit(this.getHexIndex(u.getOnHex()));
            int j = 0;
            while (j < this.getHexes().length) {
                if (this.getHex(j).getTargetted()) {
                    Unit enemy = this.getHex(j).getUnit();
                    if (!(this.getHex(j).getPResource() instanceof Fortress)) {
                        OddsAndPenalties odds = this.expectedOdds(u.getOnHex(), this.getHex(j));
                        if (enemy != null && u.getAggressiveness() * odds.getAttackerBattleOdds() >= odds.getDefenderBattleOdds() && odds.getAttackerBattleOdds() > 0.0 && (enemy.getMorale() >= 45 || enemy.getOnHex().getPResource() != null)) {
                            int score = 0;
                            score += XRandAndCalc.rand(100);
                            score += 300 * this.friendsAdjacent(this.getHexIndex(enemy.getOnHex()), u);
                            if ((score -= 30 * this.shortestPath(j, this.getHexIndex(u.getOnHex()))) > bestScore) {
                                bestScore = score;
                                ret = this.getHex(j);
                            }
                        }
                    }
                }
                ++j;
            }
        }
        this.deHighlightdeTargetAll();
        return ret;
    }

    public Hex decideWhereToMove(int unitHex, int destination) {
        Hex ret = null;
        if (this.insideMap(unitHex) && this.insideMap(destination) && this.hex[unitHex].getUnit() != null) {
            int movement = this.hex[unitHex].getUnit().getRealMovement();
            int dist = this.shortestPath(this.getHexIndex(ret), destination);
            if (dist > 25 && this.hex[unitHex].getUnit().isLandUnit() && this.hex[unitHex].getContinent() == this.hex[destination].getContinent() || dist > 65 && !this.hex[unitHex].getUnit().isLandUnit()) {
                Hex large = this.decideWhereToMove2(unitHex, destination, 55);
                Hex medium = null;
                Hex small = null;
                if (large != null) {
                    medium = this.decideWhereToMove2(unitHex, this.getHexIndex(large), 40);
                }
                if (medium != null) {
                    small = this.decideWhereToMove2(unitHex, this.getHexIndex(medium), 25);
                }
                if (small != null) {
                    ret = movement > 40 ? this.decideWhereToMove2(unitHex, this.getHexIndex(large), -1) : (movement > 25 ? this.decideWhereToMove2(unitHex, this.getHexIndex(medium), -1) : this.decideWhereToMove2(unitHex, this.getHexIndex(small), -1));
                }
            } else {
                ret = this.decideWhereToMove2(unitHex, destination, -1);
            }
        }
        return ret;
    }

    public boolean coastalLandHex(int hex) {
        return this.hex[hex].isLandHex() && this.nearestOceanDist(hex) <= 1;
    }

    public boolean coastalSeaHex(int hex, int destContinent) {
        if (this.hex[hex].isWaterHex()) {
            Hex h;
            int nextHex = this.getNorthHex(hex);
            if (this.insideMap(nextHex) && (h = this.hex[nextHex]).isLandHex() && h.getContinent() == destContinent) {
                return true;
            }
            nextHex = this.getNorthEastHex(hex);
            if (this.insideMap(nextHex) && (h = this.hex[nextHex]).isLandHex() && h.getContinent() == destContinent) {
                return true;
            }
            nextHex = this.getSouthEastHex(hex);
            if (this.insideMap(nextHex) && (h = this.hex[nextHex]).isLandHex() && h.getContinent() == destContinent) {
                return true;
            }
            nextHex = this.getSouthHex(hex);
            if (this.insideMap(nextHex) && (h = this.hex[nextHex]).isLandHex() && h.getContinent() == destContinent) {
                return true;
            }
            nextHex = this.getSouthWestHex(hex);
            if (this.insideMap(nextHex) && (h = this.hex[nextHex]).isLandHex() && h.getContinent() == destContinent) {
                return true;
            }
            nextHex = this.getNorthWestHex(hex);
            if (this.insideMap(nextHex) && (h = this.hex[nextHex]).isLandHex() && h.getContinent() == destContinent) {
                return true;
            }
        }
        return false;
    }

    public Hex decideWhereToMove2(int unitHex, int destination, int moves) {
        Hex ret = null;
        int bestScore = -999999;
        Vector<Integer> candidates = new Vector<Integer>(10, 5);
        Unit unit = this.hex[unitHex].getUnit();
        int realMoves = moves;
        if (realMoves == -1) {
            realMoves = unit.getRealMovement();
        }
        this.highlightAroundUnit(unitHex, realMoves, false);
        this.hex[unitHex].setHighlighted(true);
        int j = 0;
        while (j < this.hexLength()) {
            if (this.getHex(j).getHighlighted() && !unit.afraidOfHex(j)) {
                int score = -10 * this.shortestPath(j, destination);
                if (unit instanceof AirUnit && this.getHex(j).getSupply() < this.hex[unitHex].getSupply()) {
                    score -= 150;
                }
                if (j == unitHex) {
                    score += 5;
                }
                if (unit instanceof GroundUnit) {
                    if (this.enemyValuedResourceAdjacent(j, unit)) {
                        score += 200;
                    }
                    if (this.nonFortressEnemiesAdjacent(j, unit) > 0) {
                        score += 250;
                    }
                    if (this.owningSide(j) != unit.getSide()) {
                        score += 100;
                    }
                    if (unit.capitalDefenceDuty()) {
                        score -= 1000 * this.shortestPath(j, destination);
                    }
                } else if (unit instanceof Transport && this.coastalSeaHex(j, this.hex[destination].getContinent())) {
                    score += 22;
                }
                if (score > bestScore) {
                    candidates.removeAllElements();
                    candidates.add(new Integer(j));
                    bestScore = score;
                } else if (score == bestScore) {
                    candidates.add(new Integer(j));
                }
            }
            ++j;
        }
        if (candidates.size() > 0) {
            int index = XRandAndCalc.rand(candidates.size()) - 1;
            ret = this.hex[(Integer)candidates.get(index)];
        }
        this.deHighlightdeTargetAll();
        if (ret == this.hex[unitHex]) {
            ret = null;
        }
        return ret;
    }

    public Hex decideWhereToAttack(int unitHex) {
        Hex ret = null;
        double bestScore = 1.0;
        Vector<Integer> candidates = new Vector<Integer>(10, 5);
        Unit unit = this.hex[unitHex].getUnit();
        this.targetAroundUnit(unitHex);
        int j = 0;
        while (j < this.hexLength()) {
            if (this.hex[j].getTargetted()) {
                double score = 0.0;
                OddsAndPenalties odds = this.expectedOdds(unit.getOnHex(), this.hex[j]);
                score = odds.getAttackerBattleOdds() / Math.max(1.0, odds.getDefenderBattleOdds());
                score *= unit.getAggressiveness();
                score -= Math.random() / 10.0;
                score += Math.random() / 10.0;
                if (odds.getAttackerBattleOdds() <= 0.0) {
                    score = 0.0;
                }
                if (unit instanceof GroundUnit && this.hex[j].getPResource() != null && this.hex[j].getPResource().maxProduction() > 0.0) {
                    score *= 1.3;
                }
                if (score > bestScore) {
                    candidates.removeAllElements();
                    candidates.add(new Integer(j));
                    bestScore = score;
                } else if (score == bestScore) {
                    candidates.add(new Integer(j));
                }
            }
            ++j;
        }
        if (candidates.size() > 0) {
            int index = XRandAndCalc.rand(candidates.size()) - 1;
            ret = this.hex[(Integer)candidates.get(index)];
        }
        this.deHighlightdeTargetAll();
        return ret;
    }

    public boolean isInFrontLine(int unitHex, Unit u) {
        return this.enemiesAdjacent(unitHex, u) > 0 && this.friendsAdjacent(unitHex, u) > 0;
    }

    public boolean isNearEnemy(int unitHex, Unit u) {
        return this.enemiesAdjacent(unitHex, u) > 0;
    }

    public Hex decideCaptureMove(int unitHex) {
        Hex ret = null;
        Vector<Integer> candidates = new Vector<Integer>(10, 5);
        Unit unit = this.hex[unitHex].getUnit();
        if (!unit.onDefenceMission()) {
            int realMoves = unit.getRealMovement();
            this.highlightAroundUnit(unitHex, realMoves, false);
            if (unit instanceof GroundUnit) {
                int j = 0;
                while (j < this.hexLength()) {
                    Hex h = this.getHex(j);
                    if (h.getHighlighted() && h.getPResource() != null && unit.getOnHex().getPResource() == null && h.getUnit() == null) {
                        if (unit.getSide() == this.owningSide(j) && !unit.isVehicle()) {
                            candidates.add(new Integer(j));
                        } else if (unit.getSide() != this.owningSide(j)) {
                            candidates.add(new Integer(j));
                        }
                    }
                    ++j;
                }
            }
            if (candidates.size() > 0) {
                int index = XRandAndCalc.rand(candidates.size()) - 1;
                ret = this.hex[(Integer)candidates.get(index)];
            }
            this.deHighlightdeTargetAll();
        }
        return ret;
    }

    public Hex decideFrontLiningMove(int unitHex) {
        Hex ret = null;
        Vector<Integer> candidates = new Vector<Integer>(10, 5);
        Unit unit = this.hex[unitHex].getUnit();
        int ownCapital = unit.getCountry().activeCapital();
        int shortestDist = 999999;
        if (!unit.onDefenceMission()) {
            int realMoves = unit.getRealMovement();
            this.highlightAroundUnit(unitHex, realMoves, false);
            int j = 0;
            while (j < this.hexLength()) {
                if (this.getHex(j).getHighlighted() && !unit.afraidOfHex(j) && !this.isInFrontLine(unitHex, unit) && this.isInFrontLine(j, unit)) {
                    if (ownCapital == -1) {
                        candidates.add(new Integer(j));
                    } else if (this.shortestPath(j, ownCapital) < shortestDist) {
                        candidates.removeAllElements();
                        candidates.add(new Integer(j));
                        shortestDist = this.shortestPath(j, ownCapital);
                    } else if (this.shortestPath(j, ownCapital) == shortestDist) {
                        candidates.add(new Integer(j));
                    }
                }
                ++j;
            }
            if (candidates.size() > 0) {
                int index = XRandAndCalc.rand(candidates.size()) - 1;
                ret = this.hex[(Integer)candidates.get(index)];
            }
            this.deHighlightdeTargetAll();
        }
        return ret;
    }

    public void sentryUnit() {
        if (this.whosTurn() == this.gameState.playerSide() && this.seingMap() && !this.warWindow.getMapCanvas().getAutomaticMoving() && !this.busy && this.selectedHex != null && this.selectedHex.getUnit() != null) {
            this.selectedHex.getUnit().setSentry(true);
            this.deSelect();
        }
    }

    public double industrialEffort(int country) {
        Country c = this.country[country];
        double factor = ((double)c.getPeaceProductionFactor1939() + (double)(this.quartersPassed(this.calendar) * Global.QUARTERLY_PEACE_PRODUCTION_INCREASE)) / 100.0;
        if (c.getAtWar()) {
            factor += (double)Global.AT_WAR_PRODUCTION_INCREASE / 100.0;
        }
        if (c.mobilized()) {
            factor += (double)Global.FULL_MOBILIZATION_PRODUCTION_INCREASE / 100.0;
        }
        if (!c.isMajorCountry()) {
            factor = c.getAtWar() ? 1.0 : 0.0;
        }
        factor = Math.min(1.0, factor);
        factor = Math.max(0.0, factor);
        factor *= c.productionTechFactor();
        return factor *= c.getHandicapFactor();
    }

    private void offMapPP() {
        int i = 0;
        while (i < this.country.length) {
            Country c = this.country[i];
            double pp = c.getOffMapProduction();
            if (c.getSide() == this.whosTurn() && !c.isConquered()) {
                double productionFactor = this.industrialEffort(c.getCountryIndex());
                c.addPP(productionFactor * pp);
            }
            ++i;
        }
    }

    private void setHandicapLevels() {
        int bias = this.gameState.getAlliedBias();
        if (this.getGameMode() == 1000) {
            if (this.playerSide() == 100) {
                this.createToForcePool(new Garrison(this.country[2]), 2);
                this.createToForcePool(new Garrison(this.country[2]), 2);
                this.createToForcePool(new Corps(this.country[2]), 2);
                this.createToForcePool(new Corps(this.country[2]), 2);
                this.createToForcePool(new Garrison(this.country[3]), 3);
                this.createToForcePool(new Garrison(this.country[3]), 3);
                this.createToForcePool(new Garrison(this.country[3]), 3);
                this.createToForcePool(new Garrison(this.country[3]), 3);
                if (bias == 7) {
                    this.createToForcePool(new Corps(this.country[5]), 5);
                }
                if (bias == 7) {
                    this.createToForcePool(new Corps(this.country[5]), 5);
                }
                if (bias == 7) {
                    this.createToForcePool(new Corps(this.country[5]), 5);
                }
                if (bias == 7) {
                    this.createToForcePool(new Corps(this.country[5]), 5);
                }
                if (bias == 7) {
                    this.createToForcePool(new Corps(this.country[5]), 5);
                }
                if (bias == 7) {
                    this.createToForcePool(new Corps(this.country[5]), 5);
                }
                if (bias == 7) {
                    this.createToForcePool(new Corps(this.country[5]), 5);
                }
                if (bias > 4) {
                    this.createToForcePool(new Garrison(this.country[2]), 2);
                }
                if (bias > 4) {
                    this.createToForcePool(new Corps(this.country[2]), 2);
                }
                if (bias > 4) {
                    this.createToForcePool(new Destroyer(this.country[2]), 2);
                }
                if (bias > 4) {
                    this.createToForcePool(new Battleship(this.country[2]), 2);
                }
                if (bias > 4) {
                    this.createToForcePool(new Destroyer(this.country[4]), 4);
                }
                if (bias > 4) {
                    this.createToForcePool(new Battleship(this.country[4]), 4);
                }
                if (bias > 4) {
                    this.createToForcePool(new Garrison(this.country[3]), 3);
                }
                if (bias > 4) {
                    this.createToForcePool(new Garrison(this.country[3]), 3);
                }
                if (bias > 4) {
                    this.createToForcePool(new Garrison(this.country[3]), 3);
                }
                if (bias > 4) {
                    this.createToForcePool(new Garrison(this.country[3]), 3);
                }
                if (bias > 4) {
                    this.createToForcePool(new Corps(this.country[3]), 3);
                }
                if (bias > 4) {
                    this.createToForcePool(new Corps(this.country[3]), 3);
                }
                if (bias > 4) {
                    this.createToForcePool(new Corps(this.country[3]), 3);
                }
            } else if (this.playerSide() == 200) {
                this.createToForcePool(new Garrison(this.country[0]), 0);
                this.createToForcePool(new Garrison(this.country[0]), 0);
                this.createToForcePool(new Corps(this.country[0]), 0);
                this.createToForcePool(new Corps(this.country[0]), 0);
                if (bias == 1) {
                    this.createToForcePool(new Corps(this.country[0]), 0);
                }
                if (bias == 1) {
                    this.createToForcePool(new Corps(this.country[0]), 0);
                }
                if (bias == 1) {
                    this.createToForcePool(new Corps(this.country[0]), 0);
                }
                if (bias == 1) {
                    this.createToForcePool(new Corps(this.country[0]), 0);
                }
                if (bias == 1) {
                    this.createToForcePool(new Corps(this.country[0]), 0);
                }
                if (bias < 4) {
                    this.createToForcePool(new Armour(this.country[0]), 0);
                }
                if (bias < 4) {
                    this.createToForcePool(new Armour(this.country[0]), 0);
                }
                if (bias < 4) {
                    this.createToForcePool(new TacticalBomber(this.country[0]), 0);
                }
                if (bias < 4) {
                    this.createToForcePool(new Fighter(this.country[0]), 0);
                }
            }
        }
        switch (bias) {
            case 1: {
                this.country[0].setHandicapFactor(1.9);
                break;
            }
            case 2: {
                this.country[0].setHandicapFactor(1.45);
                break;
            }
            case 3: {
                this.country[0].setHandicapFactor(1.2);
                break;
            }
            case 5: {
                this.country[0].setHandicapFactor(0.9);
                break;
            }
            case 6: {
                this.country[0].setHandicapFactor(0.8);
                break;
            }
            case 7: {
                this.country[0].setHandicapFactor(0.7);
            }
        }
        switch (bias) {
            case 1: {
                this.country[1].setHandicapFactor(1.4);
                break;
            }
            case 2: {
                this.country[1].setHandicapFactor(1.2);
                break;
            }
            case 3: {
                this.country[1].setHandicapFactor(1.1);
                break;
            }
            case 5: {
                this.country[1].setHandicapFactor(0.9);
                break;
            }
            case 6: {
                this.country[1].setHandicapFactor(0.8);
                break;
            }
            case 7: {
                this.country[1].setHandicapFactor(0.7);
            }
        }
        switch (bias) {
            case 1: {
                this.country[2].setHandicapFactor(0.8);
                break;
            }
            case 2: {
                this.country[2].setHandicapFactor(0.9);
                break;
            }
            case 3: {
                this.country[2].setHandicapFactor(0.95);
                break;
            }
            case 5: {
                this.country[2].setHandicapFactor(1.1);
                break;
            }
            case 6: {
                this.country[2].setHandicapFactor(1.2);
                break;
            }
            case 7: {
                this.country[2].setHandicapFactor(1.4);
            }
        }
        switch (bias) {
            case 1: {
                this.country[3].setHandicapFactor(0.4);
                break;
            }
            case 2: {
                this.country[3].setHandicapFactor(0.7);
                break;
            }
            case 3: {
                this.country[3].setHandicapFactor(0.85);
                break;
            }
            case 5: {
                this.country[3].setHandicapFactor(1.2);
                break;
            }
            case 6: {
                this.country[3].setHandicapFactor(1.4);
                break;
            }
            case 7: {
                this.country[3].setHandicapFactor(1.8);
            }
        }
        switch (bias) {
            case 1: {
                this.country[4].setHandicapFactor(0.6);
                break;
            }
            case 2: {
                this.country[4].setHandicapFactor(0.8);
                break;
            }
            case 3: {
                this.country[4].setHandicapFactor(0.9);
                break;
            }
            case 5: {
                this.country[4].setHandicapFactor(1.05);
                break;
            }
            case 6: {
                this.country[4].setHandicapFactor(1.1);
                break;
            }
            case 7: {
                this.country[4].setHandicapFactor(1.2);
            }
        }
        switch (bias) {
            case 1: {
                this.country[5].setHandicapFactor(0.7);
                break;
            }
            case 2: {
                this.country[5].setHandicapFactor(0.8);
                break;
            }
            case 3: {
                this.country[5].setHandicapFactor(0.9);
                break;
            }
            case 5: {
                this.country[5].setHandicapFactor(1.2);
                break;
            }
            case 6: {
                this.country[5].setHandicapFactor(1.5);
                break;
            }
            case 7: {
                this.country[5].setHandicapFactor(2.0);
            }
        }
    }

    public int monthsBeforeWarEntry(Country c) {
        int months = this.monthsPassed(c.getEntryDate()) - this.monthsPassed(this.calendar);
        return months;
    }

    private void warEntries() {
        int i = 0;
        while (i < this.country.length) {
            Country c = this.country[i];
            if (c.getSide() != 300 && !c.getAtWar() && !c.isConquered() && c.getSide() == this.whosTurn() && (this.calendar.after(c.getEntryDate()) || this.calendar.equals(c.getEntryDate()))) {
                this.dowCountry(this.oppositeSide(this.whosTurn()), i, false, false, true, true);
            }
            ++i;
        }
    }

    public void saveGame(boolean defaultSave, boolean isScenario, String paramPath, String fileName) {
        this.gameState.setGameName(fileName);
        this.gameState.setScenario(isScenario);
        try {
            try {
                try {
                    String path = "";
                    if (!defaultSave && !isScenario) {
                        if (this.getGameMode() == 1000) {
                            path = Global.getSavePath();
                        } else if (this.getGameMode() == 2000) {
                            path = Global.getHotSeatPath();
                            path = String.valueOf(path) + "Hotseat ";
                        } else if (this.getGameMode() == 4000) {
                            path = Global.getpbemPath();
                            path = String.valueOf(path) + "PBEM ";
                        } else if (this.getGameMode() == 3000) {
                            path = Global.gettcpipPath();
                            path = String.valueOf(path) + "TCPIP ";
                        }
                    } else {
                        path = Global.getSavePath();
                    }
                    path = defaultSave ? String.valueOf(path) + "Default.data" : String.valueOf(path) + "Game " + this.gameState.getGameName() + ".data";
                    if (fileName != "") {
                        String fileName2 = "";
                        if (!isScenario) {
                            if (this.getGameMode() == 2000 && !fileName.startsWith("Hotseat")) {
                                fileName2 = "Hotseat ";
                            } else if (this.getGameMode() == 4000 && !fileName.startsWith("PBEM")) {
                                fileName2 = "PBEM ";
                            } else if (this.getGameMode() == 3000 && !fileName.startsWith("TCPIP")) {
                                fileName2 = "TCPIP ";
                            }
                        }
                        fileName2 = String.valueOf(fileName2) + fileName;
                        if (!fileName.endsWith(".data")) {
                            fileName2 = String.valueOf(fileName2) + ".data";
                        }
                        path = String.valueOf(paramPath) + fileName2;
                    }
                    FileOutputStream f_out = new FileOutputStream(path);
                    ObjectOutputStream obj_out = new ObjectOutputStream(f_out);
                    obj_out.writeObject(this.gameState);
                    obj_out.writeObject(this.country);
                    obj_out.writeObject(this.hex);
                    obj_out.writeObject(this.calendar);
                    obj_out.writeObject(this.timeSystem);
                    obj_out.flush();
                    obj_out.close();
                }
                catch (NotSerializableException e) {
                    System.exit(189);
                }
            }
            catch (FileNotFoundException e) {
                OkDialogLarge okDialogLarge = new OkDialogLarge((Frame)this.theScreen, this);
                okDialogLarge.showDialog(Global.getMessage(1320), Global.getMessage(1321));
                System.exit(88);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(88);
        }
    }

    public boolean loadGame(int gameMode, boolean defaultSave, boolean isScenario, String paramPath, String fileName) {
        boolean success = true;
        int version = this.gameState.getVersion();
        int preGameMode = this.getGameMode();
        boolean FOW = this.gameState.getFOW();
        boolean end1945 = this.gameState.getEnd1945();
        boolean randomResearch = this.gameState.getRandomResearch();
        boolean oilCons = this.gameState.getOilConsumption();
        int alliedBias = this.gameState.getAlliedBias();
        boolean nato = this.gameState.getNatoSymbols();
        boolean hexGrid = this.gameState.getHexGrid();
        boolean tooltips = this.gameState.getTooltips();
        boolean darkOverlay = this.gameState.getDarkOverlay();
        try {
            try {
                String path = "";
                if (!defaultSave) {
                    if (gameMode == 1000) {
                        path = Global.getSavePath();
                    } else if (gameMode == 2000) {
                        path = Global.getHotSeatPath();
                        path = String.valueOf(path) + "Hotseat ";
                    } else if (gameMode == 4000) {
                        path = Global.getpbemPath();
                        path = String.valueOf(path) + "PBEM ";
                    } else if (gameMode == 3000) {
                        path = Global.gettcpipPath();
                        path = String.valueOf(path) + "TCPIP ";
                    }
                } else {
                    path = Global.getSavePath();
                }
                path = defaultSave ? String.valueOf(path) + "Default.data" : String.valueOf(path) + "Autosave.data";
                if (fileName != "") {
                    path = String.valueOf(paramPath) + fileName;
                }
                FileInputStream f_in = new FileInputStream(path);
                ObjectInputStream obj_in = new ObjectInputStream(f_in);
                GameState tmp = (GameState)obj_in.readObject();
                if (!isScenario && tmp.getGameMode() != gameMode) {
                    success = false;
                }
                if (tmp.getVersion() != version) {
                    success = false;
                }
                if (tmp.getScenario() != isScenario) {
                    success = false;
                }
                if (gameMode == 98) {
                    return success;
                }
                if (success) {
                    this.gameState = tmp;
                    this.country = (Country[])obj_in.readObject();
                    this.hex = (Hex[])obj_in.readObject();
                    this.calendar = (GregorianCalendar)obj_in.readObject();
                    this.timeSystem = (TimeSystem)obj_in.readObject();
                    obj_in.close();
                    int i = 0;
                    while (i < this.country.length) {
                        this.country[i].setGame(this);
                        ++i;
                    }
                    if (tmp.getGameMode() == 4000) {
                        this.switchPlayerSide();
                    }
                    if (isScenario) {
                        tmp.setFOW(FOW);
                        tmp.setEnd1945(end1945);
                        tmp.setRandomResearch(randomResearch);
                        tmp.setOilConsumption(oilCons);
                        tmp.setAlliedBias(alliedBias);
                    }
                    tmp.setNatoSymbols(nato);
                    tmp.setHexGrid(hexGrid);
                    tmp.setTooltips(tooltips);
                    tmp.setDarkOverlay(darkOverlay);
                    this.busy = false;
                    this.scrolling = false;
                    this.endTurnRequested = false;
                    this.chatDialogRequested = false;
                    this.nextreadyUnit = 0;
                    this.nowShowing = 0;
                    this.selectedCountry = -1;
                    this.selectedHex = null;
                    this.actionHex = null;
                    this.enemyHex = null;
                    this.tmpUnit = null;
                    this.exploitMove = false;
                }
                this.gameState.setGameName(fileName);
            }
            catch (NotSerializableException e) {
                success = false;
            }
        }
        catch (Exception e) {
            success = false;
        }
        if (isScenario) {
            this.gameState.setGameMode(preGameMode);
        }
        this.gameState.resetZoom();
        return success;
    }

    public static String modePath(int gameMode) {
        String ret = "";
        switch (gameMode) {
            case 1000: {
                ret = Global.getSavePath();
                break;
            }
            case 2000: {
                ret = Global.getHotSeatPath();
                break;
            }
            case 4000: {
                ret = Global.getpbemPath();
                break;
            }
            case 3000: {
                ret = Global.gettcpipPath();
                break;
            }
            case 99: {
                ret = Global.getScenarioPath();
            }
        }
        return ret;
    }

    private void endTurn2() {
        this.busy = true;
        boolean hereFirst = true;
        if (this.getGameMode() == 3000 && this.whosTurn() != this.playerSide()) {
            hereFirst = false;
        }
        this.warWindow.disableButtons();
        if (this.getGameMode() != 4000 && hereFirst) {
            this.saveGame(false, false, Game.modePath(this.getGameMode()), "autosave");
        }
        if (this.getGameMode() != 3000 || hereFirst) {
            this.techAdvances();
        }
        if (this.getZoom() == 1) {
            this.changeZoom(true, false, true);
        }
        if (this.getZoom() == 4) {
            this.changeZoom(false, false, true);
        }
        this.resetMapDependancy();
        this.warWindow.showWarMap();
        this.resetScrolling();
        if ((this.getGameMode() != 3000 || hereFirst) && this.whosTurn() == 100) {
            this.convoysProcedure();
        }
        this.busy = true;
        if (this.getGameMode() != 3000) {
            this.partisansProcedure();
        }
        this.updateTransportationLoopsOwnership();
        this.nowShowing = 0;
        this.resetMapDependancy();
        if (!this.timeSystem.getNoTimeLimit()) {
            if (this.whosTurn() == 100) {
                this.timeSystem.addTime(true);
            } else {
                this.timeSystem.addTime(false);
            }
            this.showTimeLeft();
        }
        this.surrenderCheck();
        this.productionUpdate(true);
        this.updateTransportationLoops();
        if (hereFirst && Global.WINTER_DURATION > 0) {
            this.winterEvent(true);
        }
        this.weatherUpdate();
        this.warEntries();
        this.fowProcedure();
        this.incEntrenchments();
        this.updateSupplyLevels(true);
        this.updateEffectiveness(this.whosTurn());
        this.updateRangedCommanders();
        this.resetMovedRaided();
        this.resetHasDeployed();
        this.repairDamagedResources();
        this.resetRailroad();
        this.warWindow.disableButtons();
        this.warWindow.getMiniMap().repaint();
        this.warWindow.oneSlowFrame();
        if (this.getGameMode() == 2000 || this.gameState.getAIvsAI()) {
            this.switchPlayerSide();
        }
        if (this.whosTurn() == 200) {
            this.advanceCalendar();
        }
        this.gameState.incTurn();
        this.warWindow.endTurn();
        this.warWindow.getMiniMap().repaint();
        this.resetScrolling();
        if (this.getGameMode() == 3000 && hereFirst) {
            this.sendDataToOpponent("e");
        }
        this.victoryCheck();
        if (this.playerSide() == this.whosTurn()) {
            this.adjustToolTipManager(this.getTooltips());
        } else {
            this.adjustToolTipManager(false);
        }
        if (this.getGameMode() == 1000) {
            if (this.playerSide() != this.whosTurn()) {
                this.ai.setActive(true);
            } else {
                this.ai.setActive(false);
            }
        } else {
            this.warWindow.getMapCanvas().setAutomaticMoving(false);
        }
        this.endTurnRequested = false;
        if (!this.getGameState().getGameOver()) {
            this.addManpower();
            this.addPP();
            this.addOil();
            this.warWindow.showPP(false);
            if (this.getGameMode() != 4000 && !this.gameState.getAIvsAI() && this.whosTurn() == this.playerSide()) {
                this.warWindow.showBeginTurnDialog();
            }
            this.warWindow.updateAll(true);
            this.gameState.setHasStartedMoving(false);
            if (this.getGameMode() == 4000) {
                this.saveGame(false, false, Game.modePath(this.getGameMode()), this.gameState.getGameName());
                this.getWarWindow().quitToMainMenu();
            }
        }
        this.busy = false;
    }

    public void resetScrolling() {
        this.scrollingRight = 0;
        this.scrollingUp = 0;
        this.upPressed = false;
        this.downPressed = false;
        this.rightPressed = false;
        this.leftPressed = false;
        this.mouseScroll = 0;
        this.oneScrollRight = 0;
        this.oneScrollUp = 0;
    }

    public void setUpPressed(boolean b) {
        this.upPressed = b;
    }

    public void setDownPressed(boolean b) {
        this.downPressed = b;
    }

    public void setRightPressed(boolean b) {
        this.rightPressed = b;
    }

    public void setLeftPressed(boolean b) {
        this.leftPressed = b;
    }

    public void setScrollingUp(int i) {
        this.scrollingUp = i;
        if (this.oneScrollUp == 0) {
            this.oneScrollUp = i;
        }
    }

    public void setScrollingRight(int i) {
        this.scrollingRight = i;
        if (this.oneScrollRight == 0) {
            this.oneScrollRight = i;
        }
    }

    public boolean getLeftPressed() {
        return this.leftPressed;
    }

    public boolean getRightPressed() {
        return this.rightPressed;
    }

    public boolean getUpPressed() {
        return this.upPressed;
    }

    public boolean getDownPressed() {
        return this.downPressed;
    }

    private void techAdvances() {
        int i = 0;
        while (i < this.country.length) {
            if (!this.country[i].isConquered() && this.country[i].getSide() == this.oppositeSide(this.whosTurn())) {
                this.country[i].getResearch().endTurn(this, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1);
            }
            ++i;
        }
    }

    public int shortestPath(int hex1, int hex2) {
        if (!this.insideMap(hex1) || !this.insideMap(hex2)) {
            return 999999;
        }
        int dist = 0;
        int col1 = this.getColumn(hex1);
        int col2 = this.getColumn(hex2);
        int row1 = this.getRow(hex1);
        int row2 = this.getRow(hex2);
        int horizontalDist = Math.abs(col2 - col1);
        int correct = 0;
        if (horizontalDist % 2 != 0) {
            if (col2 % 2 != 0) {
                if (row2 < row1) {
                    correct = 1;
                }
            } else if (row2 > row1) {
                correct = 1;
            }
        }
        int verticalDist = Math.abs(row2 - row1);
        dist = horizontalDist;
        int remainingVertical = (2 * (verticalDist - correct) - horizontalDist + 1) / 2;
        if (remainingVertical > 0) {
            dist += remainingVertical;
        }
        while (hex1 == -988666) {
            if (col2 < col1) {
                if (row2 > row1) {
                    if (col1 % 2 != 0) {
                        ++row1;
                    }
                    --col1;
                    ++dist;
                    continue;
                }
                if (row2 < row1) {
                    if (col1 % 2 == 0) {
                        --row1;
                    }
                    --col1;
                    ++dist;
                    continue;
                }
                --col1;
                ++dist;
                continue;
            }
            if (col2 > col1) {
                if (row2 > row1) {
                    if (col1 % 2 != 0) {
                        ++row1;
                    }
                    ++col1;
                    ++dist;
                    continue;
                }
                if (row2 < row1) {
                    if (col1 % 2 == 0) {
                        --row1;
                    }
                    ++col1;
                    ++dist;
                    continue;
                }
                ++col1;
                ++dist;
                continue;
            }
            if (row2 > row1) {
                ++row1;
                ++dist;
                continue;
            }
            if (row2 >= row1) break;
            --row1;
            ++dist;
        }
        return dist;
    }

    public void ssshowForcePool() {
        int i = 0;
        while (i < this.country.length) {
            this.country[i].getSide();
            this.whosTurn();
            ++i;
        }
    }

    public TimeSystem getTimeSystem() {
        return this.timeSystem;
    }

    public boolean retreatProcedure(Unit attacker, Unit defender, int casualty, int moraleLoss, int roll) {
        boolean ret = false;
        if (attacker.getOnHex() == null) {
            return false;
        }
        if (defender.isLandUnit() && casualty > Global.RETREAT_CASUALTY_THRESHOLD) {
            Hex retreatHex;
            PResource pResource = defender.getOnHex().getPResource();
            Terrain terrain = defender.getOnHex().getTerrain();
            int retreatChance = 0;
            retreatChance = pResource != null ? (pResource instanceof Capital || pResource instanceof City || pResource instanceof Fortress ? 0 : Global.RETREAT_FROM_NON_CLEAR) : (terrain instanceof Clear ? Global.RETREAT_FROM_CLEAR : Global.RETREAT_FROM_NON_CLEAR);
            int underThreshold = Global.RETREAT_REMAINING_EFFICIENCY_THRESHOLD - defender.getMorale();
            retreatChance = underThreshold <= 0 ? 0 : retreatChance * (underThreshold + moraleLoss) / 10;
            if (roll < retreatChance && (retreatHex = this.retreatHex(attacker, defender, roll)) != null) {
                if (defender.getCommander() != null) {
                    defender.getCountry().injureCommander(defender, roll);
                }
                defender.enterHex(retreatHex, false);
                ret = true;
                this.warWindow.oneImmediateFrame();
            }
        }
        return ret;
    }

    private Hex retreatHex(Unit attacker, Unit defender, int roll) {
        Hex attackerHex = attacker.getOnHex();
        int side = defender.getCountry().getSide();
        Hex ret = null;
        int onHex = this.getHexIndex(defender.getOnHex());
        int nHex = this.getNorthHex(onHex);
        int nProb = 100;
        int neHex = this.getNorthEastHex(onHex);
        int neProb = 100;
        int seHex = this.getSouthEastHex(onHex);
        int seProb = 100;
        int sHex = this.getSouthHex(onHex);
        int sProb = 100;
        int swHex = this.getSouthWestHex(onHex);
        int swProb = 100;
        int nwHex = this.getNorthWestHex(onHex);
        int nwProb = 100;
        if (!this.enterable(nHex, 99, defender.getCountry().getCountryIndex(), defender, 0, false, false) || !this.friendlyEmptyLandHex(nHex, side)) {
            nProb -= 1000;
        }
        if (this.shortestPath(this.getHexIndex(attackerHex), nHex) > 1) {
            nProb += 100;
        }
        if (this.enemiesAdjacent(nHex, defender) > 0) {
            nProb -= 10;
        }
        if (!this.enterable(neHex, 99, defender.getCountry().getCountryIndex(), defender, 0, false, false) || !this.friendlyEmptyLandHex(neHex, side)) {
            neProb -= 1000;
        }
        if (this.shortestPath(this.getHexIndex(attackerHex), neHex) > 1) {
            neProb += 100;
        }
        if (this.enemiesAdjacent(neHex, defender) > 0) {
            neProb -= 10;
        }
        if (!this.enterable(seHex, 99, defender.getCountry().getCountryIndex(), defender, 0, false, false) || !this.friendlyEmptyLandHex(seHex, side)) {
            seProb -= 1000;
        }
        if (this.shortestPath(this.getHexIndex(attackerHex), seHex) > 1) {
            seProb += 100;
        }
        if (this.enemiesAdjacent(seHex, defender) > 0) {
            seProb -= 10;
        }
        if (!this.enterable(sHex, 99, defender.getCountry().getCountryIndex(), defender, 0, false, false) || !this.friendlyEmptyLandHex(sHex, side)) {
            sProb -= 1000;
        }
        if (this.shortestPath(this.getHexIndex(attackerHex), sHex) > 1) {
            sProb += 100;
        }
        if (this.enemiesAdjacent(sHex, defender) > 0) {
            sProb -= 10;
        }
        if (!this.enterable(swHex, 99, defender.getCountry().getCountryIndex(), defender, 0, false, false) || !this.friendlyEmptyLandHex(swHex, side)) {
            swProb -= 1000;
        }
        if (this.shortestPath(this.getHexIndex(attackerHex), swHex) > 1) {
            swProb += 100;
        }
        if (this.enemiesAdjacent(swHex, defender) > 0) {
            swProb -= 10;
        }
        if (!this.enterable(nwHex, 99, defender.getCountry().getCountryIndex(), defender, 0, false, false) || !this.friendlyEmptyLandHex(nwHex, side)) {
            nwProb -= 1000;
        }
        if (this.shortestPath(this.getHexIndex(attackerHex), nwHex) > 1) {
            nwProb += 100;
        }
        if (this.enemiesAdjacent(nwHex, defender) > 0) {
            nwProb -= 10;
        }
        Vector<Node> candidates = new Vector<Node>(6, 3);
        Node bestNode = new Node(nHex, nProb, 0);
        candidates.add(bestNode);
        Node tmpNode = new Node(neHex, neProb, 0);
        int compare = bestNode.compare(tmpNode, bestNode);
        if (compare == 1) {
            candidates.removeAllElements();
        }
        if (compare > 0) {
            candidates.add(tmpNode);
            bestNode = tmpNode;
        }
        if ((compare = bestNode.compare(tmpNode = new Node(seHex, seProb, 0), bestNode)) == 1) {
            candidates.removeAllElements();
        }
        if (compare > 0) {
            candidates.add(tmpNode);
            bestNode = tmpNode;
        }
        if ((compare = bestNode.compare(tmpNode = new Node(sHex, sProb, 0), bestNode)) == 1) {
            candidates.removeAllElements();
        }
        if (compare > 0) {
            candidates.add(tmpNode);
            bestNode = tmpNode;
        }
        if ((compare = bestNode.compare(tmpNode = new Node(swHex, swProb, 0), bestNode)) == 1) {
            candidates.removeAllElements();
        }
        if (compare > 0) {
            candidates.add(tmpNode);
            bestNode = tmpNode;
        }
        if ((compare = bestNode.compare(tmpNode = new Node(nwHex, nwProb, 0), bestNode)) == 1) {
            candidates.removeAllElements();
        }
        if (compare > 0) {
            candidates.add(tmpNode);
            bestNode = tmpNode;
        }
        if (candidates.size() > 0) {
            double a = 1001.0;
            double b = candidates.size();
            int selected = (int)((double)roll / (1001.0 / b));
            Node sel = (Node)candidates.get(selected);
            if (sel.getHeuristic() > 0) {
                ret = this.hex[sel.getHex()];
            }
        }
        this.deHighlightdeTargetAll();
        return ret;
    }

    public void productionUpdate(boolean endOfTurn) {
        int i = 0;
        while (i < this.country.length) {
            this.country[i].updateConstructions(endOfTurn);
            ++i;
        }
    }

    private Unit interceptor(Hex attackHex, Hex defenceHex) {
        Vector<Unit> candidates = new Vector<Unit>(1, 1);
        Unit inter = null;
        int attackSide = attackHex.getUnit().getCountry().getSide();
        if (!(defenceHex.getUnit() instanceof Fighter) && !(defenceHex.getUnit() instanceof Carrier)) {
            int i = 0;
            while (i < this.hex.length) {
                Unit tmp = this.hex[i].getUnit();
                if (tmp != null && tmp.canIntercept() && !tmp.getHasMoved() && attackSide != tmp.getCountry().getSide() && tmp.getCountry().getAtWar() && (double)tmp.getStrength() >= 0.5 * (double)tmp.maxStrength() && this.shortestPath(this.getHexIndex(tmp.getOnHex()), this.getHexIndex(defenceHex)) <= tmp.getAttackRange()) {
                    candidates.add(tmp);
                }
                ++i;
            }
        }
        if (candidates.size() > 0) {
            double maxRnd = 0.0;
            int j = 0;
            while (j < candidates.size()) {
                maxRnd += ((Unit)candidates.get(j)).getLandInfluence();
                ++j;
            }
            maxRnd = Math.max(1.0, maxRnd / (double)candidates.size());
            int[] score = new int[candidates.size()];
            int k = 0;
            while (k < candidates.size()) {
                score[k] = (int)((Unit)candidates.get(k)).getLandInfluence() + XRandAndCalc.rand((int)maxRnd);
                ++k;
            }
            inter = (Unit)candidates.get(Game.indexOfHighestInt(score, null));
        }
        return inter;
    }

    public void createRolls(int[] roll) {
        int i = 0;
        while (i < roll.length) {
            roll[i] = XRandAndCalc.rand(1000);
            ++i;
        }
    }

    public OddsAndPenalties airDuelBattleOdds(Hex attackHex, Hex defenceHex) {
        Unit attacker = attackHex.getUnit();
        Unit defender = defenceHex.getUnit();
        double attackFire = 0.0;
        double defenceFire = 0.0;
        attackFire = attacker.getAirCombat();
        defenceFire = defender.getAirCombat();
        attackFire = (double)Global.AIR_DUEL_CASUALTY_FACTOR * attackFire * (double)attacker.getMorale() / (double)(100 * Math.max(1, defender.getSurvivability()));
        defenceFire = (double)Global.AIR_DUEL_CASUALTY_FACTOR * defenceFire * (double)defender.getMorale() / (double)(100 * Math.max(1, attacker.getSurvivability()));
        OddsAndPenalties odds = new OddsAndPenalties(attackFire, defenceFire, attackFire * (double)Game.strengthFactor(attacker.getStrength()), defenceFire * (double)Game.strengthFactor(defender.getStrength()), 1.0, 1.0, 1.0, attacker.getCountryIndex(), defender.getCountryIndex());
        return odds;
    }

    public boolean resolveAirDuelBattle(Hex attackHex, Hex defenceHex, boolean battleHereFirst, int[] shockRolls, int[] attackFireRolls, int[] defenceFireRolls) {
        this.setTutorialMessage(16);
        attackHex.setAlliesFOW(false);
        attackHex.setAxisFOW(false);
        defenceHex.setAlliesFOW(false);
        defenceHex.setAxisFOW(false);
        attackHex.getUnit().setHasMoved(true);
        defenceHex.getUnit().setHasMoved(true);
        Unit attacker = attackHex.getUnit();
        Unit defender = defenceHex.getUnit();
        attacker.setInvisible(false);
        defender.setInvisible(false);
        this.actionHex = attackHex;
        this.enemyHex = defenceHex;
        this.warWindow.oneImmediateFrame();
        this.enemyHex = null;
        this.actionHex = null;
        if (this.getSoundEffect()) {
            this.playAudioFileAndWait(String.valueOf(Global.getSoundPath()) + "fighter_attack_" + XRandAndCalc.randZero(0) + ".wav");
        }
        double attackFire = 0.0;
        double defenceFire = 0.0;
        OddsAndPenalties odds = this.airDuelBattleOdds(attackHex, defenceHex);
        attackFire = odds.getAttackerHitRate();
        defenceFire = odds.getDefenderHitRate();
        int[] shockRolls2 = new int[30];
        if (shockRolls[0] != 0) {
            shockRolls2 = shockRolls;
        } else {
            this.createRolls(shockRolls2);
        }
        int[] defenceFireRolls2 = new int[30];
        if (defenceFireRolls[0] != 0) {
            defenceFireRolls2 = defenceFireRolls;
        } else {
            this.createRolls(defenceFireRolls2);
        }
        int[] attackFireRolls2 = new int[30];
        if (attackFireRolls[0] != 0) {
            attackFireRolls2 = attackFireRolls;
        } else {
            this.createRolls(attackFireRolls2);
        }
        int defenderPreStrength = defender.getStrength();
        int attackerPreStrength = attacker.getStrength();
        int defenderPreMorale = defender.getMorale();
        int attackerPreMorale = attacker.getMorale();
        int attackerCasualty = this.fireAttack(defenderPreStrength, (int)defenceFire, defenceFireRolls2);
        int defenderCasualty = this.fireAttack(attackerPreStrength, (int)attackFire, attackFireRolls2);
        int val1 = 0;
        int val2 = 0;
        int val3 = 0;
        int val4 = 0;
        int val5 = 0;
        int val6 = 0;
        val1 = this.getHexIndex(attacker.getOnHex());
        val4 = this.getHexIndex(defender.getOnHex());
        defender.casualties(defenderCasualty, false, defenceFireRolls2);
        val5 = defenderPreStrength - defender.getStrength();
        val6 = defenderPreMorale - defender.getMorale();
        defender.killedProcedure(attackFireRolls2[29], true);
        attacker.casualties(attackerCasualty, false, attackFireRolls2);
        val2 = attackerPreStrength - attacker.getStrength();
        val3 = attackerPreMorale - attacker.getMorale();
        attacker.killedProcedure(defenceFireRolls2[29], true);
        attacker.incExperience(15);
        defender.incExperience(15);
        attacker.getCountry().changeOil(-attacker.getOilConsumption());
        defender.getCountry().changeOil(-defender.getOilConsumption());
        this.warWindow.getMapCanvas().setDamages(val1, val2, val3, 2, val4, val5, val6, 2);
        if (battleHereFirst && this.getGameMode() == 3000) {
            String s = "i ";
            s = String.valueOf(s) + this.getHexIndex(attackHex) + " " + this.getHexIndex(defenceHex) + " ";
            int i = 0;
            while (i < 30) {
                s = String.valueOf(s) + shockRolls2[i] + " ";
                ++i;
            }
            i = 0;
            while (i < 30) {
                s = String.valueOf(s) + attackFireRolls2[i] + " ";
                ++i;
            }
            i = 0;
            while (i < 30) {
                s = String.valueOf(s) + defenceFireRolls2[i] + " ";
                ++i;
            }
            this.sendDataToOpponent(s);
        } else {
            this.warWindow.oneSlowFrame();
        }
        return false;
    }

    public OddsAndPenalties strategicBattleOdds(Hex attackHex, Hex defenceHex) {
        PResource pResource = defenceHex.getPResource();
        Unit attacker = attackHex.getUnit();
        double attackFire = 0.0;
        double defenceFire = 0.0;
        Country country = this.country[defenceHex.getOwningCountry()];
        attackFire = attacker.getStrategicAttack();
        defenceFire = pResource.getAirCombat(country);
        attackFire = (double)Global.STRATEGIC_CASUALTY_FACTOR * attackFire * (double)attacker.getMorale() / (double)(100 * pResource.getSurvivability(country));
        defenceFire = (double)Global.STRATEGIC_CASUALTY_FACTOR * defenceFire * (double)pResource.getMorale() / (double)(100 * Math.max(1, attacker.getSurvivability()));
        OddsAndPenalties odds = new OddsAndPenalties(attackFire, defenceFire, attackFire * (double)Game.strengthFactor(attacker.getStrength()), defenceFire * (double)Game.strengthFactor(pResource.getStrength()), 1.0, 1.0, 1.0, attacker.getCountryIndex(), defenceHex.getOwningCountry());
        return odds;
    }

    public void resolveStrategicBattle(Hex attackHex, Hex defenceHex, boolean battleHereFirst, int[] shockRolls, int[] attackFireRolls, int[] defenceFireRolls) {
        attackHex.setAlliesFOW(false);
        attackHex.setAxisFOW(false);
        defenceHex.setAlliesFOW(false);
        defenceHex.setAxisFOW(false);
        if (this.getGameMode() == 4000 || this.getGameMode() == 2000) {
            defenceHex.setBattleState(1);
        }
        PResource pResource = defenceHex.getPResource();
        Unit attacker = attackHex.getUnit();
        double attackFire = 0.0;
        double defenceFire = 0.0;
        OddsAndPenalties odds = this.strategicBattleOdds(attackHex, defenceHex);
        attackFire = odds.getAttackerHitRate();
        defenceFire = odds.getDefenderHitRate();
        int[] shockRolls2 = new int[30];
        if (shockRolls[0] != 0) {
            shockRolls2 = shockRolls;
        } else {
            this.createRolls(shockRolls2);
        }
        int[] defenceFireRolls2 = new int[30];
        if (defenceFireRolls[0] != 0) {
            defenceFireRolls2 = defenceFireRolls;
        } else {
            this.createRolls(defenceFireRolls2);
        }
        int[] attackFireRolls2 = new int[30];
        if (attackFireRolls[0] != 0) {
            attackFireRolls2 = attackFireRolls;
        } else {
            this.createRolls(attackFireRolls2);
        }
        int defenderPreStrength = pResource.getStrength();
        int attackerPreStrength = attacker.getStrength();
        int attackerPreMorale = attacker.getMorale();
        int val1 = 0;
        int val2 = 0;
        int val3 = 0;
        int val4 = 0;
        int val5 = 0;
        int val6 = 0;
        val1 = this.getHexIndex(attacker.getOnHex());
        val4 = this.getHexIndex(defenceHex);
        int attackerCasualty = this.fireAttack(pResource.getStrength(), (int)defenceFire, defenceFireRolls2);
        attacker.casualties(attackerCasualty, false, attackFireRolls2);
        val2 = attackerPreStrength - attacker.getStrength();
        val3 = attackerPreMorale - attacker.getMorale();
        attacker.killedProcedure(attackFireRolls2[29], true);
        if (!attacker.isDead()) {
            int defenderCasualty = this.fireAttack(attacker.getStrength(), (int)attackFire, attackFireRolls2);
            pResource.casualties(defenderCasualty);
            val5 = defenderPreStrength - pResource.getStrength();
            val6 = 0;
        }
        attacker.incExperience(4);
        attacker.getCountry().changeOil(-attacker.getOilConsumption());
        this.warWindow.clearLeft();
        this.warWindow.clearRight();
        if (attackHex.getUnit() != null) {
            attackHex.getUnit().setHasMoved(true);
        }
        this.warWindow.getMapCanvas().setDamages(val1, val2, val3, 2, val4, val5, val6, 1);
        if (battleHereFirst && this.getGameMode() == 3000) {
            String s = "a ";
            s = String.valueOf(s) + this.getHexIndex(attackHex) + " " + this.getHexIndex(defenceHex) + " ";
            int i = 0;
            while (i < 30) {
                s = String.valueOf(s) + shockRolls2[i] + " ";
                ++i;
            }
            i = 0;
            while (i < 30) {
                s = String.valueOf(s) + attackFireRolls2[i] + " ";
                ++i;
            }
            i = 0;
            while (i < 30) {
                s = String.valueOf(s) + defenceFireRolls2[i] + " ";
                ++i;
            }
            s = String.valueOf(s) + "0 ";
            s = String.valueOf(s) + "0 ";
            this.sendDataToOpponent(s);
        } else {
            this.warWindow.oneSlowFrame();
        }
    }

    public static int strengthFactor(int strength) {
        return strength + Global.EXTRA_ATTACKS;
    }

    public OddsAndPenalties unitBattleOdds(Hex attackHex, Hex defenceHex) {
        Unit attacker = attackHex.getUnit();
        Unit defender = defenceHex.getUnit();
        double attackFire = 0.0;
        double defenceFire = 0.0;
        PResource pResource = defenceHex.getPResource();
        Terrain terrain = defenceHex.getTerrain();
        if (defender instanceof GroundUnit) {
            attackFire = attacker.getGroundAttack();
        } else if (defender instanceof NavalUnit) {
            attackFire = attacker instanceof GroundUnit ? (double)attacker.getGroundAttack() : (defender instanceof Sub ? (double)attacker.getSubCombat() : (double)attacker.getNavalCombat());
        } else if (defender instanceof AirUnit) {
            attackFire = attacker instanceof GroundUnit ? (double)attacker.getGroundAttack() : (double)attacker.getAirCombat();
        }
        if (attacker instanceof GroundUnit) {
            defenceFire = defender.getGroundDefence();
        } else if (attacker instanceof AirUnit) {
            defenceFire = defender.getAirCombat();
        } else if (attacker instanceof Sub) {
            defenceFire = defender.getSubCombat();
        } else if (attacker instanceof NavalUnit) {
            defenceFire = defender.getNavalCombat();
        }
        if (attacker.hasAirDuelCapacity() && defender.getAirCombat() == 0) {
            defenceFire = 0.0;
        }
        int attackerSurv = attacker.getSurvivability();
        int defenderSurv = defender.getSurvivability();
        if (defender instanceof Armour || defender instanceof HeavyTank) {
            defenderSurv -= attacker.getAntiTankBonus();
        }
        if (attacker instanceof Armour || attacker instanceof HeavyTank) {
            attackerSurv -= defender.getAntiTankBonus();
        }
        double riverEfficiency = 1.0;
        double terrainEfficiency = 1.0;
        double entrenchmentEfficiency = 1.0;
        if (attacker instanceof GroundUnit && this.crossingRiver(this.getHexIndex(attackHex), this.getHexIndex(defenceHex))) {
            riverEfficiency = TerrainPenalties.getRiverAttackEfficiency();
            attackFire *= riverEfficiency;
            if (attacker.isArmour()) {
                attackFire *= TerrainPenalties.getRiverArmourEfficiency();
            }
        }
        if (defender.getEntrenchment() > 0) {
            entrenchmentEfficiency = TerrainPenalties.getEntrenchmentAttackEfficiency();
            attackFire *= entrenchmentEfficiency;
            if (attacker.isArmour()) {
                attackFire *= TerrainPenalties.getEntrenchmentArmourEfficiency();
            }
        }
        if (pResource != null) {
            if (attacker.isArmour()) {
                attackFire *= pResource.getTankPenaltyModifier();
            }
            if (defender.isArmour()) {
                defenceFire *= pResource.getTankPenaltyModifier();
            }
            terrainEfficiency = pResource.getDefenceBonusModifier();
            attackFire *= terrainEfficiency;
        } else if (terrain != null) {
            if (attacker.isArmour()) {
                attackFire *= terrain.getTankPenaltyModifier();
            }
            if (defender.isArmour()) {
                defenceFire *= terrain.getTankPenaltyModifier();
            }
            terrainEfficiency = terrain.getDefenceBonusModifier();
            attackFire *= terrainEfficiency;
        }
        defenceFire = defenceFire * (double)defender.getMorale() * (double)Global.CASUALTY_FACTOR / (double)(100 * Math.max(1, attackerSurv));
        attackFire = attackFire * (double)attacker.getMorale() * (double)Global.CASUALTY_FACTOR / (double)(100 * Math.max(1, defenderSurv));
        return new OddsAndPenalties(attackFire, defenceFire, attackFire * (double)Game.strengthFactor(attacker.getStrength()), defenceFire * (double)Game.strengthFactor(defender.getStrength()), riverEfficiency, terrainEfficiency, entrenchmentEfficiency, attacker.getCountryIndex(), defender.getCountryIndex());
    }

    public boolean resolveUnitBattle(Hex attackHex, Hex defenceHex, boolean battleHereFirst, int[] shockRolls, int[] attackFireRolls, int[] defenceFireRolls, int retreatSurrenderRoll, boolean defenderSurprised) {
        boolean ret = false;
        PResource pResource = defenceHex.getPResource();
        Terrain terrain = defenceHex.getTerrain();
        Unit attacker = attackHex.getUnit();
        Unit defender = defenceHex.getUnit();
        defender.setFOWed(false);
        if (this.getGameMode() == 4000 || this.getGameMode() == 2000) {
            defenceHex.setBattleState(1);
        }
        double attackFire = 0.0;
        double defenceFire = 0.0;
        double shockAttack = 0.0;
        shockAttack = attacker.getShockAttack();
        if (defender instanceof GroundUnit) {
            attackFire = attacker.getGroundAttack();
        } else if (defender instanceof NavalUnit) {
            attackFire = attacker instanceof GroundUnit ? (double)attacker.getGroundAttack() : (defender instanceof Sub ? (double)attacker.getSubCombat() : (double)attacker.getNavalCombat());
        } else if (defender instanceof AirUnit) {
            attackFire = attacker instanceof GroundUnit ? (double)attacker.getGroundAttack() : (double)attacker.getAirCombat();
        }
        if (attacker instanceof GroundUnit) {
            defenceFire = defender.getGroundDefence();
        } else if (attacker instanceof AirUnit) {
            defenceFire = defender.getAirCombat();
        } else if (attacker instanceof Sub) {
            defenceFire = defender.getSubCombat();
        } else if (attacker instanceof NavalUnit) {
            defenceFire = defender.getNavalCombat();
        }
        if (attacker.hasAirDuelCapacity() && defender.getAirCombat() == 0) {
            defenceFire = 0.0;
        }
        int attackerSurv = attacker.getSurvivability();
        int defenderSurv = defender.getSurvivability();
        if (defender instanceof Armour || defender instanceof HeavyTank) {
            defenderSurv -= attacker.getAntiTankBonus();
        }
        if (attacker instanceof Armour || attacker instanceof HeavyTank) {
            attackerSurv -= defender.getAntiTankBonus();
        }
        if (attacker instanceof GroundUnit && this.crossingRiver(this.getHexIndex(attackHex), this.getHexIndex(defenceHex))) {
            attackFire *= TerrainPenalties.getRiverAttackEfficiency();
            shockAttack *= TerrainPenalties.getRiverAttackEfficiency();
            if (attacker.isArmour()) {
                attackFire *= TerrainPenalties.getRiverArmourEfficiency();
                shockAttack *= TerrainPenalties.getRiverArmourEfficiency();
            }
        }
        if (defender.getEntrenchment() > 0) {
            attackFire *= TerrainPenalties.getEntrenchmentAttackEfficiency();
            shockAttack *= TerrainPenalties.getEntrenchmentAttackEfficiency();
            if (attacker.isArmour()) {
                attackFire *= TerrainPenalties.getEntrenchmentArmourEfficiency();
                shockAttack *= TerrainPenalties.getEntrenchmentArmourEfficiency();
            }
        }
        if (pResource != null) {
            if (attacker.isArmour()) {
                attackFire *= pResource.getTankPenaltyModifier();
            }
            if (defender.isArmour()) {
                defenceFire *= pResource.getTankPenaltyModifier();
            }
            shockAttack *= pResource.getDefenceBonusModifier();
            attackFire *= pResource.getDefenceBonusModifier();
        } else if (terrain != null) {
            if (attacker.isArmour()) {
                attackFire *= terrain.getTankPenaltyModifier();
            }
            if (defender.isArmour()) {
                defenceFire *= terrain.getTankPenaltyModifier();
            }
            shockAttack *= terrain.getDefenceBonusModifier();
            attackFire *= terrain.getDefenceBonusModifier();
        }
        int defenderPreStrength = defender.getStrength();
        int defenderPreMorale = defender.getMorale();
        int attackerPreStrength = attacker.getStrength();
        int attackerPreMorale = attacker.getMorale();
        shockAttack = shockAttack * (double)attacker.getMorale() * (double)Global.SHOCK_FACTOR / (double)(100 * Math.max(1, defenderSurv));
        int[] shockRolls2 = new int[30];
        if (shockRolls[0] != 0) {
            shockRolls2 = shockRolls;
        } else {
            this.createRolls(shockRolls2);
        }
        int[] defenceFireRolls2 = new int[30];
        if (defenceFireRolls[0] != 0) {
            defenceFireRolls2 = defenceFireRolls;
        } else {
            this.createRolls(defenceFireRolls2);
        }
        int[] attackFireRolls2 = new int[30];
        if (attackFireRolls[0] != 0) {
            attackFireRolls2 = attackFireRolls;
        } else {
            this.createRolls(attackFireRolls2);
        }
        int retreatSurrenderRoll2 = 0;
        retreatSurrenderRoll2 = retreatSurrenderRoll != -1 ? retreatSurrenderRoll : XRandAndCalc.rand(1000);
        if (defender instanceof GroundUnit) {
            int defenderShocked = this.shockAttack(attacker.getStrength(), (int)shockAttack, shockRolls2);
            defender.moraleShock(defenderShocked);
        }
        int val1 = 0;
        int val2 = 0;
        int val3 = 0;
        int val4 = 0;
        int val5 = 0;
        int val6 = 0;
        val1 = this.getHexIndex(attacker.getOnHex());
        val4 = this.getHexIndex(defender.getOnHex());
        if (attacker instanceof NavalUnit && defender instanceof NavalUnit) {
            attackFire = attackFire * (double)attacker.getMorale() * (double)Global.CASUALTY_FACTOR / (double)(100 * Math.max(1, defenderSurv));
            int defenderCasualty = this.fireAttack(attacker.getStrength(), (int)attackFire, attackFireRolls2);
            defender.casualties(defenderCasualty, true, defenceFireRolls2);
            val5 = defenderPreStrength - defender.getStrength();
            val6 = defenderPreMorale - defender.getMorale();
            defender.killedProcedure(defenceFireRolls2[29], true);
            if (!defender.isDead()) {
                defenceFire = defenceFire * (double)defender.getMorale() * (double)Global.CASUALTY_FACTOR / (double)(100 * Math.max(1, attackerSurv));
                if (defender instanceof GroundUnit && defenderSurprised) {
                    defenceFire = 0.0;
                }
                int attackerCasualty = this.fireAttack(defender.getStrength(), (int)defenceFire, defenceFireRolls2);
                attacker.casualties(attackerCasualty, false, attackFireRolls2);
                val2 = attackerPreStrength - attacker.getStrength();
                val3 = attackerPreMorale - attacker.getMorale();
                attacker.killedProcedure(attackFireRolls2[29], true);
            }
        } else {
            defenceFire = defenceFire * (double)defender.getMorale() * (double)Global.CASUALTY_FACTOR / (double)(100 * Math.max(1, attackerSurv));
            if (defender instanceof GroundUnit && defenderSurprised) {
                defenceFire = 0.0;
            }
            int attackerCasualty = this.fireAttack(defender.getStrength(), (int)defenceFire, defenceFireRolls2);
            attacker.casualties(attackerCasualty, false, attackFireRolls2);
            val2 = attackerPreStrength - attacker.getStrength();
            val3 = attackerPreMorale - attacker.getMorale();
            attacker.killedProcedure(attackFireRolls2[29], true);
            if (!attacker.isDead()) {
                attackFire = attackFire * (double)attacker.getMorale() * (double)Global.CASUALTY_FACTOR / (double)(100 * Math.max(1, defenderSurv));
                int defenderCasualty = this.fireAttack(attacker.getStrength(), (int)attackFire, attackFireRolls2);
                defender.casualties(defenderCasualty, true, defenceFireRolls2);
                val5 = defenderPreStrength - defender.getStrength();
                val6 = defenderPreMorale - defender.getMorale();
                defender.killedProcedure(defenceFireRolls2[29], true);
            }
        }
        attacker.incExperience(6);
        defender.incExperience(4);
        attacker.getCountry().changeOil(-attacker.getOilConsumption());
        this.warWindow.clearLeft();
        this.warWindow.clearRight();
        if (attackHex.getUnit() != null) {
            attackHex.getUnit().setHasMoved(true);
        }
        boolean exploit = false;
        if (attacker.getStrength() > 0 && attacker instanceof GroundUnit && defender.isLandUnit()) {
            int defenderStrength = defender.getStrength();
            if (defenderStrength > 0) {
                exploit = this.retreatProcedure(attacker, defender, defenderPreStrength - defenderStrength, defenderPreMorale - defender.getMorale(), retreatSurrenderRoll2);
            }
            if (defenderStrength <= 0) {
                exploit = true;
            }
            if (exploit) {
                this.tmpUnit = attacker;
                if (defender.getOnHex() != null) {
                    val4 = this.getHexIndex(defender.getOnHex());
                }
            }
            ret = exploit;
        }
        this.warWindow.getMapCanvas().setDamages(val1, val2, val3, 2, val4, val5, val6, 2);
        if (battleHereFirst && this.getGameMode() == 3000) {
            String s = "a ";
            s = String.valueOf(s) + this.getHexIndex(attackHex) + " " + this.getHexIndex(defenceHex) + " ";
            int i = 0;
            while (i < 30) {
                s = String.valueOf(s) + shockRolls2[i] + " ";
                ++i;
            }
            i = 0;
            while (i < 30) {
                s = String.valueOf(s) + attackFireRolls2[i] + " ";
                ++i;
            }
            i = 0;
            while (i < 30) {
                s = String.valueOf(s) + defenceFireRolls2[i] + " ";
                ++i;
            }
            s = String.valueOf(s) + retreatSurrenderRoll2 + " ";
            int surprise = 0;
            if (defenderSurprised) {
                surprise = 1;
            }
            s = String.valueOf(s) + surprise + " ";
            this.sendDataToOpponent(s);
        } else {
            this.warWindow.oneSlowFrame();
        }
        defender.decEntrenchment();
        return ret;
    }

    public void pauseIfNeeded(long millis, boolean hereFirst) {
        if (this.warWindow != null) {
            this.showTimeLeft();
        }
        if (!hereFirst || this.getGameMode() == 1000 && this.whosTurn() != this.playerSide()) {
            Game.delay(millis);
        } else if (this.warWindow.getMapCanvas().getAutomaticMoving()) {
            Game.delay(millis);
        }
    }

    public boolean resolveBattle(Hex attackHex, Hex defenceHex, boolean hereFirst, boolean defenderSurprised) {
        if (!this.gameState.getHasStartedMoving()) {
            this.gameState.setHasStartedMoving(true);
            this.resetReplaySymbols();
        }
        int[] shock = new int[1];
        int[] attack = new int[1];
        int[] defence = new int[1];
        return this.resolveBattle(attackHex, defenceHex, hereFirst, shock, attack, defence, -1, defenderSurprised);
    }

    private int shockAttack(int strength, int shockValue, int[] shockRolls) {
        int hits = 0;
        int hits2 = 0;
        int i = 0;
        while (i < strength + Global.EXTRA_ATTACKS) {
            if (shockRolls[i] <= shockValue) {
                ++hits;
            }
            ++i;
        }
        int j = strength + Global.EXTRA_ATTACKS;
        while (j < 2 * strength + 2 * Global.EXTRA_ATTACKS) {
            if (shockRolls[j] <= shockValue) {
                ++hits2;
            }
            ++j;
        }
        int hits3 = hits + hits2;
        if (hits3 % 2 != 0) {
            hits3 = shockRolls[0] < 500 ? ++hits3 : --hits3;
        }
        int hits4 = hits3 / 2;
        return hits4;
    }

    private int fireAttack(int strengt, int fireValue, int[] fireRolls) {
        int hits = 0;
        int hits2 = 0;
        int attacks = Math.min(strengt + Global.EXTRA_ATTACKS, fireRolls.length / 2);
        int i = 0;
        while (i < attacks) {
            if (fireRolls[i] <= fireValue) {
                ++hits;
            }
            ++i;
        }
        int j = attacks;
        while (j < 2 * attacks) {
            if (fireRolls[j] <= fireValue) {
                ++hits2;
            }
            ++j;
        }
        int hits3 = hits + hits2;
        if (hits3 % 2 != 0) {
            hits3 = fireRolls[fireRolls.length - 1] < 500 ? ++hits3 : --hits3;
        }
        int hits4 = hits3 / 2;
        return hits4;
    }

    public int evacuateHex(int maxDist, Unit u) {
        int ret = -1;
        int unitHex = this.getHexIndex(u.getOnHex());
        this.highlightAroundUnit(unitHex, maxDist, false);
        Vector<Integer> candidates = new Vector<Integer>(5, 1);
        int i = 0;
        while (i < this.hex.length) {
            if (this.hex[i].getHighlighted() && this.shortestPath(i, unitHex) <= maxDist) {
                if (u.getOnHex() instanceof WaterHex) {
                    if (!(this.hex[i] instanceof LoopHex) && !(this.hex[i] instanceof LoopHex2) && this.hex[i] instanceof WaterHex) {
                        candidates.add(new Integer(i));
                    }
                } else if (u.getOnHex() instanceof LandHex && this.hex[i] instanceof LandHex) {
                    candidates.add(new Integer(i));
                }
            }
            ++i;
        }
        if (candidates.size() > 0) {
            int index = XRandAndCalc.rand(candidates.size()) - 1;
            ret = (Integer)candidates.get(index);
        }
        this.deHighlightdeTargetAll();
        return ret;
    }

    public boolean isStrategicBattle(Hex attackHex, Hex defenceHex) {
        Unit attacker = attackHex.getUnit();
        Unit defender = defenceHex.getUnit();
        boolean ret = defender == null ? true : defenceHex.getPResource() != null && attacker instanceof StrategicBomber;
        return ret;
    }

    public boolean resolveBattle(Hex attackHex, Hex defenceHex, boolean hereFirst, int[] shockRolls, int[] attackRolls, int[] defenceRolls, int retreatSurrenderRoll, boolean defenderSurprised) {
        boolean ret = false;
        this.busy = true;
        attackHex.setAlliesFOW(false);
        attackHex.setAxisFOW(false);
        defenceHex.setAlliesFOW(false);
        defenceHex.setAxisFOW(false);
        attackHex.getUnit().setInvisible(false);
        if (defenceHex.getUnit() != null) {
            defenceHex.getUnit().setSentry(false);
            defenceHex.getUnit().setHasMoved(true);
            defenceHex.getUnit().setInvisible(false);
        }
        attackHex.getUnit().setSentry(false);
        attackHex.getUnit().setHasMoved(true);
        Unit interceptor = null;
        if (hereFirst && (attackHex.getUnit() instanceof AirUnit || attackHex.getUnit() instanceof Carrier)) {
            interceptor = this.interceptor(attackHex, defenceHex);
        }
        if (interceptor != null) {
            Unit escort = null;
            if (attackHex.getUnit() instanceof StrategicBomber || attackHex.getUnit() instanceof TacticalBomber) {
                escort = this.interceptor(interceptor.getOnHex(), defenceHex);
            }
            if (escort != null) {
                this.centerOnBattleIfNeeded(this.getHexIndex(escort.getOnHex()), this.getHexIndex(interceptor.getOnHex()));
                this.resolveAirDuelBattle(escort.getOnHex(), interceptor.getOnHex(), hereFirst, shockRolls, attackRolls, defenceRolls);
            } else {
                this.centerOnBattleIfNeeded(this.getHexIndex(interceptor.getOnHex()), this.getHexIndex(attackHex));
                this.resolveAirDuelBattle(interceptor.getOnHex(), attackHex, hereFirst, attackRolls, shockRolls, defenceRolls);
            }
            this.warWindow.oneImmediateFrame();
            Game.delay(1500L);
        }
        this.centerOnBattleIfNeeded(this.getHexIndex(attackHex), this.getHexIndex(defenceHex));
        this.pauseIfNeeded(400L, hereFirst);
        if (attackHex.getUnit() != null) {
            Unit attacker = attackHex.getUnit();
            Unit defender = defenceHex.getUnit();
            attacker.setFOWed(false);
            this.actionHex = attackHex;
            this.enemyHex = defenceHex;
            this.warWindow.oneImmediateFrame();
            this.enemyHex = null;
            this.actionHex = null;
            boolean dogFight = false;
            if (defenceHex.getPResource() != null && attacker instanceof StrategicBomber && defender instanceof StrategicBomber) {
                dogFight = false;
            } else if (defender != null && attacker.hasAirDuelCapacity() && defender.hasAirDuelCapacity()) {
                dogFight = true;
            }
            if (dogFight) {
                ret = this.resolveAirDuelBattle(attackHex, defenceHex, hereFirst, shockRolls, attackRolls, defenceRolls);
            } else {
                if (attacker instanceof Garrison) {
                    this.playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "infantry_attack_" + XRandAndCalc.randZero(2) + ".wav", 2, false);
                } else if (attacker instanceof Corps) {
                    this.playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "infantry_attack_" + XRandAndCalc.randZero(2) + ".wav", 2, false);
                } else if (attacker instanceof MotorisedCorps) {
                    this.playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "infantry_attack_" + XRandAndCalc.randZero(2) + ".wav", 2, false);
                } else if (attacker instanceof Armour) {
                    this.playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "armour_attack_" + XRandAndCalc.randZero(1) + ".wav", 2, false);
                } else if (attacker instanceof Fighter) {
                    this.playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "fighter_attack_" + XRandAndCalc.randZero(0) + ".wav", 2, false);
                } else if (attacker instanceof TacticalBomber) {
                    this.playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "tactical_bomber_attack_" + XRandAndCalc.randZero(0) + ".wav", 2, false);
                } else if (attacker instanceof StrategicBomber) {
                    this.playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "strategic_bomber_attack_" + XRandAndCalc.randZero(0) + ".wav", 2, false);
                } else if (attacker instanceof Sub) {
                    this.playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "sub_attack_" + XRandAndCalc.randZero(0) + ".wav", 2, false);
                } else if (attacker instanceof Destroyer) {
                    this.playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "ship_attack_" + XRandAndCalc.randZero(0) + ".wav", 2, false);
                } else if (attacker instanceof Battleship) {
                    this.playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "ship_attack_" + XRandAndCalc.randZero(0) + ".wav", 2, false);
                } else if (attacker instanceof Carrier) {
                    this.playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "ship_attack_" + XRandAndCalc.randZero(0) + ".wav", 2, false);
                }
                Game.delay(700L);
                if (defender == null) {
                    this.resolveStrategicBattle(attackHex, defenceHex, hereFirst, shockRolls, attackRolls, defenceRolls);
                } else if (defenceHex.getPResource() != null && attacker instanceof StrategicBomber) {
                    this.resolveStrategicBattle(attackHex, defenceHex, hereFirst, shockRolls, attackRolls, defenceRolls);
                } else {
                    ret = this.resolveUnitBattle(attackHex, defenceHex, hereFirst, shockRolls, attackRolls, defenceRolls, retreatSurrenderRoll, defenderSurprised);
                }
            }
            if (defenceHex.getTmpUnit() != null) {
                if (defenceHex.getUnit() != null) {
                    int tmp = this.getEmptyAdjacentWaterHex(this.getHexIndex(defenceHex), false);
                    if (tmp != -1) {
                        defenceHex.getUnit().enterHex(this.getHex(tmp), false);
                    }
                } else {
                    defenceHex.activeTempUnit();
                }
            }
        }
        this.pauseIfNeeded(1000L, hereFirst);
        this.busy = false;
        if (ret) {
            this.setTutorialMessage(9);
        }
        return ret;
    }

    public OddsAndPenalties expectedOdds(Hex attackHex, Hex defenceHex) {
        Unit attacker = attackHex.getUnit();
        Unit defender = defenceHex.getUnit();
        OddsAndPenalties odds = defender == null || !this.canSeeUnit(defender, attackHex.getUnit().getSide()) ? this.strategicBattleOdds(attackHex, defenceHex) : (attacker.hasAirDuelCapacity() && defender.hasAirDuelCapacity() ? this.airDuelBattleOdds(attackHex, defenceHex) : this.unitBattleOdds(attackHex, defenceHex));
        return odds;
    }

    public Point northwestHexEdge(int hexIndex) {
        int xGrid = hexIndex / 72;
        int yGrid = hexIndex - xGrid * 72;
        double xPos = 0.0;
        double yPos = 0.0;
        xPos = 0.5 * (double)xGrid * 10.0 * (double)this.getZoom() + 0.5 * (double)xGrid * 20.0 * (double)this.getZoom();
        yPos = (double)(yGrid * 16 * this.getZoom()) - 8.0 * (double)this.getZoom();
        if (xGrid % 2 == 1) {
            yPos += 8.0 * (double)this.getZoom();
        }
        Point p = new Point((int)xPos, (int)yPos);
        return p;
    }

    public Point northwestQuadraticCorner(int hexIndex) {
        int xGrid = hexIndex / 72;
        int yGrid = hexIndex - xGrid * 72;
        double xPos = 0.0;
        double yPos = 0.0;
        xPos = 0.5 * (double)xGrid * 10.0 * (double)this.getZoom() + 0.5 * (double)xGrid * 20.0 * (double)this.getZoom() - 5.0 * (double)this.getZoom();
        yPos = (double)(yGrid * 16 * this.getZoom()) - 8.0 * (double)this.getZoom();
        if (xGrid % 2 == 1) {
            yPos += 8.0 * (double)this.getZoom();
        }
        Point p = new Point((int)xPos, (int)yPos);
        return p;
    }

    public Point centreOfHex(int hexIndex) {
        Point p = this.northwestHexEdge(hexIndex);
        p.x += (int)(5.0 * (double)this.getZoom());
        p.y += (int)(8.0 * (double)this.getZoom());
        return p;
    }

    public static boolean isSoftUnit(Unit u) {
        if (u instanceof Garrison) {
            return true;
        }
        if (u instanceof Corps) {
            return true;
        }
        return u instanceof MotorisedCorps;
    }

    public static boolean isTankUnit(Unit u) {
        if (u instanceof Armour) {
            return true;
        }
        return u instanceof HeavyTank;
    }

    public static boolean isAirUnit(Unit u) {
        return u instanceof AirUnit;
    }

    public static boolean isNavalUnit(Unit u) {
        return u instanceof NavalUnit;
    }

    public String displaySideName(int side) {
        String ret = "";
        switch (side) {
            case 100: {
                ret = Global.getMessage(301);
                break;
            }
            case 200: {
                ret = Global.getMessage(302);
                break;
            }
            default: {
                ret = Global.getMessage(304);
            }
        }
        return ret;
    }

    public String getSideName(int side, boolean lowerCase) {
        String ret = "";
        switch (side) {
            case 100: {
                ret = Global.getMessage(301);
                break;
            }
            case 200: {
                ret = Global.getMessage(302);
                break;
            }
            default: {
                ret = Global.getMessage(304);
            }
        }
        if (lowerCase) {
            ret = ret.toLowerCase();
        }
        return ret;
    }

    public String getSideData(int side) {
        String ret = "";
        switch (side) {
            case 100: {
                ret = "axis";
                break;
            }
            case 200: {
                ret = "allies";
                break;
            }
            default: {
                ret = "neutral";
            }
        }
        return ret;
    }

    public int militaryInfluenceOverHex(int side, int target) {
        double support = 0.0;
        if (target != -1) {
            int i = 0;
            while (i < this.hex.length) {
                Unit u = this.hex[i].getUnit();
                if (u != null && u.getCountry().getSide() == side && u.getCountry().getAtWar()) {
                    int dist;
                    double influence = 0.0;
                    influence = this.hex[target] instanceof LandHex ? u.getLandInfluence() : u.getWaterInfluence();
                    if (this.hex[i].getContinent() != this.hex[target].getContinent()) {
                        influence *= 0.7;
                    }
                    if ((dist = this.shortestPath(this.getHexIndex(u.getOnHex()), target)) <= 1) {
                        support += 9.0 * influence;
                    } else if (dist <= 4) {
                        support += 6.0 * influence;
                    } else if (dist <= 8) {
                        support += 3.5 * influence;
                    } else if (dist <= 12) {
                        support += 1.5 * influence;
                    } else if (dist <= 30) {
                        support += 1.0 * influence;
                    } else if (dist <= 55) {
                        support += 0.5 * influence;
                    }
                }
                ++i;
            }
        }
        return (int)support;
    }

    public double militaryAdvantageRatioOverHex(int side, int h) {
        double ratio = 0.0;
        int enemySide = 0;
        enemySide = side == 100 ? 200 : 100;
        ratio = (double)this.militaryInfluenceOverHex(side, h) / (double)Math.max(1, this.militaryInfluenceOverHex(enemySide, h));
        return ratio;
    }

    public void dowCountry(int declaringSide, int countryIndex, boolean hereFirst, boolean penalty, boolean infoDialog, boolean specialMessage) {
        Country country = this.country[countryIndex];
        if (country.getDOWAble() && !country.getAtWar()) {
            int enemySide = 0;
            enemySide = declaringSide == 100 ? 200 : 100;
            boolean answer = true;
            if (hereFirst && penalty) {
                this.getWarWindow().showYesNoDialog(Global.createLanguageMessage(102, new String[]{country.getName()}));
                answer = this.getWarWindow().getYesNoDialog().yesSelected();
            }
            if (answer) {
                String s;
                country.joinWar(enemySide);
                if (infoDialog) {
                    s = "";
                    if (specialMessage && country.getEntryMessage().length() > 0 && country.mobilized()) {
                        s = country.getEntryMessage();
                    } else {
                        if (penalty) {
                            s = String.valueOf(s) + this.displaySideName(declaringSide) + " " + Global.createLanguageMessage(102, new String[]{country.getName()}) + " \n";
                        }
                        s = String.valueOf(s) + country.getName() + " " + Global.createLanguageMessage(124, new String[]{this.displaySideName(enemySide)});
                    }
                    this.warWindow.showInfoDialog(s);
                }
                this.createOwningBorders();
                if (penalty) {
                    this.getWarWindow().oneSlowFrame();
                }
                if (penalty) {
                    this.getWarWindow().getMiniMap().repaint();
                }
                this.unfowCountry(countryIndex);
                if (hereFirst && this.getGameMode() == 3000) {
                    s = "w " + declaringSide + " " + countryIndex + " ";
                    this.sendDataToOpponent(s);
                }
                if (penalty) {
                    this.warWindow.showBelowPanels(0, null, null, null, false);
                }
                this.pauseIfNeeded(500L, hereFirst);
            }
            this.nowShowing = 0;
            if (penalty) {
                this.selectButton(99);
            }
        }
    }

    public int getStrategicAggression(int side) {
        int ret = 0;
        if (side == 100) {
            ret = Math.min(100, Global.AXIS_1939_AGGRESSION + (this.calendar.get(1) - 1939) * Global.AGGRESSION_YEARLY_INCREASE);
        } else if (side == 200) {
            ret = Math.min(100, Global.ALLIES_1939_AGGRESSION + (this.calendar.get(1) - 1939) * Global.AGGRESSION_YEARLY_INCREASE);
        }
        return ret;
    }

    public static Image getImage(String path) {
        return Toolkit.getDefaultToolkit().getImage(path);
    }

    public static boolean existIn(int exist, Vector<Integer> integers) {
        if (integers != null) {
            int i = 0;
            while (i < integers.size()) {
                int tmp = integers.get(i);
                if (tmp == exist) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static int indexOfHighestInt(int[] candidates, Vector<Integer> notAllowed) {
        int ret = 0;
        int i = 0;
        while (i < candidates.length) {
            if (candidates[i] > candidates[ret] && !Game.existIn(i, notAllowed)) {
                ret = i;
            }
            ++i;
        }
        return ret;
    }

    public Hex getTmpUnitHex() {
        return this.tmpUnit.getOnHex();
    }

    public Point drawUnitAt(int i) {
        Point p = new Point(0, 0);
        if (!this.hex[i].isEmpty()) {
            int xPos = 0;
            int yPos = 0;
            p = new Point(this.northwestHexEdge(i));
            xPos = (int)(p.getX() + 5.0 * (double)this.getZoom() - 8.0 + (double)this.hex[i].getUnit().getxoffset());
            yPos = (int)(p.getY() + 8.0 * (double)this.getZoom() - 8.0 + (double)this.hex[i].getUnit().getyoffset());
            p = new Point(xPos, yPos);
        }
        return p;
    }

    public int getFaction(Country c) {
        return c.getFaction();
    }

    public void mouseClickedPixelNormal(Hex newSelectedHex, boolean leftClick) {
        boolean exploitM = false;
        if (!leftClick) {
            if (this.selectedHex == null && !this.exploitMove) {
                this.warWindow.getMapCanvas().setMapViewPosition(newSelectedHex, false);
                this.deSelect();
            } else {
                this.deSelect();
                this.playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "click.wav", 0, false);
            }
        } else if (this.whosTurn() == this.playerSide() && !this.timeSystem.timeIsUp(this.whosTurn()) && !this.mover.getUnitMoving()) {
            int pointed = this.getHexIndex(newSelectedHex);
            if (this.selectedHex == null) {
                if (newSelectedHex.getTargetted()) {
                    exploitM = this.resolveBattle(this.tmpUnit.getOnHex(), newSelectedHex, true, false);
                    this.deSelect();
                } else if (this.exploitMove && newSelectedHex.getHighlighted()) {
                    Vector<Integer> routeHexes = new Vector<Integer>(2, 2);
                    routeHexes.add(new Integer(this.getHexIndex(this.tmpUnit.getOnHex())));
                    routeHexes.add(new Integer(this.getHexIndex(newSelectedHex)));
                    this.moveUnit(routeHexes, false, false, true);
                    this.deSelect();
                } else {
                    this.deHighlightdeTargetAll();
                    this.actionHex = null;
                    if (newSelectedHex.getUnit() != null && this.canSeeUnit(newSelectedHex.getUnit(), this.playerSide())) {
                        if (this.playerSide() == this.whosTurn() && this.country[newSelectedHex.getUnit().getCountryIndex()].getSide() == this.playerSide() && !newSelectedHex.getUnit().getHasMoved()) {
                            this.actionHex = this.selectedHex = newSelectedHex;
                            this.tmpUnit = newSelectedHex.getUnit();
                            this.selectedHex.setHighlighted(true);
                            this.warWindow.updateProductionPanel2(this.tmpUnit.getCountry());
                            newSelectedHex.getUnit().setSentry(false);
                            this.highlightAroundUnit(pointed, -1, false);
                            this.targetAroundUnit(pointed);
                            this.warWindow.showBelowPanels(1, newSelectedHex.getUnit(), null, null, false);
                            this.playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "click.wav", 0, false);
                            this.setTutorialMessage(8);
                        } else {
                            if (!this.warWindow.getHexInfoPanel().isShowing()) {
                                this.warWindow.showBelowPanels(1, null, null, newSelectedHex, true);
                            } else {
                                this.warWindow.showBelowPanels(1, newSelectedHex.getUnit(), null, null, true);
                            }
                            this.playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "click.wav", 0, false);
                        }
                    } else {
                        this.actionHex = this.selectedHex = newSelectedHex;
                        this.selectedHex.setHighlighted(true);
                        this.playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "click.wav", 0, false);
                        this.warWindow.showBelowPanels(1, null, null, newSelectedHex, true);
                    }
                }
            } else if (newSelectedHex != this.selectedHex) {
                if (newSelectedHex.getHighlighted()) {
                    Vector<Integer> routeHexes = new Vector<Integer>(10, 10);
                    if (this.selectedHex.getUnit() instanceof AirUnit) {
                        this.calcAirUnitRoute(routeHexes, this.getHexIndex(this.selectedHex), this.getHexIndex(newSelectedHex));
                    } else {
                        this.calcGroundUnitRoute2(routeHexes, this.getHexIndex(this.selectedHex), this.getHexIndex(newSelectedHex), this.selectedHex.getUnit().getRealMovement(), this.selectedHex.getUnit().getCountryIndex());
                    }
                    boolean airMove = false;
                    Unit selectedUnit = this.selectedHex.getUnit();
                    if (selectedUnit instanceof AirUnit) {
                        airMove = true;
                    }
                    boolean surprised = this.moveUnit(routeHexes, true, airMove, true);
                    this.deHighlightdeTargetAll();
                    if (!(selectedUnit instanceof AirUnit) && !surprised) {
                        this.targetAroundUnit(pointed);
                    }
                    this.tmpUnit = this.hex[pointed].getUnit();
                    this.selectedHex = newSelectedHex;
                } else if (newSelectedHex.getUnit() != null && this.canSeeUnit(newSelectedHex.getUnit(), this.playerSide())) {
                    if (newSelectedHex.getTargetted()) {
                        exploitM = this.resolveBattle(this.selectedHex, newSelectedHex, true, false);
                        this.deSelect();
                    } else if (this.playerSide() == this.whosTurn() && this.country[newSelectedHex.getUnit().getCountryIndex()].getSide() == this.playerSide() && !newSelectedHex.getUnit().getHasMoved()) {
                        this.deHighlightdeTargetAll();
                        this.actionHex = this.selectedHex = newSelectedHex;
                        this.selectedHex.setHighlighted(true);
                        this.tmpUnit = newSelectedHex.getUnit();
                        this.warWindow.updateProductionPanel2(this.tmpUnit.getCountry());
                        newSelectedHex.getUnit().setSentry(false);
                        this.highlightAroundUnit(pointed, -1, false);
                        this.targetAroundUnit(pointed);
                        this.warWindow.showBelowPanels(1, newSelectedHex.getUnit(), null, null, true);
                        this.playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "click.wav", 0, false);
                    } else {
                        this.deSelect();
                        this.playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "click.wav", 0, false);
                    }
                } else if (newSelectedHex.getTargetted()) {
                    this.resolveBattle(this.selectedHex, newSelectedHex, true, false);
                    this.actionHex = this.selectedHex;
                    this.selectedHex = null;
                    this.deHighlightdeTargetAll();
                } else {
                    this.deHighlightdeTargetAll();
                    this.actionHex = this.selectedHex = newSelectedHex;
                    this.selectedHex.setHighlighted(true);
                    this.playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "click.wav", 0, false);
                    this.warWindow.showBelowPanels(1, null, null, newSelectedHex, true);
                }
            }
            this.warWindow.oneSlowFrame();
        }
        this.exploitMove = exploitM;
        if (exploitM) {
            newSelectedHex.setHighlighted(true);
        }
    }

    public int getUnitsHex(Unit u) {
        int i = 0;
        while (i < this.hex.length) {
            if (this.hex[i].getUnit() != null && this.hex[i].getUnit() == u) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void reinforce(int hex, double reinf, boolean hereFirst) {
        if (this.hex[hex].getHighlighted() || !hereFirst) {
            Unit u = this.hex[hex].getUnit();
            boolean minor = false;
            double amount = u.reinforce(reinf);
            if (!u.getCountry().isMajorCountry()) {
                minor = true;
            }
            if (!minor) {
                this.country[u.getCountryIndex()].payPP(amount);
            } else {
                this.countryInCharge(u.getCountry()).payPP(amount);
            }
            this.deSelect();
            this.warWindow.oneSlowFrame();
            this.warWindow.showPP(false);
            if (hereFirst && this.getGameMode() == 3000) {
                String s = "r " + hex + " " + reinf;
                this.sendDataToOpponent(s);
            }
        }
    }

    public void deSelect() {
        this.deHighlightdeTargetAll();
        this.actionHex = null;
        this.selectedHex = null;
        this.enemyHex = null;
        this.exploitMove = false;
        this.warWindow.clearLeft();
        this.warWindow.clearRight();
        this.warWindow.showBelowPanels(0, null, null, null, false);
        this.warWindow.getLeftUnitPanel().showUnit(null, true);
        this.warWindow.oneSlowFrame();
    }

    public void mouseClickedPixel(int pixelX, int pixelY, Hex h, boolean leftClick) {
        if (!this.busy && !this.warWindow.getMapCanvas().getAutomaticMoving()) {
            this.busy = true;
            if (!this.timeSystem.timeIsUp(this.whosTurn())) {
                Hex newSelectedHex = null;
                if (h != null) {
                    newSelectedHex = h;
                } else {
                    int pointed = this.mousePointedHex(pixelX, pixelY, true);
                    if (pointed != -1) {
                        newSelectedHex = this.hex[pointed];
                    }
                }
                if (newSelectedHex != null) {
                    if (this.nowShowing == 1) {
                        this.mouseClickedPixelPurchase(newSelectedHex, leftClick);
                    } else if (this.nowShowing == 2) {
                        this.mouseClickedPixelDeploy(newSelectedHex, leftClick);
                    } else if (this.nowShowing == 3) {
                        this.mouseClickedPixelResearch(newSelectedHex, leftClick);
                    } else if (this.nowShowing == 4) {
                        this.mouseClickedPixelReport(newSelectedHex, leftClick);
                    } else if (this.nowShowing == 5) {
                        this.mouseClickedPixelDOW(newSelectedHex, leftClick);
                    } else if (this.nowShowing == 6) {
                        this.mouseClickedPixelOperate(newSelectedHex, leftClick);
                    } else if (this.nowShowing == 7) {
                        this.mouseClickedPixelRepair(newSelectedHex, leftClick);
                    } else if (this.nowShowing == 8) {
                        this.mouseClickedPixelUpgrade(newSelectedHex, leftClick);
                    } else {
                        this.mouseClickedPixelNormal(newSelectedHex, leftClick);
                    }
                }
            }
            this.busy = false;
        }
    }

    public void mouseClickedPixelPurchase(Hex pointed, boolean leftClick) {
        if (!leftClick) {
            this.warWindow.selectTab(0);
        }
    }

    public void mouseClickedPixelResearch(Hex pointed, boolean leftClick) {
        if (!leftClick) {
            this.warWindow.selectTab(0);
        }
    }

    public void mouseClickedPixelReport(Hex pointed, boolean leftClick) {
        if (!leftClick) {
            this.warWindow.selectTab(0);
        }
    }

    public void mouseClickedPixelDeploy(Hex newSelectedHex, boolean leftClick) {
        if (!leftClick) {
            this.warWindow.closeForcePool();
        } else {
            Unit preDeployUnit = this.warWindow.getForcePoolPanel().getDeployUnit();
            if (newSelectedHex.getHighlighted()) {
                this.playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "click.wav", 0, false);
                boolean b = false;
                if (this.getGameMode() == 3000) {
                    b = true;
                }
                this.warWindow.getForcePoolPanel().deployUnit(this.getHexIndex(newSelectedHex), b);
                if (newSelectedHex.getUnit() != null) {
                    int i = 0;
                    while (i < this.hex.length) {
                        this.hex[i].setHighlighted(false);
                        ++i;
                    }
                    if (!this.warWindow.getForcePoolPanel().forcePoolEmpty()) {
                        Unit postDeployUnit = this.warWindow.getForcePoolPanel().getDeployUnit();
                        this.highlightDeployHexes(this.warWindow.getForcePoolPanel().getSelectedCountry(), this.warWindow.getForcePoolPanel().getDeployUnit());
                        if (postDeployUnit.getCountry() != preDeployUnit.getCountry()) {
                            this.centerOnCapital(postDeployUnit.getCountry());
                        }
                    } else {
                        this.warWindow.closeForcePool();
                    }
                }
            }
            this.warWindow.oneSlowFrame();
        }
    }

    public void mouseClickedPixelDOW(Hex newSelectedHex, boolean leftClick) {
        if (!leftClick) {
            this.selectTab(0);
            this.selectButton(99);
        } else if (this.whosTurn() == this.playerSide() && !this.mover.getUnitMoving()) {
            this.playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "click.wav", 0, false);
            int owner = newSelectedHex.getOwningCountry();
            if (owner != -1 && !this.country[owner].getAtWar() && this.country[owner].getSide() != this.playerSide()) {
                this.dowCountry(this.whosTurn(), owner, true, true, false, false);
            }
        }
    }

    public void mouseClickedPixelRepair(Hex newSelectedHex, boolean leftClick) {
        if (!leftClick) {
            this.selectTab(0);
            this.selectButton(99);
        } else if (this.whosTurn() == this.playerSide() && !this.mover.getUnitMoving() && newSelectedHex.getHighlighted()) {
            this.playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "click.wav", 0, false);
            Unit unit = newSelectedHex.getUnit();
            unit.setHasMoved(true);
            Country c = unit.getCountry();
            int preManpLevel = c.manpowerPenaltyLevel();
            this.reinforce(this.getHexIndex(newSelectedHex), unit.maximumAmountThatCanBeReinforced(), true);
            this.highlightReinforceUnits();
            this.warWindow.oneImmediateFrame();
            if (this.whosTurn() != this.playerSide() || !this.canRepair(this.playerSide())) {
                this.warWindow.closeForcePool();
            }
            if (c.manpowerPenaltyLevel() > preManpLevel) {
                c.getGame().requestShowInfoDialog(Global.createLanguageMessage(140 + c.manpowerPenaltyLevel(), new String[]{c.getName()}));
            }
        }
    }

    public void mouseClickedPixelUpgrade(Hex newSelectedHex, boolean leftClick) {
        if (!leftClick) {
            this.selectTab(0);
            this.selectButton(99);
        } else if (this.whosTurn() == this.playerSide() && !this.mover.getUnitMoving() && newSelectedHex.getHighlighted()) {
            this.playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "click.wav", 0, false);
            Unit unit = newSelectedHex.getUnit();
            unit.upgradeUnit(true);
            unit.setHasMoved(true);
            this.warWindow.showPP(false);
            this.highlightUpgradeUnits();
            this.warWindow.oneImmediateFrame();
            if (this.whosTurn() != this.playerSide() || !this.canUpgrade(this.playerSide())) {
                this.warWindow.closeForcePool();
            }
            if (this.getGameMode() == 3000) {
                String s = "u " + this.getHexIndex(newSelectedHex) + " ";
                this.sendDataToOpponent(s);
            }
        }
    }

    public void mouseClickedPixelOperate(Hex pointed, boolean leftClick) {
        if (this.whosTurn() == this.playerSide() && !this.mover.getUnitMoving()) {
            if (leftClick && pointed.getHighlighted()) {
                if (this.getOperatesLeft(this.owningFaction(this.getHexIndex(this.selectedHex))) <= 0) {
                    this.warWindow.getYesNoDialog().show(Global.createLanguageMessage(138, new String[]{"" + Global.RAIL_MOVE_COST}));
                    if (this.warWindow.getYesNoDialog().yesSelected()) {
                        this.playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "railroad.wav", 0, false);
                        this.operateUnit(this.getHexIndex(this.selectedHex), pointed, true);
                    }
                } else {
                    this.playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "railroad.wav", 0, false);
                    this.operateUnit(this.getHexIndex(this.selectedHex), pointed, true);
                }
            }
            this.warWindow.closeForcePool();
        }
    }

    public int nearestEnemyGroundUnitDistance(int hex, int friendlySide, boolean onlyCountAtWar) {
        int nearest = 999999;
        int i = 0;
        while (i < this.hex.length) {
            int dist;
            Unit tmp = this.hex[i].getUnit();
            if (tmp != null && friendlySide != tmp.getSide() && tmp.hasGroundUnit() && (!onlyCountAtWar || tmp.getCountry().getAtWar()) && (dist = this.shortestPath(hex, i)) < nearest) {
                nearest = dist;
            }
            ++i;
        }
        return nearest;
    }

    public void operateUnit(int sourceHex, Hex targetHex, boolean hereFirst) {
        Country coun = this.hex[sourceHex].getUnit().getCountry();
        this.busy = true;
        Hex newSelectedHex = targetHex;
        if (newSelectedHex.getHighlighted() || !hereFirst || this.ai.active) {
            this.hex[sourceHex].getUnit().changeMorale(-Global.EFFICIENCY_LOSS_FROM_RAIL_MOVEMENT);
            this.hex[sourceHex].getUnit().enterHex(newSelectedHex, false);
            newSelectedHex.getUnit().setHasMoved(true);
            if (coun.getOperatesLeft() < 1) {
                newSelectedHex.getUnit().getCountry().payPP(Global.RAIL_MOVE_COST);
            }
            int val = coun.getFaction();
            this.gameState.decOperatesLeft(val);
            this.warWindow.showPP(false);
            if (hereFirst) {
                String s = "o " + sourceHex + " " + this.getHexIndex(targetHex);
                this.sendDataToOpponent(s);
            }
        }
        this.resetMapDependancy();
        this.nowShowing = 0;
        this.warWindow.showBelowPanels(0, null, null, null, false);
        this.warWindow.oneSlowFrame();
        this.busy = false;
    }

    public void calcGroundUnitRoute2(Vector<Integer> route, int startHex, int endHex, int movesLeft, int country) {
        if (this.hex[startHex].getUnit() instanceof Transport && this.hex[endHex] instanceof LandHex) {
            Transport tmp = (Transport)this.hex[startHex].getUnit();
            tmp.removeFromMap();
            Unit u = tmp.getCarryingUnit();
            if (u.getSide() != this.country[this.hex[endHex].getOwningCountry()].getSide()) {
                this.hex[endHex].setSupply(0);
            }
            tmp.getCarryingUnit().enterHex(this.hex[startHex], false);
            if (u.getOnHex().getPResource() == null) {
                u.changeMorale(-Global.EFFICIENCY_LOSS_FROM_UNLOAD);
            }
        }
        Unit unit = this.hex[startHex].getUnit();
        NodePriorityQueue openQueue = new NodePriorityQueue();
        Vector<Node> closedQueue = new Vector<Node>(15, 10);
        route.add(new Integer(startHex));
        Node startNode = new Node(startHex, 0, this.shortestPath(startHex, endHex));
        openQueue.add(startNode);
        int count = 0;
        while (openQueue.size() > 0) {
            int nextIndex;
            ++count;
            Node currentNode = openQueue.poll();
            closedQueue.add(currentNode);
            if (currentNode.getHex() == endHex) {
                route.removeAllElements();
                route.add(new Integer(currentNode.getHex()));
                while (route.firstElement() != startHex) {
                    currentNode = currentNode.getParent();
                    route.add(0, new Integer(currentNode.getHex()));
                }
                break;
            }
            int tmp = currentNode.getHex();
            if (count % 2 == 1) {
                nextIndex = this.getNorthEastHex(tmp);
                this.calcGroundUnitRoute3(route, openQueue, closedQueue, currentNode, unit, country, tmp, nextIndex, endHex);
                nextIndex = this.getNorthHex(tmp);
                this.calcGroundUnitRoute3(route, openQueue, closedQueue, currentNode, unit, country, tmp, nextIndex, endHex);
                nextIndex = this.getNorthWestHex(tmp);
                this.calcGroundUnitRoute3(route, openQueue, closedQueue, currentNode, unit, country, tmp, nextIndex, endHex);
                nextIndex = this.getSouthWestHex(tmp);
                this.calcGroundUnitRoute3(route, openQueue, closedQueue, currentNode, unit, country, tmp, nextIndex, endHex);
                nextIndex = this.getSouthHex(tmp);
                this.calcGroundUnitRoute3(route, openQueue, closedQueue, currentNode, unit, country, tmp, nextIndex, endHex);
                nextIndex = this.getSouthEastHex(tmp);
                this.calcGroundUnitRoute3(route, openQueue, closedQueue, currentNode, unit, country, tmp, nextIndex, endHex);
                continue;
            }
            nextIndex = this.getSouthEastHex(tmp);
            this.calcGroundUnitRoute3(route, openQueue, closedQueue, currentNode, unit, country, tmp, nextIndex, endHex);
            nextIndex = this.getSouthHex(tmp);
            this.calcGroundUnitRoute3(route, openQueue, closedQueue, currentNode, unit, country, tmp, nextIndex, endHex);
            nextIndex = this.getSouthWestHex(tmp);
            this.calcGroundUnitRoute3(route, openQueue, closedQueue, currentNode, unit, country, tmp, nextIndex, endHex);
            nextIndex = this.getNorthWestHex(tmp);
            this.calcGroundUnitRoute3(route, openQueue, closedQueue, currentNode, unit, country, tmp, nextIndex, endHex);
            nextIndex = this.getNorthHex(tmp);
            this.calcGroundUnitRoute3(route, openQueue, closedQueue, currentNode, unit, country, tmp, nextIndex, endHex);
            nextIndex = this.getNorthEastHex(tmp);
            this.calcGroundUnitRoute3(route, openQueue, closedQueue, currentNode, unit, country, tmp, nextIndex, endHex);
        }
    }

    public void calcGroundUnitRoute3(Vector<Integer> route, NodePriorityQueue openQueue, Vector<Node> closedQueue, Node currentNode, Unit unit, int country, int tmp, int nextIndex, int endHex) {
        if (this.routable(tmp, nextIndex, 99, country, unit)) {
            Node next = new Node(nextIndex, currentNode.getCost() + 1, this.shortestPath(nextIndex, endHex));
            int exist = openQueue.existIn(next);
            if (exist == -1) {
                openQueue.add(next);
                next.setParent(currentNode);
            } else if (next.getHeuristic() < openQueue.getNode(exist).getHeuristic()) {
                openQueue.remove(exist);
                next.setParent(currentNode);
                openQueue.add(next);
            }
        }
    }

    public void calcAirUnitRoute(Vector<Integer> route, int startHex, int endHex) {
        route.add(new Integer(startHex));
        route.add(new Integer(endHex));
    }

    public int getCenteredHex() {
        int hex = this.mousePointedHex(0, 0, true);
        int col = this.getColumn(hex) + 32 / this.getZoom();
        int row = this.getRow(hex) + 16 / this.getZoom();
        return this.getHex(col, row);
    }

    public void resetReplaySymbols() {
        int i = 0;
        while (i < this.hex.length) {
            this.hex[i].resetReplaySymbols();
            ++i;
        }
    }

    public boolean moveUnit(Vector<Integer> routeHexes, boolean costOil, boolean airMove, boolean hereFirst) {
        this.busy = true;
        if (!this.gameState.getHasStartedMoving()) {
            this.gameState.setHasStartedMoving(true);
            this.resetReplaySymbols();
        }
        this.pauseIfNeeded(200L, hereFirst);
        this.deHighlightdeTargetAll();
        int startHex = routeHexes.get(0);
        if ((!hereFirst || this.warWindow.getMapCanvas().getAutomaticMoving()) && this.canSeeUnit(this.hex[startHex].getUnit(), this.viewingSide())) {
            this.warWindow.getMapCanvas().setMapViewPosition(this.hex[startHex], true);
        }
        int endHex = routeHexes.lastElement();
        if (this.hex[startHex].getUnit() instanceof Transport && this.hex[endHex] instanceof LandHex) {
            Transport tmp = (Transport)this.hex[startHex].getUnit();
            tmp.removeFromMap();
            Unit u = tmp.getCarryingUnit();
            if (u.getSide() != this.country[this.hex[endHex].getOwningCountry()].getSide()) {
                this.hex[endHex].setSupply(0);
            }
            tmp.getCarryingUnit().enterHex(this.hex[startHex], false);
            if (u.getOnHex().getPResource() == null) {
                u.changeMorale(-Global.EFFICIENCY_LOSS_FROM_UNLOAD);
            }
        }
        this.getHex(startHex).getUnit().changeMorale(-Global.EFFICIENCY_LOSS_FROM_MOVEMENT);
        Unit u = this.getHex(routeHexes.get(0)).getUnit();
        if (u instanceof Sub) {
            u.setInvisible(true);
        }
        if (this.canSeeUnit(u, this.viewingSide())) {
            if (u instanceof Garrison) {
                this.playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "infantry_move_0.wav", 1, false);
            } else if (u instanceof Corps) {
                this.playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "infantry_move_0.wav", 1, false);
            } else if (u instanceof MotorisedCorps) {
                this.playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "infantry_move_0.wav", 1, false);
            } else if (u instanceof Armour) {
                this.playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "armour_move_0.wav", 1, false);
            } else if (u instanceof Fighter) {
                this.playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "air_move_0.wav", 1, false);
            } else if (u instanceof TacticalBomber) {
                this.playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "air_move_0.wav", 1, false);
            } else if (u instanceof StrategicBomber) {
                this.playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "strategic_bomber_move_0.wav", 1, false);
            } else if (u instanceof Sub) {
                this.playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "sub_move_0.wav", 1, false);
            } else if (u instanceof Destroyer) {
                this.playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "ship_move_0.wav", 1, false);
            } else if (u instanceof Battleship) {
                this.playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "ship_move_0.wav", 1, false);
            } else if (u instanceof Carrier) {
                this.playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "ship_move_0.wav", 1, false);
            } else if (u instanceof Transport) {
                this.playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "ship_move_0.wav", 1, false);
            } else if (u instanceof Convoy) {
                this.playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "ship_move_0.wav", 1, false);
            }
        }
        double preOil = u.getCountry().getOil();
        boolean lowOnOilPre = u.getCountry().lowOnOil();
        if (costOil) {
            u.getCountry().changeOil(-u.getOilConsumption());
        }
        this.warWindow.showPP(false);
        if (u.getSide() == this.playerSide() && preOil > 0.0 && u.getCountry().getOil() <= 0.0) {
            this.requestShowInfoDialog(Global.createLanguageMessage(137, new String[]{u.getCountry().displayFactionName(false)}));
        } else if (u.getSide() == this.playerSide() && !lowOnOilPre && u.getCountry().lowOnOil()) {
            this.requestShowInfoDialog(Global.createLanguageMessage(135, new String[]{u.getCountry().displayFactionName(false)}));
        }
        this.pauseIfNeeded(250L, hereFirst);
        if (hereFirst && this.getGameMode() == 3000) {
            String s = "v ";
            s = costOil ? String.valueOf(s) + "1 " : String.valueOf(s) + "0 ";
            s = airMove ? String.valueOf(s) + "1 " : String.valueOf(s) + "0 ";
            int i = 0;
            while (i < routeHexes.size()) {
                s = String.valueOf(s) + routeHexes.get(i) + " ";
                ++i;
            }
            this.sendDataToOpponent(s);
        }
        boolean surprised = this.mover.moveUnit(routeHexes, airMove);
        if (u instanceof Convoy) {
            Hex nowOnHex = u.getOnHex();
            if (hereFirst && nowOnHex != null && this.shortestPath(this.getHexIndex(nowOnHex), this.getHexIndex(u.getDestinationHex())) < 3) {
                u.getCountry().cashInConvoyCargo(u, hereFirst);
            }
        }
        if (hereFirst && !this.getWarWindow().getMapCanvas().getAutomaticMoving()) {
            this.warWindow.closeForcePool();
        }
        this.busy = false;
        return surprised;
    }

    public boolean mmmmmoveUnitOneStep(Vector<Hex> routeHexes, int step) {
        int step2 = 1 + step % 6;
        int size = routeHexes.size();
        if (size < 2) {
            return false;
        }
        int first = this.warWindow.getGame().getHexIndex(routeHexes.get(0));
        int second = this.warWindow.getGame().getHexIndex(routeHexes.get(1));
        Point p2 = this.northwestHexEdge(second);
        Point p1 = this.northwestHexEdge(first);
        int diffX = p2.x - p1.x;
        int diffY = p2.y - p1.y;
        routeHexes.get(0).getUnit().setOffsets(diffX * step2 / 6, diffY * step2 / 6);
        Game.delay(200L);
        if (step2 == 6) {
            routeHexes.get(0).getUnit().enterHex(routeHexes.get(1), true);
            routeHexes.remove(0);
        }
        return true;
    }

    private boolean sameZOCgroup(Unit a, Unit b) {
        if (a instanceof GroundUnit && b instanceof GroundUnit) {
            return true;
        }
        if (a instanceof AirUnit && b instanceof AirUnit) {
            return true;
        }
        if (a instanceof GroundUnit && b instanceof AirUnit) {
            return true;
        }
        return a instanceof AirUnit && b instanceof GroundUnit;
    }

    public void deHighlightdeTargetAll() {
        int i = 0;
        while (i < this.hex.length) {
            this.hex[i].setHighlighted(false);
            this.hex[i].setTargetted(false);
            ++i;
        }
    }

    public void deTargetAll() {
        int i = 0;
        while (i < this.hex.length) {
            this.hex[i].setTargetted(false);
            ++i;
        }
    }

    private boolean insideMap(int index) {
        return index > -1 && index < this.hex.length;
    }

    private int getStartIndexAroundHex(int hexIndex, int minus) {
        int col = 0;
        int row = 0;
        col = this.getColumn(hexIndex) - minus;
        row = this.getRow(hexIndex) - minus;
        if (col < 0) {
            col = 0;
        }
        if (row < 0) {
            row = 0;
        }
        return this.getHex(col, row);
    }

    private int getStopIndexAroundHex(int hexIndex, int plus) {
        int col = 0;
        int row = 0;
        col = this.getColumn(hexIndex) + plus;
        row = this.getRow(hexIndex) + plus;
        if (col >= 150) {
            col = 149;
        }
        if (row >= 72) {
            row = 71;
        }
        return this.getHex(col, row);
    }

    public void targetAroundUnit(int hex) {
        Unit u = this.hex[hex].getUnit();
        if (u != null && (u.getOilConsumption() == 0 || u.getCountry().getOil() >= (double)u.getOilConsumption()) && !(u instanceof Transport)) {
            if (u instanceof AirUnit) {
                this.targetAroundAirUnit(hex);
            } else if (u instanceof Carrier) {
                this.targetAroundAirUnit(hex);
            } else {
                this.targetAroundGroundNavyUnit(hex);
            }
        }
    }

    private void targetAroundGroundNavyUnit(int hex) {
        if (this.hex[hex].getUnit() instanceof Transport) {
            // empty if block
        }
        int index = 0;
        index = this.getNorthHex(hex);
        this.targetAroundGroundNavyUnit2(hex, index);
        index = this.getNorthEastHex(hex);
        this.targetAroundGroundNavyUnit2(hex, index);
        index = this.getSouthEastHex(hex);
        this.targetAroundGroundNavyUnit2(hex, index);
        index = this.getSouthHex(hex);
        this.targetAroundGroundNavyUnit2(hex, index);
        index = this.getSouthWestHex(hex);
        this.targetAroundGroundNavyUnit2(hex, index);
        index = this.getNorthWestHex(hex);
        this.targetAroundGroundNavyUnit2(hex, index);
    }

    private void targetAroundGroundNavyUnit2(int friendHex, int targetHex) {
        Unit enemy;
        Unit friend = this.hex[friendHex].getUnit();
        if (this.insideMap(targetHex) && (enemy = this.hex[targetHex].getUnit()) != null && enemy.isAtWar() && this.canSeeUnit(enemy, friend.getSide()) && Country.enemies(this.country[friend.getCountryIndex()], this.country[enemy.getCountryIndex()])) {
            if (enemy instanceof NavalUnit) {
                if (this.hex[targetHex].getPResource() instanceof SeaPort) {
                    this.hex[targetHex].setTargetted(true);
                } else if (!(friend instanceof GroundUnit || friend instanceof Sub && enemy instanceof Sub)) {
                    this.hex[targetHex].setTargetted(true);
                }
            } else if (!(friend instanceof Sub)) {
                this.hex[targetHex].setTargetted(true);
            }
        }
    }

    private int zocMovePenalty(Unit unit, int hex1, int hex2) {
        int enemies1 = this.nonFOWedEnemiesAdjacent(hex1, unit);
        int enemies2 = this.nonFOWedEnemiesAdjacent(hex2, unit);
        if (enemies2 > 1) {
            return unit.zocPenalty();
        }
        if (enemies1 > 0 && enemies2 > 0) {
            return unit.zocPenalty();
        }
        return 0;
    }

    public boolean chaseableEnemyOnHex(int hex, Unit friendlyUnit) {
        Unit enemy = this.hex[hex].getUnit();
        int side = friendlyUnit.getCountry().getSide();
        return this.hex[hex].getUnit() != null && this.hex[hex].getUnit().getCountry().getAtWar() && this.hex[hex].getUnit().getCountry().getSide() != side && (friendlyUnit.isLandUnit() == enemy.isLandUnit() || !friendlyUnit.isLandUnit() && enemy.isLandUnit() && friendlyUnit.getOnHex().getContinent() == this.nearestOceanIndex(hex) && this.nearestOceanDist(hex) <= 1);
    }

    public int nonFOWedEnemiesAdjacent(int hex, Unit unit) {
        Unit otherUnit;
        int index = 0;
        int enemies = 0;
        index = this.getNorthHex(hex);
        if (this.insideMap(index) && (otherUnit = this.hex[index].getUnit()) != null && otherUnit.getCountry().atWarWith(unit.getCountry()) && this.sameZOCgroup(unit, otherUnit) && this.canSeeUnit(otherUnit, unit.getSide()) && !otherUnit.isInvisible()) {
            ++enemies;
        }
        if (this.insideMap(index = this.getNorthEastHex(hex)) && (otherUnit = this.hex[index].getUnit()) != null && otherUnit.getCountry().atWarWith(unit.getCountry()) && this.sameZOCgroup(unit, otherUnit) && this.canSeeUnit(otherUnit, unit.getSide()) && !otherUnit.isInvisible()) {
            ++enemies;
        }
        if (this.insideMap(index = this.getSouthEastHex(hex)) && (otherUnit = this.hex[index].getUnit()) != null && otherUnit.getCountry().atWarWith(unit.getCountry()) && this.sameZOCgroup(unit, otherUnit) && this.canSeeUnit(otherUnit, unit.getSide()) && !otherUnit.isInvisible()) {
            ++enemies;
        }
        if (this.insideMap(index = this.getSouthHex(hex)) && (otherUnit = this.hex[index].getUnit()) != null && otherUnit.getCountry().atWarWith(unit.getCountry()) && this.sameZOCgroup(unit, otherUnit) && this.canSeeUnit(otherUnit, unit.getSide()) && !otherUnit.isInvisible()) {
            ++enemies;
        }
        if (this.insideMap(index = this.getSouthWestHex(hex)) && (otherUnit = this.hex[index].getUnit()) != null && otherUnit.getCountry().atWarWith(unit.getCountry()) && this.sameZOCgroup(unit, otherUnit) && this.canSeeUnit(otherUnit, unit.getSide()) && !otherUnit.isInvisible()) {
            ++enemies;
        }
        if (this.insideMap(index = this.getNorthWestHex(hex)) && (otherUnit = this.hex[index].getUnit()) != null && otherUnit.getCountry().atWarWith(unit.getCountry()) && this.sameZOCgroup(unit, otherUnit) && this.canSeeUnit(otherUnit, unit.getSide()) && !otherUnit.isInvisible()) {
            ++enemies;
        }
        return enemies;
    }

    public boolean FOWenemyAdjacent(int hex, Unit unit) {
        Unit otherUnit;
        int index = 0;
        index = this.getNorthHex(hex);
        if (this.insideMap(index) && (otherUnit = this.hex[index].getUnit()) != null && otherUnit.getCountry().atWarWith(unit.getCountry()) && this.sameZOCgroup(unit, otherUnit) && !this.canSeeUnit(otherUnit, unit.getSide()) && !otherUnit.isInvisible()) {
            return true;
        }
        index = this.getNorthEastHex(hex);
        if (this.insideMap(index) && (otherUnit = this.hex[index].getUnit()) != null && otherUnit.getCountry().atWarWith(unit.getCountry()) && this.sameZOCgroup(unit, otherUnit) && !this.canSeeUnit(otherUnit, unit.getSide()) && !otherUnit.isInvisible()) {
            return true;
        }
        index = this.getSouthEastHex(hex);
        if (this.insideMap(index) && (otherUnit = this.hex[index].getUnit()) != null && otherUnit.getCountry().atWarWith(unit.getCountry()) && this.sameZOCgroup(unit, otherUnit) && !this.canSeeUnit(otherUnit, unit.getSide()) && !otherUnit.isInvisible()) {
            return true;
        }
        index = this.getSouthHex(hex);
        if (this.insideMap(index) && (otherUnit = this.hex[index].getUnit()) != null && otherUnit.getCountry().atWarWith(unit.getCountry()) && this.sameZOCgroup(unit, otherUnit) && !this.canSeeUnit(otherUnit, unit.getSide()) && !otherUnit.isInvisible()) {
            return true;
        }
        index = this.getSouthWestHex(hex);
        if (this.insideMap(index) && (otherUnit = this.hex[index].getUnit()) != null && otherUnit.getCountry().atWarWith(unit.getCountry()) && this.sameZOCgroup(unit, otherUnit) && !this.canSeeUnit(otherUnit, unit.getSide()) && !otherUnit.isInvisible()) {
            return true;
        }
        index = this.getNorthWestHex(hex);
        return this.insideMap(index) && (otherUnit = this.hex[index].getUnit()) != null && otherUnit.getCountry().atWarWith(unit.getCountry()) && this.sameZOCgroup(unit, otherUnit) && !this.canSeeUnit(otherUnit, unit.getSide()) && !otherUnit.isInvisible();
    }

    public boolean enemyValuedResourceAdjacent(int hex, Unit unit) {
        int index = 0;
        index = this.getNorthHex(hex);
        if (this.insideMap(index) && this.hex[index].getPResource() != null && this.hex[index].getPResource().getMaxProduction() > 0 && this.owningCountry(index).atWarWith(unit.getCountry())) {
            return true;
        }
        index = this.getNorthEastHex(hex);
        if (this.insideMap(index) && this.hex[index].getPResource() != null && this.hex[index].getPResource().getMaxProduction() > 0 && this.owningCountry(index).atWarWith(unit.getCountry())) {
            return true;
        }
        index = this.getSouthEastHex(hex);
        if (this.insideMap(index) && this.hex[index].getPResource() != null && this.hex[index].getPResource().getMaxProduction() > 0 && this.owningCountry(index).atWarWith(unit.getCountry())) {
            return true;
        }
        index = this.getSouthHex(hex);
        if (this.insideMap(index) && this.hex[index].getPResource() != null && this.hex[index].getPResource().getMaxProduction() > 0 && this.owningCountry(index).atWarWith(unit.getCountry())) {
            return true;
        }
        index = this.getSouthWestHex(hex);
        if (this.insideMap(index) && this.hex[index].getPResource() != null && this.hex[index].getPResource().getMaxProduction() > 0 && this.owningCountry(index).atWarWith(unit.getCountry())) {
            return true;
        }
        index = this.getNorthWestHex(hex);
        return this.insideMap(index) && this.hex[index].getPResource() != null && this.hex[index].getPResource().getMaxProduction() > 0 && this.owningCountry(index).atWarWith(unit.getCountry());
    }

    public void winterEvent(boolean hereFirst) {
        double rnd;
        boolean winter = false;
        if (!hereFirst) {
            winter = true;
        } else if (!(this.whosTurn() != 100 || this.gameState.getWintersDone() > this.yearsPassed(this.calendar) || this.calendar.get(2) <= 9 && this.calendar.get(2) >= 2 || !((rnd = Math.random()) < 0.26) && this.calendar.get(2) >= 2)) {
            winter = true;
        }
        if (winter) {
            this.gameState.incWinterDone();
            int axisLoss = Math.max(0, Global.AXIS_WINTER_SUFFER - this.yearsPassed(this.calendar) * 10);
            int alliedLoss = Math.max(0, Global.ALLIES_WINTER_SUFFER - this.yearsPassed(this.calendar) * 10);
            if (this.country[5].getAtWar()) {
                String s = "";
                s = Global.createLanguageMessage(125, new String[]{"" + axisLoss, "" + alliedLoss});
                this.warWindow.showInfoDialog(s);
            }
            int i = 0;
            while (i < this.hex.length) {
                Unit u = this.hex[i].getUnit();
                if (this.hex[i].getCoreOwningCountry() == 5) {
                    this.hex[i].setWinterDuration(1 + 2 * Global.WINTER_DURATION);
                    if (this.country[5].getAtWar() && u != null) {
                        if (u.getSide() == 100) {
                            u.changeMorale(-axisLoss);
                        } else {
                            u.changeMorale(-alliedLoss);
                        }
                    }
                }
                ++i;
            }
            if (hereFirst) {
                this.sendDataToOpponent("q ");
            }
        }
    }

    public void weatherUpdate() {
        int i = 0;
        while (i < this.hex.length) {
            this.hex[i].decWinterDuration();
            ++i;
        }
        int j = 0;
        while (j < this.country.length) {
            int k = 0;
            while (k < this.hex.length) {
                if (this.hex[k].getCoreOwningCountry() == j && this.hex[k].getWinterDuration() > 0 && this.country[j].getAtWar()) {
                    String s = Global.createLanguageMessage(145, new String[]{this.country[j].getName()});
                    this.warWindow.showInfoDialog(s);
                    break;
                }
                ++k;
            }
            ++j;
        }
    }

    public int nonFortressEnemiesAdjacent(int hex, Unit unit) {
        int index = 0;
        int enemies = 0;
        index = this.getNorthHex(hex);
        if (this.insideMap(index) && !(this.hex[index].getPResource() instanceof Fortress) && this.hex[index].getUnit() != null && this.hex[index].getUnit().getCountry().atWarWith(unit.getCountry()) && this.sameZOCgroup(unit, this.hex[index].getUnit())) {
            ++enemies;
        }
        if (this.insideMap(index = this.getNorthEastHex(hex)) && !(this.hex[index].getPResource() instanceof Fortress) && this.hex[index].getUnit() != null && this.hex[index].getUnit().getCountry().atWarWith(unit.getCountry()) && this.sameZOCgroup(unit, this.hex[index].getUnit())) {
            ++enemies;
        }
        if (this.insideMap(index = this.getSouthEastHex(hex)) && !(this.hex[index].getPResource() instanceof Fortress) && this.hex[index].getUnit() != null && this.hex[index].getUnit().getCountry().atWarWith(unit.getCountry()) && this.sameZOCgroup(unit, this.hex[index].getUnit())) {
            ++enemies;
        }
        if (this.insideMap(index = this.getSouthHex(hex)) && !(this.hex[index].getPResource() instanceof Fortress) && this.hex[index].getUnit() != null && this.hex[index].getUnit().getCountry().atWarWith(unit.getCountry()) && this.sameZOCgroup(unit, this.hex[index].getUnit())) {
            ++enemies;
        }
        if (this.insideMap(index = this.getSouthWestHex(hex)) && !(this.hex[index].getPResource() instanceof Fortress) && this.hex[index].getUnit() != null && this.hex[index].getUnit().getCountry().atWarWith(unit.getCountry()) && this.sameZOCgroup(unit, this.hex[index].getUnit())) {
            ++enemies;
        }
        if (this.insideMap(index = this.getNorthWestHex(hex)) && !(this.hex[index].getPResource() instanceof Fortress) && this.hex[index].getUnit() != null && this.hex[index].getUnit().getCountry().atWarWith(unit.getCountry()) && this.sameZOCgroup(unit, this.hex[index].getUnit())) {
            ++enemies;
        }
        return enemies;
    }

    public boolean inEnemyZOC(Unit u) {
        return u.getOnHex() != null && this.enemiesAdjacent(this.getHexIndex(u.getOnHex()), u) > 0;
    }

    public int enemiesAdjacent(int hex, Unit unit) {
        int index = 0;
        int enemies = 0;
        index = this.getNorthHex(hex);
        if (this.insideMap(index) && this.hex[index].getUnit() != null && this.hex[index].getUnit().getCountry().atWarWith(unit.getCountry()) && this.sameZOCgroup(unit, this.hex[index].getUnit())) {
            ++enemies;
        }
        if (this.insideMap(index = this.getNorthEastHex(hex)) && this.hex[index].getUnit() != null && this.hex[index].getUnit().getCountry().atWarWith(unit.getCountry()) && this.sameZOCgroup(unit, this.hex[index].getUnit())) {
            ++enemies;
        }
        if (this.insideMap(index = this.getSouthEastHex(hex)) && this.hex[index].getUnit() != null && this.hex[index].getUnit().getCountry().atWarWith(unit.getCountry()) && this.sameZOCgroup(unit, this.hex[index].getUnit())) {
            ++enemies;
        }
        if (this.insideMap(index = this.getSouthHex(hex)) && this.hex[index].getUnit() != null && this.hex[index].getUnit().getCountry().atWarWith(unit.getCountry()) && this.sameZOCgroup(unit, this.hex[index].getUnit())) {
            ++enemies;
        }
        if (this.insideMap(index = this.getSouthWestHex(hex)) && this.hex[index].getUnit() != null && this.hex[index].getUnit().getCountry().atWarWith(unit.getCountry()) && this.sameZOCgroup(unit, this.hex[index].getUnit())) {
            ++enemies;
        }
        if (this.insideMap(index = this.getNorthWestHex(hex)) && this.hex[index].getUnit() != null && this.hex[index].getUnit().getCountry().atWarWith(unit.getCountry()) && this.sameZOCgroup(unit, this.hex[index].getUnit())) {
            ++enemies;
        }
        return enemies;
    }

    public int readyFriendAdjacent(int hex, Unit unit) {
        int index = 0;
        int side = unit.getCountry().getSide();
        index = this.getNorthHex(hex);
        if (this.insideMap(index) && this.hex[index].getUnit() != null && this.hex[index].getUnit() != unit && !this.hex[index].getUnit().getHasMoved() && this.hex[index].getUnit().getCountry().getSide() == side && this.sameZOCgroup(unit, this.hex[index].getUnit())) {
            return index;
        }
        index = this.getNorthEastHex(hex);
        if (this.insideMap(index) && this.hex[index].getUnit() != null && this.hex[index].getUnit() != unit && !this.hex[index].getUnit().getHasMoved() && this.hex[index].getUnit().getCountry().getSide() == side && this.sameZOCgroup(unit, this.hex[index].getUnit())) {
            return index;
        }
        index = this.getSouthEastHex(hex);
        if (this.insideMap(index) && this.hex[index].getUnit() != null && this.hex[index].getUnit() != unit && !this.hex[index].getUnit().getHasMoved() && this.hex[index].getUnit().getCountry().getSide() == side && this.sameZOCgroup(unit, this.hex[index].getUnit())) {
            return index;
        }
        index = this.getSouthHex(hex);
        if (this.insideMap(index) && this.hex[index].getUnit() != null && this.hex[index].getUnit() != unit && !this.hex[index].getUnit().getHasMoved() && this.hex[index].getUnit().getCountry().getSide() == side && this.sameZOCgroup(unit, this.hex[index].getUnit())) {
            return index;
        }
        index = this.getSouthWestHex(hex);
        if (this.insideMap(index) && this.hex[index].getUnit() != null && this.hex[index].getUnit() != unit && !this.hex[index].getUnit().getHasMoved() && this.hex[index].getUnit().getCountry().getSide() == side && this.sameZOCgroup(unit, this.hex[index].getUnit())) {
            return index;
        }
        index = this.getNorthWestHex(hex);
        if (this.insideMap(index) && this.hex[index].getUnit() != null && this.hex[index].getUnit() != unit && !this.hex[index].getUnit().getHasMoved() && this.hex[index].getUnit().getCountry().getSide() == side && this.sameZOCgroup(unit, this.hex[index].getUnit())) {
            return index;
        }
        return -1;
    }

    public int friendsAdjacent(int hex, Unit unit) {
        int index = 0;
        int side = unit.getCountry().getSide();
        int friends = 0;
        index = this.getNorthHex(hex);
        if (this.insideMap(index) && this.hex[index].getUnit() != null && this.hex[index].getUnit().getCountry().getSide() == side && this.sameZOCgroup(unit, this.hex[index].getUnit())) {
            ++friends;
        }
        if (this.insideMap(index = this.getNorthEastHex(hex)) && this.hex[index].getUnit() != null && this.hex[index].getUnit().getCountry().getSide() == side && this.sameZOCgroup(unit, this.hex[index].getUnit())) {
            ++friends;
        }
        if (this.insideMap(index = this.getSouthEastHex(hex)) && this.hex[index].getUnit() != null && this.hex[index].getUnit().getCountry().getSide() == side && this.sameZOCgroup(unit, this.hex[index].getUnit())) {
            ++friends;
        }
        if (this.insideMap(index = this.getSouthHex(hex)) && this.hex[index].getUnit() != null && this.hex[index].getUnit().getCountry().getSide() == side && this.sameZOCgroup(unit, this.hex[index].getUnit())) {
            ++friends;
        }
        if (this.insideMap(index = this.getSouthWestHex(hex)) && this.hex[index].getUnit() != null && this.hex[index].getUnit().getCountry().getSide() == side && this.sameZOCgroup(unit, this.hex[index].getUnit())) {
            ++friends;
        }
        if (this.insideMap(index = this.getNorthWestHex(hex)) && this.hex[index].getUnit() != null && this.hex[index].getUnit().getCountry().getSide() == side && this.sameZOCgroup(unit, this.hex[index].getUnit())) {
            ++friends;
        }
        return friends;
    }

    public Hex getEmptyAdjacentLandHex(int hex) {
        int index = this.getNorthHex(hex);
        if (this.insideMap(index) && this.hex[index] instanceof LandHex && this.hex[index].getUnit() == null) {
            return this.hex[index];
        }
        index = this.getNorthEastHex(hex);
        if (this.insideMap(index) && this.hex[index] instanceof LandHex && this.hex[index].getUnit() == null) {
            return this.hex[index];
        }
        index = this.getSouthEastHex(hex);
        if (this.insideMap(index) && this.hex[index] instanceof LandHex && this.hex[index].getUnit() == null) {
            return this.hex[index];
        }
        index = this.getSouthHex(hex);
        if (this.insideMap(index) && this.hex[index] instanceof LandHex && this.hex[index].getUnit() == null) {
            return this.hex[index];
        }
        index = this.getSouthWestHex(hex);
        if (this.insideMap(index) && this.hex[index] instanceof LandHex && this.hex[index].getUnit() == null) {
            return this.hex[index];
        }
        index = this.getNorthWestHex(hex);
        if (this.insideMap(index) && this.hex[index] instanceof LandHex && this.hex[index].getUnit() == null) {
            return this.hex[index];
        }
        return null;
    }

    public int getEmptyAdjacentWaterHex(int hex, boolean loop) {
        int index = this.getNorthHex(hex);
        if (this.insideMap(index) && this.hex[index] instanceof WaterHex && this.hex[index].getUnit() == null) {
            return index;
        }
        index = this.getNorthEastHex(hex);
        if (this.insideMap(index) && this.hex[index] instanceof WaterHex && this.hex[index].getUnit() == null) {
            return index;
        }
        index = this.getSouthEastHex(hex);
        if (this.insideMap(index) && this.hex[index] instanceof WaterHex && this.hex[index].getUnit() == null) {
            return index;
        }
        index = this.getSouthHex(hex);
        if (this.insideMap(index) && this.hex[index] instanceof WaterHex && this.hex[index].getUnit() == null) {
            return index;
        }
        index = this.getSouthWestHex(hex);
        if (this.insideMap(index) && this.hex[index] instanceof WaterHex && this.hex[index].getUnit() == null) {
            return index;
        }
        index = this.getNorthWestHex(hex);
        if (this.insideMap(index) && this.hex[index] instanceof WaterHex && this.hex[index].getUnit() == null) {
            return index;
        }
        if (loop && this.hex[hex].getUnit() == null) {
            return hex;
        }
        return -1;
    }

    private void storeCapitals() {
        int t = 71;
        while (t >= 0) {
            int k = 149;
            while (k >= 0) {
                int i = this.getHex(k, t);
                if (this.hex[i].hasPResource() && this.hex[i].getPResource() instanceof Capital) {
                    Country c = this.country[this.hex[i].getOwningCountry()];
                    if (c.activeCapital() == -1) {
                        c.setPrimaryCapital(i);
                    } else {
                        c.setSecondaryCapital(i);
                    }
                    this.hex[i].setCoreOwningCountry(c.getCountryIndex());
                }
                --k;
            }
            --t;
        }
    }

    public void majorCapitalBonusProduction() {
        int i = 0;
        while (i < this.country.length) {
            if (this.country[i].isMajorCountry()) {
                ((Capital)this.hex[this.country[i].getPrimaryCapital()].getPResource()).setMajor();
                if (this.country[i].getSecondaryCapital() != -1) {
                    ((Capital)this.hex[this.country[i].getSecondaryCapital()].getPResource()).setMajor();
                }
            }
            ++i;
        }
    }

    private void markCoreHexesStoreDeployHexes(int hex) {
        Hex h;
        int country = this.hex[hex].getOwningCountry();
        int index = 0;
        index = this.getNorthHex(hex);
        if (this.insideMap(index) && (h = this.hex[index]).getOwningCountry() == country && !h.isCoreHex() && h instanceof LandHex) {
            if (h.getPResource() instanceof City) {
                this.country[country].addDeployHex(h);
            }
            h.setCoreOwningCountry(h.getOwningCountry());
            this.markCoreHexesStoreDeployHexes(index);
        }
        if (this.insideMap(index = this.getNorthEastHex(hex)) && (h = this.hex[index]).getOwningCountry() == country && !h.isCoreHex() && h instanceof LandHex) {
            if (h.getPResource() instanceof City) {
                this.country[country].addDeployHex(h);
            }
            h.setCoreOwningCountry(h.getOwningCountry());
            this.markCoreHexesStoreDeployHexes(index);
        }
        if (this.insideMap(index = this.getSouthEastHex(hex)) && (h = this.hex[index]).getOwningCountry() == country && !h.isCoreHex() && h instanceof LandHex) {
            if (h.getPResource() instanceof City) {
                this.country[country].addDeployHex(h);
            }
            h.setCoreOwningCountry(h.getOwningCountry());
            this.markCoreHexesStoreDeployHexes(index);
        }
        if (this.insideMap(index = this.getSouthHex(hex)) && (h = this.hex[index]).getOwningCountry() == country && !h.isCoreHex() && h instanceof LandHex) {
            if (h.getPResource() instanceof City) {
                this.country[country].addDeployHex(h);
            }
            h.setCoreOwningCountry(h.getOwningCountry());
            this.markCoreHexesStoreDeployHexes(index);
        }
        if (this.insideMap(index = this.getSouthWestHex(hex)) && (h = this.hex[index]).getOwningCountry() == country && !h.isCoreHex() && h instanceof LandHex) {
            if (h.getPResource() instanceof City) {
                this.country[country].addDeployHex(h);
            }
            h.setCoreOwningCountry(h.getOwningCountry());
            this.markCoreHexesStoreDeployHexes(index);
        }
        if (this.insideMap(index = this.getNorthWestHex(hex)) && (h = this.hex[index]).getOwningCountry() == country && !h.isCoreHex() && h instanceof LandHex) {
            if (h.getPResource() instanceof City) {
                this.country[country].addDeployHex(h);
            }
            h.setCoreOwningCountry(h.getOwningCountry());
            this.markCoreHexesStoreDeployHexes(index);
        }
    }

    public boolean hasAtlanticPort(int country) {
        int i = 0;
        while (i < this.hex.length) {
            if (this.hex[i].getAttachedPort() != null && this.hex[i].getOwningCountry() == country && this.oceanAdjacent(this.hex[i].getAttachedPort(), this.atlanticOceanIndex())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int gibraltarPort() {
        int i = 0;
        while (i < this.hex.length) {
            Hex h = this.hex[i];
            if (h.getPResource() instanceof SeaPort && this.oceanAdjacent(h, this.atlanticOceanIndex()) && this.oceanAdjacent(h, this.mediterraneanOceanIndex())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean needGibraltarWaypoint(Unit u) {
        Hex onHex = u.getOnHex();
        Hex destHex = u.getDestinationHex();
        int destHexIndex = this.getHexIndex(destHex);
        if (this.shortestPath(this.getHexIndex(onHex), this.gibraltarPort()) < 7) {
            return false;
        }
        return onHex instanceof WaterHex && this.nearestOceanIndex(this.getHexIndex(onHex)) != this.nearestOceanIndex(destHexIndex) && (destHexIndex == this.atlanticOceanIndex() || destHexIndex == this.mediterraneanOceanIndex());
    }

    public int bestLoopHexNearby(int hex, int destOcean) {
        int ret = -1;
        int nearestOcean = this.nearestOceanIndex(hex);
        int i = 0;
        while (i < this.hex.length) {
            if ((this.hex[i] instanceof LoopHex || this.hex[i] instanceof LoopHex2) && i != hex && this.hex[i].getContinent() == nearestOcean) {
                if (ret == -1) {
                    ret = i;
                } else {
                    int opposing = this.gameState.getSuezLoop().getOpposingHex(i);
                    if (opposing != -1 && this.hex[opposing].getContinent() == destOcean) {
                        ret = i;
                    }
                    if ((opposing = this.gameState.getAfricaLoop().getOpposingHex(i)) != -1 && this.hex[opposing].getContinent() == destOcean) {
                        ret = i;
                    }
                }
            }
            ++i;
        }
        return ret;
    }

    public int nearestOceanDist(int hex) {
        int nearestDist = 999999;
        int i = 0;
        while (i < this.hex.length) {
            int dist;
            if (this.hex[i] instanceof WaterHex && this.hex[i].getPResource() == null && (dist = this.shortestPath(hex, i)) < nearestDist) {
                nearestDist = dist;
            }
            ++i;
        }
        return nearestDist;
    }

    public int nearestOceanIndex(int hex) {
        int nearestDist = 999999;
        int nearestContinent = -1;
        int i = 0;
        while (i < this.hex.length) {
            int dist;
            int continent = this.hex[i].getContinent();
            if (this.hex[i] instanceof WaterHex && this.hex[i].getPResource() == null && (dist = this.shortestPath(hex, i)) < nearestDist) {
                nearestDist = dist;
                nearestContinent = continent;
            }
            ++i;
        }
        return nearestContinent;
    }

    public int nearestLostHex(int hex, Unit unit) {
        this.highlightAroundUnit(hex, unit.getRealMovement(), false);
        int nearestDist = 999999;
        int nearestHex = -1;
        int i = 0;
        while (i < this.hex.length) {
            if (this.hex[i].getHighlighted() && this.coreOwningSide(i) == unit.getSide() && this.owningSide(i) != unit.getSide() && !unit.afraidOfHex(i) && this.hex[i].sameElement(this.hex[hex])) {
                int dist = this.shortestPath(hex, i);
                if (dist < nearestDist) {
                    nearestDist = dist;
                    nearestHex = i;
                } else if (dist == nearestDist && this.hex[nearestHex].getUnit() == null && this.hex[i].getUnit() != null) {
                    nearestDist = dist;
                    nearestHex = i;
                }
            }
            ++i;
        }
        this.deHighlightdeTargetAll();
        return nearestHex;
    }

    public int nearestSafeReachableEmptyHex(int hex, Unit unit) {
        this.highlightAroundUnit(hex, unit.getRealMovement(), false);
        int nearest = 999999;
        int nearestHex = -1;
        int i = 0;
        while (i < this.hex.length) {
            int dist;
            if (this.hex[i].getHighlighted() && this.hex[i].getUnit() == null && !unit.afraidOfHex(i) && this.hex[i].sameElement(this.hex[hex]) && (dist = this.shortestPath(hex, i)) < nearest) {
                nearest = dist;
                nearestHex = i;
            }
            ++i;
        }
        this.deHighlightdeTargetAll();
        return nearestHex;
    }

    public boolean oceanAdjacent(Hex h, int continent) {
        int hex = this.getHexIndex(h);
        int index = -1;
        index = this.getNorthHex(hex);
        if (this.insideMap(index) && this.hex[index].getContinent() == continent) {
            return true;
        }
        index = this.getNorthEastHex(hex);
        if (this.insideMap(index) && this.hex[index].getContinent() == continent) {
            return true;
        }
        index = this.getSouthEastHex(hex);
        if (this.insideMap(index) && this.hex[index].getContinent() == continent) {
            return true;
        }
        index = this.getSouthHex(hex);
        if (this.insideMap(index) && this.hex[index].getContinent() == continent) {
            return true;
        }
        index = this.getSouthWestHex(hex);
        if (this.insideMap(index) && this.hex[index].getContinent() == continent) {
            return true;
        }
        index = this.getNorthWestHex(hex);
        return this.insideMap(index) && this.hex[index].getContinent() == continent;
    }

    public int atlanticOceanIndex() {
        int i = 0;
        while (i < this.hex.length) {
            if (this.hex[i] instanceof WaterHex) {
                return this.hex[i].getContinent();
            }
            ++i;
        }
        return -1;
    }

    public int mediterraneanOceanIndex() {
        int continent = -1;
        Hex h = this.hex[this.easternMostPortCity(2)].getAttachedPort();
        int hex = this.getHexIndex(h);
        int index = -1;
        index = this.getNorthHex(hex);
        if (this.insideMap(index) && this.hex[index] instanceof WaterHex) {
            continent = this.hex[index].getContinent();
        }
        if (this.insideMap(index = this.getNorthEastHex(hex)) && this.hex[index] instanceof WaterHex) {
            continent = this.hex[index].getContinent();
        }
        if (this.insideMap(index = this.getSouthEastHex(hex)) && this.hex[index] instanceof WaterHex) {
            continent = this.hex[index].getContinent();
        }
        if (this.insideMap(index = this.getSouthHex(hex)) && this.hex[index] instanceof WaterHex) {
            continent = this.hex[index].getContinent();
        }
        if (this.insideMap(index = this.getSouthWestHex(hex)) && this.hex[index] instanceof WaterHex) {
            continent = this.hex[index].getContinent();
        }
        if (this.insideMap(index = this.getNorthWestHex(hex)) && this.hex[index] instanceof WaterHex) {
            continent = this.hex[index].getContinent();
        }
        return continent;
    }

    private void markContinent(int hex, int continent, boolean land) {
        if (this.insideMap(hex) && this.hex[hex].getContinent() == -1 && (this.hex[hex] instanceof LandHex && land || this.hex[hex] instanceof WaterHex && !land) && !(this.hex[hex].getPResource() instanceof SeaPort)) {
            this.hex[hex].setContinent(continent);
            this.markContinent(this.getNorthHex(hex), continent, land);
            this.markContinent(this.getNorthEastHex(hex), continent, land);
            this.markContinent(this.getSouthEastHex(hex), continent, land);
            this.markContinent(this.getSouthHex(hex), continent, land);
            this.markContinent(this.getSouthWestHex(hex), continent, land);
            this.markContinent(this.getNorthWestHex(hex), continent, land);
        }
    }

    private Vector<Hex> friendlyNeighbouringLandHexes(int hex) {
        int side = this.getCountry(this.hex[hex].getOwningCountry()).getSide();
        Vector<Hex> vect = new Vector<Hex>(6, 5);
        int index = 0;
        index = this.getNorthHex(hex);
        if (this.friendlyEmptyLandHex(index, side)) {
            vect.add(this.hex[index]);
        }
        if (this.friendlyEmptyLandHex(index = this.getNorthEastHex(hex), side)) {
            vect.add(this.hex[index]);
        }
        if (this.friendlyEmptyLandHex(index = this.getSouthEastHex(hex), side)) {
            vect.add(this.hex[index]);
        }
        if (this.friendlyEmptyLandHex(index = this.getSouthHex(hex), side)) {
            vect.add(this.hex[index]);
        }
        if (this.friendlyEmptyLandHex(index = this.getSouthWestHex(hex), side)) {
            vect.add(this.hex[index]);
        }
        if (this.friendlyEmptyLandHex(index = this.getNorthWestHex(hex), side)) {
            vect.add(this.hex[index]);
        }
        return vect;
    }

    private boolean friendlyEmptyLandHex(int hex, int side) {
        if (this.insideMap(hex)) {
            Hex h = this.hex[hex];
            int destHexCountry = h.getOwningCountry();
            return this.country[destHexCountry].getAtWar() && side == this.country[destHexCountry].getSide() && h instanceof LandHex && h.getUnit() == null;
        }
        return false;
    }

    public void highlightReinforceUnits() {
        int i = 0;
        while (i < this.hex.length) {
            Unit u = this.hex[i].getUnit();
            if (u != null && this.friendlyReadyUnit(u) && u.canReinforce()) {
                this.hex[i].setHighlighted(true);
            } else {
                this.hex[i].setHighlighted(false);
            }
            ++i;
        }
    }

    public void highlightUpgradeUnits() {
        int i = 0;
        while (i < this.hex.length) {
            Unit u = this.hex[i].getUnit();
            if (u != null && this.friendlyReadyUnit(u) && u.canUpgrade()) {
                this.hex[i].setHighlighted(true);
            } else {
                this.hex[i].setHighlighted(false);
            }
            ++i;
        }
    }

    public void highlightAirOperateHexes(int hex) {
        int country = this.hex[hex].getOwningCountry();
        int i = 0;
        while (i < this.hex.length) {
            Hex h = this.hex[i];
            int destHexCountry = h.getOwningCountry();
            if (this.country[destHexCountry].getAtWar() && this.country[country].getSide() == this.country[destHexCountry].getSide() && h instanceof LandHex && (country != 5 || destHexCountry == 5) && (country == 5 || destHexCountry != 5) && (h.getPResource() instanceof City || h.getPResource() instanceof Capital || h.getPResource() instanceof Fortress)) {
                if (h.getUnit() == null) {
                    h.setHighlighted(true);
                }
                if (h.getPResource() instanceof City || h.getPResource() instanceof Capital) {
                    Vector<Hex> vect = this.friendlyNeighbouringLandHexes(i);
                    int j = 0;
                    while (j < vect.size()) {
                        vect.get(j).setHighlighted(true);
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    public Color intervalColor(double fraction, boolean blackInsteadOfWhite) {
        Color ret = null;
        int percentage = (int)(100.0 * fraction);
        ret = percentage >= 60 ? (blackInsteadOfWhite ? new Color(0, 0, 0, 127) : new Color(255, 255, 255)) : (percentage >= 40 ? new Color(255, 255, 0, 178) : (percentage >= 20 ? new Color(255, 128, 0, 178) : new Color(255, 0, 0, 178)));
        return ret;
    }

    public Color manpowerColor(double fraction, boolean blackInsteadOfWhite) {
        Color ret = null;
        int percentage = (int)(100.0 * fraction);
        ret = percentage >= 75 ? (blackInsteadOfWhite ? new Color(0, 0, 0, 178) : new Color(255, 255, 255)) : (percentage >= 50 ? new Color(255, 255, 0, 178) : (percentage >= 0 ? new Color(255, 128, 0, 178) : new Color(255, 0, 0, 178)));
        return ret;
    }

    public Color shortageColor(int val, boolean blackInsteadOfWhite) {
        Color ret = null;
        ret = val > 0 ? (blackInsteadOfWhite ? new Color(0, 0, 0, 178) : new Color(255, 255, 255)) : new Color(255, 0, 0, 178);
        return ret;
    }

    public boolean sameOwningSide(int hex1, int hex2) {
        return this.country[this.hex[hex1].getOwningCountry()].getSide() == this.country[this.hex[hex2].getOwningCountry()].getSide();
    }

    public void highlightGroundOperateHexes(int startHex, int currentHex, int movesLeft) {
        this.highlightOperateHex2(startHex, currentHex);
        int nextHex = 0;
        Hex tmp = this.hex[currentHex];
        if (movesLeft > tmp.gettmpMovesLeft()) {
            tmp.settmpMovesLeft(movesLeft);
            nextHex = this.getNorthHex(currentHex);
            if (this.landReachableHex(nextHex, movesLeft) && this.sameOwningSide(startHex, nextHex)) {
                this.highlightGroundOperateHexes(startHex, nextHex, movesLeft - 1);
            }
            if (this.landReachableHex(nextHex = this.getNorthEastHex(currentHex), movesLeft) && this.sameOwningSide(startHex, nextHex)) {
                this.highlightGroundOperateHexes(startHex, nextHex, movesLeft - 1);
            }
            if (this.landReachableHex(nextHex = this.getSouthEastHex(currentHex), movesLeft) && this.sameOwningSide(startHex, nextHex)) {
                this.highlightGroundOperateHexes(startHex, nextHex, movesLeft - 1);
            }
            if (this.landReachableHex(nextHex = this.getSouthHex(currentHex), movesLeft) && this.sameOwningSide(startHex, nextHex)) {
                this.highlightGroundOperateHexes(startHex, nextHex, movesLeft - 1);
            }
            if (this.landReachableHex(nextHex = this.getSouthWestHex(currentHex), movesLeft) && this.sameOwningSide(startHex, nextHex)) {
                this.highlightGroundOperateHexes(startHex, nextHex, movesLeft - 1);
            }
            if (this.landReachableHex(nextHex = this.getNorthWestHex(currentHex), movesLeft) && this.sameOwningSide(startHex, nextHex)) {
                this.highlightGroundOperateHexes(startHex, nextHex, movesLeft - 1);
            }
        }
    }

    public void highlightOperateHex2(int startHex, int currentHex) {
        int country = this.hex[startHex].getOwningCountry();
        Hex h = this.hex[currentHex];
        int destHexCountry = h.getOwningCountry();
        if (this.country[destHexCountry].getAtWar() && this.country[country].getSide() == this.country[destHexCountry].getSide() && h instanceof LandHex && (country != 5 || destHexCountry == 5) && (country == 5 || destHexCountry != 5) && (h.getPResource() instanceof City || h.getPResource() instanceof Capital || h.getPResource() instanceof Fortress)) {
            if (h.getUnit() == null) {
                h.setHighlighted(true);
            }
            if (h.getPResource() instanceof City || h.getPResource() instanceof Capital) {
                Vector<Hex> vect = this.friendlyNeighbouringLandHexes(currentHex);
                int j = 0;
                while (j < vect.size()) {
                    vect.get(j).setHighlighted(true);
                    ++j;
                }
            }
        }
    }

    public void highlightOperateHexes(Hex h) {
        if (this.whosTurn() == this.playerSide() && !this.busy && this.warWindow.getLeftUnitPanel().operatePossible() || this.ai.active) {
            this.busy = true;
            this.resettmpMovesleft();
            int startHex = this.getHexIndex(h);
            this.deHighlightdeTargetAll();
            this.selectedHex = h;
            this.highlightGroundOperateHexes(startHex, startHex, Global.MAX_RAILROAD_DISTANCE);
            this.deTargetAll();
            if (!this.ai.active) {
                this.nowShowing = 6;
                this.warWindow.oneSlowFrame();
            }
            this.busy = false;
        }
    }

    public void highlightAroundUnit(int pointedHex, int moves, boolean cheatHighlight) {
        this.deHighlightdeTargetAll();
        this.resettmpMovesleft();
        Unit u = this.hex[pointedHex].getUnit();
        if (u != null) {
            int movesLeft = moves != -1 ? moves : u.getRealMovement();
            if (u instanceof GroundUnit) {
                this.recursiveGroundMoveHighlight(pointedHex, movesLeft, this.hex[pointedHex].getUnit().getCountryIndex(), this.hex[pointedHex].getUnit(), cheatHighlight);
                if (!this.inEnemyZOC(u) && u.enoughOil()) {
                    this.highlightAllAdjacent(u, pointedHex);
                }
            } else if (u instanceof NavalUnit) {
                this.recursiveGroundMoveHighlight(pointedHex, movesLeft, this.hex[pointedHex].getUnit().getCountryIndex(), this.hex[pointedHex].getUnit(), cheatHighlight);
            } else {
                this.recursiveAirMoveHighlight2(pointedHex, movesLeft, this.hex[pointedHex].getUnit().getCountryIndex(), this.hex[pointedHex].getUnit(), cheatHighlight, false);
            }
        }
    }

    private void highlightAllAdjacent(Unit u, int hex) {
        int index = this.getNorthEastHex(hex);
        if (this.enterable(index, 9999, u.getCountryIndex(), u, 0, false, false) && this.hex[index].getUnit() == null) {
            this.hex[index].setHighlighted(true);
        }
        if (this.enterable(index = this.getSouthEastHex(hex), 9999, u.getCountryIndex(), u, 0, false, false) && this.hex[index].getUnit() == null) {
            this.hex[index].setHighlighted(true);
        }
        if (this.enterable(index = this.getSouthHex(hex), 9999, u.getCountryIndex(), u, 0, false, false) && this.hex[index].getUnit() == null) {
            this.hex[index].setHighlighted(true);
        }
        if (this.enterable(index = this.getSouthWestHex(hex), 9999, u.getCountryIndex(), u, 0, false, false) && this.hex[index].getUnit() == null) {
            this.hex[index].setHighlighted(true);
        }
        if (this.enterable(index = this.getNorthWestHex(hex), 9999, u.getCountryIndex(), u, 0, false, false) && this.hex[index].getUnit() == null) {
            this.hex[index].setHighlighted(true);
        }
        if (this.enterable(index = this.getNorthHex(hex), 9999, u.getCountryIndex(), u, 0, false, false) && this.hex[index].getUnit() == null) {
            this.hex[index].setHighlighted(true);
        }
    }

    private void targetAroundAirUnit(int pointedHex) {
        int row2;
        int col2;
        int row1;
        Unit u = this.hex[pointedHex].getUnit();
        int country = u.getCountryIndex();
        int range = u.getAttackRange();
        int startIndex = this.getStartIndexAroundHex(pointedHex, range);
        int stopIndex = this.getStopIndexAroundHex(pointedHex, range);
        int col1 = this.getColumn(startIndex) - 1;
        if (col1 < 0) {
            col1 = 0;
        }
        if ((row1 = this.getRow(startIndex) - 1) < 0) {
            row1 = 0;
        }
        if ((col2 = this.getColumn(stopIndex) + 1) > 149) {
            col2 = 149;
        }
        if ((row2 = this.getRow(stopIndex) + 1) > 71) {
            row2 = 71;
        }
        int k = col1;
        while (k < col2) {
            int t = row1;
            while (t <= row2) {
                int hexIndex = this.getHex(k, t);
                if (!this.insideMap(hexIndex) || this.shortestPath(pointedHex, hexIndex) > range || this.airTargettable(hexIndex, range, country, u)) {
                    // empty if block
                }
                ++t;
            }
            ++k;
        }
    }

    private void resettmpMovesleft() {
        int i = 0;
        while (i < this.hex.length) {
            this.hex[i].settmpMovesLeft(0);
            ++i;
        }
    }

    private void recursiveGroundMoveHighlight(int currentHex, int movesLeft, int country, Unit unit, boolean cheatHighlight) {
        int nextHex = 0;
        int zocPenalty = 0;
        Hex tmp = this.hex[currentHex];
        if (movesLeft > tmp.gettmpMovesLeft()) {
            tmp.settmpMovesLeft(movesLeft);
            nextHex = this.getNorthHex(currentHex);
            if (this.insideMap(nextHex) && this.enterable(nextHex, movesLeft, country, unit, zocPenalty = this.zocMovePenalty(unit, currentHex, nextHex), cheatHighlight, false)) {
                this.recursiveGroundMoveHighlight(nextHex, movesLeft - this.hex[nextHex].realMovementCost(unit) - zocPenalty, country, unit, cheatHighlight);
            }
            if (this.insideMap(nextHex = this.getNorthEastHex(currentHex)) && this.enterable(nextHex, movesLeft, country, unit, zocPenalty = this.zocMovePenalty(unit, currentHex, nextHex), cheatHighlight, false)) {
                this.recursiveGroundMoveHighlight(nextHex, movesLeft - this.hex[nextHex].realMovementCost(unit) - zocPenalty, country, unit, cheatHighlight);
            }
            if (this.insideMap(nextHex = this.getSouthEastHex(currentHex)) && this.enterable(nextHex, movesLeft, country, unit, zocPenalty = this.zocMovePenalty(unit, currentHex, nextHex), cheatHighlight, false)) {
                this.recursiveGroundMoveHighlight(nextHex, movesLeft - this.hex[nextHex].realMovementCost(unit) - zocPenalty, country, unit, cheatHighlight);
            }
            if (this.insideMap(nextHex = this.getSouthHex(currentHex)) && this.enterable(nextHex, movesLeft, country, unit, zocPenalty = this.zocMovePenalty(unit, currentHex, nextHex), cheatHighlight, false)) {
                this.recursiveGroundMoveHighlight(nextHex, movesLeft - this.hex[nextHex].realMovementCost(unit) - zocPenalty, country, unit, cheatHighlight);
            }
            if (this.insideMap(nextHex = this.getSouthWestHex(currentHex)) && this.enterable(nextHex, movesLeft, country, unit, zocPenalty = this.zocMovePenalty(unit, currentHex, nextHex), cheatHighlight, false)) {
                this.recursiveGroundMoveHighlight(nextHex, movesLeft - this.hex[nextHex].realMovementCost(unit) - zocPenalty, country, unit, cheatHighlight);
            }
            if (this.insideMap(nextHex = this.getNorthWestHex(currentHex)) && this.enterable(nextHex, movesLeft, country, unit, zocPenalty = this.zocMovePenalty(unit, currentHex, nextHex), cheatHighlight, false)) {
                this.recursiveGroundMoveHighlight(nextHex, movesLeft - this.hex[nextHex].realMovementCost(unit) - zocPenalty, country, unit, cheatHighlight);
            }
        }
    }

    private void recursiveAirMoveHighlight2(int currentHex, int movesLeft, int country, Unit unit, boolean cheatHighlight, boolean spottingMove) {
        int nextHex = 0;
        boolean zocPenalty = false;
        Hex tmp = this.hex[currentHex];
        if (movesLeft > tmp.gettmpMovesLeft()) {
            tmp.settmpMovesLeft(movesLeft);
            nextHex = this.getNorthHex(currentHex);
            if (this.insideMap(nextHex) && this.enterable(nextHex, movesLeft, country, unit, 0, cheatHighlight, spottingMove)) {
                this.recursiveAirMoveHighlight2(nextHex, movesLeft - 1, country, unit, cheatHighlight, spottingMove);
            }
            if (this.insideMap(nextHex = this.getNorthEastHex(currentHex)) && this.enterable(nextHex, movesLeft, country, unit, 0, cheatHighlight, spottingMove)) {
                this.recursiveAirMoveHighlight2(nextHex, movesLeft - 1, country, unit, cheatHighlight, spottingMove);
            }
            if (this.insideMap(nextHex = this.getSouthEastHex(currentHex)) && this.enterable(nextHex, movesLeft, country, unit, 0, cheatHighlight, spottingMove)) {
                this.recursiveAirMoveHighlight2(nextHex, movesLeft - 1, country, unit, cheatHighlight, spottingMove);
            }
            if (this.insideMap(nextHex = this.getSouthHex(currentHex)) && this.enterable(nextHex, movesLeft, country, unit, 0, cheatHighlight, spottingMove)) {
                this.recursiveAirMoveHighlight2(nextHex, movesLeft - 1, country, unit, cheatHighlight, spottingMove);
            }
            if (this.insideMap(nextHex = this.getSouthWestHex(currentHex)) && this.enterable(nextHex, movesLeft, country, unit, 0, cheatHighlight, spottingMove)) {
                this.recursiveAirMoveHighlight2(nextHex, movesLeft - 1, country, unit, cheatHighlight, spottingMove);
            }
            if (this.insideMap(nextHex = this.getNorthWestHex(currentHex)) && this.enterable(nextHex, movesLeft, country, unit, 0, cheatHighlight, spottingMove)) {
                this.recursiveAirMoveHighlight2(nextHex, movesLeft - 1, country, unit, cheatHighlight, spottingMove);
            }
        }
    }

    public boolean landReachableDestination(int startHex, int currentHex, int destinationHex, int movesLeft) {
        if (this.hex[startHex].getContinent() != this.hex[destinationHex].getContinent()) {
            this.resettmpMovesleft();
            return false;
        }
        this.highlightAroundUnit(startHex, movesLeft, true);
        int i = 0;
        while (i < this.hex.length) {
            if (this.hex[i].getHighlighted() && this.shortestPath(i, destinationHex) < this.shortestPath(startHex, destinationHex)) {
                return true;
            }
            ++i;
        }
        this.deHighlightdeTargetAll();
        return false;
    }

    public boolean canRepair(int side) {
        int i = 0;
        while (i < this.country.length) {
            if (this.country[i].getSide() == side) {
                Vector<Unit> v = this.country[i].getUnits();
                int j = 0;
                while (j < v.size()) {
                    Unit u = v.get(j);
                    if (u.getOnHex() != null && u.canReinforce()) {
                        return true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }

    public boolean canUpgrade(int side) {
        int i = 0;
        while (i < this.country.length) {
            if (this.country[i].getSide() == side) {
                Vector<Unit> v = this.country[i].getUnits();
                int j = 0;
                while (j < v.size()) {
                    Unit u = v.get(j);
                    if (u.getOnHex() != null && u.canUpgrade()) {
                        return true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }

    public void setTutorialMessage(int msg) {
        Tutorial t = this.gameState.getTutorial();
        if (t.isActive() && !t.alreadyShown(msg)) {
            t.showing = msg;
        }
    }

    public void showTutorialMessageIfNeeded2() {
        Tutorial t = this.gameState.getTutorial();
        if (t.isActive() && !t.alreadyShown(t.showing)) {
            Game.delay(200L);
            this.setBusy(true);
            this.warWindow.showOkDialogLarge(Global.getMessage(402), t.getMessage(t.showing));
            this.setBusy(false);
            t.deactiveTutorialMessage(t.showing);
            this.resetScrolling();
        }
    }

    public int owningFaction(int hex) {
        if (this.hex[hex] instanceof LandHex) {
            int owningCountry = this.hex[hex].getOwningCountry();
            return this.country[owningCountry].getFaction();
        }
        return -1;
    }

    private boolean enterable(int hexi, int movesLeft, int country, Unit unit, int zocPenalty, boolean cheatMove, boolean cheatMove2) {
        if (!this.insideMap(hexi)) {
            return false;
        }
        Hex tmp = this.hex[hexi];
        Country enterHexCountry = this.country[tmp.getOwningCountry()];
        if (cheatMove2) {
            this.hex[hexi].setHighlighted(true);
            return true;
        }
        if (cheatMove && movesLeft > 0) {
            if (this.hex[hexi] instanceof WaterHex) {
                if (unit instanceof NavalUnit) {
                    this.hex[hexi].setHighlighted(true);
                    return true;
                }
            } else if (enterHexCountry.getAtWar() || this.getHexIndex(unit.getDestinationHex()) == enterHexCountry.activeCapital()) {
                this.hex[hexi].setHighlighted(true);
                return true;
            }
        }
        boolean ret = false;
        if (!this.country[tmp.getOwningCountry()].getAtWar()) {
            ret = false;
        } else {
            if (unit instanceof AirUnit && movesLeft > 0) {
                ret = true;
            }
            if (this.hex[hexi] instanceof WaterHex && unit instanceof GroundUnit) {
                ret = false;
            } else if (this.hex[hexi] instanceof LandHex && unit instanceof NavalUnit) {
                ret = false;
            } else if (this.hex[hexi] instanceof LoopHex && unit.getSide() != this.gameState.getAfricaLoop().getControllingSide()) {
                ret = false;
            } else if (this.hex[hexi] instanceof LoopHex2 && unit.getSide() != this.gameState.getSuezLoop().getControllingSide()) {
                ret = false;
            } else if (this.hex[hexi].getUnit() != null) {
                if (this.hex[hexi].getUnit().getCountry().getSide() == this.country[country].getSide() && movesLeft >= this.hex[hexi].realMovementCost(unit)) {
                    ret = true;
                } else if (movesLeft < this.hex[hexi].realMovementCost(unit)) {
                    ret = false;
                } else if (this.hex[hexi].getPResource() instanceof SeaPort && this.country[this.hex[hexi].getOwningCountry()].getSide() != this.whosTurn()) {
                    ret = false;
                } else if (!this.canSeeUnit(this.hex[hexi].getUnit(), unit.getSide())) {
                    if (!(unit instanceof AirUnit)) {
                        this.hex[hexi].setHighlighted(true);
                    }
                    ret = true;
                } else {
                    ret = unit instanceof AirUnit;
                }
            } else if (unit instanceof AirUnit && movesLeft > 0) {
                ret = true;
                if (this.hex[hexi] instanceof LandHex && enterHexCountry.getAtWar() && (enterHexCountry.getSide() == this.getCountry(country).getSide() || this.hex[hexi].getSupply() == 0)) {
                    this.hex[hexi].setHighlighted(true);
                }
            } else if (movesLeft >= this.hex[hexi].realMovementCost(unit) + zocPenalty) {
                if (this.hex[hexi].getPResource() instanceof SeaPort && this.country[this.hex[hexi].getOwningCountry()].getSide() != this.whosTurn()) {
                    ret = false;
                } else {
                    ret = true;
                    this.hex[hexi].setHighlighted(true);
                }
            } else {
                ret = false;
            }
        }
        return ret;
    }

    private boolean landReachableHex(int hex, int movesLeft) {
        if (!this.insideMap(hex)) {
            return false;
        }
        Hex tmp = this.hex[hex];
        boolean ret = false;
        if (hex == -1) {
            ret = false;
        } else if (!this.country[tmp.getOwningCountry()].getAtWar()) {
            ret = false;
        } else if (this.hex[hex] instanceof WaterHex) {
            ret = false;
        } else if (movesLeft > 0) {
            ret = true;
        }
        return ret;
    }

    private boolean airTargettable(int hex, int movesLeft, int country, Unit unit) {
        Hex tmp = this.hex[hex];
        boolean ret = true;
        if (hex == -1) {
            ret = false;
        } else if (this.country[tmp.getOwningCountry()].getAtWar()) {
            if (movesLeft < 1) {
                ret = false;
            } else if (this.hex[hex].getPResource() != null) {
                if (this.country[this.hex[hex].getOwningCountry()].getSide() != this.whosTurn()) {
                    this.hex[hex].setTargetted(true);
                }
            } else if (this.hex[hex].getUnit() != null && this.country[this.hex[hex].getUnit().getCountryIndex()].getSide() != this.whosTurn() && this.canSeeUnit(this.hex[hex].getUnit(), unit.getSide())) {
                this.hex[hex].setTargetted(true);
            }
        }
        return ret;
    }

    private boolean routable(int startHex, int targetHex, int movesLeft, int country, Unit unit) {
        if (!this.insideMap(targetHex)) {
            return false;
        }
        int zocPenalty = this.zocMovePenalty(unit, startHex, targetHex);
        boolean ret = false;
        if (targetHex == -1) {
            ret = false;
        } else if (this.hex[targetHex] instanceof WaterHex && unit instanceof GroundUnit) {
            ret = false;
        } else if (this.hex[targetHex] instanceof LandHex && unit instanceof NavalUnit) {
            ret = false;
        } else if (this.hex[targetHex].getUnit() != null) {
            ret = this.hex[targetHex].getUnit().getCountry().getSide() == this.country[country].getSide() && movesLeft >= this.hex[targetHex].realMovementCost(unit) + zocPenalty ? true : (movesLeft < this.hex[targetHex].realMovementCost(unit) ? false : (this.hex[targetHex].getPResource() instanceof SeaPort && this.country[this.hex[targetHex].getOwningCountry()].getSide() != this.whosTurn() ? false : (!this.canSeeUnit(this.hex[targetHex].getUnit(), unit.getSide()) ? true : unit instanceof AirUnit)));
        } else if (this.hex[targetHex].getPResource() instanceof SeaPort && this.country[this.hex[targetHex].getOwningCountry()].getSide() != this.whosTurn()) {
            ret = false;
        } else if (movesLeft >= this.hex[targetHex].realMovementCost(unit) + zocPenalty && this.country[this.hex[targetHex].getOwningCountry()].getAtWar()) {
            ret = true;
        }
        return ret;
    }

    public int mousePointedHex(int pointedPixelX, int pointedPixelY, boolean scrollOffset) {
        int x = pointedPixelX;
        int y = pointedPixelY;
        if (scrollOffset) {
            Point p = this.warWindow.getMapCanvas().getViewPosition();
            x += p.x;
            y += p.y;
        }
        double posx = 15.0;
        posx = ((double)(x /= this.getZoom()) + 10.0) / posx;
        double posy = 16.0;
        posy = (double)(y /= this.getZoom()) / posy;
        int minX = (int)posy - 1;
        int maxX = (int)posy + 1;
        int minY = (int)posx - 1;
        int maxY = (int)posx + 1;
        if (minX < 0) {
            minX = 0;
        }
        if (minY < 0) {
            minY = 0;
        }
        if (maxX < 0) {
            maxX = 0;
        }
        if (maxY < 0) {
            maxY = 0;
        }
        if (minX >= 72) {
            minX = 71;
        }
        if (minY >= 150) {
            minY = 149;
        }
        if (maxX >= 72) {
            maxX = 71;
        }
        if (maxY >= 150) {
            maxY = 149;
        }
        int hx = minX;
        while (hx <= maxX) {
            int hy = minY;
            while (hy <= maxY) {
                int i = this.getHex(hy, hx);
                if (this.hex[i].getPolygon().contains(x, y)) {
                    return i;
                }
                ++hy;
            }
            ++hx;
        }
        return -1;
    }

    public Country getCountry(int index) {
        return this.country[index];
    }

    public Hex[] getHexes() {
        return this.hex;
    }

    public void controlHex(int hex, int country) {
        this.hex[hex].setOwningCountry(country);
    }

    public void controlHex(int col, int row, int country) {
        int index = col * 72 + row;
        this.hex[index].setOwningCountry(country);
    }

    public void controlHexArea(int col, int row, int col2, int row2, int country) {
        int i = col;
        while (i <= col2) {
            int tmp = i * 72 + row;
            int tmp2 = i * 72 + row2;
            int j = tmp;
            while (j <= tmp2) {
                this.hex[j].setOwningCountry(country);
                ++j;
            }
            ++i;
        }
    }

    public void makeLandHexesArea(int col, int row, int col2, int row2) {
        int i = col;
        while (i <= col2) {
            int tmp = i * 72 + row;
            int tmp2 = i * 72 + row2;
            int j = tmp;
            while (j <= tmp2) {
                this.hex[j] = new LandHex();
                ++j;
            }
            ++i;
        }
    }

    public int getColumn(int hex) {
        return hex / 72;
    }

    public int getRow(int hex) {
        return hex % 72;
    }

    public int getHex(int column, int row) {
        return column * 72 + row;
    }

    public void transport(int hexIndex, boolean hereFirst) {
        if (!this.busy || !hereFirst) {
            this.busy = true;
            Unit u = this.hex[hexIndex].getUnit();
            int hex = this.transportHex(u);
            u.getCountry().transport(u, this.hex[hex], false);
            this.deSelect();
            this.warWindow.oneSlowFrame();
            this.warWindow.showPP(false);
            if (hereFirst && this.getGameMode() == 3000) {
                String s = "t " + hexIndex;
                this.sendDataToOpponent(s);
            }
            if (hereFirst) {
                this.warWindow.closeForcePool();
            }
            this.busy = false;
        }
    }

    public boolean raidPossible() {
        Unit u = this.warWindow.getLeftUnit();
        if (u == null) {
            return false;
        }
        return u.canRaid();
    }

    public boolean loopPossible() {
        Unit u = this.warWindow.getLeftUnit();
        if (u == null) {
            return false;
        }
        boolean canLoop = false;
        if (u.getOnHex() instanceof LoopHex || u.getOnHex() instanceof LoopHex2) {
            canLoop = true;
        }
        return canLoop;
    }

    public boolean reassignCommanderPossible() {
        Unit u = this.warWindow.getLeftUnit();
        if (u == null) {
            return false;
        }
        return u.canReassignCommander();
    }

    public void changeZoom(boolean zoomIn, boolean turnAround, boolean forced) {
        if (this.allowInput() || forced) {
            Hex centerHex = this.getHex(this.getCenteredHex());
            int preZoom = this.getZoom();
            this.gameState.changeZoom(zoomIn, turnAround);
            if (this.getZoom() != preZoom) {
                this.warWindow.getMapCanvas().zoomChangeRescale(preZoom, this.getZoom());
                this.warWindow.getMapCanvas().setMapViewPosition(centerHex, false);
                this.warWindow.oneSlowFrame();
                this.warWindow.getMiniMap().repaint();
            }
        }
    }

    public void reassignCommander(int hexIndex, boolean hereFirst) {
        if (!this.busy && this.reassignCommanderPossible() || !hereFirst) {
            this.busy = true;
            Unit u = this.hex[hexIndex].getUnit();
            int turns = 1 + this.shortestPath(hexIndex, u.getCountry().activeCapital()) / Global.COMMANDER_REASSIGN_DISTANCE_PER_TURN;
            boolean answer = true;
            if (hereFirst) {
                this.getWarWindow().showYesNoDialog(Global.createLanguageMessage(103, new String[]{"" + Global.COMMANDER_REASSIGN_COST, "" + turns}));
                answer = this.getWarWindow().getYesNoDialog().yesSelected();
            }
            if (answer) {
                u.getCountry().reassignCommander(u, turns);
                this.deSelect();
                this.warWindow.showPP(false);
                if (hereFirst) {
                    String s = "d " + hexIndex + " ";
                    this.sendDataToOpponent(s);
                }
            }
            this.busy = false;
        }
    }

    public int transportHex(Unit u) {
        int seaPort = this.hasFriendlyPortAdjacent(u);
        if (seaPort != -1) {
            if (this.hex[seaPort].getUnit() == null) {
                return seaPort;
            }
            if (this.getEmptyAdjacentWaterHex(seaPort, false) != -1) {
                return this.getEmptyAdjacentWaterHex(seaPort, false);
            }
        }
        return -1;
    }

    public int hasFriendlyPortAdjacent(Unit u) {
        int i;
        Hex h = u.getOnHex();
        if (u.getOnHex() == null) {
            return -1;
        }
        int index = this.getHexIndex(h);
        int index2 = this.getNorthHex(index);
        if (this.insideMap(index2) && this.hex[index2].getPResource() instanceof SeaPort && this.hex[index2].getSupply() >= Global.HALF_SUPPLY) {
            i = 0;
            while (i < this.hex.length) {
                if (this.hex[i].getAttachedPort() != null && this.hex[i].getAttachedPort().getPResource() == this.hex[index2].getPResource() && this.country[this.hex[i].getOwningCountry()].getSide() == u.getSide()) {
                    return index2;
                }
                ++i;
            }
        }
        if (this.insideMap(index2 = this.getNorthEastHex(index)) && this.hex[index2].getPResource() instanceof SeaPort && this.hex[index2].getSupply() >= Global.HALF_SUPPLY) {
            i = 0;
            while (i < this.hex.length) {
                if (this.hex[i].getAttachedPort() != null && this.hex[i].getAttachedPort().getPResource() == this.hex[index2].getPResource() && this.country[this.hex[i].getOwningCountry()].getSide() == u.getSide()) {
                    return index2;
                }
                ++i;
            }
        }
        if (this.insideMap(index2 = this.getSouthEastHex(index)) && this.hex[index2].getPResource() instanceof SeaPort && this.hex[index2].getSupply() >= Global.HALF_SUPPLY) {
            i = 0;
            while (i < this.hex.length) {
                if (this.hex[i].getAttachedPort() != null && this.hex[i].getAttachedPort().getPResource() == this.hex[index2].getPResource() && this.country[this.hex[i].getOwningCountry()].getSide() == u.getSide()) {
                    return index2;
                }
                ++i;
            }
        }
        if (this.insideMap(index2 = this.getSouthHex(index)) && this.hex[index2].getPResource() instanceof SeaPort && this.hex[index2].getSupply() >= Global.HALF_SUPPLY) {
            i = 0;
            while (i < this.hex.length) {
                if (this.hex[i].getAttachedPort() != null && this.hex[i].getAttachedPort().getPResource() == this.hex[index2].getPResource() && this.country[this.hex[i].getOwningCountry()].getSide() == u.getSide()) {
                    return index2;
                }
                ++i;
            }
        }
        if (this.insideMap(index2 = this.getSouthWestHex(index)) && this.hex[index2].getPResource() instanceof SeaPort && this.hex[index2].getSupply() >= Global.HALF_SUPPLY) {
            i = 0;
            while (i < this.hex.length) {
                if (this.hex[i].getAttachedPort() != null && this.hex[i].getAttachedPort().getPResource() == this.hex[index2].getPResource() && this.country[this.hex[i].getOwningCountry()].getSide() == u.getSide()) {
                    return index2;
                }
                ++i;
            }
        }
        if (this.insideMap(index2 = this.getNorthWestHex(index)) && this.hex[index2].getPResource() instanceof SeaPort && this.hex[index2].getSupply() >= Global.HALF_SUPPLY) {
            i = 0;
            while (i < this.hex.length) {
                if (this.hex[i].getAttachedPort() != null && this.hex[i].getAttachedPort().getPResource() == this.hex[index2].getPResource() && this.country[this.hex[i].getOwningCountry()].getSide() == u.getSide()) {
                    return index2;
                }
                ++i;
            }
        }
        return -1;
    }

    public int hasSuppliedPortAdjacent(Unit u) {
        Hex h = u.getOnHex();
        if (u.getOnHex() == null) {
            return -1;
        }
        int index = this.getHexIndex(h);
        int index2 = this.getNorthHex(index);
        if (this.hex[this.getNorthEastHex(index)].getPResource() instanceof SeaPort && this.hex[this.getNorthEastHex(index)].getUnit() == null && this.hex[this.getNorthEastHex(index)].getSupply() > 0) {
            return this.getNorthEastHex(index);
        }
        index2 = this.getNorthHex(index);
        if (this.insideMap(index2) && this.hex[index2].getPResource() instanceof SeaPort && this.hex[index2].getSupply() > 0) {
            return index2;
        }
        index2 = this.getNorthEastHex(index);
        if (this.insideMap(index2) && this.hex[index2].getPResource() instanceof SeaPort && this.hex[index2].getSupply() > 0) {
            return index2;
        }
        index2 = this.getSouthEastHex(index);
        if (this.insideMap(index2) && this.hex[index2].getPResource() instanceof SeaPort && this.hex[index2].getSupply() > 0) {
            return index2;
        }
        index2 = this.getSouthHex(index);
        if (this.insideMap(index2) && this.hex[index2].getPResource() instanceof SeaPort && this.hex[index2].getSupply() > 0) {
            return index2;
        }
        index2 = this.getSouthWestHex(index);
        if (this.insideMap(index2) && this.hex[index2].getPResource() instanceof SeaPort && this.hex[index2].getSupply() > 0) {
            return index2;
        }
        index2 = this.getNorthWestHex(index);
        if (this.insideMap(index2) && this.hex[index2].getPResource() instanceof SeaPort && this.hex[index2].getSupply() > 0) {
            return index2;
        }
        return -1;
    }

    public boolean hasLandingSpotsAdjacent(Unit u) {
        Hex h = u.getOnHex();
        if (u.getOnHex() == null) {
            return false;
        }
        int index = this.getHexIndex(h);
        int index2 = this.getNorthEastHex(index);
        if (this.insideMap(index2) && this.hex[this.getNorthEastHex(index)] instanceof LandHex && this.hex[this.getNorthEastHex(index)].getUnit() == null && this.country[this.hex[this.getNorthEastHex(index)].getOwningCountry()].getAtWar()) {
            return true;
        }
        index2 = this.getSouthEastHex(index);
        if (this.insideMap(index2) && this.hex[this.getSouthEastHex(index)] instanceof LandHex && this.hex[this.getSouthEastHex(index)].getUnit() == null && this.country[this.hex[this.getSouthEastHex(index)].getOwningCountry()].getAtWar()) {
            return true;
        }
        index2 = this.getSouthHex(index);
        if (this.insideMap(index2) && this.hex[this.getSouthHex(index)] instanceof LandHex && this.hex[this.getSouthHex(index)].getUnit() == null && this.country[this.hex[this.getSouthHex(index)].getOwningCountry()].getAtWar()) {
            return true;
        }
        index2 = this.getSouthWestHex(index);
        if (this.insideMap(index2) && this.hex[this.getSouthWestHex(index)] instanceof LandHex && this.hex[this.getSouthWestHex(index)].getUnit() == null && this.country[this.hex[this.getSouthWestHex(index)].getOwningCountry()].getAtWar()) {
            return true;
        }
        index2 = this.getNorthWestHex(index);
        if (this.insideMap(index2) && this.hex[this.getNorthWestHex(index)] instanceof LandHex && this.hex[this.getNorthWestHex(index)].getUnit() == null && this.country[this.hex[this.getNorthWestHex(index)].getOwningCountry()].getAtWar()) {
            return true;
        }
        index2 = this.getNorthHex(index);
        return this.insideMap(index2) && this.hex[this.getNorthHex(index)] instanceof LandHex && this.hex[this.getNorthHex(index)].getUnit() == null && this.country[this.hex[this.getNorthHex(index)].getOwningCountry()].getAtWar();
    }

    public void highlightUnloadHexes(Hex h) {
        if (this.whosTurn() == this.playerSide() && !this.busy && this.warWindow.getLeftUnitPanel().unloadPossible() || this.ai.active) {
            Hex tmp;
            this.busy = true;
            this.deHighlightdeTargetAll();
            int index = this.getHexIndex(h);
            int index2 = this.getNorthEastHex(index);
            if (this.insideMap(index2) && (tmp = this.hex[this.getNorthEastHex(index)]) instanceof LandHex && tmp.getUnit() == null && this.country[tmp.getOwningCountry()].getAtWar() && tmp.realMovementCost(h.getUnit()) < 3) {
                tmp.setHighlighted(true);
            }
            if (this.insideMap(index2 = this.getSouthEastHex(index)) && (tmp = this.hex[this.getSouthEastHex(index)]) instanceof LandHex && tmp.getUnit() == null && this.country[tmp.getOwningCountry()].getAtWar() && tmp.realMovementCost(h.getUnit()) < 3) {
                tmp.setHighlighted(true);
            }
            if (this.insideMap(index2 = this.getSouthHex(index)) && (tmp = this.hex[this.getSouthHex(index)]) instanceof LandHex && tmp.getUnit() == null && this.country[tmp.getOwningCountry()].getAtWar() && tmp.realMovementCost(h.getUnit()) < 3) {
                tmp.setHighlighted(true);
            }
            if (this.insideMap(index2 = this.getSouthWestHex(index)) && (tmp = this.hex[this.getSouthWestHex(index)]) instanceof LandHex && tmp.getUnit() == null && this.country[tmp.getOwningCountry()].getAtWar() && tmp.realMovementCost(h.getUnit()) < 3) {
                tmp.setHighlighted(true);
            }
            if (this.insideMap(index2 = this.getNorthWestHex(index)) && (tmp = this.hex[this.getNorthWestHex(index)]) instanceof LandHex && tmp.getUnit() == null && this.country[tmp.getOwningCountry()].getAtWar() && tmp.realMovementCost(h.getUnit()) < 3) {
                tmp.setHighlighted(true);
            }
            if (this.insideMap(index2 = this.getNorthHex(index)) && (tmp = this.hex[this.getNorthHex(index)]) instanceof LandHex && tmp.getUnit() == null && this.country[tmp.getOwningCountry()].getAtWar() && tmp.realMovementCost(h.getUnit()) < 3) {
                tmp.setHighlighted(true);
            }
            this.warWindow.oneSlowFrame();
            this.busy = false;
        }
    }

    public int getNorthHex(int hex) {
        int column = this.getColumn(hex);
        int row = this.getRow(hex);
        int newRow = row - 1;
        if (newRow < 0) {
            return -1;
        }
        int newCol = column;
        return this.getHex(newCol, newRow);
    }

    public int getNorthEastHex(int hex) {
        int column = this.getColumn(hex);
        int row = this.getRow(hex);
        int newRow = row - 1;
        if (column % 2 != 0) {
            ++newRow;
        }
        int newCol = column + 1;
        if (newRow < 0) {
            return -1;
        }
        if (newCol >= 150) {
            return -1;
        }
        return this.getHex(newCol, newRow);
    }

    public int getSouthEastHex(int hex) {
        int row;
        int column = this.getColumn(hex);
        int newRow = row = this.getRow(hex);
        if (column % 2 != 0) {
            ++newRow;
        }
        int newCol = column + 1;
        if (newRow >= 72) {
            return -1;
        }
        if (newCol >= 150) {
            return -1;
        }
        return this.getHex(newCol, newRow);
    }

    public int getSouthHex(int hex) {
        int column = this.getColumn(hex);
        int row = this.getRow(hex);
        int newRow = row + 1;
        int newCol = column;
        if (newRow >= 72) {
            return -1;
        }
        return this.getHex(newCol, newRow);
    }

    public int getSouthWestHex(int hex) {
        int row;
        int column = this.getColumn(hex);
        int newRow = row = this.getRow(hex);
        if (column % 2 != 0) {
            ++newRow;
        }
        int newCol = column - 1;
        if (newRow >= 72) {
            return -1;
        }
        if (newCol < 0) {
            return -1;
        }
        return this.getHex(newCol, newRow);
    }

    public int getNorthWestHex(int hex) {
        int column = this.getColumn(hex);
        int row = this.getRow(hex);
        int newRow = row - 1;
        if (column % 2 != 0) {
            ++newRow;
        }
        int newCol = column - 1;
        if (newRow < 0) {
            return -1;
        }
        if (newCol < 0) {
            return -1;
        }
        return this.getHex(newCol, newRow);
    }

    public boolean crossingRiver(int startHex, int endHex) {
        return this.getNorthHex(startHex) == endHex ? this.hex[endHex] instanceof LandHex && (((LandHex)this.hex[startHex]).hasRiverN() || ((LandHex)this.hex[endHex]).hasRiverS()) : (this.getNorthEastHex(startHex) == endHex ? this.hex[endHex] instanceof LandHex && (((LandHex)this.hex[startHex]).hasRiverNE() || ((LandHex)this.hex[endHex]).hasRiverSW()) : (this.getSouthEastHex(startHex) == endHex ? this.hex[endHex] instanceof LandHex && (((LandHex)this.hex[startHex]).hasRiverSE() || ((LandHex)this.hex[endHex]).hasRiverNW()) : (this.getSouthHex(startHex) == endHex ? this.hex[endHex] instanceof LandHex && (((LandHex)this.hex[startHex]).hasRiverS() || ((LandHex)this.hex[endHex]).hasRiverN()) : (this.getSouthWestHex(startHex) == endHex ? this.hex[endHex] instanceof LandHex && (((LandHex)this.hex[startHex]).hasRiverSW() || ((LandHex)this.hex[endHex]).hasRiverNE()) : this.getNorthWestHex(startHex) == endHex && this.hex[endHex] instanceof LandHex && (((LandHex)this.hex[startHex]).hasRiverNW() || ((LandHex)this.hex[endHex]).hasRiverSE())))));
    }

    public void markArrow(int startHex, int endHex) {
        if (this.getNorthHex(startHex) == endHex && !this.hex[startHex].getHasArrowS()) {
            this.hex[startHex].setHasArrowN(true);
        } else if (this.getNorthEastHex(startHex) == endHex && !this.hex[endHex].getHasArrowSW()) {
            this.hex[startHex].setHasArrowNE(true);
        } else if (this.getSouthEastHex(startHex) == endHex && !this.hex[endHex].getHasArrowNW()) {
            this.hex[startHex].setHasArrowSE(true);
        } else if (this.getSouthHex(startHex) == endHex && !this.hex[endHex].getHasArrowN()) {
            this.hex[startHex].setHasArrowS(true);
        } else if (this.getSouthWestHex(startHex) == endHex && !this.hex[endHex].getHasArrowNE()) {
            this.hex[startHex].setHasArrowSW(true);
        } else if (this.getNorthWestHex(startHex) == endHex && !this.hex[endHex].getHasArrowSE()) {
            this.hex[startHex].setHasArrowNW(true);
        }
    }

    public Hex getHex(int i) {
        return this.hex[i];
    }

    public int hexLength() {
        return this.hex.length;
    }

    public int getHexIndex(Hex h) {
        int i = 0;
        while (i < this.hex.length) {
            if (h == this.hex[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public WarWindow getWarWindow() {
        return this.warWindow;
    }

    private void createMap() {
        this.hex = new Hex[10800];
        int halfHexSide = 5;
        int halfBigHexWidth = 10;
        int halfSmallHexWidth = 8;
        int i = 0;
        while (i < this.hex.length) {
            this.hex[i] = new WaterHex();
            ++i;
        }
        double[] polX = new double[6];
        double[] polY = new double[6];
        int[] intPolX = new int[6];
        int[] intPolY = new int[6];
        int hexX = 0;
        int hexY = 0;
        int index = 0;
        while (index < this.hex.length) {
            hexX = index / 72;
            hexY = index - hexX * 72;
            polX[0] = hexX * 5 + hexX * 10;
            polX[1] = polX[0] + 10.0;
            polX[2] = polX[1] + 10.0 - 5.0;
            polX[3] = polX[1];
            polX[4] = polX[0];
            polX[5] = polX[2] - 20.0;
            polY[0] = hexY * 16 - 8;
            if (hexX % 2 == 1) {
                polY[0] = polY[0] + 8.0;
            }
            polY[1] = polY[0];
            polY[2] = polY[1] + 8.0;
            polY[3] = polY[0] + 16.0;
            polY[4] = polY[3];
            polY[5] = polY[2];
            intPolX[0] = (int)polX[0];
            intPolX[1] = (int)polX[1];
            intPolX[2] = (int)polX[2];
            intPolX[3] = (int)polX[3];
            intPolX[4] = (int)polX[4];
            intPolX[5] = (int)polX[5];
            intPolY[0] = (int)polY[0];
            intPolY[1] = (int)polY[1];
            intPolY[2] = (int)polY[2];
            intPolY[3] = (int)polY[3];
            intPolY[4] = (int)polY[4];
            intPolY[5] = (int)polY[5];
            this.hex[index].setPolygon(new Polygon(intPolX, intPolY, 6));
            ++index;
        }
    }

    private void createOceans() {
        int i = 0;
        while (i < this.hex.length) {
            this.markContinent(i, i, false);
            ++i;
        }
    }

    private void createContinents() {
        int i = 0;
        while (i < this.hex.length) {
            this.markContinent(i, i, true);
            ++i;
        }
    }

    public void createMiniMap() {
        int numPix = this.warWindow.getMiniMap().getWidth() * this.warWindow.getMiniMap().getHeight();
        int[] usedForMiniMap = new int[numPix];
        int width = this.warWindow.getMiniMap().getWidth();
        int height = this.warWindow.getMiniMap().getHeight();
        int count = 0;
        int i = 0;
        while (i < width) {
            int j = 0;
            while (j < height) {
                Hex h;
                int pointed = this.mousePointedHex((int)(8.52 * (double)i), (int)(8.52 * (double)j), false);
                usedForMiniMap[count] = pointed == -1 ? -1 : ((h = this.hex[pointed]) instanceof WaterHex ? 1 : (h.getOwningCountry() == 26 ? -1 : 0));
                ++count;
                ++j;
            }
            ++i;
        }
        this.warWindow.getMiniMap().setPixels(usedForMiniMap);
    }

    private boolean editorNames() {
        boolean ret = false;
        switch (Global.getLanguage()) {
            case 1: {
                if (Global.SETTINGS_DATA.getVal("ENGLISH_NAMES") != 1) break;
                ret = true;
                break;
            }
            case 2: {
                if (Global.SETTINGS_DATA.getVal("FRENCH_NAMES") != 1) break;
                ret = true;
                break;
            }
            case 3: {
                if (Global.SETTINGS_DATA.getVal("ITALIAN_NAMES") != 1) break;
                ret = true;
                break;
            }
            case 4: {
                if (Global.SETTINGS_DATA.getVal("SPANISH_NAMES") != 1) break;
                ret = true;
                break;
            }
            case 5: {
                if (Global.SETTINGS_DATA.getVal("POLISH_NAMES") != 1) break;
                ret = true;
                break;
            }
            case 6: {
                if (Global.SETTINGS_DATA.getVal("GERMAN_NAMES") != 1) break;
                ret = true;
                break;
            }
            case 7: {
                if (Global.SETTINGS_DATA.getVal("RUSSIAN_NAMES") != 1) break;
                ret = true;
                break;
            }
            case 8: {
                if (Global.SETTINGS_DATA.getVal("CHINESE_NAMES") != 1) break;
                ret = true;
            }
        }
        return ret;
    }

    public void loadBaseMap() throws IOException {
        this.fileReader = new FileReader(String.valueOf(Global.getScenarioPath()) + this.modName + ".map");
        this.inFile = new BufferedReader(this.fileReader);
        int i = 0;
        while (i < this.hex.length) {
            Vector<String> tmp = new Vector<String>(1, 1);
            this.stringTokenizer = new StringTokenizer(this.inFile.readLine());
            while (this.stringTokenizer.hasMoreTokens()) {
                tmp.add(this.stringTokenizer.nextToken());
            }
            Polygon p = this.hex[i].getPolygon();
            if (((String)tmp.get(0)).toString().endsWith("WaterHex")) {
                this.hex[i] = new WaterHex(p, null);
                int tmp2 = Integer.parseInt(((String)tmp.get(14)).toString());
                if (tmp2 == 5) {
                    this.hex[i].buildPort();
                } else if (tmp2 == 7) {
                    this.hex[i] = new LoopHex(this.hex[i].getPolygon());
                } else if (tmp2 == 8) {
                    this.hex[i] = new LoopHex2(this.hex[i].getPolygon());
                }
            } else {
                this.hex[i] = new LandHex(p);
                this.hex[i].setOwningCountry(Integer.parseInt(((String)tmp.get(1)).toString()));
                boolean n = false;
                boolean ne = false;
                boolean se = false;
                boolean s = false;
                boolean sw = false;
                boolean nw = false;
                if (Integer.parseInt(((String)tmp.get(2)).toString()) == 1) {
                    n = true;
                }
                if (ne = Integer.parseInt(((String)tmp.get(3)).toString()) == 1) {
                    ne = true;
                }
                if (se = Integer.parseInt(((String)tmp.get(4)).toString()) == 1) {
                    se = true;
                }
                if (s = Integer.parseInt(((String)tmp.get(5)).toString()) == 1) {
                    s = true;
                }
                if (sw = Integer.parseInt(((String)tmp.get(6)).toString()) == 1) {
                    sw = true;
                }
                if (nw = Integer.parseInt(((String)tmp.get(7)).toString()) == 1) {
                    nw = true;
                }
                ((LandHex)this.hex[i]).setBorders(n, ne, se, s, sw, nw);
                n = Integer.parseInt(((String)tmp.get(8)).toString()) == 1;
                ne = Integer.parseInt(((String)tmp.get(9)).toString()) == 1;
                ne = ne;
                se = Integer.parseInt(((String)tmp.get(10)).toString()) == 1;
                se = se;
                s = Integer.parseInt(((String)tmp.get(11)).toString()) == 1;
                s = s;
                sw = Integer.parseInt(((String)tmp.get(12)).toString()) == 1;
                sw = sw;
                nw = Integer.parseInt(((String)tmp.get(13)).toString()) == 1;
                nw = nw;
                ((LandHex)this.hex[i]).setRivers(n, ne, se, s, sw, nw);
                int tmp2 = Integer.parseInt(((String)tmp.get(14)).toString());
                if (tmp2 == 1) {
                    this.hex[i].buildCapital();
                } else if (tmp2 == 2) {
                    this.hex[i].buildCity();
                } else if (tmp2 == 3) {
                    this.hex[i].buildOilField();
                } else if (tmp2 == 4) {
                    this.hex[i].buildMine();
                } else if (tmp2 == 6) {
                    this.hex[i].buildFortress();
                }
                int tmp3 = Integer.parseInt(((String)tmp.get(15)).toString());
                if (tmp3 == 1) {
                    this.hex[i].growMountain();
                } else if (tmp3 == 2) {
                    this.hex[i].growSwamp();
                } else if (tmp3 == 3) {
                    this.hex[i].growForest();
                } else if (tmp3 == 4) {
                    this.hex[i].growRough();
                } else if (tmp3 == 5) {
                    this.hex[i].growDesert();
                } else if (tmp3 == 6) {
                    this.hex[i].growDune();
                }
            }
            String sss = ((String)tmp.get(16)).toString();
            int is = Integer.parseInt(sss);
            if (this.hex[i].getPResource() != null) {
                this.hex[i].getPResource().setMaxProduction(is);
            }
            ++i;
        }
        try {
            this.loadCityNames(String.valueOf(this.modName) + "_city_" + Global.getLanguageString() + ".txt");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadCityNames(String nam) throws IOException {
        String path = String.valueOf(Global.getDataPath()) + nam;
        FileInputStream fis = new FileInputStream(path);
        InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
        this.inFile = new BufferedReader(isr);
        int i = 0;
        while (i < this.hex.length) {
            Vector<String> tmp = new Vector<String>(1, 1);
            this.stringTokenizer = new StringTokenizer(this.inFile.readLine());
            while (this.stringTokenizer.hasMoreTokens()) {
                tmp.add(this.stringTokenizer.nextToken());
            }
            String s = (String)tmp.get(0);
            if (i == 0) {
                try {
                    Integer.parseInt(s);
                }
                catch (Exception e) {
                    s = new String(s.substring(1, s.length()));
                }
            }
            int hex = Integer.parseInt(new String(s.substring(0, s.length())));
            String cityName = "";
            int j = 1;
            while (j < tmp.size()) {
                if (j > 1) {
                    cityName = String.valueOf(cityName) + " ";
                }
                cityName = String.valueOf(cityName) + ((String)tmp.get(j)).toString();
                ++j;
            }
            cityName = new String(cityName.substring(1, cityName.length() - 1));
            if (Global.SETTINGS_DATA.getVal("DEBUG_MESSAGES") == 1) {
                this.hex[hex].setHexName("z-z-z");
            } else {
                this.hex[hex].setHexName(cityName);
            }
            ++i;
        }
        this.inFile.close();
    }

    public void loadScenarioMap(String scenario) throws IOException {
        Vector<String> tmp;
        this.fileReader = new FileReader(scenario);
        this.inFile = new BufferedReader(this.fileReader);
        int i = 0;
        while (i < this.hex.length) {
            tmp = new Vector<String>(1, 1);
            this.stringTokenizer = new StringTokenizer(this.inFile.readLine());
            while (this.stringTokenizer.hasMoreTokens()) {
                tmp.add(this.stringTokenizer.nextToken());
            }
            if (((String)tmp.get(0)).toString().endsWith("WaterHex")) {
                if (this.hex[i].getPResource() instanceof SeaPort) {
                    this.hex[i].setOwningCountry(26);
                }
            } else {
                this.hex[i].setOwningCountry(Integer.parseInt(((String)tmp.get(1)).toString()));
                boolean n = false;
                boolean ne = false;
                boolean se = false;
                boolean s = false;
                boolean sw = false;
                boolean nw = false;
                if (Integer.parseInt(((String)tmp.get(2)).toString()) == 1) {
                    n = true;
                }
                if (ne = Integer.parseInt(((String)tmp.get(3)).toString()) == 1) {
                    ne = true;
                }
                if (se = Integer.parseInt(((String)tmp.get(4)).toString()) == 1) {
                    se = true;
                }
                if (s = Integer.parseInt(((String)tmp.get(5)).toString()) == 1) {
                    s = true;
                }
                if (sw = Integer.parseInt(((String)tmp.get(6)).toString()) == 1) {
                    sw = true;
                }
                if (nw = Integer.parseInt(((String)tmp.get(7)).toString()) == 1) {
                    nw = true;
                }
                ((LandHex)this.hex[i]).setBorders(n, ne, se, s, sw, nw);
                n = Integer.parseInt(((String)tmp.get(8)).toString()) == 1;
                ne = Integer.parseInt(((String)tmp.get(9)).toString()) == 1;
                ne = ne;
                se = Integer.parseInt(((String)tmp.get(10)).toString()) == 1;
                se = se;
                s = Integer.parseInt(((String)tmp.get(11)).toString()) == 1;
                s = s;
                sw = Integer.parseInt(((String)tmp.get(12)).toString()) == 1;
                sw = sw;
                nw = Integer.parseInt(((String)tmp.get(13)).toString()) == 1;
                nw = nw;
                ((LandHex)this.hex[i]).setRivers(n, ne, se, s, sw, nw);
                int tmp2 = Integer.parseInt(((String)tmp.get(14)).toString());
                if (tmp2 == 6) {
                    this.hex[i].buildFortress();
                } else {
                    this.hex[i].razeFortress();
                }
            }
            ++i;
        }
        try {
            i = 0;
            while (i < this.hex.length) {
                tmp = new Vector(1, 1);
                this.stringTokenizer = new StringTokenizer(this.inFile.readLine());
                while (this.stringTokenizer.hasMoreTokens()) {
                    tmp.add(this.stringTokenizer.nextToken());
                }
                int hex = Integer.parseInt(((String)tmp.get(0)).toString());
                int countryIndex = Integer.parseInt(((String)tmp.get(1)).toString());
                int unitType = Integer.parseInt(((String)tmp.get(2)).toString());
                String individualName = ((String)tmp.get(3)).toString().replaceAll("_", " ");
                if (countryIndex != -1) {
                    int column = this.getColumn(hex);
                    int row = this.getRow(hex);
                    Unit u = this.createUnit(countryIndex, unitType, 0, 10);
                    if (this.editorNames()) {
                        u.setIndividualName(individualName);
                    }
                    this.createAndStoreUnit(u, countryIndex, column, row);
                }
                ++i;
            }
            tmp = new Vector(10, 10);
            this.stringTokenizer = new StringTokenizer(this.inFile.readLine());
            while (this.stringTokenizer.hasMoreTokens()) {
                tmp.add(this.stringTokenizer.nextToken());
            }
            int year = Integer.parseInt(((String)tmp.get(0)).toString());
            int month = Integer.parseInt(((String)tmp.get(1)).toString());
            int date = Integer.parseInt(((String)tmp.get(2)).toString());
            this.calendar = new GregorianCalendar(year, month, date);
            tmp.removeAllElements();
            this.stringTokenizer = new StringTokenizer(this.inFile.readLine());
            while (this.stringTokenizer.hasMoreTokens()) {
                tmp.add(this.stringTokenizer.nextToken());
            }
            this.gameState.setTurn(Integer.parseInt(((String)tmp.get(0)).toString()));
            int i2 = 0;
            while (i2 < this.country.length) {
                tmp = new Vector(10, 10);
                this.stringTokenizer = new StringTokenizer(this.inFile.readLine());
                while (this.stringTokenizer.hasMoreTokens()) {
                    tmp.add(this.stringTokenizer.nextToken());
                }
                CountryData cd = new CountryData(this.country[i2].getName(), Integer.parseInt(((String)tmp.get(0)).toString()), Integer.parseInt(((String)tmp.get(1)).toString()), Integer.parseInt(((String)tmp.get(2)).toString()), Integer.parseInt(((String)tmp.get(3)).toString()), Integer.parseInt(((String)tmp.get(4)).toString()), Integer.parseInt(((String)tmp.get(5)).toString()), Integer.parseInt(((String)tmp.get(6)).toString()), Integer.parseInt(((String)tmp.get(7)).toString()));
                this.country[i2].setCountryData(cd);
                Research r = this.country[i2].getResearch();
                r.setTechLevels(Integer.parseInt(((String)tmp.get(8)).toString()), Integer.parseInt(((String)tmp.get(9)).toString()), Integer.parseInt(((String)tmp.get(10)).toString()), Integer.parseInt(((String)tmp.get(11)).toString()), Integer.parseInt(((String)tmp.get(12)).toString()), Integer.parseInt(((String)tmp.get(13)).toString()), Integer.parseInt(((String)tmp.get(14)).toString()), Integer.parseInt(((String)tmp.get(15)).toString()), Integer.parseInt(((String)tmp.get(16)).toString()), Integer.parseInt(((String)tmp.get(17)).toString()), Integer.parseInt(((String)tmp.get(18)).toString()), Integer.parseInt(((String)tmp.get(19)).toString()), Integer.parseInt(((String)tmp.get(20)).toString()), Integer.parseInt(((String)tmp.get(21)).toString()), Integer.parseInt(((String)tmp.get(22)).toString()));
                Country c = this.country[i2];
                c.setAtWar(Boolean.valueOf(((String)tmp.get(23)).toString()));
                c.setConquered(Boolean.valueOf(((String)tmp.get(24)).toString()));
                c.setSide(Integer.parseInt(((String)tmp.get(25)).toString()));
                c.setMajorNation(Boolean.valueOf(((String)tmp.get(26)).toString()));
                c.setDOWable(Boolean.valueOf(((String)tmp.get(27)).toString()));
                c.setEntryDate(Integer.parseInt(((String)tmp.get(28)).toString()), Integer.parseInt(((String)tmp.get(29)).toString()), Integer.parseInt(((String)tmp.get(30)).toString()));
                c.deployStartingUnits();
                ++i2;
            }
        }
        catch (Exception e) {
            System.exit(55);
        }
        this.inFile.close();
    }

    public Vector<Unit> allUnitTypes(Country c) {
        Vector<Unit> v = new Vector<Unit>(15, 5);
        v.add(new Garrison(c));
        v.add(new Corps(c));
        v.add(new MotorisedCorps(c));
        v.add(new Armour(c));
        v.add(new Fighter(c));
        v.add(new TacticalBomber(c));
        v.add(new StrategicBomber(c));
        v.add(new Sub(c));
        v.add(new Destroyer(c));
        v.add(new Battleship(c));
        v.add(new Carrier(c));
        v.add(new Transport(c, new Corps(c)));
        v.add(new Convoy(c, 100));
        return v;
    }

    public Vector<PResource> allResourceTypes(Country c) {
        Vector<PResource> v = new Vector<PResource>(15, 5);
        v.add(new City());
        v.add(new Capital());
        v.add(new SeaPort());
        v.add(new Fortress());
        v.add(new OilField());
        v.add(new Mine());
        return v;
    }

    public String getMonthName(int month) {
        String s;
        switch (month) {
            case 0: {
                s = Global.getMessage(333);
                break;
            }
            case 1: {
                s = Global.getMessage(334);
                break;
            }
            case 2: {
                s = Global.getMessage(335);
                break;
            }
            case 3: {
                s = Global.getMessage(336);
                break;
            }
            case 4: {
                s = Global.getMessage(337);
                break;
            }
            case 5: {
                s = Global.getMessage(338);
                break;
            }
            case 6: {
                s = Global.getMessage(339);
                break;
            }
            case 7: {
                s = Global.getMessage(340);
                break;
            }
            case 8: {
                s = Global.getMessage(341);
                break;
            }
            case 9: {
                s = Global.getMessage(342);
                break;
            }
            case 10: {
                s = Global.getMessage(343);
                break;
            }
            case 11: {
                s = Global.getMessage(344);
                break;
            }
            default: {
                s = Global.getMessage(344);
            }
        }
        return s;
    }

    public boolean canDeploy(Unit u) {
        boolean ret = false;
        this.highlightDeployHexes(u.getCountry().getCountryIndex(), u);
        int i = 0;
        while (i < this.hex.length) {
            if (this.hex[i].getHighlighted()) {
                ret = true;
            }
            ++i;
        }
        this.deHighlightdeTargetAll();
        return ret;
    }

    public void highlightDeployHexes(int country, Unit u) {
        if (u instanceof NavalUnit) {
            int i = 0;
            while (i < this.country[country].deployPorts.size()) {
                Hex h = this.country[country].getDeployPort(i);
                if (h.getUnit() == null && h.getSupply() == Global.MAX_SUPPLY) {
                    h.setHighlighted(true);
                }
                ++i;
            }
        } else if (u instanceof Commander) {
            int i = 0;
            while (i < this.hex.length) {
                Hex h = this.hex[i];
                Unit unit2 = h.getUnit();
                if (unit2 != null && !unit2.getHasMoved() && unit2.getCommander() == null && u.getCountry() == unit2.getCountry() && h instanceof LandHex && unit2 instanceof GroundUnit) {
                    this.hex[i].setHighlighted(true);
                }
                ++i;
            }
        } else {
            int hex = this.country[country].getPrimaryCapital();
            if (hex != -1 && this.hex[hex].getOwningCountry() == country && this.hex[hex].getSupply() == Global.MAX_SUPPLY) {
                this.highlightDeployHexes2(country, hex);
            }
            if ((hex = this.country[country].getSecondaryCapital()) != -1 && this.hex[hex].getOwningCountry() == country && this.hex[hex].getSupply() == Global.MAX_SUPPLY) {
                this.highlightDeployHexes2(country, hex);
            }
            int i = 0;
            while (i < this.country[country].numDeployHexes()) {
                Hex h = this.country[country].getDeployHex(i);
                if (!h.getPResource().getHasDeployed() && h.getOwningCountry() == country && h.getSupply() == Global.MAX_SUPPLY) {
                    this.highlightDeployHexes2(country, this.getHexIndex(h));
                }
                ++i;
            }
        }
    }

    private void highlightDeployHexes2(int country, int currentHex) {
        int nextHex;
        Hex h;
        if (this.insideMap(currentHex) && (h = this.hex[currentHex]).getUnit() == null && h.getOwningCountry() == country && h instanceof LandHex) {
            h.setHighlighted(true);
        }
        if (this.insideMap(nextHex = this.getNorthHex(currentHex)) && (h = this.hex[nextHex]).getUnit() == null && h.getOwningCountry() == country && h instanceof LandHex) {
            h.setHighlighted(true);
        }
        if (this.insideMap(nextHex = this.getNorthEastHex(currentHex)) && (h = this.hex[nextHex]).getUnit() == null && h.getOwningCountry() == country && h instanceof LandHex) {
            h.setHighlighted(true);
        }
        if (this.insideMap(nextHex = this.getSouthEastHex(currentHex)) && (h = this.hex[nextHex]).getUnit() == null && h.getOwningCountry() == country && h instanceof LandHex) {
            h.setHighlighted(true);
        }
        if (this.insideMap(nextHex = this.getSouthHex(currentHex)) && (h = this.hex[nextHex]).getUnit() == null && h.getOwningCountry() == country && h instanceof LandHex) {
            h.setHighlighted(true);
        }
        if (this.insideMap(nextHex = this.getSouthWestHex(currentHex)) && (h = this.hex[nextHex]).getUnit() == null && h.getOwningCountry() == country && h instanceof LandHex) {
            h.setHighlighted(true);
        }
        if (this.insideMap(nextHex = this.getNorthWestHex(currentHex)) && (h = this.hex[nextHex]).getUnit() == null && h.getOwningCountry() == country && h instanceof LandHex) {
            h.setHighlighted(true);
        }
    }

    public void markHasDeployed(int country, int hex) {
        int nextHex;
        Hex h;
        if (this.insideMap(hex) && (h = this.hex[hex]).getPResource() instanceof City && h.getOwningCountry() == country) {
            h.getPResource().setHasDeployed(true);
        }
        if (this.insideMap(nextHex = this.getNorthHex(hex)) && (h = this.hex[nextHex]).getPResource() instanceof City && h.getOwningCountry() == country) {
            h.getPResource().setHasDeployed(true);
        }
        if (this.insideMap(nextHex = this.getNorthEastHex(hex)) && (h = this.hex[nextHex]).getPResource() instanceof City && h.getOwningCountry() == country) {
            h.getPResource().setHasDeployed(true);
        }
        if (this.insideMap(nextHex = this.getSouthEastHex(hex)) && (h = this.hex[nextHex]).getPResource() instanceof City && h.getOwningCountry() == country) {
            h.getPResource().setHasDeployed(true);
        }
        if (this.insideMap(nextHex = this.getSouthHex(hex)) && (h = this.hex[nextHex]).getPResource() instanceof City && h.getOwningCountry() == country) {
            h.getPResource().setHasDeployed(true);
        }
        if (this.insideMap(nextHex = this.getSouthWestHex(hex)) && (h = this.hex[nextHex]).getPResource() instanceof City && h.getOwningCountry() == country) {
            h.getPResource().setHasDeployed(true);
        }
        if (this.insideMap(nextHex = this.getNorthWestHex(hex)) && (h = this.hex[nextHex]).getPResource() instanceof City && h.getOwningCountry() == country) {
            h.getPResource().setHasDeployed(true);
        }
    }

    private void markCoreHexes() {
        int i = 0;
        while (i < this.country.length) {
            if (this.country[i].getPrimaryCapital() != -1) {
                this.markCoreHexesStoreDeployHexes(this.country[i].getPrimaryCapital());
            }
            if (this.country[i].getSecondaryCapital() != -1) {
                this.markCoreHexesStoreDeployHexes(this.country[i].getSecondaryCapital());
            }
            ++i;
        }
        i = 0;
        while (i < this.hex.length) {
            if (this.hex[i] instanceof LandHex && this.hex[i].getOwningCountry() != -1) {
                this.hex[i].setCoreOwningCountry(this.hex[i].getOwningCountry());
            }
            ++i;
        }
    }

    private void markCorePorts() {
        int i = 0;
        while (i < this.country.length) {
            int j = 0;
            while (j < this.hex.length) {
                if (this.hex[j].getAttachedPort() != null && i == this.hex[j].getOwningCountry()) {
                    this.country[i].addDeployPort(this.hex[j].getAttachedPort());
                }
                ++j;
            }
            ++i;
        }
    }

    private void attachPorts() {
        int i = 0;
        while (i < this.hex.length) {
            Hex h = this.hex[i];
            if (h.getPResource() instanceof SeaPort) {
                Hex tmp = this.hex[this.getNorthHex(i)];
                if (tmp.getPResource() != null) {
                    tmp.setAttachedPort(h);
                    h.setOwningCountry(tmp.getOwningCountry());
                }
                if ((tmp = this.hex[this.getNorthEastHex(i)]).getPResource() != null) {
                    tmp.setAttachedPort(h);
                    h.setOwningCountry(tmp.getOwningCountry());
                }
                if ((tmp = this.hex[this.getSouthEastHex(i)]).getPResource() != null) {
                    tmp.setAttachedPort(h);
                    h.setOwningCountry(tmp.getOwningCountry());
                }
                if ((tmp = this.hex[this.getSouthHex(i)]).getPResource() != null) {
                    tmp.setAttachedPort(h);
                    h.setOwningCountry(tmp.getOwningCountry());
                }
                if ((tmp = this.hex[this.getSouthWestHex(i)]).getPResource() != null) {
                    tmp.setAttachedPort(h);
                    h.setOwningCountry(tmp.getOwningCountry());
                }
                if ((tmp = this.hex[this.getNorthWestHex(i)]).getPResource() != null) {
                    tmp.setAttachedPort(h);
                    h.setOwningCountry(tmp.getOwningCountry());
                }
            }
            ++i;
        }
    }

    public void markLoopHexes() {
        Vector<Integer> africaLoop = new Vector<Integer>(2, 5);
        Vector<Integer> suezLoop = new Vector<Integer>(2, 5);
        int i = this.hex.length - 1;
        while (i > 0) {
            if (this.hex[i] instanceof LoopHex) {
                africaLoop.add(new Integer(i));
            } else if (this.hex[i] instanceof LoopHex2) {
                suezLoop.add(new Integer(i));
            }
            --i;
        }
        this.gameState.getAfricaLoop().setExitHex((Integer)africaLoop.get(0));
        this.gameState.getAfricaLoop().setEntryHex((Integer)africaLoop.get(1));
        this.gameState.getSuezLoop().setExitHex((Integer)suezLoop.get(0));
        this.gameState.getSuezLoop().setEntryHex((Integer)suezLoop.get(1));
    }

    public void surrenderCheck() {
        int i = 0;
        while (i < this.country.length) {
            if (this.country[i].getAtWar() && this.country[i].getPrimaryCapital() != -1 && this.hex[this.country[i].getPrimaryCapital()].getOwningCountry() != i) {
                if (this.country[i].getSecondaryCapital() == -1) {
                    this.surrenderCountry(i, this.hex[this.country[i].getPrimaryCapital()].getOwningCountry());
                } else if (this.hex[this.country[i].getSecondaryCapital()].getOwningCountry() != i) {
                    this.surrenderCountry(i, this.hex[this.country[i].getSecondaryCapital()].getOwningCountry());
                }
            }
            ++i;
        }
    }

    public void surrenderCountry(int surrenderingCountry, int countryMoving) {
        Unit u;
        Country hexCountry;
        Country occupyerFactionLeader;
        int landGrabber = countryMoving;
        if (this.country[surrenderingCountry].isMajorCountry() && (occupyerFactionLeader = this.factionLeader(this.country[countryMoving].getFaction())) != null) {
            landGrabber = occupyerFactionLeader.getCountryIndex();
        }
        int faction = this.country[surrenderingCountry].getFaction();
        this.country[surrenderingCountry].surrender();
        Country surrenderFactionLeader = this.factionLeader(faction);
        int i = 0;
        while (i < this.hex.length) {
            hexCountry = this.country[this.hex[i].getOwningCountry()];
            if (this.hex[i].getCoreOwningCountry() == surrenderingCountry) {
                u = this.hex[i].getUnit();
                if (!(this.hex[i].getCoreOwningCountry() == surrenderingCountry && this.hex[i].getOwningCountry() != surrenderingCountry && this.getCountry(this.hex[i].getOwningCountry()).getSide() == this.country[surrenderingCountry].getSide() || u != null && u.getCountry() != hexCountry && u.getCountry().getSide() == hexCountry.getSide())) {
                    this.hex[i].setOwningCountry(landGrabber);
                }
                if (this.hex[i].getPResource() instanceof Fortress) {
                    this.hex[i].razeFortress();
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.hex.length) {
            hexCountry = this.country[this.hex[i].getOwningCountry()];
            if (this.hex[i].getOwningCountry() == surrenderingCountry) {
                u = this.hex[i].getUnit();
                if (u == null || u.getCountry() == hexCountry || u.getCountry().getSide() != hexCountry.getSide()) {
                    if (surrenderFactionLeader != null && this.hex[i].getCoreOwningCountry() != surrenderingCountry && this.hex[i].getSupply() > 0) {
                        this.hex[i].setOwningCountry(surrenderFactionLeader.getCountryIndex());
                    } else {
                        this.hex[i].setOwningCountry(landGrabber);
                    }
                } else {
                    this.hex[i].setOwningCountry(u.getCountryIndex());
                }
                if (this.hex[i].getPResource() instanceof Fortress) {
                    this.hex[i].razeFortress();
                }
            }
            ++i;
        }
        this.warWindow.showInfoDialog(Global.createLanguageMessage(117, new String[]{this.country[surrenderingCountry].getName(), this.country[landGrabber].getName()}));
        if (surrenderingCountry == 3) {
            this.warWindow.showInfoDialog(Global.getMessage(133));
            this.createNation(24, 300, 100);
            this.warWindow.showInfoDialog(Global.getMessage(132));
            this.fillWithCorps(32, 2);
            this.deployNavalUnit(new Battleship(this.country[2]), 32);
            this.deployLandUnit(new Fighter(this.country[2]), 32);
            int hex = this.furthestCity(24, 3);
            if (hex != -1 && this.hex[hex].getUnit() != null) {
                this.hex[hex].getUnit().removeFromMap();
            }
        }
        this.createOwningBorders();
    }

    public void fillWithGarrison(int countryIndex, int unitCountry) {
        int i = 0;
        while (i < this.hex.length) {
            if (this.hex[i].getUnit() == null && this.hex[i].getCoreOwningCountry() == countryIndex && this.hex[i].getPResource() != null && this.hex[i].getPResource().isSupplySource()) {
                this.createAndPlaceUnit(new Garrison(this.country[unitCountry]), unitCountry, this.getColumn(i), this.getRow(i));
            }
            ++i;
        }
    }

    public void fillWithCorps(int countryIndex, int unitCountry) {
        int i = 0;
        while (i < this.hex.length) {
            if (this.hex[i].getUnit() == null && this.hex[i].getCoreOwningCountry() == countryIndex && this.hex[i].getPResource() != null && this.hex[i].getPResource().isSupplySource()) {
                this.createAndPlaceUnit(new Corps(this.country[unitCountry]), unitCountry, this.getColumn(i), this.getRow(i));
            }
            ++i;
        }
    }

    public void deployLandUnit(Unit u, int countryIndex) {
        if (u.isLandUnit()) {
            int i = 0;
            while (i < this.hex.length) {
                if (this.hex[i].getCoreOwningCountry() == countryIndex && this.hex[i].getPResource() != null && this.hex[i].getPResource().isSupplySource()) {
                    Hex[] adjacentHexes = this.adjacentHexes(this.hex[i]);
                    int j = 0;
                    while (j < adjacentHexes.length) {
                        if (adjacentHexes[j].getUnit() == null) {
                            this.createAndPlaceUnit(u, u.getCountryIndex(), this.getColumn(this.getHexIndex(adjacentHexes[j])), this.getRow(this.getHexIndex(adjacentHexes[j])));
                            break;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    public Hex[] adjacentHexes(Hex h) {
        Vector<Integer> hexes = new Vector<Integer>(6, 6);
        int hexIndex = this.getHexIndex(h);
        int tmpIndex = this.getNorthEastHex(hexIndex);
        if (this.insideMap(tmpIndex)) {
            hexes.add(new Integer(tmpIndex));
        }
        if (this.insideMap(tmpIndex = this.getSouthEastHex(hexIndex))) {
            hexes.add(new Integer(tmpIndex));
        }
        if (this.insideMap(tmpIndex = this.getSouthHex(hexIndex))) {
            hexes.add(new Integer(tmpIndex));
        }
        if (this.insideMap(tmpIndex = this.getSouthWestHex(hexIndex))) {
            hexes.add(new Integer(tmpIndex));
        }
        if (this.insideMap(tmpIndex = this.getNorthWestHex(hexIndex))) {
            hexes.add(new Integer(tmpIndex));
        }
        if (this.insideMap(tmpIndex = this.getNorthHex(hexIndex))) {
            hexes.add(new Integer(tmpIndex));
        }
        Hex[] ret = new Hex[hexes.size()];
        int i = 0;
        while (i < hexes.size()) {
            ret[i] = this.hex[(Integer)hexes.get(i)];
            ++i;
        }
        return ret;
    }

    public void deployNavalUnit(NavalUnit u, int countryIndex) {
        int i = 0;
        while (i < this.hex.length) {
            if (this.hex[i].getCoreOwningCountry() == countryIndex && this.hex[i].getAttachedPort() != null && this.hex[i].getAttachedPort().getUnit() == null && this.hex[i].getPResource().isSupplySource()) {
                this.createAndPlaceUnit(u, u.getCountryIndex(), this.getColumn(this.getHexIndex(this.hex[i].getAttachedPort())), this.getRow(this.getHexIndex(this.hex[i].getAttachedPort())));
                break;
            }
            ++i;
        }
    }

    public int monthsPassed(Calendar c) {
        int monthsPassed = 0;
        monthsPassed += 12 * (c.get(1) - Global.BASE_YEAR);
        monthsPassed = monthsPassed + c.get(2) - Global.BASE_MONTH;
        return monthsPassed;
    }

    public int yearsPassed(Calendar c) {
        return this.monthsPassed(c) / 12;
    }

    public int quartersPassed(Calendar c) {
        return this.monthsPassed(c) / 3;
    }

    public int furthestCity(int country, int direction) {
        int ret = -1;
        int i = 0;
        while (i < this.hex.length) {
            if (this.hex[i].getPResource() instanceof City && this.hex[i].getOwningCountry() == country) {
                if (ret == -1) {
                    ret = i;
                } else {
                    switch (direction) {
                        case 0: {
                            if (this.getRow(i) >= this.getRow(ret)) break;
                            ret = 1;
                            break;
                        }
                        case 1: {
                            if (this.getColumn(i) <= this.getColumn(ret)) break;
                            ret = 1;
                            break;
                        }
                        case 2: {
                            if (this.getRow(i) <= this.getRow(ret)) break;
                            ret = 1;
                            break;
                        }
                        case 3: {
                            if (this.getColumn(i) >= this.getColumn(ret)) break;
                            ret = 1;
                        }
                    }
                }
            }
            ++i;
        }
        return ret;
    }

    public int middleMostCity(int country) {
        int columnSum = 0;
        int rowSum = 0;
        int cities = 0;
        int i = 0;
        while (i < this.hex.length) {
            if (this.hex[i].getPResource() instanceof City && this.hex[i].getOwningCountry() == country) {
                columnSum += this.getColumn(i);
                rowSum += this.getRow(i);
                ++cities;
            }
            ++i;
        }
        cities = Math.max(cities, 1);
        int midPoint = this.getHex(columnSum /= cities, rowSum /= cities);
        int dist = 999999;
        int bestCity = -1;
        int i2 = 0;
        while (i2 < this.hex.length) {
            int tmp;
            if (this.hex[i2].getPResource() instanceof City && this.hex[i2].getOwningCountry() == country && (tmp = this.shortestPath(i2, midPoint)) < dist) {
                dist = tmp;
                bestCity = i2;
            }
            ++i2;
        }
        return bestCity;
    }

    private void createNation(int countryIndex, int side, int freePassageSide) {
        this.country[countryIndex] = new Country(this, this.country[countryIndex].getDataName(), this.country[countryIndex].getName(), this.country[countryIndex].getOwningName(), new Color(85, 185, 255), new Color(115, 215, 255), countryIndex, side, 0, 50, 1, 0, false, false, new GregorianCalendar(9999, 9, 9), "");
        this.country[countryIndex].setConquered(false);
        int i = 0;
        while (i < this.hex.length) {
            int coreOwner = this.hex[i].getCoreOwningCountry();
            if (coreOwner == countryIndex) {
                this.hex[i].setOwningCountry(countryIndex);
                Country hexCountry = this.country[this.hex[i].getOwningCountry()];
                Unit u = this.hex[i].getUnit();
                if (u != null) {
                    u.removeFromMap();
                    if (u.getSide() == freePassageSide) {
                        hexCountry.unitsUnderConstruction.add(u);
                    }
                }
            }
            ++i;
        }
        this.fillWithGarrison(countryIndex, countryIndex);
        Game.delay(500L);
        this.warWindow.showInfoDialog(Global.createLanguageMessage(118, new String[]{this.country[countryIndex].getName()}));
    }

    private void endSequence() {
        this.gameState.setgameOver(true);
        this.gameState.setFOW(false);
        this.victoryPanel.updateAll(true, 0);
        this.theScreen.showPanel(this.victoryPanel);
    }

    public void victoryCheck() {
        if (!this.country[0].getAtWar() && !this.country[1].getAtWar()) {
            this.endSequence();
        } else if (!(this.country[2].getAtWar() || this.country[3].getAtWar() || this.country[4].getAtWar() || this.country[5].getAtWar())) {
            this.endSequence();
        } else if (this.gameState.getEnd1945() && this.calendar.after(this.endDate)) {
            this.endSequence();
        }
    }

    public void ssstalemateVictory() {
        this.gameState.setgameOver(true);
        this.warWindow.showStatisticsPanel(true, 4);
    }

    private void resetHasDeployed() {
        int i = 0;
        while (i < this.hex.length) {
            PResource pr = this.hex[i].getPResource();
            if (pr != null) {
                pr.setHasDeployed(false);
            }
            ++i;
        }
    }

    public int nearestHeldMajorCapital(Unit u) {
        if (u.getOnHex() == null) {
            return -1;
        }
        int dist = 999999;
        int ret = -1;
        int onHex = this.getHexIndex(u.getOnHex());
        int i = 0;
        while (i < this.country.length) {
            int capital = u.getSide() == this.country[i].getSide() ? this.country[i].activeCapital() : this.country[i].getPrimaryCapital();
            if (this.country[i].isMajorCountry() && capital != -1 && this.getCountry(this.hex[capital].getOwningCountry()).getSide() == u.getSide() && this.shortestPath(onHex, capital) < dist) {
                dist = this.shortestPath(onHex, capital);
                ret = capital;
            }
            ++i;
        }
        return ret;
    }

    private void repairDamagedResources() {
        int i = 0;
        while (i < this.hex.length) {
            if (this.whosTurn() != this.country[this.hex[i].getOwningCountry()].getSide()) {
                this.hex[i].repairResource();
            }
            ++i;
        }
    }

    private void updateSupplyLevels(boolean navyIncluded) {
        int i = 0;
        while (i < this.hex.length) {
            this.hex[i].setSupply(0);
            ++i;
        }
        this.floodFill(0, this.country[0].getPrimaryCapital());
        this.floodFill(1, this.country[1].getPrimaryCapital());
        this.floodFill(2, this.country[2].getPrimaryCapital());
        this.floodFill(2, this.country[2].getSecondaryCapital());
        this.floodFill(3, this.country[3].getPrimaryCapital());
        this.floodFill(4, this.country[4].getPrimaryCapital());
        this.floodFill(5, this.country[5].getPrimaryCapital());
        this.floodFill(5, this.country[5].getSecondaryCapital());
        i = 0;
        while (i < this.hex.length) {
            PResource pr = this.hex[i].getPResource();
            if (this.hex[i].getSupply() == 0 && (pr instanceof City || pr instanceof Capital)) {
                this.setSupplyAroundHex(this.hex[i].getOwningCountry(), i, Global.HALF_SUPPLY, true);
            }
            ++i;
        }
        i = 0;
        while (i < this.hex.length) {
            if (this.hex[i].getPResource() instanceof Fortress && this.hex[i].getSupply() < Global.HALF_SUPPLY) {
                if (this.hex[i].getAttachedPort() != null || this.hex[i].getPResource().getMaxProduction() > 0) {
                    this.setSupplyAroundHex(this.hex[i].getOwningCountry(), i, Global.HALF_SUPPLY, true);
                } else {
                    this.hex[i].setSupply(Global.HALF_SUPPLY);
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.hex.length) {
            if (this.hex[i].getAttachedPort() != null) {
                this.hex[i].getAttachedPort().setSupply(this.hex[i].getSupply());
            }
            ++i;
        }
        i = 0;
        while (i < this.hex.length) {
            if (this.hex[i].getUnit() != null && this.hex[i].getUnit() instanceof NavalUnit && ((NavalUnit)this.hex[i].getUnit()).canSupply()) {
                this.setSupplyAroundHex(this.hex[i].getUnit().getCountryIndex(), i, Global.LOW_SUPPLY, false);
            }
            ++i;
        }
        i = 0;
        while (i < this.hex.length) {
            Unit u = this.hex[i].getUnit();
            if (u != null && !(u instanceof NavalUnit)) {
                u.setSupply(this.hex[i].getSupply());
                if (u.getSupply() == Global.MAX_SUPPLY) {
                    u.setSupply(Math.max(Global.HALF_SUPPLY, Global.MAX_SUPPLY - (this.shortestPathToFriendlyFullSupply(u) - 1) / Global.SUPPLY_PENALTY_DISTANCE));
                }
            }
            ++i;
        }
    }

    private boolean sameSide(int hexIndex, int countryIndex) {
        Integer countrySide;
        int hexOwnerIndex = this.hex[hexIndex].getOwningCountry();
        int index = this.country[hexOwnerIndex].getWarSide();
        Integer hexSide = new Integer(index);
        return hexSide.equals(countrySide = new Integer(this.country[countryIndex].getWarSide()));
    }

    private void floodFill(int countryIndex, int startHex) {
        int countrySide = this.country[countryIndex].getSide();
        Vector<Integer> supplyQueue = new Vector<Integer>(7, 6);
        if (this.sameSide(startHex, countryIndex) && new Integer(this.hex[startHex].getSupply()).equals(new Integer(0))) {
            this.hex[startHex].setSupply(Global.MAX_SUPPLY);
            supplyQueue.add(new Integer(startHex));
        }
        while (!supplyQueue.isEmpty()) {
            Integer currHex = (Integer)supplyQueue.remove(0);
            int north = this.getNorthHex(currHex);
            int northEast = this.getNorthEastHex(currHex);
            int southEast = this.getSouthEastHex(currHex);
            int south = this.getSouthHex(currHex);
            int southWest = this.getSouthWestHex(currHex);
            int northWest = this.getNorthWestHex(currHex);
            if (this.insideMap(north) && new Integer(this.hex[north].getSupply()).equals(new Integer(0)) && this.sameSide(north, countryIndex) && (!(this.hex[north] instanceof WaterHex) || this.friendlyPort(north, countrySide))) {
                this.hex[north].setSupply(Global.MAX_SUPPLY);
                supplyQueue.add(new Integer(north));
            }
            if (this.insideMap(northEast) && new Integer(this.hex[northEast].getSupply()).equals(new Integer(0)) && this.sameSide(northEast, countryIndex) && (!(this.hex[northEast] instanceof WaterHex) || this.friendlyPort(northEast, countrySide))) {
                this.hex[northEast].setSupply(Global.MAX_SUPPLY);
                supplyQueue.add(new Integer(northEast));
            }
            if (this.insideMap(southEast) && new Integer(this.hex[southEast].getSupply()).equals(new Integer(0)) && this.sameSide(southEast, countryIndex) && (!(this.hex[southEast] instanceof WaterHex) || this.friendlyPort(southEast, countrySide))) {
                this.hex[southEast].setSupply(Global.MAX_SUPPLY);
                supplyQueue.add(new Integer(southEast));
            }
            if (this.insideMap(south) && new Integer(this.hex[south].getSupply()).equals(new Integer(0)) && this.sameSide(south, countryIndex) && (!(this.hex[south] instanceof WaterHex) || this.friendlyPort(south, countrySide))) {
                this.hex[south].setSupply(Global.MAX_SUPPLY);
                supplyQueue.add(new Integer(south));
            }
            if (this.insideMap(southWest) && new Integer(this.hex[southWest].getSupply()).equals(new Integer(0)) && this.sameSide(southWest, countryIndex) && (!(this.hex[southWest] instanceof WaterHex) || this.friendlyPort(southWest, countrySide))) {
                this.hex[southWest].setSupply(Global.MAX_SUPPLY);
                supplyQueue.add(new Integer(southWest));
            }
            if (!this.insideMap(northWest) || !new Integer(this.hex[northWest].getSupply()).equals(new Integer(0)) || !this.sameSide(northWest, countryIndex) || this.hex[northWest] instanceof WaterHex && !this.friendlyPort(northWest, countrySide)) continue;
            this.hex[northWest].setSupply(Global.MAX_SUPPLY);
            supplyQueue.add(new Integer(northWest));
        }
    }

    private void updateEffectiveness(int whosTurn) {
        int i = 0;
        while (i < this.hex.length) {
            Unit u = this.hex[i].getUnit();
            if (u != null && whosTurn != u.getSide() && u.getCountry().getAtWar()) {
                u.updateEffectiveness();
            }
            ++i;
        }
    }

    private int shortestPathToFriendlyFullSupply(Unit u) {
        int shortest = 999999;
        int side = u.getSide();
        int i = 0;
        while (i < this.country.length) {
            if (this.country[i].majorAliveFriendlyAtWar(side)) {
                shortest = Math.min(shortest, this.shortestPath(this.getHexIndex(u.getOnHex()), this.country[i].activeCapital()));
            }
            ++i;
        }
        return shortest;
    }

    private void updateRangedCommanders() {
        int i = 0;
        while (i < this.country.length) {
            Vector<Unit> v = this.country[i].getUnits();
            Unit[] units = new Unit[v.size()];
            int j = 0;
            while (j < v.size()) {
                units[j] = v.get(j);
                ++j;
            }
            int shortestDist = 1000;
            int k = 0;
            while (k < units.length) {
                units[k].setRangedCommander(null);
                Commander best = null;
                shortestDist = 10000;
                Hex unitHex = units[k].getOnHex();
                if (unitHex != null) {
                    int unitHex2 = this.getHexIndex(unitHex);
                    int m = 0;
                    while (m < units.length) {
                        Hex unitHex3 = units[m].getOnHex();
                        if (unitHex3 != null) {
                            int unitHex4 = this.getHexIndex(unitHex3);
                            Commander c = units[m].getCommander();
                            int dist = this.shortestPath(unitHex2, unitHex4);
                            if (c != null && dist < shortestDist && dist <= Global.COMMANDER_RANGE) {
                                best = c;
                                shortestDist = dist;
                            }
                        }
                        ++m;
                    }
                }
                if (best != null) {
                    units[k].setRangedCommander(best);
                }
                ++k;
            }
            ++i;
        }
    }

    public void boatSupply(Unit u) {
        int hexIndex = this.getHexIndex(u.getOnHex());
        if (this.boatSupply2(u, this.getNorthEastHex(hexIndex))) {
            u.getOnHex().setSupply(Global.HALF_SUPPLY);
            u.setSupply(Global.LOW_SUPPLY);
        } else if (this.boatSupply2(u, this.getSouthEastHex(hexIndex))) {
            u.getOnHex().setSupply(Global.HALF_SUPPLY);
            u.setSupply(Global.LOW_SUPPLY);
        } else if (this.boatSupply2(u, this.getSouthHex(hexIndex))) {
            u.getOnHex().setSupply(Global.HALF_SUPPLY);
            u.setSupply(Global.LOW_SUPPLY);
        } else if (this.boatSupply2(u, this.getSouthWestHex(hexIndex))) {
            u.getOnHex().setSupply(Global.HALF_SUPPLY);
            u.setSupply(Global.LOW_SUPPLY);
        } else if (this.boatSupply2(u, this.getNorthWestHex(hexIndex))) {
            u.getOnHex().setSupply(Global.HALF_SUPPLY);
            u.setSupply(Global.LOW_SUPPLY);
        } else if (this.boatSupply2(u, this.getNorthHex(hexIndex))) {
            u.getOnHex().setSupply(Global.HALF_SUPPLY);
            u.setSupply(Global.LOW_SUPPLY);
        }
    }

    private boolean boatSupply2(Unit stranded, int boatHex) {
        boolean getsSupply = false;
        if (boatHex != -1) {
            int side = stranded.getCountry().getSide();
            Unit boat = this.hex[boatHex].getUnit();
            if (this.insideMap(boatHex) && boat != null && boat.getCountry().getSide() == side && this.hex[boatHex].getUnit() instanceof NavalUnit && ((NavalUnit)boat).canSupply()) {
                getsSupply = true;
            }
        }
        return getsSupply;
    }

    public int shippedSupplyHex(int unitHex, Vector<Integer> unsuppliedUnits, int maxRange) {
        int ret = -1;
        Unit u = this.hex[unitHex].getUnit();
        if (u instanceof NavalUnit && ((NavalUnit)u).canSupply()) {
            this.highlightAroundUnit(unitHex, u.getRealMovement(), false);
            int j = 0;
            while (j < this.hex.length) {
                if (this.hex[j].getHighlighted() || j == unitHex) {
                    int k = 0;
                    while (k < unsuppliedUnits.size()) {
                        int hex = unsuppliedUnits.get(k);
                        if (this.shortestPath(j, hex) <= 1) {
                            return j;
                        }
                        if (this.shortestPath(unitHex, hex) <= maxRange && this.hex[unitHex].getContinent() == this.nearestOceanIndex(hex) && this.coastalLandHex(hex)) {
                            return hex;
                        }
                        ++k;
                    }
                }
                ++j;
            }
            this.deHighlightdeTargetAll();
        }
        return -1;
    }

    private void setSupplyAroundHex(int startCountry, int hex, int supply, boolean landOnly) {
        if (this.insideMap(hex)) {
            int startSide = this.country[startCountry].getSide();
            Hex h = this.hex[hex];
            int side = this.country[this.hex[hex].getOwningCountry()].getSide();
            int country = this.hex[hex].getOwningCountry();
            if (h.getSupply() == 0 && (!landOnly || h instanceof LandHex || this.friendlyPort(hex, startSide)) && (h instanceof WaterHex || this.country[startCountry].getSide() == side) && (h instanceof WaterHex || startCountry == country || this.country[country].getAtWar() && this.country[startCountry].getAtWar())) {
                this.getHex(hex).setSupply(supply);
                this.setSupplyAroundHex(startCountry, this.getNorthHex(hex), supply, true);
                this.setSupplyAroundHex(startCountry, this.getNorthEastHex(hex), supply, true);
                this.setSupplyAroundHex(startCountry, this.getSouthEastHex(hex), supply, true);
                this.setSupplyAroundHex(startCountry, this.getSouthHex(hex), supply, true);
                this.setSupplyAroundHex(startCountry, this.getSouthWestHex(hex), supply, true);
                this.setSupplyAroundHex(startCountry, this.getNorthWestHex(hex), supply, true);
            }
        }
    }

    private void createAndPlaceStrangeTechedUnits() {
        int i = 0;
        while (i < 6) {
            this.createAndPlaceStrangeTechedUnit(new Garrison(this.country[i]), i, 23, 1 + i * 8, 0);
            this.createAndPlaceStrangeTechedUnit(new Corps(this.country[i]), i, 24, 1 + i * 8, 0);
            this.createAndPlaceStrangeTechedUnit(new MotorisedCorps(this.country[i]), i, 25, 1 + i * 8, 0);
            this.createAndPlaceStrangeTechedUnit(new Armour(this.country[i]), i, 26, 1 + i * 8, 0);
            this.createAndPlaceStrangeTechedUnit(new Armour(this.country[i]), i, 26, 2 + i * 8, 1);
            this.createAndPlaceStrangeTechedUnit(new Armour(this.country[i]), i, 26, 3 + i * 8, 2);
            this.createAndPlaceStrangeTechedUnit(new Armour(this.country[i]), i, 26, 4 + i * 8, 3);
            this.createAndPlaceStrangeTechedUnit(new Armour(this.country[i]), i, 26, 5 + i * 8, 4);
            this.createAndPlaceStrangeTechedUnit(new Armour(this.country[i]), i, 26, 6 + i * 8, 5);
            this.createAndPlaceStrangeTechedUnit(new Fighter(this.country[i]), i, 27, 1 + i * 8, 0);
            this.createAndPlaceStrangeTechedUnit(new Fighter(this.country[i]), i, 27, 2 + i * 8, 1);
            this.createAndPlaceStrangeTechedUnit(new Fighter(this.country[i]), i, 27, 3 + i * 8, 2);
            this.createAndPlaceStrangeTechedUnit(new Fighter(this.country[i]), i, 27, 4 + i * 8, 3);
            this.createAndPlaceStrangeTechedUnit(new Fighter(this.country[i]), i, 27, 5 + i * 8, 4);
            this.createAndPlaceStrangeTechedUnit(new TacticalBomber(this.country[i]), i, 28, 1 + i * 8, 0);
            this.createAndPlaceStrangeTechedUnit(new TacticalBomber(this.country[i]), i, 28, 2 + i * 8, 1);
            this.createAndPlaceStrangeTechedUnit(new TacticalBomber(this.country[i]), i, 28, 3 + i * 8, 2);
            this.createAndPlaceStrangeTechedUnit(new StrategicBomber(this.country[i]), i, 29, 1 + i * 8, 0);
            this.createAndPlaceStrangeTechedUnit(new StrategicBomber(this.country[i]), i, 29, 2 + i * 8, 1);
            this.createAndPlaceStrangeTechedUnit(new StrategicBomber(this.country[i]), i, 29, 3 + i * 8, 2);
            this.createAndPlaceStrangeTechedUnit(new Sub(this.country[i]), i, 30, 1 + i * 8, 0);
            this.createAndPlaceStrangeTechedUnit(new Destroyer(this.country[i]), i, 31, 1 + i * 8, 0);
            this.createAndPlaceStrangeTechedUnit(new Battleship(this.country[i]), i, 32, 1 + i * 8, 0);
            this.createAndPlaceStrangeTechedUnit(new Carrier(this.country[i]), i, 33, 1 + i * 8, 0);
            ++i;
        }
    }

    private void createAndPlaceStrangeTechedUnit(Unit u, int country, int xpos, int ypos, int imageLevel) {
        int hex = this.getHex(xpos, ypos);
        if (this.hex[hex].getUnit() != null) {
            System.exit(123435);
        }
        this.country[country].addUnit(u);
        this.country[country].units.lastElement().enterHex(this.hex, xpos, ypos, false);
        u.testImageLevel = imageLevel;
    }

    private void createAndPlaceUnit(Unit u, int country, int xpos, int ypos) {
        int hex = this.getHex(xpos, ypos);
        if (this.hex[hex].getUnit() != null) {
            System.exit(123435);
        }
        this.country[country].addUnit(u);
        this.country[country].units.lastElement().enterHex(this.hex, xpos, ypos, false);
    }

    private void createAndStoreUnit(Unit u, int country, int xpos, int ypos) {
        int hex = this.getHex(xpos, ypos);
        if (this.hex[hex].getUnit() != null) {
            System.exit(123435);
        }
        this.country[country].addUnit(u);
        this.country[country].addUnitStartPosition(this.hex[this.getHex(xpos, ypos)]);
    }

    private void createToForcePool(Unit u, int country) {
        this.country[country].addUnit(u);
        this.country[country].getForcePool().add(u);
    }

    public void ownershipChanges(Hex hex, Unit unit) {
        int startHex = this.getHexIndex(hex);
        int index = this.getNorthHex(startHex);
        if (this.insideMap(index) && this.hex[index] instanceof LandHex) {
            this.ownershipChange(this.hex[index], unit, false);
        }
        if (this.insideMap(index = this.getNorthEastHex(startHex)) && this.hex[index] instanceof LandHex) {
            this.ownershipChange(this.hex[index], unit, false);
        }
        if (this.insideMap(index = this.getSouthEastHex(startHex)) && this.hex[index] instanceof LandHex) {
            this.ownershipChange(this.hex[index], unit, false);
        }
        if (this.insideMap(index = this.getSouthHex(startHex)) && this.hex[index] instanceof LandHex) {
            this.ownershipChange(this.hex[index], unit, false);
        }
        if (this.insideMap(index = this.getSouthWestHex(startHex)) && this.hex[index] instanceof LandHex) {
            this.ownershipChange(this.hex[index], unit, false);
        }
        if (this.insideMap(index = this.getNorthWestHex(startHex)) && this.hex[index] instanceof LandHex) {
            this.ownershipChange(this.hex[index], unit, false);
        }
    }

    public void ownershipChange(Hex hex, Unit unit, boolean byForce) {
        boolean enemyUnit = false;
        if (hex.getUnit() != null && !unit.sameSide(hex.getUnit())) {
            enemyUnit = true;
        }
        if (hex instanceof LandHex) {
            if (this.getCountry(hex.getOwningCountry()).getSide() != unit.getCountry().getSide() && this.getCountry(hex.getOwningCountry()).getAtWar() && (byForce || hex.getPResource() == null && this.enemiesAdjacent(this.getHexIndex(hex), unit) <= 0 && !enemyUnit)) {
                if (hex.getPResource() instanceof Fortress) {
                    hex.razeFortress();
                }
                hex.setOwningCountry(unit.getCountry().getCountryIndex());
                int owningCountry = hex.getOwningCountry();
                int coreOwningCountry = hex.getCoreOwningCountry();
                if (this.getCountry(owningCountry).getSide() == this.getCountry(coreOwningCountry).getSide() && owningCountry != coreOwningCountry && this.getCountry(coreOwningCountry).getAtWar()) {
                    hex.setOwningCountry(coreOwningCountry);
                }
            }
            this.createOwningBorders();
        }
    }

    public void optionButtonProcedure() {
        this.warWindow.getButtonPanel2().optionButtonProcedure();
    }

    public String dateString(GregorianCalendar gcal) {
        String yearS = "";
        String monthS = "";
        String dayS = "";
        int year = gcal.get(1);
        int month = gcal.get(2) + 1;
        int day = gcal.get(5);
        yearS = "" + year;
        if (month < 10) {
            monthS = "0";
        }
        if (day < 10) {
            dayS = "0";
        }
        monthS = String.valueOf(monthS) + month;
        dayS = String.valueOf(dayS) + day;
        return String.valueOf(yearS) + "-" + monthS + "-" + dayS;
    }

    public String dateString2(GregorianCalendar gc) {
        String cal = String.valueOf(this.getMonthName(gc.get(2))) + " " + gc.get(5) + " " + gc.get(1);
        return cal;
    }

    public String dateString3(GregorianCalendar gc) {
        String cal = String.valueOf(gc.get(5)) + "-" + this.getMonthName(gc.get(2)) + "-" + gc.get(1);
        return cal;
    }

    /*
     * Unable to fully structure code
     */
    public void createScenarios() {
        scenarioFolder = new File(Global.getScenarioPath());
        scenarios = scenarioFolder.listFiles();
        i = 0;
        while (i < scenarios.length) {
            block3: {
                tmp = scenarios[i];
                s = tmp.getName();
                if (s == null || !s.endsWith(".scn")) break block3;
                s = new String(s.substring(0, s.length() - 4));
                destPath = String.valueOf(Global.getScenarioPath()) + s + ".data";
                System.out.println("Checking " + destPath);
                f = new File(destPath);
                if (!f.canRead()) ** GOTO lbl-1000
                System.out.println("  ...found. loadable?");
                if (this.loadGame(98, false, true, Global.getScenarioPath(), String.valueOf(s) + ".data")) {
                    System.out.println("  ...checks out. skipping.");
                } else lbl-1000:
                // 2 sources

                {
                    this.createScenario(s);
                }
            }
            ++i;
        }
        this.createScenario("1939");
    }

    public void randomizeWarEntries() {
        int i = 0;
        while (i < this.country.length) {
            if (!this.gameState.getOilConsumption()) {
                this.country[i].changeOil(999999.0);
            }
            int rnd = XRandAndCalc.randZero(Global.RANDOM_WAR_ENTRY * 2) - Global.RANDOM_WAR_ENTRY;
            this.country[i].getEntryDate().add(5, rnd * Global.DAYS_PER_TURN);
            ++i;
        }
    }

    public void setUpGame() {
        if (this.getGameMode() != 3000) {
            this.randomizeWarEntries();
        }
        if (this.getGameMode() == 2000 || this.getGameMode() == 4000) {
            this.setPlayerSide(this.whosTurn());
        }
        this.updateSupplyLevels(false);
        this.resetMovedRaided();
        this.fowProcedure();
        this.createOwningBorders();
        this.setHandicapLevels();
        int i = 0;
        while (i < this.country.length) {
            this.country[i].startUpgradeAllUnits();
            ++i;
        }
        if (this.country[23].getAtWar()) {
            this.country[0].allGroundUnitsOnTarget(this.country[23].activeCapital());
        }
        i = 0;
        while (i < 30) {
            this.updateEffectiveness(100);
            this.updateEffectiveness(200);
            ++i;
        }
        this.resetRailroad();
        GregorianCalendar gcal = new GregorianCalendar();
        this.gameState.setGameName(this.dateString(gcal));
        if (this.getGameMode() == 1000 && Global.SETTINGS_DATA.getVal("DEBUG_AI_VS_AI") == 1) {
            this.gameState.setAIvsAI(true);
        }
        if (this.gameState.getAIvsAI()) {
            this.gameState.setPlayerSide(this.oppositeSide(this.whosTurn()));
        }
        this.gameState.setWintersDone((8 + this.monthsPassed(this.calendar)) / 12);
        if (this.getGameMode() == 4000) {
            this.warWindow.getChatDialog().showDialog(Global.getMessage(804));
            this.gameState.setGameName(this.warWindow.getChatDialog().getText());
        }
    }

    public void startGame(boolean newGame) {
        this.gameState.setScenario(false);
        boolean pwSuccess = true;
        if (this.getGameMode() == 4000) {
            boolean createdPass = false;
            String pw = "";
            pwSuccess = false;
            pw = this.whosTurn() == 100 ? this.gameState.getAxisPassword() : this.gameState.getAlliesPassword();
            if (pw.compareTo("") == 0) {
                ChatDialog pbe = this.warWindow.getChatDialog();
                pbe.setName("PbEPass");
                pbe.showDialog(Global.createLanguageMessage(800, new String[]{this.getSideName(this.whosTurn(), false)}));
                if (this.whosTurn() == 100) {
                    this.gameState.setAxisPassword(this.warWindow.getChatDialog().getText());
                    pw = this.gameState.getAxisPassword();
                } else {
                    this.gameState.setAlliesPassword(this.warWindow.getChatDialog().getText());
                    pw = this.gameState.getAlliesPassword();
                }
                createdPass = true;
            }
            if (createdPass) {
                this.warWindow.getChatDialog().showDialog(Global.createLanguageMessage(803, new String[]{this.getSideName(this.whosTurn(), false)}));
            } else {
                this.warWindow.getChatDialog().showDialog(Global.createLanguageMessage(801, new String[]{this.getSideName(this.whosTurn(), false)}));
            }
            if (this.warWindow.getChatDialog().getText().compareTo(pw) == 0) {
                pwSuccess = true;
            }
        }
        if (!pwSuccess) {
            this.warWindow.quitToMainMenu();
        } else {
            Global.mt.beforeGame();
            this.warWindow.reset();
            if (this.playerSide() == this.whosTurn()) {
                this.adjustToolTipManager(this.getTooltips());
            } else {
                this.adjustToolTipManager(false);
            }
            if (this.getGameMode() != 3000) {
                this.clock.resetClock();
            }
            this.warWindow.endTurn();
            this.warWindow.updateAll(true);
            this.warWindow.oneImmediateFrame();
            Game.delay(2000L);
            this.theScreen.showPanel(this.warWindow);
            if (this.getGameMode() == 1000 && (this.playerSide() != this.whosTurn() || this.gameState.getAIvsAI())) {
                this.getAI().setActive(true);
            }
            if (this.playerSide() != this.whosTurn()) {
                this.warWindow.setCursor(10);
            } else {
                this.warWindow.setCursor(-1);
            }
            this.setTutorialMessage(0);
            if (this.getGameMode() == 4000 && !newGame) {
                this.warWindow.showBeginTurnDialog();
            }
            this.active = true;
        }
    }

    private void createScenario(String name) {
        this.loadGame(1000, true, false, "", "");
        try {
            this.loadBaseMap();
        }
        catch (Exception e) {
            System.exit(988);
        }
        this.storeCapitals();
        this.markCoreHexes();
        this.attachPorts();
        this.markCorePorts();
        this.majorCapitalBonusProduction();
        this.markLoopHexes();
        this.createContinents();
        this.createOceans();
        try {
            this.loadScenarioMap(String.valueOf(Global.getScenarioPath()) + name + ".scn");
        }
        catch (Exception e) {
            System.exit(991);
        }
        this.attachPorts();
        if (Global.SETTINGS_DATA.getVal("DEBUG_SHOW_ALL_TECH_LEVELS") == 1) {
            this.createAndPlaceStrangeTechedUnits();
        }
        this.saveGame(false, true, Global.getScenarioPath(), String.valueOf(name) + ".data");
    }

    @Override
    public void run() {
        int maxScrollDelay = 110;
        int scrollDelay = 110;
        int minScrollDelay = 50;
        int horizontalChange = 0;
        int verticalChange = 0;
        long lastFrame = 0L;
        this.busy = true;
        Game.delay(400L);
        this.busy = false;
        while (true) {
            Game.delay(200L);
            if (this.startGame) {
                this.setUpGame();
                this.getWarWindow().updateAll(true);
                this.startGame(true);
                this.startGame = false;
                this.warWindow.getMapCanvas().prepareForRender();
            }
            if (!this.active) continue;
            if (this.endTurnRequested) {
                this.busy = true;
                Game.delay(200L);
                this.endTurn2();
            }
            if (!this.busy && this.infoDialogText != "") {
                this.busy = true;
                this.warWindow.showInfoDialog(this.infoDialogText);
                this.infoDialogText = "";
                this.busy = false;
            }
            if (!(this.busy || this.getGameMode() == 1000 && this.whosTurn() != this.playerSide())) {
                this.optionButtonProcedure();
            }
            if (!this.busy && this.chatDialogRequested) {
                this.busy = true;
                this.warWindow.showChatDialog();
            }
            if (!this.busy) {
                this.showTutorialMessageIfNeeded2();
            }
            if (!this.busy && this.mouseClick.size() > 0) {
                MouseClick mc = this.mouseClick.remove(0);
                this.mouseClickedPixel(mc.getX(), mc.getY(), null, mc.getLeftClick());
            }
            if (!this.seingMap() || this.busy || this.whosTurn() != this.playerSide() && this.getGameMode() != 3000) continue;
            this.busy = true;
            int mouseScroll = this.mouseScroll;
            if (mouseScroll != 0) {
                if (mouseScroll == 3) {
                    horizontalChange = 20 * this.getZoom() + 10 * this.getZoom();
                } else if (mouseScroll == 1) {
                    horizontalChange = -20 * this.getZoom() - 10 * this.getZoom();
                } else if (mouseScroll == 2) {
                    verticalChange = -32 * this.getZoom();
                } else if (mouseScroll == 4) {
                    verticalChange = 32 * this.getZoom();
                }
            } else {
                int right = this.scrollingRight;
                int up = this.scrollingUp;
                if (right == 0) {
                    right = this.oneScrollRight * 5;
                }
                this.oneScrollRight = 0;
                if (up == 0) {
                    up = this.oneScrollUp * 5;
                }
                this.oneScrollUp = 0;
                if (right > 0) {
                    horizontalChange = 20 * this.getZoom() + 10 * this.getZoom();
                } else if (right < 0) {
                    horizontalChange = -20 * this.getZoom() - 10 * this.getZoom();
                } else if (up > 0) {
                    verticalChange = -32 * this.getZoom();
                } else if (up < 0) {
                    verticalChange = 32 * this.getZoom();
                }
            }
            if (horizontalChange != 0 || verticalChange != 0) {
                if (!this.scrolling) {
                    Game.delay(60L);
                    this.scrolling = true;
                    scrollDelay = 110;
                }
                this.warWindow.getMapCanvas().adjustViewPosition(horizontalChange, verticalChange);
                Game.delay(scrollDelay);
                scrollDelay -= 10;
                scrollDelay = Math.max(scrollDelay, 50);
                horizontalChange = 0;
                verticalChange = 0;
            } else {
                this.scrolling = false;
                long beforeTime = System.currentTimeMillis();
                if (beforeTime >= this.warWindow.getMapCanvas().getToolTipStartTime() && beforeTime - lastFrame > 100L) {
                    this.warWindow.oneSlowFrame();
                    lastFrame = beforeTime;
                }
            }
            this.busy = false;
        }
    }
}

