/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Casualties;
import game.CountryData;
import game.Game;
import game.Global;
import game.LeadersData;
import game.Research;
import game.Strategy;
import game.hex.Hex;
import game.hex.WaterHex;
import game.p_resource.OilField;
import game.unit.AirUnit;
import game.unit.Armour;
import game.unit.Battleship;
import game.unit.Carrier;
import game.unit.Commander;
import game.unit.Convoy;
import game.unit.Corps;
import game.unit.Destroyer;
import game.unit.Fighter;
import game.unit.Garrison;
import game.unit.GroundUnit;
import game.unit.HeavyTank;
import game.unit.MotorisedCorps;
import game.unit.NavalUnit;
import game.unit.StrategicBomber;
import game.unit.Sub;
import game.unit.TacticalBomber;
import game.unit.Transport;
import game.unit.Unit;
import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.Serializable;
import java.util.GregorianCalendar;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Country
implements Serializable {
    private static final long serialVersionUID = 67L;
    GregorianCalendar entryDate;
    Casualties casualties = new Casualties();
    private transient Game game;
    private final String dataName;
    private final String name;
    private final String owningName;
    private Color color;
    private Color highlightColor;
    private boolean atWar;
    private boolean DOWAble;
    private boolean majorCountry;
    boolean conquered = false;
    int peaceProductionFactor1939;
    double handicapFactor = 1.0;
    private Strategy strategy;
    Vector<Unit> units = new Vector(10, 1);
    Vector<Commander> unboughtCommanders = new Vector(10, 1);
    Vector<Hex> unitStartPositions = new Vector(10, 1);
    Vector<Unit> unitsUnderConstruction = new Vector(10, 1);
    Vector<Unit> forcePool = new Vector(10, 1);
    Vector<Hex> deployHexes = new Vector(10, 1);
    Vector<Hex> deployPorts = new Vector(10, 1);
    private int primaryCapital = -1;
    private int secondaryCapital = -1;
    private int countryIndex;
    private int side;
    private int offMapPP;
    private double pp = 0.0;
    private double lastPP;
    private double manpowerCap;
    private double manpower;
    private double lastManpower;
    private int offMapOil;
    private double oil;
    private double lastOil;
    private Research research;
    String entryMessage = "";

    Country(Game g, String dataNam, String nameP, String owningNam, Color colorP, Color highlightCol, int countryIndexP, int sideP, int offMapProd, int manPowCap, int offMapOi, int prodFact1939, boolean atWa, boolean majorN, GregorianCalendar entry, String entryMess) {
        this.dataName = dataNam;
        this.entryMessage = entryMess;
        this.entryDate = entry;
        this.game = g;
        this.name = nameP;
        this.owningName = owningNam;
        this.color = colorP;
        this.highlightColor = highlightCol;
        this.countryIndex = countryIndexP;
        this.side = sideP;
        this.manpowerCap = manPowCap;
        this.manpower = this.manpowerStartupLevel();
        this.offMapPP = offMapProd;
        this.offMapOil = offMapOi;
        this.oil = offMapOi * 10;
        this.peaceProductionFactor1939 = prodFact1939;
        this.atWar = atWa;
        this.majorCountry = majorN;
        this.DOWAble = !atWa;
        this.research = new Research(this, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
        this.readCommanders();
        this.strategy = new Strategy();
    }

    public void setEntryDate(int year, int month, int day) {
        this.entryDate = new GregorianCalendar(year, month, day);
    }

    public Casualties getCasualties() {
        return this.game.countryInCharge((Country)this).casualties;
    }

    public String getEntryMessage() {
        return this.entryMessage;
    }

    public GregorianCalendar getEntryDate() {
        return this.entryDate;
    }

    public double manpowerStartupLevel() {
        return 0.95 * this.realManpowerCap();
    }

    public void setTechLevels(int a, int b, int c, int d, int e, int f, int g, int h, int i, int j, int k, int l, int m, int n, int o) {
        this.research.setTechLevels(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
    }

    public int getMaxUpgrades(Unit u) {
        return this.research.getMaxUpgrades(u);
    }

    public int getUpgradesHeld(Unit u) {
        return this.research.getCountryUpgradesHeld(u);
    }

    public void startUpgradeAllUnits() {
        int x = 0;
        while (x < this.units.size()) {
            Unit u = this.units.get(x);
            u.upgradeUnit(false);
            ++x;
        }
    }

    public void setCountryData(CountryData cd) {
        this.countryIndex = cd.countryIndex;
        this.pp = cd.getPP();
        this.manpower = cd.getManpower();
        this.oil = cd.getOil();
        this.offMapPP = cd.getOffMapPP();
        this.manpowerCap = cd.getManpowerCapacity();
        this.offMapOil = cd.getOffMapOil();
        this.peaceProductionFactor1939 = cd.getIndustrialEffort1939();
    }

    public void setHandicapFactor(double val) {
        double fraction = this.getManpowerFraction();
        this.handicapFactor = val;
        this.setManpowerFraction(fraction);
    }

    public double getHandicapFactor() {
        return this.handicapFactor;
    }

    public boolean atWarWith(Country other) {
        return this.side != other.side && this.atWar && other.atWar;
    }

    public String getTwoCountryGraphicString_notusedddd(Country enemy) {
        String ret = "_";
        ret = this.isMajorCountry() ? String.valueOf(ret) + this.getDataName().toLowerCase() : (this.getSide() == 100 ? String.valueOf(ret) + "axisminor" : String.valueOf(ret) + "alliedminor");
        ret = String.valueOf(ret) + "_";
        ret = enemy.isMajorCountry() ? String.valueOf(ret) + enemy.getDataName().toLowerCase() : (enemy.getSide() == 100 ? String.valueOf(ret) + "axisminor" : String.valueOf(ret) + "alliedminor");
        return ret;
    }

    public String getCountryGraphicString() {
        String ret = "";
        if (this.isMajorCountry()) {
            ret = this.getDataName().toLowerCase();
        } else {
            Country fac = this.game.factionLeader(this.getSide());
            if (fac == null) {
                fac = this.game.getCountry(2);
            }
            ret = fac.getDataName().toLowerCase();
        }
        return ret;
    }

    public boolean mobilized() {
        return this.game.getCalendar().after(this.getEntryDate()) || this.game.getCalendar().equals(this.getEntryDate());
    }

    public String getSideName(boolean lowerCase) {
        return this.game.getSideName(this.side, lowerCase);
    }

    public String displayFactionName(boolean lowerCase) {
        String ret = "";
        switch (this.getFaction()) {
            case 5: {
                ret = Global.getMessage(303);
                break;
            }
            case 100: {
                ret = Global.getMessage(301);
                break;
            }
            case 200: {
                ret = Global.getMessage(302);
                break;
            }
            default: {
                ret = Global.getMessage(304);
            }
        }
        if (lowerCase) {
            ret = ret.toLowerCase();
        }
        return ret;
    }

    public int getFaction() {
        if (!this.conquered) {
            if (this.majorCountry) {
                if (this.countryIndex == 5) {
                    return 5;
                }
                if (this.getSide() == 200) {
                    return 200;
                }
                return 100;
            }
            return this.side;
        }
        return 300;
    }

    public String industrialEffort() {
        String ret = "";
        double factor = this.game.industrialEffort(this.getCountryIndex());
        ret = String.valueOf(ret) + " ( " + Global.getMessage(350) + " " + (int)(100.0 * factor) + "%)";
        return ret;
    }

    public int collectedPP() {
        return (int)(this.getPP() - this.getLastPP());
    }

    public int collectedOil() {
        return (int)(this.getOil() - this.getLastOil());
    }

    public int collectedManpower() {
        return (int)(this.getManpower() - this.getLastManpower());
    }

    public Image getFlag(int width, String state) {
        String s = "";
        if (state.length() > 0) {
            s = "_" + state;
        }
        return Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "flag_" + this.getDataName() + s + "_" + width + ".png");
    }

    public int imageIndex() {
        if (this.isMajorCountry()) {
            return this.countryIndex;
        }
        if (this.getSide() == 100) {
            return 6;
        }
        return 7;
    }

    public boolean activeFriendly(int side) {
        return this.getAtWar() && this.getSide() == side;
    }

    public boolean majorFriendly(int side) {
        return this.isMajorCountry() && this.getSide() == side;
    }

    public boolean majorAliveFriendly(int side) {
        return this.majorFriendly(side) && !this.isConquered();
    }

    public boolean majorAlive() {
        return this.isMajorCountry() && !this.isConquered();
    }

    public boolean majorAtWar() {
        return this.isMajorCountry() && this.atWar;
    }

    public boolean majorAliveFriendlyAtWar(int side) {
        return this.majorAliveFriendly(side) && this.atWar;
    }

    public int getPeaceProductionFactor1939() {
        return this.peaceProductionFactor1939;
    }

    public double pResourcesOil() {
        Hex[] hex = this.game.getHexes();
        double ret = 0.0;
        int i = 0;
        while (i < hex.length) {
            Country c;
            Hex h = hex[i];
            if (h.hasPResource() && h.getPResource() instanceof OilField && (c = this.game.getCountry(h.getOwningCountry())) == this) {
                double factor = c.productionTechFactor();
                double oil = h.getPP(this.game);
                ret += factor * oil;
            }
            ++i;
        }
        return ret;
    }

    public void updateUnitAggressions() {
        int i = 0;
        while (i < this.units.size()) {
            Unit u = this.units.get(i);
            Hex onHex = u.getOnHex();
            if (onHex != null) {
                double bonusAggression = 0.0;
                if (u instanceof GroundUnit && u.getSupply() <= Global.LOW_SUPPLY) {
                    bonusAggression += 0.2;
                }
                if (u instanceof GroundUnit && u.getDestinationHex() == null) {
                    bonusAggression += 0.3;
                }
                if (u instanceof GroundUnit) {
                    u.setAggressiveness(0.52 + bonusAggression + Math.min(0.6, this.game.militaryAdvantageRatioOverHex(u.getSide(), this.game.getHexIndex(onHex)) / 2.0));
                } else if (u instanceof AirUnit) {
                    u.setAggressiveness(0.95 + Math.min(0.2, this.game.militaryAdvantageRatioOverHex(u.getSide(), this.game.getHexIndex(onHex)) / 10.0));
                } else if (u instanceof Sub) {
                    u.setAggressiveness(0.4 + Math.min(0.9, this.game.militaryAdvantageRatioOverHex(u.getSide(), this.game.getHexIndex(onHex)) / 5.0));
                } else if (u instanceof NavalUnit) {
                    u.setAggressiveness(0.95 + Math.min(0.4, this.game.militaryAdvantageRatioOverHex(u.getSide(), this.game.getHexIndex(onHex)) / 8.0));
                }
            } else {
                u.setAggressiveness(1.0);
            }
            u.setAggressiveness(u.getAggressiveness() * (double)u.getStrength() / (double)u.maxStrength());
            ++i;
        }
    }

    public void allGroundUnitsOnTarget(int target) {
        int i = 0;
        while (i < this.units.size()) {
            Unit u = this.units.get(i);
            Hex h = u.getOnHex();
            if (h != null && !(u instanceof NavalUnit)) {
                if (h.getPResource() != null && u instanceof GroundUnit) {
                    u.setDestinationHex(null);
                } else if (h.getPResource() == null || u instanceof AirUnit) {
                    u.setDestinationHex(this.game.getHex(target));
                }
            }
            ++i;
        }
    }

    public boolean isMainland() {
        Game g = this.game;
        return g.isMainland(this.getPrimaryCapital());
    }

    public boolean isConvoyNation() {
        return this.getCountryIndex() == Global.CONVOY_NATION;
    }

    public boolean isRaidingNation() {
        return this.getSide() != this.game.getCountry(Global.CONVOY_NATION).getSide() && this.game.hasAtlanticPort(this.getCountryIndex());
    }

    public int unitsOnTarget(int target) {
        int ret = 0;
        int i = 0;
        while (i < this.units.size()) {
            Unit u = this.units.get(i);
            if (u.getOnHex() != null && target != -1 && this.game.getHexIndex(u.getDestinationHex()) == target) {
                ++ret;
            }
            ++i;
        }
        return ret;
    }

    public int nearestNonFrontGroundUnit(int target, int alreadyOnTargetStatus, int maxDist) {
        int ret = -1;
        int shortest = maxDist;
        int targetContinent = this.game.getHex(target).getContinent();
        int i = 0;
        while (i < this.units.size()) {
            int dist;
            Unit u = this.units.get(i);
            int dest = this.game.getHexIndex(u.getDestinationHex());
            if (!(u.getOnHex() == null || u.garrisonDuty() || !(u instanceof GroundUnit) || this.game.isInFrontLine(this.game.getHexIndex(u.getOnHex()), u) || u.getOnHex().getContinent() != targetContinent || alreadyOnTargetStatus == 1 && dest == target || alreadyOnTargetStatus == 2 && dest != target || (dist = this.game.shortestPath(this.game.getHexIndex(u.getOnHex()), target)) >= shortest)) {
                shortest = dist;
                ret = i;
            }
            ++i;
        }
        return ret;
    }

    public int nearestNonFrontGroundUnit(int target, int minDist) {
        int ret = -1;
        int shortest = 999999;
        int targetContinent = this.game.getHex(target).getContinent();
        int i = 0;
        while (i < this.units.size()) {
            int dist;
            Unit u = this.units.get(i);
            if (u.getOnHex() != null && !u.garrisonDuty() && u instanceof GroundUnit && !this.game.isInFrontLine(this.game.getHexIndex(u.getOnHex()), u) && u.getOnHex().getContinent() == targetContinent && (dist = this.game.shortestPath(this.game.getHexIndex(u.getOnHex()), target)) < shortest && dist >= minDist) {
                shortest = dist;
                ret = i;
            }
            ++i;
        }
        return ret;
    }

    public int getMaxLabs() {
        return (int)((double)Global.MAX_LABS * this.game.industrialEffort(this.countryIndex));
    }

    public int unitFromTarget_A_NearestTarget_B(int targetA, int targetB, int maxDist) {
        int ret = -1;
        int shortest = maxDist;
        int targetContinent = this.game.getHex(targetB).getContinent();
        int i = 0;
        while (i < this.units.size()) {
            int dist;
            Unit u = this.units.get(i);
            if (!(u instanceof NavalUnit) && u.getOnHex() != null && !u.onDefenceMission() && this.game.getHexIndex(u.getDestinationHex()) == targetA && u.getOnHex().getContinent() == targetContinent && (dist = this.game.shortestPath(this.game.getHexIndex(u.getOnHex()), targetB)) < shortest) {
                shortest = dist;
                ret = i;
            }
            ++i;
        }
        return ret;
    }

    public void manpowerIncrease() {
        this.manpower += (double)Global.MANPOWER_INCREASE * this.realManpowerCap() / 10000.0;
        if (!this.majorCountry) {
            this.manpower = Math.min(this.manpower, this.realManpowerCap());
        }
    }

    public double ownOil() {
        return this.oil;
    }

    public boolean desperateForOil() {
        return this.getOil() < (double)(this.game.oilConsumptionMovingAllUnits(this.getFaction()) * Global.OIL_BUFFER_BEFORE_DESPERATION);
    }

    public boolean lowOnOil() {
        return this.getOil() < (double)(2 * this.game.oilConsumptionMovingAllUnits(this.getFaction()));
    }

    public int manpowerPenaltyLevel() {
        int ret = 0;
        double d = this.getManpowerFraction();
        if (d < 0.75) {
            ++ret;
        }
        if (d < 0.5) {
            ++ret;
        }
        if (d < 0.25) {
            ++ret;
        }
        if (d < 0.0) {
            ++ret;
        }
        return ret;
    }

    public double getOil() {
        return this.game.getOil(this.getFaction());
    }

    public int getOperatesLeft() {
        return this.game.getOperatesLeft(this.getFaction());
    }

    public void changeOil(double change) {
        double realChange = change;
        if (change > 0.0 && this.game.getGameMode() == 1000 && this.game.opponentSide() == this.side) {
            realChange *= 2.0;
        }
        this.game.countryInCharge((Country)this).oil += realChange;
    }

    public boolean sameSide(Country other) {
        return this.getSide() == other.getSide();
    }

    public double getOffMapOil() {
        return this.offMapOil;
    }

    public void changeManpower(double amount) {
        this.manpower += amount;
        if (!this.majorCountry) {
            this.manpower = Math.min(this.manpower, this.realManpowerCap());
        }
    }

    public void setManpower(double amount) {
        this.manpower = amount;
        this.manpower = Math.min(this.manpower, this.realManpowerCap());
    }

    public void setManpowerFraction(double fraction) {
        this.manpower = fraction * this.realManpowerCap();
    }

    public double realManpowerCap() {
        return this.manpowerCap * this.handicapFactor;
    }

    public double getManpower() {
        return this.manpower;
    }

    public double getManpowerFraction() {
        return this.manpower / this.realManpowerCap();
    }

    private void readCommanders() {
        LeadersData ld = Global.LEADERS_DATA;
        int i = 0;
        while (i < ld.numRows()) {
            if (ld.getName(0, i).compareTo(this.getDataName()) == 0) {
                this.unboughtCommanders.add(new Commander(this, ld.getName(1, i), ld.getTranslationName(i), ld.getValue(0, i), ld.getValue(1, i), ld.getValue(2, i), ld.getValue(3, i), Global.getMessage(ld.getValue(4, i))));
            }
            ++i;
        }
    }

    public int highestCommanderIndex() {
        return this.unboughtCommanders.size() - 1;
    }

    public Commander getCommander(int i) {
        Commander ret = i >= this.unboughtCommanders.size() ? null : this.unboughtCommanders.get(i);
        return ret;
    }

    public Game getGame() {
        return this.game;
    }

    public void setGame(Game g) {
        this.game = g;
    }

    public int getPrimaryCapital() {
        return this.primaryCapital;
    }

    public int getSecondaryCapital() {
        return this.secondaryCapital;
    }

    public int activeCapital() {
        if (this.primaryCapital == -1) {
            return -1;
        }
        if (this.game.getHex(this.primaryCapital).getOwningCountry() == this.getCountryIndex()) {
            return this.primaryCapital;
        }
        return this.secondaryCapital;
    }

    public int controlledBySide() {
        if (this.primaryCapital == -1) {
            return 300;
        }
        if (this.secondaryCapital != -1) {
            return this.game.getCountry(this.game.getHex(this.secondaryCapital).getOwningCountry()).getSide();
        }
        return this.game.getCountry(this.game.getHex(this.primaryCapital).getOwningCountry()).getSide();
    }

    public boolean getDOWable() {
        return this.DOWAble;
    }

    public void setDOWable(boolean b) {
        this.DOWAble = b;
    }

    public Vector<Unit> getUnits() {
        return this.units;
    }

    public void setStrategy(Strategy s) {
        this.strategy = s;
    }

    public int getStrategicAggression() {
        return this.game.getStrategicAggression(this.getSide());
    }

    public double productionTechFactor() {
        double factor = 1.0;
        Research r = this.getResearch();
        if (r != null) {
            factor += 0.01 * (double)r.getIndustryTechBonus();
        }
        return factor;
    }

    public int numUnits() {
        int num = 0;
        num = num + this.units.size() + this.unitsUnderConstruction.size() + this.forcePool.size();
        int i = 0;
        while (i < this.units.size()) {
            if (this.units.get(i) instanceof Transport) {
                --num;
            }
            ++i;
        }
        i = 0;
        while (i < this.unitsUnderConstruction.size()) {
            if (this.unitsUnderConstruction.get(i) instanceof Transport) {
                --num;
            }
            ++i;
        }
        i = 0;
        while (i < this.forcePool.size()) {
            if (this.forcePool.get(i) instanceof Transport) {
                --num;
            }
            ++i;
        }
        return num;
    }

    public int numInfantry() {
        return this.numGarrison() + this.numCorps() + this.numMotorisedCorps();
    }

    public int numTanks() {
        return this.numLightTanks() + this.numHeavyTanks();
    }

    public int numLandUnits() {
        return this.numGroundUnits() + this.numAirUnits();
    }

    public int numGroundUnits() {
        int num = 0;
        int i = 0;
        while (i < this.units.size()) {
            if (this.units.get(i) instanceof GroundUnit) {
                ++num;
            }
            ++i;
        }
        i = 0;
        while (i < this.unitsUnderConstruction.size()) {
            if (this.unitsUnderConstruction.get(i) instanceof GroundUnit) {
                ++num;
            }
            ++i;
        }
        i = 0;
        while (i < this.forcePool.size()) {
            if (this.forcePool.get(i) instanceof GroundUnit) {
                ++num;
            }
            ++i;
        }
        return num;
    }

    public int numShips() {
        return this.numNavalUnits() - this.numSubs();
    }

    public int numNavalUnits() {
        int num = 0;
        int i = 0;
        while (i < this.units.size()) {
            if (this.units.get(i) instanceof NavalUnit) {
                ++num;
            }
            if (this.units.get(i) instanceof Transport) {
                --num;
            }
            if (this.units.get(i) instanceof Convoy) {
                --num;
            }
            ++i;
        }
        i = 0;
        while (i < this.unitsUnderConstruction.size()) {
            if (this.unitsUnderConstruction.get(i) instanceof NavalUnit) {
                ++num;
            }
            if (this.unitsUnderConstruction.get(i) instanceof Transport) {
                --num;
            }
            if (this.unitsUnderConstruction.get(i) instanceof Convoy) {
                --num;
            }
            ++i;
        }
        i = 0;
        while (i < this.forcePool.size()) {
            if (this.forcePool.get(i) instanceof NavalUnit) {
                ++num;
            }
            if (this.forcePool.get(i) instanceof Transport) {
                --num;
            }
            if (this.forcePool.get(i) instanceof Convoy) {
                --num;
            }
            ++i;
        }
        return num;
    }

    public int numAirUnits() {
        int num = 0;
        int i = 0;
        while (i < this.units.size()) {
            if (this.units.get(i) instanceof AirUnit) {
                ++num;
            }
            ++i;
        }
        i = 0;
        while (i < this.unitsUnderConstruction.size()) {
            if (this.unitsUnderConstruction.get(i) instanceof AirUnit) {
                ++num;
            }
            ++i;
        }
        i = 0;
        while (i < this.forcePool.size()) {
            if (this.forcePool.get(i) instanceof AirUnit) {
                ++num;
            }
            ++i;
        }
        return num;
    }

    public int numGarrison() {
        int num = 0;
        int i = 0;
        while (i < this.units.size()) {
            if (this.units.get(i) instanceof Garrison) {
                ++num;
            }
            ++i;
        }
        i = 0;
        while (i < this.unitsUnderConstruction.size()) {
            if (this.unitsUnderConstruction.get(i) instanceof Garrison) {
                ++num;
            }
            ++i;
        }
        i = 0;
        while (i < this.forcePool.size()) {
            if (this.forcePool.get(i) instanceof Garrison) {
                ++num;
            }
            ++i;
        }
        return num;
    }

    public int numCorps() {
        int num = 0;
        int i = 0;
        while (i < this.units.size()) {
            if (this.units.get(i) instanceof Corps) {
                ++num;
            }
            ++i;
        }
        i = 0;
        while (i < this.unitsUnderConstruction.size()) {
            if (this.unitsUnderConstruction.get(i) instanceof Corps) {
                ++num;
            }
            ++i;
        }
        i = 0;
        while (i < this.forcePool.size()) {
            if (this.forcePool.get(i) instanceof Corps) {
                ++num;
            }
            ++i;
        }
        return num;
    }

    public int numMotorisedCorps() {
        int num = 0;
        int i = 0;
        while (i < this.units.size()) {
            if (this.units.get(i) instanceof MotorisedCorps) {
                ++num;
            }
            ++i;
        }
        i = 0;
        while (i < this.unitsUnderConstruction.size()) {
            if (this.unitsUnderConstruction.get(i) instanceof MotorisedCorps) {
                ++num;
            }
            ++i;
        }
        i = 0;
        while (i < this.forcePool.size()) {
            if (this.forcePool.get(i) instanceof MotorisedCorps) {
                ++num;
            }
            ++i;
        }
        return num;
    }

    public int numLightTanks() {
        int num = 0;
        int i = 0;
        while (i < this.units.size()) {
            if (this.units.get(i) instanceof Armour) {
                ++num;
            }
            ++i;
        }
        i = 0;
        while (i < this.unitsUnderConstruction.size()) {
            if (this.unitsUnderConstruction.get(i) instanceof Armour) {
                ++num;
            }
            ++i;
        }
        i = 0;
        while (i < this.forcePool.size()) {
            if (this.forcePool.get(i) instanceof Armour) {
                ++num;
            }
            ++i;
        }
        return num;
    }

    public int numHeavyTanks() {
        int num = 0;
        int i = 0;
        while (i < this.units.size()) {
            if (this.units.get(i) instanceof HeavyTank) {
                ++num;
            }
            ++i;
        }
        i = 0;
        while (i < this.unitsUnderConstruction.size()) {
            if (this.unitsUnderConstruction.get(i) instanceof HeavyTank) {
                ++num;
            }
            ++i;
        }
        i = 0;
        while (i < this.forcePool.size()) {
            if (this.forcePool.get(i) instanceof HeavyTank) {
                ++num;
            }
            ++i;
        }
        return num;
    }

    public int numBombers() {
        return this.numTacticalBombers() + this.numStrategicBombers();
    }

    public int numFighters() {
        int num = 0;
        int i = 0;
        while (i < this.units.size()) {
            if (this.units.get(i) instanceof Fighter) {
                ++num;
            }
            ++i;
        }
        i = 0;
        while (i < this.unitsUnderConstruction.size()) {
            if (this.unitsUnderConstruction.get(i) instanceof Fighter) {
                ++num;
            }
            ++i;
        }
        i = 0;
        while (i < this.forcePool.size()) {
            if (this.forcePool.get(i) instanceof Fighter) {
                ++num;
            }
            ++i;
        }
        return num;
    }

    public int numTacticalBombers() {
        int num = 0;
        int i = 0;
        while (i < this.units.size()) {
            if (this.units.get(i) instanceof TacticalBomber) {
                ++num;
            }
            ++i;
        }
        i = 0;
        while (i < this.unitsUnderConstruction.size()) {
            if (this.unitsUnderConstruction.get(i) instanceof TacticalBomber) {
                ++num;
            }
            ++i;
        }
        i = 0;
        while (i < this.forcePool.size()) {
            if (this.forcePool.get(i) instanceof TacticalBomber) {
                ++num;
            }
            ++i;
        }
        return num;
    }

    public int numStrategicBombers() {
        int num = 0;
        int i = 0;
        while (i < this.units.size()) {
            if (this.units.get(i) instanceof StrategicBomber) {
                ++num;
            }
            ++i;
        }
        i = 0;
        while (i < this.unitsUnderConstruction.size()) {
            if (this.unitsUnderConstruction.get(i) instanceof StrategicBomber) {
                ++num;
            }
            ++i;
        }
        i = 0;
        while (i < this.forcePool.size()) {
            if (this.forcePool.get(i) instanceof StrategicBomber) {
                ++num;
            }
            ++i;
        }
        return num;
    }

    public int numSubs() {
        int num = 0;
        int i = 0;
        while (i < this.units.size()) {
            if (this.units.get(i) instanceof Sub) {
                ++num;
            }
            ++i;
        }
        i = 0;
        while (i < this.unitsUnderConstruction.size()) {
            if (this.unitsUnderConstruction.get(i) instanceof Sub) {
                ++num;
            }
            ++i;
        }
        i = 0;
        while (i < this.forcePool.size()) {
            if (this.forcePool.get(i) instanceof Sub) {
                ++num;
            }
            ++i;
        }
        return num;
    }

    public int numDestroyer() {
        int num = 0;
        int i = 0;
        while (i < this.units.size()) {
            if (this.units.get(i) instanceof Destroyer) {
                ++num;
            }
            ++i;
        }
        i = 0;
        while (i < this.unitsUnderConstruction.size()) {
            if (this.unitsUnderConstruction.get(i) instanceof Destroyer) {
                ++num;
            }
            ++i;
        }
        i = 0;
        while (i < this.forcePool.size()) {
            if (this.forcePool.get(i) instanceof Destroyer) {
                ++num;
            }
            ++i;
        }
        return num;
    }

    public int numBattleships() {
        int num = 0;
        int i = 0;
        while (i < this.units.size()) {
            if (this.units.get(i) instanceof Battleship) {
                ++num;
            }
            ++i;
        }
        i = 0;
        while (i < this.unitsUnderConstruction.size()) {
            if (this.unitsUnderConstruction.get(i) instanceof Battleship) {
                ++num;
            }
            ++i;
        }
        i = 0;
        while (i < this.forcePool.size()) {
            if (this.forcePool.get(i) instanceof Battleship) {
                ++num;
            }
            ++i;
        }
        return num;
    }

    public int numCarriers() {
        int num = 0;
        int i = 0;
        while (i < this.units.size()) {
            if (this.units.get(i) instanceof Carrier) {
                ++num;
            }
            ++i;
        }
        i = 0;
        while (i < this.unitsUnderConstruction.size()) {
            if (this.unitsUnderConstruction.get(i) instanceof Carrier) {
                ++num;
            }
            ++i;
        }
        i = 0;
        while (i < this.forcePool.size()) {
            if (this.forcePool.get(i) instanceof Carrier) {
                ++num;
            }
            ++i;
        }
        return num;
    }

    public int getLandShare() {
        return this.strategy.getLandShare();
    }

    public int getAirShare() {
        return this.strategy.getAirShare();
    }

    public int getUnitsPerLab() {
        return this.strategy.getUnitsPerLab();
    }

    public Strategy getStrategy() {
        return this.strategy;
    }

    public boolean isMajorCountry() {
        return this.majorCountry;
    }

    public void incFocusChangesLeft() {
        if (this.research != null) {
            this.research.incFocusChangesLeft();
        }
    }

    public void decFocusChangesLeft() {
        this.research.decFocusChangesLeft();
    }

    public void setResearch(Research t) {
        this.research = t;
    }

    public Research getResearch() {
        return this.research;
    }

    public void setAsNonCountry() {
        this.DOWAble = false;
    }

    public boolean getDOWAble() {
        return this.DOWAble;
    }

    public void setConquered(boolean b) {
        this.conquered = b;
    }

    public void setMajorNation(boolean b) {
        this.majorCountry = b;
    }

    public void setSide(int sid) {
        this.side = sid;
    }

    public int numDeployHexes() {
        return this.deployHexes.size();
    }

    public void addDeployHex(Hex h) {
        this.deployHexes.add(h);
    }

    public void addDeployPort(Hex h) {
        this.deployPorts.add(h);
    }

    public Hex getDeployHex(int i) {
        return this.deployHexes.get(i);
    }

    public Hex getDeployPort(int i) {
        return this.deployPorts.get(i);
    }

    public void setPrimaryCapital(int i) {
        this.primaryCapital = i;
    }

    public void setSecondaryCapital(int i) {
        this.secondaryCapital = i;
    }

    public Vector<Unit> getForcePool() {
        return this.forcePool;
    }

    public Vector<Unit> getUnitsUnderProduction() {
        return this.unitsUnderConstruction;
    }

    public void updateConstructions(boolean newTurn) {
        int i = 0;
        while (i < this.unitsUnderConstruction.size()) {
            Unit u = this.unitsUnderConstruction.get(i);
            if (newTurn && this.game.whosTurn() == u.getSide()) {
                u.updateTurnsBeforeComplete();
            }
            if (u.getTurnsBeforeComplete() == 0) {
                this.forcePool.add(u);
                this.unitsUnderConstruction.remove(i);
                --i;
            }
            ++i;
        }
    }

    public void storeLastPP() {
        this.lastPP = this.getPP();
    }

    public void storeLastManpower() {
        this.lastManpower = this.getManpower();
    }

    public void storeLastOil() {
        this.lastOil = this.getOil();
    }

    public double getLastPP() {
        return this.lastPP;
    }

    public double getLastManpower() {
        return this.lastManpower;
    }

    public double getLastOil() {
        return this.lastOil;
    }

    public void addPP(double amount) {
        this.game.countryInCharge((Country)this).pp += amount;
    }

    public void payPP(double amount) {
        this.game.countryInCharge((Country)this).pp -= amount;
    }

    public void killUnit(Unit u, boolean dialogMessage) {
        int i = 0;
        while (i < this.units.size()) {
            Unit tmp = this.units.get(i);
            if (tmp == u) {
                this.units.remove(i);
            }
            ++i;
        }
    }

    public void cashInConvoyCargo(Unit u, boolean hereFirst) {
        if (u.getCountry().getSide() == this.game.playerSide() || this.game.getGameMode() == 2000) {
            this.game.getWarWindow().showInfoDialog(Global.createLanguageMessage(112, new String[]{"" + u.getStrength(), this.name}));
        }
        if (hereFirst) {
            String s = "b " + this.getCountryIndex() + " " + this.game.getHexIndex(u.getOnHex()) + " ";
            this.game.sendDataToOpponent(s);
        }
        this.addPP(u.getStrength());
        u.killUnit(0, false);
    }

    public void surrender() {
        int i = 0;
        while (i < this.units.size()) {
            this.units.get(i).removeFromMap();
            ++i;
        }
        this.atWar = false;
        this.conquered = true;
    }

    public boolean isConquered() {
        return this.conquered;
    }

    public void boughtUnit(Unit u) {
        if (!(u instanceof Convoy) && this.pp < 0.0) {
            System.exit(186);
        }
        this.pp -= (double)u.getPrice();
        this.changeManpower(-u.getManpower());
        this.produceUnit(u);
    }

    public void produceUnit(Unit u) {
        this.addUnit(u);
        this.unitsUnderConstruction.add(u);
        if (u instanceof Commander) {
            this.unboughtCommanders.remove(u);
        }
        this.game.productionUpdate(false);
    }

    public String manpowerString() {
        String s = "";
        s = String.valueOf(Global.getMessage(410)) + " ";
        s = String.valueOf(s) + (int)(100.0 * this.getManpowerFraction()) + "%";
        if (Unit.qualityManpowerPenalty(this) > 0) {
            if (Unit.qualityManpowerPenalty(this) > 0) {
                s = String.valueOf(s) + " : ";
                s = String.valueOf(s) + Global.getMessage(387) + " ";
                s = String.valueOf(s) + "-";
                s = String.valueOf(s) + Unit.qualityManpowerPenalty(this);
                s = String.valueOf(s) + "  ";
            }
            if (Unit.survivabilityManpowerPenalty(this) > 0) {
                s = String.valueOf(s) + Global.getMessage(388) + " ";
                s = String.valueOf(s) + "-";
                s = String.valueOf(s) + Unit.survivabilityManpowerPenalty(this);
            }
        }
        return s;
    }

    public void transportationLoopPlaceUnit(Unit u, int hex) {
        u.enterHex(this.game.getHex(hex), false);
        if (u.isInvisible() && this.game.getHex(hex).isLoopHex()) {
            u.setInvisible(false);
        }
    }

    public int deployUnit(Unit u, int hex) {
        int i = 0;
        while (i < this.forcePool.size()) {
            if (this.forcePool.get(i) == u) {
                this.deployUnit(i, hex);
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Unit deployUnit(int unit, int hex) {
        Unit u = this.forcePool.remove(unit);
        u.enterHex(this.game.getHex(hex), false);
        u.setMorale(u.maxMorale() - Global.EFFICIENCY_LOSS_FROM_DEPLOY);
        u.setFOWed(this.game.getHex(hex).getFOW(this.game.oppositeSide(u.getSide())));
        return u;
    }

    public void reassignCommander(Unit u, int turns) {
        Commander c = u.getCommander();
        c.setTurnsBeforeComplete(turns);
        this.unitsUnderConstruction.add(c);
        this.payPP(Global.COMMANDER_REASSIGN_COST);
        u.setCommander(null);
    }

    public void injureCommander(Unit u, int roll) {
        Commander c = u.getCommander();
        int injury = 1 + roll % Global.COMMANDER_MAX_INJURY;
        if (roll % 2 == 0 || u.getStrength() < 1) {
            c.setTurnsBeforeComplete(injury);
            this.unitsUnderConstruction.add(c);
            u.setCommander(null);
            this.game.requestShowInfoDialog(Global.createLanguageMessage(113, new String[]{c.getIndividualName(), this.name, "" + injury}));
        }
    }

    public void setStartingPP(double startPP) {
        this.pp = startPP;
    }

    public double getPP() {
        return this.pp;
    }

    public int getSide() {
        return this.side;
    }

    public int getWarSide() {
        if (!this.atWar) {
            return 300;
        }
        return this.getSide();
    }

    public String getDataName() {
        return this.dataName;
    }

    public String getName() {
        return this.name;
    }

    public String getOwningName() {
        return this.owningName;
    }

    public String getLowerCaseOwningName() {
        return this.owningName.toLowerCase();
    }

    public void resetMovedRaided() {
        if (this.atWar) {
            int i = 0;
            while (i < this.units.size()) {
                Unit u = this.units.get(i);
                u.resetHasMoved();
                u.resetHasRaided();
                ++i;
            }
        }
    }

    public int getOffMapProduction() {
        return this.offMapPP;
    }

    public boolean getAtWar() {
        return this.atWar;
    }

    public void setAtWar(boolean b) {
        this.atWar = b;
    }

    public Transport transport(Unit u, Hex h, boolean forFree) {
        Hex dest = u.getDestinationHex();
        if (!forFree) {
            this.payPP(Global.TRANSPORT_COST);
        }
        u.removeFromMap();
        u.setSupply(Global.LOW_SUPPLY);
        Transport uu = new Transport(u.getCountry(), u);
        uu.setFOWed(h.getFOW(this.game.oppositeSide(u.getSide())));
        uu.enterHex(h, false);
        this.addUnit(uu);
        uu.setDestinationHex(dest);
        return uu;
    }

    public Color getColor() {
        return this.color;
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public static boolean enemies(Country one, Country two) {
        return one.side != two.side;
    }

    public void addUnit(Unit u) {
        this.units.add(u);
        u.upgradeUnit(false);
    }

    public int getCountryIndex() {
        return this.countryIndex;
    }

    public void deployStartingUnits() {
        int i = 0;
        while (i < this.unitStartPositions.size()) {
            Unit u = this.units.get(i);
            Hex h = this.unitStartPositions.get(i);
            if (h instanceof WaterHex && u.isLandUnit()) {
                this.transport(u, h, true);
            } else {
                u.enterHex(h, false);
            }
            ++i;
        }
    }

    public void addUnitStartPosition(Hex h) {
        this.unitStartPositions.add(h);
    }

    public void joinWar(int joinSide) {
        this.atWar = true;
        if (this.side == 300) {
            this.side = joinSide;
            if (this.side == 200) {
                this.color = Global.ALLIED_MINOR_COLOR;
                this.highlightColor = Global.ALLIED_MINOR_HIGHLIGHT_COLOR;
            } else {
                this.color = Global.GERMAN_MINOR_COLOR;
                this.highlightColor = Global.GERMAN_MINOR_HIGHLIGHT_COLOR;
            }
        }
    }
}

