/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Game;
import game.SaveGame;
import game.XThread;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.StringTokenizer;

public class ClientServer
extends XThread {
    Game game;
    boolean server = false;
    String connectToIP;
    DataInputStream inStream;
    DataOutputStream outStream;
    ObjectOutputStream ooStream;
    ObjectInputStream oiStream;
    boolean connectPhase = false;

    public ClientServer(boolean serv, String ip, Game g) {
        this.server = serv;
        this.game = g;
        this.connectToIP = ip;
    }

    public void setConnectToIP(String s) {
        this.connectToIP = s;
    }

    public void setConnectPhase(boolean b) {
        this.connectPhase = b;
    }

    public boolean isServer() {
        return this.server;
    }

    public DataOutputStream getOutStream() {
        return this.outStream;
    }

    public DataInputStream getInStream() {
        return this.inStream;
    }

    public ObjectInputStream getoiStream() {
        return this.oiStream;
    }

    public ObjectOutputStream getooStream() {
        return this.ooStream;
    }

    public void setServer(boolean b) {
        this.server = b;
    }

    public void endTurn() {
    }

    private void receiveSaveGame(Object o) {
        String gameName = this.game.getGameState().getGameName();
        int zoom = this.game.getGameState().getZoom();
        boolean nato = this.game.getGameState().getNatoSymbols();
        boolean hexGrid = this.game.getGameState().getHexGrid();
        boolean toolTips = this.game.getGameState().getTooltips();
        boolean darkOverlay = this.game.getGameState().getDarkOverlay();
        SaveGame sg = (SaveGame)o;
        this.game.gameState = sg.getGameState();
        this.game.country = sg.getCountry();
        this.game.hex = sg.getHex();
        this.game.calendar = sg.getGregorianCalendar();
        this.game.timeSystem = sg.getTimeSystem();
        this.game.getGameState().setGameName(gameName);
        this.game.getGameState().setZoom(zoom);
        this.game.getGameState().setNatoSymbols(nato);
        this.game.getGameState().setHexGrid(hexGrid);
        this.game.getGameState().setTooltips(toolTips);
        this.game.getGameState().setDarkOverlay(darkOverlay);
        boolean isScenario = this.game.gameState.getScenario();
        int i = 0;
        while (i < this.game.country.length) {
            this.game.country[i].setGame(this.game);
            ++i;
        }
        this.game.switchPlayerSide();
        this.game.busy = false;
        this.game.scrolling = false;
        this.game.endTurnRequested = false;
        this.game.chatDialogRequested = false;
        this.game.nextreadyUnit = 0;
        this.game.nowShowing = 0;
        this.game.selectedCountry = -1;
        this.game.selectedHex = null;
        this.game.actionHex = null;
        this.game.enemyHex = null;
        this.game.tmpUnit = null;
        this.game.exploitMove = false;
        this.game.getMainMenu().startTCPIPGame(isScenario);
        this.game.orderThread.decOutgoingMessageID();
        this.game.getClock().resetClock();
        this.game.sendDataToOpponent(String.valueOf(this.game.getClock().getSyncTime()) + " ");
        if (this.game.playerSide() != this.game.whosTurn()) {
            this.game.getWarWindow().setCursor(10);
        } else {
            this.game.getWarWindow().setCursor(-1);
        }
    }

    private void sParameter(String message) {
        boolean isScenario = this.game.gameState.getScenario();
        String s = new String(message.substring(2));
        StringTokenizer st = new StringTokenizer(s);
        String ss = st.nextToken();
        long startTime = Long.parseLong(ss);
        ClientServer.delay(500L);
        this.game.getClock().resetClock();
        this.game.getClock().setSyncTime(startTime);
        this.game.showTimeLeft();
        this.game.getWarWindow().updateAll(true);
        ClientServer.delay(500L);
        this.game.getMainMenu().startTCPIPGame(isScenario);
    }

    private void serverSide() {
        int listenOnPort = 6770;
        try {
            ServerSocket listenSocket = new ServerSocket(6770);
            Socket clientSocket = listenSocket.accept();
            this.game.getMainMenu().setFullEnabled(false);
            this.game.getMainMenu().connectPhase(1);
            this.ooStream = new ObjectOutputStream(new BufferedOutputStream(clientSocket.getOutputStream()));
            this.ooStream.flush();
            ClientServer.delay(1000L);
            this.oiStream = new ObjectInputStream(new BufferedInputStream(clientSocket.getInputStream()));
            ClientServer.delay(100L);
            ClientServer.delay(200L);
            this.game.randomizeWarEntries();
            this.game.sendSaveGameToOpponent();
            this.game.showTimeLeft();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void clientSide() {
        int serverPort = 6770;
        try {
            Socket serverSock = new Socket(this.connectToIP, 6770);
            this.game.getMainMenu().setFullEnabled(false);
            this.game.getMainMenu().connectPhase(1);
            this.ooStream = new ObjectOutputStream(new BufferedOutputStream(serverSock.getOutputStream()));
            this.ooStream.flush();
            ClientServer.delay(1000L);
            this.oiStream = new ObjectInputStream(new BufferedInputStream(serverSock.getInputStream()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void run() {
        while (true) {
            ClientServer.delay(20L);
            if (!this.connectPhase) continue;
            try {
                if (this.server) {
                    this.serverSide();
                } else {
                    this.clientSide();
                }
                while (true) {
                    Object o;
                    if ((o = this.oiStream.readObject()) == null) {
                        continue;
                    }
                    if (o instanceof SaveGame) {
                        this.receiveSaveGame(o);
                        continue;
                    }
                    if (!(o instanceof String)) continue;
                    if (((String)o).startsWith("-1")) {
                        this.sParameter((String)o);
                        continue;
                    }
                    this.game.getOrderThread().insertOrder((String)o);
                }
            }
            catch (Exception e) {
                this.connectPhase = false;
                this.game.getWarWindow().quitToMainMenu();
                continue;
            }
            break;
        }
    }
}

