/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.ColorString;
import game.XThread;
import gui.WarWindow;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChatMessages
extends XThread {
    long latestInsertTime = 0L;
    WarWindow warWindow;
    Vector<ColorString> messages = new Vector(1, 1);

    public ChatMessages(WarWindow w) {
        this.warWindow = w;
    }

    public Vector<ColorString> getMessages() {
        return this.messages;
    }

    public boolean isFull() {
        return this.messages.size() >= 5;
    }

    public void insertMessage(ColorString s) {
        if (this.isFull()) {
            this.removeFirst();
            this.messages.add(s);
        } else {
            this.messages.add(s);
        }
        this.latestInsertTime = System.currentTimeMillis();
    }

    private boolean removeFirst() {
        if (!this.isEmpty()) {
            int i = 0;
            while (i < this.messages.size() - 1) {
                this.messages.set(i, this.messages.get(i + 1));
                ++i;
            }
            this.messages.remove(this.messages.size() - 1);
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.messages.size() == 0;
    }

    @Override
    public void run() {
        while (true) {
            ChatMessages.delay(1000L);
            if (System.currentTimeMillis() - this.latestInsertTime <= 30000L) continue;
            this.latestInsertTime = System.currentTimeMillis();
            if (!this.removeFirst()) continue;
            this.warWindow.oneSlowFrame();
        }
    }
}

