/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Country;
import game.Game;
import game.Global;
import game.Node;
import game.OddsAndPenalties;
import game.Research;
import game.Strategy;
import game.UnitPriorityQueue;
import game.XRandAndCalc;
import game.XThread;
import game.hex.Hex;
import game.hex.LandHex;
import game.hex.WaterHex;
import game.p_resource.Capital;
import game.p_resource.City;
import game.p_resource.Fortress;
import game.unit.AirUnit;
import game.unit.Armour;
import game.unit.Battleship;
import game.unit.Carrier;
import game.unit.Convoy;
import game.unit.Corps;
import game.unit.Destroyer;
import game.unit.Fighter;
import game.unit.GroundUnit;
import game.unit.MotorisedCorps;
import game.unit.NavalUnit;
import game.unit.StrategicBomber;
import game.unit.Sub;
import game.unit.TacticalBomber;
import game.unit.Transport;
import game.unit.Unit;
import java.awt.Point;
import java.util.Vector;

public class AI
extends XThread {
    Game game;
    boolean active = false;
    Vector<Unit> readyUnits = new Vector(50, 20);
    UnitPriorityQueue pq = new UnitPriorityQueue();

    public AI(Game g) {
        this.game = g;
    }

    public int aiSide() {
        return this.game.opponentSide();
    }

    public void setActive(boolean b) {
        this.active = b;
        this.interrupt();
    }

    private void AIStart() {
        this.game.getWarWindow().getMapCanvas().setAutomaticMoving(true);
        this.createReadyUnitVector();
        if (this.active) {
            this.dow();
        }
        if (this.active && (this.game.getGameState().getTurn() >= 1 || this.game.getCalendar().get(1) != 1939)) {
            this.updateInvasions();
        }
        if (this.active && (this.game.getGameState().getTurn() >= 1 || this.game.getCalendar().get(1) != 1939)) {
            this.updateDestinations();
            if (this.game.getGameState().getTurn() < 2) {
                int j = 0;
                while (j < 2) {
                    this.updateDestinations();
                    ++j;
                }
            }
        }
        if (this.active) {
            this.updatePurchaseResearchPriorities();
        }
        if (this.active) {
            this.research();
        }
        if (this.active) {
            this.purchaseUnits();
        }
        if (this.active) {
            this.deployUnits();
        }
        if (this.active && (this.game.getGameState().getTurn() >= 1 || this.game.getCalendar().get(1) != 1939)) {
            this.protectDestinations();
        }
        if (this.active) {
            this.updateUnitAggression();
        }
        if (this.active) {
            this.transportUnits();
        }
        if (this.active) {
            this.updateWayPoints();
        }
        if (this.active) {
            this.updateChasePoints();
        }
        if (this.active) {
            this.navalRetreats();
        }
        if (this.active) {
            this.airRetreats();
        }
        if (this.active) {
            this.upgradeUnits();
        }
        int i = 0;
        while (i < 4) {
            this.airAttacks();
            if (i == 2) {
                this.unloadUnits();
            }
            this.railMoves();
            if (i == 0) {
                this.moveGroundNavalUnits(true);
            } else {
                this.moveGroundNavalUnits(false);
            }
            this.staticAttacks();
            ++i;
        }
        this.airMoves();
        this.reinforce();
        this.game.getWarWindow().getMapCanvas().setAutomaticMoving(false);
        if (this.active) {
            this.setActive(false);
            this.game.setEndTurnRequested(true);
        }
    }

    private void createReadyUnitVector() {
        while (this.game.getBusy()) {
            AI.delay(500L);
        }
        this.readyUnits.removeAllElements();
        this.pq = new UnitPriorityQueue();
        int i = 0;
        while (i < this.game.country.length) {
            if (this.game.country[i].getSide() == this.aiSide() && this.game.getCountry(i).getAtWar()) {
                Vector<Unit> coun = this.game.getCountry((int)i).units;
                int j = 0;
                while (j < coun.size()) {
                    Unit u = coun.get(j);
                    if (!(u.getOnHex() == null || u instanceof GroundUnit && u.getOnHex() instanceof WaterHex || u.getHasMoved())) {
                        this.pq.add(u);
                    }
                    ++j;
                }
            }
            ++i;
        }
        while (this.pq.size() > 0) {
            this.readyUnits.add(this.pq.poll());
        }
        this.game.optionButtonProcedure();
    }

    private void research() {
        while (this.game.getBusy()) {
            AI.delay(500L);
        }
        int i = 0;
        while (i < this.game.country.length) {
            Game g = this.game;
            Country country = this.game.getCountry(i);
            if (country.majorAliveFriendly(this.aiSide())) {
                Research t = country.getResearch();
                while (country.numUnits() - (t.getNumLabs() + 1) * country.getUnitsPerLab() > 0) {
                    if (!(country.getPP() > (double)(t.currentLabPrice() + 10 + 50 * this.game.yearsPassed(this.game.getCalendar()))) || t.getNumLabs() >= country.getMaxLabs()) break;
                    int tech = 0;
                    Strategy strat = country.getStrategy();
                    int[] score = new int[]{2 - 10 * t.getResearchArea(0).getLabs(), 6 - 10 * t.getResearchArea(1).getLabs(), 4 - 10 * t.getResearchArea(2).getLabs(), -10 * t.getResearchArea(3).getLabs(), 8 - 10 * t.getResearchArea(4).getLabs()};
                    if (strat.getLandShare() >= 100) {
                        score[3] = score[3] - 999999;
                    }
                    if (country.getPrimaryCapital() == -1 || g.getHex(g.getCountry(0).getPrimaryCapital()).getContinent() != g.getHex(country.getPrimaryCapital()).getContinent()) {
                        score[2] = score[2] + 20;
                        score[3] = score[3] + 10;
                    }
                    tech = Game.indexOfHighestInt(score, new Vector<Integer>());
                    country.getResearch().doAction(10, tech, false, false);
                }
            }
            ++i;
        }
        this.game.optionButtonProcedure();
    }

    public void updateInvasions() {
        Game g = this.game;
        while (this.game.getBusy()) {
            AI.delay(500L);
        }
        int i = 0;
        while (i < this.game.country.length) {
            if (this.game.getCountry(i).getAtWar() && this.game.getCountry(i).isMajorCountry() && this.game.getCountry(i).getSide() != this.game.playerSide()) {
                int third;
                int second;
                this.game.getCountry(i).getStrategy().resetTargets();
                int[] scores = new int[this.game.country.length];
                int j = 0;
                while (j < scores.length) {
                    Country ownCountry = g.getCountry(i);
                    Country targetCountry = g.getCountry(j);
                    scores[j] = targetCountry.isMajorCountry() ? scores[j] + Global.TARGET_MAJOR_INCREASE * (g.getCalendar().get(1) - 1939) : scores[j] - Global.TARGET_MINOR_DECREASE * (g.getCalendar().get(1) - 1939);
                    if (targetCountry.getAtWar()) {
                        int n = j;
                        scores[n] = scores[n] + Global.AT_WAR;
                    } else {
                        int monthsBeforeEntry = this.game.monthsBeforeWarEntry(targetCountry);
                        if (monthsBeforeEntry < 10 && monthsBeforeEntry > 0) {
                            scores[j] = scores[j] + Global.AT_WAR * (10 - monthsBeforeEntry) / 10;
                        }
                    }
                    if (targetCountry.isMajorCountry() && ownCountry.getSide() == targetCountry.getSide() && this.controlledBySide(targetCountry.getCountryIndex()) == this.game.oppositeSide(targetCountry.getSide())) {
                        int n = j;
                        scores[n] = scores[n] + Global.RECONQUEST_MAJOR;
                    }
                    scores[j] = scores[j] + Global.MILITARY_INFLUENCE_FACTOR * g.militaryInfluenceOverHex(ownCountry.getSide(), targetCountry.activeCapital()) / 100;
                    if (this.controlledBySide(ownCountry.getCountryIndex()) == this.controlledBySide(targetCountry.getCountryIndex())) {
                        int n = j;
                        scores[n] = scores[n] + Global.SAME_SIDE;
                    }
                    if (targetCountry.pResourcesOil() > 0.0 && ownCountry.desperateForOil()) {
                        int n = j;
                        scores[n] = scores[n] + Global.OIL_IMPORTANCE;
                    }
                    if (ownCountry.activeCapital() != -1 && targetCountry.activeCapital() != -1) {
                        scores[j] = scores[j] + Global.MAX_CAPITAL_TO_CAPITAL_DISTANCE * Global.DISTANCE_BONUS_PER_HEX - Global.DISTANCE_BONUS_PER_HEX * g.shortestPath(ownCountry.activeCapital(), targetCountry.activeCapital());
                    }
                    scores[j] = scores[j] + Global.AGGRESSION_IMPORTANCE * g.getStrategicAggression(g.opponentSide()) / 100;
                    if (ownCountry.activeCapital() != -1 && targetCountry.activeCapital() != -1 && this.game.getHex(ownCountry.activeCapital()).getContinent() == this.game.getHex(targetCountry.activeCapital()).getContinent()) {
                        scores[j] = scores[j] + Global.SAME_CONTINENT;
                    }
                    int n = j++;
                    scores[n] = scores[n] + XRandAndCalc.rand(Global.MAX_TARGET_RANDOM);
                }
                Vector<Integer> notAllowed = new Vector<Integer>(5, 1);
                int first = Game.indexOfHighestInt(scores, notAllowed);
                if (first != -1) {
                    notAllowed.add(new Integer(first));
                }
                if ((second = Game.indexOfHighestInt(scores, notAllowed)) != -1) {
                    notAllowed.add(new Integer(second));
                }
                if ((third = Game.indexOfHighestInt(scores, notAllowed)) != -1) {
                    notAllowed.add(new Integer(third));
                }
                if (scores[first] > Global.TARGET_THRESHOLD) {
                    this.game.getCountry(i).getStrategy().setPrimaryTarget(this.game.getCountry(first));
                }
                if (scores[second] > Global.TARGET_THRESHOLD) {
                    this.game.getCountry(i).getStrategy().setSecondaryTarget(this.game.getCountry(second));
                }
                if (scores[third] > Global.TARGET_THRESHOLD) {
                    this.game.getCountry(i).getStrategy().setTertiaryTarget(this.game.getCountry(third));
                }
            }
            ++i;
        }
        this.game.optionButtonProcedure();
    }

    private void purchaseUnits() {
        while (this.game.getBusy()) {
            AI.delay(500L);
        }
        int i = 0;
        while (i < this.game.country.length) {
            Country country = this.game.getCountry(i);
            Strategy strat = country.getStrategy();
            if (country.majorAliveFriendly(this.aiSide())) {
                while (country.getManpowerFraction() > 0.55 && (country.numUnits() / (country.getResearch().getNumLabs() + 1) <= country.getUnitsPerLab() || country.getResearch().getNumLabs() >= country.getMaxLabs())) {
                    Unit neededUnit = (100 - strat.getLandShare()) * country.numLandUnits() <= strat.getLandShare() * (country.numNavalUnits() + 1) ? (strat.getAirShare() * country.numGroundUnits() <= (100 - strat.getAirShare()) * country.numAirUnits() + 1 ? (strat.getArmourShare() * country.numInfantry() <= (100 - strat.getArmourShare()) * (country.numTanks() + 1) ? (strat.getMotorisedShare() * country.numCorps() <= (100 - strat.getMotorisedShare()) * country.numMotorisedCorps() ? new Corps(country) : new MotorisedCorps(country)) : new Armour(country)) : (strat.getBomberShare() * country.numFighters() <= (100 - strat.getBomberShare()) * country.numBombers() ? new Fighter(country) : (country.numTacticalBombers() <= 2 * (country.numStrategicBombers() + 1) ? new TacticalBomber(country) : new StrategicBomber(country)))) : (100 - strat.getSubShare() * (country.numSubs() + 1) <= strat.getSubShare() * country.numShips() ? new Sub(country) : (country.numBattleships() + 3 <= country.numCarriers() + country.numDestroyer() ? new Battleship(country) : (country.numDestroyer() <= country.numCarriers() + 1 ? new Destroyer(country) : new Carrier(country))));
                    if (!(country.getPP() >= (double)(neededUnit.getPrice() + 10 + 50 * this.game.yearsPassed(this.game.getCalendar())))) break;
                    country.boughtUnit(neededUnit);
                    if (neededUnit != null) continue;
                    System.exit(country.getCountryIndex());
                }
            }
            ++i;
        }
        this.game.optionButtonProcedure();
    }

    private void deployUnits() {
        Game g = this.game;
        while (this.game.getBusy()) {
            AI.delay(500L);
        }
        int i = 0;
        while (i < this.game.country.length) {
            if (this.game.getCountry(i).majorAliveFriendly(this.aiSide())) {
                Country c = this.game.getCountry(i);
                boolean deployed = true;
                while (c.getForcePool().size() > 0 && deployed) {
                    deployed = false;
                    Unit u = c.getForcePool().get(0);
                    this.game.highlightDeployHexes(c.getCountryIndex(), u);
                    if (u instanceof NavalUnit) {
                        int j = 0;
                        while (j < c.deployPorts.size()) {
                            int moveToHex;
                            Hex h = c.getDeployPort(j);
                            Unit blocker = h.getUnit();
                            if (blocker != null && blocker.getStrength() == blocker.maxStrength() && u.getSide() == blocker.getSide() && this.game.owningSide(this.game.getHexIndex(h)) == u.getSide() && this.readyUnits.contains(blocker) && (moveToHex = this.game.evacuateHex(3, blocker)) != -1) {
                                this.moveAndBlitz(blocker, moveToHex);
                                this.readyUnits.remove(i);
                            }
                            if (h.getUnit() == null && h.getSupply() >= Global.MAX_SUPPLY) {
                                c.deployUnit(0, this.game.getHexIndex(h));
                                u.setHasMoved(true);
                                deployed = true;
                                break;
                            }
                            ++j;
                        }
                    } else {
                        Hex h = this.game.getHex(c.activeCapital());
                        int a = 0;
                        while (a < g.getHexes().length) {
                            if (g.getHex(a).getPResource() instanceof Capital && g.getHex(a).getHighlighted() && !u.afraidOfHex(g.getHexIndex(h)) && g.getHex(a).getContinent() == g.getHex(c.activeCapital()).getContinent()) {
                                c.deployUnit(0, this.game.getHexIndex(g.getHex(a)));
                                u.setHasMoved(true);
                                deployed = true;
                                break;
                            }
                            ++a;
                        }
                        if (!deployed) {
                            a = 0;
                            while (a < g.getHexes().length) {
                                if (g.getHex(a).getPResource() instanceof City && g.getHex(a).getHighlighted() && !u.afraidOfHex(g.getHexIndex(h)) && g.getHex(a).getContinent() == g.getHex(c.activeCapital()).getContinent()) {
                                    c.deployUnit(0, this.game.getHexIndex(g.getHex(a)));
                                    u.setHasMoved(true);
                                    deployed = true;
                                    break;
                                }
                                ++a;
                            }
                        }
                        if (!deployed) {
                            a = 0;
                            while (a < g.getHexes().length) {
                                if (g.getHex(a).getHighlighted() && !u.afraidOfHex(a) && g.shortestPath(a, c.activeCapital()) <= 1) {
                                    c.deployUnit(0, this.game.getHexIndex(g.getHex(a)));
                                    u.setHasMoved(true);
                                    deployed = true;
                                    break;
                                }
                                ++a;
                            }
                        }
                        if (!deployed) {
                            Vector<Integer> candidates = new Vector<Integer>(5, 1);
                            int shortestDist = 999999;
                            int a2 = 0;
                            while (a2 < g.getHexes().length) {
                                if (g.getHex(a2).getHighlighted() && !u.afraidOfHex(a2) && g.getHex(a2).getContinent() == g.getHex(c.activeCapital()).getContinent()) {
                                    int dist = this.game.shortestPath(a2, this.game.centerOfMap());
                                    if (c.getStrategy().getPrimaryTarget() != -1) {
                                        dist = this.game.shortestPath(a2, c.getStrategy().getPrimaryTarget());
                                    }
                                    if (dist <= shortestDist) {
                                        candidates.removeAllElements();
                                        candidates.add(new Integer(a2));
                                        shortestDist = dist;
                                    } else if (dist == shortestDist) {
                                        candidates.add(new Integer(a2));
                                    }
                                }
                                ++a2;
                            }
                            if (candidates.size() > 0) {
                                int rnd = XRandAndCalc.rand(candidates.size()) - 1;
                                int index = (Integer)candidates.get(rnd);
                                c.deployUnit(0, index);
                                u.setHasMoved(true);
                                deployed = true;
                            }
                        }
                    }
                    this.game.resetMapDependancy();
                }
            }
            ++i;
        }
        this.game.getWarWindow().oneSlowFrame();
        this.game.optionButtonProcedure();
    }

    private void dow() {
        Game g = this.game;
        while (this.game.getBusy()) {
            AI.delay(500L);
        }
        int aiSide = this.game.whosTurn();
        int i = 0;
        while (i < g.country.length) {
            int score = 0;
            Country targetCountry = g.getCountry(i);
            score = 0;
            score -= Global.DOW_DECREASE * (g.getCalendar().get(1) - 1939);
            if (targetCountry.getAtWar()) {
                score -= 999999;
            } else {
                int monthsBeforeEntry = this.game.monthsBeforeWarEntry(targetCountry);
                if (monthsBeforeEntry < 10 && monthsBeforeEntry > 0) {
                    score += Global.AT_WAR * (10 - monthsBeforeEntry) / 10;
                }
            }
            score += Global.MILITARY_INFLUENCE_FACTOR * g.militaryInfluenceOverHex(aiSide, targetCountry.activeCapital()) / 100;
            if (this.aiSide() == this.controlledBySide(targetCountry.getCountryIndex())) {
                score -= 999999;
            }
            score += Global.AGGRESSION_IMPORTANCE * g.getStrategicAggression(g.opponentSide()) / 100;
            if ((score += XRandAndCalc.rand(Global.MAX_DOW_RANDOM)) > Global.DOW_THRESHOLD) {
                g.dowCountry(aiSide, i, false, true, true, false);
            }
            ++i;
        }
        this.game.optionButtonProcedure();
    }

    private void updateChasePoints() {
        int i = 0;
        while (i < this.readyUnits.size()) {
            Unit u = this.readyUnits.get(i);
            u.setChasePoint(null);
            ++i;
        }
        this.updateConvoyChasePoints();
        this.updateUnitChasePoints();
    }

    private void updateConvoyChasePoints() {
        while (this.game.getBusy()) {
            AI.delay(500L);
        }
        Hex subChase = this.game.decideConvoyTargetForSubs(this.aiSide());
        int i = 0;
        while (i < this.readyUnits.size()) {
            Unit u = this.readyUnits.get(i);
            if (u instanceof NavalUnit) {
                if ((double)u.getStrength() > 0.6 * (double)u.maxStrength() && !(u instanceof Transport) && !(u instanceof Convoy)) {
                    if (u instanceof Sub) {
                        if (subChase != null) {
                            u.setChasePoint(subChase);
                        }
                    } else {
                        u.setChasePoint(this.game.decideConvoyTargetForEscort(this.aiSide(), u));
                    }
                }
                this.game.deHighlightdeTargetAll();
            }
            ++i;
        }
        this.game.optionButtonProcedure();
    }

    private void updateWayPoints() {
        while (this.game.getBusy()) {
            AI.delay(500L);
        }
        Game game = this.game;
        int i = 0;
        while (i < this.readyUnits.size()) {
            Unit u = this.readyUnits.get(i);
            u.updateLeftFlank();
            Hex dest = u.getDestinationHex();
            int destIndex = this.game.getHexIndex(dest);
            int onHexIndex = game.getHexIndex(u.getOnHex());
            if (dest != null && dest.getCoreOwningCountry() == 5 && (u.getWayPoint() == null || game.shortestPath(onHexIndex, destIndex) < game.shortestPath(game.getHexIndex(u.getWayPoint()), destIndex)) && u.isLandUnit() && !Game.isAirUnit(u) && this.game.owningCountry(destIndex).atWarWith(u.getCountry()) && dest.getPResource() instanceof Capital) {
                if (game.shortestPath(onHexIndex, destIndex) < game.shortestPath(game.getHexIndex(u.getWayPoint()), destIndex)) {
                    u.setWayPoint(null);
                }
                Point p1 = new Point(game.getColumn(onHexIndex), game.getRow(onHexIndex));
                Point p2 = new Point(game.getColumn(destIndex) - p1.x, game.getRow(destIndex) - p1.y);
                int minAngle = u.getLeftFlank() * 5;
                int shortestDist = 999999;
                int bestHex = -1;
                int v = 0;
                while (v < game.getHexes().length) {
                    Hex tmp = game.getHex(v);
                    if (tmp.getPResource() instanceof City && tmp.getOwningCountry() == 5) {
                        Point p3 = new Point(game.getColumn(v) - p1.x, game.getRow(v) - p1.y);
                        if (p3.y != 0 && p2.y != 0) {
                            int dist;
                            double angle = Game.angle(p3, p2);
                            if ((u.getLeftFlank() > 0 && angle > (double)minAngle || u.getLeftFlank() <= 0 && angle <= (double)minAngle) && (dist = game.shortestPath(onHexIndex, v)) <= shortestDist) {
                                shortestDist = dist;
                                bestHex = v;
                            }
                        }
                    }
                    ++v;
                }
                if (bestHex != -1) {
                    u.setWayPoint(game.getHex(bestHex));
                }
            }
            ++i;
        }
    }

    private void updateUnitChasePoints() {
        while (this.game.getBusy()) {
            AI.delay(500L);
        }
        int i = 0;
        while (i < this.readyUnits.size()) {
            Unit u = this.readyUnits.get(i);
            if (!(u instanceof Convoy) && !(u instanceof Transport) && u.getOnHex() != null) {
                int startHex = this.game.getHexIndex(u.getOnHex());
                int destinationHex = this.game.getHexIndex(u.getDestinationHex());
                int bestDist = 999999;
                int bestHex = -1;
                int j = 0;
                while (j < this.game.getHexes().length) {
                    int shortest;
                    Hex h = this.game.getHex(j);
                    Unit enemy = h.getUnit();
                    if (u.getStrength() > 6 && this.game.chaseableEnemyOnHex(j, u) && this.game.canSeeUnit(enemy, this.aiSide()) && (shortest = this.game.shortestPath(startHex, j)) <= u.getRealMovement()) {
                        double score = 4.0 * u.getAggressiveness() / (4.0 * this.game.militaryAdvantageRatioOverHex(this.game.oppositeSide(u.getSide()), j));
                        if (u.getSupply() <= Global.HALF_SUPPLY) {
                            score += 0.5;
                        }
                        if (score > 1.0) {
                            if (u.getDestinationHex() != null) {
                                int shortest2 = this.game.shortestPath(j, destinationHex);
                                if (shortest2 < bestDist) {
                                    bestHex = j;
                                    bestDist = shortest2;
                                }
                            } else if (shortest < bestDist) {
                                bestHex = j;
                                bestDist = shortest;
                            }
                        }
                    }
                    ++j;
                }
                if (bestHex != -1) {
                    this.game.highlightAroundUnit(startHex, u.getRealMovement(), false);
                    int k = 0;
                    while (k < this.game.getHexes().length) {
                        if (this.game.getHex(k).getHighlighted() && this.game.shortestPath(k, bestHex) <= 1) {
                            OddsAndPenalties odds = this.game.expectedOdds(u.getOnHex(), this.game.getHex(bestHex));
                            if (u.getAggressiveness() * odds.getAttackerBattleOdds() >= odds.getDefenderBattleOdds() && odds.getAttackerBattleOdds() > 0.0) {
                                u.setChasePoint(this.game.getHex(bestHex));
                            }
                        }
                        ++k;
                    }
                    this.game.deHighlightdeTargetAll();
                }
            }
            this.game.deHighlightdeTargetAll();
            ++i;
        }
        this.game.optionButtonProcedure();
    }

    private void updateUnitAggression() {
        while (this.game.getBusy()) {
            AI.delay(500L);
        }
        int i = 0;
        while (i < this.game.getCountries().length) {
            Country c = this.game.getCountry(i);
            if (c.getAtWar() && c.isMajorCountry() && c.getSide() == this.aiSide()) {
                this.game.getCountry(i).updateUnitAggressions();
            }
            ++i;
        }
        this.game.optionButtonProcedure();
    }

    private void transportUnits() {
        while (this.game.getBusy()) {
            AI.delay(500L);
        }
        int i = 0;
        while (i < this.readyUnits.size()) {
            Unit u = this.readyUnits.get(i);
            if (u.getDestinationHex() != null && u instanceof GroundUnit && this.game.militaryAdvantageRatioOverHex(u.getSide(), this.game.getHexIndex(u.getDestinationHex())) > 0.4) {
                int closest;
                int destinationHex;
                int startHex = this.game.getHexIndex(u.getOnHex());
                int dist = this.game.shortestPath(startHex, destinationHex = this.game.getHexIndex(u.getDestinationHex()));
                if (dist > 2 && !this.game.landReachableDestination(startHex, startHex, destinationHex, (int)(10.0 + 0.3 * (double)dist)) && (closest = this.game.closestFriendlyActiveSeaPort(startHex, u)) != -1) {
                    u.setWayPoint(this.game.getHex(closest));
                }
                if (u.getWayPoint() != null && u.getWayPoint().hasSeaPort()) {
                    int moveToHex;
                    Unit blocker;
                    if (this.game.shortestPath(this.game.getHexIndex(u.getOnHex()), this.game.getHexIndex(u.getWayPoint())) <= 1 && !u.canTransport() && (blocker = u.getWayPoint().getUnit()) != null && blocker.getStrength() == blocker.maxStrength() && u.getSide() == blocker.getSide() && this.readyUnits.contains(blocker) && (moveToHex = this.game.evacuateHex(3, blocker)) != -1) {
                        this.moveAndBlitz(blocker, moveToHex);
                        this.readyUnits.remove(blocker);
                    }
                    if (u.canTransport() && u.getCountry().getPP() >= (double)Global.TRANSPORT_COST) {
                        u.setWayPoint(null);
                        Transport transport = u.getCountry().transport(u, this.game.getHex(this.game.transportHex(u)), false);
                        this.readyUnits.remove(u);
                        this.readyUnits.add(transport);
                    }
                }
                this.game.deHighlightdeTargetAll();
            }
            ++i;
        }
        this.game.optionButtonProcedure();
    }

    private void unloadUnits() {
        while (this.game.getBusy()) {
            AI.delay(500L);
        }
        int i = 0;
        while (i < this.readyUnits.size()) {
            Unit u = this.readyUnits.get(i);
            if (u.getDestinationHex() != null && u instanceof Transport) {
                this.game.highlightUnloadHexes(u.getOnHex());
                int j = 0;
                while (j < this.game.hexLength()) {
                    Hex h = this.game.getHex(j);
                    if (h.getHighlighted() && h.getContinent() == u.getDestinationHex().getContinent() && !u.afraidOfHex(j) && (this.game.militaryAdvantageRatioOverHex(u.getSide(), j) > 0.3 || h.getCoreOwningCountry() == u.getCountryIndex())) {
                        this.moveAndBlitz(u, j);
                        this.readyUnits.remove(i);
                        --i;
                    }
                    ++j;
                }
                this.game.deHighlightdeTargetAll();
            }
            ++i;
        }
        this.game.optionButtonProcedure();
    }

    public void updateDestinations() {
        this.capitalDefence();
        this.offensiveDestinations();
        this.offensiveDistribution();
        this.destinationSwapping();
    }

    public void updatePurchaseResearchPriorities() {
        while (this.game.getBusy()) {
            AI.delay(500L);
        }
        this.game.optionButtonProcedure();
        int i = 0;
        while (i < this.game.getCountries().length) {
            Country c = this.game.getCountry(i);
            if (c.getSide() != this.game.playerSide()) {
                Strategy strat = c.getStrategy();
                double unitsPerLab = Math.max(3.0, 10.0 - 0.1 * (double)c.numUnits());
                double landShare = 100.0;
                double armourShare = 3.0;
                double motorisedShare = 5.0;
                double airShare = 2.0;
                double bomberShare = 25.0;
                double subShare = 0.0;
                if (!c.isMainland()) {
                    unitsPerLab -= 3.0;
                }
                if (!c.getAtWar()) {
                    unitsPerLab -= 1.0;
                }
                unitsPerLab = Math.max(3.0, unitsPerLab);
                if (!c.isMainland() || c.isRaidingNation()) {
                    landShare -= 6.0;
                }
                if (c.isRaidingNation()) {
                    switch (this.game.yearsPassed(this.game.getCalendar())) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            landShare -= 7.0;
                            break;
                        }
                        case 2: {
                            landShare -= 5.0;
                            break;
                        }
                        case 3: {
                            landShare += 0.0;
                            break;
                        }
                        case 4: {
                            landShare += 2.0;
                            break;
                        }
                        case 5: {
                            landShare += 4.0;
                        }
                    }
                }
                if (c.isConvoyNation()) {
                    switch (this.game.yearsPassed(this.game.getCalendar())) {
                        case 0: {
                            landShare -= 10.0;
                            break;
                        }
                        case 1: {
                            landShare -= 35.0;
                            break;
                        }
                        case 2: {
                            landShare -= 40.0;
                            break;
                        }
                        case 3: {
                            landShare -= 15.0;
                            break;
                        }
                        case 4: {
                            landShare -= 5.0;
                            break;
                        }
                        case 5: {
                            landShare -= 1.0;
                        }
                    }
                }
                if (!c.isMainland()) {
                    airShare += 12.0;
                }
                if (c.isRaidingNation()) {
                    subShare += 75.0;
                }
                armourShare += 0.1 * (double)c.getStrategicAggression();
                motorisedShare += 0.11 * (double)c.getStrategicAggression();
                airShare += 0.07 * (double)c.getStrategicAggression();
                bomberShare += 0.2 * (double)c.getStrategicAggression();
                if (unitsPerLab < (double)strat.getUnitsPerLab()) {
                    strat.setUnitsPerLab(strat.getUnitsPerLab() - 1);
                } else {
                    strat.setUnitsPerLab((int)unitsPerLab);
                }
                strat.setLandShare((int)landShare);
                strat.setAirShare((int)airShare);
                strat.setMotorisedShare((int)motorisedShare);
                strat.setArmourShare((int)armourShare);
                strat.setBomberShare((int)bomberShare);
                strat.setSubShare((int)subShare);
            }
            ++i;
        }
    }

    public void capitalDefence() {
        while (this.game.getBusy()) {
            AI.delay(500L);
        }
        int i = 0;
        while (i < this.game.getCountries().length) {
            Game g = this.game;
            Country c = this.game.getCountry(i);
            if (c.getAtWar() && c.getSide() != this.game.playerSide()) {
                Unit u;
                int unitIndex;
                int j;
                if (c.activeCapital() != -1 && g.militaryAdvantageRatioOverHex(c.getSide(), c.activeCapital()) < (double)Global.CAPITAL_DEFENCE / 100.0) {
                    j = 0;
                    while (j < Global.DEFENCE_REACTION) {
                        unitIndex = c.nearestNonFrontGroundUnit(c.activeCapital(), 1, 70);
                        if (unitIndex != -1) {
                            u = c.getUnits().get(unitIndex);
                            u.setDestinationHex(g.getHex(c.activeCapital()));
                        }
                        ++j;
                    }
                }
                if (c.activeCapital() != -1 && g.militaryAdvantageRatioOverHex(c.getSide(), c.activeCapital()) > (double)Global.CAPITAL_DEFENCE / 80.0) {
                    j = 0;
                    while (j < Global.DEFENCE_REACTION) {
                        unitIndex = c.nearestNonFrontGroundUnit(c.activeCapital(), 2, 999999);
                        if (unitIndex != -1) {
                            u = c.getUnits().get(unitIndex);
                            u.setDestinationHex(null);
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        this.game.optionButtonProcedure();
    }

    public void offensiveDestinations() {
        while (this.game.getBusy()) {
            AI.delay(500L);
        }
        int i = 0;
        while (i < this.game.getCountries().length) {
            Country c = this.game.getCountry(i);
            if (c.getAtWar() && c.getSide() != this.game.playerSide()) {
                int j = 0;
                while (j < c.units.size()) {
                    Unit u = c.units.get(j);
                    if (u.getOnHex() != null) {
                        if (u instanceof Transport && u.getDestinationHex() == null) {
                            c.getStrategy().updateLandDestinations(u);
                        } else if (!(u instanceof Transport) && !(u instanceof NavalUnit)) {
                            c.getStrategy().updateLandDestinations(u);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.game.optionButtonProcedure();
    }

    public void protectDestinations() {
        while (this.game.getBusy()) {
            AI.delay(500L);
        }
        double[] advantageRatio = new double[this.game.getHexes().length];
        int m = 0;
        while (m < this.game.getHexes().length) {
            advantageRatio[m] = 999999.0;
            Hex tmp = this.game.getHex(m);
            if (this.game.getCountry(tmp.getOwningCountry()).getSide() == this.aiSide() && tmp.getPResource() != null && tmp instanceof LandHex && this.game.getCountry(tmp.getOwningCountry()).getAtWar() && (tmp.getUnit() == null || !(tmp.getPResource() instanceof Fortress))) {
                advantageRatio[m] = this.game.militaryAdvantageRatioOverHex(this.aiSide(), m);
                if (tmp.getUnit() == null) {
                    advantageRatio[m] = advantageRatio[m] / 3.0;
                }
                if (tmp.getPResource() instanceof Capital) {
                    advantageRatio[m] = advantageRatio[m] * 0.7;
                }
            }
            ++m;
        }
        int i = 0;
        while (i < this.game.getCountries().length) {
            Country c = this.game.getCountry(i);
            if (c.majorAlive() && c.getAtWar() && c.getSide() != this.game.playerSide()) {
                int b = 0;
                while (b < c.units.size()) {
                    Unit u = c.units.get(b);
                    if (u.getOnHex() != null && !u.onDefenceMission() && u instanceof GroundUnit && !u.isVehicle() && u.getDestinationHex() != null && this.game.shortestPath(this.game.getHexIndex(u.getOnHex()), this.game.getHexIndex(u.getDestinationHex())) <= 1 && c.unitsOnTarget(this.game.getHexIndex(u.getDestinationHex())) > 0 && !(u.getDestinationHex().getPResource() instanceof Capital)) {
                        u.setDestinationHex(null);
                    }
                    ++b;
                }
                int h = 0;
                while (h < this.game.getHexes().length) {
                    Hex tmp = this.game.getHex(h);
                    if (tmp.getOwningCountry() == c.getCountryIndex() && advantageRatio[h] > 0.1 && advantageRatio[h] < 1.2 - 0.01 * (double)this.game.shortestPath(c.getPrimaryCapital(), h) && (this.game.militaryInfluenceOverHex(this.game.oppositeSide(this.aiSide()), h) > 120 || this.game.nearestEnemyGroundUnitDistance(h, this.aiSide(), true) <= 8)) {
                        int b2 = 0;
                        while (b2 < c.units.size()) {
                            int unit;
                            Unit u = c.units.get(b2);
                            if (u.getOnHex() != null && !u.onDefenceMission() && u instanceof GroundUnit && c.unitsOnTarget(h) == 0 && this.game.shortestPath(h, this.game.getHexIndex(u.getOnHex())) > 1 && (unit = u.getCountry().nearestNonFrontGroundUnit(h, 10)) != -1) {
                                u.getCountry().getUnits().get(u.getCountry().nearestNonFrontGroundUnit(h, 2)).setDestinationHex(this.game.getHex(h));
                            }
                            ++b2;
                        }
                    }
                    ++h;
                }
            }
            ++i;
        }
        this.game.optionButtonProcedure();
    }

    public void offensiveDistribution() {
        while (this.game.getBusy()) {
            AI.delay(500L);
        }
        int i = 0;
        while (i < this.game.getCountries().length) {
            Country c = this.game.getCountry(i);
            if (c.getAtWar() && c.getSide() != this.game.playerSide()) {
                Unit tmp;
                int k;
                int primaryTarget = c.getStrategy().getPrimaryTarget();
                int secondaryTarget = c.getStrategy().getSecondaryTarget();
                int tertiaryTarget = c.getStrategy().getTertiaryTarget();
                int secondaries = c.unitsOnTarget(secondaryTarget);
                int tertiaries = c.unitsOnTarget(tertiaryTarget);
                int numAdjustments = 0;
                int diff1 = (secondaries - 5) / 2;
                if (tertiaries > (diff1 = Math.max(0, diff1))) {
                    numAdjustments = 1;
                    int j = 0;
                    while (j < numAdjustments) {
                        Unit tmp2;
                        int unitIndex = c.unitFromTarget_A_NearestTarget_B(tertiaryTarget, secondaryTarget, 999999);
                        if (unitIndex != -1 && (tmp2 = c.getUnits().get(unitIndex)) != null) {
                            tmp2.setDestinationHex(this.game.getHex(secondaryTarget));
                        }
                        ++j;
                    }
                }
                secondaries = c.unitsOnTarget(secondaryTarget);
                int primaries = c.unitsOnTarget(primaryTarget);
                diff1 = (primaries - 13) / 2;
                if (secondaries > (diff1 = Math.max(0, diff1))) {
                    numAdjustments = 1;
                    k = 0;
                    while (k < numAdjustments) {
                        int unitIndex = c.unitFromTarget_A_NearestTarget_B(secondaryTarget, primaryTarget, 999999);
                        if (unitIndex != -1 && (tmp = c.getUnits().get(unitIndex)) != null) {
                            tmp.setDestinationHex(this.game.getHex(primaryTarget));
                        }
                        ++k;
                    }
                }
                if (primaryTarget != -1 && secondaryTarget != -1) {
                    k = 0;
                    while (k < Global.DEFENCE_REACTION) {
                        int unitIndex;
                        if (((c.unitsOnTarget(primaryTarget) - 20) / Math.max(1, c.unitsOnTarget(secondaryTarget)) > 2 || c.unitsOnTarget(primaryTarget) > 1 && c.unitsOnTarget(secondaryTarget) == 0) && (unitIndex = c.unitFromTarget_A_NearestTarget_B(primaryTarget, secondaryTarget, 999999)) != -1 && (tmp = c.getUnits().get(unitIndex)) != null) {
                            tmp.setDestinationHex(this.game.getHex(secondaryTarget));
                        }
                        ++k;
                    }
                }
                if (secondaryTarget != -1 && tertiaryTarget != -1) {
                    k = 0;
                    while (k < Global.DEFENCE_REACTION) {
                        int unitIndex;
                        if (((c.unitsOnTarget(secondaryTarget) - 3) / Math.max(1, c.unitsOnTarget(tertiaryTarget)) > 2 || c.unitsOnTarget(secondaryTarget) > 1 && c.unitsOnTarget(tertiaryTarget) == 0) && (unitIndex = c.unitFromTarget_A_NearestTarget_B(secondaryTarget, tertiaryTarget, 999999)) != -1 && (tmp = c.getUnits().get(unitIndex)) != null) {
                            tmp.setDestinationHex(this.game.getHex(tertiaryTarget));
                        }
                        ++k;
                    }
                }
            }
            ++i;
        }
        this.game.optionButtonProcedure();
    }

    public void destinationSwapping() {
        while (this.game.getBusy()) {
            AI.delay(500L);
        }
        Game g = this.game;
        int i = 0;
        while (i < this.game.getCountries().length) {
            Country c = this.game.getCountry(i);
            if (c.getAtWar() && c.getSide() != this.game.playerSide()) {
                Vector<Unit> units = c.getUnits();
                int j = 0;
                while (j < 5) {
                    int k = 0;
                    while (k < units.size()) {
                        int l = 0;
                        while (l < units.size()) {
                            Unit unitA = units.get(k);
                            Unit unitB = units.get(l);
                            int destA = g.getHexIndex(unitA.getDestinationHex());
                            int destB = g.getHexIndex(unitB.getDestinationHex());
                            int onHexA = g.getHexIndex(unitA.getOnHex());
                            int onHexB = g.getHexIndex(unitB.getOnHex());
                            if (unitA.getPrice() == unitB.getPrice() && unitA.getOnHex() != null && unitB.getOnHex() != null && destA != -1 && destB != -1 && destA != destB && !unitA.onDefenceMission() && !unitB.onDefenceMission() && g.shortestPath(onHexA, destA) + g.shortestPath(onHexB, destB) > g.shortestPath(onHexA, destB) + g.shortestPath(onHexB, destA)) {
                                unitA.setDestinationHex(g.getHex(destB));
                                unitB.setDestinationHex(g.getHex(destA));
                            }
                            ++l;
                        }
                        ++k;
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.game.optionButtonProcedure();
    }

    /*
     * Unable to fully structure code
     */
    private void navalRetreats() {
        i = 0;
        while (i < this.readyUnits.size()) {
            if (this.active) ** GOTO lbl6
            break;
lbl-1000:
            // 1 sources

            {
                AI.delay(500L);
lbl6:
                // 2 sources

                ** while (this.game.getBusy())
            }
lbl7:
            // 1 sources

            u = this.readyUnits.get(i);
            if (!(u instanceof Transport) && u instanceof NavalUnit && ((double)u.getStrength() <= 0.6 * (double)u.maxStrength() || u.nothingToDo() || this.game.insideEnemyPort(u))) {
                unitHex = this.game.getHexIndex(u.getOnHex());
                if (!this.active) break;
                moveToHex = this.game.closestFriendlyActiveSeaPort(unitHex, u);
                if (moveToHex != -1) {
                    u.setDestinationHex(this.game.getHex(moveToHex));
                }
            }
            this.game.optionButtonProcedure();
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void airRetreats() {
        this.game.deHighlightdeTargetAll();
        i = 0;
        while (i < this.readyUnits.size()) {
            if (this.active) ** GOTO lbl7
            break;
lbl-1000:
            // 1 sources

            {
                AI.delay(500L);
lbl7:
                // 2 sources

                ** while (this.game.getBusy())
            }
lbl8:
            // 1 sources

            u = this.readyUnits.get(i);
            if (u instanceof AirUnit) {
                unitHex = this.game.getHexIndex(u.getOnHex());
                if (!this.active) break;
                if (u.afraidOfHex(unitHex) && this.game.militaryAdvantageRatioOverHex(u.getSide(), unitHex) < 1.4 && (nearestSafe = this.game.nearestSafeReachableEmptyHex(unitHex, u)) != -1) {
                    route = new Vector<Integer>(10, 5);
                    this.game.calcAirUnitRoute(route, unitHex, nearestSafe);
                    this.game.moveUnit(route, true, true, true);
                    this.readyUnits.remove(i);
                    --i;
                }
            }
            this.game.optionButtonProcedure();
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void upgradeUnits() {
        i = 0;
        while (i < this.readyUnits.size()) {
            if (this.active) ** GOTO lbl6
            break;
lbl-1000:
            // 1 sources

            {
                AI.delay(500L);
lbl6:
                // 2 sources

                ** while (this.game.getBusy())
            }
lbl7:
            // 1 sources

            u = this.readyUnits.get(i);
            unitHex = this.game.getHexIndex(u.getOnHex());
            if (!this.active) break;
            if (u.getStrength() > 7 && (double)u.getMorale() > 0.7 * (double)u.maxMorale() && u.canUpgrade() && this.game.enemiesAdjacent(unitHex, u) == 0) {
                u.upgradeUnit(true);
                this.game.warWindow.oneImmediateFrame();
                this.readyUnits.remove(i);
                --i;
            }
            this.game.optionButtonProcedure();
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void moveGroundNavalUnits(boolean adjacentToEnemyOnly) {
        lowOrUnsuppliedGroundUnits = new Vector<Integer>(5, 5);
        j = 0;
        while (j < this.game.getHexes().length) {
            u = this.game.getHex(j).getUnit();
            if (u != null && u.getOnHex() != null && u.isLandUnit() && u.getOnHex().getSupply() <= Global.LOW_SUPPLY && u.getSide() == this.aiSide() && this.game.nearestOceanDist(this.game.getHexIndex(u.getOnHex())) <= 1) {
                lowOrUnsuppliedGroundUnits.add(new Integer(this.game.getHexIndex(u.getOnHex())));
            }
            ++j;
        }
        removeThem = new Vector<Unit>(5, 1);
        i = 0;
        while (i < this.readyUnits.size()) {
            if (this.active) ** GOTO lbl16
            break;
lbl-1000:
            // 1 sources

            {
                AI.delay(500L);
lbl16:
                // 2 sources

                ** while (this.game.getBusy())
            }
lbl17:
            // 1 sources

            u = this.readyUnits.get(i);
            if (u.getHasMoved()) {
                this.readyUnits.remove(i);
                --i;
            } else {
                moveToHex = null;
                unitHex = this.game.getHexIndex(u.getOnHex());
                if (!adjacentToEnemyOnly || this.game.isNearEnemy(unitHex, u)) {
                    if (!u.getHasMoved() && (u instanceof GroundUnit || u instanceof NavalUnit)) {
                        destHex = this.game.getHexIndex(u.getDestinationHex());
                        wayPointHex = this.game.getHexIndex(u.getWayPoint());
                        if (!this.active) break;
                        if (u instanceof NavalUnit) {
                            chasePoint = this.game.shippedSupplyHex(this.game.getHexIndex(u.getOnHex()), lowOrUnsuppliedGroundUnits, 1);
                            if (chasePoint != -1) {
                                u.setChasePoint(this.game.getHex(chasePoint));
                            }
                            if (chasePoint == -1 && (chasePoint = this.game.shippedSupplyHex(this.game.getHexIndex(u.getOnHex()), lowOrUnsuppliedGroundUnits, 30)) != -1) {
                                u.setChasePoint(this.game.getHex(chasePoint));
                            }
                            if (u.getDestinationHex() != null && u.getDestinationHex().hasSeaPort() && u.getStrength() < u.maxStrength() && this.game.shortestPath(this.game.getHexIndex(u.getOnHex()), this.game.getHexIndex(u.getDestinationHex())) <= 2 && (blocker = u.getDestinationHex().getUnit()) != null && blocker.getStrength() == blocker.maxStrength() && u.getSide() == blocker.getSide() && this.readyUnits.contains(blocker) && (moveTo = this.game.evacuateHex(3, blocker)) != -1) {
                                this.moveAndBlitz(blocker, moveTo);
                                removeThem.add(blocker);
                            }
                        } else if (u instanceof GroundUnit && u.getWayPoint() != null && u.getWayPoint().hasSeaPort() && this.game.shortestPath(unitHex, wayPointHex) <= 2 && this.game.getEmptyAdjacentLandHex(wayPointHex) == null && (friend = this.game.readyFriendAdjacent(wayPointHex, u)) != -1 && (moveTo = this.game.evacuateHex(3, friendlyUnit = this.game.getHex(friend).getUnit())) != -1) {
                            this.moveAndBlitz(friendlyUnit, moveTo);
                            removeThem.add(friendlyUnit);
                        }
                        if (u.getWayPoint() == null && this.game.needGibraltarWaypoint(u)) {
                            loopHex = this.game.bestLoopHexNearby(unitHex, this.game.nearestOceanIndex(destHex));
                            if (loopHex != -1 && this.game.shortestPath(unitHex, this.game.gibraltarPort()) > 30) {
                                u.setWayPoint(this.game.getHex(loopHex));
                            } else {
                                u.setWayPoint(this.game.getHex(this.game.gibraltarPort()));
                            }
                        }
                        if (u.getChasePoint() != null) {
                            moveToHex = this.game.decideWhereToMove(unitHex, this.game.getHexIndex(u.getChasePoint()));
                        } else if (u.getWayPoint() != null) {
                            moveToHex = this.game.decideWhereToMove(unitHex, this.game.getHexIndex(u.getWayPoint()));
                        } else if (u.getDestinationHex() != null) {
                            moveToHex = this.game.decideWhereToMove(unitHex, this.game.getHexIndex(u.getDestinationHex()));
                        }
                    }
                    if (u instanceof GroundUnit && !u.onDefenceMission()) {
                        captureHex = this.game.decideCaptureMove(unitHex);
                        if (captureHex != null) {
                            moveToHex = captureHex;
                        }
                        if (moveToHex == null) {
                            moveToHex = this.game.decideFrontLiningMove(unitHex);
                        }
                        if (moveToHex == null && u.getDestinationHex() != null && !this.game.isInFrontLine(unitHex, u) && this.game.nearestLostHex(unitHex, u) != -1) {
                            moveToHex = this.game.decideWhereToMove(unitHex, this.game.nearestLostHex(unitHex, u));
                        }
                    }
                    if (!(moveToHex == null || u.isLandUnit() && (double)u.getStrength() < 0.7 * (double)u.maxStrength())) {
                        this.moveAndBlitz(u, this.game.getHexIndex(moveToHex));
                        this.readyUnits.remove(i);
                        --i;
                    }
                    this.game.deHighlightdeTargetAll();
                    this.game.optionButtonProcedure();
                }
            }
            ++i;
        }
        while (removeThem.size() > 0) {
            this.readyUnits.remove(removeThem.remove(0));
        }
    }

    private void moveAndBlitz(Unit u, int moveToHex) {
        boolean exploit;
        Hex attackHex;
        int unitHex = this.game.getHexIndex(u.getOnHex());
        Vector<Integer> route = new Vector<Integer>(10, 5);
        this.game.calcGroundUnitRoute2(route, unitHex, moveToHex, u.getMaxMovement(), u.getCountryIndex());
        boolean surprised = this.game.moveUnit(route, true, false, true);
        if (u.getOnHex() == u.getWayPoint()) {
            u.setWayPoint(null);
        }
        Unit realUnit = this.game.getHex(moveToHex).getUnit();
        if (!surprised && (double)realUnit.getStrength() >= 0.7 * (double)realUnit.maxStrength() && realUnit.getOnHex() != null && (attackHex = this.game.decideWhereToAttack(this.game.getHexIndex(realUnit.getOnHex()))) != null && (exploit = this.game.resolveBattle(realUnit.getOnHex(), attackHex, true, false)) && attackHex.getPResource() != null) {
            Vector<Integer> v = new Vector<Integer>();
            v.add(new Integer(moveToHex));
            v.add(new Integer(this.game.getHexIndex(attackHex)));
            this.game.moveUnit(v, false, false, true);
        }
    }

    private void staticAttacks() {
        boolean attacked = true;
        while (this.game.getBusy()) {
            AI.delay(500L);
        }
        while (attacked) {
            if (!this.active) break;
            attacked = false;
            int i = 0;
            while (i < this.readyUnits.size()) {
                Unit u = this.readyUnits.get(i);
                if (u.getHasMoved()) {
                    this.readyUnits.remove(i);
                    --i;
                } else if ((u instanceof GroundUnit || u instanceof NavalUnit) && u.getStrength() >= 7) {
                    if (!this.active) break;
                    int unitHex = this.game.getHexIndex(u.getOnHex());
                    Hex attackHex = this.game.decideWhereToAttack(unitHex);
                    if (attackHex != null) {
                        boolean exploit = this.game.resolveBattle(u.getOnHex(), attackHex, true, false);
                        if (exploit && attackHex.getPResource() != null) {
                            Vector<Integer> v = new Vector<Integer>();
                            v.add(new Integer(unitHex));
                            v.add(new Integer(this.game.getHexIndex(attackHex)));
                            this.game.moveUnit(v, false, false, true);
                        }
                        this.readyUnits.remove(i);
                        --i;
                        attacked = true;
                        break;
                    }
                }
                ++i;
            }
            this.game.optionButtonProcedure();
        }
    }

    private void airAttacks() {
        boolean attacked = true;
        while (this.game.getBusy()) {
            AI.delay(500L);
        }
        while (attacked) {
            if (!this.active) break;
            attacked = false;
            int i = 0;
            while (i < this.readyUnits.size()) {
                Unit u = this.readyUnits.get(i);
                if (u.getHasMoved()) {
                    this.readyUnits.remove(i);
                    --i;
                } else if ((double)u.getStrength() >= 0.7 * (double)u.maxStrength()) {
                    Hex attackHex = this.game.decideWhereToAirAttack(u);
                    if (attackHex != null) {
                        this.game.resolveBattle(u.getOnHex(), attackHex, true, false);
                        this.readyUnits.remove(i);
                        --i;
                        attacked = true;
                        break;
                    }
                    this.game.deHighlightdeTargetAll();
                }
                ++i;
            }
            this.game.optionButtonProcedure();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void airMoves() {
        this.game.deHighlightdeTargetAll();
        i = 0;
        ** GOTO lbl23
        {
            AI.delay(500L);
            do {
                if (this.game.getBusy()) continue block0;
                u = this.readyUnits.get(i);
                if (u.getDestinationHex() != null && !u.getHasMoved() && (double)u.getStrength() >= 0.7 * (double)u.maxStrength() && u instanceof AirUnit) {
                    unitHex = this.game.getHexIndex(u.getOnHex());
                    if (!this.active) break block0;
                    moveToHex = this.game.decideWhereToMove(unitHex, this.game.getHexIndex(u.getDestinationHex()));
                    if (moveToHex != null) {
                        route = new Vector<Integer>(10, 5);
                        this.game.calcAirUnitRoute(route, unitHex, this.game.getHexIndex(moveToHex));
                        this.game.moveUnit(route, true, true, true);
                        this.readyUnits.remove(i);
                        --i;
                    }
                    this.game.deHighlightdeTargetAll();
                }
                this.game.optionButtonProcedure();
                ++i;
lbl23:
                // 2 sources

            } while (i < this.readyUnits.size());
        }
    }

    private void railMoves() {
        while (this.game.getBusy()) {
            AI.delay(500L);
        }
        int max1 = this.game.getOperatesLeft(100);
        int max2 = this.game.getOperatesLeft(200);
        int max3 = this.game.getOperatesLeft(5);
        if (this.aiSide() == 100) {
            int a = 0;
            while (a < max1) {
                this.railMoves2(100, false);
                ++a;
            }
        } else {
            int b = 0;
            while (b < max2) {
                this.railMoves2(200, false);
                ++b;
            }
            int c = 0;
            while (c < max3) {
                this.railMoves2(5, true);
                ++c;
            }
        }
        this.game.optionButtonProcedure();
    }

    private void railMoves2(int side, boolean USSR) {
        Game g = this.game;
        Hex[] hexes = this.game.getHexes();
        Node[] unitScores = new Node[this.readyUnits.size()];
        int i = 0;
        while (i < this.readyUnits.size()) {
            Unit u = this.readyUnits.get(i);
            if (u.getCountry().getSide() == side && (u.getCountryIndex() == 5 && USSR || u.getCountryIndex() != 5 && !USSR)) {
                Hex onHex = u.getOnHex();
                Hex destHex = u.getDestinationHex();
                if (!(u instanceof NavalUnit) && onHex != null && destHex != null && u.canOperate()) {
                    int onHexIndex = g.getHexIndex(onHex);
                    int destHexIndex = g.getHexIndex(destHex);
                    int bestScore = 0;
                    int bestHex = -1;
                    this.game.highlightOperateHexes(u.getOnHex());
                    int j = 0;
                    while (j < hexes.length) {
                        if (hexes[j].getHighlighted() && !u.afraidOfHex(j)) {
                            int hexGain = g.shortestPath(onHexIndex, destHexIndex) - g.shortestPath(j, destHexIndex);
                            int score = (int)(u.getLandInfluence() * (double)(hexGain - u.getRealMovement()));
                            if (score > bestScore) {
                                bestScore = score;
                                bestHex = j;
                            }
                        }
                        ++j;
                    }
                    if (bestHex != -1) {
                        unitScores[i] = new Node(bestHex, bestScore, 0);
                    }
                    this.game.resetMapDependancy();
                }
            }
            ++i;
        }
        int bestScore = 0;
        int bestNode = -1;
        int b = 0;
        while (b < unitScores.length) {
            if (unitScores[b] != null && unitScores[b].getCost() > bestScore) {
                bestNode = b;
                bestScore = unitScores[b].getCost();
            }
            ++b;
        }
        if (bestNode != -1) {
            int sourceHex = g.getHexIndex(this.readyUnits.remove(bestNode).getOnHex());
            this.game.operateUnit(sourceHex, g.getHex(unitScores[bestNode].getHex()), true);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void reinforce() {
        i = 0;
        ** GOTO lbl18
        {
            AI.delay(500L);
            do {
                if (this.game.getBusy()) continue block0;
                u = this.readyUnits.get(i);
                if (u.getStrength() < u.maxStrength()) {
                    if (u.canReinforce()) {
                        u.reinforce(u.maximumAmountThatCanBeReinforced());
                        if (u instanceof NavalUnit) {
                            u.setDestinationHex(null);
                        }
                    }
                    this.readyUnits.remove(i);
                    --i;
                    this.game.getWarWindow().oneSlowFrame();
                }
                ++i;
lbl18:
                // 2 sources

            } while (i < this.readyUnits.size());
        }
        this.game.optionButtonProcedure();
    }

    private int controlledBySide(int country) {
        return this.game.getCountry(country).controlledBySide();
    }

    public void run() {
        while (true) {
            AI.delay(2099999999L);
            if (!this.active) continue;
            this.AIStart();
        }
    }
}

