var level : String;
var images : Texture[];

var nvr = 864.0;
var nhr = 1152.0;
var shouldRot : boolean = true;
var fitToScreen : boolean = true;

var guiTime : float = 0.0;
var guiScale : float = 1.0;
var delay : int = 30;

private var timer : float;
timer = delay;
private var index : int = 0;

function OnGUI() {
	GUI.matrix = Matrix4x4.TRS (Vector3(0, 0, 0), Quaternion.identity, Vector3 (Screen.height / nvr, Screen.height / nvr, 1));
	if(guiTime > -20.0 && shouldRot)
		GUIUtility.RotateAroundPivot(guiTime, Vector2(nhr/2, nvr/2));
	if(guiScale < 2)
		GUIUtility.ScaleAroundPivot(Vector2(guiScale, guiScale), Vector2(nhr/2, nvr/2));
	if(fitToScreen)
		GUI.DrawTexture(Rect(0, 0, nhr, nvr), images[index], ScaleMode.ScaleToFit, true, 0);
	else GUI.DrawTexture(Rect(nhr / 2 - images[index].width / 2, nvr / 2 - images[index].height, images[index].width, images[index].height), images[index], ScaleMode.ScaleToFit, true, 0);
}

function Update(){
	timer -= Time.deltaTime;
	if(timer <=0)
		NextImage();
	if(Input.GetButtonDown("Fire1")){
		NextImage();
	}
	if(Input.GetKey("escape")){
		LoadLevel();
	}
	guiTime -= Time.deltaTime / 4;
	guiScale += (Time.deltaTime / 40);
}

function LoadLevel(){
	Application.LoadLevel(level);
}

function NextImage(){
	timer = delay;
	if(index >= images.length - 1){
		LoadLevel();
	} else {
		index++;
	}
	guiTime = 0;
	guiScale = 0.8;
}