var targets : Transform[];
var pause : float = 2.5;
var speed : float = 5.0;
private var pSpeed : float;
private var pauseTime : float = 0;
private var target : int;
private var playerLocked : boolean = false;
pSpeed = speed;

function Update () {
	if(playerLocked){
		var playerPos : Transform = GameObject.FindWithTag("Player").transform;
		playerPos.position.x = transform.position.x;
		playerPos.position.z = transform.position.z;
	}
	if(targets){
		if(pauseTime <= 0){
			transform.LookAt(targets[target]);
			transform.Translate(Vector3.forward * pSpeed * Time.deltaTime);
			if(Vector3.Distance(transform.position, targets[target].position) < 15){
				pSpeed = 5;
			}
			if(Vector3.Distance(transform.position, targets[target].position) < 1){
				target++;
				pSpeed = speed;
				if(target >= targets.length)
					target = 0;
				pauseTime = pause;
			}
		} else {
			pauseTime -= Time.deltaTime;
		}
	}
	if(Input.GetButton("Jump")){
		playerLocked = false;
	}
}

function OnCollisionEnter(col : Collision){
	if(col.transform.IsChildOf(GameObject.FindWithTag("Player").transform)){
		playerLocked = true;
	}
}

