/*MouseStats.jas manages player health, weapon mode, weapon power, and weapon range.*/

private var weapons = new Array();
weapons.length = 2;
weapons[0] = "Hands";
weapons[1] = "Handgun";

var currentWeapon : String = "Hands";
var health : float = 100;
var grenades : int = 5;
var gunMode : String = "Handgun";
var isChuck : boolean = false;

var drawChuck : float = 0.0;
var chuckBanner : Texture;
var chuckGUI : float = 1.0;

var keys : int = 0;
var cards : int = 0;
var cash : int = 0;

var normalHitPower : float = 10.0;
var hitPower : float = 10.0;

var machineGunDamage : float = 5.0;

function OnGUI(){
	var hudScript =	GameObject.FindWithTag("GameController").GetComponent("HUD");
	GUI.matrix = Matrix4x4.TRS (Vector3(0, 0, 0), Quaternion.identity, Vector3 (Screen.height / hudScript.nativeVerticalResolution, Screen.height / hudScript.nativeVerticalResolution, 1));
	GUIUtility.ScaleAroundPivot(Vector2(chuckGUI, chuckGUI), Vector2(hudScript.nativeHorizontalResolution/2, hudScript.nativeVerticalResolution/2));
	if(drawChuck > 0.0)
		GUI.DrawTexture(Rect(0, hudScript.nativeVerticalResolution / 2 - chuckBanner.height / 1.5, hudScript.nativeHorizontalResolution, hudScript.nativeVerticalResolution), chuckBanner, ScaleMode.ScaleToFit, true, 0);
}

function Update () {
	if(drawChuck > 0.0){
		chuckGUI += Time.deltaTime/20;
	}
	drawChuck -= Time.deltaTime;
	if(isChuck){
		hitPower = normalHitPower * 5;
	} else {
		hitPower = normalHitPower;
	}

	if(Input.GetButtonDown("Weapon")){
		print("MouseStats caught weapon down");
		if(currentWeapon == "Hands"){
			currentWeapon = "Handgun";
		} else if (currentWeapon == "Handgun" && gunMode == "Handgun"){
			gunMode = "Grapple";
		} else if(currentWeapon == "Handgun" && gunMode == "Grapple"){
			if(grenades > 0)
				gunMode = "Grenade";
			else if(cash > 0){
				currentWeapon = "Cash";
				gunMode = "Handgun";
			} else {
				currentWeapon = "Hands";
				gunMode = "Handgun";
			}
		} else if(currentWeapon == "Handgun" && gunMode == "Grenade"){
			if(cash > 0){
				currentWeapon = "Cash";
			} else {
				currentWeapon = "Hands";
				gunMode = "Handgun";	
			}
		} 
	}
	if(gunMode == "Grenade" && grenades <= 0)
		gunMode = "Handgun";
}

function OnTriggerEnter(col : Collider) {
	if(col.gameObject.CompareTag("Powerup")){
		if(!col.gameObject.GetComponent(Powerup).playerCollided){
			var pType : PowerType = col.gameObject.GetComponent("Powerup").theType;
			if(pType == PowerType.Cheese)
				health += col.gameObject.GetComponent("Powerup").value;
			if(pType == PowerType.Chuck){
				chuckGUI = 0.8;
				drawChuck = 4.0;
				isChuck = true;
			}
			if(pType == PowerType.GunPower)
				transform.Find("Gun").GetComponent("Handgun").gunPower += col.gameObject.GetComponent("Powerup").value;
			if(pType == PowerType.Grenades)
				grenades += col.gameObject.GetComponent("Powerup").value;
			if(pType == PowerType.Key)
				keys++;
			if(pType == PowerType.Card)
				cards++;
			if(pType == PowerType.Cash)
				cash++;
		}
	}
}

function TakeDamage(amount : float) {
	health -= amount / (isChuck ? 2 : 1); //reduce damage if we're chuck
}

@script AddComponentMenu("Mouse/Mouse Stats")

