var returnToFPS : boolean = false;

transform.Find("Root/Spine/MidSpine/L_Arm/L_Elbow/L_Hand/L_Finger").tag = "MouseFist";
transform.Find("Root/Spine/MidSpine/R_Arm/R_Elbow/R_Hand/R_Finger").tag = "MouseFist";

SetRagdoll(false);
GetComponent(MouseLook).axes = 1;
returnToFPS = !GameObject.FindWithTag("MainCamera").camera.enabled;

enum ViewMode {Third = 0, First = 1, ThirdFirst = 2}
var mode : ViewMode = ViewMode.Third;

function Update () {
	GetComponent(CapsuleCollider).height = Input.GetButton("Crouch") ? 4.0 : 5.0;
	GetComponent(CapsuleCollider).center.y = Input.GetButton("Crouch") ? -1.2 : -0.3;
	if(GetComponent(MouseStats).health <= 0){
		animation.Stop();
		SetRagdoll(true);
		Destroy(gameObject, 2);
		GameObject.FindWithTag("GameController").GetComponent("LevelController").PlayerDied();
	}
	transform.Find("Sight").gameObject.active = GetComponent(MouseStats).currentWeapon == "Handgun" && !Running();
	if(Input.GetButtonDown("Fire1") && GetComponent("MouseStats").currentWeapon == "Handgun"){
		if(GetComponent("MouseStats").gunMode == "Handgun"){
			transform.Find("Gun").GetComponent("Handgun").Fire();
		} else if(GetComponent("MouseStats").gunMode == "Grapple"){
			transform.Find("Gun").GetComponent("Handgun").FireGrapple();
		} else if(GetComponent(MouseStats).gunMode == "Grenade"){
			transform.Find("Gun").GetComponent("Handgun").FireGrenade();
		}
	}
	
	if(Input.GetButtonDown("Camera")){
		transform.Find("Gun/FPSCam").gameObject.camera.enabled = !transform.Find("Gun/FPSCam").gameObject.camera.enabled;
		returnToFPS = !returnToFPS;
	}
	
	if(Running() || GetComponent("MouseStats").currentWeapon != "Handgun") {
		transform.Find("Gun/FPSCam").gameObject.camera.enabled = false;
		GameObject.FindWithTag("MainCamera").camera.enabled = true;
	} else if(returnToFPS){
		transform.Find("Gun/FPSCam").gameObject.camera.enabled = true;
	}
	
	if(GetComponent(MouseStats).currentWeapon == "Cash"){
		var op = FindClosestWithTag("EnemyPolice");
		if(op){
			if(Vector3.Distance(transform.position, op.transform.position) < 5){
				op.GetComponent(PoliceAI).paid = true;
			}
		}
	}
}

function SetRagdoll(flag : boolean) {
	var bodies = GetComponentsInChildren(Rigidbody);
	for(var currentBody : Rigidbody in bodies){
		currentBody.isKinematic = !flag;
		currentBody.collider.isTrigger = !flag;
	}
	var hits : GameObject[];
	hits = GameObject.FindGameObjectsWithTag("MouseFist");
	for(var currentFist : GameObject in hits){
		currentFist.collider.isTrigger = false;
		Physics.IgnoreCollision(currentFist.collider, collider);
	}
	rigidbody.isKinematic = flag;
	collider.isTrigger = flag;
}

function Reset() {
	gameObject.tag = "Player";
}

function Running() {
	return ((Input.GetAxis("Horizontal") != 0.0 || Input.GetAxis("Vertical") != 0.0) && Input.GetButton("Run"));
}

function FindClosestWithTag (aTag : String) : GameObject {
    // Find all game objects with tag Enemy
    var gos : GameObject[];
    gos = GameObject.FindGameObjectsWithTag(aTag); 
    var closest : GameObject; 
    var distance = Mathf.Infinity; 
    var position = transform.position; 
    // Iterate through them and find the closest one
    for (var go : GameObject in gos)  { 
        var diff = (go.transform.position - position);
        var curDistance = diff.sqrMagnitude; 
        if (curDistance < distance) { 
            closest = go; 
            distance = curDistance; 
        } 
    } 
    return closest;    
}

function InRangeOfRoach(range) : boolean {
	if(GameObject.FindWithTag("Roach"))
		return Vector3.Distance(transform.position, FindClosestWithTag("Roach").transform.position) < range;
	return false;
}

@script RequireComponent(MouseStats,MouseAnimation,MouseLook)
@script AddComponentMenu("Mouse/Mouse Controller")