var walkSpeed : int = 1;
var runSpeed : int = 1;
var comboTime = 0.5;
var shouldAnimate : boolean = true;
var camHeight : float;
var aimSensitivity : float = 2.0;

private var comboTimer = -1.0; 
private var shouldLand : boolean = false;
private var idleStance : String = "Ready";
private var armRot : float = -90;

var stepTime : float = 0.3;
private var walker : RigidbodyFPSWalker;
private var weaponAnimVar : String = "Hands";

private var pcamHeight : float;

Screen.lockCursor = true;

function Awake(){
	camHeight = GameObject.FindWithTag("MainCamera").GetComponent(SmoothFollow).height;
	pcamHeight = camHeight;
	walker = GetComponent(RigidbodyFPSWalker);
	
	animation.wrapMode = WrapMode.Loop;
	
	animation["Run"].layer = 0;
	animation["Run"].speed = 1.25;

	animation["RightStep"].layer = 0;
	animation["LeftStep"].layer = 0;
	
	animation["Walk"].layer = 0;
	animation["Walk"].speed = 1.25;
	
	animation["Climb"].layer = 0;
	animation["Climb"].speed = 0.4;

	animation["Idle"].layer = -1;
	animation["Ready"].layer = -1;
	animation["ChuckReady"].layer = -1;

	animation["Crouch"].layer = -1;
	animation["Crouch"].wrapMode = WrapMode.ClampForever;
	
	animation["ReadyGun"].layer = 0;
	
	animation["Jump"].wrapMode = WrapMode.ClampForever;
	animation["Land"].wrapMode = WrapMode.ClampForever;
	animation["Jump"].layer = 10;
	animation["Land"].layer = 10;
	
	animation["LeftJab"].layer = 2;
	animation["LeftJab"].speed = 1.25;
	animation["LeftJab"].wrapMode = WrapMode.Once;
	
	animation["RHKick1"].layer = 2;
	animation["RHKick1"].speed = 2;
	animation["RHKick1"].wrapMode = WrapMode.Once;
	
	animation["RHKick2"].layer = 2;
	animation["RHKick2"].speed = 2;
	animation["RHKick2"].wrapMode = WrapMode.Once;
	
	animation["RightFist"].layer = 2;
	animation["RightFist"].speed = 1.25;
	animation["RightFist"].wrapMode = WrapMode.Once;
	
	animation["Stomp"].layer = 2;
	animation["Stomp"].speed = 1.25;
	animation["Stomp"].wrapMode = WrapMode.Once;
	
	animation["Fire"].layer = 2;
	animation["Fire"].wrapMode = WrapMode.Once;
	
	animation["Draw"].wrapMode = WrapMode.Once;
	animation["Draw"].layer = 2;
	
	animation["Sheath"].wrapMode = WrapMode.Once;
	animation["Sheath"].layer = 2;
	
	animation.Stop();
}

function Update () {
	if(GetComponent(MouseStats).health <= 0){
		animation.Stop();
	}
	
	armRot -= (Input.GetAxis("Mouse Y") * aimSensitivity);
	pcamHeight -= (Input.GetAxis("Mouse Y") * aimSensitivity/10);
	if(!GetComponent(MouseStats).currentWeapon == "Handgun")
		pcamHeight = camHeight;
	GameObject.FindWithTag("MainCamera").GetComponent(SmoothFollow).height = pcamHeight;
	
	if(shouldAnimate){
		if(walker.Grounded() && !walker.isClimbing){	
			if(Input.GetAxis("Vertical") > 0.0){
				if(Input.GetButton("Run")){
					animation.CrossFade("Run");
					stepTime = 0.2;
					// We fade out jumpland quick otherwise we get sliding feet
					animation.Blend("Land", 0);
				} else {
					stepTime = 0.3;
					animation.CrossFade("Walk");
					animation.Blend("Land", 0);
				}
			} else if(Input.GetAxis("Horizontal") > 0.0) {
				if(!GetComponent("RigidbodyFPSWalker").isClimbing)
					animation.CrossFade("RightStep");
			} else  if(Input.GetAxis("Horizontal") < 0.0){ 
				if(!GetComponent("RigidbodyFPSWalker").isClimbing)
					animation.CrossFade("LeftStep");
			} else {
				if(!animation.IsPlaying("Draw"))
					if(!GetComponent("MouseStats").isChuck || GetComponent("MouseStats").currentWeapon == "Handgun"){
						animation.CrossFade("Ready");
					} else {
						animation.Play("ChuckReady");
					}
				if(GetComponent(MouseStats).currentWeapon == "Handgun" && (!Input.GetButton("Run"))){
					animation.Play("ReadyGun");
				} else {
					animation.Blend("ReadyGun", 0.0, 0.3);
				}
				
				if(Input.GetButton("Crouch")){
					animation.CrossFade("Crouch");
					collider.isTrigger = true;
					rigidbody.isKinematic = true;
				} else {
					collider.isTrigger = false;
					rigidbody.isKinematic = false;
				}

				animation.Blend("Walk", 0.0, 0.3);
				animation.Blend("Run", 0.0, 0.3);
				animation.Blend("Run", 0.0, 0.3);
				animation.Blend("RightStep", 0.0, 0.3);
				animation.Blend("LeftStep", 0.0, 0.3);
				animation.Blend("Climb", 0.0, 0.3);
			}
		
			if(Input.GetButton("Jump")) {
				animation.CrossFade("Jump");	
			}
		
			if(Input.GetButtonDown("Fire1")) {
				if(!GetComponent("MouseController").InRangeOfRoach(10)){
					if(GetComponent(MouseStats).currentWeapon == "Hands"){
						if (Time.time-comboTimer > comboTime) {
							if(!GetComponent("MouseStats").isChuck){
		    	    			animation.Play("LeftJab");
							}else{
			        			animation.Play("RHKick1");
							}
		        			comboTimer = Time.time; 
		      			} else {
		      				if(!GetComponent("MouseStats").isChuck){
			        			animation.PlayQueued("RightFist");
		      				}else{
			        			animation.PlayQueued("RHKick2");
		      				}
		        		}
					} else if(GetComponent(MouseStats).currentWeapon == "Handgun"){
						animation.Play("Fire");
					} 
		   		} else if(GetComponent("MouseStats").currentWeapon == "Hands"){
		   			animation.Play("Stomp");
        			animation.Blend("RightFist", 0.0, 0.1); 
        			animation.Blend("LeftJab", 0.0, 0.1);
		   		}
			}
	   		if(GetComponent(MouseStats).currentWeapon != weaponAnimVar){
				print("MouseAnimation caught weapon down");
	   			if(GetComponent(MouseStats).currentWeapon == "Hands"){
   					animation.Play("Sheath");
   					weaponAnimVar = "Hands";
	   			} else if(GetComponent(MouseStats).currentWeapon == "Handgun") { //if we haven't played the "Draw" animation
					animation.Play("Draw");
					weaponAnimVar = "Handgun";
	   			}
	   		}
		} else {
	   		if(walker.isClimbing == true){
				if(Input.GetAxis("Vertical") > 0.0){
					animation.CrossFade("Climb");
					animation.Blend("Run", 0.0, 0.3);
					animation.Blend("Walk", 0.0, 0.3);
				} else {
					animation.Blend("Climb", 0.0, 0.3);
				}
			}
	   	}
	} else {
		animation.Stop();
	}
	if(!walker.Grounded()){
		shouldLand = true;
	}
}

function LateUpdate() {
	if(GetComponent(MouseStats).currentWeapon == "Handgun"){
		if(GetComponent(MouseController).Running()){
			transform.Find("Gun").position = transform.Find("Root/Spine/MidSpine/R_Arm/R_Elbow/R_Hand").position;
		} else {		
			transform.Find("Root/Spine/MidSpine").localRotation.y = 0;		
			transform.Find("Root/Spine/MidSpine/R_Arm").localRotation = Quaternion(0,0,0,0);
			transform.Find("Root/Spine/MidSpine/R_Arm").Rotate(Vector3.right, armRot);
			transform.Find("Gun").rotation = Quaternion(0,0,0,0);
			transform.Find("Gun").Rotate(Vector3.right, armRot + 90);
			transform.Find("Gun").position = transform.Find("Root/Spine/MidSpine/R_Arm/R_Elbow/R_Hand/R_Finger").position;
		}
	}
}

function OnCollisionEnter (collision : Collision) {
	if(shouldLand)
		animation.CrossFade("Land");
	shouldLand = false;	
}

@script AddComponentMenu("Mouse/Mouse Animation")