var gunRange : float = 100.0;
var gunPower : float = 20.0;

var grapple : Transform;
var grenade : GameObject;
var sight : Transform;
var sparks : ParticleEmitter;
var blood : ParticleEmitter;

var grappleRange : float = 100.0;
var grappling : boolean = false;
var grappleRigidbody : Rigidbody;
var fireRate : float;
var tgPos : Vector3;

private var firing : float;

function Start(){
	sparks.emit = false; //Don't emit particles when we start out.
	blood.emit = false;
	grapple = transform.Find("Grapple");
	GetComponent(LineRenderer).SetColors(Color.black, Color.black);
	GetComponent(LineRenderer).SetVertexCount(2);
	GetComponent(LineRenderer).SetWidth(0.1,0.1);
}

function Update () {
	firing -= Time.deltaTime;
	GetComponent(LineRenderer).SetPosition(0, transform.position);
	GetComponent(LineRenderer).SetPosition(1, grapple.position);
	
	if(sight && transform.parent.GetComponent(MouseStats).currentWeapon == "Handgun"){
		var hit : RaycastHit;
		var layerMask = 1 << 2;
		layerMask = ~layerMask;
		if(Physics.Raycast(transform.position, transform.forward, hit, gunRange, layerMask)){
			sight.renderer.material.SetColor("_Emission", Color.green);
			sight.renderer.material.SetColor("_SpecColor", Color.green);
			sight.renderer.material.SetColor("_Color", Color.green);
			if(hit.rigidbody){
				sight.renderer.material.SetColor("_SpecColor", Color(1,0.0,0.0,1));
				sight.renderer.material.SetColor("_Color", Color(1,0.0,0.0,1));
				sight.renderer.material.SetColor("_Emission", Color(1,0.0,0.0,1));
			}
			sight.transform.position = transform.position + transform.forward*(hit.distance - 0.8);
			//sight.rotation = Quaternion.FromToRotation(Vector3.up, hit.normal);
			sight.localPosition.x = 0;
		} else {
			sight.transform.position = transform.position + transform.forward * (gunRange - 0.8);
			sight.renderer.material.SetColor("_SpecColor", Color.white);
			sight.renderer.material.SetColor("_Emissive", Color.white);
			sight.renderer.material.SetColor("_Color", Color.white);
		}
	}
	if(Input.GetAxis("Horizontal") || Input.GetAxis("Vertical")){ //if the user is moving
		grappleRigidbody = null;
		grapple.localPosition = Vector3.zero;
		grapple.collider.size = Vector3.one; //we don't want to be grappling
	}
}

function FixedUpdate() {
	if(grappling){
		if(grappleRigidbody){
			if(!grappleRigidbody.isKinematic){
				grapple.LookAt(transform);
				grapple.rigidbody.MovePosition(grapple.rigidbody.position + grapple.forward * 50 * Time.deltaTime);
				grappleRigidbody.position = grapple.position;
				if(Vector3.Distance(transform.position, grappleRigidbody.transform.position) < 10){
					grappling = false;
					grappleRigidbody = null;
					grapple.localPosition = Vector3.zero;
				}
			} else {
				transform.parent.rigidbody.isKinematic = true;
				transform.parent.LookAt(tgPos);
				transform.parent.Translate(0,0,2);
				if(Vector3.Distance(transform.parent.position, tgPos) < 10){
					transform.parent.rigidbody.isKinematic = false;
					grappling = false;
				}
				//transform.parent.position = tgPos;
			}
		}
	} else if(grappleRigidbody && Vector3.Distance(transform.parent.position, tgPos) < 10){
		transform.parent.position = tgPos;
	}
}

function Fire() {
	if(firing <= 0.0){
		if(audio)
			audio.Play();
		firing = fireRate;
		sparks.Emit();
		var hit : RaycastHit;
		var layerMask = 1 << 2; //ignore selective colliders
		layerMask = ~layerMask;
		if(Physics.Raycast(transform.position, transform.forward, hit, gunRange, layerMask)){
			if(hit.rigidbody){
				hit.rigidbody.AddForce(transform.forward * gunPower);
				hit.collider.gameObject.SendMessage("TakeDamage", gunPower);
			}
			if(hit.collider.gameObject.CompareTag("EnemyPolice")){
				blood.transform.position = hit.point;
				blood.transform.rotation = Quaternion.FromToRotation(Vector3.up, hit.normal);
				blood.Emit();
				if(Physics.Raycast(transform.position, transform.forward, hit, gunRange, layerMask)){
					if(hit.rigidbody){
						hit.rigidbody.AddForce(transform.forward * gunPower * hit.rigidbody.mass);
					}
				}
			} else if(hit.collider.gameObject.CompareTag("Roach")){
				hit.collider.gameObject.SendMessage("TakeDamage", gunPower);
			}
		}
	}
}

function FireGrapple() {
	var hit : RaycastHit;
	var layerMask = 1 << 2; //ignore the mousee colliders
	layerMask = ~layerMask;
	if(!grappleRigidbody){
		if(Physics.Raycast(transform.position, transform.forward, hit, grappleRange, layerMask)){
			grapple.position = hit.point;
			if(hit.rigidbody){
				grappleRigidbody = hit.rigidbody;
				tgPos = hit.point;
			} else {
				grapple.localPosition = Vector3.zero;
				grapple.collider.size = Vector3.one;
			}
		}
	} else if(grappling == true){
		grappleRigidbody = null;
		grappling = false;
		grapple.localPosition = Vector3.zero;
		grapple.collider.size = Vector3.one;
	} else {
		grappling = true;
	}
}

function FireGrenade() {
	if(grenade){
		var theGrenade : GameObject = Instantiate(grenade, transform.position + transform.forward * 3, transform.rotation);
		theGrenade.rigidbody.AddForce(transform.forward * 200);
		transform.root.GetComponent(MouseStats).grenades -= 1;
	}
}

@script RequireComponent(LineRenderer)
@script AddComponentMenu("Mouse/Hand Gun")