var nextLevel : String;
var loadDelay : int = 10;
var playerGO : GameObject;
var finished : boolean = false;

//GUI
var paused : boolean = false;
var levelName : String = "LevelName";
var objective : String = "Level Objective";
var tutorial : String;

var gCount : int;
var kCount : int;
var kcCount : int;
var cCount : int;
var chucky : boolean;

private var enemyCount : int = 0;
private var remainingHealth : int = 0;

Screen.lockCursor = true;

function Reset() {
	gameObject.tag = "GameController";
}

function OnGUI() {
	GUILayout.Label("Finished = " + finished);
}

function Update() {
	if(!GameObject.FindWithTag("Player")){
		var clone = Instantiate(playerGO, GameObject.FindWithTag("Respawn") ? GameObject.FindWithTag("Respawn").transform.position : Vector3.zero, Quaternion.identity);
		var ps = clone.GetComponent(MouseStats);
		ps.grenades = gCount;
		ps.cards = kcCount;
		ps.cash = cCount;
		ps.keys = kCount;
		ps.isChuck = chucky;
	} else {
		if(GameObject.FindWithTag("Finish")){
			if(Vector3.Distance(GameObject.FindWithTag("Player").transform.position, GameObject.FindWithTag("Finish").transform.position) <= 5 && !finished){
				Debug.Log("FINISHED");
				Finish();
			}
		}
	}
}

function Start() {
	gameObject.tag = "GameController";
	var ps = GameObject.FindWithTag("Player").GetComponent(MouseStats);
	ps.health = PlayerPrefs.GetInt("Health", 100);
	ps.grenades = PlayerPrefs.GetInt("Grenades", 1);
	ps.keys = PlayerPrefs.GetInt("Keys", 0);
	ps.isChuck = PlayerPrefs.GetInt("IsChuck", 0);
	ps.cash = PlayerPrefs.GetInt("Cash", 0);
	ps.cards = PlayerPrefs.GetInt("Cards", 0);
	ps.keys = PlayerPrefs.GetInt("Keys", 0);
	ps.transform.position.x = PlayerPrefs.GetFloat("PosX" + levelName, GameObject.FindWithTag("Respawn") ? GameObject.FindWithTag("Respawn").transform.position.x : 0);
	ps.transform.position.y = PlayerPrefs.GetFloat("PosY" + levelName, GameObject.FindWithTag("Respawn") ? GameObject.FindWithTag("Respawn").transform.position.y : 0 + 2);
	ps.transform.position.z = PlayerPrefs.GetFloat("PosZ" + levelName, GameObject.FindWithTag("Respawn") ? GameObject.FindWithTag("Respawn").transform.position.z : 0);
}

function Finish() {
	GameObject.FindWithTag("DisplayText").GetComponent(Messager).DisplayMessage("Level Complete");
	Save(false);
	finished = true;
	tutorial = "Level Complete";
	objective = "Level Complete";
	yield WaitForSeconds(loadDelay);
	Application.LoadLevel(nextLevel);
}

function TriggerTutorial(tut : String){
	tutorial = tut;
}

function PlayerDied(){
	var ps = GameObject.FindWithTag("Player").GetComponent(MouseStats);
	kCount = ps.keys;
	gCount = ps.grenades;
	chucky = ps.isChuck;
	kcCount = ps.cards;
	cCount = ps.cash;
}


function Save(pos : boolean) {
	var ps = GameObject.FindWithTag("Player").GetComponent(MouseStats);
	PlayerPrefs.SetInt("Health", ps.health);
	PlayerPrefs.SetInt("Grenades", ps.grenades);
	PlayerPrefs.SetInt("Keys", ps.keys);
	PlayerPrefs.SetInt("Cards", ps.cards);
	PlayerPrefs.SetInt("Cash", ps.cash);
	PlayerPrefs.SetInt("IsChuck", ps.isChuck);
	PlayerPrefs.SetInt("GunPower", ps.transform.Find("Gun").GetComponent("Handgun").gunPower);
	if(pos){
		PlayerPrefs.SetFloat("PosX" + levelName, ps.transform.position.x);
		PlayerPrefs.SetFloat("PosY" + levelName, ps.transform.position.y);
		PlayerPrefs.SetFloat("PosZ" + levelName, ps.transform.position.z);
	}
	PlayerPrefs.SetString("Level", levelName);
}

function Quit(save : boolean){
	if(save)
		Save(true);
	Application.LoadLevel("Menu");
}