var spawnPoints : Transform[];
var rowX : int = 5;
var rowZ : int = 4;
var manCount : int = 500;

var spawnTime : float = 10.0;
var spawnTimer : float = 0.0;

var policeGuy : GameObject;

function Update () {
	spawnTimer -= Time.deltaTime;
	if(spawnTimer <= 0.0){
		Spawn();
		spawnTimer = spawnTime;
	}
	if(manCount <= 0 && !GameObject.FindWithTag("EnemyPolice")){
		GetComponent(LevelController).Finish();
		Destroy(this);
	}
	if(!GameObject.FindWithTag("Player")){
		Application.LoadLevel("Level4");
	}
}

function Spawn(){
	var spawnPoint;
	var op = Random.value;
	if(op < 0.3)
		spawnPoint = spawnPoints[0];
	else if(op < 0.6)
		spawnPoint = spawnPoints[1];
	else if(op < 1.0)
		spawnPoint = spawnPoints[2];
		
	//start spawning some troops
	var xPos : int = rowX;
	var zPos : int = rowZ;
	var pop : GameObject;
	for(xPos = 0; xPos < rowX; xPos++){ //do a loop to spawn troops along the x-axis
		for(zPos = 0; zPos < rowZ; zPos++){
			pop = Instantiate(policeGuy, spawnPoint.position + (spawnPoint.right * 4 * xPos) + (spawnPoint.forward * 4 * zPos), spawnPoint.rotation);
			pop.GetComponent(PoliceAI).p_alertPause = 10000.0;
			pop.transform.Translate(0,0, 4);
		}
	}
	manCount -= (rowX * rowZ);
}