var pinTime : float = 4.0;
private var pinTimer;

var damage : int = 10;
var radius : float = 20;

function Awake() {
	pinTimer = pinTime;
}
function Update () {
	pinTimer -= Time.deltaTime;
	if(pinTimer <= 0){
		Explode();
	}
}

function Explode() {
	pinTimer = 1000;
	GetComponent(AudioClipper).PlayRandom();
	transform.Find("flame").particleEmitter.Emit();
	transform.Find("burnflame").particleEmitter.Emit(); //spawn some particles
	transform.Find("sparks").particleEmitter.Emit();
	var layerMask = 1 << 2; 
	var colliders = Physics.OverlapSphere(transform.position, radius, ~layerMask);
	for(var op : Collider in colliders){
		if(op.gameObject.CompareTag("EnemyPolice")){
			transform.LookAt(op.transform);
			op.rigidbody.AddForce(500 * op.rigidbody.mass * transform.forward, ForceMode.VelocityChange);
			op.gameObject.SendMessage("TakeDamage", damage);
		}
	}
	Destroy(gameObject, 1);
}