private var playerCollided;
private var animationTime = 0.0;

var value : int = 5;
var axis : Vector3 = Vector3(100, 0, 0);
var direction : Vector3 = Vector3(10,0,0);
var pickupTime : int = 2;
enum PowerType {Cheese = 0, Chuck = 1, GunPower = 2, Grenades = 3, Key = 4, Card = 5, Cash = 6, RottenCheese = 7, Poison = 8}
var theType : PowerType = PowerType.Cheese;

function Reset(){
	gameObject.tag = "Powerup";
}

function Update () {
	if(GetComponent(TriggerText)){
		switch (PowerType){
			case 0:
				GetComponent(TriggerText).pText = "Health +" + value;
			case 1:
				GetComponent(TriggerText).pText = "";
			case 2:
				GetComponent(TriggerText).pText = "Gun Power +" + value;
			case 3:
				GetComponent(TriggerText).pText = "Grenades +" + value;
			case 4:
				GetComponent(TriggerText).pText = "Key";
			case 5:
				GetComponent(TriggerText).pText = "Keycard";
			case 6 :
				GetComponent(TriggerText).pText = "Cash";
			case 7:
				GetComponent(TriggerText).pText = "Rotten Cheese -" + value;
			case 8:
				GetComponent(TriggerText).pText = "Poision -" + value;
		}
	}
	transform.Rotate(axis * Time.deltaTime);
	
	if(animationTime == pickupTime)
		Destroy(gameObject);
	
	if(playerCollided == true){
		transform.Translate(direction * Time.deltaTime);
		animationTime += Time.deltaTime;
	}
}

function OnCollisionEnter (collision : Collision) {
	if(collision.gameObject.tag == "Player"){
		playerCollided = true;
	}
}

function OnTriggerEnter (other : Collider) {
	if(other.gameObject.tag == "Player"){
		playerCollided = true;
	}
}

@script AddComponentMenu("Pickups/Powerup")