var range : float = 20.0;
var particles : ParticleEmitter;
var rateOfFire = 0.0;
private var timeSinceShot : float = 0.0;
private var laser;

function Awake() {
	if(particles)
		particles.emit = false;
	laser = GetComponent(LineRenderer);
	laser.SetVertexCount(2);
	laser.SetColors(Color.green, Color.red);
}

function Update () {
	var hello : Vector3 = transform.position;
	laser.SetPosition(0, transform.position);
	laser.SetPosition(1, Vector3(transform.position.x, transform.position.y, 50));
}

function Fire(){
	var direction = transform.TransformDirection(Vector3.forward);
	var hit : RaycastHit;
	if(Physics.Raycast(transform.position, direction, hit, 20)) {
		if(hit.rigidbody){
			hit.rigidbody.AddForceAtPosition(10 * direction, hit.point);
			print("Applied force");
		}
		if(particles){
			particles.transform.rotation = Quaternion.FromToRotation(Vector3.up, hit.normal);
			particles.Emit();
		}
	}
}

@script RequireComponent(LineRenderer)