var yPos : float;
var xPos : float;

var buttonWidth : int = 256;
var buttonHeight : int = 48;
var statWidth : int = 512;

var buttonPadding : int = 16;

var nativeVerticalResolution = 864.0;
var nativeHorizontalResolution = 1152.0;

var gSkin : GUISkin;
var hSkin : GUISkin;
var paused : boolean = false;

var HUDBack : Texture;
var statusTex : Texture;

enum StatusMode {Objective = 0, Tutorial = 1}
var statusMode : StatusMode = StatusMode.Objective;

function OnGUI() {
	GUI.skin = gSkin;
	
	xPos = nativeHorizontalResolution / 2 - buttonWidth / 2;
	yPos = nativeVerticalResolution;
	
	GUI.matrix = Matrix4x4.TRS (Vector3(0, 0, 0), Quaternion.identity, Vector3 (Screen.height / nativeVerticalResolution, Screen.height / nativeVerticalResolution, 1));
	
	if(paused){
		Time.timeScale = 0.0;
		GUI.Label(Rect(xPos, nativeVerticalResolution - yPos, buttonWidth, 64), "-Paused-");
		yPos -= (64 + buttonPadding);
		if(GUI.Button(Rect(xPos, nativeVerticalResolution - yPos, buttonWidth, buttonHeight), "Continue")){
			paused = false;
		}
		yPos -= (buttonHeight + buttonPadding);
		if(GUI.Button(Rect(xPos, nativeVerticalResolution - yPos, buttonWidth, buttonHeight), "Save & Quit")){
			GameObject.FindWithTag("GameController").GetComponent(LevelController).Quit(true);
		}
	} else {
		GUI.skin = hSkin;
		Time.timeScale = 1.0;
		yPos = nativeVerticalResolution - 96;
		xPos = 0;
		/*BACKGROUND RECT*/
		GUI.DrawTexture(Rect(0, yPos, nativeHorizontalResolution, 96), HUDBack, ScaleMode.StretchToFill, true, 0);
		/*Health Display*/
		if(GameObject.FindWithTag("Player")){
			var pHealth : int = GameObject.FindWithTag("Player").GetComponent("MouseStats").health;
			GUI.Label(Rect(xPos, yPos, 178, 64), "Health : " + pHealth);
			xPos += nativeHorizontalResolution / 2 - statWidth / 2;
		}
		/*Status bar*/
		GUI.DrawTexture(Rect(xPos, yPos, statWidth, 98), statusTex, ScaleMode.StretchToFill, true, 0);
		var statusString : String;
		if(GetComponent(LevelController)){
			if(statusMode == StatusMode.Objective)
				statusString = GetComponent(LevelController).objective;
			else if(statusMode == StatusMode.Tutorial)
				statusString = GetComponent(LevelController).tutorial;
		}
		GUI.Label(Rect(xPos, yPos-10, statWidth, 98), statusString, "StatusDisplay");
		xPos = nativeHorizontalResolution - 178;
		/*Weapon Display*/
		GUI.Label(Rect(xPos, yPos, 178, 64), WeaponDisplay());
	}
}

function Update () {
	Screen.lockCursor = !paused;
	if(Input.GetKeyDown("escape")){
		paused = !paused;
	}
	if(Input.GetButtonDown("Status")){
		if(statusMode == StatusMode.Objective)
			statusMode = StatusMode.Tutorial;
		else if(statusMode == StatusMode.Tutorial)
			statusMode = StatusMode.Objective;
	}
}

function WeaponDisplay(){
	var theWeapon : String;
	if(GameObject.FindWithTag("Player")){
		var stats = GameObject.FindWithTag("Player").GetComponent("MouseStats");
		if(stats.currentWeapon == "Hands"){
			if(stats.isChuck){
				return "CHUCK NORRIS";
			} else {
				return "Melee";
			}
		} else if(stats.currentWeapon == "Handgun"){
			return stats.gunMode;
		} else if(stats.currentWeapon == "Cash"){
			return "Cash";
		}
	}
}