/*
 * Decompiled with CFR 0.152.
 */
import com.apple.cocoa.foundation.NSRect;
import com.apple.cocoa.foundation.NSSize;

class Spider
extends HorizMine {
    protected int nextFireTime;
    protected int stunnedUntil;
    int nHits;
    protected static final int POINTINGLEFT = 1;
    protected static final int POINTINGRIGHT = 0;

    Spider() {
    }

    public void initInGame(Game g) {
        this.initInGame(g, "spider", 3, 2);
        this.setPerFrameTime(300);
    }

    public int pieceType() {
        return 1;
    }

    public void frameChanged() {
        Helicopter helicopter;
        if (this.curImage == 0 && (helicopter = this.game.helicopter()) != null && this.isWithin(150.0f, helicopter)) {
            NSRect hRect = helicopter.rect();
            this.setVelocity(new NSSize(hRect.midX() < this.pos.x() ? -Math.abs(this.vel.width()) : Math.abs(this.vel.width()), this.vel.height()));
        }
    }

    public void setVelocity(NSSize newVelocity) {
        super.setVelocity(newVelocity);
        this.curPose = this.vel.width() < 0.0f ? 1 : 0;
    }

    public int rechargeTime() {
        return 8000;
    }

    public void updatePiece() {
        if (this.game.updateTime() > this.stunnedUntil) {
            Helicopter helicopter;
            super.updatePiece();
            if (this.curImage != 0 && this.game.updateTime() > this.nextFireTime && (helicopter = this.game.helicopter()) != null && this.isWithin(150.0f, helicopter)) {
                this.fire(new EnemyBullet(), 65.0f, helicopter, true, null);
                this.nextFireTime = this.game.updateTime() + this.rechargeTime();
            }
        }
    }

    public void explode() {
        if (this.game.updateTime() < this.stunnedUntil || ++this.nHits == 2) {
            this.nHits = 0;
            this.stunnedUntil = this.game.updateTime() + 12000;
        }
    }
}

