/*
 * Decompiled with CFR 0.152.
 */
import com.apple.cocoa.foundation.NSPoint;
import com.apple.cocoa.foundation.NSSize;

class MissileBase
extends GamePiece {
    protected int nextFireTime;

    MissileBase() {
    }

    public int pieceType() {
        return 1;
    }

    public void initInGame(Game g) {
        this.initInGame(g, "mbase", 3);
        this.setPerFrameTime(300 + 50 * Game.randInt(20));
    }

    public void explode() {
        MissileBaseExplosion exp = new MissileBaseExplosion();
        ((GamePiece)exp).initInGame(this.game);
        this.game.addScore(1);
        this.explode(exp);
    }

    public void updatePiece() {
        if (this.isWithin(25.0f, this.game.helicopter()) && this.curImage == 0 && this.game.updateTime() > this.nextFireTime) {
            Missile missile = new Missile();
            ((GamePiece)missile).initInGame(this.game);
            NSPoint bulletLocation = new NSPoint(this.pos.midX() - missile.size().width() / 2.0f, this.pos.maxY() - 6.0f);
            NSSize bulletVelocity = new NSSize(this.vel.width(), this.vel.height() + 65.0f);
            missile.setLocation(bulletLocation);
            missile.setVelocity(bulletVelocity);
            this.game.addGamePiece(missile);
            this.game.playEnemyFireSound();
            this.nextFireTime = this.game.updateTime() + 2000;
        }
        super.updatePiece();
    }
}

