/*
 * Decompiled with CFR 0.152.
 */
import com.apple.cocoa.application.NSBezierPath;
import com.apple.cocoa.application.NSColor;
import com.apple.cocoa.application.NSImage;
import com.apple.cocoa.application.NSView;
import com.apple.cocoa.foundation.NSPoint;
import com.apple.cocoa.foundation.NSRect;

public class InputIndicator
extends NSView {
    protected boolean[] highlighted = new boolean[11];

    public InputIndicator(NSRect rect) {
        super(rect);
        this.allocateGState();
    }

    public void drawRect(NSRect rects) {
        NSImage image = NSImage.imageNamed((String)"keypad");
        if (image != null) {
            image.compositeToPoint(new NSPoint(), 2);
        }
    }

    protected NSRect rectFor(int cmd) {
        float width = this.bounds().width() / 4.0f;
        float height = this.bounds().height() / 5.0f;
        float xLoc = 0.0f;
        float yLoc = 0.0f;
        switch (cmd) {
            case 2: {
                xLoc = 2.0f * width;
                yLoc = 3.0f * height;
                break;
            }
            case 1: {
                xLoc = width;
                yLoc = 3.0f * height;
                break;
            }
            case 8: {
                yLoc = 3.0f * height;
                break;
            }
            case 3: {
                xLoc = 2.0f * width;
                yLoc = 2.0f * height;
                break;
            }
            case 9: {
                xLoc = width;
                yLoc = 2.0f * height;
                break;
            }
            case 7: {
                yLoc = 2.0f * height;
                break;
            }
            case 4: {
                xLoc = 2.0f * width;
                yLoc = height;
                break;
            }
            case 5: {
                xLoc = width;
                yLoc = height;
                break;
            }
            case 6: {
                yLoc = height;
                break;
            }
            case 10: {
                width *= 2.0f;
                break;
            }
            default: {
                return null;
            }
        }
        return new NSRect(xLoc, yLoc, width, height).rectByMakingIntegral();
    }

    public void turnOn(int cmd) {
        NSRect rect;
        if (!this.highlighted[cmd] && (rect = this.rectFor(cmd)) != null) {
            rect = rect.rectByInsettingRect(1.0f, 1.0f);
            this.lockFocus();
            NSColor.whiteColor().set();
            NSBezierPath.strokeRect((NSRect)rect);
            this.unlockFocus();
            this.highlighted[cmd] = true;
        }
    }

    public void turnOff(int cmd) {
        NSRect rect;
        if (this.highlighted[cmd] && (rect = this.rectFor(cmd)) != null) {
            NSImage image = NSImage.imageNamed((String)"keypad");
            this.lockFocus();
            if (image != null) {
                image.compositeToPointFromRect(rect.origin(), rect, 2);
            }
            this.unlockFocus();
            this.highlighted[cmd] = false;
        }
    }
}

