/*
 * Decompiled with CFR 0.152.
 */
import com.apple.cocoa.foundation.NSMutableSize;
import com.apple.cocoa.foundation.NSPoint;
import com.apple.cocoa.foundation.NSRect;
import com.apple.cocoa.foundation.NSSize;

public class Helicopter
extends GamePiece {
    private int command;
    private boolean fireRequested;
    private int nextFireTime;
    private static final float ZEROVELTHRESHOLD = 2.0f;
    public static final int NUMHELICOPTERRECTS = 5;
    private static NSRect[] helicopterRectArray;

    public int pieceType() {
        return 0;
    }

    public void initInGame(Game g) {
        this.initInGame(g, "helicopter", 4);
    }

    public void startFiring() {
        this.fireRequested = true;
    }

    public void stopFiring() {
        if (this.fireRequested) {
            this.nextFireTime = Game.minInt(this.nextFireTime, this.game.updateTime() + 125);
            this.fireRequested = false;
        }
    }

    public boolean fireRequested() {
        return this.fireRequested;
    }

    public void setVelocity(NSSize newVelocity) {
        NSMutableSize newVel = new NSMutableSize(Game.maxFloat(0.0f, Game.minFloat(65.0f, newVelocity.width())), Game.restrictValue(newVelocity.height(), 65.0f));
        if (newVel.height() > 0.0f && this.vel.height() > 0.0f && newVel.height() < this.vel.height() && newVel.height() < 2.0f || newVel.height() < 0.0f && this.vel.height() < 0.0f && newVel.height() > this.vel.height() && newVel.height() > -2.0f) {
            newVel.setHeight(0.0f);
        }
        if (newVel.width() < this.vel.width() && newVel.width() < 2.0f) {
            newVel.setWidth(0.0f);
        }
        super.setVelocity((NSSize)newVel);
    }

    public void setCommand(int cmd) {
        this.command = cmd;
    }

    public NSSize acceleration() {
        float dw = 0.0f;
        float dh = 0.0f;
        switch (this.command) {
            case 9: {
                dw = -7.0f * this.vel.width();
                dh = -7.0f * this.vel.height();
                break;
            }
            case 6: {
                dh = -120.0f;
                dw = -120.0f;
                break;
            }
            case 5: {
                dh = -120.0f;
                break;
            }
            case 4: {
                dw = 120.0f;
                dh = -120.0f;
                break;
            }
            case 7: {
                dw = -120.0f;
                break;
            }
            case 3: {
                dw = 120.0f;
                break;
            }
            case 8: {
                dw = -120.0f;
                dh = 120.0f;
                break;
            }
            case 1: {
                dh = 120.0f;
                break;
            }
            case 2: {
                dw = 120.0f;
                dh = 120.0f;
                break;
            }
        }
        return new NSSize(this.acc.width() + dw, this.acc.height() + dh);
    }

    public void updatePiece() {
        if (this.fireRequested() && this.game.updateTime() > this.nextFireTime) {
            Bullet bullet = new Bullet();
            ((GamePiece)bullet).initInGame(this.game);
            this.game.playFriendlyFireSound();
            bullet.setVelocity(new NSSize(this.vel.width() + 65.0f, this.vel.height()));
            bullet.setLocation(new NSPoint(this.pos.maxX() - 8.0f, this.pos.y()));
            this.game.addGamePiece(bullet);
            this.nextFireTime = this.game.updateTime() + 500;
        }
        super.updatePiece();
    }

    public void playExplosionSound() {
        this.game.playLoudExplosionSound();
    }

    public void explode() {
        HelicopterExplosion explosion = new HelicopterExplosion();
        ((GamePiece)explosion).initInGame(this.game);
        this.game.setFocusObject(explosion);
        this.explode(explosion);
    }

    public NSRect[] helicopterRects() {
        if (helicopterRectArray == null) {
            helicopterRectArray = new NSRect[5];
            Helicopter.helicopterRectArray[0] = new NSRect(27.0f, 0.0f, 18.0f, 11.0f);
            Helicopter.helicopterRectArray[1] = new NSRect(0.0f, 8.0f, 4.0f, 11.0f);
            Helicopter.helicopterRectArray[2] = new NSRect(0.0f, 16.0f, 50.0f, 1.0f);
            Helicopter.helicopterRectArray[3] = new NSRect(22.0f, 5.0f, 18.0f, 12.0f);
            Helicopter.helicopterRectArray[4] = new NSRect(0.0f, 10.0f, 42.0f, 3.0f);
        }
        return helicopterRectArray;
    }

    public boolean touches(GamePiece obj) {
        if (!super.touches(obj)) {
            return false;
        }
        int cnt = 0;
        while (cnt < 5) {
            NSRect rect = this.helicopterRects()[cnt];
            if (obj.touchesRect(new NSRect(rect.x() + this.pos.x(), rect.y() + this.pos.y(), rect.width(), rect.height()))) {
                return true;
            }
            ++cnt;
        }
        return false;
    }

    public boolean touchesRect(NSRect r) {
        if (!super.touchesRect(r)) {
            return false;
        }
        int cnt = 0;
        while (cnt < 5) {
            NSRect rect = this.helicopterRects()[cnt];
            if (GamePiece.intersectsRects(r, new NSRect(rect.x() + this.pos.x(), rect.y() + this.pos.y(), rect.width(), rect.height()))) {
                return true;
            }
            ++cnt;
        }
        return false;
    }
}

