/*
 * Decompiled with CFR 0.152.
 */
import com.apple.cocoa.application.NSImage;
import com.apple.cocoa.foundation.NSMutablePoint;
import com.apple.cocoa.foundation.NSMutableSize;
import com.apple.cocoa.foundation.NSPoint;
import com.apple.cocoa.foundation.NSRect;
import com.apple.cocoa.foundation.NSSize;
import com.apple.cocoa.foundation.NSSystem;
import java.util.Vector;

public class GamePiece {
    protected static final int DEFAULTPERFRAMETIME = 200;
    protected static final int BULLETVEL = 65;
    protected static final int ARROWVEL = 90;
    protected static final int ATTACKSHIPVEL = 90;
    protected static final int TIMETORECHARGE = 500;
    protected static final int TIMETORECHARGEMISSILE = 2000;
    protected static final int TIMETORECHARGESMARTMISSILE = 4000;
    protected static final int TIMETORECHARGEENEMYBULLET = 3000;
    protected static final int TIMETORECHARGERAPIDENEMYBULLET = 200;
    protected static final int TIMETORECHARGERAPIDMISSILE = 300;
    protected static final int TIMETORECHARGEARROW = 4000;
    protected static final int TIMETOADJUSTSMARTMISSILE = 500;
    protected static final int TIMETOADJUSTDROPSHIP = 1000;
    protected static final int TIMETOADJUSTARROW = 300;
    protected static final int TIMETOADJUSTSMARTHANGINGBASE = 300;
    protected static final int TIMETODETONATEPROXIMITYMINE = 2000;
    protected static final int TIMETOEXPIREATTACKSHIP = 2000;
    protected static final int TIMETOADJUSTATTACKSHIP = 700;
    protected static final int TIMETOADJUSTSHEEP = 2000;
    protected static final int TIMETOEXPIREBIGEXPLOSION = 600;
    protected static final int TIMETOEXPLODEBIGMULTIPLE = 400;
    protected static final int TIMETORECHARGEWAVEGENERATOR = 800;
    protected static final int TIMETORECHARGEBOMBGENERATOR = 2000;
    protected static final int TIMETORECHARGESPIDER = 8000;
    protected static final int TIMETORECHARGETOUGHSPIDER = 500;
    protected static final int TIMETOSLOWRECHARGETOUGHSPIDER = 2500;
    protected static final int TIMETOUNSTUNSPIDER = 12000;
    protected static final int TIMETOADJUSTKILLERMISSILE = 1000;
    protected static final int TIMETOADJUSTBOMB = 1000;
    protected static final int TIMETORECHARGEKILLERMISSILE = 2000;
    protected static final int TIMETOCHANGEGATE = 2000;
    protected static final int TIMETOOPENGATE = 100;
    protected static final int TIMETOCLOSEGATE = 2000;
    protected static final int TIMETOCLOSEAUTOGATE = 6000;
    protected static final int TIMETOCHANGESWITCHEDGATE = 1000;
    protected static final int TIMETOCLOSESWITCHEDGATE = 10000;
    protected static final int MISSILEDISTANCE = 25;
    protected static final int HANGINGBASEDISTANCE = 125;
    protected static final int SMARTHANGINGBASEDISTANCE = 140;
    protected static final int SNEAKYHANGINGBASEDISTANCE = 40;
    protected static final int SMARTMISSILEDISTANCE = 75;
    protected static final int KILLERMISSILEDISTANCE = 200;
    protected static final int SMARTMINEDISTANCE = 40;
    protected static final int ARROWDISTANCE = 250;
    protected static final int DROPSHIPDISTANCE = 160;
    protected static final int BACKSHOOTERDISTANCE = 250;
    protected static final int PROXIMITYMINEDISTANCE = 20;
    protected static final int ATTACKSHIPDISTANCE = 125;
    protected static final int MAXBIGMULTIPLEOFFSET = 35;
    protected static final int MINBIGMULTIPLEOFFSET = 10;
    protected static final int SPIDERDISTANCE = 150;
    protected static final int BUBBLEMINEDISTANCE = 60;
    protected static final int HOLEDISTANCE = 200;
    protected static final int DONUTDISTANCE = 30;
    protected static final int MISSILEBASESCORE = 1;
    protected static final int HANGINGBASESCORE = 1;
    protected static final int MINESCORE = 1;
    protected static final int BACKSHOOTERSCORE = 1;
    protected static final int DROPSHIPSCORE = 1;
    protected static final int ARROWBASESCORE = 1;
    protected static final int ATTACKSHIPSCORE = 1;
    protected static final int GOODSHEEPSCORE = 2;
    protected static final int BADSHEEPSCORE = 1;
    protected static final int BOINGSCORE = 1;
    protected static final int SPIDERSCORE = 1;
    protected static final int BOMBSCORE = 1;
    protected static final int REQUIREDSMARTMINEHITS = 3;
    protected static final int REQUIREDATTACKSHIPHITS = 3;
    protected static final int REQUIREDWAVEHITS = 2;
    protected static final int REQUIREDSPIDERHITS = 2;
    protected static final int MAXAMEOBAGENERATION = 3;
    protected static final int MAXBIGMULTIPLEGENERATION = 1;
    protected static final int HELICOPTERACCVALUE = 120;
    protected static final int HOLEACCVALUE = 80;
    protected static final int FriendlyPiece = 0;
    protected static final int StationaryEnemyPiece = 1;
    protected static final int MobileEnemyPiece = 2;
    protected static final int OtherPiece = 3;
    protected static final int LastGamePiece = 4;
    public NSSize vel;
    public NSSize acc;
    public NSRect pos;
    protected NSImage images;
    protected int numImages;
    protected int curImage;
    protected int numPoses;
    protected int curPose;
    protected int aliveUntil;
    protected int perFrameTime;
    protected int nextFrameTime;
    protected Game game;
    protected static Vector cachedImages = new Vector();

    public void initInGame(Game g, NSImage frames, int nf, int np, boolean cacheFlag) {
        this.game = g;
        this.numImages = nf;
        this.numPoses = np;
        this.curImage = 0;
        this.curPose = 0;
        this.pos = NSRect.ZeroRect;
        this.vel = NSSize.ZeroSize;
        this.acc = NSSize.ZeroSize;
        if (frames != null) {
            this.images = frames;
            NSSize imageSize = this.images.size();
            this.setSize(new NSSize(imageSize.width() / (float)this.numPoses, imageSize.height() / (float)this.numImages));
            if (cacheFlag) {
                GamePiece.cacheImage(this.images);
            }
        }
        this.setPerFrameTime(200);
        this.aliveUntil = 0;
    }

    public void initInGame(Game g, NSImage frames, int nf, int np) {
        this.initInGame(g, frames, nf, np, true);
    }

    public void initInGame(Game g, String imageName, int nf, int np) {
        this.initInGame(g, NSImage.imageNamed((String)imageName), nf, np);
    }

    public void initInGame(Game g, String imageName, int nf) {
        this.initInGame(g, imageName, nf, 1);
    }

    public void initInGame(Game g) {
        this.initInGame(g, null, 1, 1, true);
    }

    public void setSize(NSSize newSize) {
        this.pos = new NSRect(this.pos.origin(), newSize);
    }

    public void setLocation(NSPoint newLocation) {
        this.pos = new NSRect(newLocation, this.pos.size());
    }

    public void setPerFrameTime(int time) {
        this.setPerFrameTime(time, true);
    }

    public void setPerFrameTime(int time, boolean takeEffectNow) {
        this.perFrameTime = time;
        if (takeEffectNow) {
            this.nextFrameTime = this.game.updateTime() + this.perFrameTime;
        }
    }

    public NSPoint location() {
        return this.pos.origin();
    }

    public NSSize size() {
        return this.pos.size();
    }

    public NSRect rect() {
        return this.pos;
    }

    public void reverseVelocity() {
        NSSize newVel = new NSSize(-this.vel.width(), -this.vel.height());
        this.setVelocity(newVel);
    }

    public void setVelocity(NSSize newVel) {
        this.vel = new NSSize(newVel);
    }

    public NSSize velocity() {
        return this.vel;
    }

    public void setAcceleration(NSSize newAcc) {
        this.acc = new NSSize(newAcc);
    }

    public NSSize acceleration() {
        return this.acc;
    }

    public void setTimeToExpire(int time) {
        this.aliveUntil = this.game.updateTime() + time;
    }

    public void frameChanged() {
    }

    public boolean touches(GamePiece obj) {
        return obj != null && obj != this && obj.touchesRect(this.pos);
    }

    public static boolean intersectsRects(NSRect a, NSRect b) {
        if (a.width() == 0.0f || a.height() == 0.0f) {
            return false;
        }
        if (b.width() == 0.0f || b.height() == 0.0f) {
            return false;
        }
        if (a.x() >= b.maxX()) {
            return false;
        }
        if (b.x() >= a.maxX()) {
            return false;
        }
        if (a.y() >= b.maxY()) {
            return false;
        }
        return !(b.y() >= a.maxY());
    }

    public boolean touchesRect(NSRect rect) {
        return GamePiece.intersectsRects(this.pos, rect);
    }

    public boolean isWithin(float dist, GamePiece obj) {
        if (obj == null) {
            return false;
        }
        NSRect objRect = obj.rect();
        return this.pos.x() - dist < objRect.maxX() && this.pos.maxX() + dist > objRect.x();
    }

    public boolean isInFrontAndWithin(float dist, GamePiece obj) {
        if (obj == null) {
            return false;
        }
        NSRect objRect = obj.rect();
        return this.pos.x() - dist < objRect.maxX() && this.pos.maxX() > objRect.x();
    }

    public boolean isInBackAndWithin(float dist, GamePiece obj) {
        if (obj == null) {
            return false;
        }
        NSRect objRect = obj.rect();
        return objRect.x() - this.pos.maxX() < dist && objRect.maxX() > this.pos.x();
    }

    public boolean isInFrontAndBetween(float farDist, float nearDist, GamePiece obj) {
        if (obj == null) {
            return false;
        }
        NSRect objRect = obj.rect();
        return this.pos.x() - farDist < objRect.maxX() && this.pos.maxX() > objRect.x() + nearDist;
    }

    public void updatePiece() {
        int updateTime = this.game.updateTime();
        int t = this.game.elapsedTime();
        if (t > 0) {
            if (this.aliveUntil > 0 && updateTime > this.aliveUntil) {
                this.game.removeGamePiece(this);
                return;
            }
            if (this.images != null && updateTime > this.nextFrameTime) {
                this.nextFrameTime = Game.maxInt(this.nextFrameTime + this.perFrameTime, updateTime + this.perFrameTime / 2);
                this.curImage = (this.curImage + 1) % this.numImages;
                this.frameChanged();
            }
            NSSize oldVel = this.vel;
            NSSize curAcc = this.acceleration();
            float timeInSeconds = (float)Game.timeInSeconds(t);
            if (curAcc.width() != 0.0f || curAcc.height() != 0.0f) {
                this.setVelocity(new NSSize(this.vel.width() + curAcc.width() * timeInSeconds, this.vel.height() + curAcc.height() * timeInSeconds));
            }
            if (oldVel.width() != 0.0f || oldVel.height() != 0.0f || this.vel.width() != 0.0f || this.vel.height() != 0.0f) {
                this.setLocation(new NSPoint(this.pos.x() + 0.5f * (oldVel.width() + this.vel.width()) * timeInSeconds, this.pos.y() + 0.5f * (oldVel.height() + this.vel.height()) * timeInSeconds));
            }
        }
    }

    public boolean isVisibleIn(NSRect rect) {
        return GamePiece.intersectsRects(rect, this.pos);
    }

    public void draw(NSRect gameRect) {
        if (this.isVisibleIn(gameRect) && this.images != null) {
            NSRect fromRect = new NSRect(this.pos.width() * (float)this.curPose, this.pos.height() * (float)this.curImage, this.pos.width(), this.pos.height());
            NSPoint toPoint = new NSPoint((float)Math.floor(this.pos.x() - gameRect.x()), (float)Math.floor(this.pos.y() - gameRect.y()));
            this.images.compositeToPointFromRect(toPoint, fromRect, 2);
        }
    }

    public void explode() {
        this.explode(null);
    }

    public void playExplosionSound() {
        this.game.playExplosionSound();
    }

    public void explode(GamePiece explosion) {
        if (explosion != null) {
            NSSize explosionSize = explosion.size();
            NSMutablePoint loc = new NSMutablePoint(this.location());
            this.playExplosionSound();
            loc.setX(this.pos.x() - (explosionSize.width() - this.pos.width()) / 2.0f);
            loc.setY(this.pos.y() - (explosionSize.height() - this.pos.height()) / 2.0f);
            explosion.setVelocity(this.vel);
            explosion.setLocation((NSPoint)loc);
            this.game.addGamePiece(explosion);
        }
        this.game.removeGamePiece(this);
    }

    public int pieceType() {
        return 2;
    }

    public void flyTowards(GamePiece obj, boolean smart) {
        NSRect objRect = obj.rect();
        if (smart) {
            NSSize objVel = obj.velocity();
            objRect = new NSRect(objRect.x() + objVel.width() * 0.6f, objRect.y() + objVel.height() * 0.4f, objRect.width(), objRect.height());
        }
        NSMutableSize velVector = new NSMutableSize(objRect.midX() - this.pos.x(), objRect.midY() - this.pos.y());
        float mag = (float)Math.sqrt(velVector.width() * velVector.width() + velVector.height() * velVector.height());
        float speed = (float)Math.sqrt(this.vel.width() * this.vel.width() + this.vel.height() * this.vel.height());
        velVector.setWidth(velVector.width() * speed / mag);
        velVector.setHeight(velVector.height() * speed / mag);
        this.setVelocity((NSSize)velVector);
    }

    public void fire(GamePiece bullet, float speed, GamePiece obj, boolean smart, NSPoint fireFrom) {
        NSPoint bulletLoc;
        NSSize newVel = new NSSize(speed, 0.0f);
        bullet.initInGame(this.game);
        if (fireFrom != null) {
            bulletLoc = new NSPoint(this.pos.x() + fireFrom.x(), this.pos.y() + fireFrom.y());
        } else {
            NSSize bulletSize = bullet.size();
            bulletLoc = new NSPoint(this.pos.midX() - bulletSize.width() / 2.0f, this.pos.midY() - bulletSize.height() / 2.0f);
        }
        bullet.setLocation(bulletLoc);
        bullet.setVelocity(newVel);
        this.game.addGamePiece(bullet);
        this.game.playEnemyFireSound();
        bullet.flyTowards(obj, smart);
    }

    public static void cacheImage(NSImage image) {
        if (!cachedImages.contains(image)) {
            image.lockFocus();
            image.unlockFocus();
            cachedImages.addElement(image);
        }
    }

    public static void cacheImageNamed(String imageName) {
        NSImage image = NSImage.imageNamed((String)imageName);
        if (image == null) {
            NSSystem.log((String)("Bad image to cache " + imageName));
        } else {
            GamePiece.cacheImage(image);
        }
    }
}

