/*
 * Decompiled with CFR 0.152.
 */
import com.apple.cocoa.application.NSAlertPanel;
import com.apple.cocoa.application.NSApplication;
import com.apple.cocoa.application.NSButton;
import com.apple.cocoa.application.NSControl;
import com.apple.cocoa.application.NSEvent;
import com.apple.cocoa.application.NSMatrix;
import com.apple.cocoa.application.NSPanel;
import com.apple.cocoa.application.NSResponder;
import com.apple.cocoa.application.NSSlider;
import com.apple.cocoa.application.NSSound;
import com.apple.cocoa.application.NSTextField;
import com.apple.cocoa.application.NSView;
import com.apple.cocoa.application.NSWindow;
import com.apple.cocoa.foundation.NSMutableRect;
import com.apple.cocoa.foundation.NSNotification;
import com.apple.cocoa.foundation.NSNotificationCenter;
import com.apple.cocoa.foundation.NSPoint;
import com.apple.cocoa.foundation.NSRect;
import com.apple.cocoa.foundation.NSRunLoop;
import com.apple.cocoa.foundation.NSSelector;
import com.apple.cocoa.foundation.NSSize;
import com.apple.cocoa.foundation.NSSystem;
import com.apple.cocoa.foundation.NSTimer;
import com.apple.cocoa.foundation.NSUserDefaults;
import java.util.Date;
import java.util.Random;
import java.util.Vector;

public class Game
extends NSView {
    public static final int MAXBONUSTIME = 120000;
    public static final int BONUS = 10;
    public static final float HELICOPTERSTARTX = 2.0f;
    public static final float HELICOPTERSTARTY = 80.0f;
    public static final int TIMING = 0;
    public static final float ANIMATIONINTERVAL = 0.04f;
    public static final int MAXUPDATETIME = 100;
    public static final int MAXVELX = 65;
    public static final int MAXVELY = 65;
    public static final int MINVELX = 1;
    public static final int MINVELY = 1;
    public static final int NoCommand = 0;
    public static final int GoUpCommand = 1;
    public static final int GoUpRightCommand = 2;
    public static final int GoRightCommand = 3;
    public static final int GoDownRightCommand = 4;
    public static final int GoDownCommand = 5;
    public static final int GoDownLeftCommand = 6;
    public static final int GoLeftCommand = 7;
    public static final int GoUpLeftCommand = 8;
    public static final int StopCommand = 9;
    public static final int FireCommand = 10;
    public static final int NumCommands = 11;
    private static final boolean timing = false;
    private int timingTime;
    private int timingFrames;
    private int timingMissed;
    private int cheating;
    private Vector[] pieces = new Vector[4];
    private Background background;
    private Helicopter helicopter;
    private GamePiece focusObject;
    private NSTextField statusField;
    private NSTextField scoreField;
    private RemainingHelicopters livesField;
    private NSTextField levelField;
    private NSTextField highscoreField;
    private InputIndicator inputIndicator;
    private NSButton pauseButton;
    private NSMatrix levelMatrix;
    private NSSlider levelSlider;
    private NSTextField levelPrefsIndicator;
    private NSButton soundPrefItem;
    private NSTimer timer;
    private NSPoint lastOrigin;
    private boolean gameOver;
    private boolean bonusGiven;
    private boolean newHighScore;
    private boolean started;
    public int score;
    public int lives;
    public int level;
    public int highScore;
    public int highLevel;
    public int numFrames;
    public int updateTime;
    public int elapsedTime;
    public int timeStopped;
    public int pausedAt;
    public int levelStartedAt;
    public Date gameStartTime;
    public int lastCommand;
    public boolean isDemo;
    private static Random randomNumberGenerator;
    private static boolean soundRequested;
    private static NSSound fireSound;
    private static NSSound explosionSound;
    private static NSSound loudExplosionSound;
    private static boolean nonLazyInitDone;
    static boolean alreadyLoadedAGame;
    private static char bugCmd;
    private static final char VERSION = 'B';

    public static int randInt(int n) {
        int r;
        if (randomNumberGenerator == null) {
            randomNumberGenerator = new Random();
        }
        return (r = randomNumberGenerator.nextInt() % (n + 1)) < 0 ? -r : r;
    }

    public static boolean oneIn(int n) {
        return Game.randInt(n - 1) == 0;
    }

    public static double timeInSeconds(int ms) {
        return (float)ms / 1000.0f;
    }

    public static int secondsToMilliseconds(double seconds) {
        return (int)(seconds * 1000.0);
    }

    public static float restrictValue(float val, float max) {
        if (val > max) {
            return max;
        }
        if (val < -max) {
            return -max;
        }
        return val;
    }

    public static float distance(NSPoint p1, NSPoint p2) {
        return (float)Math.sqrt((p1.x() - p2.x()) * (p1.x() - p2.x()) + (p1.y() - p2.y()) * (p1.y() - p2.y()));
    }

    public static int minInt(int a, int b) {
        if (a < b) {
            return a;
        }
        return b;
    }

    public static int maxInt(int a, int b) {
        if (a > b) {
            return a;
        }
        return b;
    }

    public static float minFloat(float a, float b) {
        if (a < b) {
            return a;
        }
        return b;
    }

    public static float maxFloat(float a, float b) {
        if (a > b) {
            return a;
        }
        return b;
    }

    static boolean initSounds() {
        if (fireSound != null) {
            return true;
        }
        fireSound = NSSound.soundNamed((String)"EnemyFire");
        explosionSound = NSSound.soundNamed((String)"LowExplosion");
        loudExplosionSound = NSSound.soundNamed((String)"LoudExplosion");
        return fireSound != null && explosionSound != null && loudExplosionSound != null;
    }

    public void playEnemyFireSound() {
        if (soundRequested) {
            fireSound.play();
        }
    }

    public void playFriendlyFireSound() {
        if (soundRequested) {
            fireSound.play();
        }
    }

    public void playExplosionSound() {
        if (soundRequested) {
            explosionSound.play();
        }
    }

    public void playLoudExplosionSound() {
        if (soundRequested) {
            loudExplosionSound.play();
        }
    }

    private static void cacheImage(String imageName) {
    }

    public static void doNonLazyInitialization() {
        if (nonLazyInitDone) {
            return;
        }
        nonLazyInitDone = true;
        GamePiece.cacheImageNamed("bullet");
        GamePiece.cacheImageNamed("missile");
        GamePiece.cacheImageNamed("smartmissile");
        GamePiece.cacheImageNamed("arrowbaseexplosion");
        GamePiece.cacheImageNamed("backshooterexplosion");
        GamePiece.cacheImageNamed("bigexplosion");
        GamePiece.cacheImageNamed("dropshipexplosion");
        GamePiece.cacheImageNamed("hexplosion");
        GamePiece.cacheImageNamed("hbexplosion");
        GamePiece.cacheImageNamed("mbexplosion");
        GamePiece.cacheImageNamed("smallexplosion");
        GamePiece.cacheImageNamed("smallmineexplosion");
        GamePiece.cacheImageNamed("smartmbexplosion");
        GamePiece.cacheImageNamed("smartmineexplosion");
    }

    public Game(NSRect rect) {
        super(rect);
        this.allocateGState();
        if (!alreadyLoadedAGame) {
            alreadyLoadedAGame = true;
        } else {
            this.setDemo(true);
        }
        this.background = new Background();
        this.background.initInGame(this);
        int cnt = 0;
        while (cnt < 4) {
            this.pieces[cnt] = new Vector(40);
            ++cnt;
        }
        this.readHighScore();
        boolean soundDisabled = NSUserDefaults.standardUserDefaults().booleanForKey("SoundDisabled");
        this.setSoundRequested(!soundDisabled);
        Game.doNonLazyInitialization();
    }

    public boolean acceptsFirstResponder() {
        return true;
    }

    public void viewWillMoveToWindow(NSWindow newWindow) {
        NSWindow oldWindow = this.window();
        if (oldWindow != null) {
            NSNotificationCenter.defaultCenter().removeObserver((Object)this, "NSWindowDidUpdateNotification", (Object)oldWindow);
        }
        if (newWindow != null) {
            Class[] classes = new Class[]{((Object)((Object)this)).getClass()};
            NSNotificationCenter.defaultCenter().addObserver((Object)this, new NSSelector("windowDidUpdate", classes), "NSWindowDidUpdateNotification", (Object)newWindow);
        }
    }

    public boolean isOpaque() {
        return true;
    }

    public void setDemo(boolean flag) {
        this.isDemo = flag;
    }

    public boolean isDemo() {
        return this.isDemo;
    }

    public int timeInMsSinceGameBegan() {
        long ms = this.gameStartTime.getTime();
        long msNow = new Date().getTime();
        int diff = (int)(msNow - ms);
        return diff - this.timeStopped;
    }

    protected void setHighscoreField(NSTextField anObject) {
        this.highscoreField = anObject;
        this.highscoreField.setIntValue(this.highScore);
    }

    public void markGameAsRunning() {
        if (!this.started) {
            this.started = true;
            this.displayRunningMessage();
            if (this.levelStartedAt == -1) {
                this.levelStartedAt = this.updateTime;
            }
        }
    }

    protected int commandForKey(char key) {
        switch (key) {
            case '8': 
            case '\uf700': {
                return 1;
            }
            case '6': 
            case '\uf703': {
                return 3;
            }
            case '2': 
            case '\uf701': {
                return 5;
            }
            case '4': 
            case '\uf702': {
                return 7;
            }
            case '9': 
            case '\uf72c': {
                return 2;
            }
            case '3': 
            case '\uf72d': {
                return 4;
            }
            case '1': 
            case '\uf72b': {
                return 6;
            }
            case '7': 
            case '\uf729': {
                return 8;
            }
            case '0': 
            case '5': 
            case '\uf727': {
                return 9;
            }
            case ' ': 
            case '.': 
            case '\uf728': {
                return 10;
            }
        }
        return 0;
    }

    public void keyDown(NSEvent event) {
        if (this.isPaused()) {
            super.keyDown(event);
        } else {
            char key = event.characters().length() < 1 ? (char)'\u0000' : event.characters().charAt(0);
            int command = this.commandForKey(key);
            switch (command) {
                case 0: {
                    if (key == 'B' && bugCmd == '*' || key == 'u' && bugCmd == 'B' || key == 'g' && bugCmd == 'u') {
                        bugCmd = key;
                        if (bugCmd != 'g') break;
                        bugCmd = (char)42;
                        if (this.cheating != 0) {
                            this.statusField.setIntValue(this.cheating - 1);
                            this.cheating = 0;
                            break;
                        }
                        this.statusField.setStringValue("Hey!");
                        this.cheating = 1;
                        break;
                    }
                    bugCmd = (char)42;
                    if (key == 'h') {
                        NSApplication.sharedApplication().hide(null);
                        break;
                    }
                    super.keyDown(event);
                    break;
                }
                case 10: {
                    this.markGameAsRunning();
                    if (this.helicopter == null) break;
                    this.helicopter.startFiring();
                    break;
                }
                default: {
                    if (this.lastCommand == command) break;
                    if (this.lastCommand != 0) {
                        this.stopLastCommand();
                    }
                    this.lastCommand = command;
                    this.markGameAsRunning();
                    if (this.helicopter != null) {
                        this.helicopter.setCommand(this.lastCommand);
                    }
                    this.inputIndicator.turnOn(command);
                }
            }
        }
    }

    public void keyUp(NSEvent event) {
        if (this.isPaused()) {
            super.keyUp(event);
        } else {
            char key = event.characters().length() < 1 ? (char)'\u0000' : event.characters().charAt(0);
            int command = this.commandForKey(key);
            if (command == 10) {
                if (this.helicopter != null) {
                    this.helicopter.stopFiring();
                }
            } else if (command == this.lastCommand) {
                this.stopLastCommand();
            } else {
                super.keyUp(event);
            }
        }
    }

    public void stopLastCommand() {
        if (this.helicopter != null) {
            this.helicopter.setCommand(0);
        }
        this.inputIndicator.turnOff(this.lastCommand);
        this.lastCommand = 0;
    }

    public Helicopter helicopter() {
        return this.helicopter;
    }

    public Background background() {
        return this.background;
    }

    public void updatePieces() {
        int cnt = 0;
        while (cnt < 4) {
            int objectCnt = this.pieces[cnt].size();
            while (objectCnt-- != 0) {
                ((GamePiece)this.pieces[cnt].elementAt(objectCnt)).updatePiece();
            }
            ++cnt;
        }
    }

    public Vector piecesOfType(int type) {
        return this.pieces[type];
    }

    public void drawPieces() {
        NSRect drawRect = this.currentBackgroundPosition();
        this.background.draw(drawRect);
        int pieceCnt = 0;
        while (pieceCnt < 4) {
            Vector pieceList = this.pieces[pieceCnt];
            int cnt = pieceList.size() - 1;
            while (cnt >= 0) {
                ((GamePiece)pieceList.elementAt(cnt)).draw(drawRect);
                --cnt;
            }
            ++pieceCnt;
        }
    }

    public void drawRect(NSRect rect) {
        this.drawPieces();
    }

    public void checkCollisions() {
        int cnt = this.pieces[0].size() - 1;
        while (cnt >= 0) {
            GamePiece enemy;
            boolean hit = false;
            GamePiece piece = (GamePiece)this.pieces[0].elementAt(cnt);
            int objCnt = this.pieces[1].size() - 1;
            while (objCnt >= 0) {
                enemy = (GamePiece)this.pieces[1].elementAt(objCnt);
                if (piece.touches(enemy)) {
                    enemy.explode();
                    hit = true;
                }
                --objCnt;
            }
            objCnt = this.pieces[2].size() - 1;
            while (objCnt >= 0) {
                enemy = (GamePiece)this.pieces[2].elementAt(objCnt);
                if (piece.touches(enemy)) {
                    enemy.explode();
                    hit = true;
                }
                --objCnt;
            }
            if (hit || piece.touches(this.background)) {
                if (this.helicopter == piece) {
                    if (!this.isDemo()) {
                        if (this.cheating == 0) {
                            this.helicopter.explode();
                            this.helicopter = null;
                            --this.lives;
                            this.livesField.setIntValue(this.lives);
                        } else {
                            ++this.cheating;
                        }
                    }
                } else {
                    piece.explode();
                }
            }
            --cnt;
        }
        cnt = this.pieces[2].size() - 1;
        while (cnt >= 0) {
            GamePiece piece = (GamePiece)this.pieces[2].elementAt(cnt);
            if (piece.touches(this.background)) {
                piece.explode();
            }
            --cnt;
        }
    }

    public void removeGamePiece(GamePiece piece) {
        this.pieces[piece.pieceType()].removeElement(piece);
        if (piece == this.focusObject) {
            this.focusObject = null;
        }
    }

    public void addGamePiece(GamePiece piece) {
        this.pieces[piece.pieceType()].addElement(piece);
    }

    public void setFocusObject(GamePiece piece) {
        this.focusObject = piece;
    }

    public int updateTime() {
        return this.updateTime;
    }

    public int elapsedTime() {
        return this.elapsedTime;
    }

    public NSRect currentBackgroundPosition() {
        NSMutableRect rect = new NSMutableRect();
        rect.setSize(this.bounds().size());
        if (this.focusObject == null) {
            rect.setOrigin(this.lastOrigin);
        } else {
            NSRect focusObjectRect = this.focusObject.rect();
            rect.setX((float)Math.floor(focusObjectRect.midX() - rect.width() / 2.0f));
            rect.setY((float)Math.floor(focusObjectRect.midY() - rect.height() / 2.0f));
            rect.setX(Game.maxFloat(0.0f, Game.minFloat(rect.x(), this.background.gameRect().width() - rect.width())));
            rect.setY(Game.maxFloat(0.0f, Game.minFloat(rect.y(), this.background.gameRect().height() - rect.height())));
            this.lastOrigin = rect.origin();
        }
        return rect;
    }

    public void doAward() {
        NSAlertPanel.runAlert((String)"BlastApp Completed", (String)("Congratulations! You finished BlastApp with " + this.score + " points."), (String)"Great!", null, null);
        if (this.background.levelDataName() == null && NSAlertPanel.runAlert((String)"BlastApp Completed", (String)"Would you like a certificate documenting your victory?  (Even if you don't have a printer you can save the certificate as a PostScript file and print it later.)", (String)"Yes", (String)"No", null) == 1) {
            AwardView.makeNewAward(this.background.numLevels(), this.score);
        }
    }

    public void step(NSTimer obj) {
        int scoreBefore = this.score;
        ++this.numFrames;
        this.elapsedTime = this.timeInMsSinceGameBegan() - this.updateTime;
        if (this.elapsedTime > 100) {
            this.stopGameFor(this.elapsedTime - 100);
            this.elapsedTime = 100;
        }
        this.updateTime += this.elapsedTime;
        this.updatePieces();
        this.checkCollisions();
        this.setNeedsDisplay(true);
        if (!this.gameOver) {
            if (this.helicopter != null) {
                NSRect helicopterRect = this.helicopter.rect();
                if (!GamePiece.intersectsRects(this.background.gameRect(), helicopterRect)) {
                    if (this.isDemo()) {
                        this.statusField.setStringValue("Level completed.");
                    } else if (this.updateTime - this.levelStartedAt < 120000) {
                        this.addScore(10);
                        this.statusField.setStringValue("Level " + this.level + " completed with bonus points!");
                    } else {
                        this.statusField.setStringValue("Level " + this.level + " completed.");
                    }
                    if (this.isDemo()) {
                        this.startLevel(this.level < this.background.numLevels() ? this.level + 1 : 1);
                    } else if (this.level == this.background.numLevels()) {
                        this.gameOver = true;
                        this.removeGamePiece(this.helicopter);
                        this.helicopter = null;
                        this.updateHighScore();
                        this.scoreField.setIntValue(this.score);
                        this.doAward();
                        this.statusField.setStringValue("Game completed with " + this.score + " points.");
                    } else {
                        this.startLevel(this.level + 1);
                    }
                }
            }
            this.updateHighScore();
            if (this.focusObject == null && !this.gameOver) {
                if (this.lives != 0) {
                    this.statusField.setStringValue(this.lives + " helicopter" + (this.lives > 1 ? "s" : "") + " left. Ready to start.");
                    this.restartLevel();
                } else if (!this.bonusGiven && this.score >= 1000) {
                    this.lives = 1;
                    this.bonusGiven = true;
                    this.statusField.setStringValue("You get a Bonus Helicopter!");
                    this.restartLevel();
                } else {
                    this.statusField.setStringValue(this.newHighScore ? "Game over with a new high score." : "All helicopters destroyed. Game Over.");
                    this.gameOver = true;
                }
            }
        }
        if (this.score != scoreBefore) {
            this.scoreField.setIntValue(this.score);
        }
    }

    public void windowDidUpdate(NSNotification notification) {
    }

    public void go(NSControl sender) {
        if (this.timer == null) {
            if (this.lives != 0) {
                this.displayRunningMessage();
            } else {
                this.statusField.setStringValue("Game Over.");
            }
            Class[] classes = new Class[]{((Object)((Object)this)).getClass()};
            this.timer = new NSTimer((double)0.04f, (Object)this, new NSSelector("step", classes), (Object)this, true);
            NSRunLoop.currentRunLoop().addTimerForMode(this.timer, "NSDefaultRunLoopMode");
            this.pauseButton.setState(0);
        }
        this.window().makeFirstResponder((NSResponder)this);
    }

    public void stop(NSControl sender) {
        if (this.timer != null) {
            this.timer.invalidate();
            this.timer = null;
            this.pausedAt = this.timeInMsSinceGameBegan();
            this.statusField.setStringValue("Paused.");
            this.pauseButton.setState(1);
        }
    }

    public boolean isPaused() {
        return this.timer == null;
    }

    public void togglePause(NSControl sender) {
        if (this.timer != null) {
            this.stop(sender);
        } else {
            int timeAdj = this.timeInMsSinceGameBegan() - this.pausedAt;
            this.stopGameFor(Game.maxInt(timeAdj, 0));
            this.go(sender);
        }
    }

    public void stopGameFor(int timeAdj) {
        this.timeStopped += timeAdj;
    }

    public void startLevel(int newLevel) {
        this.level = Game.minInt(newLevel, this.background.numLevels());
        this.levelField.setIntValue(this.level);
        this.updateHighScore();
        int cnt = 0;
        while (cnt < 4) {
            this.pieces[cnt].removeAllElements();
            ++cnt;
        }
        this.helicopter = null;
        this.background.setLevel(this.level);
        this.restartLevel();
    }

    public void startGame(NSControl sender) {
        int startingLevel = this.levelMatrix == null || this.levelMatrix.selectedTag() == 0 ? this.highLevel : this.levelSlider.intValue();
        this.startGameAtLevel(sender, startingLevel);
    }

    public void startGameAtLevel(Object sender, int startingLevel) {
        this.updateHighScore();
        this.lives = 3;
        this.score = 0;
        this.livesField.setIntValue(this.lives);
        this.scoreField.setIntValue(this.score);
        this.gameStartTime = new Date();
        this.timeStopped = 0;
        this.updateTime = 0;
        this.startLevel(startingLevel);
        this.go(null);
        if (this.highScore == 0 && this.highLevel == 1) {
            this.statusField.setStringValue("Welcome! See About Box for help.");
        } else {
            this.statusField.setStringValue("Ready to start new game.");
        }
        this.gameOver = false;
        this.newHighScore = false;
        this.levelStartedAt = -1;
    }

    public void toggleSound(NSControl sender) {
        boolean newState = !soundRequested;
        this.setSoundRequested(newState);
        if (newState != soundRequested) {
            if (newState) {
                NSAlertPanel.runAlert(null, (String)"Can't play sounds.", (String)"Bummer", null, null);
            }
        } else {
            NSUserDefaults.standardUserDefaults().setBooleanForKey(!soundRequested, "SoundDisabled");
        }
        this.updateSoundPref();
    }

    public void setSoundRequested(boolean flag) {
        soundRequested = flag && Game.initSounds();
    }

    public void setStartingLevel(NSControl sender) {
        this.levelMatrix.selectCellAtLocation(1, 0);
        this.levelPrefsIndicator.setIntValue(sender.intValue());
    }

    public void updateStartingLevelPrefs() {
        if (this.levelMatrix != null && this.levelMatrix.window().isVisible()) {
            this.levelSlider.setMaxValue((double)this.highLevel);
            if (this.highLevel < 2) {
                this.levelSlider.setEnabled(false);
                this.levelMatrix.cellAtLocation(1, 0).setEnabled(false);
            } else {
                this.levelSlider.setEnabled(true);
                this.levelMatrix.cellAtLocation(1, 0).setEnabled(true);
            }
        }
    }

    public void updateSoundPref() {
        if (this.soundPrefItem != null && this.soundPrefItem.window().isVisible()) {
            this.soundPrefItem.setState(soundRequested ? 1 : 0);
        }
    }

    public void showPrefs(NSControl sender) {
        if (this.levelMatrix == null) {
            if (!NSApplication.loadNibNamed((String)"Prefs", (Object)((Object)this)) || this.levelMatrix == null) {
                NSSystem.log((String)"Prefs.nib could not be loaded successfully.");
            }
            ((NSPanel)this.levelMatrix.window()).setBecomesKeyOnlyIfNeeded(true);
        }
        this.levelMatrix.window().orderFront(null);
        this.updateStartingLevelPrefs();
        this.updateSoundPref();
    }

    private static int hash(String str, int modBy) {
        int hash = 0;
        if (str != null) {
            int len = str.length();
            int cnt = 0;
            while (cnt < len) {
                hash = (hash + str.charAt(cnt)) % modBy;
                ++cnt;
            }
        }
        return hash;
    }

    public void writeHighScore() {
        String fileName = this.background.levelDataName();
        String defaultValue = "B" + ((this.highScore * 99 + this.highLevel) * 99 + Game.hash("nousername", 49) + Game.hash(fileName, 50));
        String defaultName = fileName != null ? "HighScoreFor" + fileName : "HighScore";
        NSUserDefaults.standardUserDefaults().setObjectForKey((Object)defaultValue, defaultName);
    }

    public void readHighScore() {
        block3: {
            String fileName = this.background.levelDataName();
            String defaultName = fileName != null ? "HighScoreFor" + fileName : "HighScore";
            String defaultValue = NSUserDefaults.standardUserDefaults().stringForKey(defaultName);
            this.highLevel = 1;
            this.highScore = 0;
            if (defaultValue == null || defaultValue.length() <= 1 || defaultValue.charAt(0) != 'B') break block3;
            try {
                int value = Integer.parseInt(defaultValue.substring(1));
                if (value % 99 == Game.hash("nousername", 49) + Game.hash(fileName, 50)) {
                    this.highLevel = Game.maxInt(1, Game.minInt((value /= 99) % 99, 30));
                    this.highScore = Game.maxInt(0, value / 99);
                }
            }
            catch (Exception e) {}
        }
    }

    public void updateHighScore() {
        boolean bl = this.newHighScore = this.newHighScore || this.score > this.highScore;
        if (this.score > this.highScore || this.level > this.highLevel) {
            this.highScore = Game.maxInt(this.score, this.highScore);
            this.highLevel = Game.maxInt(this.level, this.highLevel);
            this.highscoreField.setIntValue(this.highScore);
            this.updateStartingLevelPrefs();
            this.writeHighScore();
        }
    }

    public void restartLevel() {
        NSPoint startLocation = new NSPoint(2.0f, 80.0f);
        NSSize zero = new NSSize(0.0f, 0.0f);
        this.helicopter = this.isDemo() ? new AutoPilotHelicopter() : new Helicopter();
        this.helicopter.initInGame(this);
        this.addGamePiece(this.helicopter);
        this.setFocusObject(this.helicopter);
        this.helicopter.setLocation(startLocation);
        this.helicopter.setVelocity(zero);
        this.helicopter.setAcceleration(zero);
        System.gc();
        this.started = false;
        this.lastCommand = 0;
    }

    public void addScore(int points) {
        this.score += points * this.level;
    }

    public void displayRunningMessage() {
        this.statusField.setStringValue((this.lives == 3 ? "Welcome to " : "Running in ") + this.background.levelDescription());
    }

    public void windowWillClose(NSNotification notification) {
        this.stop(null);
    }

    public void windowDidMiniaturize(NSNotification notification) {
        this.stop(null);
    }

    static {
        nonLazyInitDone = false;
        alreadyLoadedAGame = false;
        bugCmd = (char)42;
    }
}

