/*
 * Decompiled with CFR 0.152.
 */
import com.apple.cocoa.foundation.NSMutableSize;
import com.apple.cocoa.foundation.NSPoint;
import com.apple.cocoa.foundation.NSRect;
import com.apple.cocoa.foundation.NSSize;

class DropShip
extends GamePiece {
    protected int nextFireTime;

    DropShip() {
    }

    public void initInGame(Game g) {
        this.initInGame(g, "dropship", 1);
        this.setPerFrameTime(100000000);
    }

    public boolean touches(GamePiece obj) {
        if (super.touches(obj)) {
            return obj.touchesRect(new NSRect(this.pos.x(), this.pos.y() + 4.0f, this.pos.width(), this.pos.height() - 4.0f)) || obj.touchesRect(new NSRect(this.pos.x() + 4.0f, this.pos.y(), this.pos.width() - 4.0f, 4.0f));
        }
        return false;
    }

    public boolean touchesRect(NSRect rect) {
        if (super.touchesRect(rect)) {
            return GamePiece.intersectsRects(rect, new NSRect(this.pos.x(), this.pos.y() + 4.0f, this.pos.width(), this.pos.height() - 4.0f)) || GamePiece.intersectsRects(rect, new NSRect(this.pos.x() + 4.0f, this.pos.y(), this.pos.width() - 4.0f, 4.0f));
        }
        return false;
    }

    public void explode() {
        DropShipExplosion exp = new DropShipExplosion();
        ((GamePiece)exp).initInGame(this.game);
        this.game.addScore(1);
        this.explode(exp);
    }

    public void updatePiece() {
        if (this.game.updateTime() > this.nextFireTime) {
            Helicopter helicopter = this.game.helicopter();
            NSSize newVelocity = null;
            if (helicopter != null && this.isInFrontAndWithin(160.0f, helicopter)) {
                NSRect helicopterRect = helicopter.rect();
                EnemyBullet missile = new EnemyBullet();
                ((GamePiece)missile).initInGame(this.game);
                NSPoint bulletLocation = new NSPoint(this.pos.x(), this.pos.y() + 7.0f);
                NSMutableSize bulletVelocity = new NSMutableSize(-65.0f, 0.0f);
                if (helicopterRect.maxY() < this.pos.y()) {
                    bulletVelocity.setHeight(-13.0f);
                } else if (helicopterRect.y() > this.pos.maxY()) {
                    bulletVelocity.setHeight(13.0f);
                }
                missile.setVelocity((NSSize)bulletVelocity);
                missile.setLocation(bulletLocation);
                this.game.addGamePiece(missile);
                this.game.playEnemyFireSound();
                newVelocity = new NSSize(0.0f, (helicopterRect.midY() - this.pos.midY()) / (float)Game.timeInSeconds(1000));
                this.nextFireTime = this.game.updateTime() + 1000;
            }
            super.updatePiece();
            this.setVelocity(newVelocity == null ? NSSize.ZeroSize : newVelocity);
        } else {
            super.updatePiece();
        }
    }
}

