/*
 * Decompiled with CFR 0.152.
 */
import com.apple.cocoa.foundation.NSRect;
import com.apple.cocoa.foundation.NSSize;

class BubbleMine
extends Mine {
    BubbleMine() {
    }

    public void initInGame(Game g) {
        this.initInGame(g, "bubblemine", 6);
        this.setPerFrameTime(90 + Game.randInt(10));
    }

    public boolean touches(GamePiece obj) {
        if (super.touches(obj)) {
            float third = (float)Math.floor(this.pos.width() / 3.0f);
            return obj.touchesRect(new NSRect(this.pos.x() + third, this.pos.y() + 2.0f, third, this.pos.height() - 4.0f)) || obj.touchesRect(new NSRect(this.pos.x() + 2.0f, this.pos.y() + third, this.pos.width() - 4.0f, third));
        }
        return false;
    }

    public boolean touchesRect(NSRect rect) {
        if (super.touchesRect(rect)) {
            float third = (float)Math.floor(this.pos.width() / 3.0f);
            return GamePiece.intersectsRects(rect, new NSRect(this.pos.x() + third, this.pos.y() + 2.0f, third, this.pos.height() - 4.0f)) || GamePiece.intersectsRects(rect, new NSRect(this.pos.x() + 2.0f, this.pos.y() + third, this.pos.width() - 4.0f, third));
        }
        return false;
    }

    public void explode() {
        int newPerFrameTime = this.perFrameTime + Game.randInt(32);
        if (newPerFrameTime > 250) {
            BigMultipleExplosion exp = new BigMultipleExplosion();
            ((GamePiece)exp).initInGame(this.game);
            this.game.addScore(1);
            super.explode(exp);
        } else {
            this.setPerFrameTime(newPerFrameTime, false);
        }
    }

    public void updatePiece() {
        Helicopter helicopter = this.game.helicopter();
        if (helicopter != null && this.isWithin(60.0f, helicopter)) {
            NSRect hRect = helicopter.rect();
            NSSize newVel = hRect.y() > this.pos.midY() ? new NSSize(0.0f, 6.5f) : new NSSize(0.0f, -6.5f);
            this.setVelocity(newVel);
        }
        if (this.perFrameTime > 100) {
            this.setPerFrameTime(this.perFrameTime - this.game.elapsedTime() / 20, false);
        }
        super.updatePiece();
    }
}

