/*
 * Decompiled with CFR 0.152.
 */
import com.apple.cocoa.foundation.NSRect;
import com.apple.cocoa.foundation.NSSize;

class Bomb
extends GamePiece {
    Bomb() {
    }

    public void initInGame(Game g) {
        this.initInGame(g, "bomb", 6);
        this.setPerFrameTime(250);
        this.setTimeToExpire(8000);
    }

    public void frameChanged() {
        if (this.curImage == this.numImages - 1) {
            Helicopter helicopter = this.game.helicopter();
            if (helicopter != null) {
                NSRect hRect = helicopter.rect();
                NSSize backgroundSize = this.game.background().size();
                this.setVelocity(new NSSize(65.0f, 65.0f * hRect.x() / (backgroundSize.width() * 2.0f)));
                this.flyTowards(helicopter, true);
            }
            this.setPerFrameTime(100000000);
        }
    }

    public void updatePiece() {
        if (this.game.helicopter() == null) {
            this.explode(null);
        } else {
            super.updatePiece();
        }
    }

    public void explode() {
        SmallHarmlessExplosion exp = new SmallHarmlessExplosion();
        ((GamePiece)exp).initInGame(this.game);
        this.game.addScore(1);
        super.explode(exp);
    }
}

