/*
 * Decompiled with CFR 0.152.
 */
import com.apple.cocoa.application.NSApplication;
import com.apple.cocoa.application.NSControl;
import com.apple.cocoa.foundation.NSNotification;
import com.apple.cocoa.foundation.NSSystem;

class BlastAppController {
    protected Game game;
    protected Game demo;
    public static final String copyright = "Copyright (c) 1990-2002, Apple Computer";

    BlastAppController() {
    }

    public void createNewGame(Object sender) {
        if (this.game == null) {
            if (!NSApplication.loadNibNamed((String)"Game.nib", (Object)this)) {
                NSSystem.log((String)"No nib file for game?");
                return;
            }
            this.game.startGame(null);
            this.game.window().center();
        }
        this.game.window().makeKeyAndOrderFront(null);
    }

    public void createDemo(Object sender) {
        if (this.demo == null) {
            Game origGame = this.game;
            if (!NSApplication.loadNibNamed((String)"Game.nib", (Object)this)) {
                NSSystem.log((String)"No nib file for game?");
                return;
            }
            this.demo = this.game;
            this.game = origGame;
            this.game.stop(null);
            this.demo.setDemo(true);
            this.demo.window().setTitle("BlastApp Demo");
            this.demo.startGame(null);
        }
        this.demo.window().makeKeyAndOrderFront(null);
    }

    public void applicationDidFinishLaunching(NSNotification notification) {
        this.createNewGame(null);
    }

    public void applicationDidHide(NSNotification notification) {
        if (this.game != null) {
            this.game.stop(null);
        }
        if (this.demo != null) {
            this.demo.stop(null);
        }
    }

    public void applicationDidUnhide(NSNotification notification) {
    }

    public boolean applicationShouldTerminate(NSControl sender) {
        this.game.updateHighScore();
        return true;
    }

    public void showPrefs(NSControl sender) {
        this.game.showPrefs(sender);
    }

    public void setGame(Game obj) {
        this.game = obj;
    }
}

