/*
 * Decompiled with CFR 0.152.
 */
import com.apple.cocoa.application.NSAlertPanel;
import com.apple.cocoa.application.NSApplication;
import com.apple.cocoa.application.NSBezierPath;
import com.apple.cocoa.application.NSColor;
import com.apple.cocoa.application.NSImage;
import com.apple.cocoa.foundation.NSBundle;
import com.apple.cocoa.foundation.NSData;
import com.apple.cocoa.foundation.NSMutablePoint;
import com.apple.cocoa.foundation.NSMutableRect;
import com.apple.cocoa.foundation.NSPathUtilities;
import com.apple.cocoa.foundation.NSPoint;
import com.apple.cocoa.foundation.NSRect;
import com.apple.cocoa.foundation.NSSize;
import com.apple.cocoa.foundation.NSSystem;
import com.apple.cocoa.foundation.NSUserDefaults;
import java.io.File;
import java.util.StringTokenizer;

public class Background
extends GamePiece {
    public static final int LANDSCAPEHEIGHT = 175;
    public static final int MAXLEVELNAMELENGTH = 80;
    public static final int MAXLEVELS = 30;
    public static final int MAXNUMLANDSCAPESPECS = 150;
    public static final int LANDSCAPEWIDTHPERSPEC = 25;
    public int maxLevelSpecs;
    public int numLandscapeSpecs;
    public int landscapeWidthInPixels;
    public NSRect gameRect;
    protected short[] bottom;
    protected short[] top;
    protected int bottomSpec;
    protected int topSpec;
    protected int gamePieces;
    protected String levelDescription;
    protected String fileName;
    protected byte[] levelData;
    protected int currentLevel;
    protected int numLevels;
    protected NSColor groundColor;

    protected float codeToHeight(int code) {
        return (float)(175 * (code - 97)) / 25.0f;
    }

    protected int codeToWidth(int code) {
        return this.landscapeWidthInPixels * code / this.numLandscapeSpecs;
    }

    protected int widthToPrevCode(float w) {
        return (int)(w / (float)(this.landscapeWidthInPixels / this.numLandscapeSpecs));
    }

    protected int widthToNextCode(float w) {
        return 1 + (int)((w - 1.0f) / (float)(this.landscapeWidthInPixels / this.numLandscapeSpecs));
    }

    public void initInGame(Game g) {
        String levelFile = g.isDemo() ? NSBundle.mainBundle().pathForResource("DemoLevelData", "txt") : NSUserDefaults.standardUserDefaults().stringForKey("LevelFile");
        if (levelFile != null) {
            if (this.initializeLevelData(new NSData(new File(levelFile)))) {
                this.fileName = NSPathUtilities.stringByDeletingPathExtension((String)NSPathUtilities.lastPathComponent((String)levelFile));
                if (!g.isDemo()) {
                    NSSystem.log((String)("BlastApp: Using external level file " + levelFile + "."));
                }
            } else {
                NSAlertPanel.runAlert((String)"Bad Level Data File", (String)("The external level data file " + levelFile + " doesn't exist or is illegal. Will use the default level data instead."), (String)"OK", null, null);
            }
        }
        if (!(this.numLevels() != 0 || (levelFile = NSBundle.mainBundle().pathForResource("LevelData", "txt")) != null && this.initializeLevelData(new NSData(new File(levelFile))))) {
            NSSystem.log((String)"Bad level data, aborting.");
            NSApplication.sharedApplication().terminate(null);
        }
        this.bottom = new short[this.maxLevelSpecs * 25];
        this.top = new short[this.maxLevelSpecs * 25];
        this.initInGame(g, new NSImage(new NSSize((float)(this.maxLevelSpecs * 25), 175.0f)), 1, 1, false);
        this.setPerFrameTime(10000000);
    }

    public NSRect gameRect() {
        return this.gameRect;
    }

    public String levelDataName() {
        return this.fileName;
    }

    public int numLevels() {
        return this.numLevels;
    }

    private static int advanceToNextLine(byte[] ptr, int cnt) {
        while (ptr[cnt] != 0 && ptr[cnt++] != 10) {
        }
        return cnt;
    }

    public boolean initializeLevelData(NSData data) {
        this.levelData = data.bytes(0, data.length());
        boolean done = false;
        int cnt = 0;
        while (!done) {
            switch ((char)this.levelData[cnt]) {
                case '%': {
                    cnt = Background.advanceToNextLine(this.levelData, cnt);
                    break;
                }
                case '+': {
                    ++this.numLevels;
                    cnt = Background.advanceToNextLine(this.levelData, cnt);
                    cnt = Background.advanceToNextLine(this.levelData, cnt);
                    int tmp = Background.advanceToNextLine(this.levelData, cnt);
                    if (tmp - cnt - 2 > this.maxLevelSpecs) {
                        this.maxLevelSpecs = tmp - cnt - 2;
                    }
                    cnt = tmp;
                    cnt = Background.advanceToNextLine(this.levelData, cnt);
                    cnt = Background.advanceToNextLine(this.levelData, cnt);
                    break;
                }
                case '$': {
                    done = true;
                    break;
                }
                default: {
                    done = true;
                    this.numLevels = 0;
                }
            }
        }
        return this.numLevels > 0;
    }

    public boolean getLevelData(int level) {
        int cnt = 0;
        int levelCnt = 0;
        block6: while (levelCnt != level) {
            switch ((char)this.levelData[cnt]) {
                case '%': {
                    cnt = Background.advanceToNextLine(this.levelData, cnt);
                    break;
                }
                case '+': {
                    ++levelCnt;
                    int nameLoc = cnt + 1;
                    int colorLoc = cnt = Background.advanceToNextLine(this.levelData, cnt);
                    this.topSpec = cnt = Background.advanceToNextLine(this.levelData, cnt);
                    this.bottomSpec = cnt = Background.advanceToNextLine(this.levelData, cnt);
                    this.gamePieces = cnt = Background.advanceToNextLine(this.levelData, cnt);
                    cnt = Background.advanceToNextLine(this.levelData, cnt);
                    if (levelCnt != level) continue block6;
                    cnt = Background.advanceToNextLine(this.levelData, nameLoc);
                    this.levelDescription = new String(this.levelData, nameLoc, cnt - nameLoc - 1);
                    this.numLandscapeSpecs = this.bottomSpec - this.topSpec - 2;
                    this.landscapeWidthInPixels = this.numLandscapeSpecs * 25;
                    this.gameRect = new NSRect(0.0f, 0.0f, (float)this.landscapeWidthInPixels, 175.0f);
                    try {
                        String colorSpec = new String(this.levelData, colorLoc, this.topSpec - colorLoc - 1);
                        if (colorSpec.equals("random")) {
                            this.groundColor = NSColor.colorWithCalibratedHSB((float)((float)Game.randInt(100) / 100.0f), (float)1.0f, (float)1.0f, (float)1.0f);
                        } else {
                            StringTokenizer scanner = new StringTokenizer(colorSpec);
                            float red = Float.valueOf(scanner.nextToken()).floatValue();
                            float green = Float.valueOf(scanner.nextToken()).floatValue();
                            float blue = Float.valueOf(scanner.nextToken()).floatValue();
                            this.groundColor = NSColor.colorWithCalibratedRGB((float)red, (float)green, (float)blue, (float)1.0f);
                        }
                    }
                    catch (Exception e) {
                        NSSystem.log((String)("Bad color specification for level " + levelCnt + "; using default."));
                        this.groundColor = NSColor.brownColor();
                    }
                    return true;
                }
                default: {
                    return false;
                }
            }
        }
        return false;
    }

    public void setLevel(int level) {
        if (level > this.numLevels()) {
            level = this.numLevels();
        }
        if (!this.getLevelData(level)) {
            NSAlertPanel.runAlert((String)"Bad Level Data", (String)("Sorry, level " + level + " is under construction."), (String)"Bummer", null, null);
            while (--level != 0 && !this.getLevelData(level)) {
            }
            if (level == 0) {
                NSSystem.log((String)"Bad level data file, aborting.");
                NSApplication.sharedApplication().terminate(null);
            }
        }
        this.currentLevel = level;
        this.createLandscape();
        this.images.lockFocus();
        this.drawLandscape();
        this.images.unlockFocus();
    }

    public String levelDescription() {
        return this.levelDescription;
    }

    protected static void washToBlack(NSColor color, NSSize size) {
        float hue = color.hueComponent();
        NSMutableRect rect = new NSMutableRect(0.0f, 0.0f, size.width(), 1.0f);
        float curHeight = 0.0f;
        while (curHeight < size.height()) {
            float brightness = 0.5f * (curHeight / size.height());
            NSColor.colorWithCalibratedHSB((float)hue, (float)1.0f, (float)brightness, (float)1.0f).set();
            rect.setY(curHeight);
            NSBezierPath.fillRect((NSRect)rect);
            curHeight += 1.0f;
        }
    }

    protected static void washToWhite(NSColor color, NSSize size) {
        float hue = color.hueComponent();
        NSMutableRect rect = new NSMutableRect(0.0f, 0.0f, size.width(), 1.0f);
        float curHeight = 0.0f;
        while (curHeight < size.height()) {
            float saturation = 0.5f * (curHeight / size.height());
            NSColor.colorWithCalibratedHSB((float)hue, (float)saturation, (float)1.0f, (float)1.0f).set();
            rect.setY(curHeight);
            NSBezierPath.fillRect((NSRect)rect);
            curHeight += 1.0f;
        }
    }

    public void drawLandscape() {
        NSMutablePoint point = new NSMutablePoint();
        NSColor color = this.groundColor;
        color.set();
        Background.washToBlack(color, this.size());
        NSBezierPath path = new NSBezierPath();
        point.setX(0.0f);
        point.setY(0.0f);
        path.moveToPoint((NSPoint)point);
        int cnt = 0;
        while (cnt <= this.numLandscapeSpecs) {
            point.setX((float)this.codeToWidth(cnt));
            point.setY(this.codeToHeight(this.levelData[this.topSpec + cnt]));
            path.lineToPoint((NSPoint)point);
            ++cnt;
        }
        cnt = this.numLandscapeSpecs;
        while (cnt >= 0) {
            point.setX((float)this.codeToWidth(cnt));
            point.setY(this.codeToHeight(this.levelData[this.bottomSpec + cnt]));
            path.lineToPoint((NSPoint)point);
            --cnt;
        }
        path.closePath();
        path.setClip();
        Background.washToWhite(color, this.size());
    }

    public void draw(NSRect gameRect) {
        this.images.compositeToPointFromRect(NSPoint.ZeroPoint, gameRect, 1);
    }

    protected void createLandscape() {
        float[] vels = new float[]{32.5f, 21.666666f, 16.25f, 13.0f};
        int spec = 0;
        while (spec < this.numLandscapeSpecs) {
            float bottomSlope = (this.codeToHeight(this.levelData[this.bottomSpec + spec + 1]) - this.codeToHeight(this.levelData[this.bottomSpec + spec])) / (float)(this.codeToWidth(spec + 1) - this.codeToWidth(spec));
            float topSlope = (this.codeToHeight(this.levelData[this.topSpec + spec + 1]) - this.codeToHeight(this.levelData[this.topSpec + spec])) / (float)(this.codeToWidth(spec + 1) - this.codeToWidth(spec));
            int cnt = this.codeToWidth(spec);
            while (cnt < this.codeToWidth(spec + 1)) {
                this.bottom[cnt] = (short)(this.codeToHeight(this.levelData[this.bottomSpec + spec]) + bottomSlope * (float)(cnt - this.codeToWidth(spec)));
                this.top[cnt] = (short)(this.codeToHeight(this.levelData[this.topSpec + spec]) + topSlope * (float)(cnt - this.codeToWidth(spec)));
                ++cnt;
            }
            ++spec;
        }
        spec = 0;
        while (spec < this.numLandscapeSpecs) {
            GamePiece piece = null;
            byte cur = this.levelData[this.gamePieces + spec];
            float bottomHeight = (float)Math.floor(this.codeToHeight(this.levelData[this.bottomSpec + spec]));
            float topHeight = (float)Math.floor(this.codeToHeight(this.levelData[this.topSpec + spec]));
            switch ((char)cur) {
                case '.': {
                    break;
                }
                case '2': 
                case 'F': 
                case 'a': 
                case 'b': {
                    switch ((char)cur) {
                        case 'a': {
                            piece = new MissileBase();
                            break;
                        }
                        case 'b': {
                            piece = new SmartMissileBase();
                            break;
                        }
                        case 'F': {
                            piece = new RapidFireMissileBase();
                            break;
                        }
                        case '2': {
                            piece = new KillerMissileBase();
                        }
                    }
                    piece.initInGame(this.game);
                    piece.setLocation(new NSPoint((float)Math.floor((float)this.codeToWidth(spec) + (float)this.codeToWidth(1) / 2.0f) - piece.size().width() / 2.0f, bottomHeight));
                    this.game.addGamePiece(piece);
                    break;
                }
                case '5': 
                case '6': 
                case 'E': 
                case 'J': 
                case 'c': {
                    switch ((char)cur) {
                        case 'c': {
                            piece = new HangingBase();
                            break;
                        }
                        case 'E': {
                            piece = new RapidFireHangingBase();
                            break;
                        }
                        case '5': {
                            piece = new DumHangingBase();
                            break;
                        }
                        case 'J': {
                            piece = new SmartHangingBase();
                            break;
                        }
                        case '6': {
                            piece = new SneakyHangingBase();
                        }
                    }
                    piece.initInGame(this.game);
                    piece.setLocation(new NSPoint((float)Math.floor((float)this.codeToWidth(spec) + (float)this.codeToWidth(1) / 2.0f) - piece.size().width() / 2.0f, topHeight - piece.size().height()));
                    this.game.addGamePiece(piece);
                    break;
                }
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': {
                    this.putMine(new SmallMine(), spec, vels[cur - 100]);
                    break;
                }
                case 'h': {
                    this.putMine(new SmallMine(), spec, 65.0f * ((float)Game.randInt(60) / 100.0f));
                    break;
                }
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': {
                    this.putMine(new Sentry(), spec, vels[cur - 106]);
                    break;
                }
                case 'n': {
                    this.putMine(new Sentry(), spec, 65.0f * ((10.0f + (float)Game.randInt(30)) / 100.0f));
                    break;
                }
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': {
                    this.putMine(new FatSentry(), spec, vels[cur - 111]);
                    break;
                }
                case 's': {
                    this.putMine(new FatSentry(), spec, 65.0f * ((10.0f + (float)Game.randInt(40)) / 100.0f));
                    break;
                }
                case 't': {
                    this.putMine(new LargeMine(), spec, 4.642857f);
                    break;
                }
                case 'u': {
                    this.putMine(new Fog(), spec, Game.oneIn(2) ? 65.0f * ((float)Game.randInt(10) / 200.0f) : 0.0f);
                    break;
                }
                case 'w': {
                    this.putMine(new SmartMine(), spec, 65.0f * (0.25f + (float)Game.randInt(30) / 100.0f));
                    break;
                }
                case 'z': {
                    this.putMine(new RealSmartMine(), spec, 65.0f * (0.4f + (float)Game.randInt(30) / 100.0f));
                    break;
                }
                case 'v': {
                    piece = new BackShooter();
                    piece.initInGame(this.game);
                    piece.setLocation(new NSPoint((float)Math.floor((float)this.codeToWidth(spec) + (float)this.codeToWidth(1) / 2.0f) - piece.size().width() / 2.0f, bottomHeight));
                    this.game.addGamePiece(piece);
                    break;
                }
                case 'A': 
                case 'B': 
                case 'C': {
                    this.putMine(new AmeobaMine(), spec, vels[cur - 65]);
                    break;
                }
                case 'D': {
                    this.putMine(new StopMine(), spec, 65.0f * ((10.0f + (float)Game.randInt(40)) / 100.0f));
                    break;
                }
                case 'G': {
                    this.putMine(new RandomMine(), spec, 32.5f);
                    break;
                }
                case 'H': {
                    this.putMine(new Throton(), spec, 16.25f);
                    break;
                }
                case '8': {
                    this.putMine(new Throton(), spec, 21.666666f);
                    break;
                }
                case 'I': {
                    this.putMine(new Throton(), spec, 65.0f * ((10.0f + (float)Game.randInt(40)) / 100.0f));
                    break;
                }
                case 'L': {
                    this.putMine(new ProximityMine(), spec, 0.0f, 0.0f);
                    break;
                }
                case '@': {
                    this.putMine(new DonutMine(), spec, 65.0f, 0.5f);
                    break;
                }
                case 'K': 
                case 'M': 
                case 'O': 
                case 'P': 
                case 'x': {
                    switch ((char)cur) {
                        case 'x': {
                            piece = new DropShip();
                            break;
                        }
                        case 'K': {
                            piece = new RapidFireDropShip();
                            break;
                        }
                        case 'M': {
                            piece = new AttackShip();
                            break;
                        }
                        case 'O': {
                            piece = new BigAttackShip();
                            break;
                        }
                        case 'P': {
                            piece = new SmartAttackShip();
                        }
                    }
                    piece.initInGame(this.game);
                    piece.setLocation(new NSPoint((float)Math.floor((float)this.codeToWidth(spec) + (float)this.codeToWidth(1) / 2.0f), (float)Math.floor((double)(bottomHeight + topHeight) / 2.0)));
                    this.game.addGamePiece(piece);
                    break;
                }
                case 'y': {
                    piece = new ArrowBase();
                    piece.initInGame(this.game);
                    piece.setLocation(new NSPoint((float)Math.floor((float)this.codeToWidth(spec) + (float)this.codeToWidth(1) / 2.0f) - piece.size().width() / 2.0f, bottomHeight));
                    this.game.addGamePiece(piece);
                    break;
                }
                case '+': {
                    piece = new Switch();
                    piece.initInGame(this.game);
                    piece.setLocation(new NSPoint((float)Math.floor((float)this.codeToWidth(spec) + (float)this.codeToWidth(1) / 2.0f), bottomHeight + 5.0f));
                    this.game.addGamePiece(piece);
                    break;
                }
                case 'N': {
                    this.putMine(new Gunes(), spec, 65.0f * ((10.0f + (float)Game.randInt(30)) / 100.0f));
                    break;
                }
                case '&': {
                    this.putMine(new FourMines(), spec, 16.25f);
                    break;
                }
                case 'Q': 
                case 'R': {
                    this.putMine(new TimedVertGate(), spec, cur == 81 ? 0.0f : 16.25f, 0.5f);
                    break;
                }
                case '*': {
                    this.putMine(new Hole(), spec, 0.0f, 0.5f);
                    break;
                }
                case 'S': {
                    this.putHorizMine(new GoodSheep(), spec, 65.0f / ((float)Game.randInt(4) + 4.0f), 0.0f);
                    break;
                }
                case 'V': {
                    this.putHorizMine(new ToughGoodSheep(), spec, 65.0f / ((float)Game.randInt(4) + 4.0f), 0.0f);
                    break;
                }
                case '4': {
                    this.putHorizMine(new BadSheep(), spec, 65.0f / ((float)Game.randInt(4) + 4.0f), 0.0f);
                    break;
                }
                case 'U': {
                    this.putMine(new PassableVertGate(), spec, 0.0f, 0.5f);
                    break;
                }
                case '9': {
                    this.putMine(new SwitchedVertGate(), spec, 0.0f, 0.5f);
                    break;
                }
                case 'T': {
                    this.putMine(new TimedHorizGate(), spec, 0.0f, 0.5f);
                    break;
                }
                case 'W': {
                    this.putMine(new WaveGenerator(), spec, 65.0f);
                    break;
                }
                case '$': {
                    this.putMine(new KillerWaveGenerator(), spec, 65.0f);
                    break;
                }
                case '3': {
                    this.putMine(new BombGenerator(), spec, 0.0f);
                    break;
                }
                case 'Y': {
                    this.putMine(new BoingBall(), spec, 0.0f, 0.8f);
                    break;
                }
                case 'X': {
                    this.putMine(new BubbleMine(), spec, 0.0f, (float)(2 + Game.randInt(6)) / 10.0f);
                    break;
                }
                case 'Z': {
                    this.putMine(new BouncingBoingBall(), spec, 65.0f, 0.0f);
                    break;
                }
                case '7': {
                    this.putMine(new SneakyBoingBall(), spec, 0.0f, 0.95f);
                    break;
                }
                case '0': {
                    this.putHorizMine(new Spider(), spec, 21.666666f, 0.0f);
                    break;
                }
                case '1': {
                    this.putHorizMine(new ToughSpider(), spec, 23.214287f, 0.0f);
                    break;
                }
                default: {
                    NSSystem.log((String)("Unknown game piece indicator " + cur));
                }
            }
            ++spec;
        }
    }

    protected void putMine(Mine mine, int loc, float yVel, float locFromBottomPercentage) {
        float bottomHeight = 0.0f;
        float topHeight = 100000.0f;
        NSMutablePoint mineLocation = new NSMutablePoint((float)this.codeToWidth(loc), 0.0f);
        NSSize mineVelocity = new NSSize(0.0f, yVel);
        mine.initInGame(this.game);
        NSSize mineSize = mine.size();
        int cnt = loc;
        while (cnt <= loc + this.widthToNextCode(mineSize.width())) {
            bottomHeight = Game.maxFloat(bottomHeight, this.codeToHeight(this.levelData[this.bottomSpec + cnt]));
            topHeight = Game.minFloat(topHeight, this.codeToHeight(this.levelData[this.topSpec + cnt]));
            ++cnt;
        }
        if ((bottomHeight += 2.0f) >= (topHeight -= 2.0f)) {
            NSSystem.log((String)("Can't place mine " + mine.toString() + " at " + loc + "."));
            return;
        }
        if (locFromBottomPercentage >= 1.0f) {
            mineLocation.setY(bottomHeight + (float)Game.randInt((int)(topHeight - bottomHeight)));
        } else {
            mineLocation.setY(bottomHeight + (float)((int)((topHeight - mineSize.height() - bottomHeight) * locFromBottomPercentage)));
        }
        mine.setHighLow(topHeight, bottomHeight);
        mine.setVelocity(mineVelocity);
        mine.setLocation((NSPoint)mineLocation);
        this.game.addGamePiece(mine);
    }

    protected void putHorizMine(HorizMine mine, int loc, float xVel, float locFromBottomPercentage) {
        float bottomHeight = this.codeToHeight(this.levelData[this.bottomSpec + loc]);
        float topHeight = 100000.0f;
        float leftLoc = 100000.0f;
        float rightLoc = -100000.0f;
        NSMutablePoint mineLocation = new NSMutablePoint((float)this.codeToWidth(loc), 0.0f);
        NSSize mineVelocity = new NSSize(xVel, 0.0f);
        mine.initInGame(this.game);
        NSSize mineSize = mine.size();
        int cnt = loc;
        while (cnt <= loc + this.widthToNextCode(mineSize.width())) {
            topHeight = Game.minFloat(topHeight, this.codeToHeight(this.levelData[this.topSpec + cnt]));
            ++cnt;
        }
        cnt = loc;
        while (cnt > 1 && this.levelData[this.bottomSpec + loc] == this.levelData[this.bottomSpec + cnt - 1]) {
            --cnt;
        }
        leftLoc = this.codeToWidth(cnt);
        cnt = loc;
        while (cnt < this.numLandscapeSpecs - 1 && this.levelData[this.bottomSpec + loc] == this.levelData[this.bottomSpec + cnt + 1]) {
            ++cnt;
        }
        rightLoc = this.codeToWidth(cnt);
        if (locFromBottomPercentage >= 1.0f) {
            mineLocation.setY(bottomHeight + (float)Game.randInt((int)(topHeight - mineSize.height() - bottomHeight)));
        } else {
            mineLocation.setY(bottomHeight + (float)((int)((topHeight - bottomHeight) * locFromBottomPercentage)));
        }
        mine.setLeftRight(leftLoc, rightLoc);
        mine.setVelocity(mineVelocity);
        mine.setLocation((NSPoint)mineLocation);
        this.game.addGamePiece(mine);
    }

    public void putMine(Mine mine, int loc, float yVel) {
        this.putMine(mine, loc, yVel, 1.0f);
    }

    public boolean touches(GamePiece obj) {
        return obj != this && obj.touches(this);
    }

    public boolean touchesRect(NSRect rect) {
        int from = Game.minInt(Game.maxInt(0, (int)rect.x()), this.landscapeWidthInPixels - 1);
        int to = Game.minInt(Game.maxInt(0, (int)rect.maxX()), this.landscapeWidthInPixels - 1);
        while (from <= to) {
            if ((float)this.bottom[from] >= rect.y() || (float)this.top[from] <= rect.maxY()) {
                return true;
            }
            ++from;
        }
        return false;
    }

    public NSRect clearRect(float startLoc, float endLoc) {
        int to = Game.maxInt(0, Game.minInt((int)endLoc, this.landscapeWidthInPixels - 1));
        int from = Game.maxInt(0, Game.minInt((int)startLoc, this.landscapeWidthInPixels - 1));
        float y1 = 0.0f;
        float y2 = 175.0f;
        int tmp = from;
        while (tmp <= to) {
            if ((float)this.bottom[tmp] > y1) {
                y1 = this.bottom[tmp];
            }
            if ((float)this.top[tmp] < y2) {
                y2 = this.top[tmp];
            }
            ++tmp;
        }
        return new NSRect((float)from, y1, (float)(to - from), y2 - y1);
    }
}

