/*
 * Decompiled with CFR 0.152.
 */
import com.apple.cocoa.foundation.NSPoint;
import com.apple.cocoa.foundation.NSRect;
import com.apple.cocoa.foundation.NSSize;

class BackShooter
extends GamePiece {
    protected int nextFireTime;

    BackShooter() {
    }

    public int pieceType() {
        return 1;
    }

    public void initInGame(Game g) {
        this.initInGame(g, "backshooter", 4);
        this.setPerFrameTime(300 + 5 * Game.randInt(20));
    }

    public boolean touches(GamePiece obj) {
        return false;
    }

    public void explode() {
        BackShooterExplosion exp = new BackShooterExplosion();
        ((GamePiece)exp).initInGame(this.game);
        this.game.addScore(1);
        this.explode(exp);
    }

    public void updatePiece() {
        Helicopter helicopter = this.game.helicopter();
        if (helicopter != null) {
            NSRect helicopterRect = helicopter.rect();
            if (this.isInBackAndWithin(250.0f, helicopter) && (helicopterRect.y() <= this.pos.maxY() && this.curImage == 2 || helicopterRect.y() >= this.pos.maxY() && this.curImage == 0) && this.game.updateTime() > this.nextFireTime) {
                EnemyBullet missile = new EnemyBullet();
                ((GamePiece)missile).initInGame(this.game);
                missile.setVelocity(new NSSize(65.0f, this.curImage == 0 ? 21.666666f : 0.0f));
                missile.setLocation(new NSPoint(this.pos.maxX(), this.pos.y() + (this.curImage == 0 ? 7.0f : 4.0f)));
                this.game.addGamePiece(missile);
                this.game.playEnemyFireSound();
                this.nextFireTime = this.game.updateTime() + 3000;
            }
        }
        super.updatePiece();
    }
}

