/*
 * Decompiled with CFR 0.152.
 */
import com.apple.cocoa.application.NSAffineTransform;
import com.apple.cocoa.application.NSApplication;
import com.apple.cocoa.application.NSBitmapImageRep;
import com.apple.cocoa.application.NSControl;
import com.apple.cocoa.application.NSFont;
import com.apple.cocoa.application.NSGraphics;
import com.apple.cocoa.application.NSImage;
import com.apple.cocoa.application.NSImageRep;
import com.apple.cocoa.application.NSPrintInfo;
import com.apple.cocoa.application.NSTextField;
import com.apple.cocoa.application.NSView;
import com.apple.cocoa.application.NSWindow;
import com.apple.cocoa.foundation.NSArray;
import com.apple.cocoa.foundation.NSAttributedString;
import com.apple.cocoa.foundation.NSBundle;
import com.apple.cocoa.foundation.NSFormatter;
import com.apple.cocoa.foundation.NSGregorianDate;
import com.apple.cocoa.foundation.NSGregorianDateFormatter;
import com.apple.cocoa.foundation.NSMutableAttributedString;
import com.apple.cocoa.foundation.NSMutableRect;
import com.apple.cocoa.foundation.NSPoint;
import com.apple.cocoa.foundation.NSRange;
import com.apple.cocoa.foundation.NSRect;
import com.apple.cocoa.foundation.NSSystem;

class AwardView
extends NSView {
    public NSTextField nameField;
    private int numLevels;
    private int score;
    private float textDrawingLocation;
    private static NSBitmapImageRep helicopterBitmap;

    public AwardView(NSRect rect) {
        super(rect);
    }

    protected boolean getUserName() {
        String name = NSSystem.currentFullUserName();
        if (name == null) {
            name = NSSystem.currentUserName();
        }
        if (this.nameField == null && !NSApplication.loadNibNamed((String)"UserName.nib", (Object)((Object)this))) {
            return false;
        }
        this.nameField.setStringValue(name != null ? name : "");
        this.nameField.selectText(null);
        return NSApplication.sharedApplication().runModalForWindow(this.nameField.window()) != 0;
    }

    public void nameOK(NSControl sender) {
        NSApplication.sharedApplication().stopModalWithCode(1);
        this.nameField.window().orderOut(null);
    }

    public void nameCancel(NSControl sender) {
        NSApplication.sharedApplication().stopModalWithCode(0);
        this.nameField.window().orderOut(null);
    }

    public static void makeNewAward(int nLevels, int sc) {
        NSRect rect = new NSRect(0.0f, 0.0f, 500.0f, 500.0f);
        AwardView award = new AwardView(rect);
        if (!award.getUserName()) {
            return;
        }
        if (helicopterBitmap == null) {
            AwardView.cacheHelicopterBitmap();
        }
        NSPrintInfo printInfo = NSPrintInfo.sharedPrintInfo();
        NSWindow win = new NSWindow(rect, 0, 1, false);
        win.contentView().addSubview((NSView)award);
        printInfo.setVerticallyCentered(true);
        printInfo.setHorizontallyCentered(true);
        printInfo.setVerticalPagination(1);
        printInfo.setHorizontalPagination(1);
        award.setLevels(nLevels, sc);
        award.print(null);
    }

    public void setLevels(int nLevels, int sc) {
        this.numLevels = nLevels;
        this.score = sc;
    }

    private static void cacheHelicopterBitmap() {
        NSImage helicopter = new NSImage(NSBundle.mainBundle().pathForResource("helicopter", "tiff"), true);
        helicopter.setCacheDepthMatchesImageDepth(true);
        NSArray reps = helicopter.representations();
        helicopter.lockFocusOnRepresentation((NSImageRep)reps.objectAtIndex(0));
        helicopterBitmap = new NSBitmapImageRep(new NSRect(0.0f, 0.0f, helicopter.size().width(), helicopter.size().height() / 4.0f));
        helicopter.unlockFocus();
    }

    public void drawLineOfText(String txt, float size) {
        float width;
        NSMutableAttributedString attrStr = new NSMutableAttributedString(txt);
        NSRange range = new NSRange(0, attrStr.length());
        float viewWidth = this.bounds().width();
        do {
            NSFont font = NSFont.fontWithNameAndSize((String)"Times-Roman", (float)size);
            attrStr.addAttributeInRange("NSFont", (Object)font, range);
        } while (!((width = NSGraphics.sizeOfAttributedString((NSAttributedString)attrStr).width()) < viewWidth * 0.9f) && (size -= 2.0f) > 10.0f);
        NSGraphics.drawAttributedString((NSAttributedString)attrStr, (NSPoint)new NSPoint((viewWidth - width) / 2.0f, this.textDrawingLocation));
        this.textDrawingLocation += size * 1.3f + 4.0f;
    }

    public void drawRect(NSRect rect) {
        NSMutableRect hRect = new NSMutableRect();
        NSMutableRect sRect = new NSMutableRect();
        NSRect bounds = this.bounds();
        NSAffineTransform transform = new NSAffineTransform();
        transform.translateXYBy(0.0f, bounds.height());
        transform.scaleXYBy(1.0f, -1.0f);
        transform.concat();
        sRect.setSize(helicopterBitmap.size());
        hRect.setWidth((float)Math.floor(bounds.width() * 0.6f));
        hRect.setHeight((float)Math.floor(hRect.width() / sRect.width() * sRect.height()));
        hRect.setX((bounds.width() - hRect.width()) / 2.0f);
        hRect.setY(bounds.height() - hRect.height() * 1.5f);
        helicopterBitmap.drawInRect((NSRect)hRect);
        sRect.setX(10.0f);
        sRect.setY(10.0f);
        helicopterBitmap.drawInRect((NSRect)sRect);
        sRect.setX(bounds.maxX() - 10.0f - sRect.width());
        helicopterBitmap.drawInRect((NSRect)sRect);
        sRect.setY(bounds.maxY() - 10.0f - sRect.height());
        helicopterBitmap.drawInRect((NSRect)sRect);
        sRect.setX(10.0f);
        helicopterBitmap.drawInRect((NSRect)sRect);
        transform.concat();
        this.textDrawingLocation = bounds.height() - hRect.y() + 28.0f;
        this.drawLineOfText("Certificate of Achievement", 28.0f);
        this.drawLineOfText("awarded to", 20.0f);
        this.drawLineOfText(this.nameField.stringValue(), 48.0f);
        this.drawLineOfText("for valiantly completing the " + this.numLevels + " treacherous levels of", 20.0f);
        this.drawLineOfText("BlastApp", 28.0f);
        this.drawLineOfText("with a total score of " + this.score, 24.0f);
        try {
            NSGregorianDateFormatter dateFormatter = new NSGregorianDateFormatter("%A, %B %e, %Y", true);
            this.drawLineOfText(dateFormatter.stringForObjectValue((Object)new NSGregorianDate()), 20.0f);
        }
        catch (NSFormatter.FormattingException e) {
            // empty catch block
        }
        NSGraphics.frameRect((NSRect)bounds);
    }

    public boolean isFlipped() {
        return true;
    }
}

