/*
 * Decompiled with CFR 0.152.
 */
import com.apple.cocoa.foundation.NSPoint;
import com.apple.cocoa.foundation.NSRect;
import com.apple.cocoa.foundation.NSSize;

class AutoPilotHelicopter
extends Helicopter {
    protected static final int AUTOPILOTSTARTTIME = 2000;
    protected static final int AUTOPILOTTAKEOVERTIME = 4000;
    protected int autopilotTakeoverTime;
    protected boolean autopilot;
    protected static final int AUTOPILOTHELICOPTERSPEED = 48;

    AutoPilotHelicopter() {
    }

    public void initInGame(Game g) {
        super.initInGame(g);
        this.autopilotTakeoverTime = this.game.updateTime() + 2000;
    }

    public void setCommand(int cmd) {
        this.autopilot = false;
        this.autopilotTakeoverTime = this.game.updateTime() + 4000;
        super.setCommand(cmd);
    }

    public void startFiring() {
        this.autopilot = false;
        this.autopilotTakeoverTime = this.game.updateTime() + 40000;
        super.startFiring();
    }

    public void stopFiring() {
        this.autopilot = false;
        this.autopilotTakeoverTime = this.game.updateTime() + 4000;
        super.stopFiring();
    }

    public boolean fireRequested() {
        if (this.autopilot) {
            return Game.oneIn(50);
        }
        return super.fireRequested();
    }

    public void updatePiece() {
        if (!this.autopilot && this.game.updateTime() >= this.autopilotTakeoverTime) {
            this.autopilot = true;
            this.game.markGameAsRunning();
            this.setVelocity(new NSSize(48.0f, 0.0f));
            this.setAcceleration(new NSSize(0.0f, 0.0f));
        }
        super.updatePiece();
        NSRect rect = this.game.background().clearRect(this.pos.x(), this.pos.maxX() + 4.0f);
        if (this.pos.maxY() >= rect.maxY()) {
            this.setLocation(new NSPoint(this.pos.x(), rect.maxY() - this.pos.height() - 1.0f));
        } else if (this.pos.y() <= rect.y()) {
            this.setLocation(new NSPoint(this.pos.x(), rect.y() + 1.0f));
        } else {
            rect = this.game.background().clearRect(this.pos.x(), this.pos.maxX() + 20.0f);
            if (this.pos.maxY() >= rect.maxY() - 2.0f) {
                this.setLocation(new NSPoint(this.pos.x(), this.pos.y() - 1.0f));
            } else if (this.pos.y() < rect.y() + 2.0f) {
                this.setLocation(new NSPoint(this.pos.x(), this.pos.y() + 1.0f));
            } else if (!this.autopilot && Game.oneIn(100)) {
                this.setLocation(new NSPoint(this.pos.x(), this.pos.y() + (float)Game.randInt(2) - 1.0f));
            }
        }
    }
}

