/*
 * Decompiled with CFR 0.152.
 */
import com.apple.cocoa.foundation.NSPoint;
import com.apple.cocoa.foundation.NSSize;

class ArrowBase
extends GamePiece {
    protected int nextFireTime;

    ArrowBase() {
    }

    public int pieceType() {
        return 1;
    }

    public void initInGame(Game g) {
        this.initInGame(g, "arrowbase", 1);
        this.setPerFrameTime(100000000);
    }

    public void explode() {
        ArrowBaseExplosion exp = new ArrowBaseExplosion();
        ((GamePiece)exp).initInGame(this.game);
        this.game.addScore(1);
        this.explode(exp);
    }

    public void updatePiece() {
        Helicopter helicopter = this.game.helicopter();
        if (helicopter != null && this.isInFrontAndWithin(250.0f, helicopter) && this.game.updateTime() > this.nextFireTime) {
            Arrow arrow = new Arrow();
            ((GamePiece)arrow).initInGame(this.game);
            arrow.setVelocity(new NSSize(-90.0f, 0.0f));
            arrow.setLocation(new NSPoint(this.pos.x() - 7.0f, this.pos.y() + 11.0f));
            this.game.addGamePiece(arrow);
            this.game.playEnemyFireSound();
            this.nextFireTime = this.game.updateTime() + 4000;
        }
        super.updatePiece();
    }
}

