local ns = {}
setmetatable(ns, {__index = _G})
desert_barracks = ns;
setfenv(1, ns);

-- The map name and location graphic
map_name = "Barracks"
location_filename = "blank.png"

enemy_ids = {}

-- Allacrost map editor begin. Do not edit this line. --

-- A reference to the C++ MapMode object that was created with this file
map = {}

-- The number of contexts, rows, and columns that compose the map
num_map_contexts = 2
num_tile_cols = 64
num_tile_rows = 64

-- The sound files used on this map.
sound_filenames = {}

-- The music files used as background music on this map.
music_filenames = {}
music_filenames[1] = "mus/Seeking_New_Worlds.ogg"
music_filenames[2] = "mus/Betrayal.ogg"

-- The names of the contexts used to improve Editor user-friendliness
context_names = {}
context_names[1] = "House_Interior"

-- The names of the tilesets used, with the path and file extension omitted
tileset_filenames = {}
tileset_filenames[1] = "desert_ground"
tileset_filenames[2] = "harrvah_house"
tileset_filenames[3] = "mountain_house_interior"

-- The map grid to indicate walkability. The size of the grid is 4x the size of the tile layer tables
-- Walkability status of tiles for 32 contexts. Zero indicates walkable. Valid range: [0:2^32-1]
map_grid = {}
map_grid[0] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2 }
map_grid[1] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2 }
map_grid[2] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2 }
map_grid[3] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2 }
map_grid[4] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2 }
map_grid[5] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2 }
map_grid[6] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2 }
map_grid[7] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2 }
map_grid[8] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2 }
map_grid[9] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2 }
map_grid[10] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2 }
map_grid[11] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2 }
map_grid[12] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2 }
map_grid[13] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2 }
map_grid[14] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2 }
map_grid[15] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2 }
map_grid[16] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2 }
map_grid[17] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2 }
map_grid[18] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2 }
map_grid[19] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2 }
map_grid[20] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2 }
map_grid[21] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2 }
map_grid[22] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 }
map_grid[23] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 }
map_grid[24] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 }
map_grid[25] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 }
map_grid[26] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 }
map_grid[27] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 }
map_grid[28] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 }
map_grid[29] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 }
map_grid[30] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3 }
map_grid[31] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3 }
map_grid[32] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3 }
map_grid[33] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3 }
map_grid[34] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3 }
map_grid[35] = { 2, 2, 2, 2, 2, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3 }
map_grid[36] = { 2, 2, 2, 2, 2, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3 }
map_grid[37] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3 }
map_grid[38] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3 }
map_grid[39] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3 }
map_grid[40] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3 }
map_grid[41] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3 }
map_grid[42] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3 }
map_grid[43] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3 }
map_grid[44] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3 }
map_grid[45] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3 }
map_grid[46] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3 }
map_grid[47] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3 }
map_grid[48] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3 }
map_grid[49] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3 }
map_grid[50] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3 }
map_grid[51] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3 }
map_grid[52] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3 }
map_grid[53] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3 }
map_grid[54] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3 }
map_grid[55] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3 }
map_grid[56] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3 }
map_grid[57] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3 }
map_grid[58] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3 }
map_grid[59] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3 }
map_grid[60] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3 }
map_grid[61] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3 }
map_grid[62] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 }
map_grid[63] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 }
map_grid[64] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 }
map_grid[65] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 }
map_grid[66] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 }
map_grid[67] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 }
map_grid[68] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 }
map_grid[69] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 }
map_grid[70] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 }
map_grid[71] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 }
map_grid[72] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 }
map_grid[73] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 }
map_grid[74] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 }
map_grid[75] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 }
map_grid[76] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 }
map_grid[77] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 }
map_grid[78] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 }
map_grid[79] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 }
map_grid[80] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 }
map_grid[81] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 }
map_grid[82] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 }
map_grid[83] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 }
map_grid[84] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 }
map_grid[85] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 }
map_grid[86] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 }
map_grid[87] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 }
map_grid[88] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 }
map_grid[89] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 }
map_grid[90] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 }
map_grid[91] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 }
map_grid[92] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 }
map_grid[93] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 }
map_grid[94] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 }
map_grid[95] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 }
map_grid[96] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 }
map_grid[97] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 }
map_grid[98] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3 }
map_grid[99] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3 }
map_grid[100] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3 }
map_grid[101] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3 }
map_grid[102] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3 }
map_grid[103] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3 }
map_grid[104] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3 }
map_grid[105] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3 }
map_grid[106] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3 }
map_grid[107] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3 }
map_grid[108] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3 }
map_grid[109] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3 }
map_grid[110] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3 }
map_grid[111] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3 }
map_grid[112] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3 }
map_grid[113] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3 }
map_grid[114] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3 }
map_grid[115] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3 }
map_grid[116] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3 }
map_grid[117] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3 }
map_grid[118] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3 }
map_grid[119] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3 }
map_grid[120] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3 }
map_grid[121] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3 }
map_grid[122] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3 }
map_grid[123] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3 }
map_grid[124] = { 2, 2, 2, 2, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3 }
map_grid[125] = { 2, 2, 2, 2, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3 }
map_grid[126] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 }
map_grid[127] = { 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2 }

-- The lower tile layer. The numbers are indeces to the tile_mappings table.
lower_layer = {}
lower_layer[0] = { 34, 0, 24, 32, 40, 54, 55, 56, 0, 1, 2, 3, 0, 1, 2, 48, 16, 32, 24, 40, 0, 24, 2, 3, 0, 1, 2, 3, 34, 35, 18, 19, 34, 8, 17, 19, 32, 33, 50, 3, 49, 50, 51, 16, 17, 18, 19, 48, 49, 50, 3, 49, 51, 1, 8, 32, 17, 17, 8, 8, 1, 34, 48, 19 }
lower_layer[1] = { 16, 18, 24, 19, 16, 1, 2, 3, 16, 17, 18, 19, 16, 17, 18, 16, 33, 48, 1, 48, 18, 32, 18, 19, 16, 17, 18, 19, 50, 51, 34, 35, 32, 51, 1, 18, 34, 17, 19, 3, 1, 2, 3, 32, 33, 34, 35, 0, 1, 2, 24, 35, 24, 17, 40, 8, 3, 8, 51, 50, 24, 17, 40, 48 }
lower_layer[2] = { 50, 0, 17, 40, 51, 17, 18, 19, 32, 33, 34, 35, 32, 33, 34, 34, 24, 17, 51, 24, 17, 33, 34, 35, 32, 33, 34, 35, 34, 35, 50, 51, 51, 34, 0, 32, 17, 3, 2, 51, 17, 18, 19, 48, 49, 50, 51, 16, 17, 18, 33, 50, 48, 3, 49, 50, 35, 3, 32, 50, 33, 18, 3, 8 }
lower_layer[3] = { 19, 1, 0, 49, 19, 33, 34, 35, 48, 49, 50, 51, 48, 49, 50, 50, 51, 24, 19, 32, 0, 2, 50, 51, 48, 49, 50, 51, 50, 51, 34, 35, 32, 49, 17, 19, 49, 49, 3, 19, 33, 34, 35, 0, 1, 2, 3, 32, 33, 34, 35, 33, 24, 1, 51, 35, 1, 16, 18, 18, 49, 32, 40, 32 }
lower_layer[4] = { 19, 19, 17, 34, 0, 459, 459, 459, 459, 17, 18, 19, 0, 1, 2, 35, 16, 2, 40, 40, 49, 19, 459, 459, 459, 459, 2, 3, 34, 35, 50, 51, 51, 0, 48, 24, 40, 40, 40, 8, 459, 459, 459, 459, 17, 18, 19, 48, 49, 50, 24, 40, 49, 24, 35, 24, 24, 1, 5, 6, 7, 34, 24, 24 }
lower_layer[5] = { 32, 16, 18, 40, 24, 5, 6, 7, 49, 19, 51, 19, 49, 0, 49, 49, 0, 1, 17, 0, 33, 34, 19, 33, 51, 8, 35, 40, 35, 2, 34, 51, 33, 40, 1, 40, 2, 1, 17, 34, 34, 8, 3, 19, 50, 40, 33, 8, 24, 35, 17, 0, 50, 34, 48, 49, 49, 49, 21, 22, 23, 1, 35, 40 }
lower_layer[6] = { 32, 16, 32, 49, 18, 21, 22, 23, 35, 35, 18, 48, 48, 49, 24, 18, 33, 19, 35, 40, 16, 51, 33, 3, 33, 24, 1, 32, 8, 2, 48, 49, 1, 16, 24, 3, 0, 34, 1, 16, 17, 48, 3, 40, 32, 18, 17, 34, 16, 2, 33, 50, 35, 24, 32, 48, 35, 51, 37, 38, 39, 18, 0, 32 }
lower_layer[7] = { 17, 2, 49, 51, 2, 37, 38, 39, 2, 24, 18, 19, 24, 48, 17, 49, 0, 0, 18, 32, 33, 48, 32, 1, 49, 0, 8, 32, 24, 35, 1, 2, 17, 19, 8, 17, 19, 50, 35, 0, 18, 48, 51, 0, 51, 3, 18, 2, 18, 34, 24, 8, 0, 24, 3, 24, 3, 40, 3, 32, 16, 48, 49, 49 }
lower_layer[8] = { 16, 0, 33, 49, 33, 49, 2, 48, 33, 49, 49, 48, 48, 0, 48, 1, 2, 18, 8, 1, 16, 40, 32, 50, 35, 2, 32, 33, 19, 50, 16, 18, 35, 1, 8, 33, 35, 49, 48, 18, 35, 49, 1, 51, 51, 18, 34, 17, 1, 19, 18, 17, 8, 50, 24, 34, 50, 17, 17, 17, 18, 33, 17, 3 }
lower_layer[9] = { 1, 48, 50, 51, 40, 24, 33, 0, 0, 51, 48, 3, 32, 2, 1, 32, 35, 34, 48, 34, 33, 16, 34, 32, 34, 18, 18, 32, 49, 1, 50, 18, 48, 49, 18, 17, 48, 0, 48, 1, 49, 18, 8, 40, 49, 19, 2, 18, 2, 16, 32, 24, 48, 51, 32, 51, 2, 34, 35, 16, 19, 51, 24, 4 }
lower_layer[10] = { 3, 49, 3, 51, 34, 40, 19, 24, 1, 1, 33, 50, 0, 5, 6, 7, 2, 3, 48, 49, 16, 40, 2, 50, 33, 19, 48, 2, 49, 16, 32, 3, 34, 49, 50, 0, 48, 48, 1, 48, 24, 51, 3, 34, 49, 24, 1, 19, 49, 17, 40, 8, 49, 0, 1, 16, 35, 35, 48, 3, 32, 35, 2, 20 }
lower_layer[11] = { 17, 40, 8, 32, 32, 35, 19, 24, 18, 1, 16, 17, 8, 21, 22, 23, 48, 49, 50, 51, 16, 17, 18, 19, 48, 49, 50, 51, 49, 50, 18, 19, 50, 51, 48, 0, 1, 2, 3, 32, 33, 34, 35, 0, 1, 2, 3, 32, 33, 34, 35, 0, 1, 2, 3, 32, 33, 34, 35, 51, 0, 1, 2, 36 }
lower_layer[12] = { 16, 1, 32, 3, 18, 18, 49, 3, 24, 1, 1, 51, 8, 37, 38, 39, 0, 1, 2, 3, 32, 33, 34, 35, 0, 8, 2, 34, 35, 8, 34, 35, 18, 19, 35, 16, 17, 18, 19, 48, 49, 50, 51, 16, 17, 18, 19, 48, 49, 50, 51, 16, 17, 18, 19, 48, 49, 50, 51, 8, 16, 17, 18, 19 }
lower_layer[13] = { 50, 2, 24, 1, 17, 18, 3, 33, 51, 3, 32, 19, 3, 50, 32, 19, 16, 17, 18, 19, 48, 49, 50, 51, 16, 17, 18, 50, 51, 18, 50, 51, 34, 35, 0, 32, 33, 34, 35, 0, 1, 2, 3, 32, 33, 34, 35, 0, 1, 2, 3, 32, 33, 34, 35, 0, 1, 2, 3, 24, 32, 33, 34, 35 }
lower_layer[14] = { 32, 40, 18, 34, 2, 17, 0, 40, 17, 1, 19, 35, 51, 33, 0, 35, 32, 33, 34, 35, 0, 1, 2, 3, 32, 33, 34, 35, 33, 34, 18, 19, 50, 51, 16, 48, 49, 50, 51, 16, 17, 18, 19, 48, 49, 50, 51, 16, 17, 18, 19, 48, 49, 50, 51, 16, 17, 18, 19, 40, 48, 49, 50, 51 }
lower_layer[15] = { 19, 50, 32, 50, 35, 8, 34, 3, 50, 48, 49, 8, 0, 51, 1, 51, 48, 49, 50, 51, 16, 17, 18, 19, 48, 49, 50, 51, 49, 50, 34, 35, 18, 19, 32, 0, 1, 2, 3, 32, 33, 34, 35, 0, 1, 2, 3, 32, 33, 34, 35, 0, 1, 2, 3, 32, 33, 34, 35, 0, 1, 2, 3, 8 }
lower_layer[16] = { 34, 35, 0, 40, 8, 32, 19, 16, 24, 19, 50, 1, 18, 17, 32, 3, 0, 1, 2, 3, 32, 33, 34, 35, 8, 0, 1, 2, 3, 8, 50, 51, 34, 35, 48, 16, 17, 18, 19, 48, 49, 50, 51, 16, 17, 18, 19, 48, 49, 50, 51, 16, 17, 18, 19, 48, 49, 50, 51, 16, 17, 18, 19, 24 }
lower_layer[17] = { 49, 32, 40, 50, 16, 50, 3, 8, 40, 48, 48, 48, 2, 19, 50, 19, 16, 17, 18, 19, 48, 49, 50, 51, 24, 16, 17, 18, 19, 16, 17, 18, 50, 51, 35, 32, 33, 34, 35, 0, 1, 2, 3, 32, 33, 34, 35, 0, 1, 2, 3, 32, 33, 34, 35, 0, 1, 2, 3, 32, 33, 34, 35, 40 }
lower_layer[18] = { 40, 40, 8, 17, 33, 33, 49, 3, 34, 33, 19, 51, 3, 35, 32, 35, 32, 33, 34, 35, 0, 1, 2, 3, 40, 32, 33, 34, 35, 32, 33, 34, 16, 17, 18, 48, 49, 50, 51, 16, 17, 18, 19, 48, 49, 50, 51, 16, 17, 18, 19, 48, 49, 50, 51, 16, 17, 18, 19, 48, 49, 50, 51, 51 }
lower_layer[19] = { 48, 19, 16, 19, 19, 19, 48, 17, 2, 50, 34, 2, 40, 2, 17, 51, 48, 49, 50, 51, 16, 17, 18, 19, 16, 48, 49, 50, 51, 48, 49, 50, 32, 33, 34, 0, 1, 2, 3, 32, 33, 34, 35, 0, 1, 2, 3, 32, 33, 34, 35, 0, 1, 2, 3, 32, 33, 34, 35, 8, 0, 1, 2, 3 }
lower_layer[20] = { 51, 32, 18, 2, 50, 18, 35, 3, 32, 51, 49, 51, 3, 3, 49, 3, 0, 1, 2, 3, 32, 33, 34, 35, 32, 33, 34, 35, 3, 16, 17, 18, 48, 49, 50, 16, 17, 18, 19, 48, 49, 50, 51, 16, 17, 18, 19, 48, 49, 50, 51, 16, 17, 18, 19, 48, 49, 50, 51, 24, 16, 17, 18, 19 }
lower_layer[21] = { 18, 8, 48, 50, 1, 32, 8, 16, 0, 1, 3, 50, 0, 49, 34, 19, 16, 17, 18, 5, 6, 7, 50, 51, 48, 49, 50, 51, 19, 32, 16, 17, 18, 17, 18, 32, 33, 34, 35, 0, 1, 2, 3, 32, 33, 34, 35, 0, 1, 2, 3, 32, 33, 34, 35, 0, 1, 2, 3, 40, 32, 33, 34, 35 }
lower_layer[22] = { 50, 40, 0, 8, 32, 17, 33, 34, 35, 35, 0, 51, 19, 16, 1, 35, 32, 33, 34, 21, 22, 23, 1, 2, 3, 32, 33, 34, 35, 48, 32, 33, 34, 33, 34, 48, 49, 50, 51, 16, 17, 18, 19, 48, 49, 50, 51, 16, 17, 18, 19, 48, 49, 50, 51, 16, 17, 18, 19, 51, 48, 49, 50, 51 }
lower_layer[23] = { 50, 32, 8, 16, 40, 5, 6, 7, 49, 1, 1, 49, 19, 16, 51, 51, 48, 49, 50, 37, 38, 39, 17, 18, 19, 48, 49, 50, 17, 18, 48, 49, 50, 49, 50, 0, 1, 2, 3, 32, 33, 34, 35, 0, 1, 2, 3, 32, 33, 34, 35, 0, 1, 2, 3, 32, 33, 34, 35, 0, 1, 5, 6, 7 }
lower_layer[24] = { 1, 48, 32, 3, 48, 21, 22, 23, 1, 24, 17, 34, 35, 18, 3, 2, 3, 0, 1, 2, 3, 32, 33, 34, 35, 0, 1, 2, 33, 34, 16, 17, 18, 17, 18, 16, 17, 18, 19, 48, 49, 50, 51, 16, 17, 18, 19, 48, 49, 50, 51, 16, 17, 18, 19, 48, 49, 50, 51, 16, 17, 21, 22, 23 }
lower_layer[25] = { 48, 32, 48, 16, 49, 37, 38, 39, 50, 33, 1, 51, 2, 32, 40, 18, 19, 16, 17, 18, 19, 48, 49, 50, 51, 16, 17, 18, 49, 50, 32, 33, 34, 33, 34, 32, 33, 34, 35, 0, 1, 2, 3, 32, 33, 34, 35, 0, 1, 2, 3, 32, 33, 34, 35, 0, 1, 2, 3, 32, 33, 37, 38, 39 }
lower_layer[26] = { 51, 50, 2, 19, 33, 51, 17, 8, 3, 32, 50, 8, 48, 1, 1, 34, 35, 32, 33, 34, 35, 0, 1, 2, 3, 32, 33, 34, 35, 3, 48, 49, 50, 49, 50, 48, 49, 50, 51, 16, 17, 18, 19, 48, 49, 50, 51, 16, 17, 18, 19, 48, 49, 50, 51, 16, 17, 18, 19, 48, 49, 50, 51, 51 }
lower_layer[27] = { 34, 8, 19, 49, 50, 2, 24, 18, 18, 8, 17, 51, 51, 2, 49, 50, 51, 48, 49, 50, 51, 16, 17, 18, 19, 48, 49, 50, 51, 0, 1, 2, 3, 18, 19, 0, 1, 2, 3, 32, 33, 34, 35, 0, 1, 2, 3, 32, 33, 34, 35, 0, 1, 2, 3, 32, 33, 34, 35, 4, 0, 1, 2, 3 }
lower_layer[28] = { 35, 24, 16, 8, 3, 19, 48, 32, 49, 50, 50, 16, 17, 51, 4, 2, 3, 0, 1, 2, 3, 32, 33, 34, 35, 32, 33, 34, 35, 16, 17, 18, 19, 34, 35, 16, 17, 18, 19, 48, 49, 50, 51, 16, 17, 18, 19, 48, 49, 50, 51, 16, 17, 18, 19, 48, 49, 50, 51, 20, 16, 17, 18, 19 }
lower_layer[29] = { 19, 34, 48, 51, 4, 5, 6, 7, 24, 32, 0, 24, 19, 19, 20, 18, 19, 16, 17, 18, 19, 48, 49, 50, 51, 48, 49, 50, 51, 32, 33, 34, 35, 50, 51, 32, 33, 34, 35, 0, 1, 2, 3, 32, 33, 34, 35, 0, 1, 2, 3, 32, 33, 34, 35, 0, 1, 2, 3, 36, 32, 33, 34, 35 }
lower_layer[30] = { 51, 18, 33, 24, 20, 21, 22, 23, 3, 1, 33, 33, 24, 18, 36, 34, 35, 32, 33, 459, 35, 0, 1, 2, 3, 0, 1, 2, 3, 48, 49, 50, 51, 8, 8, 48, 49, 50, 51, 16, 17, 18, 19, 48, 49, 50, 51, 16, 17, 18, 19, 48, 49, 50, 51, 16, 17, 18, 19, 40, 48, 49, 50, 51 }
lower_layer[31] = { 33, 34, 2, 33, 36, 37, 38, 39, 34, 18, 32, 1, 35, 24, 49, 460, 459, 459, 459, 459, 459, 459, 459, 459, 459, 459, 459, 459, 459, 459, 459, 459, 3, 18, 19, 0, 1, 2, 3, 32, 33, 34, 35, 0, 1, 2, 3, 460, 33, 34, 35, 0, 1, 2, 3, 32, 33, 34, 35, 0, 1, 2, 3, 8 }
lower_layer[32] = { 35, 16, 40, 35, 52, 53, 54, 55, 56, 50, 50, 24, 17, 2, 50, 1, 32, 16, 51, 3, 40, 51, 16, 33, 49, 8, 8, 40, 50, 1, 17, 18, 19, 34, 35, 16, 17, 18, 19, 48, 49, 50, 51, 16, 17, 18, 19, 48, 49, 50, 51, 16, 17, 18, 19, 48, 49, 50, 51, 16, 17, 18, 19, 24 }
lower_layer[33] = { 49, 17, 40, 16, 16, 34, 17, 34, 0, 2, 24, 34, 17, 16, 18, 2, 32, 40, 48, 34, 18, 40, 8, 19, 34, 24, 1, 49, 4, 32, 33, 34, 35, 50, 51, 32, 33, 34, 35, 0, 1, 2, 3, 32, 33, 34, 35, 0, 1, 2, 3, 32, 33, 34, 35, 0, 1, 2, 3, 32, 33, 34, 35, 40 }
lower_layer[34] = { 24, 16, 49, 32, 17, 8, 18, 51, 33, 33, 49, 2, 1, 35, 2, 18, 48, 48, 3, 17, 33, 49, 1, 32, 1, 24, 49, 40, 20, 48, 49, 50, 51, 8, 8, 48, 49, 50, 51, 16, 17, 18, 19, 48, 49, 50, 51, 16, 17, 18, 19, 48, 49, 50, 51, 16, 17, 18, 19, 8, 49, 50, 51, 4 }
lower_layer[35] = { 35, 24, 1, 48, 40, 19, 51, 24, 18, 2, 18, 50, 19, 51, 0, 16, 19, 2, 2, 24, 40, 3, 40, 48, 24, 8, 34, 3, 36, 1, 2, 3, 8, 18, 19, 0, 1, 2, 3, 32, 33, 34, 35, 0, 1, 2, 3, 32, 33, 34, 35, 0, 1, 2, 3, 32, 33, 34, 35, 24, 32, 33, 34, 20 }
lower_layer[36] = { 48, 49, 50, 51, 48, 49, 50, 51, 32, 33, 34, 35, 53, 54, 55, 56, 53, 54, 55, 56, 32, 17, 0, 40, 33, 24, 50, 35, 49, 17, 18, 19, 24, 34, 35, 16, 17, 18, 19, 48, 49, 50, 51, 16, 17, 18, 19, 48, 49, 50, 51, 16, 17, 18, 19, 48, 49, 50, 51, 40, 48, 49, 50, 36 }
lower_layer[37] = { 8, 32, 17, 49, 40, 17, 40, 35, 32, 32, 18, 17, 51, 19, 8, 24, 32, 35, 8, 16, 33, 24, 2, 35, 0, 0, 3, 1, 32, 33, 34, 35, 40, 50, 51, 32, 33, 34, 35, 32, 33, 34, 35, 32, 33, 34, 35, 32, 33, 34, 35, 32, 33, 34, 35, 32, 33, 34, 35, 32, 33, 34, 35, 32 }
lower_layer[38] = { 34, 3, 24, 50, 3, 50, 48, 50, 35, 33, 33, 16, 2, 32, 18, 8, 51, 49, 16, 34, 8, 17, 1, 50, 0, 24, 3, 24, 17, 49, 50, 51, 3, 8, 8, 48, 49, 50, 51, 48, 49, 50, 51, 48, 49, 50, 51, 48, 49, 50, 51, 48, 49, 50, 51, 48, 49, 50, 51, 48, 49, 50, 51, 48 }
lower_layer[39] = { 17, 40, 51, 48, 33, 51, 40, 3, 34, 49, 40, 24, 8, 40, 51, 33, 2, 1, 24, 32, 33, 17, 24, 3, 16, 51, 0, 19, 49, 2, 3, 0, 1, 2, 3, 0, 1, 2, 3, 0, 1, 2, 3, 0, 1, 2, 3, 0, 1, 2, 3, 0, 1, 2, 3, 0, 1, 2, 3, 0, 1, 2, 3, 0 }
lower_layer[40] = { 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66 }
lower_layer[41] = { 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82 }
lower_layer[42] = { 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98 }
lower_layer[43] = { 35, 18, 24, 51, 18, 24, 16, 18, 19, 48, 16, 35, 3, 49, 3, 16, 48, 48, 3, 33, 18, 18, 37, 38, 39, 33, 40, 32, 8, 2, 3, 16, 17, 18, 19, 0, 1, 2, 3, 32, 33, 34, 35, 0, 1, 2, 3, 32, 33, 34, 35, 0, 1, 2, 3, 32, 33, 34, 35, 0, 1, 2, 3, 32 }
lower_layer[44] = { 49, 2, 3, 48, 35, 24, 51, 50, 3, 1, 16, 3, 3, 0, 1, 8, 17, 40, 17, 48, 3, 35, 40, 40, 17, 18, 2, 51, 32, 18, 19, 32, 33, 34, 35, 16, 17, 18, 19, 48, 49, 50, 51, 16, 17, 18, 19, 48, 49, 50, 51, 16, 17, 18, 19, 48, 49, 50, 51, 16, 17, 18, 19, 48 }
lower_layer[45] = { 35, 17, 51, 3, 16, 49, 8, 50, 35, 2, 3, 40, 40, 18, 48, 0, 35, 1, 50, 50, 33, 33, 33, 2, 16, 34, 51, 19, 51, 16, 35, 48, 49, 50, 51, 32, 33, 34, 35, 0, 1, 2, 3, 32, 33, 34, 35, 0, 1, 2, 3, 32, 33, 34, 35, 0, 1, 2, 3, 32, 33, 34, 35, 0 }
lower_layer[46] = { 50, 3, 1, 3, 17, 18, 48, 0, 3, 18, 34, 17, 0, 1, 19, 0, 40, 19, 16, 24, 34, 50, 17, 24, 24, 48, 32, 49, 34, 1, 51, 0, 1, 2, 3, 48, 49, 50, 51, 16, 17, 18, 19, 48, 49, 50, 51, 16, 17, 18, 19, 48, 49, 50, 51, 16, 17, 18, 19, 48, 49, 50, 51, 16 }
lower_layer[47] = { 35, 32, 51, 49, 35, 18, 33, 8, 2, 32, 18, 18, 8, 51, 32, 48, 24, 1, 17, 16, 19, 49, 17, 35, 1, 2, 19, 19, 32, 18, 3, 16, 17, 18, 19, 0, 1, 2, 3, 32, 33, 34, 35, 0, 1, 2, 3, 32, 33, 34, 35, 0, 1, 2, 3, 32, 33, 34, 35, 0, 1, 2, 3, 32 }
lower_layer[48] = { 50, 40, 16, 40, 1, 18, 32, 17, 19, 8, 40, 24, 0, 1, 50, 34, 0, 17, 0, 32, 50, 3, 33, 33, 24, 16, 51, 18, 33, 40, 19, 32, 33, 34, 35, 16, 17, 18, 19, 48, 49, 50, 51, 16, 17, 18, 19, 48, 49, 50, 51, 16, 17, 18, 19, 48, 49, 50, 51, 16, 17, 18, 19, 48 }
lower_layer[49] = { 18, 8, 48, 48, 3, 18, 16, 1, 24, 0, 51, 48, 32, 2, 40, 1, 2, 3, 32, 33, 34, 35, 40, 48, 49, 50, 51, 32, 33, 34, 35, 48, 49, 50, 51, 32, 33, 34, 35, 0, 1, 2, 3, 32, 33, 34, 35, 0, 1, 2, 3, 32, 33, 34, 35, 0, 1, 2, 3, 32, 33, 34, 35, 0 }
lower_layer[50] = { 2, 24, 18, 8, 50, 48, 18, 18, 3, 3, 51, 50, 35, 51, 35, 17, 18, 19, 48, 49, 50, 51, 0, 1, 2, 3, 8, 48, 49, 50, 51, 0, 1, 2, 3, 48, 49, 50, 51, 16, 17, 18, 19, 48, 49, 50, 51, 16, 17, 18, 19, 48, 49, 50, 51, 16, 17, 18, 19, 48, 49, 50, 51, 16 }
lower_layer[51] = { 24, 24, 32, 32, 34, 1, 2, 1, 49, 48, 51, 34, 24, 17, 40, 33, 34, 35, 0, 1, 2, 3, 16, 17, 18, 19, 24, 1, 2, 3, 8, 16, 17, 18, 19, 0, 1, 2, 3, 32, 33, 34, 35, 0, 1, 2, 3, 32, 33, 34, 35, 0, 1, 2, 3, 32, 33, 34, 35, 48, 49, 50, 51, 32 }
lower_layer[52] = { 35, 1, 40, 3, 49, 8, 50, 3, 0, 51, 32, 50, 3, 35, 48, 49, 50, 8, 16, 17, 18, 19, 32, 33, 34, 35, 40, 17, 18, 19, 24, 32, 33, 34, 35, 16, 17, 18, 19, 48, 49, 50, 51, 16, 17, 18, 19, 48, 49, 50, 51, 16, 17, 18, 19, 48, 49, 50, 51, 0, 1, 2, 3, 48 }
lower_layer[53] = { 0, 2, 35, 2, 19, 0, 1, 24, 51, 33, 48, 1, 51, 51, 18, 2, 3, 24, 32, 33, 34, 35, 48, 49, 50, 51, 32, 33, 34, 35, 40, 48, 49, 50, 51, 32, 33, 34, 35, 0, 1, 2, 3, 32, 33, 34, 35, 0, 1, 2, 3, 32, 33, 34, 35, 0, 1, 2, 3, 16, 17, 18, 19, 0 }
lower_layer[54] = { 53, 54, 55, 56, 17, 2, 1, 33, 50, 16, 1, 17, 16, 24, 1, 18, 19, 40, 48, 49, 50, 51, 0, 1, 2, 3, 48, 0, 1, 2, 3, 0, 1, 2, 3, 48, 49, 50, 51, 16, 17, 18, 19, 48, 49, 50, 51, 16, 17, 18, 19, 48, 49, 50, 51, 16, 17, 18, 19, 32, 33, 34, 35, 16 }
lower_layer[55] = { 17, 50, 48, 51, 0, 32, 49, 8, 2, 18, 16, 51, 19, 1, 34, 34, 35, 3, 0, 1, 2, 3, 16, 0, 1, 2, 3, 16, 17, 18, 19, 16, 17, 18, 19, 0, 1, 2, 3, 32, 33, 34, 35, 0, 1, 2, 3, 32, 33, 34, 35, 0, 1, 2, 3, 32, 33, 34, 35, 48, 49, 50, 51, 32 }
lower_layer[56] = { 8, 16, 49, 2, 48, 8, 2, 18, 24, 2, 50, 8, 18, 18, 18, 50, 51, 19, 16, 17, 18, 19, 32, 16, 17, 18, 19, 32, 33, 34, 35, 32, 33, 34, 35, 16, 17, 18, 19, 48, 49, 50, 51, 16, 17, 18, 19, 48, 49, 50, 51, 16, 17, 18, 19, 48, 49, 50, 51, 0, 1, 2, 3, 48 }
lower_layer[57] = { 16, 18, 40, 24, 48, 33, 16, 3, 35, 48, 24, 40, 2, 18, 1, 33, 34, 35, 32, 33, 34, 35, 8, 32, 33, 34, 35, 48, 49, 50, 51, 48, 49, 50, 51, 32, 33, 34, 35, 0, 1, 2, 3, 32, 33, 34, 35, 0, 1, 2, 3, 32, 33, 34, 35, 0, 1, 2, 3, 16, 17, 18, 19, 0 }
lower_layer[58] = { 17, 2, 2, 2, 50, 49, 33, 18, 50, 40, 1, 32, 40, 32, 33, 49, 50, 51, 48, 49, 50, 51, 24, 48, 49, 50, 51, 0, 1, 2, 3, 0, 1, 2, 3, 48, 49, 50, 51, 16, 17, 18, 19, 0, 1, 2, 3, 16, 17, 18, 19, 48, 49, 50, 51, 16, 17, 18, 19, 32, 33, 34, 35, 16 }
lower_layer[59] = { 35, 2, 48, 32, 3, 17, 33, 8, 8, 8, 2, 48, 34, 34, 34, 54, 55, 33, 0, 1, 2, 3, 40, 0, 1, 2, 3, 16, 17, 18, 19, 16, 17, 18, 19, 0, 1, 2, 3, 32, 33, 34, 35, 16, 17, 18, 19, 32, 33, 34, 35, 0, 1, 2, 3, 32, 33, 34, 35, 48, 49, 50, 51, 32 }
lower_layer[60] = { 40, 48, 3, 35, 1, 3, 8, 34, 24, 1, 40, 1, 19, 48, 50, 1, 2, 3, 16, 17, 18, 19, 18, 16, 17, 18, 19, 32, 33, 34, 35, 32, 33, 34, 35, 16, 17, 18, 19, 48, 49, 50, 51, 32, 33, 34, 35, 48, 49, 50, 51, 16, 17, 18, 19, 48, 49, 50, 51, 0, 1, 2, 3, 48 }
lower_layer[61] = { 24, 50, 16, 51, 1, 19, 2, 48, 8, 0, 33, 16, 24, 40, 2, 17, 18, 19, 8, 33, 34, 35, 34, 32, 33, 34, 35, 48, 49, 50, 51, 48, 49, 50, 51, 32, 33, 34, 35, 0, 1, 2, 3, 48, 49, 50, 51, 0, 1, 2, 3, 32, 33, 34, 35, 0, 1, 2, 3, 16, 17, 18, 19, 16 }
lower_layer[62] = { 40, 34, 35, 32, 24, 8, 24, 24, 19, 32, 16, 1, 1, 18, 33, 33, 34, 35, 24, 49, 50, 51, 50, 48, 49, 50, 51, 0, 1, 2, 3, 0, 1, 2, 3, 48, 49, 50, 51, 16, 17, 18, 19, 0, 1, 2, 3, 16, 17, 18, 19, 48, 49, 50, 51, 16, 17, 18, 19, 32, 33, 34, 35, 0 }
lower_layer[63] = { 2, 48, 0, 3, 17, 34, 49, 17, 40, 2, 17, 1, 16, 35, 50, 459, 459, 459, 459, 459, 459, 459, 459, 459, 459, 459, 459, 459, 459, 459, 459, 459, 459, 459, 459, 459, 459, 459, 459, 459, 459, 459, 459, 459, 459, 459, 19, 32, 33, 34, 35, 0, 1, 2, 3, 32, 33, 34, 35, 48, 49, 50, 51, 16 }

-- The middle tile layer. The numbers are indeces to the tile_mappings table.
middle_layer = {}
middle_layer[0] = { -1, 203, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[1] = { -1, -1, -1, -1, -1, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, -1, -1, -1, -1, -1, -1, -1, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, -1, -1, -1, -1, -1, -1, -1, -1, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, -1, -1, -1, -1, 235, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[2] = { -1, -1, -1, -1, 369, 370, 371, 372, 373, 374, 375, 376, 377, 378, 379, -1, -1, -1, -1, -1, -1, 369, 370, 371, 372, 373, 374, 375, 376, 377, 378, 379, -1, -1, -1, -1, -1, -1, -1, 369, 370, 371, 372, 373, 374, 375, 376, 377, 378, 379, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[3] = { -1, -1, -1, -1, 385, 386, 387, 388, 389, 390, 391, 392, 393, 394, 395, -1, -1, -1, -1, -1, -1, 385, 386, 387, 388, 389, 390, 391, 392, 393, 394, 395, -1, -1, -1, -1, -1, -1, -1, 385, 386, 387, 388, 389, 390, 391, 392, 393, 394, 395, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[4] = { -1, -1, -1, -1, 401, 402, 403, 404, 405, 406, 407, 408, 409, 410, 411, -1, -1, -1, -1, -1, -1, 401, 402, 403, 404, 405, 406, 407, 408, 409, 410, 411, -1, -1, -1, -1, -1, -1, -1, 401, 402, 403, 404, 405, 406, 407, 408, 409, 410, 411, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[5] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[6] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 203, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 219, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 250, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 235, -1, -1, -1 }
middle_layer[7] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[8] = { -1, -1, -1, -1, -1, -1, -1, 235, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 219, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 203, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[9] = { -1, -1, -1, 219, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[10] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 250, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 235, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[11] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[12] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 219, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[13] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[14] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 235, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[15] = { -1, -1, -1, -1, -1, -1, 219, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[16] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[17] = { -1, -1, 232, 233, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[18] = { -1, -1, 248, 249, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[19] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[20] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[21] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[22] = { -1, -1, -1, -1, -1, -1, -1, -1, 253, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[23] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[24] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[25] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[26] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[27] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 340, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[28] = { -1, -1, -1, 219, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 354, 355, 356, 355, 356, 355, 356, 355, 356, 355, 356, 355, 356, 355, 356, 355, 357, 358, 359, 360, 361, 362, 361, 362, 361, 362, 361, 362, 361, 362, 361, 362, 363, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[29] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, 235, -1, -1, -1, -1, 369, 370, 371, 372, 371, 372, 371, 372, 371, 372, 371, 372, 371, 372, 371, 372, 371, 373, 374, 375, 376, 377, 378, 377, 378, 377, 378, 377, 378, 377, 378, 377, 378, 379, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[30] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 385, 386, 387, 388, 387, 388, 387, 388, 387, 388, 387, 388, 387, 388, 387, 388, 387, 389, 390, 391, 392, 393, 394, 393, 394, 393, 394, 393, 394, 393, 394, 393, 394, 395, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[31] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 219, -1, -1, 401, 402, 403, 404, 403, 404, 403, 404, 403, 404, 403, 404, 403, 404, 403, 404, 403, 405, 406, 407, 408, 409, 410, 409, 410, 409, 410, 409, 410, 409, 410, 409, 410, 411, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[32] = { -1, -1, 235, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[33] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 235, -1, -1, -1, -1, -1, -1, 232, 233, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[34] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 248, 249, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[35] = { -1, -1, -1, -1, -1, -1, -1, -1, 219, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[36] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 219, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[37] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 551, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[38] = { -1, -1, -1, -1, -1, 235, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 251, -1, -1, -1, -1, -1, -1, -1, -1, 567, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[39] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 203, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 583, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[40] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[41] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[42] = { -1, -1, -1, -1, -1, -1, -1, 219, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 551, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[43] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 567, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[44] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 235, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 583, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[45] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 219, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[46] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[47] = { -1, -1, 219, -1, -1, -1, -1, -1, -1, -1, 235, -1, -1, -1, -1, -1, -1, 203, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 235, -1, -1, -1, -1, -1, -1, 232, 233, -1, -1, -1, -1, -1, -1 }
middle_layer[48] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 248, 249, -1, -1, -1, -1, -1, -1 }
middle_layer[49] = { -1, -1, -1, -1, 235, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[50] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[51] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[52] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[53] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 203, -1, -1, -1, -1, -1, -1 }
middle_layer[54] = { -1, -1, -1, -1, -1, -1, -1, -1, 235, -1, -1, -1, 219, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[55] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 219, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[56] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[57] = { -1, -1, 219, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[58] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 329, 330, 329, 330, 329, 330, 329, 330, 329, 330, 329, 330, 329, 330, 329, 330, 329, 330 }
middle_layer[59] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 345, 346, 345, 346, 345, 346, 345, 346, 345, 346, 345, 346, 345, 346, 345, 346, 345, 346 }
middle_layer[60] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 203, -1, -1, 354, 355, 356, 355, 356, 355, 356, 355, 356, 355, 356, 355, 356, 355, 356, 355, 356, 355, 356, 355, 356, 355, 356, 355, 356, 355, 356, 355, 356, 355, 356, 361, 362, 361, 362, 361, 362, 361, 362, 361, 362, 361, 362, 361, 362, 361, 362, 361, 362 }
middle_layer[61] = { -1, -1, 0, -1, -1, -1, 235, -1, -1, -1, -1, -1, -1, -1, 369, 370, 371, 372, 371, 372, 371, 372, 371, 372, 371, 372, 371, 372, 371, 372, 371, 372, 371, 372, 371, 372, 371, 372, 371, 372, 371, 372, 371, 372, 371, 372, 377, 378, 377, 378, 377, 378, 377, 378, 377, 378, 377, 378, 377, 378, 377, 378, 377, 378 }
middle_layer[62] = { -1, -1, 250, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 385, 386, 387, 388, 387, 388, 387, 388, 387, 388, 387, 388, 387, 388, 387, 388, 387, 388, 387, 388, 387, 388, 387, 388, 387, 388, 387, 388, 387, 388, 387, 388, 393, 394, 393, 394, 393, 394, 393, 394, 393, 394, 393, 394, 393, 394, 393, 394, 393, 394 }
middle_layer[63] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 401, 402, 403, 404, 403, 404, 403, 404, 403, 404, 403, 404, 403, 404, 403, 404, 403, 404, 403, 404, 403, 404, 403, 404, 403, 404, 403, 404, 403, 404, 403, 404, 409, 410, 409, 410, 409, 410, 409, 410, 409, 410, 409, 410, 409, 410, 409, 410, 409, 410 }

-- The upper tile layer. The numbers are indeces to the tile_mappings table.
upper_layer = {}
upper_layer[0] = { -1, -1, -1, -1, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346, 347, 348, -1, -1, -1, -1, -1, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346, 347, 348, -1, -1, -1, -1, -1, -1, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346, 347, 348, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[1] = { -1, -1, -1, -1, 353, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 364, -1, -1, -1, -1, -1, 353, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 364, -1, -1, -1, -1, -1, -1, 353, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 364, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[2] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[3] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[4] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[5] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 234, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[6] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[7] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[8] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[9] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 234, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[10] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[11] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 289, 290, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291 }
upper_layer[12] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 305, 466, 307, 307, 307, 292, 293, 307, 307, 307, 307, 292, 293, 307, 307, 307, 307, 292, 293, 307, 307, 307, 307, 292, 293, 307, 307, 307, 307, 292, 293, 307, 467, 467, 467, 292, 293, 467, 467, 467, 467, 292, 293, 467, 467, 467, 467, 292, 293, 467 }
upper_layer[13] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 321, 466, 291, 291, 291, 308, 309, 291, 291, 307, 291, 308, 309, 291, 291, 291, 291, 308, 309, 291, 291, 291, 307, 308, 309, 307, 291, 291, 291, 308, 309, 291, 291, 291, 291, 308, 309, 291, 291, 291, 291, 308, 309, 291, 291, 291, 291, 308, 309, 291 }
upper_layer[14] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 321, 466, 292, 293, 291, 291, 307, 307, 292, 293, 291, 291, 291, 291, 291, 291, 291, 291, 307, 307, 291, 291, 291, 291, 291, 291, 291, 291, 291, 307, 291, 307, 292, 293, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291 }
upper_layer[15] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 321, 466, 308, 309, 291, 291, 291, 291, 308, 309, 307, 291, 291, 291, 291, 291, 291, 291, 307, 291, 291, 291, 291, 291, 307, 291, 291, 291, 291, 291, 307, 291, 308, 309, 291, 291, 307, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291 }
upper_layer[16] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 321, 466, 291, 291, 307, 291, 291, 307, 291, 291, 291, 292, 293, 307, 307, 291, 307, 292, 293, 291, 291, 291, 307, 291, 291, 291, 307, 307, 307, 292, 293, 291, 467, 467, 291, 291, 291, 291, 291, 307, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291 }
upper_layer[17] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 321, 466, 291, 291, 307, 291, 291, 291, 307, 291, 291, 308, 309, 291, 307, 291, 291, 308, 309, 307, 291, 291, 291, 291, 291, 307, 291, 307, 291, 308, 309, 291, 467, 467, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291 }
upper_layer[18] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 321, 466, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 307, 291, 291, 291, 291, 291, 291, 307, 291, 291, 291, 291, 291, 307, 307, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291 }
upper_layer[19] = { -1, -1, -1, -1, -1, -1, -1, 204, 205, 206, 207, -1, -1, -1, 321, 466, 291, 291, 291, 291, 291, 307, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 307, 291, 291, 307, 291, 307, 291, 291, 291, 291, 307, 307, 307, 291, 291, 291, 291, 291, 307, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291 }
upper_layer[20] = { -1, -1, -1, -1, -1, -1, -1, 220, 221, 222, 223, -1, -1, -1, 321, 466, 307, 291, 291, 292, 293, 291, 307, 307, 291, 291, 291, 307, 291, 291, 291, 291, 291, 291, 291, 307, 291, 292, 293, 291, 307, 307, 291, 292, 293, 291, 291, 467, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291 }
upper_layer[21] = { -1, -1, -1, -1, -1, -1, -1, 236, 237, 238, 239, -1, -1, -1, 321, 466, 291, 291, 291, 308, 309, 291, 307, 291, 291, 291, 291, 307, 291, 307, 291, 291, 291, 291, 291, 291, 291, 308, 309, 307, 291, 291, 307, 308, 309, 291, 291, 467, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291 }
upper_layer[22] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 321, 466, 292, 293, 291, 291, 291, 291, 292, 293, 291, 291, 291, 291, 291, 291, 291, 291, 291, 307, 292, 293, 307, 291, 291, 307, 291, 291, 291, 291, 291, 307, 292, 293, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291 }
upper_layer[23] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 321, 466, 308, 309, 291, 291, 291, 291, 308, 309, 307, 291, 291, 291, 291, 291, 307, 291, 291, 307, 308, 309, 291, 307, 291, 291, 291, 291, 291, 291, 291, 307, 308, 309, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291 }
upper_layer[24] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 321, 466, 307, 291, 307, 292, 293, 291, 307, 307, 291, 292, 293, 291, 291, 307, 291, 292, 293, 291, 291, 307, 291, 291, 291, 291, 307, 291, 307, 292, 293, 291, 291, 291, 291, 291, 291, 291, 307, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291 }
upper_layer[25] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 321, 306, 291, 307, 291, 308, 309, 307, 291, 307, 307, 308, 309, 307, 291, 291, 307, 308, 309, 291, 291, 307, 291, 291, 291, 307, 291, 291, 307, 308, 309, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291 }
upper_layer[26] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 321, 322, 323, 324, 323, 324, 323, 324, 323, 324, 323, 324, 323, 324, 324, 325, 326, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291 }
upper_layer[27] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 337, 338, 339, 340, 339, 340, 339, 340, 339, 340, 339, 340, 339, 340, 340, 341, 466, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 307, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291 }
upper_layer[28] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 353, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 321, 466, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 307, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291 }
upper_layer[29] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 321, 466, 291, 291, 292, 293, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291 }
upper_layer[30] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 321, 466, 291, 291, 308, 309, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291 }
upper_layer[31] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 321, 466, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291 }
upper_layer[32] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 321, 466, 291, 291, 291, 291, 291, 291, 291, 291, 291, 307, 291, 291, 291, 291, 291, 291, 291, 307, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291 }
upper_layer[33] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 321, 466, 291, 291, 292, 293, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 307, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291 }
upper_layer[34] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 321, 466, 291, 291, 308, 309, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291 }
upper_layer[35] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 321, 466, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 307, 291, 307, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291 }
upper_layer[36] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 321, 466, 291, 291, 292, 293, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291 }
upper_layer[37] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 321, 466, 291, 291, 308, 309, 291, 291, 291, 307, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 307, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291 }
upper_layer[38] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 321, 466, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291 }
upper_layer[39] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 321, 466, 291, 291, 291, 291, 291, 291, 291, 291, 307, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291 }
upper_layer[40] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 321, 466, 291, 291, 292, 293, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 307, 307, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291 }
upper_layer[41] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 321, 466, 291, 291, 308, 309, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 307, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291 }
upper_layer[42] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 321, 466, 307, 291, 291, 291, 291, 291, 291, 291, 291, 291, 307, 291, 291, 291, 307, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291 }
upper_layer[43] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 321, 466, 291, 291, 292, 293, 291, 291, 291, 291, 291, 291, 307, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 307, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291 }
upper_layer[44] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 321, 466, 291, 291, 308, 309, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 307, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291 }
upper_layer[45] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 321, 466, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291 }
upper_layer[46] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 321, 466, 291, 291, 292, 293, 291, 291, 291, 291, 307, 291, 291, 291, 291, 291, 307, 291, 291, 307, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291 }
upper_layer[47] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 321, 466, 291, 291, 308, 309, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 307, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291 }
upper_layer[48] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 321, 466, 291, 307, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 307, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291 }
upper_layer[49] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 289, 290, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 307, 307, 291, 291, 292, 293, 291, 291, 307, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 307, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291 }
upper_layer[50] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 305, 466, 307, 292, 293, 307, 292, 293, 307, 292, 293, 307, 292, 293, 307, 292, 293, 291, 291, 308, 309, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 307, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291 }
upper_layer[51] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 321, 466, 291, 308, 309, 291, 308, 309, 291, 308, 309, 291, 308, 309, 291, 308, 309, 291, 291, 291, 291, 291, 291, 291, 291, 291, 307, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291 }
upper_layer[52] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 321, 466, 291, 291, 291, 291, 291, 291, 291, 291, 291, 307, 291, 291, 291, 291, 291, 291, 291, 291, 307, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 307, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291 }
upper_layer[53] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 321, 466, 291, 291, 291, 291, 291, 291, 307, 291, 291, 291, 291, 291, 291, 307, 291, 291, 291, 291, 291, 291, 291, 307, 291, 291, 291, 291, 307, 291, 307, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291 }
upper_layer[54] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 321, 466, 291, 291, 292, 293, 291, 291, 291, 291, 292, 293, 291, 291, 292, 293, 291, 291, 307, 291, 291, 291, 292, 293, 291, 307, 291, 291, 291, 291, 291, 291, 292, 293, 291, 291, 291, 291, 291, 307, 292, 293, 291, 291, 291, 291, 292, 293, 291, 291 }
upper_layer[55] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 321, 466, 291, 291, 308, 309, 291, 307, 291, 291, 308, 309, 291, 291, 308, 309, 291, 291, 307, 291, 291, 291, 308, 309, 291, 291, 291, 291, 291, 291, 291, 291, 308, 309, 291, 291, 291, 291, 291, 291, 308, 309, 291, 291, 291, 291, 308, 309, 291, 291 }
upper_layer[56] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 321, 466, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 307, 291, 291, 291, 291, 291, 291, 291, 307, 291, 291, 291, 291, 291, 307, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291 }
upper_layer[57] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 321, 306, 307, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291 }
upper_layer[58] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 321, 322, 323, 324, 323, 324, 323, 324, 323, 324, 323, 324, 323, 324, 323, 324, 323, 324, 323, 324, 323, 324, 323, 324, 323, 324, 323, 324, 323, 324, 323, 324, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[59] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 337, 338, 339, 340, 339, 340, 339, 340, 339, 340, 339, 340, 339, 340, 339, 340, 339, 340, 339, 340, 339, 340, 339, 340, 339, 340, 339, 340, 339, 340, 339, 340, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[60] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 353, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[61] = { -1, -1, 234, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[62] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[63] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }

-- All, if any, existing contexts follow.
context_01 = { 0, 0, 0, -1, 0, 0, 1, -1, 0, 0, 2, -1, 0, 0, 3, -1, 0, 0, 4, -1, 0, 0, 5, -1, 0, 0, 6, -1, 0, 0, 7, -1, 0, 0, 8, -1, 0, 0, 9, -1, 0, 0, 10, -1, 0, 0, 11, -1, 0, 0, 12, -1, 0, 0, 13, -1, 0, 0, 14, -1, 0, 0, 15, -1, 0, 0, 16, -1, 0, 0, 17, -1, 0, 0, 18, -1, 0, 0, 19, -1, 0, 0, 20, -1, 0, 0, 21, -1, 0, 0, 22, -1, 0, 0, 23, -1, 0, 0, 24, -1, 0, 0, 25, -1, 0, 0, 26, -1, 0, 0, 27, -1, 0, 0, 28, -1, 0, 0, 29, -1, 0, 0, 30, -1, 0, 0, 31, -1, 0, 0, 32, -1, 0, 0, 33, -1, 0, 0, 34, -1, 0, 0, 35, -1, 0, 0, 36, -1, 0, 0, 37, -1, 0, 0, 38, -1, 0, 0, 39, -1, 0, 0, 40, -1, 0, 0, 41, -1, 0, 0, 42, -1, 0, 0, 43, -1, 0, 0, 44, -1, 0, 0, 45, -1, 0, 0, 46, -1, 0, 0, 47, -1, 0, 0, 48, -1, 0, 0, 49, -1, 0, 0, 50, -1, 0, 0, 51, -1, 0, 0, 52, -1, 0, 0, 53, -1, 0, 0, 54, -1, 0, 0, 55, -1, 0, 0, 56, -1, 0, 0, 57, -1, 0, 0, 58, -1, 0, 0, 59, -1, 0, 0, 60, -1, 0, 0, 61, -1, 0, 0, 62, -1, 0, 0, 63, -1, 0, 1, 0, -1, 0, 1, 1, -1, 0, 1, 2, -1, 0, 1, 3, -1, 0, 1, 4, -1, 0, 1, 5, -1, 0, 1, 6, -1, 0, 1, 7, -1, 0, 1, 8, -1, 0, 1, 9, -1, 0, 1, 10, -1, 0, 1, 11, -1, 0, 1, 12, -1, 0, 1, 13, -1, 0, 1, 14, -1, 0, 1, 15, -1, 0, 1, 16, -1, 0, 1, 17, -1, 0, 1, 18, -1, 0, 1, 19, -1, 0, 1, 20, -1, 0, 1, 21, -1, 0, 1, 22, -1, 0, 1, 23, -1, 0, 1, 24, -1, 0, 1, 25, -1, 0, 1, 26, -1, 0, 1, 27, -1, 0, 1, 28, -1, 0, 1, 29, -1, 0, 1, 30, -1, 0, 1, 31, -1, 0, 1, 32, -1, 0, 1, 33, -1, 0, 1, 34, -1, 0, 1, 35, -1, 0, 1, 36, -1, 0, 1, 37, -1, 0, 1, 38, -1, 0, 1, 39, -1, 0, 1, 40, -1, 0, 1, 41, -1, 0, 1, 42, -1, 0, 1, 43, -1, 0, 1, 44, -1, 0, 1, 45, -1, 0, 1, 46, -1, 0, 1, 47, -1, 0, 1, 48, -1, 0, 1, 49, -1, 0, 1, 50, -1, 0, 1, 51, -1, 0, 1, 52, -1, 0, 1, 53, -1, 0, 1, 54, -1, 0, 1, 55, -1, 0, 1, 56, -1, 0, 1, 57, -1, 0, 1, 58, -1, 0, 1, 59, -1, 0, 1, 60, -1, 0, 1, 61, -1, 0, 1, 62, -1, 0, 1, 63, -1, 0, 2, 0, -1, 0, 2, 1, -1, 0, 2, 2, -1, 0, 2, 3, -1, 0, 2, 4, -1, 0, 2, 5, -1, 0, 2, 6, -1, 0, 2, 7, -1, 0, 2, 8, -1, 0, 2, 9, -1, 0, 2, 10, -1, 0, 2, 11, -1, 0, 2, 12, -1, 0, 2, 13, -1, 0, 2, 14, -1, 0, 2, 15, -1, 0, 2, 16, -1, 0, 2, 17, -1, 0, 2, 18, -1, 0, 2, 19, -1, 0, 2, 20, -1, 0, 2, 21, -1, 0, 2, 22, -1, 0, 2, 23, -1, 0, 2, 24, -1, 0, 2, 25, -1, 0, 2, 26, -1, 0, 2, 27, -1, 0, 2, 28, -1, 0, 2, 29, -1, 0, 2, 30, -1, 0, 2, 31, -1, 0, 2, 32, -1, 0, 2, 33, -1, 0, 2, 34, -1, 0, 2, 35, -1, 0, 2, 36, -1, 0, 2, 37, -1, 0, 2, 38, -1, 0, 2, 39, -1, 0, 2, 40, -1, 0, 2, 41, -1, 0, 2, 42, -1, 0, 2, 43, -1, 0, 2, 44, -1, 0, 2, 45, -1, 0, 2, 46, -1, 0, 2, 47, -1, 0, 2, 48, -1, 0, 2, 49, -1, 0, 2, 50, -1, 0, 2, 51, -1, 0, 2, 52, -1, 0, 2, 53, -1, 0, 2, 54, -1, 0, 2, 55, -1, 0, 2, 56, -1, 0, 2, 57, -1, 0, 2, 58, -1, 0, 2, 59, -1, 0, 2, 60, -1, 0, 2, 61, -1, 0, 2, 62, -1, 0, 2, 63, -1, 0, 3, 0, -1, 0, 3, 1, -1, 0, 3, 2, -1, 0, 3, 3, -1, 0, 3, 4, -1, 0, 3, 5, -1, 0, 3, 6, -1, 0, 3, 7, -1, 0, 3, 8, -1, 0, 3, 9, -1, 0, 3, 10, -1, 0, 3, 11, -1, 0, 3, 12, -1, 0, 3, 13, -1, 0, 3, 14, -1, 0, 3, 15, -1, 0, 3, 16, -1, 0, 3, 17, -1, 0, 3, 18, -1, 0, 3, 19, -1, 0, 3, 20, -1, 0, 3, 21, -1, 0, 3, 22, -1, 0, 3, 23, -1, 0, 3, 24, -1, 0, 3, 25, -1, 0, 3, 26, -1, 0, 3, 27, -1, 0, 3, 28, -1, 0, 3, 29, -1, 0, 3, 30, -1, 0, 3, 31, -1, 0, 3, 32, -1, 0, 3, 33, -1, 0, 3, 34, -1, 0, 3, 35, -1, 0, 3, 36, -1, 0, 3, 37, -1, 0, 3, 38, -1, 0, 3, 39, -1, 0, 3, 40, -1, 0, 3, 41, -1, 0, 3, 42, -1, 0, 3, 43, -1, 0, 3, 44, -1, 0, 3, 45, -1, 0, 3, 46, -1, 0, 3, 47, -1, 0, 3, 48, -1, 0, 3, 49, -1, 0, 3, 50, -1, 0, 3, 51, -1, 0, 3, 52, -1, 0, 3, 53, -1, 0, 3, 54, -1, 0, 3, 55, -1, 0, 3, 56, -1, 0, 3, 57, -1, 0, 3, 58, -1, 0, 3, 59, -1, 0, 3, 60, -1, 0, 3, 61, -1, 0, 3, 62, -1, 0, 3, 63, -1, 0, 4, 0, -1, 0, 4, 1, -1, 0, 4, 2, -1, 0, 4, 3, -1, 0, 4, 4, -1, 0, 4, 5, -1, 0, 4, 6, -1, 0, 4, 7, -1, 0, 4, 8, -1, 0, 4, 9, -1, 0, 4, 10, -1, 0, 4, 11, -1, 0, 4, 12, -1, 0, 4, 13, -1, 0, 4, 14, -1, 0, 4, 15, -1, 0, 4, 16, -1, 0, 4, 17, -1, 0, 4, 18, -1, 0, 4, 19, -1, 0, 4, 20, -1, 0, 4, 21, -1, 0, 4, 22, -1, 0, 4, 23, -1, 0, 4, 24, -1, 0, 4, 25, -1, 0, 4, 26, -1, 0, 4, 27, -1, 0, 4, 28, -1, 0, 4, 29, -1, 0, 4, 30, -1, 0, 4, 31, -1, 0, 4, 32, -1, 0, 4, 33, -1, 0, 4, 34, -1, 0, 4, 35, -1, 0, 4, 36, -1, 0, 4, 37, -1, 0, 4, 38, -1, 0, 4, 39, -1, 0, 4, 40, -1, 0, 4, 41, -1, 0, 4, 42, -1, 0, 4, 43, -1, 0, 4, 44, -1, 0, 4, 45, -1, 0, 4, 46, -1, 0, 4, 47, -1, 0, 4, 48, -1, 0, 4, 49, -1, 0, 4, 50, -1, 0, 4, 51, -1, 0, 4, 52, -1, 0, 4, 53, -1, 0, 4, 54, -1, 0, 4, 55, -1, 0, 4, 56, -1, 0, 4, 57, -1, 0, 4, 58, -1, 0, 4, 59, -1, 0, 4, 60, -1, 0, 4, 61, -1, 0, 4, 62, -1, 0, 4, 63, -1, 0, 5, 0, -1, 0, 5, 1, -1, 0, 5, 2, -1, 0, 5, 3, -1, 0, 5, 4, -1, 0, 5, 5, -1, 0, 5, 6, -1, 0, 5, 7, -1, 0, 5, 8, -1, 0, 5, 9, -1, 0, 5, 10, -1, 0, 5, 11, -1, 0, 5, 12, -1, 0, 5, 13, -1, 0, 5, 14, -1, 0, 5, 15, -1, 0, 5, 16, -1, 0, 5, 17, -1, 0, 5, 18, -1, 0, 5, 19, -1, 0, 5, 20, -1, 0, 5, 21, -1, 0, 5, 22, -1, 0, 5, 23, -1, 0, 5, 24, -1, 0, 5, 25, -1, 0, 5, 26, -1, 0, 5, 27, -1, 0, 5, 28, -1, 0, 5, 29, -1, 0, 5, 30, -1, 0, 5, 31, -1, 0, 5, 32, -1, 0, 5, 33, -1, 0, 5, 34, -1, 0, 5, 35, -1, 0, 5, 36, -1, 0, 5, 37, -1, 0, 5, 38, -1, 0, 5, 39, -1, 0, 5, 40, -1, 0, 5, 41, -1, 0, 5, 42, -1, 0, 5, 43, -1, 0, 5, 44, -1, 0, 5, 45, -1, 0, 5, 46, -1, 0, 5, 47, -1, 0, 5, 48, -1, 0, 5, 49, -1, 0, 5, 50, -1, 0, 5, 51, -1, 0, 5, 52, -1, 0, 5, 53, -1, 0, 5, 54, -1, 0, 5, 55, -1, 0, 5, 56, -1, 0, 5, 57, -1, 0, 5, 58, -1, 0, 5, 59, -1, 0, 5, 60, -1, 0, 5, 61, -1, 0, 5, 62, -1, 0, 5, 63, -1, 0, 6, 0, -1, 0, 6, 1, -1, 0, 6, 2, -1, 0, 6, 3, -1, 0, 6, 4, -1, 0, 6, 5, -1, 0, 6, 6, -1, 0, 6, 7, -1, 0, 6, 8, -1, 0, 6, 9, -1, 0, 6, 10, -1, 0, 6, 11, -1, 0, 6, 12, -1, 0, 6, 13, -1, 0, 6, 14, -1, 0, 6, 15, -1, 0, 6, 16, -1, 0, 6, 17, -1, 0, 6, 18, -1, 0, 6, 19, -1, 0, 6, 20, -1, 0, 6, 21, -1, 0, 6, 22, -1, 0, 6, 23, -1, 0, 6, 24, -1, 0, 6, 25, -1, 0, 6, 26, -1, 0, 6, 27, -1, 0, 6, 28, -1, 0, 6, 29, -1, 0, 6, 30, -1, 0, 6, 31, -1, 0, 6, 32, -1, 0, 6, 33, -1, 0, 6, 34, -1, 0, 6, 35, -1, 0, 6, 36, -1, 0, 6, 37, -1, 0, 6, 38, -1, 0, 6, 39, -1, 0, 6, 40, -1, 0, 6, 41, -1, 0, 6, 42, -1, 0, 6, 43, -1, 0, 6, 44, -1, 0, 6, 45, -1, 0, 6, 46, -1, 0, 6, 47, -1, 0, 6, 48, -1, 0, 6, 49, -1, 0, 6, 50, -1, 0, 6, 51, -1, 0, 6, 52, -1, 0, 6, 53, -1, 0, 6, 54, -1, 0, 6, 55, -1, 0, 6, 56, -1, 0, 6, 57, -1, 0, 6, 58, -1, 0, 6, 59, -1, 0, 6, 60, -1, 0, 6, 61, -1, 0, 6, 62, -1, 0, 6, 63, -1, 0, 7, 0, -1, 0, 7, 1, -1, 0, 7, 2, -1, 0, 7, 3, -1, 0, 7, 4, -1, 0, 7, 5, -1, 0, 7, 6, -1, 0, 7, 7, -1, 0, 7, 8, -1, 0, 7, 9, -1, 0, 7, 10, -1, 0, 7, 11, -1, 0, 7, 12, -1, 0, 7, 13, -1, 0, 7, 14, -1, 0, 7, 15, -1, 0, 7, 16, -1, 0, 7, 17, -1, 0, 7, 18, -1, 0, 7, 19, -1, 0, 7, 20, -1, 0, 7, 21, -1, 0, 7, 22, -1, 0, 7, 23, -1, 0, 7, 24, -1, 0, 7, 25, -1, 0, 7, 26, -1, 0, 7, 27, -1, 0, 7, 28, -1, 0, 7, 29, -1, 0, 7, 30, -1, 0, 7, 31, -1, 0, 7, 32, -1, 0, 7, 33, -1, 0, 7, 34, -1, 0, 7, 35, -1, 0, 7, 36, -1, 0, 7, 37, -1, 0, 7, 38, -1, 0, 7, 39, -1, 0, 7, 40, -1, 0, 7, 41, -1, 0, 7, 42, -1, 0, 7, 43, -1, 0, 7, 44, -1, 0, 7, 45, -1, 0, 7, 46, -1, 0, 7, 47, -1, 0, 7, 48, -1, 0, 7, 49, -1, 0, 7, 50, -1, 0, 7, 51, -1, 0, 7, 52, -1, 0, 7, 53, -1, 0, 7, 54, -1, 0, 7, 55, -1, 0, 7, 56, -1, 0, 7, 57, -1, 0, 7, 58, -1, 0, 7, 59, -1, 0, 7, 60, -1, 0, 7, 61, -1, 0, 7, 62, -1, 0, 7, 63, -1, 0, 8, 0, -1, 0, 8, 1, -1, 0, 8, 2, -1, 0, 8, 3, -1, 0, 8, 4, -1, 0, 8, 5, -1, 0, 8, 6, -1, 0, 8, 7, -1, 0, 8, 8, -1, 0, 8, 9, -1, 0, 8, 10, -1, 0, 8, 11, -1, 0, 8, 12, -1, 0, 8, 13, -1, 0, 8, 14, -1, 0, 8, 15, -1, 0, 8, 16, -1, 0, 8, 17, -1, 0, 8, 18, -1, 0, 8, 19, -1, 0, 8, 20, -1, 0, 8, 21, -1, 0, 8, 22, -1, 0, 8, 23, -1, 0, 8, 24, -1, 0, 8, 25, -1, 0, 8, 26, -1, 0, 8, 27, -1, 0, 8, 28, -1, 0, 8, 29, -1, 0, 8, 30, -1, 0, 8, 31, -1, 0, 8, 32, -1, 0, 8, 33, -1, 0, 8, 34, -1, 0, 8, 35, -1, 0, 8, 36, -1, 0, 8, 37, -1, 0, 8, 38, -1, 0, 8, 39, -1, 0, 8, 40, -1, 0, 8, 41, -1, 0, 8, 42, -1, 0, 8, 43, -1, 0, 8, 44, -1, 0, 8, 45, -1, 0, 8, 46, -1, 0, 8, 47, -1, 0, 8, 48, -1, 0, 8, 49, -1, 0, 8, 50, -1, 0, 8, 51, -1, 0, 8, 52, -1, 0, 8, 53, -1, 0, 8, 54, -1, 0, 8, 55, -1, 0, 8, 56, -1, 0, 8, 57, -1, 0, 8, 58, -1, 0, 8, 59, -1, 0, 8, 60, -1, 0, 8, 61, -1, 0, 8, 62, -1, 0, 8, 63, -1, 0, 9, 0, -1, 0, 9, 1, -1, 0, 9, 2, -1, 0, 9, 3, -1, 0, 9, 4, -1, 0, 9, 5, -1, 0, 9, 6, -1, 0, 9, 7, -1, 0, 9, 8, -1, 0, 9, 9, -1, 0, 9, 10, -1, 0, 9, 11, -1, 0, 9, 12, -1, 0, 9, 13, -1, 0, 9, 14, -1, 0, 9, 15, -1, 0, 9, 16, -1, 0, 9, 17, -1, 0, 9, 18, -1, 0, 9, 19, -1, 0, 9, 20, -1, 0, 9, 21, -1, 0, 9, 22, -1, 0, 9, 23, -1, 0, 9, 24, -1, 0, 9, 25, -1, 0, 9, 26, -1, 0, 9, 27, -1, 0, 9, 28, -1, 0, 9, 29, -1, 0, 9, 30, -1, 0, 9, 31, -1, 0, 9, 32, -1, 0, 9, 33, -1, 0, 9, 34, -1, 0, 9, 35, -1, 0, 9, 36, -1, 0, 9, 37, -1, 0, 9, 38, -1, 0, 9, 39, -1, 0, 9, 40, -1, 0, 9, 41, -1, 0, 9, 42, -1, 0, 9, 43, -1, 0, 9, 44, -1, 0, 9, 45, -1, 0, 9, 46, -1, 0, 9, 47, -1, 0, 9, 48, -1, 0, 9, 49, -1, 0, 9, 50, -1, 0, 9, 51, -1, 0, 9, 52, -1, 0, 9, 53, -1, 0, 9, 54, -1, 0, 9, 55, -1, 0, 9, 56, -1, 0, 9, 57, -1, 0, 9, 58, -1, 0, 9, 59, -1, 0, 9, 60, -1, 0, 9, 61, -1, 0, 9, 62, -1, 0, 9, 63, -1, 0, 10, 0, -1, 0, 10, 1, -1, 0, 10, 2, -1, 0, 10, 3, -1, 0, 10, 4, -1, 0, 10, 5, -1, 0, 10, 6, -1, 0, 10, 7, -1, 0, 10, 8, -1, 0, 10, 9, -1, 0, 10, 10, -1, 0, 10, 11, -1, 0, 10, 12, -1, 0, 10, 13, -1, 0, 10, 14, -1, 0, 10, 15, -1, 0, 10, 16, -1, 0, 10, 17, -1, 0, 10, 18, -1, 0, 10, 19, -1, 0, 10, 20, -1, 0, 10, 21, -1, 0, 10, 22, -1, 0, 10, 23, -1, 0, 10, 24, -1, 0, 10, 25, -1, 0, 10, 26, -1, 0, 10, 27, -1, 0, 10, 28, -1, 0, 10, 29, -1, 0, 10, 30, -1, 0, 10, 31, -1, 0, 10, 32, -1, 0, 10, 33, -1, 0, 10, 34, -1, 0, 10, 35, -1, 0, 10, 36, -1, 0, 10, 37, -1, 0, 10, 38, -1, 0, 10, 39, -1, 0, 10, 40, -1, 0, 10, 41, -1, 0, 10, 42, -1, 0, 10, 43, -1, 0, 10, 44, -1, 0, 10, 45, -1, 0, 10, 46, -1, 0, 10, 47, -1, 0, 10, 48, -1, 0, 10, 49, -1, 0, 10, 50, -1, 0, 10, 51, -1, 0, 10, 52, -1, 0, 10, 53, -1, 0, 10, 54, -1, 0, 10, 55, -1, 0, 10, 56, -1, 0, 10, 57, -1, 0, 10, 58, -1, 0, 10, 59, -1, 0, 10, 60, -1, 0, 10, 61, -1, 0, 10, 62, -1, 0, 10, 63, -1, 0, 11, 0, -1, 0, 11, 1, -1, 0, 11, 2, -1, 0, 11, 3, -1, 0, 11, 4, -1, 0, 11, 5, -1, 0, 11, 6, -1, 0, 11, 7, -1, 0, 11, 8, -1, 0, 11, 9, -1, 0, 11, 10, -1, 0, 11, 11, -1, 0, 11, 12, -1, 0, 11, 13, -1, 0, 11, 14, -1, 0, 11, 15, -1, 0, 11, 16, -1, 0, 11, 17, -1, 0, 11, 18, -1, 0, 11, 19, -1, 0, 11, 20, -1, 0, 11, 21, -1, 0, 11, 22, -1, 0, 11, 23, -1, 0, 11, 24, -1, 0, 11, 25, -1, 0, 11, 26, -1, 0, 11, 27, -1, 0, 11, 28, -1, 0, 11, 29, -1, 0, 11, 30, -1, 0, 11, 31, -1, 0, 11, 32, -1, 0, 11, 33, -1, 0, 11, 34, -1, 0, 11, 35, -1, 0, 11, 36, -1, 0, 11, 37, -1, 0, 11, 38, -1, 0, 11, 39, -1, 0, 11, 40, -1, 0, 11, 41, -1, 0, 11, 42, -1, 0, 11, 43, -1, 0, 11, 44, -1, 0, 11, 45, -1, 0, 11, 46, -1, 0, 11, 47, -1, 0, 11, 48, -1, 0, 11, 49, -1, 0, 11, 50, -1, 0, 11, 51, -1, 0, 11, 52, -1, 0, 11, 53, -1, 0, 11, 54, -1, 0, 11, 55, -1, 0, 11, 56, -1, 0, 11, 57, -1, 0, 11, 58, -1, 0, 11, 59, -1, 0, 11, 60, -1, 0, 11, 61, -1, 0, 11, 62, -1, 0, 11, 63, -1, 0, 12, 0, -1, 0, 12, 1, -1, 0, 12, 2, -1, 0, 12, 3, -1, 0, 12, 4, -1, 0, 12, 5, -1, 0, 12, 6, -1, 0, 12, 7, -1, 0, 12, 8, -1, 0, 12, 9, -1, 0, 12, 10, -1, 0, 12, 11, -1, 0, 12, 12, -1, 0, 12, 13, -1, 0, 12, 14, -1, 0, 12, 15, -1, 0, 12, 16, -1, 0, 12, 17, -1, 0, 12, 18, -1, 0, 12, 19, -1, 0, 12, 20, -1, 0, 12, 21, -1, 0, 12, 22, -1, 0, 12, 23, -1, 0, 12, 24, -1, 0, 12, 25, -1, 0, 12, 26, -1, 0, 12, 27, -1, 0, 12, 28, -1, 0, 12, 29, -1, 0, 12, 30, -1, 0, 12, 31, -1, 0, 12, 32, -1, 0, 12, 33, -1, 0, 12, 34, -1, 0, 12, 35, -1, 0, 12, 36, -1, 0, 12, 37, -1, 0, 12, 38, -1, 0, 12, 39, -1, 0, 12, 40, -1, 0, 12, 41, -1, 0, 12, 42, -1, 0, 12, 43, -1, 0, 12, 44, -1, 0, 12, 45, -1, 0, 12, 46, -1, 0, 12, 47, 562, 0, 12, 48, 563, 0, 12, 49, -1, 0, 12, 50, -1, 0, 12, 51, -1, 0, 12, 52, -1, 0, 12, 53, -1, 0, 12, 54, -1, 0, 12, 55, -1, 0, 12, 56, -1, 0, 12, 57, -1, 0, 12, 58, -1, 0, 12, 59, -1, 0, 12, 60, -1, 0, 12, 61, -1, 0, 12, 62, -1, 0, 12, 63, -1, 0, 13, 0, -1, 0, 13, 1, -1, 0, 13, 2, -1, 0, 13, 3, -1, 0, 13, 4, -1, 0, 13, 5, -1, 0, 13, 6, -1, 0, 13, 7, -1, 0, 13, 8, -1, 0, 13, 9, -1, 0, 13, 10, -1, 0, 13, 11, -1, 0, 13, 12, -1, 0, 13, 13, -1, 0, 13, 14, -1, 0, 13, 15, -1, 0, 13, 16, -1, 0, 13, 17, -1, 0, 13, 18, -1, 0, 13, 19, -1, 0, 13, 20, -1, 0, 13, 21, -1, 0, 13, 22, -1, 0, 13, 23, -1, 0, 13, 24, -1, 0, 13, 25, -1, 0, 13, 26, -1, 0, 13, 27, -1, 0, 13, 28, -1, 0, 13, 29, -1, 0, 13, 30, -1, 0, 13, 31, -1, 0, 13, 32, -1, 0, 13, 33, -1, 0, 13, 34, -1, 0, 13, 35, -1, 0, 13, 36, -1, 0, 13, 37, -1, 0, 13, 38, -1, 0, 13, 39, -1, 0, 13, 40, -1, 0, 13, 41, -1, 0, 13, 42, -1, 0, 13, 43, -1, 0, 13, 44, -1, 0, 13, 45, -1, 0, 13, 46, -1, 0, 13, 47, 562, 0, 13, 48, 563, 0, 13, 49, -1, 0, 13, 50, -1, 0, 13, 51, 562, 0, 13, 52, 563, 0, 13, 53, -1, 0, 13, 54, -1, 0, 13, 55, 562, 0, 13, 56, 563, 0, 13, 57, -1, 0, 13, 58, -1, 0, 13, 59, 562, 0, 13, 60, 563, 0, 13, 61, -1, 0, 13, 62, -1, 0, 13, 63, -1, 0, 14, 0, -1, 0, 14, 1, -1, 0, 14, 2, -1, 0, 14, 3, -1, 0, 14, 4, -1, 0, 14, 5, -1, 0, 14, 6, -1, 0, 14, 7, -1, 0, 14, 8, -1, 0, 14, 9, -1, 0, 14, 10, -1, 0, 14, 11, -1, 0, 14, 12, -1, 0, 14, 13, -1, 0, 14, 14, -1, 0, 14, 15, -1, 0, 14, 16, -1, 0, 14, 17, -1, 0, 14, 18, -1, 0, 14, 19, -1, 0, 14, 20, -1, 0, 14, 21, -1, 0, 14, 22, -1, 0, 14, 23, -1, 0, 14, 24, -1, 0, 14, 25, -1, 0, 14, 26, -1, 0, 14, 27, -1, 0, 14, 28, -1, 0, 14, 29, -1, 0, 14, 30, -1, 0, 14, 31, -1, 0, 14, 32, -1, 0, 14, 33, -1, 0, 14, 34, -1, 0, 14, 35, -1, 0, 14, 36, -1, 0, 14, 37, -1, 0, 14, 38, -1, 0, 14, 39, -1, 0, 14, 40, -1, 0, 14, 41, -1, 0, 14, 42, -1, 0, 14, 43, -1, 0, 14, 44, -1, 0, 14, 45, -1, 0, 14, 46, -1, 0, 14, 47, 578, 0, 14, 48, 579, 0, 14, 49, -1, 0, 14, 50, -1, 0, 14, 51, 578, 0, 14, 52, 579, 0, 14, 53, -1, 0, 14, 54, -1, 0, 14, 55, 578, 0, 14, 56, 579, 0, 14, 57, -1, 0, 14, 58, -1, 0, 14, 59, 578, 0, 14, 60, 579, 0, 14, 61, -1, 0, 14, 62, -1, 0, 14, 63, -1, 0, 15, 0, -1, 0, 15, 1, -1, 0, 15, 2, -1, 0, 15, 3, -1, 0, 15, 4, -1, 0, 15, 5, -1, 0, 15, 6, -1, 0, 15, 7, -1, 0, 15, 8, -1, 0, 15, 9, -1, 0, 15, 10, -1, 0, 15, 11, -1, 0, 15, 12, -1, 0, 15, 13, -1, 0, 15, 14, -1, 0, 15, 15, -1, 0, 15, 16, 562, 0, 15, 17, 563, 0, 15, 18, 562, 0, 15, 19, 563, 0, 15, 20, 562, 0, 15, 21, 563, 0, 15, 22, 562, 0, 15, 23, 563, 0, 15, 24, 562, 0, 15, 25, 563, 0, 15, 26, 562, 0, 15, 27, 563, 0, 15, 28, 562, 0, 15, 29, 563, 0, 15, 30, 562, 0, 15, 31, 563, 0, 15, 32, 562, 0, 15, 33, 563, 0, 15, 34, 562, 0, 15, 35, 563, 0, 15, 36, 562, 0, 15, 37, 563, 0, 15, 38, 562, 0, 15, 39, 563, 0, 15, 40, 562, 0, 15, 41, 563, 0, 15, 42, 562, 0, 15, 43, 563, 0, 15, 44, 562, 0, 15, 45, 563, 0, 15, 46, 562, 0, 15, 47, 594, 0, 15, 48, 595, 0, 15, 49, 562, 0, 15, 50, 563, 0, 15, 51, 594, 0, 15, 52, 595, 0, 15, 53, 562, 0, 15, 54, 563, 0, 15, 55, 594, 0, 15, 56, 595, 0, 15, 57, 562, 0, 15, 58, 563, 0, 15, 59, 594, 0, 15, 60, 595, 0, 15, 61, 562, 0, 15, 62, 563, 0, 15, 63, -1, 0, 16, 0, -1, 0, 16, 1, -1, 0, 16, 2, -1, 0, 16, 3, -1, 0, 16, 4, -1, 0, 16, 5, -1, 0, 16, 6, -1, 0, 16, 7, -1, 0, 16, 8, -1, 0, 16, 9, -1, 0, 16, 10, -1, 0, 16, 11, -1, 0, 16, 12, -1, 0, 16, 13, -1, 0, 16, 14, -1, 0, 16, 15, -1, 0, 16, 16, 562, 0, 16, 17, 563, 0, 16, 18, 578, 0, 16, 19, 579, 0, 16, 20, 562, 0, 16, 21, 563, 0, 16, 22, 578, 0, 16, 23, 579, 0, 16, 24, 562, 0, 16, 25, 563, 0, 16, 26, 578, 0, 16, 27, 579, 0, 16, 28, 562, 0, 16, 29, 563, 0, 16, 30, 578, 0, 16, 31, 579, 0, 16, 32, 562, 0, 16, 33, 563, 0, 16, 34, 578, 0, 16, 35, 579, 0, 16, 36, 562, 0, 16, 37, 563, 0, 16, 38, 578, 0, 16, 39, 579, 0, 16, 40, 562, 0, 16, 41, 563, 0, 16, 42, 578, 0, 16, 43, 579, 0, 16, 44, 562, 0, 16, 45, 563, 0, 16, 46, 578, 0, 16, 47, 562, 0, 16, 48, 563, 0, 16, 49, 578, 0, 16, 50, 579, 0, 16, 51, 562, 0, 16, 52, 563, 0, 16, 53, 578, 0, 16, 54, 579, 0, 16, 55, 562, 0, 16, 56, 563, 0, 16, 57, 578, 0, 16, 58, 579, 0, 16, 59, 562, 0, 16, 60, 563, 0, 16, 61, 578, 0, 16, 62, 579, 0, 16, 63, -1, 0, 17, 0, -1, 0, 17, 1, -1, 0, 17, 2, -1, 0, 17, 3, -1, 0, 17, 4, -1, 0, 17, 5, -1, 0, 17, 6, -1, 0, 17, 7, -1, 0, 17, 8, -1, 0, 17, 9, -1, 0, 17, 10, -1, 0, 17, 11, -1, 0, 17, 12, -1, 0, 17, 13, -1, 0, 17, 14, -1, 0, 17, 15, -1, 0, 17, 16, 578, 0, 17, 17, 579, 0, 17, 18, 594, 0, 17, 19, 595, 0, 17, 20, 578, 0, 17, 21, 579, 0, 17, 22, 594, 0, 17, 23, 595, 0, 17, 24, 578, 0, 17, 25, 579, 0, 17, 26, 594, 0, 17, 27, 595, 0, 17, 28, 578, 0, 17, 29, 579, 0, 17, 30, 594, 0, 17, 31, 595, 0, 17, 32, 578, 0, 17, 33, 579, 0, 17, 34, 594, 0, 17, 35, 595, 0, 17, 36, 578, 0, 17, 37, 579, 0, 17, 38, 594, 0, 17, 39, 595, 0, 17, 40, 578, 0, 17, 41, 579, 0, 17, 42, 594, 0, 17, 43, 595, 0, 17, 44, 578, 0, 17, 45, 579, 0, 17, 46, 594, 0, 17, 47, 578, 0, 17, 48, 579, 0, 17, 49, 594, 0, 17, 50, 595, 0, 17, 51, 578, 0, 17, 52, 579, 0, 17, 53, 594, 0, 17, 54, 595, 0, 17, 55, 578, 0, 17, 56, 579, 0, 17, 57, 594, 0, 17, 58, 595, 0, 17, 59, 578, 0, 17, 60, 579, 0, 17, 61, 594, 0, 17, 62, 595, 0, 17, 63, -1, 0, 18, 0, -1, 0, 18, 1, -1, 0, 18, 2, -1, 0, 18, 3, -1, 0, 18, 4, -1, 0, 18, 5, -1, 0, 18, 6, -1, 0, 18, 7, -1, 0, 18, 8, -1, 0, 18, 9, -1, 0, 18, 10, -1, 0, 18, 11, -1, 0, 18, 12, -1, 0, 18, 13, -1, 0, 18, 14, -1, 0, 18, 15, -1, 0, 18, 16, 594, 0, 18, 17, 595, 0, 18, 18, 562, 0, 18, 19, 563, 0, 18, 20, 594, 0, 18, 21, 595, 0, 18, 22, 562, 0, 18, 23, 563, 0, 18, 24, 594, 0, 18, 25, 595, 0, 18, 26, 562, 0, 18, 27, 563, 0, 18, 28, 594, 0, 18, 29, 595, 0, 18, 30, 562, 0, 18, 31, 563, 0, 18, 32, 594, 0, 18, 33, 595, 0, 18, 34, 562, 0, 18, 35, 563, 0, 18, 36, 594, 0, 18, 37, 595, 0, 18, 38, 562, 0, 18, 39, 563, 0, 18, 40, 594, 0, 18, 41, 595, 0, 18, 42, 562, 0, 18, 43, 563, 0, 18, 44, 594, 0, 18, 45, 595, 0, 18, 46, 562, 0, 18, 47, 594, 0, 18, 48, 595, 0, 18, 49, 562, 0, 18, 50, 563, 0, 18, 51, 594, 0, 18, 52, 595, 0, 18, 53, 562, 0, 18, 54, 563, 0, 18, 55, 594, 0, 18, 56, 595, 0, 18, 57, 562, 0, 18, 58, 563, 0, 18, 59, 594, 0, 18, 60, 595, 0, 18, 61, 562, 0, 18, 62, 563, 0, 18, 63, -1, 0, 19, 0, -1, 0, 19, 1, -1, 0, 19, 2, -1, 0, 19, 3, -1, 0, 19, 4, -1, 0, 19, 5, -1, 0, 19, 6, -1, 0, 19, 7, -1, 0, 19, 8, -1, 0, 19, 9, -1, 0, 19, 10, -1, 0, 19, 11, -1, 0, 19, 12, -1, 0, 19, 13, -1, 0, 19, 14, -1, 0, 19, 15, -1, 0, 19, 16, 562, 0, 19, 17, 563, 0, 19, 18, 578, 0, 19, 19, 579, 0, 19, 20, 562, 0, 19, 21, 563, 0, 19, 22, 578, 0, 19, 23, 579, 0, 19, 24, 562, 0, 19, 25, 563, 0, 19, 26, 578, 0, 19, 27, 579, 0, 19, 28, 562, 0, 19, 29, 563, 0, 19, 30, 578, 0, 19, 31, 579, 0, 19, 32, 562, 0, 19, 33, 563, 0, 19, 34, 578, 0, 19, 35, 579, 0, 19, 36, 562, 0, 19, 37, 563, 0, 19, 38, 578, 0, 19, 39, 579, 0, 19, 40, 562, 0, 19, 41, 563, 0, 19, 42, 578, 0, 19, 43, 579, 0, 19, 44, 562, 0, 19, 45, 563, 0, 19, 46, 578, 0, 19, 47, 562, 0, 19, 48, 563, 0, 19, 49, 578, 0, 19, 50, 579, 0, 19, 51, 562, 0, 19, 52, 563, 0, 19, 53, 578, 0, 19, 54, 579, 0, 19, 55, 562, 0, 19, 56, 563, 0, 19, 57, 578, 0, 19, 58, 579, 0, 19, 59, 562, 0, 19, 60, 563, 0, 19, 61, 578, 0, 19, 62, 579, 0, 19, 63, -1, 0, 20, 0, -1, 0, 20, 1, -1, 0, 20, 2, -1, 0, 20, 3, -1, 0, 20, 4, -1, 0, 20, 5, -1, 0, 20, 6, -1, 0, 20, 7, -1, 0, 20, 8, -1, 0, 20, 9, -1, 0, 20, 10, -1, 0, 20, 11, -1, 0, 20, 12, -1, 0, 20, 13, -1, 0, 20, 14, -1, 0, 20, 15, -1, 0, 20, 16, 578, 0, 20, 17, 579, 0, 20, 18, 594, 0, 20, 19, 595, 0, 20, 20, 578, 0, 20, 21, 579, 0, 20, 22, 594, 0, 20, 23, 595, 0, 20, 24, 578, 0, 20, 25, 579, 0, 20, 26, 594, 0, 20, 27, 595, 0, 20, 28, 578, 0, 20, 29, 579, 0, 20, 30, 594, 0, 20, 31, 595, 0, 20, 32, 578, 0, 20, 33, 579, 0, 20, 34, 594, 0, 20, 35, 595, 0, 20, 36, 578, 0, 20, 37, 579, 0, 20, 38, 594, 0, 20, 39, 595, 0, 20, 40, 578, 0, 20, 41, 579, 0, 20, 42, 594, 0, 20, 43, 595, 0, 20, 44, 578, 0, 20, 45, 579, 0, 20, 46, 594, 0, 20, 47, 578, 0, 20, 48, 579, 0, 20, 49, 594, 0, 20, 50, 595, 0, 20, 51, 578, 0, 20, 52, 579, 0, 20, 53, 594, 0, 20, 54, 595, 0, 20, 55, 578, 0, 20, 56, 579, 0, 20, 57, 594, 0, 20, 58, 595, 0, 20, 59, 578, 0, 20, 60, 579, 0, 20, 61, 594, 0, 20, 62, 595, 0, 20, 63, -1, 0, 21, 0, -1, 0, 21, 1, -1, 0, 21, 2, -1, 0, 21, 3, -1, 0, 21, 4, -1, 0, 21, 5, -1, 0, 21, 6, -1, 0, 21, 7, -1, 0, 21, 8, -1, 0, 21, 9, -1, 0, 21, 10, -1, 0, 21, 11, -1, 0, 21, 12, -1, 0, 21, 13, -1, 0, 21, 14, -1, 0, 21, 15, -1, 0, 21, 16, 594, 0, 21, 17, 595, 0, 21, 18, 562, 0, 21, 19, 563, 0, 21, 20, 594, 0, 21, 21, 595, 0, 21, 22, 562, 0, 21, 23, 563, 0, 21, 24, 594, 0, 21, 25, 595, 0, 21, 26, 562, 0, 21, 27, 563, 0, 21, 28, 594, 0, 21, 29, 595, 0, 21, 30, 562, 0, 21, 31, 563, 0, 21, 32, 594, 0, 21, 33, 595, 0, 21, 34, 562, 0, 21, 35, 563, 0, 21, 36, 594, 0, 21, 37, 595, 0, 21, 38, 562, 0, 21, 39, 563, 0, 21, 40, 594, 0, 21, 41, 595, 0, 21, 42, 562, 0, 21, 43, 563, 0, 21, 44, 594, 0, 21, 45, 595, 0, 21, 46, 562, 0, 21, 47, 594, 0, 21, 48, 595, 0, 21, 49, 562, 0, 21, 50, 563, 0, 21, 51, 594, 0, 21, 52, 595, 0, 21, 53, 562, 0, 21, 54, 563, 0, 21, 55, 594, 0, 21, 56, 595, 0, 21, 57, 562, 0, 21, 58, 563, 0, 21, 59, 594, 0, 21, 60, 595, 0, 21, 61, 562, 0, 21, 62, 563, 0, 21, 63, -1, 0, 22, 0, -1, 0, 22, 1, -1, 0, 22, 2, -1, 0, 22, 3, -1, 0, 22, 4, -1, 0, 22, 5, -1, 0, 22, 6, -1, 0, 22, 7, -1, 0, 22, 8, -1, 0, 22, 9, -1, 0, 22, 10, -1, 0, 22, 11, -1, 0, 22, 12, -1, 0, 22, 13, -1, 0, 22, 14, -1, 0, 22, 15, -1, 0, 22, 16, 562, 0, 22, 17, 563, 0, 22, 18, 578, 0, 22, 19, 579, 0, 22, 20, 562, 0, 22, 21, 563, 0, 22, 22, 578, 0, 22, 23, 579, 0, 22, 24, 562, 0, 22, 25, 563, 0, 22, 26, 578, 0, 22, 27, 579, 0, 22, 28, 562, 0, 22, 29, 563, 0, 22, 30, 578, 0, 22, 31, 579, 0, 22, 32, 562, 0, 22, 33, 563, 0, 22, 34, 578, 0, 22, 35, 579, 0, 22, 36, 562, 0, 22, 37, 563, 0, 22, 38, 578, 0, 22, 39, 579, 0, 22, 40, 562, 0, 22, 41, 563, 0, 22, 42, 578, 0, 22, 43, 579, 0, 22, 44, 562, 0, 22, 45, 563, 0, 22, 46, 578, 0, 22, 47, 562, 0, 22, 48, 563, 0, 22, 49, 578, 0, 22, 50, 579, 0, 22, 51, 562, 0, 22, 52, 563, 0, 22, 53, 578, 0, 22, 54, 579, 0, 22, 55, 562, 0, 22, 56, 563, 0, 22, 57, 578, 0, 22, 58, 579, 0, 22, 59, 562, 0, 22, 60, 563, 0, 22, 61, 578, 0, 22, 62, 579, 0, 22, 63, -1, 0, 23, 0, -1, 0, 23, 1, -1, 0, 23, 2, -1, 0, 23, 3, -1, 0, 23, 4, -1, 0, 23, 5, -1, 0, 23, 6, -1, 0, 23, 7, -1, 0, 23, 8, -1, 0, 23, 9, -1, 0, 23, 10, -1, 0, 23, 11, -1, 0, 23, 12, -1, 0, 23, 13, -1, 0, 23, 14, -1, 0, 23, 15, -1, 0, 23, 16, 578, 0, 23, 17, 579, 0, 23, 18, 594, 0, 23, 19, 595, 0, 23, 20, 578, 0, 23, 21, 579, 0, 23, 22, 594, 0, 23, 23, 595, 0, 23, 24, 578, 0, 23, 25, 579, 0, 23, 26, 594, 0, 23, 27, 595, 0, 23, 28, 578, 0, 23, 29, 579, 0, 23, 30, 594, 0, 23, 31, 595, 0, 23, 32, 578, 0, 23, 33, 579, 0, 23, 34, 594, 0, 23, 35, 595, 0, 23, 36, 578, 0, 23, 37, 579, 0, 23, 38, 594, 0, 23, 39, 595, 0, 23, 40, 578, 0, 23, 41, 579, 0, 23, 42, 594, 0, 23, 43, 595, 0, 23, 44, 578, 0, 23, 45, 579, 0, 23, 46, 594, 0, 23, 47, 578, 0, 23, 48, 579, 0, 23, 49, 594, 0, 23, 50, 595, 0, 23, 51, 578, 0, 23, 52, 579, 0, 23, 53, 594, 0, 23, 54, 595, 0, 23, 55, 578, 0, 23, 56, 579, 0, 23, 57, 594, 0, 23, 58, 595, 0, 23, 59, 578, 0, 23, 60, 579, 0, 23, 61, 594, 0, 23, 62, 595, 0, 23, 63, -1, 0, 24, 0, -1, 0, 24, 1, -1, 0, 24, 2, -1, 0, 24, 3, -1, 0, 24, 4, -1, 0, 24, 5, -1, 0, 24, 6, -1, 0, 24, 7, -1, 0, 24, 8, -1, 0, 24, 9, -1, 0, 24, 10, -1, 0, 24, 11, -1, 0, 24, 12, -1, 0, 24, 13, -1, 0, 24, 14, -1, 0, 24, 15, -1, 0, 24, 16, 594, 0, 24, 17, 595, 0, 24, 18, 562, 0, 24, 19, 563, 0, 24, 20, 594, 0, 24, 21, 595, 0, 24, 22, 562, 0, 24, 23, 563, 0, 24, 24, 594, 0, 24, 25, 595, 0, 24, 26, 562, 0, 24, 27, 563, 0, 24, 28, 594, 0, 24, 29, 595, 0, 24, 30, 562, 0, 24, 31, 563, 0, 24, 32, 594, 0, 24, 33, 595, 0, 24, 34, 562, 0, 24, 35, 563, 0, 24, 36, 594, 0, 24, 37, 595, 0, 24, 38, 562, 0, 24, 39, 563, 0, 24, 40, 594, 0, 24, 41, 595, 0, 24, 42, 562, 0, 24, 43, 563, 0, 24, 44, 594, 0, 24, 45, 595, 0, 24, 46, 562, 0, 24, 47, 594, 0, 24, 48, 595, 0, 24, 49, 562, 0, 24, 50, 563, 0, 24, 51, 594, 0, 24, 52, 595, 0, 24, 53, 562, 0, 24, 54, 563, 0, 24, 55, 594, 0, 24, 56, 595, 0, 24, 57, 562, 0, 24, 58, 563, 0, 24, 59, 594, 0, 24, 60, 595, 0, 24, 61, 562, 0, 24, 62, 563, 0, 24, 63, -1, 0, 25, 0, -1, 0, 25, 1, -1, 0, 25, 2, -1, 0, 25, 3, -1, 0, 25, 4, -1, 0, 25, 5, -1, 0, 25, 6, -1, 0, 25, 7, -1, 0, 25, 8, -1, 0, 25, 9, -1, 0, 25, 10, -1, 0, 25, 11, -1, 0, 25, 12, -1, 0, 25, 13, -1, 0, 25, 14, -1, 0, 25, 15, -1, 0, 25, 16, 562, 0, 25, 17, 563, 0, 25, 18, 578, 0, 25, 19, 579, 0, 25, 20, 562, 0, 25, 21, 563, 0, 25, 22, 578, 0, 25, 23, 579, 0, 25, 24, 562, 0, 25, 25, 563, 0, 25, 26, 578, 0, 25, 27, 579, 0, 25, 28, 562, 0, 25, 29, 563, 0, 25, 30, 578, 0, 25, 31, 579, 0, 25, 32, 562, 0, 25, 33, 563, 0, 25, 34, 578, 0, 25, 35, 579, 0, 25, 36, 562, 0, 25, 37, 563, 0, 25, 38, 578, 0, 25, 39, 579, 0, 25, 40, 562, 0, 25, 41, 563, 0, 25, 42, 578, 0, 25, 43, 579, 0, 25, 44, 562, 0, 25, 45, 563, 0, 25, 46, 578, 0, 25, 47, 562, 0, 25, 48, 563, 0, 25, 49, 578, 0, 25, 50, 579, 0, 25, 51, 562, 0, 25, 52, 563, 0, 25, 53, 578, 0, 25, 54, 579, 0, 25, 55, 562, 0, 25, 56, 563, 0, 25, 57, 578, 0, 25, 58, 579, 0, 25, 59, 562, 0, 25, 60, 563, 0, 25, 61, 578, 0, 25, 62, 579, 0, 25, 63, -1, 0, 26, 0, -1, 0, 26, 1, -1, 0, 26, 2, -1, 0, 26, 3, -1, 0, 26, 4, -1, 0, 26, 5, -1, 0, 26, 6, -1, 0, 26, 7, -1, 0, 26, 8, -1, 0, 26, 9, -1, 0, 26, 10, -1, 0, 26, 11, -1, 0, 26, 12, -1, 0, 26, 13, -1, 0, 26, 14, -1, 0, 26, 15, -1, 0, 26, 16, 578, 0, 26, 17, 579, 0, 26, 18, 594, 0, 26, 19, 595, 0, 26, 20, 578, 0, 26, 21, 579, 0, 26, 22, 594, 0, 26, 23, 595, 0, 26, 24, 578, 0, 26, 25, 579, 0, 26, 26, 594, 0, 26, 27, 595, 0, 26, 28, 578, 0, 26, 29, 579, 0, 26, 30, 594, 0, 26, 31, 595, 0, 26, 32, 578, 0, 26, 33, 579, 0, 26, 34, 594, 0, 26, 35, 595, 0, 26, 36, 578, 0, 26, 37, 579, 0, 26, 38, 594, 0, 26, 39, 595, 0, 26, 40, 578, 0, 26, 41, 579, 0, 26, 42, 594, 0, 26, 43, 595, 0, 26, 44, 578, 0, 26, 45, 579, 0, 26, 46, 594, 0, 26, 47, 578, 0, 26, 48, 579, 0, 26, 49, 594, 0, 26, 50, 595, 0, 26, 51, 578, 0, 26, 52, 579, 0, 26, 53, 594, 0, 26, 54, 595, 0, 26, 55, 578, 0, 26, 56, 579, 0, 26, 57, 594, 0, 26, 58, 595, 0, 26, 59, 578, 0, 26, 60, 579, 0, 26, 61, 594, 0, 26, 62, 595, 0, 26, 63, -1, 0, 27, 0, -1, 0, 27, 1, -1, 0, 27, 2, -1, 0, 27, 3, -1, 0, 27, 4, -1, 0, 27, 5, -1, 0, 27, 6, -1, 0, 27, 7, -1, 0, 27, 8, -1, 0, 27, 9, -1, 0, 27, 10, -1, 0, 27, 11, -1, 0, 27, 12, -1, 0, 27, 13, -1, 0, 27, 14, -1, 0, 27, 15, -1, 0, 27, 16, 594, 0, 27, 17, 595, 0, 27, 18, 562, 0, 27, 19, 563, 0, 27, 20, 594, 0, 27, 21, 595, 0, 27, 22, 562, 0, 27, 23, 563, 0, 27, 24, 594, 0, 27, 25, 595, 0, 27, 26, 562, 0, 27, 27, 563, 0, 27, 28, 594, 0, 27, 29, 595, 0, 27, 30, 562, 0, 27, 31, 563, 0, 27, 32, 594, 0, 27, 33, 595, 0, 27, 34, 562, 0, 27, 35, 563, 0, 27, 36, 594, 0, 27, 37, 595, 0, 27, 38, 562, 0, 27, 39, 563, 0, 27, 40, 594, 0, 27, 41, 595, 0, 27, 42, 562, 0, 27, 43, 563, 0, 27, 44, 594, 0, 27, 45, 595, 0, 27, 46, 562, 0, 27, 47, 594, 0, 27, 48, 595, 0, 27, 49, 562, 0, 27, 50, 563, 0, 27, 51, 594, 0, 27, 52, 595, 0, 27, 53, 562, 0, 27, 54, 563, 0, 27, 55, 594, 0, 27, 56, 595, 0, 27, 57, 562, 0, 27, 58, 563, 0, 27, 59, 594, 0, 27, 60, 595, 0, 27, 61, 562, 0, 27, 62, 563, 0, 27, 63, -1, 0, 28, 0, -1, 0, 28, 1, -1, 0, 28, 2, -1, 0, 28, 3, -1, 0, 28, 4, -1, 0, 28, 5, -1, 0, 28, 6, -1, 0, 28, 7, -1, 0, 28, 8, -1, 0, 28, 9, -1, 0, 28, 10, -1, 0, 28, 11, -1, 0, 28, 12, -1, 0, 28, 13, -1, 0, 28, 14, -1, 0, 28, 15, -1, 0, 28, 16, 562, 0, 28, 17, 563, 0, 28, 18, 578, 0, 28, 19, 579, 0, 28, 20, 562, 0, 28, 21, 563, 0, 28, 22, 578, 0, 28, 23, 579, 0, 28, 24, 562, 0, 28, 25, 563, 0, 28, 26, 578, 0, 28, 27, 579, 0, 28, 28, 562, 0, 28, 29, 563, 0, 28, 30, 578, 0, 28, 31, 579, 0, 28, 32, 562, 0, 28, 33, 563, 0, 28, 34, 578, 0, 28, 35, 579, 0, 28, 36, 562, 0, 28, 37, 563, 0, 28, 38, 578, 0, 28, 39, 579, 0, 28, 40, 562, 0, 28, 41, 563, 0, 28, 42, 578, 0, 28, 43, 579, 0, 28, 44, 562, 0, 28, 45, 563, 0, 28, 46, 578, 0, 28, 47, 562, 0, 28, 48, 563, 0, 28, 49, 578, 0, 28, 50, 579, 0, 28, 51, 562, 0, 28, 52, 563, 0, 28, 53, 578, 0, 28, 54, 579, 0, 28, 55, 562, 0, 28, 56, 563, 0, 28, 57, 578, 0, 28, 58, 579, 0, 28, 59, 562, 0, 28, 60, 563, 0, 28, 61, 578, 0, 28, 62, 579, 0, 28, 63, -1, 0, 29, 0, -1, 0, 29, 1, -1, 0, 29, 2, -1, 0, 29, 3, -1, 0, 29, 4, -1, 0, 29, 5, -1, 0, 29, 6, -1, 0, 29, 7, -1, 0, 29, 8, -1, 0, 29, 9, -1, 0, 29, 10, -1, 0, 29, 11, -1, 0, 29, 12, -1, 0, 29, 13, -1, 0, 29, 14, -1, 0, 29, 15, -1, 0, 29, 16, 578, 0, 29, 17, 579, 0, 29, 18, 594, 0, 29, 19, 595, 0, 29, 20, 578, 0, 29, 21, 579, 0, 29, 22, 594, 0, 29, 23, 595, 0, 29, 24, 578, 0, 29, 25, 579, 0, 29, 26, 594, 0, 29, 27, 595, 0, 29, 28, 578, 0, 29, 29, 579, 0, 29, 30, 594, 0, 29, 31, 595, 0, 29, 32, 578, 0, 29, 33, 579, 0, 29, 34, 594, 0, 29, 35, 595, 0, 29, 36, 578, 0, 29, 37, 579, 0, 29, 38, 594, 0, 29, 39, 595, 0, 29, 40, 578, 0, 29, 41, 579, 0, 29, 42, 594, 0, 29, 43, 595, 0, 29, 44, 578, 0, 29, 45, 579, 0, 29, 46, 594, 0, 29, 47, 578, 0, 29, 48, 579, 0, 29, 49, 594, 0, 29, 50, 595, 0, 29, 51, 578, 0, 29, 52, 579, 0, 29, 53, 594, 0, 29, 54, 595, 0, 29, 55, 578, 0, 29, 56, 579, 0, 29, 57, 594, 0, 29, 58, 595, 0, 29, 59, 578, 0, 29, 60, 579, 0, 29, 61, 594, 0, 29, 62, 595, 0, 29, 63, -1, 0, 30, 0, -1, 0, 30, 1, -1, 0, 30, 2, -1, 0, 30, 3, -1, 0, 30, 4, -1, 0, 30, 5, -1, 0, 30, 6, -1, 0, 30, 7, -1, 0, 30, 8, -1, 0, 30, 9, -1, 0, 30, 10, -1, 0, 30, 11, -1, 0, 30, 12, -1, 0, 30, 13, -1, 0, 30, 14, -1, 0, 30, 15, -1, 0, 30, 16, 594, 0, 30, 17, 595, 0, 30, 18, 562, 0, 30, 19, 563, 0, 30, 20, 594, 0, 30, 21, 595, 0, 30, 22, 562, 0, 30, 23, 563, 0, 30, 24, 594, 0, 30, 25, 595, 0, 30, 26, 562, 0, 30, 27, 563, 0, 30, 28, 594, 0, 30, 29, 595, 0, 30, 30, 562, 0, 30, 31, 563, 0, 30, 32, 594, 0, 30, 33, 595, 0, 30, 34, 562, 0, 30, 35, 563, 0, 30, 36, 562, 0, 30, 37, 563, 0, 30, 38, 562, 0, 30, 39, 563, 0, 30, 40, 562, 0, 30, 41, 563, 0, 30, 42, 562, 0, 30, 43, 563, 0, 30, 44, 562, 0, 30, 45, 563, 0, 30, 46, 562, 0, 30, 47, 594, 0, 30, 48, 595, 0, 30, 49, 563, 0, 30, 50, 563, 0, 30, 51, 594, 0, 30, 52, 595, 0, 30, 53, 594, 0, 30, 54, 595, 0, 30, 55, 594, 0, 30, 56, 595, 0, 30, 57, 594, 0, 30, 58, 595, 0, 30, 59, 594, 0, 30, 60, 595, 0, 30, 61, 594, 0, 30, 62, 595, 0, 30, 63, -1, 0, 31, 0, -1, 0, 31, 1, -1, 0, 31, 2, -1, 0, 31, 3, -1, 0, 31, 4, -1, 0, 31, 5, -1, 0, 31, 6, -1, 0, 31, 7, -1, 0, 31, 8, -1, 0, 31, 9, -1, 0, 31, 10, -1, 0, 31, 11, -1, 0, 31, 12, -1, 0, 31, 13, -1, 0, 31, 14, -1, 0, 31, 15, -1, 0, 31, 16, -1, 0, 31, 17, -1, 0, 31, 18, -1, 0, 31, 19, -1, 0, 31, 20, -1, 0, 31, 21, -1, 0, 31, 22, -1, 0, 31, 23, -1, 0, 31, 24, -1, 0, 31, 25, -1, 0, 31, 26, -1, 0, 31, 27, -1, 0, 31, 28, -1, 0, 31, 29, -1, 0, 31, 30, 562, 0, 31, 31, 563, 0, 31, 32, 578, 0, 31, 33, 579, 0, 31, 34, 562, 0, 31, 35, 563, 0, 31, 36, 578, 0, 31, 37, 579, 0, 31, 38, 562, 0, 31, 39, 563, 0, 31, 40, 578, 0, 31, 41, 579, 0, 31, 42, 562, 0, 31, 43, 563, 0, 31, 44, 578, 0, 31, 45, 579, 0, 31, 46, 562, 0, 31, 47, 563, 0, 31, 48, -1, 0, 31, 49, -1, 0, 31, 50, -1, 0, 31, 51, -1, 0, 31, 52, -1, 0, 31, 53, -1, 0, 31, 54, -1, 0, 31, 55, -1, 0, 31, 56, -1, 0, 31, 57, -1, 0, 31, 58, -1, 0, 31, 59, -1, 0, 31, 60, -1, 0, 31, 61, -1, 0, 31, 62, -1, 0, 31, 63, -1, 0, 32, 0, -1, 0, 32, 1, -1, 0, 32, 2, -1, 0, 32, 3, -1, 0, 32, 4, -1, 0, 32, 5, -1, 0, 32, 6, -1, 0, 32, 7, -1, 0, 32, 8, -1, 0, 32, 9, -1, 0, 32, 10, -1, 0, 32, 11, -1, 0, 32, 12, -1, 0, 32, 13, -1, 0, 32, 14, -1, 0, 32, 15, -1, 0, 32, 16, -1, 0, 32, 17, -1, 0, 32, 18, -1, 0, 32, 19, -1, 0, 32, 20, -1, 0, 32, 21, -1, 0, 32, 22, -1, 0, 32, 23, -1, 0, 32, 24, -1, 0, 32, 25, -1, 0, 32, 26, -1, 0, 32, 27, -1, 0, 32, 28, -1, 0, 32, 29, -1, 0, 32, 30, 578, 0, 32, 31, 579, 0, 32, 32, 594, 0, 32, 33, 595, 0, 32, 34, 578, 0, 32, 35, 579, 0, 32, 36, 594, 0, 32, 37, 595, 0, 32, 38, 578, 0, 32, 39, 579, 0, 32, 40, 594, 0, 32, 41, 595, 0, 32, 42, 578, 0, 32, 43, 579, 0, 32, 44, 594, 0, 32, 45, 595, 0, 32, 46, 578, 0, 32, 47, 579, 0, 32, 48, -1, 0, 32, 49, -1, 0, 32, 50, -1, 0, 32, 51, -1, 0, 32, 52, -1, 0, 32, 53, -1, 0, 32, 54, -1, 0, 32, 55, -1, 0, 32, 56, -1, 0, 32, 57, -1, 0, 32, 58, -1, 0, 32, 59, -1, 0, 32, 60, -1, 0, 32, 61, -1, 0, 32, 62, -1, 0, 32, 63, -1, 0, 33, 0, -1, 0, 33, 1, -1, 0, 33, 2, -1, 0, 33, 3, -1, 0, 33, 4, -1, 0, 33, 5, -1, 0, 33, 6, -1, 0, 33, 7, -1, 0, 33, 8, -1, 0, 33, 9, -1, 0, 33, 10, -1, 0, 33, 11, -1, 0, 33, 12, -1, 0, 33, 13, -1, 0, 33, 14, -1, 0, 33, 15, -1, 0, 33, 16, -1, 0, 33, 17, -1, 0, 33, 18, -1, 0, 33, 19, -1, 0, 33, 20, -1, 0, 33, 21, -1, 0, 33, 22, -1, 0, 33, 23, -1, 0, 33, 24, -1, 0, 33, 25, -1, 0, 33, 26, -1, 0, 33, 27, -1, 0, 33, 28, -1, 0, 33, 29, -1, 0, 33, 30, 594, 0, 33, 31, 595, 0, 33, 32, 562, 0, 33, 33, 563, 0, 33, 34, 594, 0, 33, 35, 595, 0, 33, 36, 562, 0, 33, 37, 563, 0, 33, 38, 594, 0, 33, 39, 595, 0, 33, 40, 578, 0, 33, 41, 579, 0, 33, 42, 594, 0, 33, 43, 595, 0, 33, 44, 578, 0, 33, 45, 579, 0, 33, 46, 594, 0, 33, 47, 595, 0, 33, 48, -1, 0, 33, 49, -1, 0, 33, 50, -1, 0, 33, 51, -1, 0, 33, 52, -1, 0, 33, 53, -1, 0, 33, 54, -1, 0, 33, 55, -1, 0, 33, 56, -1, 0, 33, 57, -1, 0, 33, 58, -1, 0, 33, 59, -1, 0, 33, 60, -1, 0, 33, 61, -1, 0, 33, 62, -1, 0, 33, 63, -1, 0, 34, 0, -1, 0, 34, 1, -1, 0, 34, 2, -1, 0, 34, 3, -1, 0, 34, 4, -1, 0, 34, 5, -1, 0, 34, 6, -1, 0, 34, 7, -1, 0, 34, 8, -1, 0, 34, 9, -1, 0, 34, 10, -1, 0, 34, 11, -1, 0, 34, 12, -1, 0, 34, 13, -1, 0, 34, 14, -1, 0, 34, 15, -1, 0, 34, 16, -1, 0, 34, 17, -1, 0, 34, 18, -1, 0, 34, 19, -1, 0, 34, 20, -1, 0, 34, 21, -1, 0, 34, 22, -1, 0, 34, 23, -1, 0, 34, 24, -1, 0, 34, 25, -1, 0, 34, 26, -1, 0, 34, 27, -1, 0, 34, 28, -1, 0, 34, 29, -1, 0, 34, 30, 562, 0, 34, 31, 563, 0, 34, 32, 578, 0, 34, 33, 579, 0, 34, 34, 562, 0, 34, 35, 563, 0, 34, 36, 578, 0, 34, 37, 579, 0, 34, 38, 562, 0, 34, 39, 563, 0, 34, 40, 594, 0, 34, 41, 595, 0, 34, 42, 562, 0, 34, 43, 563, 0, 34, 44, 594, 0, 34, 45, 595, 0, 34, 46, 562, 0, 34, 47, 563, 0, 34, 48, -1, 0, 34, 49, -1, 0, 34, 50, -1, 0, 34, 51, -1, 0, 34, 52, -1, 0, 34, 53, -1, 0, 34, 54, -1, 0, 34, 55, -1, 0, 34, 56, -1, 0, 34, 57, -1, 0, 34, 58, -1, 0, 34, 59, -1, 0, 34, 60, -1, 0, 34, 61, -1, 0, 34, 62, -1, 0, 34, 63, -1, 0, 35, 0, -1, 0, 35, 1, -1, 0, 35, 2, -1, 0, 35, 3, -1, 0, 35, 4, -1, 0, 35, 5, -1, 0, 35, 6, -1, 0, 35, 7, -1, 0, 35, 8, -1, 0, 35, 9, -1, 0, 35, 10, -1, 0, 35, 11, -1, 0, 35, 12, -1, 0, 35, 13, -1, 0, 35, 14, -1, 0, 35, 15, -1, 0, 35, 16, -1, 0, 35, 17, -1, 0, 35, 18, -1, 0, 35, 19, -1, 0, 35, 20, -1, 0, 35, 21, -1, 0, 35, 22, -1, 0, 35, 23, -1, 0, 35, 24, -1, 0, 35, 25, -1, 0, 35, 26, -1, 0, 35, 27, -1, 0, 35, 28, -1, 0, 35, 29, -1, 0, 35, 30, 578, 0, 35, 31, 579, 0, 35, 32, 594, 0, 35, 33, 595, 0, 35, 34, 578, 0, 35, 35, 579, 0, 35, 36, 594, 0, 35, 37, 595, 0, 35, 38, 578, 0, 35, 39, 579, 0, 35, 40, 562, 0, 35, 41, 563, 0, 35, 42, 578, 0, 35, 43, 579, 0, 35, 44, 562, 0, 35, 45, 563, 0, 35, 46, 578, 0, 35, 47, 579, 0, 35, 48, -1, 0, 35, 49, -1, 0, 35, 50, -1, 0, 35, 51, -1, 0, 35, 52, -1, 0, 35, 53, -1, 0, 35, 54, -1, 0, 35, 55, -1, 0, 35, 56, -1, 0, 35, 57, -1, 0, 35, 58, -1, 0, 35, 59, -1, 0, 35, 60, -1, 0, 35, 61, -1, 0, 35, 62, -1, 0, 35, 63, -1, 0, 36, 0, -1, 0, 36, 1, -1, 0, 36, 2, -1, 0, 36, 3, -1, 0, 36, 4, -1, 0, 36, 5, -1, 0, 36, 6, -1, 0, 36, 7, -1, 0, 36, 8, -1, 0, 36, 9, -1, 0, 36, 10, -1, 0, 36, 11, -1, 0, 36, 12, -1, 0, 36, 13, -1, 0, 36, 14, -1, 0, 36, 15, -1, 0, 36, 16, -1, 0, 36, 17, -1, 0, 36, 18, -1, 0, 36, 19, -1, 0, 36, 20, -1, 0, 36, 21, -1, 0, 36, 22, -1, 0, 36, 23, -1, 0, 36, 24, -1, 0, 36, 25, -1, 0, 36, 26, -1, 0, 36, 27, -1, 0, 36, 28, -1, 0, 36, 29, -1, 0, 36, 30, 594, 0, 36, 31, 595, 0, 36, 32, 562, 0, 36, 33, 563, 0, 36, 34, 594, 0, 36, 35, 595, 0, 36, 36, 562, 0, 36, 37, 563, 0, 36, 38, 594, 0, 36, 39, 595, 0, 36, 40, 578, 0, 36, 41, 579, 0, 36, 42, 594, 0, 36, 43, 595, 0, 36, 44, 578, 0, 36, 45, 579, 0, 36, 46, 594, 0, 36, 47, 595, 0, 36, 48, -1, 0, 36, 49, -1, 0, 36, 50, -1, 0, 36, 51, -1, 0, 36, 52, -1, 0, 36, 53, -1, 0, 36, 54, -1, 0, 36, 55, -1, 0, 36, 56, -1, 0, 36, 57, -1, 0, 36, 58, -1, 0, 36, 59, -1, 0, 36, 60, -1, 0, 36, 61, -1, 0, 36, 62, -1, 0, 36, 63, -1, 0, 37, 0, -1, 0, 37, 1, -1, 0, 37, 2, -1, 0, 37, 3, -1, 0, 37, 4, -1, 0, 37, 5, -1, 0, 37, 6, -1, 0, 37, 7, -1, 0, 37, 8, -1, 0, 37, 9, -1, 0, 37, 10, -1, 0, 37, 11, -1, 0, 37, 12, -1, 0, 37, 13, -1, 0, 37, 14, -1, 0, 37, 15, -1, 0, 37, 16, -1, 0, 37, 17, -1, 0, 37, 18, -1, 0, 37, 19, -1, 0, 37, 20, -1, 0, 37, 21, -1, 0, 37, 22, -1, 0, 37, 23, -1, 0, 37, 24, -1, 0, 37, 25, -1, 0, 37, 26, -1, 0, 37, 27, -1, 0, 37, 28, -1, 0, 37, 29, -1, 0, 37, 30, 562, 0, 37, 31, 563, 0, 37, 32, 578, 0, 37, 33, 579, 0, 37, 34, 562, 0, 37, 35, 563, 0, 37, 36, 578, 0, 37, 37, 579, 0, 37, 38, 562, 0, 37, 39, 563, 0, 37, 40, 594, 0, 37, 41, 595, 0, 37, 42, 562, 0, 37, 43, 563, 0, 37, 44, 594, 0, 37, 45, 595, 0, 37, 46, 562, 0, 37, 47, 563, 0, 37, 48, -1, 0, 37, 49, -1, 0, 37, 50, -1, 0, 37, 51, -1, 0, 37, 52, -1, 0, 37, 53, -1, 0, 37, 54, -1, 0, 37, 55, -1, 0, 37, 56, -1, 0, 37, 57, -1, 0, 37, 58, -1, 0, 37, 59, -1, 0, 37, 60, -1, 0, 37, 61, -1, 0, 37, 62, -1, 0, 37, 63, -1, 0, 38, 0, -1, 0, 38, 1, -1, 0, 38, 2, -1, 0, 38, 3, -1, 0, 38, 4, -1, 0, 38, 5, -1, 0, 38, 6, -1, 0, 38, 7, -1, 0, 38, 8, -1, 0, 38, 9, -1, 0, 38, 10, -1, 0, 38, 11, -1, 0, 38, 12, -1, 0, 38, 13, -1, 0, 38, 14, -1, 0, 38, 15, -1, 0, 38, 16, -1, 0, 38, 17, -1, 0, 38, 18, -1, 0, 38, 19, -1, 0, 38, 20, -1, 0, 38, 21, -1, 0, 38, 22, -1, 0, 38, 23, -1, 0, 38, 24, -1, 0, 38, 25, -1, 0, 38, 26, -1, 0, 38, 27, -1, 0, 38, 28, -1, 0, 38, 29, -1, 0, 38, 30, 578, 0, 38, 31, 579, 0, 38, 32, 594, 0, 38, 33, 595, 0, 38, 34, 578, 0, 38, 35, 579, 0, 38, 36, 594, 0, 38, 37, 595, 0, 38, 38, 578, 0, 38, 39, 579, 0, 38, 40, 562, 0, 38, 41, 563, 0, 38, 42, 578, 0, 38, 43, 579, 0, 38, 44, 562, 0, 38, 45, 563, 0, 38, 46, 578, 0, 38, 47, 579, 0, 38, 48, -1, 0, 38, 49, -1, 0, 38, 50, -1, 0, 38, 51, -1, 0, 38, 52, -1, 0, 38, 53, -1, 0, 38, 54, -1, 0, 38, 55, -1, 0, 38, 56, -1, 0, 38, 57, -1, 0, 38, 58, -1, 0, 38, 59, -1, 0, 38, 60, -1, 0, 38, 61, -1, 0, 38, 62, -1, 0, 38, 63, -1, 0, 39, 0, -1, 0, 39, 1, -1, 0, 39, 2, -1, 0, 39, 3, -1, 0, 39, 4, -1, 0, 39, 5, -1, 0, 39, 6, -1, 0, 39, 7, -1, 0, 39, 8, -1, 0, 39, 9, -1, 0, 39, 10, -1, 0, 39, 11, -1, 0, 39, 12, -1, 0, 39, 13, -1, 0, 39, 14, -1, 0, 39, 15, -1, 0, 39, 16, -1, 0, 39, 17, -1, 0, 39, 18, -1, 0, 39, 19, -1, 0, 39, 20, -1, 0, 39, 21, -1, 0, 39, 22, -1, 0, 39, 23, -1, 0, 39, 24, -1, 0, 39, 25, -1, 0, 39, 26, -1, 0, 39, 27, -1, 0, 39, 28, -1, 0, 39, 29, -1, 0, 39, 30, 594, 0, 39, 31, 595, 0, 39, 32, 562, 0, 39, 33, 563, 0, 39, 34, 594, 0, 39, 35, 595, 0, 39, 36, 562, 0, 39, 37, 563, 0, 39, 38, 594, 0, 39, 39, 595, 0, 39, 40, 578, 0, 39, 41, 579, 0, 39, 42, 594, 0, 39, 43, 595, 0, 39, 44, 578, 0, 39, 45, 579, 0, 39, 46, 594, 0, 39, 47, 595, 0, 39, 48, -1, 0, 39, 49, -1, 0, 39, 50, -1, 0, 39, 51, -1, 0, 39, 52, -1, 0, 39, 53, -1, 0, 39, 54, -1, 0, 39, 55, -1, 0, 39, 56, -1, 0, 39, 57, -1, 0, 39, 58, -1, 0, 39, 59, -1, 0, 39, 60, -1, 0, 39, 61, -1, 0, 39, 62, -1, 0, 39, 63, -1, 0, 40, 0, -1, 0, 40, 1, -1, 0, 40, 2, -1, 0, 40, 3, -1, 0, 40, 4, -1, 0, 40, 5, -1, 0, 40, 6, -1, 0, 40, 7, -1, 0, 40, 8, -1, 0, 40, 9, -1, 0, 40, 10, -1, 0, 40, 11, -1, 0, 40, 12, -1, 0, 40, 13, -1, 0, 40, 14, -1, 0, 40, 15, -1, 0, 40, 16, -1, 0, 40, 17, -1, 0, 40, 18, -1, 0, 40, 19, -1, 0, 40, 20, -1, 0, 40, 21, -1, 0, 40, 22, -1, 0, 40, 23, -1, 0, 40, 24, -1, 0, 40, 25, -1, 0, 40, 26, -1, 0, 40, 27, -1, 0, 40, 28, 563, 0, 40, 29, 563, 0, 40, 30, 562, 0, 40, 31, 563, 0, 40, 32, 578, 0, 40, 33, 579, 0, 40, 34, 562, 0, 40, 35, 563, 0, 40, 36, 578, 0, 40, 37, 579, 0, 40, 38, 562, 0, 40, 39, 563, 0, 40, 40, 594, 0, 40, 41, 595, 0, 40, 42, 562, 0, 40, 43, 563, 0, 40, 44, 594, 0, 40, 45, 595, 0, 40, 46, 562, 0, 40, 47, 563, 0, 40, 48, -1, 0, 40, 49, -1, 0, 40, 50, -1, 0, 40, 51, -1, 0, 40, 52, -1, 0, 40, 53, -1, 0, 40, 54, -1, 0, 40, 55, -1, 0, 40, 56, -1, 0, 40, 57, -1, 0, 40, 58, -1, 0, 40, 59, -1, 0, 40, 60, -1, 0, 40, 61, -1, 0, 40, 62, -1, 0, 40, 63, -1, 0, 41, 0, -1, 0, 41, 1, -1, 0, 41, 2, -1, 0, 41, 3, -1, 0, 41, 4, -1, 0, 41, 5, -1, 0, 41, 6, -1, 0, 41, 7, -1, 0, 41, 8, -1, 0, 41, 9, -1, 0, 41, 10, -1, 0, 41, 11, -1, 0, 41, 12, -1, 0, 41, 13, -1, 0, 41, 14, -1, 0, 41, 15, -1, 0, 41, 16, -1, 0, 41, 17, -1, 0, 41, 18, -1, 0, 41, 19, -1, 0, 41, 20, -1, 0, 41, 21, -1, 0, 41, 22, -1, 0, 41, 23, -1, 0, 41, 24, -1, 0, 41, 25, -1, 0, 41, 26, -1, 0, 41, 27, -1, 0, 41, 28, 579, 0, 41, 29, 579, 0, 41, 30, 578, 0, 41, 31, 579, 0, 41, 32, 594, 0, 41, 33, 595, 0, 41, 34, 578, 0, 41, 35, 579, 0, 41, 36, 594, 0, 41, 37, 595, 0, 41, 38, 578, 0, 41, 39, 579, 0, 41, 40, 562, 0, 41, 41, 563, 0, 41, 42, 578, 0, 41, 43, 579, 0, 41, 44, 562, 0, 41, 45, 563, 0, 41, 46, 578, 0, 41, 47, 579, 0, 41, 48, -1, 0, 41, 49, -1, 0, 41, 50, -1, 0, 41, 51, -1, 0, 41, 52, -1, 0, 41, 53, -1, 0, 41, 54, -1, 0, 41, 55, -1, 0, 41, 56, -1, 0, 41, 57, -1, 0, 41, 58, -1, 0, 41, 59, -1, 0, 41, 60, -1, 0, 41, 61, -1, 0, 41, 62, -1, 0, 41, 63, -1, 0, 42, 0, -1, 0, 42, 1, -1, 0, 42, 2, -1, 0, 42, 3, -1, 0, 42, 4, -1, 0, 42, 5, -1, 0, 42, 6, -1, 0, 42, 7, -1, 0, 42, 8, -1, 0, 42, 9, -1, 0, 42, 10, -1, 0, 42, 11, -1, 0, 42, 12, -1, 0, 42, 13, -1, 0, 42, 14, -1, 0, 42, 15, -1, 0, 42, 16, -1, 0, 42, 17, -1, 0, 42, 18, -1, 0, 42, 19, -1, 0, 42, 20, -1, 0, 42, 21, -1, 0, 42, 22, -1, 0, 42, 23, -1, 0, 42, 24, -1, 0, 42, 25, -1, 0, 42, 26, -1, 0, 42, 27, -1, 0, 42, 28, 578, 0, 42, 29, 578, 0, 42, 30, 594, 0, 42, 31, 595, 0, 42, 32, 562, 0, 42, 33, 563, 0, 42, 34, 594, 0, 42, 35, 595, 0, 42, 36, 562, 0, 42, 37, 563, 0, 42, 38, 594, 0, 42, 39, 595, 0, 42, 40, 578, 0, 42, 41, 579, 0, 42, 42, 594, 0, 42, 43, 595, 0, 42, 44, 578, 0, 42, 45, 579, 0, 42, 46, 594, 0, 42, 47, 595, 0, 42, 48, -1, 0, 42, 49, -1, 0, 42, 50, -1, 0, 42, 51, -1, 0, 42, 52, -1, 0, 42, 53, -1, 0, 42, 54, -1, 0, 42, 55, -1, 0, 42, 56, -1, 0, 42, 57, -1, 0, 42, 58, -1, 0, 42, 59, -1, 0, 42, 60, -1, 0, 42, 61, -1, 0, 42, 62, -1, 0, 42, 63, -1, 0, 43, 0, -1, 0, 43, 1, -1, 0, 43, 2, -1, 0, 43, 3, -1, 0, 43, 4, -1, 0, 43, 5, -1, 0, 43, 6, -1, 0, 43, 7, -1, 0, 43, 8, -1, 0, 43, 9, -1, 0, 43, 10, -1, 0, 43, 11, -1, 0, 43, 12, -1, 0, 43, 13, -1, 0, 43, 14, -1, 0, 43, 15, -1, 0, 43, 16, -1, 0, 43, 17, -1, 0, 43, 18, -1, 0, 43, 19, -1, 0, 43, 20, -1, 0, 43, 21, -1, 0, 43, 22, -1, 0, 43, 23, -1, 0, 43, 24, -1, 0, 43, 25, -1, 0, 43, 26, -1, 0, 43, 27, -1, 0, 43, 28, -1, 0, 43, 29, -1, 0, 43, 30, 562, 0, 43, 31, 563, 0, 43, 32, 578, 0, 43, 33, 579, 0, 43, 34, 562, 0, 43, 35, 563, 0, 43, 36, 578, 0, 43, 37, 579, 0, 43, 38, 562, 0, 43, 39, 563, 0, 43, 40, 594, 0, 43, 41, 595, 0, 43, 42, 562, 0, 43, 43, 563, 0, 43, 44, 594, 0, 43, 45, 595, 0, 43, 46, 562, 0, 43, 47, 563, 0, 43, 48, -1, 0, 43, 49, -1, 0, 43, 50, -1, 0, 43, 51, -1, 0, 43, 52, -1, 0, 43, 53, -1, 0, 43, 54, -1, 0, 43, 55, -1, 0, 43, 56, -1, 0, 43, 57, -1, 0, 43, 58, -1, 0, 43, 59, -1, 0, 43, 60, -1, 0, 43, 61, -1, 0, 43, 62, -1, 0, 43, 63, -1, 0, 44, 0, -1, 0, 44, 1, -1, 0, 44, 2, -1, 0, 44, 3, -1, 0, 44, 4, -1, 0, 44, 5, -1, 0, 44, 6, -1, 0, 44, 7, -1, 0, 44, 8, -1, 0, 44, 9, -1, 0, 44, 10, -1, 0, 44, 11, -1, 0, 44, 12, -1, 0, 44, 13, -1, 0, 44, 14, -1, 0, 44, 15, -1, 0, 44, 16, -1, 0, 44, 17, -1, 0, 44, 18, -1, 0, 44, 19, -1, 0, 44, 20, -1, 0, 44, 21, -1, 0, 44, 22, -1, 0, 44, 23, -1, 0, 44, 24, -1, 0, 44, 25, -1, 0, 44, 26, -1, 0, 44, 27, -1, 0, 44, 28, -1, 0, 44, 29, -1, 0, 44, 30, 578, 0, 44, 31, 579, 0, 44, 32, 594, 0, 44, 33, 595, 0, 44, 34, 578, 0, 44, 35, 579, 0, 44, 36, 594, 0, 44, 37, 595, 0, 44, 38, 578, 0, 44, 39, 579, 0, 44, 40, 562, 0, 44, 41, 563, 0, 44, 42, 578, 0, 44, 43, 579, 0, 44, 44, 562, 0, 44, 45, 563, 0, 44, 46, 578, 0, 44, 47, 579, 0, 44, 48, -1, 0, 44, 49, -1, 0, 44, 50, -1, 0, 44, 51, -1, 0, 44, 52, -1, 0, 44, 53, -1, 0, 44, 54, -1, 0, 44, 55, -1, 0, 44, 56, -1, 0, 44, 57, -1, 0, 44, 58, -1, 0, 44, 59, -1, 0, 44, 60, -1, 0, 44, 61, -1, 0, 44, 62, -1, 0, 44, 63, -1, 0, 45, 0, -1, 0, 45, 1, -1, 0, 45, 2, -1, 0, 45, 3, -1, 0, 45, 4, -1, 0, 45, 5, -1, 0, 45, 6, -1, 0, 45, 7, -1, 0, 45, 8, -1, 0, 45, 9, -1, 0, 45, 10, -1, 0, 45, 11, -1, 0, 45, 12, -1, 0, 45, 13, -1, 0, 45, 14, -1, 0, 45, 15, -1, 0, 45, 16, -1, 0, 45, 17, -1, 0, 45, 18, -1, 0, 45, 19, -1, 0, 45, 20, -1, 0, 45, 21, -1, 0, 45, 22, -1, 0, 45, 23, -1, 0, 45, 24, -1, 0, 45, 25, -1, 0, 45, 26, -1, 0, 45, 27, -1, 0, 45, 28, -1, 0, 45, 29, -1, 0, 45, 30, 594, 0, 45, 31, 595, 0, 45, 32, 562, 0, 45, 33, 563, 0, 45, 34, 594, 0, 45, 35, 595, 0, 45, 36, 562, 0, 45, 37, 563, 0, 45, 38, 594, 0, 45, 39, 595, 0, 45, 40, 578, 0, 45, 41, 579, 0, 45, 42, 594, 0, 45, 43, 595, 0, 45, 44, 578, 0, 45, 45, 579, 0, 45, 46, 594, 0, 45, 47, 595, 0, 45, 48, -1, 0, 45, 49, -1, 0, 45, 50, -1, 0, 45, 51, -1, 0, 45, 52, -1, 0, 45, 53, -1, 0, 45, 54, -1, 0, 45, 55, -1, 0, 45, 56, -1, 0, 45, 57, -1, 0, 45, 58, -1, 0, 45, 59, -1, 0, 45, 60, -1, 0, 45, 61, -1, 0, 45, 62, -1, 0, 45, 63, -1, 0, 46, 0, -1, 0, 46, 1, -1, 0, 46, 2, -1, 0, 46, 3, -1, 0, 46, 4, -1, 0, 46, 5, -1, 0, 46, 6, -1, 0, 46, 7, -1, 0, 46, 8, -1, 0, 46, 9, -1, 0, 46, 10, -1, 0, 46, 11, -1, 0, 46, 12, -1, 0, 46, 13, -1, 0, 46, 14, -1, 0, 46, 15, -1, 0, 46, 16, -1, 0, 46, 17, -1, 0, 46, 18, -1, 0, 46, 19, -1, 0, 46, 20, -1, 0, 46, 21, -1, 0, 46, 22, -1, 0, 46, 23, -1, 0, 46, 24, -1, 0, 46, 25, -1, 0, 46, 26, -1, 0, 46, 27, -1, 0, 46, 28, -1, 0, 46, 29, -1, 0, 46, 30, 562, 0, 46, 31, 563, 0, 46, 32, 578, 0, 46, 33, 579, 0, 46, 34, 562, 0, 46, 35, 563, 0, 46, 36, 578, 0, 46, 37, 579, 0, 46, 38, 562, 0, 46, 39, 563, 0, 46, 40, 594, 0, 46, 41, 595, 0, 46, 42, 562, 0, 46, 43, 563, 0, 46, 44, 594, 0, 46, 45, 595, 0, 46, 46, 562, 0, 46, 47, 563, 0, 46, 48, -1, 0, 46, 49, -1, 0, 46, 50, -1, 0, 46, 51, -1, 0, 46, 52, -1, 0, 46, 53, -1, 0, 46, 54, -1, 0, 46, 55, -1, 0, 46, 56, -1, 0, 46, 57, -1, 0, 46, 58, -1, 0, 46, 59, -1, 0, 46, 60, -1, 0, 46, 61, -1, 0, 46, 62, -1, 0, 46, 63, -1, 0, 47, 0, -1, 0, 47, 1, -1, 0, 47, 2, -1, 0, 47, 3, -1, 0, 47, 4, -1, 0, 47, 5, -1, 0, 47, 6, -1, 0, 47, 7, -1, 0, 47, 8, -1, 0, 47, 9, -1, 0, 47, 10, -1, 0, 47, 11, -1, 0, 47, 12, -1, 0, 47, 13, -1, 0, 47, 14, -1, 0, 47, 15, -1, 0, 47, 16, -1, 0, 47, 17, -1, 0, 47, 18, -1, 0, 47, 19, -1, 0, 47, 20, -1, 0, 47, 21, -1, 0, 47, 22, -1, 0, 47, 23, -1, 0, 47, 24, -1, 0, 47, 25, -1, 0, 47, 26, -1, 0, 47, 27, -1, 0, 47, 28, -1, 0, 47, 29, -1, 0, 47, 30, 578, 0, 47, 31, 579, 0, 47, 32, 594, 0, 47, 33, 595, 0, 47, 34, 578, 0, 47, 35, 579, 0, 47, 36, 594, 0, 47, 37, 595, 0, 47, 38, 578, 0, 47, 39, 579, 0, 47, 40, 562, 0, 47, 41, 563, 0, 47, 42, 578, 0, 47, 43, 579, 0, 47, 44, 562, 0, 47, 45, 563, 0, 47, 46, 578, 0, 47, 47, 579, 0, 47, 48, -1, 0, 47, 49, -1, 0, 47, 50, -1, 0, 47, 51, -1, 0, 47, 52, -1, 0, 47, 53, -1, 0, 47, 54, -1, 0, 47, 55, -1, 0, 47, 56, -1, 0, 47, 57, -1, 0, 47, 58, -1, 0, 47, 59, -1, 0, 47, 60, -1, 0, 47, 61, -1, 0, 47, 62, -1, 0, 47, 63, -1, 0, 48, 0, -1, 0, 48, 1, -1, 0, 48, 2, -1, 0, 48, 3, -1, 0, 48, 4, -1, 0, 48, 5, -1, 0, 48, 6, -1, 0, 48, 7, -1, 0, 48, 8, -1, 0, 48, 9, -1, 0, 48, 10, -1, 0, 48, 11, -1, 0, 48, 12, -1, 0, 48, 13, -1, 0, 48, 14, -1, 0, 48, 15, -1, 0, 48, 16, -1, 0, 48, 17, -1, 0, 48, 18, -1, 0, 48, 19, -1, 0, 48, 20, -1, 0, 48, 21, -1, 0, 48, 22, -1, 0, 48, 23, -1, 0, 48, 24, -1, 0, 48, 25, -1, 0, 48, 26, -1, 0, 48, 27, -1, 0, 48, 28, -1, 0, 48, 29, -1, 0, 48, 30, 594, 0, 48, 31, 595, 0, 48, 32, 562, 0, 48, 33, 563, 0, 48, 34, 594, 0, 48, 35, 595, 0, 48, 36, 562, 0, 48, 37, 563, 0, 48, 38, 594, 0, 48, 39, 595, 0, 48, 40, 578, 0, 48, 41, 579, 0, 48, 42, 594, 0, 48, 43, 595, 0, 48, 44, 578, 0, 48, 45, 579, 0, 48, 46, 594, 0, 48, 47, 595, 0, 48, 48, -1, 0, 48, 49, -1, 0, 48, 50, -1, 0, 48, 51, -1, 0, 48, 52, -1, 0, 48, 53, -1, 0, 48, 54, -1, 0, 48, 55, -1, 0, 48, 56, -1, 0, 48, 57, -1, 0, 48, 58, -1, 0, 48, 59, -1, 0, 48, 60, -1, 0, 48, 61, -1, 0, 48, 62, -1, 0, 48, 63, -1, 0, 49, 0, -1, 0, 49, 1, -1, 0, 49, 2, -1, 0, 49, 3, -1, 0, 49, 4, -1, 0, 49, 5, -1, 0, 49, 6, -1, 0, 49, 7, -1, 0, 49, 8, -1, 0, 49, 9, -1, 0, 49, 10, -1, 0, 49, 11, -1, 0, 49, 12, -1, 0, 49, 13, -1, 0, 49, 14, -1, 0, 49, 15, -1, 0, 49, 16, -1, 0, 49, 17, -1, 0, 49, 18, -1, 0, 49, 19, -1, 0, 49, 20, -1, 0, 49, 21, -1, 0, 49, 22, -1, 0, 49, 23, -1, 0, 49, 24, -1, 0, 49, 25, -1, 0, 49, 26, -1, 0, 49, 27, -1, 0, 49, 28, -1, 0, 49, 29, -1, 0, 49, 30, 562, 0, 49, 31, 563, 0, 49, 32, 578, 0, 49, 33, 579, 0, 49, 34, 562, 0, 49, 35, 563, 0, 49, 36, 578, 0, 49, 37, 579, 0, 49, 38, 562, 0, 49, 39, 563, 0, 49, 40, 594, 0, 49, 41, 595, 0, 49, 42, 562, 0, 49, 43, 563, 0, 49, 44, 594, 0, 49, 45, 595, 0, 49, 46, 562, 0, 49, 47, 563, 0, 49, 48, -1, 0, 49, 49, -1, 0, 49, 50, -1, 0, 49, 51, -1, 0, 49, 52, -1, 0, 49, 53, -1, 0, 49, 54, -1, 0, 49, 55, -1, 0, 49, 56, -1, 0, 49, 57, -1, 0, 49, 58, -1, 0, 49, 59, -1, 0, 49, 60, -1, 0, 49, 61, -1, 0, 49, 62, -1, 0, 49, 63, -1, 0, 50, 0, -1, 0, 50, 1, -1, 0, 50, 2, -1, 0, 50, 3, -1, 0, 50, 4, -1, 0, 50, 5, -1, 0, 50, 6, -1, 0, 50, 7, -1, 0, 50, 8, -1, 0, 50, 9, -1, 0, 50, 10, -1, 0, 50, 11, -1, 0, 50, 12, -1, 0, 50, 13, -1, 0, 50, 14, -1, 0, 50, 15, -1, 0, 50, 16, -1, 0, 50, 17, -1, 0, 50, 18, -1, 0, 50, 19, -1, 0, 50, 20, -1, 0, 50, 21, -1, 0, 50, 22, -1, 0, 50, 23, -1, 0, 50, 24, -1, 0, 50, 25, -1, 0, 50, 26, -1, 0, 50, 27, -1, 0, 50, 28, -1, 0, 50, 29, -1, 0, 50, 30, 578, 0, 50, 31, 579, 0, 50, 32, 594, 0, 50, 33, 595, 0, 50, 34, 578, 0, 50, 35, 579, 0, 50, 36, 594, 0, 50, 37, 595, 0, 50, 38, 578, 0, 50, 39, 579, 0, 50, 40, 562, 0, 50, 41, 563, 0, 50, 42, 578, 0, 50, 43, 579, 0, 50, 44, 562, 0, 50, 45, 563, 0, 50, 46, 578, 0, 50, 47, 579, 0, 50, 48, -1, 0, 50, 49, -1, 0, 50, 50, -1, 0, 50, 51, -1, 0, 50, 52, -1, 0, 50, 53, -1, 0, 50, 54, -1, 0, 50, 55, -1, 0, 50, 56, 562, 0, 50, 57, 563, 0, 50, 58, -1, 0, 50, 59, -1, 0, 50, 60, -1, 0, 50, 61, -1, 0, 50, 62, -1, 0, 50, 63, -1, 0, 51, 0, -1, 0, 51, 1, -1, 0, 51, 2, -1, 0, 51, 3, -1, 0, 51, 4, -1, 0, 51, 5, -1, 0, 51, 6, -1, 0, 51, 7, -1, 0, 51, 8, -1, 0, 51, 9, -1, 0, 51, 10, -1, 0, 51, 11, -1, 0, 51, 12, -1, 0, 51, 13, -1, 0, 51, 14, -1, 0, 51, 15, -1, 0, 51, 16, -1, 0, 51, 17, -1, 0, 51, 18, -1, 0, 51, 19, -1, 0, 51, 20, 562, 0, 51, 21, 563, 0, 51, 22, -1, 0, 51, 23, -1, 0, 51, 24, -1, 0, 51, 25, -1, 0, 51, 26, -1, 0, 51, 27, -1, 0, 51, 28, 562, 0, 51, 29, 563, 0, 51, 30, 594, 0, 51, 31, 595, 0, 51, 32, 562, 0, 51, 33, 563, 0, 51, 34, 594, 0, 51, 35, 595, 0, 51, 36, 562, 0, 51, 37, 563, 0, 51, 38, 594, 0, 51, 39, 595, 0, 51, 40, 578, 0, 51, 41, 579, 0, 51, 42, 594, 0, 51, 43, 595, 0, 51, 44, 578, 0, 51, 45, 579, 0, 51, 46, 594, 0, 51, 47, 595, 0, 51, 48, 562, 0, 51, 49, 563, 0, 51, 50, -1, 0, 51, 51, -1, 0, 51, 52, 562, 0, 51, 53, 563, 0, 51, 54, -1, 0, 51, 55, -1, 0, 51, 56, 578, 0, 51, 57, 579, 0, 51, 58, -1, 0, 51, 59, -1, 0, 51, 60, -1, 0, 51, 61, -1, 0, 51, 62, -1, 0, 51, 63, -1, 0, 52, 0, -1, 0, 52, 1, -1, 0, 52, 2, -1, 0, 52, 3, -1, 0, 52, 4, -1, 0, 52, 5, -1, 0, 52, 6, -1, 0, 52, 7, -1, 0, 52, 8, -1, 0, 52, 9, -1, 0, 52, 10, -1, 0, 52, 11, -1, 0, 52, 12, -1, 0, 52, 13, -1, 0, 52, 14, -1, 0, 52, 15, -1, 0, 52, 16, 562, 0, 52, 17, 563, 0, 52, 18, 562, 0, 52, 19, 563, 0, 52, 20, 578, 0, 52, 21, 579, 0, 52, 22, 562, 0, 52, 23, 563, 0, 52, 24, 562, 0, 52, 25, 563, 0, 52, 26, 562, 0, 52, 27, 563, 0, 52, 28, 578, 0, 52, 29, 579, 0, 52, 30, 562, 0, 52, 31, 563, 0, 52, 32, 578, 0, 52, 33, 579, 0, 52, 34, 562, 0, 52, 35, 563, 0, 52, 36, 578, 0, 52, 37, 579, 0, 52, 38, 562, 0, 52, 39, 563, 0, 52, 40, 594, 0, 52, 41, 595, 0, 52, 42, 562, 0, 52, 43, 563, 0, 52, 44, 594, 0, 52, 45, 595, 0, 52, 46, 562, 0, 52, 47, 563, 0, 52, 48, 578, 0, 52, 49, 579, 0, 52, 50, 562, 0, 52, 51, 563, 0, 52, 52, 578, 0, 52, 53, 579, 0, 52, 54, 562, 0, 52, 55, 563, 0, 52, 56, 594, 0, 52, 57, 595, 0, 52, 58, 562, 0, 52, 59, 563, 0, 52, 60, 563, 0, 52, 61, 562, 0, 52, 62, 563, 0, 52, 63, -1, 0, 53, 0, -1, 0, 53, 1, -1, 0, 53, 2, -1, 0, 53, 3, -1, 0, 53, 4, -1, 0, 53, 5, -1, 0, 53, 6, -1, 0, 53, 7, -1, 0, 53, 8, -1, 0, 53, 9, -1, 0, 53, 10, -1, 0, 53, 11, -1, 0, 53, 12, -1, 0, 53, 13, -1, 0, 53, 14, -1, 0, 53, 15, -1, 0, 53, 16, 578, 0, 53, 17, 579, 0, 53, 18, 578, 0, 53, 19, 579, 0, 53, 20, 594, 0, 53, 21, 595, 0, 53, 22, 562, 0, 53, 23, 563, 0, 53, 24, 578, 0, 53, 25, 579, 0, 53, 26, 562, 0, 53, 27, 563, 0, 53, 28, 594, 0, 53, 29, 595, 0, 53, 30, 578, 0, 53, 31, 579, 0, 53, 32, 594, 0, 53, 33, 595, 0, 53, 34, 578, 0, 53, 35, 579, 0, 53, 36, 594, 0, 53, 37, 595, 0, 53, 38, 578, 0, 53, 39, 579, 0, 53, 40, 562, 0, 53, 41, 563, 0, 53, 42, 578, 0, 53, 43, 579, 0, 53, 44, 562, 0, 53, 45, 563, 0, 53, 46, 578, 0, 53, 47, 579, 0, 53, 48, 594, 0, 53, 49, 595, 0, 53, 50, 578, 0, 53, 51, 579, 0, 53, 52, 594, 0, 53, 53, 595, 0, 53, 54, 578, 0, 53, 55, 579, 0, 53, 56, 562, 0, 53, 57, 563, 0, 53, 58, 578, 0, 53, 59, 579, 0, 53, 60, 562, 0, 53, 61, 563, 0, 53, 62, 579, 0, 53, 63, -1, 0, 54, 0, -1, 0, 54, 1, -1, 0, 54, 2, -1, 0, 54, 3, -1, 0, 54, 4, -1, 0, 54, 5, -1, 0, 54, 6, -1, 0, 54, 7, -1, 0, 54, 8, -1, 0, 54, 9, -1, 0, 54, 10, -1, 0, 54, 11, -1, 0, 54, 12, -1, 0, 54, 13, -1, 0, 54, 14, -1, 0, 54, 15, -1, 0, 54, 16, 594, 0, 54, 17, 595, 0, 54, 18, 594, 0, 54, 19, 595, 0, 54, 20, 562, 0, 54, 21, 563, 0, 54, 22, 578, 0, 54, 23, 579, 0, 54, 24, 594, 0, 54, 25, 595, 0, 54, 26, 578, 0, 54, 27, 579, 0, 54, 28, 562, 0, 54, 29, 563, 0, 54, 30, 594, 0, 54, 31, 595, 0, 54, 32, 562, 0, 54, 33, 563, 0, 54, 34, 594, 0, 54, 35, 595, 0, 54, 36, 562, 0, 54, 37, 563, 0, 54, 38, 594, 0, 54, 39, 595, 0, 54, 40, 578, 0, 54, 41, 579, 0, 54, 42, 594, 0, 54, 43, 595, 0, 54, 44, 578, 0, 54, 45, 579, 0, 54, 46, 594, 0, 54, 47, 595, 0, 54, 48, 562, 0, 54, 49, 563, 0, 54, 50, 594, 0, 54, 51, 595, 0, 54, 52, 562, 0, 54, 53, 563, 0, 54, 54, 594, 0, 54, 55, 595, 0, 54, 56, 578, 0, 54, 57, 579, 0, 54, 58, 594, 0, 54, 59, 595, 0, 54, 60, 578, 0, 54, 61, 579, 0, 54, 62, 595, 0, 54, 63, -1, 0, 55, 0, -1, 0, 55, 1, -1, 0, 55, 2, -1, 0, 55, 3, -1, 0, 55, 4, -1, 0, 55, 5, -1, 0, 55, 6, -1, 0, 55, 7, -1, 0, 55, 8, -1, 0, 55, 9, -1, 0, 55, 10, -1, 0, 55, 11, -1, 0, 55, 12, -1, 0, 55, 13, -1, 0, 55, 14, -1, 0, 55, 15, -1, 0, 55, 16, 562, 0, 55, 17, 563, 0, 55, 18, 562, 0, 55, 19, 563, 0, 55, 20, 578, 0, 55, 21, 579, 0, 55, 22, 594, 0, 55, 23, 595, 0, 55, 24, 562, 0, 55, 25, 563, 0, 55, 26, 594, 0, 55, 27, 595, 0, 55, 28, 578, 0, 55, 29, 579, 0, 55, 30, 562, 0, 55, 31, 563, 0, 55, 32, 578, 0, 55, 33, 579, 0, 55, 34, 562, 0, 55, 35, 563, 0, 55, 36, 578, 0, 55, 37, 579, 0, 55, 38, 562, 0, 55, 39, 563, 0, 55, 40, 594, 0, 55, 41, 595, 0, 55, 42, 562, 0, 55, 43, 563, 0, 55, 44, 594, 0, 55, 45, 595, 0, 55, 46, 562, 0, 55, 47, 563, 0, 55, 48, 578, 0, 55, 49, 579, 0, 55, 50, 562, 0, 55, 51, 563, 0, 55, 52, 578, 0, 55, 53, 579, 0, 55, 54, 562, 0, 55, 55, 563, 0, 55, 56, 594, 0, 55, 57, 595, 0, 55, 58, 562, 0, 55, 59, 563, 0, 55, 60, 594, 0, 55, 61, 595, 0, 55, 62, 563, 0, 55, 63, -1, 0, 56, 0, -1, 0, 56, 1, -1, 0, 56, 2, -1, 0, 56, 3, -1, 0, 56, 4, -1, 0, 56, 5, -1, 0, 56, 6, -1, 0, 56, 7, -1, 0, 56, 8, -1, 0, 56, 9, -1, 0, 56, 10, -1, 0, 56, 11, -1, 0, 56, 12, -1, 0, 56, 13, -1, 0, 56, 14, -1, 0, 56, 15, -1, 0, 56, 16, 578, 0, 56, 17, 579, 0, 56, 18, 578, 0, 56, 19, 579, 0, 56, 20, 594, 0, 56, 21, 595, 0, 56, 22, 562, 0, 56, 23, 563, 0, 56, 24, 578, 0, 56, 25, 579, 0, 56, 26, 562, 0, 56, 27, 563, 0, 56, 28, 594, 0, 56, 29, 595, 0, 56, 30, 578, 0, 56, 31, 579, 0, 56, 32, 594, 0, 56, 33, 595, 0, 56, 34, 578, 0, 56, 35, 579, 0, 56, 36, 594, 0, 56, 37, 595, 0, 56, 38, 578, 0, 56, 39, 579, 0, 56, 40, 562, 0, 56, 41, 563, 0, 56, 42, 578, 0, 56, 43, 579, 0, 56, 44, 562, 0, 56, 45, 563, 0, 56, 46, 578, 0, 56, 47, 579, 0, 56, 48, 594, 0, 56, 49, 595, 0, 56, 50, 578, 0, 56, 51, 579, 0, 56, 52, 594, 0, 56, 53, 595, 0, 56, 54, 578, 0, 56, 55, 579, 0, 56, 56, 562, 0, 56, 57, 563, 0, 56, 58, 578, 0, 56, 59, 579, 0, 56, 60, 562, 0, 56, 61, 563, 0, 56, 62, 579, 0, 56, 63, -1, 0, 57, 0, -1, 0, 57, 1, -1, 0, 57, 2, -1, 0, 57, 3, -1, 0, 57, 4, -1, 0, 57, 5, -1, 0, 57, 6, -1, 0, 57, 7, -1, 0, 57, 8, -1, 0, 57, 9, -1, 0, 57, 10, -1, 0, 57, 11, -1, 0, 57, 12, -1, 0, 57, 13, -1, 0, 57, 14, -1, 0, 57, 15, -1, 0, 57, 16, 594, 0, 57, 17, 595, 0, 57, 18, 594, 0, 57, 19, 595, 0, 57, 20, 562, 0, 57, 21, 563, 0, 57, 22, 578, 0, 57, 23, 579, 0, 57, 24, 594, 0, 57, 25, 595, 0, 57, 26, 578, 0, 57, 27, 579, 0, 57, 28, 562, 0, 57, 29, 563, 0, 57, 30, 594, 0, 57, 31, 595, 0, 57, 32, 562, 0, 57, 33, 563, 0, 57, 34, 594, 0, 57, 35, 595, 0, 57, 36, 562, 0, 57, 37, 563, 0, 57, 38, 594, 0, 57, 39, 595, 0, 57, 40, 578, 0, 57, 41, 579, 0, 57, 42, 594, 0, 57, 43, 595, 0, 57, 44, 578, 0, 57, 45, 579, 0, 57, 46, 594, 0, 57, 47, 595, 0, 57, 48, 562, 0, 57, 49, 563, 0, 57, 50, 594, 0, 57, 51, 595, 0, 57, 52, 562, 0, 57, 53, 563, 0, 57, 54, 594, 0, 57, 55, 595, 0, 57, 56, 578, 0, 57, 57, 579, 0, 57, 58, 594, 0, 57, 59, 595, 0, 57, 60, 578, 0, 57, 61, 579, 0, 57, 62, 595, 0, 57, 63, -1, 0, 58, 0, -1, 0, 58, 1, -1, 0, 58, 2, -1, 0, 58, 3, -1, 0, 58, 4, -1, 0, 58, 5, -1, 0, 58, 6, -1, 0, 58, 7, -1, 0, 58, 8, -1, 0, 58, 9, -1, 0, 58, 10, -1, 0, 58, 11, -1, 0, 58, 12, -1, 0, 58, 13, -1, 0, 58, 14, -1, 0, 58, 15, -1, 0, 58, 16, 562, 0, 58, 17, 563, 0, 58, 18, 562, 0, 58, 19, 563, 0, 58, 20, 578, 0, 58, 21, 579, 0, 58, 22, 594, 0, 58, 23, 595, 0, 58, 24, 562, 0, 58, 25, 563, 0, 58, 26, 594, 0, 58, 27, 595, 0, 58, 28, 578, 0, 58, 29, 579, 0, 58, 30, 562, 0, 58, 31, 563, 0, 58, 32, 578, 0, 58, 33, 579, 0, 58, 34, 562, 0, 58, 35, 563, 0, 58, 36, 578, 0, 58, 37, 579, 0, 58, 38, 562, 0, 58, 39, 563, 0, 58, 40, 594, 0, 58, 41, 595, 0, 58, 42, 562, 0, 58, 43, 563, 0, 58, 44, 594, 0, 58, 45, 595, 0, 58, 46, 562, 0, 58, 47, 563, 0, 58, 48, 578, 0, 58, 49, 579, 0, 58, 50, 562, 0, 58, 51, 563, 0, 58, 52, 578, 0, 58, 53, 579, 0, 58, 54, 562, 0, 58, 55, 563, 0, 58, 56, 594, 0, 58, 57, 595, 0, 58, 58, 562, 0, 58, 59, 563, 0, 58, 60, 594, 0, 58, 61, 595, 0, 58, 62, 563, 0, 58, 63, -1, 0, 59, 0, -1, 0, 59, 1, -1, 0, 59, 2, -1, 0, 59, 3, -1, 0, 59, 4, -1, 0, 59, 5, -1, 0, 59, 6, -1, 0, 59, 7, -1, 0, 59, 8, -1, 0, 59, 9, -1, 0, 59, 10, -1, 0, 59, 11, -1, 0, 59, 12, -1, 0, 59, 13, -1, 0, 59, 14, -1, 0, 59, 15, -1, 0, 59, 16, 578, 0, 59, 17, 579, 0, 59, 18, 578, 0, 59, 19, 579, 0, 59, 20, 594, 0, 59, 21, 595, 0, 59, 22, 562, 0, 59, 23, 563, 0, 59, 24, 578, 0, 59, 25, 579, 0, 59, 26, 562, 0, 59, 27, 563, 0, 59, 28, 594, 0, 59, 29, 595, 0, 59, 30, 578, 0, 59, 31, 579, 0, 59, 32, 594, 0, 59, 33, 595, 0, 59, 34, 578, 0, 59, 35, 579, 0, 59, 36, 594, 0, 59, 37, 595, 0, 59, 38, 578, 0, 59, 39, 579, 0, 59, 40, 562, 0, 59, 41, 563, 0, 59, 42, 578, 0, 59, 43, 579, 0, 59, 44, 562, 0, 59, 45, 563, 0, 59, 46, 578, 0, 59, 47, 579, 0, 59, 48, 594, 0, 59, 49, 595, 0, 59, 50, 578, 0, 59, 51, 579, 0, 59, 52, 594, 0, 59, 53, 595, 0, 59, 54, 578, 0, 59, 55, 579, 0, 59, 56, 562, 0, 59, 57, 563, 0, 59, 58, 578, 0, 59, 59, 579, 0, 59, 60, 562, 0, 59, 61, 563, 0, 59, 62, 579, 0, 59, 63, -1, 0, 60, 0, -1, 0, 60, 1, -1, 0, 60, 2, -1, 0, 60, 3, -1, 0, 60, 4, -1, 0, 60, 5, -1, 0, 60, 6, -1, 0, 60, 7, -1, 0, 60, 8, -1, 0, 60, 9, -1, 0, 60, 10, -1, 0, 60, 11, -1, 0, 60, 12, -1, 0, 60, 13, -1, 0, 60, 14, -1, 0, 60, 15, -1, 0, 60, 16, 594, 0, 60, 17, 595, 0, 60, 18, 594, 0, 60, 19, 595, 0, 60, 20, 562, 0, 60, 21, 563, 0, 60, 22, 578, 0, 60, 23, 579, 0, 60, 24, 594, 0, 60, 25, 595, 0, 60, 26, 578, 0, 60, 27, 579, 0, 60, 28, 562, 0, 60, 29, 563, 0, 60, 30, 594, 0, 60, 31, 595, 0, 60, 32, 562, 0, 60, 33, 563, 0, 60, 34, 594, 0, 60, 35, 595, 0, 60, 36, 562, 0, 60, 37, 563, 0, 60, 38, 594, 0, 60, 39, 595, 0, 60, 40, 578, 0, 60, 41, 579, 0, 60, 42, 594, 0, 60, 43, 595, 0, 60, 44, 578, 0, 60, 45, 579, 0, 60, 46, 594, 0, 60, 47, 595, 0, 60, 48, 562, 0, 60, 49, 563, 0, 60, 50, 594, 0, 60, 51, 595, 0, 60, 52, 562, 0, 60, 53, 563, 0, 60, 54, 594, 0, 60, 55, 595, 0, 60, 56, 578, 0, 60, 57, 579, 0, 60, 58, 594, 0, 60, 59, 595, 0, 60, 60, 578, 0, 60, 61, 579, 0, 60, 62, 595, 0, 60, 63, -1, 0, 61, 0, -1, 0, 61, 1, -1, 0, 61, 2, -1, 0, 61, 3, -1, 0, 61, 4, -1, 0, 61, 5, -1, 0, 61, 6, -1, 0, 61, 7, -1, 0, 61, 8, -1, 0, 61, 9, -1, 0, 61, 10, -1, 0, 61, 11, -1, 0, 61, 12, -1, 0, 61, 13, -1, 0, 61, 14, -1, 0, 61, 15, -1, 0, 61, 16, 562, 0, 61, 17, 563, 0, 61, 18, 562, 0, 61, 19, 563, 0, 61, 20, 578, 0, 61, 21, 579, 0, 61, 22, 594, 0, 61, 23, 595, 0, 61, 24, 562, 0, 61, 25, 563, 0, 61, 26, 594, 0, 61, 27, 595, 0, 61, 28, 578, 0, 61, 29, 579, 0, 61, 30, 562, 0, 61, 31, 563, 0, 61, 32, 578, 0, 61, 33, 579, 0, 61, 34, 562, 0, 61, 35, 563, 0, 61, 36, 578, 0, 61, 37, 579, 0, 61, 38, 562, 0, 61, 39, 563, 0, 61, 40, 594, 0, 61, 41, 595, 0, 61, 42, 562, 0, 61, 43, 563, 0, 61, 44, 594, 0, 61, 45, 595, 0, 61, 46, 562, 0, 61, 47, 563, 0, 61, 48, 578, 0, 61, 49, 579, 0, 61, 50, 562, 0, 61, 51, 563, 0, 61, 52, 578, 0, 61, 53, 579, 0, 61, 54, 562, 0, 61, 55, 563, 0, 61, 56, 594, 0, 61, 57, 595, 0, 61, 58, 562, 0, 61, 59, 563, 0, 61, 60, 594, 0, 61, 61, 595, 0, 61, 62, 563, 0, 61, 63, -1, 0, 62, 0, -1, 0, 62, 1, -1, 0, 62, 2, -1, 0, 62, 3, -1, 0, 62, 4, -1, 0, 62, 5, -1, 0, 62, 6, -1, 0, 62, 7, -1, 0, 62, 8, -1, 0, 62, 9, -1, 0, 62, 10, -1, 0, 62, 11, -1, 0, 62, 12, -1, 0, 62, 13, -1, 0, 62, 14, -1, 0, 62, 15, -1, 0, 62, 16, 578, 0, 62, 17, 579, 0, 62, 18, 578, 0, 62, 19, 579, 0, 62, 20, 594, 0, 62, 21, 595, 0, 62, 22, 562, 0, 62, 23, 563, 0, 62, 24, 578, 0, 62, 25, 579, 0, 62, 26, 562, 0, 62, 27, 563, 0, 62, 28, 594, 0, 62, 29, 595, 0, 62, 30, 578, 0, 62, 31, 579, 0, 62, 32, 594, 0, 62, 33, 595, 0, 62, 34, 578, 0, 62, 35, 579, 0, 62, 36, 594, 0, 62, 37, 595, 0, 62, 38, 578, 0, 62, 39, 579, 0, 62, 40, 562, 0, 62, 41, 563, 0, 62, 42, 578, 0, 62, 43, 579, 0, 62, 44, 562, 0, 62, 45, 563, 0, 62, 46, 578, 0, 62, 47, 579, 0, 62, 48, 594, 0, 62, 49, 595, 0, 62, 50, 578, 0, 62, 51, 579, 0, 62, 52, 594, 0, 62, 53, 595, 0, 62, 54, 578, 0, 62, 55, 579, 0, 62, 56, 562, 0, 62, 57, 563, 0, 62, 58, 578, 0, 62, 59, 579, 0, 62, 60, 562, 0, 62, 61, 563, 0, 62, 62, 579, 0, 62, 63, -1, 0, 63, 0, -1, 0, 63, 1, -1, 0, 63, 2, -1, 0, 63, 3, -1, 0, 63, 4, -1, 0, 63, 5, -1, 0, 63, 6, -1, 0, 63, 7, -1, 0, 63, 8, -1, 0, 63, 9, -1, 0, 63, 10, -1, 0, 63, 11, -1, 0, 63, 12, -1, 0, 63, 13, -1, 0, 63, 14, -1, 0, 63, 15, -1, 0, 63, 16, 594, 0, 63, 17, 595, 0, 63, 18, 594, 0, 63, 19, 595, 0, 63, 20, -1, 0, 63, 21, -1, 0, 63, 22, 578, 0, 63, 23, 579, 0, 63, 24, 594, 0, 63, 25, 595, 0, 63, 26, 578, 0, 63, 27, 579, 0, 63, 28, -1, 0, 63, 29, -1, 0, 63, 30, -1, 0, 63, 31, -1, 0, 63, 32, -1, 0, 63, 33, -1, 0, 63, 34, -1, 0, 63, 35, -1, 0, 63, 36, -1, 0, 63, 37, -1, 0, 63, 38, 594, 0, 63, 39, 595, 0, 63, 40, -1, 0, 63, 41, -1, 0, 63, 42, 594, 0, 63, 43, 595, 0, 63, 44, -1, 0, 63, 45, -1, 0, 63, 46, 594, 0, 63, 47, 595, 0, 63, 48, -1, 0, 63, 49, -1, 0, 63, 50, 594, 0, 63, 51, 595, 0, 63, 52, -1, 0, 63, 53, -1, 0, 63, 54, 594, 0, 63, 55, 595, 0, 63, 56, 578, 0, 63, 57, 579, 0, 63, 58, 594, 0, 63, 59, 595, 0, 63, 60, 578, 0, 63, 61, 579, 0, 63, 62, 595, 0, 63, 63, -1, 1, 0, 1, -1, 1, 1, 5, -1, 1, 1, 6, -1, 1, 1, 7, -1, 1, 1, 8, -1, 1, 1, 9, -1, 1, 1, 10, -1, 1, 1, 11, -1, 1, 1, 12, -1, 1, 1, 13, -1, 1, 1, 14, -1, 1, 1, 22, -1, 1, 1, 23, -1, 1, 1, 24, -1, 1, 1, 25, -1, 1, 1, 26, -1, 1, 1, 27, -1, 1, 1, 28, -1, 1, 1, 29, -1, 1, 1, 30, -1, 1, 1, 31, -1, 1, 1, 40, -1, 1, 1, 41, -1, 1, 1, 42, -1, 1, 1, 43, -1, 1, 1, 44, -1, 1, 1, 45, -1, 1, 1, 46, -1, 1, 1, 47, -1, 1, 1, 48, -1, 1, 1, 49, -1, 1, 1, 54, -1, 1, 2, 4, -1, 1, 2, 5, -1, 1, 2, 6, -1, 1, 2, 7, -1, 1, 2, 8, -1, 1, 2, 9, -1, 1, 2, 10, -1, 1, 2, 11, -1, 1, 2, 12, -1, 1, 2, 13, -1, 1, 2, 14, -1, 1, 2, 21, -1, 1, 2, 22, -1, 1, 2, 23, -1, 1, 2, 24, -1, 1, 2, 25, -1, 1, 2, 26, -1, 1, 2, 27, -1, 1, 2, 28, -1, 1, 2, 29, -1, 1, 2, 30, -1, 1, 2, 31, -1, 1, 2, 39, -1, 1, 2, 40, -1, 1, 2, 41, -1, 1, 2, 42, -1, 1, 2, 43, -1, 1, 2, 44, -1, 1, 2, 45, -1, 1, 2, 46, -1, 1, 2, 47, -1, 1, 2, 48, -1, 1, 2, 49, -1, 1, 3, 4, -1, 1, 3, 5, -1, 1, 3, 6, -1, 1, 3, 7, -1, 1, 3, 8, -1, 1, 3, 9, -1, 1, 3, 10, -1, 1, 3, 11, -1, 1, 3, 12, -1, 1, 3, 13, -1, 1, 3, 14, -1, 1, 3, 21, -1, 1, 3, 22, -1, 1, 3, 23, -1, 1, 3, 24, -1, 1, 3, 25, -1, 1, 3, 26, -1, 1, 3, 27, -1, 1, 3, 28, -1, 1, 3, 29, -1, 1, 3, 30, -1, 1, 3, 31, -1, 1, 3, 39, -1, 1, 3, 40, -1, 1, 3, 41, -1, 1, 3, 42, -1, 1, 3, 43, -1, 1, 3, 44, -1, 1, 3, 45, -1, 1, 3, 46, -1, 1, 3, 47, -1, 1, 3, 48, -1, 1, 3, 49, -1, 1, 4, 4, -1, 1, 4, 5, -1, 1, 4, 6, -1, 1, 4, 7, -1, 1, 4, 8, -1, 1, 4, 9, -1, 1, 4, 10, -1, 1, 4, 11, -1, 1, 4, 12, -1, 1, 4, 13, -1, 1, 4, 14, -1, 1, 4, 21, -1, 1, 4, 22, -1, 1, 4, 23, -1, 1, 4, 24, -1, 1, 4, 25, -1, 1, 4, 26, -1, 1, 4, 27, -1, 1, 4, 28, -1, 1, 4, 29, -1, 1, 4, 30, -1, 1, 4, 31, -1, 1, 4, 39, -1, 1, 4, 40, -1, 1, 4, 41, -1, 1, 4, 42, -1, 1, 4, 43, -1, 1, 4, 44, -1, 1, 4, 45, -1, 1, 4, 46, -1, 1, 4, 47, -1, 1, 4, 48, -1, 1, 4, 49, -1, 1, 5, 47, -1, 1, 6, 11, -1, 1, 6, 30, -1, 1, 6, 47, -1, 1, 6, 60, -1, 1, 8, 7, -1, 1, 8, 25, -1, 1, 8, 55, -1, 1, 9, 3, -1, 1, 9, 10, -1, 1, 10, 10, -1, 1, 10, 37, -1, 1, 12, 10, -1, 1, 13, 16, 529, 1, 13, 17, 530, 1, 13, 18, 531, 1, 13, 19, 530, 1, 13, 20, 531, 1, 13, 21, 530, 1, 13, 22, 531, 1, 13, 23, 530, 1, 13, 24, 531, 1, 13, 25, 530, 1, 13, 26, 531, 1, 13, 27, 530, 1, 13, 28, 531, 1, 13, 29, 530, 1, 13, 30, 531, 1, 13, 31, 530, 1, 13, 32, 531, 1, 13, 33, 530, 1, 13, 34, 531, 1, 13, 35, 530, 1, 13, 36, 531, 1, 13, 37, 530, 1, 13, 38, 531, 1, 13, 39, 530, 1, 13, 40, 531, 1, 13, 41, 530, 1, 13, 42, 531, 1, 13, 43, 530, 1, 13, 44, 531, 1, 13, 45, 530, 1, 13, 46, 530, 1, 13, 47, 531, 1, 13, 48, 530, 1, 13, 49, 531, 1, 13, 50, 530, 1, 13, 51, 531, 1, 13, 52, 530, 1, 13, 53, 531, 1, 13, 54, 530, 1, 13, 55, 531, 1, 13, 56, 530, 1, 13, 57, 531, 1, 13, 58, 530, 1, 13, 59, 531, 1, 13, 60, 530, 1, 13, 61, 531, 1, 13, 62, 532, 1, 14, 11, -1, 1, 14, 16, 545, 1, 14, 17, 546, 1, 14, 18, 547, 1, 14, 19, 546, 1, 14, 20, 547, 1, 14, 21, 546, 1, 14, 22, 547, 1, 14, 23, 546, 1, 14, 24, 547, 1, 14, 25, 546, 1, 14, 26, 547, 1, 14, 27, 546, 1, 14, 28, 547, 1, 14, 29, 546, 1, 14, 30, 547, 1, 14, 31, 546, 1, 14, 32, 547, 1, 14, 33, 546, 1, 14, 34, 547, 1, 14, 35, 546, 1, 14, 36, 547, 1, 14, 37, 546, 1, 14, 38, 547, 1, 14, 39, 546, 1, 14, 40, 547, 1, 14, 41, 546, 1, 14, 42, 547, 1, 14, 43, 546, 1, 14, 44, 547, 1, 14, 45, 546, 1, 14, 46, 546, 1, 14, 47, 547, 1, 14, 48, 546, 1, 14, 49, 547, 1, 14, 50, 546, 1, 14, 51, 547, 1, 14, 52, 546, 1, 14, 53, 547, 1, 14, 54, 546, 1, 14, 55, 547, 1, 14, 56, 546, 1, 14, 57, 547, 1, 14, 58, 546, 1, 14, 59, 547, 1, 14, 60, 546, 1, 14, 61, 547, 1, 14, 62, 548, 1, 15, 6, -1, 1, 16, 19, 525, 1, 16, 20, 526, 1, 16, 21, 527, 1, 16, 26, 525, 1, 16, 27, 526, 1, 16, 28, 527, 1, 16, 33, 525, 1, 16, 34, 526, 1, 16, 35, 527, 1, 16, 40, 525, 1, 16, 41, 526, 1, 16, 42, 527, 1, 16, 47, 525, 1, 16, 48, 526, 1, 16, 49, 527, 1, 16, 54, 525, 1, 16, 55, 526, 1, 16, 56, 527, 1, 17, 2, -1, 1, 17, 3, -1, 1, 17, 19, 557, 1, 17, 20, 558, 1, 17, 21, 559, 1, 17, 26, 557, 1, 17, 27, 558, 1, 17, 28, 559, 1, 17, 33, 557, 1, 17, 34, 558, 1, 17, 35, 559, 1, 17, 40, 557, 1, 17, 41, 558, 1, 17, 42, 559, 1, 17, 47, 557, 1, 17, 48, 558, 1, 17, 49, 559, 1, 17, 54, 557, 1, 17, 55, 558, 1, 17, 56, 559, 1, 18, 2, -1, 1, 18, 3, -1, 1, 22, 8, -1, 1, 22, 19, 525, 1, 22, 20, 526, 1, 22, 21, 527, 1, 22, 26, 525, 1, 22, 27, 526, 1, 22, 28, 527, 1, 22, 33, 525, 1, 22, 34, 526, 1, 22, 35, 527, 1, 22, 40, 525, 1, 22, 41, 526, 1, 22, 42, 527, 1, 22, 47, 525, 1, 22, 48, 526, 1, 22, 49, 527, 1, 22, 54, 525, 1, 22, 55, 526, 1, 22, 56, 527, 1, 23, 19, 557, 1, 23, 20, 558, 1, 23, 21, 559, 1, 23, 26, 557, 1, 23, 27, 558, 1, 23, 28, 559, 1, 23, 33, 557, 1, 23, 34, 558, 1, 23, 35, 559, 1, 23, 40, 557, 1, 23, 41, 558, 1, 23, 42, 559, 1, 23, 47, 557, 1, 23, 48, 558, 1, 23, 49, 559, 1, 23, 54, 557, 1, 23, 55, 558, 1, 23, 56, 559, 1, 27, 29, -1, 1, 28, 3, -1, 1, 28, 15, -1, 1, 28, 16, -1, 1, 28, 17, -1, 1, 28, 18, -1, 1, 28, 19, 525, 1, 28, 20, 526, 1, 28, 21, 527, 1, 28, 22, -1, 1, 28, 23, -1, 1, 28, 24, -1, 1, 28, 25, -1, 1, 28, 26, 525, 1, 28, 27, 526, 1, 28, 28, 527, 1, 28, 29, -1, 1, 28, 30, -1, 1, 28, 31, -1, 1, 28, 32, -1, 1, 28, 33, -1, 1, 28, 34, -1, 1, 28, 35, -1, 1, 28, 36, -1, 1, 28, 37, -1, 1, 28, 38, -1, 1, 28, 39, -1, 1, 28, 40, -1, 1, 28, 41, -1, 1, 28, 42, -1, 1, 28, 43, -1, 1, 28, 44, -1, 1, 28, 45, -1, 1, 28, 46, -1, 1, 28, 47, -1, 1, 29, 9, -1, 1, 29, 14, -1, 1, 29, 15, -1, 1, 29, 16, -1, 1, 29, 17, -1, 1, 29, 18, -1, 1, 29, 19, 557, 1, 29, 20, 558, 1, 29, 21, 559, 1, 29, 22, -1, 1, 29, 23, -1, 1, 29, 24, -1, 1, 29, 25, -1, 1, 29, 26, 557, 1, 29, 27, 558, 1, 29, 28, 559, 1, 29, 29, -1, 1, 29, 30, -1, 1, 29, 31, -1, 1, 29, 32, -1, 1, 29, 33, -1, 1, 29, 34, -1, 1, 29, 35, -1, 1, 29, 36, -1, 1, 29, 37, -1, 1, 29, 38, -1, 1, 29, 39, -1, 1, 29, 40, -1, 1, 29, 41, -1, 1, 29, 42, -1, 1, 29, 43, -1, 1, 29, 44, -1, 1, 29, 45, -1, 1, 29, 46, -1, 1, 29, 47, -1, 1, 30, 14, -1, 1, 30, 15, -1, 1, 30, 16, -1, 1, 30, 17, -1, 1, 30, 18, -1, 1, 30, 19, -1, 1, 30, 20, -1, 1, 30, 21, -1, 1, 30, 22, -1, 1, 30, 23, -1, 1, 30, 24, -1, 1, 30, 25, -1, 1, 30, 26, -1, 1, 30, 27, -1, 1, 30, 28, -1, 1, 30, 29, -1, 1, 30, 30, -1, 1, 30, 31, -1, 1, 30, 32, -1, 1, 30, 33, -1, 1, 30, 34, -1, 1, 30, 35, -1, 1, 30, 36, -1, 1, 30, 37, -1, 1, 30, 38, -1, 1, 30, 39, -1, 1, 30, 40, -1, 1, 30, 41, -1, 1, 30, 42, -1, 1, 30, 43, -1, 1, 30, 44, -1, 1, 30, 45, -1, 1, 30, 46, -1, 1, 30, 47, -1, 1, 31, 11, -1, 1, 31, 14, -1, 1, 31, 15, -1, 1, 31, 16, -1, 1, 31, 17, -1, 1, 31, 18, -1, 1, 31, 19, -1, 1, 31, 20, -1, 1, 31, 21, -1, 1, 31, 22, -1, 1, 31, 23, -1, 1, 31, 24, -1, 1, 31, 25, -1, 1, 31, 26, -1, 1, 31, 27, -1, 1, 31, 28, -1, 1, 31, 29, -1, 1, 31, 30, -1, 1, 31, 31, -1, 1, 31, 32, -1, 1, 31, 33, -1, 1, 31, 34, -1, 1, 31, 35, -1, 1, 31, 36, -1, 1, 31, 37, -1, 1, 31, 38, -1, 1, 31, 39, -1, 1, 31, 40, -1, 1, 31, 41, -1, 1, 31, 42, -1, 1, 31, 43, -1, 1, 31, 44, -1, 1, 31, 45, -1, 1, 31, 46, -1, 1, 31, 47, -1, 1, 32, 2, -1, 1, 33, 15, -1, 1, 33, 22, -1, 1, 33, 23, -1, 1, 34, 22, -1, 1, 34, 23, -1, 1, 35, 8, -1, 1, 36, 26, -1, 1, 37, 29, 552, 1, 37, 30, 553, 1, 38, 5, -1, 1, 38, 20, -1, 1, 38, 29, 568, 1, 38, 30, 569, 1, 39, 10, -1, 1, 39, 29, 584, 1, 39, 30, 585, 1, 42, 7, -1, 1, 42, 29, -1, 1, 43, 29, -1, 1, 44, 17, -1, 1, 44, 29, -1, 1, 45, 24, -1, 1, 47, 2, -1, 1, 47, 10, -1, 1, 47, 17, -1, 1, 47, 49, -1, 1, 47, 56, -1, 1, 47, 57, -1, 1, 48, 56, -1, 1, 48, 57, -1, 1, 49, 4, -1, 1, 49, 48, 514, 1, 49, 49, 515, 1, 49, 50, 514, 1, 49, 51, 515, 1, 49, 52, 514, 1, 49, 53, 515, 1, 49, 54, 514, 1, 49, 55, 515, 1, 49, 56, 514, 1, 49, 57, 515, 1, 49, 58, 634, 1, 49, 59, 635, 1, 49, 60, 636, 1, 49, 61, 637, 1, 49, 62, 638, 1, 50, 16, 529, 1, 50, 17, 530, 1, 50, 18, 531, 1, 50, 19, 530, 1, 50, 20, 531, 1, 50, 21, 530, 1, 50, 22, 531, 1, 50, 23, 530, 1, 50, 24, 531, 1, 50, 25, 530, 1, 50, 26, 531, 1, 50, 27, 530, 1, 50, 28, 531, 1, 50, 29, 568, 1, 50, 30, 569, 1, 50, 46, 566, 1, 50, 47, 567, 1, 50, 48, 530, 1, 50, 49, 531, 1, 50, 50, 530, 1, 50, 51, 531, 1, 50, 52, 530, 1, 50, 53, 531, 1, 50, 54, 530, 1, 50, 55, 531, 1, 50, 56, 530, 1, 50, 57, 531, 1, 50, 58, 650, 1, 50, 59, 651, 1, 50, 60, 652, 1, 50, 61, 653, 1, 50, 62, 654, 1, 51, 16, 545, 1, 51, 17, 546, 1, 51, 18, 547, 1, 51, 19, 546, 1, 51, 20, 547, 1, 51, 21, 546, 1, 51, 22, 547, 1, 51, 23, 546, 1, 51, 24, 547, 1, 51, 25, 546, 1, 51, 26, 547, 1, 51, 27, 546, 1, 51, 28, 547, 1, 51, 29, 584, 1, 51, 30, 585, 1, 51, 46, 582, 1, 51, 47, 583, 1, 51, 48, 546, 1, 51, 49, 547, 1, 51, 50, 546, 1, 51, 51, 547, 1, 51, 52, 546, 1, 51, 53, 547, 1, 51, 54, 546, 1, 51, 55, 547, 1, 51, 56, 546, 1, 51, 57, 547, 1, 51, 58, 666, 1, 51, 59, 667, 1, 51, 60, 668, 1, 51, 61, 669, 1, 51, 62, 670, 1, 53, 18, 571, 1, 53, 19, 572, 1, 53, 20, 573, 1, 53, 26, 571, 1, 53, 27, 572, 1, 53, 28, 573, 1, 53, 57, -1, 1, 54, 8, -1, 1, 54, 12, -1, 1, 54, 18, 522, 1, 54, 19, 523, 1, 54, 20, 524, 1, 54, 26, 522, 1, 54, 27, 523, 1, 54, 28, 524, 1, 55, 17, 570, 1, 55, 18, 538, 1, 55, 19, 539, 1, 55, 20, 540, 1, 55, 21, 570, 1, 55, 25, 570, 1, 55, 26, 538, 1, 55, 27, 539, 1, 55, 28, 540, 1, 55, 29, 570, 1, 56, 18, 554, 1, 56, 19, 555, 1, 56, 20, 556, 1, 56, 26, 554, 1, 56, 27, 555, 1, 56, 28, 556, 1, 57, 2, -1, 1, 58, 46, -1, 1, 58, 47, -1, 1, 58, 48, -1, 1, 58, 49, -1, 1, 58, 50, -1, 1, 58, 51, -1, 1, 58, 52, -1, 1, 58, 53, -1, 1, 58, 54, -1, 1, 58, 55, -1, 1, 58, 56, -1, 1, 58, 57, -1, 1, 58, 58, -1, 1, 58, 59, -1, 1, 58, 60, -1, 1, 58, 61, -1, 1, 58, 62, -1, 1, 58, 63, -1, 1, 59, 18, 571, 1, 59, 19, 572, 1, 59, 20, 573, 1, 59, 26, 571, 1, 59, 27, 572, 1, 59, 28, 573, 1, 59, 46, -1, 1, 59, 47, -1, 1, 59, 48, -1, 1, 59, 49, -1, 1, 59, 50, -1, 1, 59, 51, -1, 1, 59, 52, -1, 1, 59, 53, -1, 1, 59, 54, -1, 1, 59, 55, -1, 1, 59, 56, -1, 1, 59, 57, -1, 1, 59, 58, -1, 1, 59, 59, -1, 1, 59, 60, -1, 1, 59, 61, -1, 1, 59, 62, -1, 1, 59, 63, -1, 1, 60, 12, -1, 1, 60, 15, -1, 1, 60, 16, -1, 1, 60, 17, -1, 1, 60, 18, 522, 1, 60, 19, 523, 1, 60, 20, 524, 1, 60, 21, -1, 1, 60, 22, -1, 1, 60, 23, -1, 1, 60, 24, -1, 1, 60, 25, -1, 1, 60, 26, 522, 1, 60, 27, 523, 1, 60, 28, 524, 1, 60, 29, -1, 1, 60, 30, -1, 1, 60, 31, -1, 1, 60, 32, -1, 1, 60, 33, -1, 1, 60, 34, -1, 1, 60, 35, -1, 1, 60, 36, -1, 1, 60, 37, -1, 1, 60, 38, -1, 1, 60, 39, -1, 1, 60, 40, -1, 1, 60, 41, -1, 1, 60, 42, -1, 1, 60, 43, -1, 1, 60, 44, -1, 1, 60, 45, -1, 1, 60, 46, -1, 1, 60, 47, -1, 1, 60, 48, -1, 1, 60, 49, -1, 1, 60, 50, -1, 1, 60, 51, -1, 1, 60, 52, -1, 1, 60, 53, -1, 1, 60, 54, -1, 1, 60, 55, -1, 1, 60, 56, -1, 1, 60, 57, -1, 1, 60, 58, -1, 1, 60, 59, -1, 1, 60, 60, -1, 1, 60, 61, -1, 1, 60, 62, -1, 1, 60, 63, -1, 1, 61, 2, -1, 1, 61, 6, -1, 1, 61, 14, -1, 1, 61, 15, -1, 1, 61, 16, -1, 1, 61, 17, 570, 1, 61, 18, 538, 1, 61, 19, 539, 1, 61, 20, 540, 1, 61, 21, 570, 1, 61, 22, -1, 1, 61, 23, -1, 1, 61, 24, -1, 1, 61, 25, 570, 1, 61, 26, 538, 1, 61, 27, 539, 1, 61, 28, 540, 1, 61, 29, 570, 1, 61, 30, -1, 1, 61, 31, -1, 1, 61, 32, -1, 1, 61, 33, -1, 1, 61, 34, -1, 1, 61, 35, -1, 1, 61, 36, -1, 1, 61, 37, -1, 1, 61, 38, -1, 1, 61, 39, -1, 1, 61, 40, -1, 1, 61, 41, -1, 1, 61, 42, -1, 1, 61, 43, -1, 1, 61, 44, -1, 1, 61, 45, -1, 1, 61, 46, -1, 1, 61, 47, -1, 1, 61, 48, -1, 1, 61, 49, -1, 1, 61, 50, -1, 1, 61, 51, -1, 1, 61, 52, -1, 1, 61, 53, -1, 1, 61, 54, -1, 1, 61, 55, -1, 1, 61, 56, -1, 1, 61, 57, -1, 1, 61, 58, -1, 1, 61, 59, -1, 1, 61, 60, -1, 1, 61, 61, -1, 1, 61, 62, -1, 1, 61, 63, -1, 1, 62, 2, -1, 1, 62, 14, -1, 1, 62, 15, -1, 1, 62, 16, -1, 1, 62, 17, -1, 1, 62, 18, 554, 1, 62, 19, 555, 1, 62, 20, 556, 1, 62, 21, -1, 1, 62, 22, -1, 1, 62, 23, -1, 1, 62, 24, -1, 1, 62, 25, -1, 1, 62, 26, 554, 1, 62, 27, 555, 1, 62, 28, 556, 1, 62, 29, -1, 1, 62, 30, -1, 1, 62, 31, -1, 1, 62, 32, -1, 1, 62, 33, -1, 1, 62, 34, -1, 1, 62, 35, -1, 1, 62, 36, -1, 1, 62, 37, -1, 1, 62, 38, -1, 1, 62, 39, -1, 1, 62, 40, -1, 1, 62, 41, -1, 1, 62, 42, -1, 1, 62, 43, -1, 1, 62, 44, -1, 1, 62, 45, -1, 1, 62, 46, -1, 1, 62, 47, -1, 1, 62, 48, -1, 1, 62, 49, -1, 1, 62, 50, -1, 1, 62, 51, -1, 1, 62, 52, -1, 1, 62, 53, -1, 1, 62, 54, -1, 1, 62, 55, -1, 1, 62, 56, -1, 1, 62, 57, -1, 1, 62, 58, -1, 1, 62, 59, -1, 1, 62, 60, -1, 1, 62, 61, -1, 1, 62, 62, -1, 1, 62, 63, -1, 1, 63, 14, -1, 1, 63, 15, -1, 1, 63, 16, -1, 1, 63, 17, -1, 1, 63, 18, -1, 1, 63, 19, -1, 1, 63, 20, -1, 1, 63, 21, -1, 1, 63, 22, -1, 1, 63, 23, -1, 1, 63, 24, -1, 1, 63, 25, -1, 1, 63, 26, -1, 1, 63, 27, -1, 1, 63, 28, -1, 1, 63, 29, -1, 1, 63, 30, -1, 1, 63, 31, -1, 1, 63, 32, -1, 1, 63, 33, -1, 1, 63, 34, -1, 1, 63, 35, -1, 1, 63, 36, -1, 1, 63, 37, -1, 1, 63, 38, -1, 1, 63, 39, -1, 1, 63, 40, -1, 1, 63, 41, -1, 1, 63, 42, -1, 1, 63, 43, -1, 1, 63, 44, -1, 1, 63, 45, -1, 1, 63, 46, -1, 1, 63, 47, -1, 1, 63, 48, -1, 1, 63, 49, -1, 1, 63, 50, -1, 1, 63, 51, -1, 1, 63, 52, -1, 1, 63, 53, -1, 1, 63, 54, -1, 1, 63, 55, -1, 1, 63, 56, -1, 1, 63, 57, -1, 1, 63, 58, -1, 1, 63, 59, -1, 1, 63, 60, -1, 1, 63, 61, -1, 1, 63, 62, -1, 1, 63, 63, -1, 2, 0, 4, -1, 2, 0, 5, -1, 2, 0, 6, -1, 2, 0, 7, -1, 2, 0, 8, -1, 2, 0, 9, -1, 2, 0, 10, -1, 2, 0, 11, -1, 2, 0, 12, -1, 2, 0, 13, -1, 2, 0, 14, -1, 2, 0, 15, -1, 2, 0, 21, -1, 2, 0, 22, -1, 2, 0, 23, -1, 2, 0, 24, -1, 2, 0, 25, -1, 2, 0, 26, -1, 2, 0, 27, -1, 2, 0, 28, -1, 2, 0, 29, -1, 2, 0, 30, -1, 2, 0, 31, -1, 2, 0, 32, -1, 2, 0, 39, -1, 2, 0, 40, -1, 2, 0, 41, -1, 2, 0, 42, -1, 2, 0, 43, -1, 2, 0, 44, -1, 2, 0, 45, -1, 2, 0, 46, -1, 2, 0, 47, -1, 2, 0, 48, -1, 2, 0, 49, -1, 2, 0, 50, -1, 2, 1, 4, -1, 2, 1, 15, -1, 2, 1, 21, -1, 2, 1, 32, -1, 2, 1, 39, -1, 2, 1, 50, -1, 2, 5, 47, -1, 2, 9, 10, -1, 2, 11, 14, -1, 2, 11, 15, -1, 2, 11, 16, -1, 2, 11, 17, -1, 2, 11, 18, -1, 2, 11, 19, -1, 2, 11, 20, -1, 2, 11, 21, -1, 2, 11, 22, -1, 2, 11, 23, -1, 2, 11, 24, -1, 2, 11, 25, -1, 2, 11, 26, -1, 2, 11, 27, -1, 2, 11, 28, -1, 2, 11, 29, -1, 2, 11, 30, -1, 2, 11, 31, -1, 2, 11, 32, -1, 2, 11, 33, -1, 2, 11, 34, -1, 2, 11, 35, -1, 2, 11, 36, -1, 2, 11, 37, -1, 2, 11, 38, -1, 2, 11, 39, -1, 2, 11, 40, -1, 2, 11, 41, -1, 2, 11, 42, -1, 2, 11, 43, -1, 2, 11, 44, -1, 2, 11, 45, -1, 2, 11, 46, -1, 2, 11, 47, -1, 2, 11, 48, -1, 2, 11, 49, -1, 2, 11, 50, -1, 2, 11, 51, -1, 2, 11, 52, -1, 2, 11, 53, -1, 2, 11, 54, -1, 2, 11, 55, -1, 2, 11, 56, -1, 2, 11, 57, -1, 2, 11, 58, -1, 2, 11, 59, -1, 2, 11, 60, -1, 2, 11, 61, -1, 2, 11, 62, -1, 2, 11, 63, -1, 2, 12, 14, -1, 2, 12, 15, 512, 2, 12, 16, 513, 2, 12, 17, 514, 2, 12, 18, 515, 2, 12, 19, 514, 2, 12, 20, 515, 2, 12, 21, 514, 2, 12, 22, 515, 2, 12, 23, 514, 2, 12, 24, 515, 2, 12, 25, 514, 2, 12, 26, 515, 2, 12, 27, 514, 2, 12, 28, 515, 2, 12, 29, 514, 2, 12, 30, 515, 2, 12, 31, 514, 2, 12, 32, 515, 2, 12, 33, 514, 2, 12, 34, 515, 2, 12, 35, 514, 2, 12, 36, 515, 2, 12, 37, 514, 2, 12, 38, 515, 2, 12, 39, 514, 2, 12, 40, 515, 2, 12, 41, 514, 2, 12, 42, 515, 2, 12, 43, 514, 2, 12, 44, 515, 2, 12, 45, 514, 2, 12, 46, 515, 2, 12, 47, 514, 2, 12, 48, 515, 2, 12, 49, 514, 2, 12, 50, 515, 2, 12, 51, 514, 2, 12, 52, 515, 2, 12, 53, 514, 2, 12, 54, 515, 2, 12, 55, 514, 2, 12, 56, 515, 2, 12, 57, 514, 2, 12, 58, 515, 2, 12, 59, 514, 2, 12, 60, 515, 2, 12, 61, 514, 2, 12, 62, 516, 2, 12, 63, 517, 2, 13, 14, -1, 2, 13, 15, 528, 2, 13, 16, -1, 2, 13, 17, -1, 2, 13, 18, -1, 2, 13, 19, -1, 2, 13, 20, -1, 2, 13, 21, -1, 2, 13, 22, -1, 2, 13, 23, -1, 2, 13, 24, -1, 2, 13, 25, -1, 2, 13, 26, -1, 2, 13, 27, -1, 2, 13, 28, -1, 2, 13, 29, -1, 2, 13, 30, -1, 2, 13, 31, -1, 2, 13, 32, -1, 2, 13, 33, -1, 2, 13, 34, -1, 2, 13, 35, -1, 2, 13, 36, -1, 2, 13, 37, -1, 2, 13, 38, -1, 2, 13, 39, -1, 2, 13, 40, -1, 2, 13, 41, -1, 2, 13, 42, -1, 2, 13, 43, -1, 2, 13, 44, -1, 2, 13, 45, -1, 2, 13, 46, -1, 2, 13, 47, -1, 2, 13, 48, -1, 2, 13, 49, -1, 2, 13, 50, -1, 2, 13, 51, -1, 2, 13, 52, -1, 2, 13, 53, -1, 2, 13, 54, -1, 2, 13, 55, -1, 2, 13, 56, -1, 2, 13, 57, -1, 2, 13, 58, -1, 2, 13, 59, -1, 2, 13, 60, -1, 2, 13, 61, -1, 2, 13, 62, -1, 2, 13, 63, 533, 2, 14, 14, -1, 2, 14, 15, 560, 2, 14, 16, -1, 2, 14, 17, -1, 2, 14, 18, -1, 2, 14, 19, -1, 2, 14, 20, -1, 2, 14, 21, -1, 2, 14, 22, -1, 2, 14, 23, -1, 2, 14, 24, -1, 2, 14, 25, -1, 2, 14, 26, -1, 2, 14, 27, -1, 2, 14, 28, -1, 2, 14, 29, -1, 2, 14, 30, -1, 2, 14, 31, -1, 2, 14, 32, -1, 2, 14, 33, -1, 2, 14, 34, -1, 2, 14, 35, -1, 2, 14, 36, -1, 2, 14, 37, -1, 2, 14, 38, -1, 2, 14, 39, -1, 2, 14, 40, -1, 2, 14, 41, -1, 2, 14, 42, -1, 2, 14, 43, -1, 2, 14, 44, -1, 2, 14, 45, -1, 2, 14, 46, -1, 2, 14, 47, -1, 2, 14, 48, -1, 2, 14, 49, -1, 2, 14, 50, -1, 2, 14, 51, -1, 2, 14, 52, -1, 2, 14, 53, -1, 2, 14, 54, -1, 2, 14, 55, -1, 2, 14, 56, -1, 2, 14, 57, -1, 2, 14, 58, -1, 2, 14, 59, -1, 2, 14, 60, -1, 2, 14, 61, -1, 2, 14, 62, -1, 2, 14, 63, 549, 2, 15, 14, -1, 2, 15, 15, 576, 2, 15, 16, -1, 2, 15, 17, -1, 2, 15, 18, -1, 2, 15, 19, -1, 2, 15, 20, -1, 2, 15, 21, -1, 2, 15, 22, -1, 2, 15, 23, -1, 2, 15, 24, -1, 2, 15, 25, -1, 2, 15, 26, -1, 2, 15, 27, -1, 2, 15, 28, -1, 2, 15, 29, -1, 2, 15, 30, -1, 2, 15, 31, -1, 2, 15, 32, -1, 2, 15, 33, -1, 2, 15, 34, -1, 2, 15, 35, -1, 2, 15, 36, -1, 2, 15, 37, -1, 2, 15, 38, -1, 2, 15, 39, -1, 2, 15, 40, -1, 2, 15, 41, -1, 2, 15, 42, -1, 2, 15, 43, -1, 2, 15, 44, -1, 2, 15, 45, -1, 2, 15, 46, -1, 2, 15, 47, -1, 2, 15, 48, -1, 2, 15, 49, -1, 2, 15, 50, -1, 2, 15, 51, -1, 2, 15, 52, -1, 2, 15, 53, -1, 2, 15, 54, -1, 2, 15, 55, -1, 2, 15, 56, -1, 2, 15, 57, -1, 2, 15, 58, -1, 2, 15, 59, -1, 2, 15, 60, -1, 2, 15, 61, -1, 2, 15, 62, -1, 2, 15, 63, 565, 2, 16, 14, -1, 2, 16, 15, 560, 2, 16, 16, -1, 2, 16, 17, -1, 2, 16, 18, -1, 2, 16, 19, -1, 2, 16, 20, -1, 2, 16, 21, -1, 2, 16, 22, -1, 2, 16, 23, -1, 2, 16, 24, -1, 2, 16, 25, -1, 2, 16, 26, -1, 2, 16, 27, -1, 2, 16, 28, -1, 2, 16, 29, -1, 2, 16, 30, -1, 2, 16, 31, -1, 2, 16, 32, -1, 2, 16, 33, -1, 2, 16, 34, -1, 2, 16, 35, -1, 2, 16, 36, -1, 2, 16, 37, -1, 2, 16, 38, -1, 2, 16, 39, -1, 2, 16, 40, -1, 2, 16, 41, -1, 2, 16, 42, -1, 2, 16, 43, -1, 2, 16, 44, -1, 2, 16, 45, -1, 2, 16, 46, -1, 2, 16, 47, -1, 2, 16, 48, -1, 2, 16, 49, -1, 2, 16, 50, -1, 2, 16, 51, -1, 2, 16, 52, -1, 2, 16, 53, -1, 2, 16, 54, -1, 2, 16, 55, -1, 2, 16, 56, -1, 2, 16, 57, -1, 2, 16, 58, -1, 2, 16, 59, -1, 2, 16, 60, -1, 2, 16, 61, -1, 2, 16, 62, -1, 2, 16, 63, 581, 2, 17, 14, -1, 2, 17, 15, 576, 2, 17, 16, -1, 2, 17, 17, -1, 2, 17, 18, -1, 2, 17, 19, -1, 2, 17, 20, -1, 2, 17, 21, -1, 2, 17, 22, -1, 2, 17, 23, -1, 2, 17, 24, -1, 2, 17, 25, -1, 2, 17, 26, -1, 2, 17, 27, -1, 2, 17, 28, -1, 2, 17, 29, -1, 2, 17, 30, -1, 2, 17, 31, -1, 2, 17, 32, -1, 2, 17, 33, -1, 2, 17, 34, -1, 2, 17, 35, -1, 2, 17, 36, -1, 2, 17, 37, -1, 2, 17, 38, -1, 2, 17, 39, -1, 2, 17, 40, -1, 2, 17, 41, -1, 2, 17, 42, -1, 2, 17, 43, -1, 2, 17, 44, -1, 2, 17, 45, -1, 2, 17, 46, -1, 2, 17, 47, -1, 2, 17, 48, -1, 2, 17, 49, -1, 2, 17, 50, -1, 2, 17, 51, -1, 2, 17, 52, -1, 2, 17, 53, -1, 2, 17, 54, -1, 2, 17, 55, -1, 2, 17, 56, -1, 2, 17, 57, -1, 2, 17, 58, -1, 2, 17, 59, -1, 2, 17, 60, -1, 2, 17, 61, -1, 2, 17, 62, -1, 2, 17, 63, 549, 2, 18, 14, -1, 2, 18, 15, 560, 2, 18, 16, -1, 2, 18, 17, -1, 2, 18, 18, -1, 2, 18, 19, -1, 2, 18, 20, -1, 2, 18, 21, -1, 2, 18, 22, -1, 2, 18, 23, -1, 2, 18, 24, -1, 2, 18, 25, -1, 2, 18, 26, -1, 2, 18, 27, -1, 2, 18, 28, -1, 2, 18, 29, -1, 2, 18, 30, -1, 2, 18, 31, -1, 2, 18, 32, -1, 2, 18, 33, -1, 2, 18, 34, -1, 2, 18, 35, -1, 2, 18, 36, -1, 2, 18, 37, -1, 2, 18, 38, -1, 2, 18, 39, -1, 2, 18, 40, -1, 2, 18, 41, -1, 2, 18, 42, -1, 2, 18, 43, -1, 2, 18, 44, -1, 2, 18, 45, -1, 2, 18, 46, -1, 2, 18, 47, -1, 2, 18, 48, -1, 2, 18, 49, -1, 2, 18, 50, -1, 2, 18, 51, -1, 2, 18, 52, -1, 2, 18, 53, -1, 2, 18, 54, -1, 2, 18, 55, -1, 2, 18, 56, -1, 2, 18, 57, -1, 2, 18, 58, -1, 2, 18, 59, -1, 2, 18, 60, -1, 2, 18, 61, -1, 2, 18, 62, -1, 2, 18, 63, 565, 2, 19, 7, -1, 2, 19, 8, -1, 2, 19, 9, -1, 2, 19, 10, -1, 2, 19, 14, -1, 2, 19, 15, 576, 2, 19, 16, -1, 2, 19, 17, -1, 2, 19, 18, -1, 2, 19, 19, -1, 2, 19, 20, -1, 2, 19, 21, -1, 2, 19, 22, -1, 2, 19, 23, -1, 2, 19, 24, -1, 2, 19, 25, -1, 2, 19, 26, -1, 2, 19, 27, -1, 2, 19, 28, -1, 2, 19, 29, -1, 2, 19, 30, -1, 2, 19, 31, -1, 2, 19, 32, -1, 2, 19, 33, -1, 2, 19, 34, -1, 2, 19, 35, -1, 2, 19, 36, -1, 2, 19, 37, -1, 2, 19, 38, -1, 2, 19, 39, -1, 2, 19, 40, -1, 2, 19, 41, -1, 2, 19, 42, -1, 2, 19, 43, -1, 2, 19, 44, -1, 2, 19, 45, -1, 2, 19, 46, -1, 2, 19, 47, -1, 2, 19, 48, -1, 2, 19, 49, -1, 2, 19, 50, -1, 2, 19, 51, -1, 2, 19, 52, -1, 2, 19, 53, -1, 2, 19, 54, -1, 2, 19, 55, -1, 2, 19, 56, -1, 2, 19, 57, -1, 2, 19, 58, -1, 2, 19, 59, -1, 2, 19, 60, -1, 2, 19, 61, -1, 2, 19, 62, -1, 2, 19, 63, 581, 2, 20, 7, -1, 2, 20, 8, -1, 2, 20, 9, -1, 2, 20, 10, -1, 2, 20, 14, -1, 2, 20, 15, 560, 2, 20, 16, -1, 2, 20, 17, -1, 2, 20, 18, -1, 2, 20, 19, -1, 2, 20, 20, -1, 2, 20, 21, -1, 2, 20, 22, -1, 2, 20, 23, -1, 2, 20, 24, -1, 2, 20, 25, -1, 2, 20, 26, -1, 2, 20, 27, -1, 2, 20, 28, -1, 2, 20, 29, -1, 2, 20, 30, -1, 2, 20, 31, -1, 2, 20, 32, -1, 2, 20, 33, -1, 2, 20, 34, -1, 2, 20, 35, -1, 2, 20, 36, -1, 2, 20, 37, -1, 2, 20, 38, -1, 2, 20, 39, -1, 2, 20, 40, -1, 2, 20, 41, -1, 2, 20, 42, -1, 2, 20, 43, -1, 2, 20, 44, -1, 2, 20, 45, -1, 2, 20, 46, -1, 2, 20, 47, -1, 2, 20, 48, -1, 2, 20, 49, -1, 2, 20, 50, -1, 2, 20, 51, -1, 2, 20, 52, -1, 2, 20, 53, -1, 2, 20, 54, -1, 2, 20, 55, -1, 2, 20, 56, -1, 2, 20, 57, -1, 2, 20, 58, -1, 2, 20, 59, -1, 2, 20, 60, -1, 2, 20, 61, -1, 2, 20, 62, -1, 2, 20, 63, 549, 2, 21, 7, -1, 2, 21, 8, -1, 2, 21, 9, -1, 2, 21, 10, -1, 2, 21, 14, -1, 2, 21, 15, 576, 2, 21, 16, -1, 2, 21, 17, -1, 2, 21, 18, -1, 2, 21, 19, -1, 2, 21, 20, -1, 2, 21, 21, -1, 2, 21, 22, -1, 2, 21, 23, -1, 2, 21, 24, -1, 2, 21, 25, -1, 2, 21, 26, -1, 2, 21, 27, -1, 2, 21, 28, -1, 2, 21, 29, -1, 2, 21, 30, -1, 2, 21, 31, -1, 2, 21, 32, -1, 2, 21, 33, -1, 2, 21, 34, -1, 2, 21, 35, -1, 2, 21, 36, -1, 2, 21, 37, -1, 2, 21, 38, -1, 2, 21, 39, -1, 2, 21, 40, -1, 2, 21, 41, -1, 2, 21, 42, -1, 2, 21, 43, -1, 2, 21, 44, -1, 2, 21, 45, -1, 2, 21, 46, -1, 2, 21, 47, -1, 2, 21, 48, -1, 2, 21, 49, -1, 2, 21, 50, -1, 2, 21, 51, -1, 2, 21, 52, -1, 2, 21, 53, -1, 2, 21, 54, -1, 2, 21, 55, -1, 2, 21, 56, -1, 2, 21, 57, -1, 2, 21, 58, -1, 2, 21, 59, -1, 2, 21, 60, -1, 2, 21, 61, -1, 2, 21, 62, -1, 2, 21, 63, 565, 2, 22, 14, -1, 2, 22, 15, 560, 2, 22, 16, -1, 2, 22, 17, -1, 2, 22, 18, -1, 2, 22, 19, -1, 2, 22, 20, -1, 2, 22, 21, -1, 2, 22, 22, -1, 2, 22, 23, -1, 2, 22, 24, -1, 2, 22, 25, -1, 2, 22, 26, -1, 2, 22, 27, -1, 2, 22, 28, -1, 2, 22, 29, -1, 2, 22, 30, -1, 2, 22, 31, -1, 2, 22, 32, -1, 2, 22, 33, -1, 2, 22, 34, -1, 2, 22, 35, -1, 2, 22, 36, -1, 2, 22, 37, -1, 2, 22, 38, -1, 2, 22, 39, -1, 2, 22, 40, -1, 2, 22, 41, -1, 2, 22, 42, -1, 2, 22, 43, -1, 2, 22, 44, -1, 2, 22, 45, -1, 2, 22, 46, -1, 2, 22, 47, -1, 2, 22, 48, -1, 2, 22, 49, -1, 2, 22, 50, -1, 2, 22, 51, -1, 2, 22, 52, -1, 2, 22, 53, -1, 2, 22, 54, -1, 2, 22, 55, -1, 2, 22, 56, -1, 2, 22, 57, -1, 2, 22, 58, -1, 2, 22, 59, -1, 2, 22, 60, -1, 2, 22, 61, -1, 2, 22, 62, -1, 2, 22, 63, 581, 2, 23, 14, -1, 2, 23, 15, 576, 2, 23, 16, -1, 2, 23, 17, -1, 2, 23, 18, -1, 2, 23, 19, -1, 2, 23, 20, -1, 2, 23, 21, -1, 2, 23, 22, -1, 2, 23, 23, -1, 2, 23, 24, -1, 2, 23, 25, -1, 2, 23, 26, -1, 2, 23, 27, -1, 2, 23, 28, -1, 2, 23, 29, -1, 2, 23, 30, -1, 2, 23, 31, -1, 2, 23, 32, -1, 2, 23, 33, -1, 2, 23, 34, -1, 2, 23, 35, -1, 2, 23, 36, -1, 2, 23, 37, -1, 2, 23, 38, -1, 2, 23, 39, -1, 2, 23, 40, -1, 2, 23, 41, -1, 2, 23, 42, -1, 2, 23, 43, -1, 2, 23, 44, -1, 2, 23, 45, -1, 2, 23, 46, -1, 2, 23, 47, -1, 2, 23, 48, -1, 2, 23, 49, -1, 2, 23, 50, -1, 2, 23, 51, -1, 2, 23, 52, -1, 2, 23, 53, -1, 2, 23, 54, -1, 2, 23, 55, -1, 2, 23, 56, -1, 2, 23, 57, -1, 2, 23, 58, -1, 2, 23, 59, -1, 2, 23, 60, -1, 2, 23, 61, -1, 2, 23, 62, -1, 2, 23, 63, 549, 2, 24, 14, -1, 2, 24, 15, 560, 2, 24, 16, -1, 2, 24, 17, -1, 2, 24, 18, -1, 2, 24, 19, -1, 2, 24, 20, -1, 2, 24, 21, -1, 2, 24, 22, -1, 2, 24, 23, -1, 2, 24, 24, -1, 2, 24, 25, -1, 2, 24, 26, -1, 2, 24, 27, -1, 2, 24, 28, -1, 2, 24, 29, -1, 2, 24, 30, -1, 2, 24, 31, -1, 2, 24, 32, -1, 2, 24, 33, -1, 2, 24, 34, -1, 2, 24, 35, -1, 2, 24, 36, -1, 2, 24, 37, -1, 2, 24, 38, -1, 2, 24, 39, -1, 2, 24, 40, -1, 2, 24, 41, -1, 2, 24, 42, -1, 2, 24, 43, -1, 2, 24, 44, -1, 2, 24, 45, -1, 2, 24, 46, -1, 2, 24, 47, -1, 2, 24, 48, -1, 2, 24, 49, -1, 2, 24, 50, -1, 2, 24, 51, -1, 2, 24, 52, -1, 2, 24, 53, -1, 2, 24, 54, -1, 2, 24, 55, -1, 2, 24, 56, -1, 2, 24, 57, -1, 2, 24, 58, -1, 2, 24, 59, -1, 2, 24, 60, -1, 2, 24, 61, -1, 2, 24, 62, -1, 2, 24, 63, 565, 2, 25, 14, -1, 2, 25, 15, 576, 2, 25, 16, -1, 2, 25, 17, -1, 2, 25, 18, -1, 2, 25, 19, -1, 2, 25, 20, -1, 2, 25, 21, -1, 2, 25, 22, -1, 2, 25, 23, -1, 2, 25, 24, -1, 2, 25, 25, -1, 2, 25, 26, -1, 2, 25, 27, -1, 2, 25, 28, -1, 2, 25, 29, -1, 2, 25, 30, -1, 2, 25, 31, -1, 2, 25, 32, -1, 2, 25, 33, -1, 2, 25, 34, -1, 2, 25, 35, -1, 2, 25, 36, -1, 2, 25, 37, -1, 2, 25, 38, -1, 2, 25, 39, -1, 2, 25, 40, -1, 2, 25, 41, -1, 2, 25, 42, -1, 2, 25, 43, -1, 2, 25, 44, -1, 2, 25, 45, -1, 2, 25, 46, -1, 2, 25, 47, -1, 2, 25, 48, -1, 2, 25, 49, -1, 2, 25, 50, -1, 2, 25, 51, -1, 2, 25, 52, -1, 2, 25, 53, -1, 2, 25, 54, -1, 2, 25, 55, -1, 2, 25, 56, -1, 2, 25, 57, -1, 2, 25, 58, -1, 2, 25, 59, -1, 2, 25, 60, -1, 2, 25, 61, -1, 2, 25, 62, -1, 2, 25, 63, 581, 2, 26, 14, -1, 2, 26, 15, 560, 2, 26, 16, -1, 2, 26, 17, -1, 2, 26, 18, -1, 2, 26, 19, -1, 2, 26, 20, -1, 2, 26, 21, -1, 2, 26, 22, -1, 2, 26, 23, -1, 2, 26, 24, -1, 2, 26, 25, -1, 2, 26, 26, -1, 2, 26, 27, -1, 2, 26, 28, -1, 2, 26, 29, -1, 2, 26, 30, -1, 2, 26, 31, -1, 2, 26, 32, -1, 2, 26, 33, -1, 2, 26, 34, -1, 2, 26, 35, -1, 2, 26, 36, -1, 2, 26, 37, -1, 2, 26, 38, -1, 2, 26, 39, -1, 2, 26, 40, -1, 2, 26, 41, -1, 2, 26, 42, -1, 2, 26, 43, -1, 2, 26, 44, -1, 2, 26, 45, -1, 2, 26, 46, -1, 2, 26, 47, -1, 2, 26, 48, -1, 2, 26, 49, -1, 2, 26, 50, -1, 2, 26, 51, -1, 2, 26, 52, -1, 2, 26, 53, -1, 2, 26, 54, -1, 2, 26, 55, -1, 2, 26, 56, -1, 2, 26, 57, -1, 2, 26, 58, -1, 2, 26, 59, -1, 2, 26, 60, -1, 2, 26, 61, -1, 2, 26, 62, -1, 2, 26, 63, 549, 2, 27, 14, -1, 2, 27, 15, 576, 2, 27, 16, -1, 2, 27, 17, -1, 2, 27, 18, -1, 2, 27, 19, -1, 2, 27, 20, -1, 2, 27, 21, -1, 2, 27, 22, -1, 2, 27, 23, -1, 2, 27, 24, -1, 2, 27, 25, -1, 2, 27, 26, -1, 2, 27, 27, -1, 2, 27, 28, -1, 2, 27, 29, -1, 2, 27, 30, -1, 2, 27, 31, -1, 2, 27, 32, -1, 2, 27, 33, -1, 2, 27, 34, -1, 2, 27, 35, -1, 2, 27, 36, -1, 2, 27, 37, -1, 2, 27, 38, -1, 2, 27, 39, -1, 2, 27, 40, -1, 2, 27, 41, -1, 2, 27, 42, -1, 2, 27, 43, -1, 2, 27, 44, -1, 2, 27, 45, -1, 2, 27, 46, -1, 2, 27, 47, -1, 2, 27, 48, -1, 2, 27, 49, -1, 2, 27, 50, -1, 2, 27, 51, -1, 2, 27, 52, -1, 2, 27, 53, -1, 2, 27, 54, -1, 2, 27, 55, -1, 2, 27, 56, -1, 2, 27, 57, -1, 2, 27, 58, -1, 2, 27, 59, -1, 2, 27, 60, -1, 2, 27, 61, -1, 2, 27, 62, -1, 2, 27, 63, 565, 2, 28, 14, -1, 2, 28, 15, 560, 2, 28, 29, -1, 2, 28, 30, -1, 2, 28, 31, -1, 2, 28, 32, -1, 2, 28, 33, -1, 2, 28, 34, -1, 2, 28, 35, -1, 2, 28, 36, -1, 2, 28, 37, -1, 2, 28, 38, -1, 2, 28, 39, -1, 2, 28, 40, -1, 2, 28, 41, -1, 2, 28, 42, -1, 2, 28, 43, -1, 2, 28, 44, -1, 2, 28, 45, -1, 2, 28, 46, -1, 2, 28, 47, -1, 2, 28, 48, -1, 2, 28, 49, -1, 2, 28, 50, -1, 2, 28, 51, -1, 2, 28, 52, -1, 2, 28, 53, -1, 2, 28, 54, -1, 2, 28, 55, -1, 2, 28, 56, -1, 2, 28, 57, -1, 2, 28, 58, -1, 2, 28, 59, -1, 2, 28, 60, -1, 2, 28, 61, -1, 2, 28, 62, -1, 2, 28, 63, 581, 2, 29, 15, 576, 2, 29, 29, -1, 2, 29, 30, -1, 2, 29, 31, -1, 2, 29, 32, -1, 2, 29, 33, -1, 2, 29, 34, -1, 2, 29, 35, -1, 2, 29, 36, -1, 2, 29, 37, -1, 2, 29, 38, -1, 2, 29, 39, -1, 2, 29, 40, -1, 2, 29, 41, -1, 2, 29, 42, -1, 2, 29, 43, -1, 2, 29, 44, -1, 2, 29, 45, -1, 2, 29, 46, -1, 2, 29, 47, -1, 2, 29, 48, -1, 2, 29, 49, -1, 2, 29, 50, -1, 2, 29, 51, -1, 2, 29, 52, -1, 2, 29, 53, -1, 2, 29, 54, -1, 2, 29, 55, -1, 2, 29, 56, -1, 2, 29, 57, -1, 2, 29, 58, -1, 2, 29, 59, -1, 2, 29, 60, -1, 2, 29, 61, -1, 2, 29, 62, -1, 2, 29, 63, 549, 2, 30, 15, 592, 2, 30, 16, 593, 2, 30, 29, -1, 2, 30, 30, -1, 2, 30, 31, -1, 2, 30, 32, -1, 2, 30, 33, -1, 2, 30, 34, -1, 2, 30, 35, -1, 2, 30, 36, -1, 2, 30, 37, -1, 2, 30, 38, -1, 2, 30, 39, -1, 2, 30, 40, -1, 2, 30, 41, -1, 2, 30, 42, -1, 2, 30, 43, -1, 2, 30, 44, -1, 2, 30, 45, -1, 2, 30, 46, 518, 2, 30, 47, 519, 2, 30, 48, -1, 2, 30, 49, -1, 2, 30, 50, -1, 2, 30, 51, -1, 2, 30, 52, -1, 2, 30, 53, -1, 2, 30, 54, -1, 2, 30, 55, -1, 2, 30, 56, -1, 2, 30, 57, -1, 2, 30, 58, -1, 2, 30, 59, -1, 2, 30, 60, -1, 2, 30, 61, -1, 2, 30, 62, -1, 2, 30, 63, 565, 2, 31, 15, 608, 2, 31, 16, 609, 2, 31, 17, 610, 2, 31, 18, 611, 2, 31, 19, 610, 2, 31, 20, 611, 2, 31, 21, 610, 2, 31, 22, 611, 2, 31, 23, 610, 2, 31, 24, 611, 2, 31, 25, 610, 2, 31, 26, 611, 2, 31, 27, 610, 2, 31, 28, 611, 2, 31, 29, 536, 2, 31, 30, -1, 2, 31, 31, -1, 2, 31, 32, -1, 2, 31, 33, -1, 2, 31, 34, -1, 2, 31, 35, -1, 2, 31, 36, -1, 2, 31, 37, -1, 2, 31, 38, -1, 2, 31, 39, -1, 2, 31, 40, -1, 2, 31, 41, -1, 2, 31, 42, -1, 2, 31, 43, -1, 2, 31, 44, -1, 2, 31, 45, -1, 2, 31, 46, 534, 2, 31, 47, 535, 2, 31, 48, 610, 2, 31, 49, 611, 2, 31, 50, 610, 2, 31, 51, 611, 2, 31, 52, 610, 2, 31, 53, 611, 2, 31, 54, 610, 2, 31, 55, 611, 2, 31, 56, 610, 2, 31, 57, 611, 2, 31, 58, 610, 2, 31, 59, 611, 2, 31, 60, 610, 2, 31, 61, 611, 2, 31, 62, 610, 2, 31, 63, 581, 2, 32, 29, 528, 2, 32, 30, -1, 2, 32, 31, -1, 2, 32, 32, -1, 2, 32, 33, -1, 2, 32, 34, -1, 2, 32, 35, -1, 2, 32, 36, -1, 2, 32, 37, -1, 2, 32, 38, -1, 2, 32, 39, -1, 2, 32, 40, -1, 2, 32, 41, -1, 2, 32, 42, -1, 2, 32, 43, -1, 2, 32, 44, -1, 2, 32, 45, -1, 2, 32, 46, -1, 2, 32, 47, 581, 2, 32, 48, -1, 2, 32, 49, -1, 2, 32, 50, -1, 2, 32, 51, -1, 2, 32, 52, -1, 2, 32, 53, -1, 2, 32, 54, -1, 2, 32, 55, -1, 2, 32, 56, -1, 2, 32, 57, -1, 2, 32, 58, -1, 2, 32, 59, -1, 2, 32, 60, -1, 2, 32, 61, -1, 2, 32, 62, -1, 2, 32, 63, 549, 2, 33, 29, 544, 2, 33, 30, -1, 2, 33, 31, -1, 2, 33, 32, -1, 2, 33, 33, -1, 2, 33, 34, -1, 2, 33, 35, -1, 2, 33, 36, -1, 2, 33, 37, -1, 2, 33, 38, -1, 2, 33, 39, -1, 2, 33, 40, -1, 2, 33, 41, -1, 2, 33, 42, -1, 2, 33, 43, -1, 2, 33, 44, -1, 2, 33, 45, -1, 2, 33, 46, -1, 2, 33, 47, 549, 2, 33, 48, -1, 2, 33, 49, -1, 2, 33, 50, -1, 2, 33, 51, -1, 2, 33, 52, -1, 2, 33, 53, -1, 2, 33, 54, -1, 2, 33, 55, -1, 2, 33, 56, -1, 2, 33, 57, -1, 2, 33, 58, -1, 2, 33, 59, -1, 2, 33, 60, -1, 2, 33, 61, -1, 2, 33, 62, -1, 2, 33, 63, 565, 2, 34, 29, 560, 2, 34, 30, -1, 2, 34, 31, -1, 2, 34, 32, -1, 2, 34, 33, -1, 2, 34, 34, -1, 2, 34, 35, -1, 2, 34, 36, -1, 2, 34, 37, -1, 2, 34, 38, -1, 2, 34, 39, -1, 2, 34, 40, -1, 2, 34, 41, -1, 2, 34, 42, -1, 2, 34, 43, -1, 2, 34, 44, -1, 2, 34, 45, -1, 2, 34, 46, -1, 2, 34, 47, 565, 2, 34, 48, -1, 2, 34, 49, -1, 2, 34, 50, -1, 2, 34, 51, -1, 2, 34, 52, -1, 2, 34, 53, -1, 2, 34, 54, -1, 2, 34, 55, -1, 2, 34, 56, -1, 2, 34, 57, -1, 2, 34, 58, -1, 2, 34, 59, -1, 2, 34, 60, -1, 2, 34, 61, -1, 2, 34, 62, -1, 2, 34, 63, 581, 2, 35, 29, 576, 2, 35, 30, -1, 2, 35, 31, -1, 2, 35, 32, -1, 2, 35, 33, -1, 2, 35, 34, -1, 2, 35, 35, -1, 2, 35, 36, -1, 2, 35, 37, -1, 2, 35, 38, -1, 2, 35, 39, -1, 2, 35, 40, -1, 2, 35, 41, -1, 2, 35, 42, -1, 2, 35, 43, -1, 2, 35, 44, -1, 2, 35, 45, -1, 2, 35, 46, -1, 2, 35, 47, 581, 2, 35, 48, -1, 2, 35, 49, -1, 2, 35, 50, -1, 2, 35, 51, -1, 2, 35, 52, -1, 2, 35, 53, -1, 2, 35, 54, -1, 2, 35, 55, -1, 2, 35, 56, -1, 2, 35, 57, -1, 2, 35, 58, -1, 2, 35, 59, -1, 2, 35, 60, -1, 2, 35, 61, -1, 2, 35, 62, -1, 2, 35, 63, 549, 2, 36, 29, 544, 2, 36, 30, -1, 2, 36, 31, -1, 2, 36, 32, -1, 2, 36, 33, -1, 2, 36, 34, -1, 2, 36, 35, -1, 2, 36, 36, -1, 2, 36, 37, -1, 2, 36, 38, -1, 2, 36, 39, -1, 2, 36, 40, -1, 2, 36, 41, -1, 2, 36, 42, -1, 2, 36, 43, -1, 2, 36, 44, -1, 2, 36, 45, -1, 2, 36, 46, -1, 2, 36, 47, 549, 2, 36, 48, -1, 2, 36, 49, -1, 2, 36, 50, -1, 2, 36, 51, -1, 2, 36, 52, -1, 2, 36, 53, -1, 2, 36, 54, -1, 2, 36, 55, -1, 2, 36, 56, -1, 2, 36, 57, -1, 2, 36, 58, -1, 2, 36, 59, -1, 2, 36, 60, -1, 2, 36, 61, -1, 2, 36, 62, -1, 2, 36, 63, 565, 2, 37, 29, -1, 2, 37, 30, -1, 2, 37, 31, -1, 2, 37, 32, -1, 2, 37, 33, -1, 2, 37, 34, -1, 2, 37, 35, -1, 2, 37, 36, -1, 2, 37, 37, -1, 2, 37, 38, -1, 2, 37, 39, -1, 2, 37, 40, -1, 2, 37, 41, -1, 2, 37, 42, -1, 2, 37, 43, -1, 2, 37, 44, -1, 2, 37, 45, -1, 2, 37, 46, -1, 2, 37, 47, 565, 2, 37, 48, -1, 2, 37, 49, -1, 2, 37, 50, -1, 2, 37, 51, -1, 2, 37, 52, -1, 2, 37, 53, -1, 2, 37, 54, -1, 2, 37, 55, -1, 2, 37, 56, -1, 2, 37, 57, -1, 2, 37, 58, -1, 2, 37, 59, -1, 2, 37, 60, -1, 2, 37, 61, -1, 2, 37, 62, -1, 2, 37, 63, 581, 2, 38, 29, -1, 2, 38, 30, -1, 2, 38, 31, -1, 2, 38, 32, -1, 2, 38, 33, -1, 2, 38, 34, -1, 2, 38, 35, -1, 2, 38, 36, -1, 2, 38, 37, -1, 2, 38, 38, -1, 2, 38, 39, -1, 2, 38, 40, -1, 2, 38, 41, -1, 2, 38, 42, -1, 2, 38, 43, -1, 2, 38, 44, -1, 2, 38, 45, -1, 2, 38, 46, -1, 2, 38, 47, 581, 2, 38, 48, -1, 2, 38, 49, -1, 2, 38, 50, -1, 2, 38, 51, -1, 2, 38, 52, -1, 2, 38, 53, -1, 2, 38, 54, -1, 2, 38, 55, -1, 2, 38, 56, -1, 2, 38, 57, -1, 2, 38, 58, -1, 2, 38, 59, -1, 2, 38, 60, -1, 2, 38, 61, -1, 2, 38, 62, -1, 2, 38, 63, 549, 2, 39, 29, -1, 2, 39, 30, -1, 2, 39, 31, -1, 2, 39, 32, -1, 2, 39, 33, -1, 2, 39, 34, -1, 2, 39, 35, -1, 2, 39, 36, -1, 2, 39, 37, -1, 2, 39, 38, -1, 2, 39, 39, -1, 2, 39, 40, -1, 2, 39, 41, -1, 2, 39, 42, -1, 2, 39, 43, -1, 2, 39, 44, -1, 2, 39, 45, -1, 2, 39, 46, -1, 2, 39, 47, 549, 2, 39, 48, -1, 2, 39, 49, -1, 2, 39, 50, -1, 2, 39, 51, -1, 2, 39, 52, -1, 2, 39, 53, -1, 2, 39, 54, -1, 2, 39, 55, -1, 2, 39, 56, -1, 2, 39, 57, -1, 2, 39, 58, -1, 2, 39, 59, -1, 2, 39, 60, -1, 2, 39, 61, -1, 2, 39, 62, -1, 2, 39, 63, 565, 2, 40, 29, -1, 2, 40, 30, -1, 2, 40, 31, -1, 2, 40, 32, -1, 2, 40, 33, -1, 2, 40, 34, -1, 2, 40, 35, -1, 2, 40, 36, -1, 2, 40, 37, -1, 2, 40, 38, -1, 2, 40, 39, -1, 2, 40, 40, -1, 2, 40, 41, -1, 2, 40, 42, -1, 2, 40, 43, -1, 2, 40, 44, -1, 2, 40, 45, -1, 2, 40, 46, -1, 2, 40, 47, 565, 2, 40, 48, -1, 2, 40, 49, -1, 2, 40, 50, -1, 2, 40, 51, -1, 2, 40, 52, -1, 2, 40, 53, -1, 2, 40, 54, -1, 2, 40, 55, -1, 2, 40, 56, -1, 2, 40, 57, -1, 2, 40, 58, -1, 2, 40, 59, -1, 2, 40, 60, -1, 2, 40, 61, -1, 2, 40, 62, -1, 2, 40, 63, 581, 2, 41, 29, -1, 2, 41, 30, -1, 2, 41, 31, -1, 2, 41, 32, -1, 2, 41, 33, -1, 2, 41, 34, -1, 2, 41, 35, -1, 2, 41, 36, -1, 2, 41, 37, -1, 2, 41, 38, -1, 2, 41, 39, -1, 2, 41, 40, -1, 2, 41, 41, -1, 2, 41, 42, -1, 2, 41, 43, -1, 2, 41, 44, -1, 2, 41, 45, -1, 2, 41, 46, -1, 2, 41, 47, 581, 2, 41, 48, -1, 2, 41, 49, -1, 2, 41, 50, -1, 2, 41, 51, -1, 2, 41, 52, -1, 2, 41, 53, -1, 2, 41, 54, -1, 2, 41, 55, -1, 2, 41, 56, -1, 2, 41, 57, -1, 2, 41, 58, -1, 2, 41, 59, -1, 2, 41, 60, -1, 2, 41, 61, -1, 2, 41, 62, -1, 2, 41, 63, 549, 2, 42, 29, 536, 2, 42, 30, -1, 2, 42, 31, -1, 2, 42, 32, -1, 2, 42, 33, -1, 2, 42, 34, -1, 2, 42, 35, -1, 2, 42, 36, -1, 2, 42, 37, -1, 2, 42, 38, -1, 2, 42, 39, -1, 2, 42, 40, -1, 2, 42, 41, -1, 2, 42, 42, -1, 2, 42, 43, -1, 2, 42, 44, -1, 2, 42, 45, -1, 2, 42, 46, -1, 2, 42, 47, 549, 2, 42, 48, -1, 2, 42, 49, -1, 2, 42, 50, -1, 2, 42, 51, -1, 2, 42, 52, -1, 2, 42, 53, -1, 2, 42, 54, -1, 2, 42, 55, -1, 2, 42, 56, -1, 2, 42, 57, -1, 2, 42, 58, -1, 2, 42, 59, -1, 2, 42, 60, -1, 2, 42, 61, -1, 2, 42, 62, -1, 2, 42, 63, 565, 2, 43, 29, 544, 2, 43, 30, -1, 2, 43, 31, -1, 2, 43, 32, -1, 2, 43, 33, -1, 2, 43, 34, -1, 2, 43, 35, -1, 2, 43, 36, -1, 2, 43, 37, -1, 2, 43, 38, -1, 2, 43, 39, -1, 2, 43, 40, -1, 2, 43, 41, -1, 2, 43, 42, -1, 2, 43, 43, -1, 2, 43, 44, -1, 2, 43, 45, -1, 2, 43, 46, -1, 2, 43, 47, 565, 2, 43, 48, -1, 2, 43, 49, -1, 2, 43, 50, -1, 2, 43, 51, -1, 2, 43, 52, -1, 2, 43, 53, -1, 2, 43, 54, -1, 2, 43, 55, -1, 2, 43, 56, -1, 2, 43, 57, -1, 2, 43, 58, -1, 2, 43, 59, -1, 2, 43, 60, -1, 2, 43, 61, -1, 2, 43, 62, -1, 2, 43, 63, 581, 2, 44, 29, 560, 2, 44, 30, -1, 2, 44, 31, -1, 2, 44, 32, -1, 2, 44, 33, -1, 2, 44, 34, -1, 2, 44, 35, -1, 2, 44, 36, -1, 2, 44, 37, -1, 2, 44, 38, -1, 2, 44, 39, -1, 2, 44, 40, -1, 2, 44, 41, -1, 2, 44, 42, -1, 2, 44, 43, -1, 2, 44, 44, -1, 2, 44, 45, -1, 2, 44, 46, -1, 2, 44, 47, 581, 2, 44, 48, -1, 2, 44, 49, -1, 2, 44, 50, -1, 2, 44, 51, -1, 2, 44, 52, -1, 2, 44, 53, -1, 2, 44, 54, -1, 2, 44, 55, -1, 2, 44, 56, -1, 2, 44, 57, -1, 2, 44, 58, -1, 2, 44, 59, -1, 2, 44, 60, -1, 2, 44, 61, -1, 2, 44, 62, -1, 2, 44, 63, 549, 2, 45, 29, 576, 2, 45, 30, -1, 2, 45, 31, -1, 2, 45, 32, -1, 2, 45, 33, -1, 2, 45, 34, -1, 2, 45, 35, -1, 2, 45, 36, -1, 2, 45, 37, -1, 2, 45, 38, -1, 2, 45, 39, -1, 2, 45, 40, -1, 2, 45, 41, -1, 2, 45, 42, -1, 2, 45, 43, -1, 2, 45, 44, -1, 2, 45, 45, -1, 2, 45, 46, -1, 2, 45, 47, 549, 2, 45, 48, -1, 2, 45, 49, -1, 2, 45, 50, -1, 2, 45, 51, -1, 2, 45, 52, -1, 2, 45, 53, -1, 2, 45, 54, -1, 2, 45, 55, -1, 2, 45, 56, -1, 2, 45, 57, -1, 2, 45, 58, -1, 2, 45, 59, -1, 2, 45, 60, -1, 2, 45, 61, -1, 2, 45, 62, -1, 2, 45, 63, 565, 2, 46, 29, 544, 2, 46, 30, -1, 2, 46, 31, -1, 2, 46, 32, -1, 2, 46, 33, -1, 2, 46, 34, -1, 2, 46, 35, -1, 2, 46, 36, -1, 2, 46, 37, -1, 2, 46, 38, -1, 2, 46, 39, -1, 2, 46, 40, -1, 2, 46, 41, -1, 2, 46, 42, -1, 2, 46, 43, -1, 2, 46, 44, -1, 2, 46, 45, -1, 2, 46, 46, -1, 2, 46, 47, 565, 2, 46, 48, -1, 2, 46, 49, -1, 2, 46, 50, -1, 2, 46, 51, -1, 2, 46, 52, -1, 2, 46, 53, -1, 2, 46, 54, -1, 2, 46, 55, -1, 2, 46, 56, -1, 2, 46, 57, -1, 2, 46, 58, -1, 2, 46, 59, -1, 2, 46, 60, -1, 2, 46, 61, -1, 2, 46, 62, -1, 2, 46, 63, 581, 2, 47, 29, 560, 2, 47, 30, -1, 2, 47, 31, -1, 2, 47, 32, -1, 2, 47, 33, -1, 2, 47, 34, -1, 2, 47, 35, -1, 2, 47, 36, -1, 2, 47, 37, -1, 2, 47, 38, -1, 2, 47, 39, -1, 2, 47, 40, -1, 2, 47, 41, -1, 2, 47, 42, -1, 2, 47, 43, -1, 2, 47, 44, -1, 2, 47, 45, -1, 2, 47, 46, -1, 2, 47, 47, 581, 2, 47, 48, -1, 2, 47, 49, -1, 2, 47, 50, -1, 2, 47, 51, -1, 2, 47, 52, -1, 2, 47, 53, -1, 2, 47, 54, -1, 2, 47, 55, -1, 2, 47, 56, -1, 2, 47, 57, -1, 2, 47, 58, -1, 2, 47, 59, -1, 2, 47, 60, -1, 2, 47, 61, -1, 2, 47, 62, -1, 2, 47, 63, 549, 2, 48, 29, 576, 2, 48, 30, -1, 2, 48, 31, -1, 2, 48, 32, -1, 2, 48, 33, -1, 2, 48, 34, -1, 2, 48, 35, -1, 2, 48, 36, -1, 2, 48, 37, -1, 2, 48, 38, -1, 2, 48, 39, -1, 2, 48, 40, -1, 2, 48, 41, -1, 2, 48, 42, -1, 2, 48, 43, -1, 2, 48, 44, -1, 2, 48, 45, -1, 2, 48, 46, -1, 2, 48, 47, 549, 2, 48, 48, -1, 2, 48, 49, -1, 2, 48, 50, -1, 2, 48, 51, -1, 2, 48, 52, -1, 2, 48, 53, -1, 2, 48, 54, -1, 2, 48, 55, -1, 2, 48, 56, -1, 2, 48, 57, -1, 2, 48, 58, -1, 2, 48, 59, -1, 2, 48, 60, -1, 2, 48, 61, -1, 2, 48, 62, -1, 2, 48, 63, 565, 2, 49, 14, -1, 2, 49, 15, 512, 2, 49, 16, 513, 2, 49, 17, 514, 2, 49, 18, 515, 2, 49, 19, 514, 2, 49, 20, 515, 2, 49, 21, 514, 2, 49, 22, 515, 2, 49, 23, 514, 2, 49, 24, 515, 2, 49, 25, 514, 2, 49, 26, 515, 2, 49, 27, 514, 2, 49, 28, 515, 2, 49, 29, 552, 2, 49, 30, 553, 2, 49, 31, -1, 2, 49, 32, -1, 2, 49, 33, -1, 2, 49, 34, -1, 2, 49, 35, -1, 2, 49, 36, -1, 2, 49, 37, -1, 2, 49, 38, -1, 2, 49, 39, -1, 2, 49, 40, -1, 2, 49, 41, -1, 2, 49, 42, -1, 2, 49, 43, -1, 2, 49, 44, -1, 2, 49, 45, -1, 2, 49, 46, 550, 2, 49, 47, 551, 2, 49, 48, -1, 2, 49, 49, -1, 2, 49, 50, -1, 2, 49, 51, -1, 2, 49, 52, -1, 2, 49, 53, -1, 2, 49, 54, -1, 2, 49, 55, -1, 2, 49, 56, -1, 2, 49, 57, -1, 2, 49, 58, -1, 2, 49, 59, -1, 2, 49, 60, -1, 2, 49, 61, -1, 2, 49, 62, -1, 2, 49, 63, 581, 2, 50, 14, -1, 2, 50, 15, 528, 2, 50, 16, -1, 2, 50, 17, -1, 2, 50, 18, -1, 2, 50, 19, -1, 2, 50, 20, -1, 2, 50, 21, -1, 2, 50, 22, -1, 2, 50, 23, -1, 2, 50, 24, -1, 2, 50, 25, -1, 2, 50, 26, -1, 2, 50, 27, -1, 2, 50, 28, -1, 2, 50, 29, -1, 2, 50, 30, -1, 2, 50, 31, -1, 2, 50, 32, -1, 2, 50, 33, -1, 2, 50, 34, -1, 2, 50, 35, -1, 2, 50, 36, -1, 2, 50, 37, -1, 2, 50, 38, -1, 2, 50, 39, -1, 2, 50, 40, -1, 2, 50, 41, -1, 2, 50, 42, -1, 2, 50, 43, -1, 2, 50, 44, -1, 2, 50, 45, -1, 2, 50, 46, -1, 2, 50, 47, -1, 2, 50, 48, -1, 2, 50, 49, -1, 2, 50, 50, -1, 2, 50, 51, -1, 2, 50, 52, -1, 2, 50, 53, -1, 2, 50, 54, -1, 2, 50, 55, -1, 2, 50, 56, -1, 2, 50, 57, -1, 2, 50, 58, -1, 2, 50, 59, -1, 2, 50, 60, -1, 2, 50, 61, -1, 2, 50, 62, -1, 2, 50, 63, 549, 2, 51, 14, -1, 2, 51, 15, 560, 2, 51, 16, -1, 2, 51, 17, -1, 2, 51, 18, -1, 2, 51, 19, -1, 2, 51, 20, -1, 2, 51, 21, -1, 2, 51, 22, -1, 2, 51, 23, -1, 2, 51, 24, -1, 2, 51, 25, -1, 2, 51, 26, -1, 2, 51, 27, -1, 2, 51, 28, -1, 2, 51, 29, -1, 2, 51, 30, -1, 2, 51, 31, -1, 2, 51, 32, -1, 2, 51, 33, -1, 2, 51, 34, -1, 2, 51, 35, -1, 2, 51, 36, -1, 2, 51, 37, -1, 2, 51, 38, -1, 2, 51, 39, -1, 2, 51, 40, -1, 2, 51, 41, -1, 2, 51, 42, -1, 2, 51, 43, -1, 2, 51, 44, -1, 2, 51, 45, -1, 2, 51, 46, -1, 2, 51, 47, -1, 2, 51, 48, -1, 2, 51, 49, -1, 2, 51, 50, -1, 2, 51, 51, -1, 2, 51, 52, -1, 2, 51, 53, -1, 2, 51, 54, -1, 2, 51, 55, -1, 2, 51, 56, -1, 2, 51, 57, -1, 2, 51, 58, -1, 2, 51, 59, -1, 2, 51, 60, -1, 2, 51, 61, -1, 2, 51, 62, -1, 2, 51, 63, 565, 2, 52, 14, -1, 2, 52, 15, 576, 2, 52, 16, -1, 2, 52, 17, -1, 2, 52, 18, -1, 2, 52, 19, -1, 2, 52, 20, -1, 2, 52, 21, -1, 2, 52, 22, -1, 2, 52, 23, -1, 2, 52, 24, -1, 2, 52, 25, -1, 2, 52, 26, -1, 2, 52, 27, -1, 2, 52, 28, -1, 2, 52, 29, -1, 2, 52, 30, -1, 2, 52, 31, -1, 2, 52, 32, -1, 2, 52, 33, -1, 2, 52, 34, -1, 2, 52, 35, -1, 2, 52, 36, -1, 2, 52, 37, -1, 2, 52, 38, -1, 2, 52, 39, -1, 2, 52, 40, -1, 2, 52, 41, -1, 2, 52, 42, -1, 2, 52, 43, -1, 2, 52, 44, -1, 2, 52, 45, -1, 2, 52, 46, -1, 2, 52, 47, -1, 2, 52, 48, -1, 2, 52, 49, -1, 2, 52, 50, -1, 2, 52, 51, -1, 2, 52, 52, -1, 2, 52, 53, -1, 2, 52, 54, -1, 2, 52, 55, -1, 2, 52, 56, -1, 2, 52, 57, -1, 2, 52, 58, -1, 2, 52, 59, -1, 2, 52, 60, -1, 2, 52, 61, -1, 2, 52, 62, -1, 2, 52, 63, 581, 2, 53, 14, -1, 2, 53, 15, 544, 2, 53, 16, -1, 2, 53, 17, -1, 2, 53, 18, -1, 2, 53, 19, -1, 2, 53, 20, -1, 2, 53, 21, -1, 2, 53, 22, -1, 2, 53, 23, -1, 2, 53, 24, -1, 2, 53, 25, -1, 2, 53, 26, -1, 2, 53, 27, -1, 2, 53, 28, -1, 2, 53, 29, -1, 2, 53, 30, -1, 2, 53, 31, -1, 2, 53, 32, -1, 2, 53, 33, -1, 2, 53, 34, -1, 2, 53, 35, -1, 2, 53, 36, -1, 2, 53, 37, -1, 2, 53, 38, -1, 2, 53, 39, -1, 2, 53, 40, -1, 2, 53, 41, -1, 2, 53, 42, -1, 2, 53, 43, -1, 2, 53, 44, -1, 2, 53, 45, -1, 2, 53, 46, -1, 2, 53, 47, -1, 2, 53, 48, -1, 2, 53, 49, -1, 2, 53, 50, -1, 2, 53, 51, -1, 2, 53, 52, -1, 2, 53, 53, -1, 2, 53, 54, -1, 2, 53, 55, -1, 2, 53, 56, -1, 2, 53, 57, -1, 2, 53, 58, -1, 2, 53, 59, -1, 2, 53, 60, -1, 2, 53, 61, -1, 2, 53, 62, -1, 2, 53, 63, 549, 2, 54, 14, -1, 2, 54, 15, 560, 2, 54, 16, -1, 2, 54, 17, -1, 2, 54, 18, -1, 2, 54, 19, -1, 2, 54, 20, -1, 2, 54, 21, -1, 2, 54, 22, -1, 2, 54, 23, -1, 2, 54, 24, -1, 2, 54, 25, -1, 2, 54, 26, -1, 2, 54, 27, -1, 2, 54, 28, -1, 2, 54, 29, -1, 2, 54, 30, -1, 2, 54, 31, -1, 2, 54, 32, -1, 2, 54, 33, -1, 2, 54, 34, -1, 2, 54, 35, -1, 2, 54, 36, -1, 2, 54, 37, -1, 2, 54, 38, -1, 2, 54, 39, -1, 2, 54, 40, -1, 2, 54, 41, -1, 2, 54, 42, -1, 2, 54, 43, -1, 2, 54, 44, -1, 2, 54, 45, -1, 2, 54, 46, -1, 2, 54, 47, -1, 2, 54, 48, -1, 2, 54, 49, -1, 2, 54, 50, -1, 2, 54, 51, -1, 2, 54, 52, -1, 2, 54, 53, -1, 2, 54, 54, -1, 2, 54, 55, -1, 2, 54, 56, -1, 2, 54, 57, -1, 2, 54, 58, -1, 2, 54, 59, -1, 2, 54, 60, -1, 2, 54, 61, -1, 2, 54, 62, -1, 2, 54, 63, 565, 2, 55, 14, -1, 2, 55, 15, 576, 2, 55, 16, -1, 2, 55, 17, -1, 2, 55, 18, -1, 2, 55, 19, -1, 2, 55, 20, -1, 2, 55, 21, -1, 2, 55, 22, -1, 2, 55, 23, -1, 2, 55, 24, -1, 2, 55, 25, -1, 2, 55, 26, -1, 2, 55, 27, -1, 2, 55, 28, -1, 2, 55, 29, -1, 2, 55, 30, -1, 2, 55, 31, -1, 2, 55, 32, -1, 2, 55, 33, -1, 2, 55, 34, -1, 2, 55, 35, -1, 2, 55, 36, -1, 2, 55, 37, -1, 2, 55, 38, -1, 2, 55, 39, -1, 2, 55, 40, -1, 2, 55, 41, -1, 2, 55, 42, -1, 2, 55, 43, -1, 2, 55, 44, -1, 2, 55, 45, -1, 2, 55, 46, -1, 2, 55, 47, -1, 2, 55, 48, -1, 2, 55, 49, -1, 2, 55, 50, -1, 2, 55, 51, -1, 2, 55, 52, -1, 2, 55, 53, -1, 2, 55, 54, -1, 2, 55, 55, -1, 2, 55, 56, -1, 2, 55, 57, -1, 2, 55, 58, -1, 2, 55, 59, -1, 2, 55, 60, -1, 2, 55, 61, -1, 2, 55, 62, -1, 2, 55, 63, 581, 2, 56, 14, -1, 2, 56, 15, 544, 2, 56, 16, -1, 2, 56, 17, -1, 2, 56, 18, -1, 2, 56, 19, -1, 2, 56, 20, -1, 2, 56, 21, -1, 2, 56, 22, -1, 2, 56, 23, -1, 2, 56, 24, -1, 2, 56, 25, -1, 2, 56, 26, -1, 2, 56, 27, -1, 2, 56, 28, -1, 2, 56, 29, -1, 2, 56, 30, -1, 2, 56, 31, -1, 2, 56, 32, -1, 2, 56, 33, -1, 2, 56, 34, -1, 2, 56, 35, -1, 2, 56, 36, -1, 2, 56, 37, -1, 2, 56, 38, -1, 2, 56, 39, -1, 2, 56, 40, -1, 2, 56, 41, -1, 2, 56, 42, -1, 2, 56, 43, -1, 2, 56, 44, -1, 2, 56, 45, -1, 2, 56, 46, -1, 2, 56, 47, -1, 2, 56, 48, -1, 2, 56, 49, -1, 2, 56, 50, -1, 2, 56, 51, -1, 2, 56, 52, -1, 2, 56, 53, -1, 2, 56, 54, -1, 2, 56, 55, -1, 2, 56, 56, -1, 2, 56, 57, -1, 2, 56, 58, -1, 2, 56, 59, -1, 2, 56, 60, -1, 2, 56, 61, -1, 2, 56, 62, -1, 2, 56, 63, 549, 2, 57, 14, -1, 2, 57, 15, 560, 2, 57, 16, -1, 2, 57, 17, -1, 2, 57, 18, -1, 2, 57, 19, -1, 2, 57, 20, -1, 2, 57, 21, -1, 2, 57, 22, -1, 2, 57, 23, -1, 2, 57, 24, -1, 2, 57, 25, -1, 2, 57, 26, -1, 2, 57, 27, -1, 2, 57, 28, -1, 2, 57, 29, -1, 2, 57, 30, -1, 2, 57, 31, -1, 2, 57, 32, -1, 2, 57, 33, -1, 2, 57, 34, -1, 2, 57, 35, -1, 2, 57, 36, -1, 2, 57, 37, -1, 2, 57, 38, -1, 2, 57, 39, -1, 2, 57, 40, -1, 2, 57, 41, -1, 2, 57, 42, -1, 2, 57, 43, -1, 2, 57, 44, -1, 2, 57, 45, -1, 2, 57, 46, -1, 2, 57, 47, -1, 2, 57, 48, -1, 2, 57, 49, -1, 2, 57, 50, -1, 2, 57, 51, -1, 2, 57, 52, -1, 2, 57, 53, -1, 2, 57, 54, -1, 2, 57, 55, -1, 2, 57, 56, -1, 2, 57, 57, -1, 2, 57, 58, -1, 2, 57, 59, -1, 2, 57, 60, -1, 2, 57, 61, -1, 2, 57, 62, -1, 2, 57, 63, 565, 2, 58, 14, -1, 2, 58, 15, 576, 2, 58, 16, -1, 2, 58, 17, -1, 2, 58, 18, -1, 2, 58, 19, -1, 2, 58, 20, -1, 2, 58, 21, -1, 2, 58, 22, -1, 2, 58, 23, -1, 2, 58, 24, -1, 2, 58, 25, -1, 2, 58, 26, -1, 2, 58, 27, -1, 2, 58, 28, -1, 2, 58, 29, -1, 2, 58, 30, -1, 2, 58, 31, -1, 2, 58, 32, -1, 2, 58, 33, -1, 2, 58, 34, -1, 2, 58, 35, -1, 2, 58, 36, -1, 2, 58, 37, -1, 2, 58, 38, -1, 2, 58, 39, -1, 2, 58, 40, -1, 2, 58, 41, -1, 2, 58, 42, -1, 2, 58, 43, -1, 2, 58, 44, -1, 2, 58, 45, -1, 2, 58, 63, 581, 2, 59, 14, -1, 2, 59, 15, 544, 2, 59, 16, -1, 2, 59, 17, -1, 2, 59, 18, -1, 2, 59, 19, -1, 2, 59, 20, -1, 2, 59, 21, -1, 2, 59, 22, -1, 2, 59, 23, -1, 2, 59, 24, -1, 2, 59, 25, -1, 2, 59, 26, -1, 2, 59, 27, -1, 2, 59, 28, -1, 2, 59, 29, -1, 2, 59, 30, -1, 2, 59, 31, -1, 2, 59, 32, -1, 2, 59, 33, -1, 2, 59, 34, -1, 2, 59, 35, -1, 2, 59, 36, -1, 2, 59, 37, -1, 2, 59, 38, -1, 2, 59, 39, -1, 2, 59, 40, -1, 2, 59, 41, -1, 2, 59, 42, -1, 2, 59, 43, -1, 2, 59, 44, -1, 2, 59, 45, -1, 2, 59, 63, 549, 2, 60, 14, -1, 2, 60, 15, 560, 2, 60, 63, 565, 2, 61, 2, -1, 2, 61, 15, 576, 2, 61, 63, 581, 2, 62, 15, 592, 2, 62, 16, 593, 2, 62, 46, 596, 2, 62, 62, 596, 2, 62, 63, 597, 2, 63, 15, 608, 2, 63, 16, 609, 2, 63, 17, 610, 2, 63, 18, 611, 2, 63, 19, 610, 2, 63, 20, 611, 2, 63, 21, 610, 2, 63, 22, 611, 2, 63, 23, 610, 2, 63, 24, 611, 2, 63, 25, 610, 2, 63, 26, 610, 2, 63, 27, 611, 2, 63, 28, 610, 2, 63, 29, 611, 2, 63, 30, 610, 2, 63, 31, 611, 2, 63, 32, 610, 2, 63, 33, 611, 2, 63, 34, 610, 2, 63, 35, 611, 2, 63, 36, 610, 2, 63, 37, 611, 2, 63, 38, 610, 2, 63, 39, 611, 2, 63, 40, 610, 2, 63, 41, 611, 2, 63, 42, 610, 2, 63, 43, 611, 2, 63, 44, 610, 2, 63, 45, 611, 2, 63, 46, 610, 2, 63, 47, 610, 2, 63, 48, 610, 2, 63, 49, 611, 2, 63, 50, 610, 2, 63, 51, 611, 2, 63, 52, 610, 2, 63, 53, 611, 2, 63, 54, 610, 2, 63, 55, 611, 2, 63, 56, 610, 2, 63, 57, 611, 2, 63, 58, 610, 2, 63, 59, 611, 2, 63, 60, 610, 2, 63, 61, 611, 2, 63, 62, 612, 2, 63, 63, 613 }

-- Allacrost map editor end. Do not edit this line. --

betrayal_scene = false;

-- these are NPCs who will need to be accessed by multiple functions
claudius = nil;
captain = nil;
hector = nil;
alex = nil;
fred = nil;
scott = nil;
jeff = nil;
tim = nil;
joe = nil;

function Load(m)
	-- First, record the current map in the map variable that is global to this script
	map = m;
	map.run_forever = true;
	dialogue_supervisor = m.dialogue_supervisor;
	event_supervisor = m.event_supervisor;

	local dialogue;
	local event;
	local chest;
	local text;

	if (GlobalManager:GetEventGroup("kyle_story"):DoesEventExist("desert_beast_fought") == true and GlobalManager:GetEventGroup("kyle_story"):DoesEventExist("betrayal") == false) then
		betrayal_scene = true;
	end

	CreateDialogue();

	-- Generic Karlate Sprite (outside barracks guard)
	fred = ConstructSprite("Karlate", 4, 28, 78, 0.0, 0.0);
	fred:SetName(hoa_system.Translate("Fred"));
	if (betrayal_scene == false) then
		fred:AddDialogueReference(2);
	else
		fred:AddDialogueReference(5);
	end
	map:AddGroundObject(fred);

	-- Generic Karlate Sprite (kitchen guard)
	scott = ConstructSprite("Karlate", 5, 120, 105, 0.0, 0.0);
	scott:SetName(hoa_system.Translate("Scott"));
	scott:AddDialogueReference(3);
	scott:SetContext(2);
	map:AddGroundObject(scott);

	-- Generic Karlate Sprite, inside the barracks building
	alex = ConstructSprite("Karlate", 7, 72, 77, 0.0, 0.0);
	alex:SetName(hoa_system.Translate("Alex"));
	alex:SetMovementSpeed(hoa_map.MapMode.VERY_FAST_SPEED);
	if (betrayal_scene == true) then
		alex:SetXPosition(66, 0);
		alex:SetYPosition(50, 0);
	else
		alex:AddDialogueReference(4);
	end
	alex:SetContext(2);
	map:AddGroundObject(alex);

	-- Generic Karlate Sprite, wakes up Claudius
	hector = ConstructSprite("Karlate", 8, 72, 50, 0.0, 0.0);
	hector:SetName(hoa_system.Translate("Hector"));
	hector:SetContext(2);
	if (betrayal_scene == true) then
		hector:SetMovementSpeed(hoa_map.MapMode.VERY_FAST_SPEED);
	end
	map:AddGroundObject(hector);

	-- Captain, for the betrayal scene
	captain = ConstructSprite("Captain", 9, 24, 70, 0.0, 0.0);
	if (betrayal_scene == true) then
		captain:SetMovementSpeed(hoa_map.MapMode.VERY_FAST_SPEED);
		captain:AddDialogueReference(6);
		map:AddGroundObject(captain);
	end

	-- Generic sprites, currently just used as extras
	jeff = ConstructSprite("Karlate", 10, 20, 78, 0.0, 0.0);
	jeff:SetName(hoa_system.Translate("Jeff"));
	jeff:SetMovementSpeed(hoa_map.MapMode.VERY_FAST_SPEED);
	if (betrayal_scene == true) then
		map:AddGroundObject(jeff);
	end

	tim = ConstructSprite("Karlate", 11, 20, 74, 0.0, 0.0);
	tim:SetName(hoa_system.Translate("Tim"));
	tim:SetMovementSpeed(hoa_map.MapMode.VERY_FAST_SPEED);
	if (betrayal_scene == true) then
		map:AddGroundObject(tim);
	end

	joe = ConstructSprite("Karlate", 12, 28, 74, 0.0, 0.0);
	joe:SetName(hoa_system.Translate("Joe"));
	joe:SetMovementSpeed(hoa_map.MapMode.VERY_FAST_SPEED);
	if (betrayal_scene == true) then
		map:AddGroundObject(joe);
	end

	-- Create a zone for exiting the map, to be used as a trigger
	exit_zone = hoa_map.MapZone();
	exit_zone:AddSection(hoa_map.ZoneSection(0, 0, 10, 128));
	map:AddZone(exit_zone);

	-- Create zones for switching the map context
	context_zone = hoa_map.ContextZone(1, 2);
	context_zone:AddSection(hoa_map.ZoneSection(58, 80, 61, 83), false);
	context_zone:AddSection(hoa_map.ZoneSection(56, 80, 57, 83), true);
	map:AddZone(context_zone);

	-- Register event functions
	event = hoa_map.ScriptedEvent(1, 1, 0);
	event_supervisor:RegisterEvent(event);

	event = hoa_map.MapTransitionEvent(22111, "dat/maps/desert_training.lua");
	event_supervisor:RegisterEvent(event);

	-- Betrayal dialogue
	event = hoa_map.DialogueEvent(23001, 1);
	event_supervisor:RegisterEvent(event);
	event = hoa_map.PathMoveSpriteEvent(23002, hector, 72, 82);
	event:AddEventLink(23003, false, 0);
	event_supervisor:RegisterEvent(event);
	event = hoa_map.PathMoveSpriteEvent(23003, hector, 26, 82);
	event_supervisor:RegisterEvent(event);
	event = hoa_map.PathMoveSpriteEvent(23004, alex, 66, 82);
	event:AddEventLink(23014, false, 0);
	event_supervisor:RegisterEvent(event);
	event = hoa_map.PathMoveSpriteEvent(23014, alex, 18, 82);
	event_supervisor:RegisterEvent(event);

	-- Captain speech post-game
	event = hoa_map.ScriptedEvent(23005, 2, 0);
	event:AddEventLink(23006, false, 0);
	event_supervisor:RegisterEvent(event);
	event = hoa_map.PathMoveSpriteEvent(23006, captain, 1, 70);
	event_supervisor:RegisterEvent(event);
	event = hoa_map.PathMoveSpriteEvent(23007, hector, 1, 82);
	event_supervisor:RegisterEvent(event);
	event = hoa_map.PathMoveSpriteEvent(23008, alex, 1, 82);
	event:AddEventLink(23012, false, 0);
	event_supervisor:RegisterEvent(event);
	event = hoa_map.PathMoveSpriteEvent(23009, jeff, 1, 78);
	event_supervisor:RegisterEvent(event);
	event = hoa_map.PathMoveSpriteEvent(23010, tim, 1, 74);
	event_supervisor:RegisterEvent(event);
	event = hoa_map.PathMoveSpriteEvent(23011, joe, 1, 74);
	event_supervisor:RegisterEvent(event);
	event = hoa_map.ScriptedEvent(23012, 3, 0);
	event_supervisor:RegisterEvent(event);

	if (betrayal_scene == true) then
		-- TODO: use video effect for darkness?
		map:PlayMusic(1);
		GlobalManager:RemoveCharacter(KYLE);                        -- Kyle disappears, get him out of the party
		claudius = ConstructSprite("Claudius", 1000, 63, 45);       -- place Claudius in the barracks (coordinates)
		claudius:SetContext(2);                                     -- place Claudius in the barracks (context)
		event_supervisor:StartEvent(23001);                         -- start dialogue
	else
		-- No special event, so just start at the entrance
		claudius = ConstructSprite("Claudius", 1000, 16, 85);       -- place Claudius at the entrance
	end

	-- just make sure this exists, it should as long as we're not coming from an old savefile
	-- there's only one entrance for this map, so we don't do anything except define that this is where we came from
	if (GlobalManager:DoesEventGroupExist("last_visited") == false) then
		GlobalManager:AddNewEventGroup("last_visited");
		GlobalManager:GetEventGroup("last_visited"):AddNewEvent("map_number", 2);
	end
	GlobalManager:GetEventGroup("last_visited"):SetEvent("map_number", 2);

	-- Finally, set the camera to focus on the players sprite
	map:AddGroundObject(claudius);                                      -- add Claudius to map
	map:SetCamera(claudius);
end -- function Load()


function Update()
	-- Check if the map camera is in the exit zone
	if (exit_zone:IsInsideZone(map.camera.x_position, map.camera.y_position) == true) then
		if (event_supervisor:IsEventActive(22111) == false) then
			event_supervisor:StartEvent(22111);
		end
	end
end

function CreateDialogue()
	local dialogue;
	
	dialogue = hoa_map.MapDialogue(1);
		text = hoa_system.Translate("Claudius?  Claudius!  WAKE UP!");
		dialogue:AddText(text, 8, 1, 0, false);
		text = hoa_system.Translate("Huh?  What?");
		dialogue:AddText(text, 1000, 2, 0, false);
		text = hoa_system.Translate("Get your gear and let’s go!");
		dialogue:AddText(text, 8, 3, 0, false);
		text = hoa_system.Translate("What’s going on?");
		dialogue:AddText(text, 1000, 4, 0, false);
		text = hoa_system.Translate("The treasury!  A thief has broken in and stolen everything.  The captain has called a man hunt.  Now equip yourself and meet us out front.");
		dialogue:AddText(text, 7, 5, 0, false);
		text = hoa_system.Translate("Come on, Kyle, let’s go! Kyle?");
		dialogue:AddText(text, 1000, 6, 0, false);
		text = hoa_system.Translate("Oh no.");
		dialogue:AddText(text, 1000, -1, 1, false);
	dialogue_supervisor:AddDialogue(dialogue);

	dialogue = hoa_map.MapDialogue(2);
		text = hoa_system.Translate("This way to the barracks.");
		dialogue:AddText(text, 4, -1, 0, false);
	dialogue_supervisor:AddDialogue(dialogue);

	dialogue = hoa_map.MapDialogue(3);
		text = hoa_system.Translate("Entry into the kitchen is strictly forbidden!");
		dialogue:AddText(text, 5, -1, 0, false);
	dialogue_supervisor:AddDialogue(dialogue);

	dialogue = hoa_map.MapDialogue(4);
		text = hoa_system.Translate("Hi, Claudius.  If you're looking for the captain, he's at the training hall.");
		dialogue:AddText(text, 7, -1, 0, false);
	dialogue_supervisor:AddDialogue(dialogue);

	dialogue = hoa_map.MapDialogue(5);
		text = hoa_system.Translate("I'll stay behind and protect the barracks.  Good luck!");
		dialogue:AddText(text, 4, -1, 0, false);
	dialogue_supervisor:AddDialogue(dialogue);

	dialogue = hoa_map.MapDialogue(6);
		text = hoa_system.Translate("For those of you who don’t know, a thief has broken into the armory. It is up to us to capture him. Split up and comb the area.");
		dialogue:AddText(text, 9, 1, 0, false);
		text = hoa_system.Translate("Sir?");
		dialogue:AddText(text, 1000, 2, 0, false);
		text = hoa_system.Translate("Yes, Claudius?");
		dialogue:AddText(text, 9, 3, 0, false);
		text = hoa_system.Translate("…Nothing.");
		dialogue:AddText(text, 1000, 4, 0, false);
		text = hoa_system.Translate("You have your orders.  Now go.");
		dialogue:AddText(text, 9, -1, 23005, false);
	dialogue_supervisor:AddDialogue(dialogue);
end

map_functions[1] = function()
	GlobalManager:GetEventGroup("kyle_story"):AddNewEvent("betrayal", 1);
	event_supervisor:StartEvent(23004);
	event_supervisor:StartEvent(23002);
end

map_functions[2] = function()
	event_supervisor:StartEvent(23007);
	event_supervisor:StartEvent(23008);
	event_supervisor:StartEvent(23009);
	event_supervisor:StartEvent(23010);
	event_supervisor:StartEvent(23011);
end

map_functions[3] = function()
	hector:SetContext(2);
	alex:SetContext(2);
	jeff:SetContext(2);
	tim:SetContext(2);
	joe:SetContext(2);
	captain:SetContext(2);
end
