local ns = {}
setmetatable(ns, {__index = _G})
demo_town = ns;
setfenv(1, ns);

-- The map name and location graphic
map_name = "Village"
location_filename = "mountain_village.png"

enemy_ids = {}

-- Allacrost map editor begin. Do not edit this line. --

-- A reference to the C++ MapMode object that was created with this file
map = {}
dialogue_supervisor = {}

-- The number of contexts, rows, and columns that compose the map
num_map_contexts = 2
num_tile_cols = 60
num_tile_rows = 40

-- The sound files used on this map.
sound_filenames = {}
sound_filenames[1] = "snd/coins.wav"

-- The music files used as background music on this map.
music_filenames = {}
music_filenames[1] = "mus/Town_Folk.ogg"

-- The names of the contexts used to improve Editor user-friendliness
context_names = {}
context_names[1] = "House_Interior"

-- The names of the tilesets used, with the path and file extension omitted
tileset_filenames = {}
tileset_filenames[1] = "mountain_landscape"
tileset_filenames[2] = "mountain_house_exterior"
tileset_filenames[3] = "mountain_house_exterior2"
tileset_filenames[4] = "mountain_house_interior"

-- The map grid to indicate walkability. The size of the grid is 4x the size of the tile layer tables
-- Walkability status of tiles for 32 contexts. Zero indicates walkable. Valid range: [0:2^32-1]
map_grid = {}
map_grid[0] = { 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[1] = { 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[2] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[3] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[4] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[5] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[6] = { 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[7] = { 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[8] = { 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[9] = { 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[10] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[11] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[12] = { 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[13] = { 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[14] = { 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0 }
map_grid[15] = { 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0 }
map_grid[16] = { 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0 }
map_grid[17] = { 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0 }
map_grid[18] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0 }
map_grid[19] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0 }
map_grid[20] = { 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1 }
map_grid[21] = { 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1 }
map_grid[22] = { 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1 }
map_grid[23] = { 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1 }
map_grid[24] = { 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0 }
map_grid[25] = { 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0 }
map_grid[26] = { 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1 }
map_grid[27] = { 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1 }
map_grid[28] = { 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1 }
map_grid[29] = { 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1 }
map_grid[30] = { 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[31] = { 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[32] = { 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0 }
map_grid[33] = { 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0 }
map_grid[34] = { 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[35] = { 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[36] = { 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[37] = { 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[38] = { 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[39] = { 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[40] = { 0, 0, 0, 1, 3, 3, 2, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0 }
map_grid[41] = { 0, 0, 1, 1, 3, 3, 2, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0 }
map_grid[42] = { 0, 0, 1, 1, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[43] = { 0, 0, 1, 1, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[44] = { 0, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[45] = { 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[46] = { 1, 1, 0, 1, 3, 3, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[47] = { 1, 1, 0, 1, 3, 3, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[48] = { 1, 1, 0, 0, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[49] = { 1, 1, 0, 0, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[50] = { 1, 1, 0, 0, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[51] = { 1, 1, 0, 0, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[52] = { 1, 1, 0, 0, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1 }
map_grid[53] = { 1, 1, 0, 0, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1 }
map_grid[54] = { 0, 1, 0, 0, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1 }
map_grid[55] = { 0, 1, 0, 0, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0 }
map_grid[56] = { 0, 0, 0, 0, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0 }
map_grid[57] = { 0, 0, 0, 0, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0 }
map_grid[58] = { 0, 0, 0, 0, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[59] = { 0, 0, 0, 0, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[60] = { 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 1, 0, 0, 0, 0 }
map_grid[61] = { 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0 }
map_grid[62] = { 1, 1, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0 }
map_grid[63] = { 1, 1, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0 }
map_grid[64] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0 }
map_grid[65] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0 }
map_grid[66] = { 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0 }
map_grid[67] = { 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0 }
map_grid[68] = { 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 }
map_grid[69] = { 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 }
map_grid[70] = { 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 }
map_grid[71] = { 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 }
map_grid[72] = { 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 }
map_grid[73] = { 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 }
map_grid[74] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 }
map_grid[75] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 }
map_grid[76] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0 }
map_grid[77] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0 }
map_grid[78] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0 }
map_grid[79] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0 }

-- The lower tile layer. The numbers are indeces to the tile_mappings table.
lower_layer = {}
lower_layer[0] = { 10, 10, 10, 10, 10, 10, 111, 12, 13, 95, 78, 95, 11, 110, 42, 111, 110, 26, 26, 78, 78, 111, 13, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 111, 110, 78, 78, 26, 10, 10, 10, 10, 111, 12, 13, 94, 78, 95, 95, 78 }
lower_layer[1] = { 78, 78, 78, 78, 78, 10, 10, 10, 111, 13, 95, 78, 27, 10, 26, 42, 42, 78, 78, 78, 78, 78, 29, 78, 78, 78, 78, 78, 78, 78, 79, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 10, 10, 111, 12, 13, 95, 11, 13 }
lower_layer[2] = { 78, 78, 78, 78, 78, 78, 78, 10, 10, 111, 12, 13, 27, 10, 10, 10, 78, 78, 78, 78, 78, 78, 111, 12, 12, 13, 78, 78, 11, 12, 12, 13, 11, 12, 110, 10, 10, 10, 10, 10, 10, 10, 10, 78, 78, 95, 95, 78, 78, 78, 78, 78, 78, 78, 78, 10, 111, 13, 43, 45 }
lower_layer[3] = { 78, 78, 78, 78, 78, 78, 78, 78, 10, 10, 10, 111, 110, 42, 10, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 111, 12, 12, 110, 10, 10, 111, 110, 78, 78, 78, 78, 78, 78, 78, 78, 10, 10, 10, 13, 95, 95, 95, 79, 79, 27, 10, 78, 78, 78, 10, 10, 111, 13, 95 }
lower_layer[4] = { 78, 78, 78, 78, 78, 78, 78, 78, 10, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 42, 10, 10, 42, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 42, 42, 111, 12, 13, 95, 79, 11, 110, 10, 10, 10, 10, 10, 127, 126, 29, 78 }
lower_layer[5] = { 78, 78, 78, 79, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 42, 42, 111, 12, 12, 110, 127, 44, 126, 10, 10, 78, 111, 110, 29, 78 }
lower_layer[6] = { 78, 79, 79, 79, 78, 79, 78, 78, 78, 78, 78, 78, 78, 78, 78, 95, 78, 79, 78, 79, 95, 78, 95, 95, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 42, 42, 42, 111, 13, 27, 28, 10, 78, 10, 10, 29, 78 }
lower_layer[7] = { 78, 78, 79, 79, 79, 78, 78, 78, 78, 78, 78, 78, 78, 78, 95, 78, 95, 78, 79, 78, 79, 79, 79, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 79, 78, 79, 95, 95, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 111, 110, 28, 10, 78, 78, 10, 111, 12 }
lower_layer[8] = { 78, 78, 79, 79, 78, 79, 78, 78, 78, 78, 79, 78, 11, 12, 13, 78, 79, 78, 78, 79, 78, 79, 78, 79, 79, 95, 78, 78, 78, 78, 79, 78, 79, 95, 79, 79, 79, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 127, 126, 10, 78, 78, 78, 10, 10 }
lower_layer[9] = { 78, 78, 78, 79, 79, 11, 12, 12, 12, 13, 79, 11, 110, 10, 111, 12, 12, 13, 78, 79, 11, 12, 13, 78, 78, 79, 95, 78, 78, 78, 79, 79, 78, 11, 13, 95, 95, 79, 95, 79, 78, 79, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 29, 27, 10, 10, 10, 78, 78, 78 }
lower_layer[10] = { 78, 78, 78, 11, 12, 110, 26, 26, 42, 111, 12, 110, 10, 42, 42, 26, 26, 29, 95, 11, 110, 28, 111, 12, 12, 12, 13, 78, 78, 95, 79, 79, 95, 43, 45, 79, 78, 79, 95, 95, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 111, 110, 28, 10, 10, 78, 78, 78 }
lower_layer[11] = { 78, 78, 78, 27, 26, 59, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 61, 111, 78, 43, 44, 126, 28, 28, 28, 127, 45, 78, 78, 79, 78, 79, 79, 78, 79, 95, 79, 95, 79, 78, 79, 11, 12, 13, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 10, 10, 10 }
lower_layer[12] = { 78, 78, 78, 27, 26, 75, 76, 76, 76, 76, 76, 76, 76, 76, 76, 30, 77, 26, 111, 13, 78, 43, 44, 44, 44, 45, 11, 12, 13, 79, 79, 79, 95, 79, 78, 79, 79, 78, 79, 95, 79, 43, 126, 111, 12, 12, 13, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78 }
lower_layer[13] = { 78, 78, 78, 27, 26, 75, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 77, 127, 126, 111, 12, 13, 11, 12, 13, 11, 110, 10, 111, 12, 12, 13, 79, 78, 79, 79, 79, 79, 95, 79, 78, 78, 43, 44, 126, 28, 111, 13, 78, 78, 78, 78, 95, 95, 78, 78, 78, 78, 78, 78 }
lower_layer[14] = { 42, 78, 78, 43, 126, 75, 76, 76, 76, 76, 76, 76, 76, 76, 76, 30, 77, 111, 110, 28, 28, 111, 110, 42, 111, 110, 10, 10, 10, 42, 42, 111, 13, 79, 78, 79, 79, 95, 79, 95, 78, 79, 95, 78, 43, 44, 44, 45, 78, 95, 78, 95, 95, 79, 78, 78, 78, 78, 78, 79 }
lower_layer[15] = { 42, 42, 78, 78, 27, 75, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 47, 61, 59, 60, 60, 60, 46, 47, 60, 60, 61, 10, 42, 28, 42, 42, 29, 78, 78, 78, 78, 95, 78, 95, 95, 95, 95, 79, 95, 79, 78, 79, 78, 79, 79, 79, 95, 78, 78, 78, 78, 78, 78, 78 }
lower_layer[16] = { 126, 42, 78, 78, 27, 75, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 15, 77, 91, 63, 76, 76, 31, 76, 76, 14, 47, 61, 127, 126, 28, 127, 45, 79, 78, 95, 95, 95, 78, 79, 95, 79, 79, 78, 79, 78, 79, 78, 79, 79, 11, 12, 13, 78, 11, 12, 13, 78, 78, 78 }
lower_layer[17] = { 27, 42, 78, 11, 110, 75, 76, 76, 76, 76, 76, 76, 76, 76, 76, 31, 30, 47, 61, 91, 62, 76, 76, 76, 30, 76, 31, 77, 111, 110, 28, 29, 79, 79, 95, 79, 79, 79, 11, 13, 78, 95, 95, 95, 95, 78, 79, 79, 79, 79, 43, 44, 45, 11, 110, 28, 111, 12, 12, 12 }
lower_layer[18] = { 27, 42, 78, 43, 126, 91, 62, 76, 76, 15, 31, 30, 76, 30, 76, 15, 63, 62, 77, 10, 91, 92, 92, 62, 76, 76, 15, 77, 28, 28, 28, 29, 11, 12, 12, 12, 12, 12, 110, 111, 12, 12, 12, 12, 13, 95, 78, 11, 13, 78, 79, 11, 12, 110, 28, 28, 28, 28, 28, 28 }
lower_layer[19] = { 110, 78, 78, 78, 43, 126, 91, 92, 92, 62, 63, 92, 92, 92, 62, 63, 93, 91, 93, 42, 10, 127, 126, 91, 62, 76, 76, 77, 28, 28, 28, 111, 110, 28, 28, 28, 42, 28, 42, 28, 28, 42, 42, 28, 111, 12, 12, 110, 111, 12, 12, 110, 28, 28, 127, 44, 44, 44, 44, 44 }
lower_layer[20] = { 78, 78, 78, 78, 78, 43, 44, 44, 126, 10, 42, 26, 127, 126, 26, 28, 42, 26, 42, 26, 42, 111, 110, 26, 75, 76, 76, 77, 28, 127, 44, 126, 28, 28, 10, 28, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 42, 42, 127, 126, 29, 78, 78, 78, 78, 78 }
lower_layer[21] = { 78, 78, 78, 78, 78, 78, 78, 78, 43, 126, 42, 42, 29, 43, 126, 28, 42, 26, 26, 42, 26, 28, 127, 126, 75, 76, 76, 77, 28, 29, 78, 27, 28, 42, 42, 28, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 42, 42, 42, 111, 110, 111, 13, 78, 78, 78, 78 }
lower_layer[22] = { 78, 78, 78, 78, 78, 78, 78, 78, 11, 110, 42, 26, 111, 12, 110, 26, 127, 44, 126, 42, 10, 127, 45, 27, 75, 76, 76, 77, 127, 45, 11, 110, 28, 28, 28, 28, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 28, 10, 10, 28, 111, 78, 78, 78, 78 }
lower_layer[23] = { 78, 78, 78, 78, 78, 78, 78, 78, 43, 44, 44, 44, 44, 126, 42, 42, 111, 12, 110, 42, 26, 29, 78, 27, 75, 76, 76, 77, 29, 11, 110, 59, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 61, 28, 28, 78, 127, 44, 44, 44 }
lower_layer[24] = { 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 43, 44, 44, 126, 42, 26, 127, 44, 45, 11, 110, 75, 76, 76, 77, 29, 27, 28, 75, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 77, 28, 28, 78, 111, 13, 78, 78 }
lower_layer[25] = { 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 11, 13, 78, 78, 78, 43, 126, 127, 45, 95, 78, 27, 26, 75, 14, 76, 77, 29, 43, 126, 75, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 77, 28, 28, 78, 10, 111, 13, 78 }
lower_layer[26] = { 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 43, 45, 78, 78, 78, 78, 43, 45, 78, 11, 12, 110, 26, 75, 76, 31, 77, 29, 11, 110, 75, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 77, 28, 28, 78, 10, 10, 29, 78 }
lower_layer[27] = { 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 13, 78, 78, 78, 78, 78, 78, 78, 78, 78, 27, 26, 26, 26, 75, 15, 76, 77, 111, 110, 26, 75, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 77, 28, 127, 78, 10, 10, 29, 78 }
lower_layer[28] = { 78, 11, 12, 78, 78, 318, 319, 78, 78, 28, 111, 13, 78, 10, 10, 78, 78, 78, 78, 78, 27, 127, 126, 28, 91, 92, 92, 93, 28, 127, 126, 75, 30, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 77, 127, 45, 78, 10, 10, 29, 78 }
lower_layer[29] = { 78, 27, 59, 60, 78, 334, 335, 78, 78, 28, 127, 45, 78, 10, 10, 78, 78, 78, 78, 11, 110, 111, 110, 28, 28, 28, 26, 26, 127, 45, 27, 91, 62, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 77, 29, 78, 78, 78, 10, 111, 13 }
lower_layer[30] = { 78, 27, 75, 15, 76, 350, 351, 78, 42, 42, 29, 78, 78, 26, 78, 78, 78, 78, 11, 110, 28, 28, 26, 28, 127, 44, 126, 127, 45, 78, 43, 126, 91, 62, 76, 31, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 77, 29, 78, 78, 78, 78, 10, 29 }
lower_layer[31] = { 78, 27, 75, 76, 15, 30, 31, 77, 42, 127, 45, 78, 78, 78, 78, 78, 78, 78, 27, 28, 26, 127, 44, 44, 45, 78, 43, 45, 78, 78, 78, 43, 126, 75, 76, 76, 14, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 77, 29, 78, 78, 78, 78, 78, 111 }
lower_layer[32] = { 78, 27, 91, 92, 62, 76, 14, 77, 42, 111, 13, 78, 78, 78, 78, 78, 78, 11, 110, 26, 127, 45, 78, 78, 11, 13, 78, 78, 78, 78, 78, 78, 27, 91, 92, 92, 62, 31, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 77, 111, 13, 78, 78, 78, 78, 78 }
lower_layer[33] = { 78, 43, 44, 126, 91, 62, 76, 63, 42, 10, 111, 12, 13, 78, 78, 78, 11, 110, 28, 127, 45, 78, 78, 78, 43, 45, 78, 78, 78, 78, 78, 78, 43, 44, 44, 126, 75, 15, 31, 76, 76, 76, 76, 76, 76, 76, 318, 319, 76, 76, 76, 76, 77, 26, 29, 78, 78, 78, 78, 78 }
lower_layer[34] = { 78, 78, 78, 27, 42, 91, 92, 93, 42, 42, 28, 28, 111, 12, 13, 11, 110, 28, 127, 45, 78, 78, 10, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 27, 75, 76, 76, 76, 76, 76, 76, 14, 14, 14, 334, 335, 14, 76, 76, 76, 77, 26, 111, 13, 78, 78, 78, 78 }
lower_layer[35] = { 78, 78, 78, 43, 126, 127, 126, 42, 42, 42, 10, 42, 10, 42, 111, 110, 127, 44, 45, 78, 78, 127, 126, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 11, 13, 27, 91, 92, 62, 30, 76, 76, 76, 76, 76, 14, 350, 351, 76, 76, 76, 14, 77, 28, 26, 111, 13, 78, 78, 78 }
lower_layer[36] = { 78, 78, 78, 78, 43, 45, 43, 126, 42, 127, 44, 44, 44, 44, 44, 44, 45, 78, 78, 78, 78, 29, 43, 126, 78, 78, 78, 78, 78, 78, 78, 78, 11, 110, 29, 27, 26, 26, 75, 76, 76, 31, 76, 76, 76, 76, 76, 76, 76, 76, 15, 31, 77, 28, 127, 44, 45, 78, 78, 78 }
lower_layer[37] = { 126, 78, 78, 78, 78, 78, 78, 43, 44, 45, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 111, 13, 27, 42, 13, 78, 78, 78, 78, 78, 78, 43, 44, 45, 43, 126, 26, 75, 76, 30, 76, 76, 14, 63, 92, 92, 92, 92, 92, 92, 92, 93, 127, 45, 78, 78, 78, 78, 78 }
lower_layer[38] = { 43, 126, 42, 42, 78, 78, 78, 78, 78, 78, 78, 78, 11, 13, 78, 78, 78, 78, 78, 78, 42, 28, 111, 110, 127, 44, 126, 78, 78, 78, 78, 78, 78, 78, 78, 78, 27, 26, 91, 92, 92, 92, 92, 92, 93, 10, 127, 44, 44, 44, 44, 44, 44, 45, 78, 78, 78, 78, 78, 78 }
lower_layer[39] = { 78, 43, 44, 44, 126, 42, 78, 78, 78, 78, 78, 78, 43, 45, 78, 78, 78, 78, 78, 42, 42, 28, 28, 28, 29, 78, 43, 126, 78, 78, 78, 78, 78, 78, 78, 78, 43, 126, 26, 42, 26, 42, 26, 127, 44, 44, 45, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 28 }

-- The middle tile layer. The numbers are indeces to the tile_mappings table.
middle_layer = {}
middle_layer[0] = { -1, -1, -1, -1, 249, 250, -1, -1, -1, -1, 233, 234, -1, -1, -1, -1, -1, -1, -1, 57, 144, -1, 64, 65, 68, 69, 96, 97, 98, 99, 86, 87, 82, 83, 70, 71, 66, 67, 66, 67, 66, 67, 54, -1, -1, 57, 54, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[1] = { 66, 67, 66, 67, 54, -1, -1, -1, -1, -1, 249, 250, -1, -1, 235, -1, -1, 57, 72, 73, 160, 161, 80, 81, 84, 85, -1, -1, -1, -1, 102, 103, 98, 99, 86, 87, 82, 83, 82, 83, 82, 83, 70, 71, 72, 73, 70, 71, 66, 67, 66, 67, 54, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[2] = { 82, 83, 82, 83, 70, 71, 144, -1, -1, -1, -1, 252, -1, -1, 251, -1, 72, 73, 88, 89, 176, 177, 96, 97, 100, 101, -1, -1, -1, -1, -1, 251, -1, -1, 102, 103, 98, 99, 98, 99, 98, 99, 86, 87, 88, 89, 86, 87, 82, 83, 82, 83, 70, 71, 144, -1, -1, -1, -1, -1 }
middle_layer[3] = { 98, 99, 98, 99, 86, 87, 160, 161, 252, -1, -1, -1, -1, -1, 194, 195, 88, 89, 104, 105, 64, 65, 66, 67, 54, -1, -1, -1, -1, -1, -1, -1, -1, 57, 66, 67, 66, 67, 66, 67, 54, -1, 102, 103, 104, 105, 102, 103, 98, 99, 98, 99, 86, 87, 160, 161, -1, -1, -1, -1 }
middle_layer[4] = { -1, 252, -1, -1, 102, 103, 176, 177, -1, 57, 66, 67, 66, 67, 210, 211, 104, 105, -1, -1, 80, 81, 82, 83, 70, 71, 252, -1, 247, 248, 66, 67, 72, 73, 82, 83, 82, 83, 82, 83, 70, 71, -1, -1, -1, -1, -1, 249, 250, -1, -1, -1, 102, 103, 176, 177, -1, -1, -1, -1 }
middle_layer[5] = { 252, -1, -1, -1, -1, -1, 64, 65, 72, 73, 82, 83, 82, 83, 226, 227, 252, -1, -1, -1, 96, 97, 98, 99, 86, 87, 192, 193, 194, 195, 82, 83, 88, 89, 98, 99, 98, 99, 98, 99, 86, 87, 192, 193, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 32, 33, -1, -1, -1, -1 }
middle_layer[6] = { -1, 251, -1, -1, -1, -1, 80, 81, 88, 89, 98, 99, 98, 99, 242, 243, -1, -1, -1, -1, -1, -1, -1, -1, 102, 103, 208, 209, 210, 211, 98, 99, 104, 105, -1, -1, -1, -1, -1, -1, 102, 103, 208, 209, 66, 67, 54, -1, -1, -1, -1, -1, -1, -1, 48, 49, -1, -1, -1, -1 }
middle_layer[7] = { 252, -1, -1, 244, 245, 246, 96, 97, 104, 105, 247, 248, -1, -1, 251, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 224, 225, 226, 227, -1, 228, 229, 230, -1, -1, -1, -1, 244, 245, 246, -1, 224, 225, 82, 83, 70, 71, 66, 67, 144, -1, -1, -1, 64, 65, 144, -1, -1, -1 }
middle_layer[8] = { -1, 252, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 240, 241, 242, 243, -1, 244, 245, 246, -1, -1, -1, -1, -1, -1, -1, -1, 240, 241, 98, 99, 86, 87, 82, 83, 160, 161, -1, -1, 80, 81, 192, 193, -1, -1 }
middle_layer[9] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 249, 250, -1, -1, -1, -1, -1, -1, -1, -1, 102, 103, 98, 99, 176, 177, -1, -1, 96, 97, 208, 209, 66, 67 }
middle_layer[10] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 247, 248, -1, -1, -1, 48, 49, -1, -1, -1, -1, 224, 225, 82, 83 }
middle_layer[11] = { -1, -1, -1, -1, -1, -1, -1, -1, 290, 291, 292, 293, 294, 295, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 249, 250, 64, 65, 66, 67, 66, 67, 54, 241, 98, 99 }
middle_layer[12] = { -1, -1, -1, -1, -1, -1, -1, 305, 306, 307, 308, 309, 310, 311, 312, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 80, 81, 82, 83, 82, 83, 70, 71, 66, 67 }
middle_layer[13] = { -1, -1, -1, -1, -1, -1, -1, 321, 322, 323, 324, 325, 326, 327, 328, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 96, 97, 98, 99, 98, 99, 86, 87, 82, 83 }
middle_layer[14] = { -1, -1, -1, -1, -1, -1, -1, 337, 338, 339, 268, 269, 342, 343, 344, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 102, 103, 98, 99 }
middle_layer[15] = { -1, -1, 36, 37, -1, -1, -1, 353, 354, 355, 284, 285, 358, 359, 360, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 244, 245, 246, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[16] = { -1, -1, 52, 53, -1, -1, -1, 369, 370, 371, 300, 301, 374, 375, 376, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 251, -1, 251, -1, 251, -1 }
middle_layer[17] = { -1, -1, 36, 37, -1, -1, -1, 385, 386, 387, 316, 317, 390, 391, 392, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 249, 250, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[18] = { -1, -1, 52, 53, -1, -1, -1, 401, 402, 403, 404, 405, 406, 407, 408, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[19] = { -1, 147, 68, 69, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[20] = { 162, 163, 84, 85, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 251, -1, 251, -1, 251, -1 }
middle_layer[21] = { 178, 179, 100, 101, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 289, 290, 291, 292, 293, 292, 293, 294, 294, 292, 293, 292, 293, 292, 293, 294, 295, -1, -1, -1, -1, -1, 1, 2, 3, 2, 3 }
middle_layer[22] = { 163, 69, -1, 290, 291, 292, 293, 294, 295, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 305, 306, 307, 308, 309, 512, 513, 516, 310, 308, 309, 308, 309, 308, 309, 310, 311, 312, -1, -1, -1, 16, 17, 18, 19, 18, 19 }
middle_layer[23] = { 179, 85, 305, 306, 307, 308, 309, 310, 311, 312, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 321, 322, 323, 324, 325, 324, 529, 530, 531, 292, 325, 324, 325, 324, 325, 326, 327, 328, -1, -1, -1, 32, 33, -1, -1, -1, -1 }
middle_layer[24] = { 37, -1, 321, 322, 323, 324, 325, 326, 327, 328, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 337, 418, 419, 266, 267, 544, 545, 546, 547, 308, 309, 308, 309, 308, 309, 310, 311, 312, -1, -1, -1, 48, 49, -1, -1, -1, -1 }
middle_layer[25] = { 53, -1, 417, 418, 419, 270, 271, 422, 423, 424, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 433, 434, 435, 282, 283, 560, 561, 562, 563, 324, 325, 324, 325, 324, 325, 326, 327, 328, -1, -1, -1, 32, 33, -1, 196, 197, 198 }
middle_layer[26] = { 69, -1, 433, 434, 435, 286, 287, 438, 439, 440, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 449, 450, 451, 298, 299, 576, 577, 578, 579, 308, 309, 308, 309, 308, 309, 310, 311, 312, -1, -1, -1, 48, 49, -1, 228, 229, 230 }
middle_layer[27] = { 85, -1, 449, 450, 451, 302, 303, 454, 455, 456, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 466, 467, 314, 315, 592, 593, 594, 595, 324, 325, 324, 325, 324, 325, 326, 327, 328, -1, -1, -1, 32, 33, -1, 244, 245, 246 }
middle_layer[28] = { -1, -1, 465, 466, 467, 366, 367, 470, 471, 472, -1, 48, 49, -1, -1, 36, 37, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 481, 482, 483, 330, 331, 609, 305, 306, 307, 308, 309, 308, 309, 308, 309, 310, 311, 312, -1, -1, -1, 48, 49, -1, -1, -1, -1 }
middle_layer[29] = { -1, -1, 481, 482, 483, 382, 383, 486, 487, 488, -1, 32, 33, -1, -1, 52, 53, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 497, 498, 499, 346, 347, 625, 321, 322, 323, 324, 325, 324, 325, 324, 325, 326, 327, 328, -1, -1, -1, 64, 65, 144, -1, -1, -1 }
middle_layer[30] = { -1, -1, 497, 498, 499, 398, 399, 502, 503, 504, -1, 48, 49, -1, 57, 68, 69, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 417, 418, 419, 266, 267, 420, 421, 270, 271, 422, 423, 424, -1, -1, -1, 80, 81, 192, 193, -1, -1 }
middle_layer[31] = { -1, 252, 254, 255, -1, -1, -1, -1, -1, -1, -1, 64, 65, 72, 73, 84, 85, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 433, 434, 435, 282, 283, 436, 437, 286, 287, 438, 439, 440, -1, -1, -1, 96, 97, 208, 209, 144, -1 }
middle_layer[32] = { 252, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 80, 81, 88, 89, 100, 101, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 449, 450, 451, 298, 299, 452, 453, 302, 303, 454, 455, 456, -1, -1, -1, -1, -1, 224, 225, 160, 161 }
middle_layer[33] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 96, 97, 104, 105, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 465, 466, 467, 314, 315, 468, 469, 366, 367, 470, 471, 472, -1, -1, -1, -1, -1, 240, 241, 176, 177 }
middle_layer[34] = { 36, 37, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 481, 482, 483, 330, 331, 484, 485, 382, 383, 486, 487, 488, -1, -1, -1, -1, -1, -1, -1, 32, 33 }
middle_layer[35] = { 52, 53, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 33, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 497, 498, 499, 346, 347, 500, 501, 398, 399, 502, 503, 504, -1, -1, -1, -1, -1, -1, -1, 48, 49 }
middle_layer[36] = { 114, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 49, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 32, 33 }
middle_layer[37] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 40, 41, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 253, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 48, 49 }
middle_layer[38] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 249, 250, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 114, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1, 112, 113 }
middle_layer[39] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 33, -1, -1, -1, -1, -1, -1, -1, -1, -1, 131, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 16, 17, 128, -1 }

-- The upper tile layer. The numbers are indeces to the tile_mappings table.
upper_layer = {}
upper_layer[0] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[1] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 235, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 215, 216, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[2] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 215, 216, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 231, 232, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[3] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 231, 232, -1, -1, -1, -1, -1, -1, 252, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 233, 234, -1, -1, 196, 197, 198, -1, -1, -1, -1, -1, -1 }
upper_layer[4] = { -1, -1, -1, 196, 197, 198, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 212, 213, 214, -1, -1, -1, -1, -1, -1 }
upper_layer[5] = { -1, 235, -1, 212, 213, 214, -1, -1, -1, -1, 215, 216, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 196, 197, 198, -1, -1, -1, -1, 196, 197, 198, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 228, 229, 230, -1, -1, 215, 216, -1, -1 }
upper_layer[6] = { -1, -1, -1, 228, 229, 230, -1, -1, -1, -1, 231, 232, -1, -1, 235, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 212, 213, 214, -1, -1, 215, 216, 228, 229, 214, -1, -1, -1, -1, -1, -1, 252, -1, -1, -1, 244, 245, 246, -1, -1, 231, 232, -1, -1 }
upper_layer[7] = { 21, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 231, 232, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 247, 248, -1, -1 }
upper_layer[8] = { 37, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 233, 234, -1, -1, -1, -1, -1, -1, -1, 215, 216, -1, 215, 216, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[9] = { 53, -1, -1, -1, -1, -1, -1, 257, 258, -1, 260, 261, -1, 263, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 231, 232, -1, 231, 232, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[10] = { 115, 21, -1, -1, -1, -1, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 233, 234, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[11] = { 36, 37, -1, -1, -1, -1, 288, 289, -1, -1, -1, -1, -1, -1, 296, 297, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 240, -1, -1, -1 }
upper_layer[12] = { 52, 53, -1, -1, -1, -1, 304, 305, -1, -1, -1, -1, -1, -1, 312, 313, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 196, 197, 198, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[13] = { 114, 115, 4, -1, -1, -1, 320, 321, -1, -1, -1, -1, -1, -1, 328, 329, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 212, 213, 214, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[14] = { -1, 131, 20, 21, -1, -1, 336, 337, -1, -1, -1, -1, -1, -1, 344, 345, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 228, 229, 230, -1, -1, -1, -1, 215, 216, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[15] = { -1, -1, -1, -1, -1, -1, 352, 353, -1, -1, -1, -1, -1, -1, 360, 361, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 231, 232, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 235, -1, 235, -1, 235, -1 }
upper_layer[16] = { -1, -1, -1, -1, -1, -1, 368, -1, -1, -1, -1, -1, -1, -1, -1, 377, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 233, 234, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[17] = { -1, -1, -1, -1, -1, -1, 384, -1, -1, -1, -1, -1, -1, -1, -1, 393, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[18] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[19] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 257, 258, -1, 260, 261, 260, 261, -1, -1, 260, 261, 260, 261, 260, 261, -1, 263, 264, -1, -1, -1, 235, -1, 235, -1, 235, -1 }
upper_layer[20] = { -1, -1, 257, 258, -1, 260, 261, -1, 263, 264, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 272, 273, 274, 275, 276, 277, 276, 277, 278, 278, 276, 277, 276, 277, 276, 277, 278, 279, 280, 281, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[21] = { -1, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 288, 289, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 296, 297, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[22] = { -1, 288, 289, -1, -1, -1, -1, -1, -1, 296, 297, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 304, 305, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 312, 313, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[23] = { -1, 304, 305, -1, -1, -1, -1, -1, -1, 312, 313, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 320, 321, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 328, 329, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[24] = { -1, 320, 321, -1, -1, -1, -1, -1, -1, 328, 329, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 336, 337, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 312, 313, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[25] = { -1, 416, 337, -1, -1, -1, -1, -1, -1, 344, 425, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 352, 353, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 328, 329, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[26] = { -1, 432, 353, -1, -1, -1, -1, -1, -1, 360, 441, -1, 1, 2, 3, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 448, 369, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 312, 313, -1, -1, -1, 215, 216, -1, -1, -1 }
upper_layer[27] = { -1, 448, -1, -1, -1, -1, -1, -1, -1, -1, 457, 16, 17, 18, 19, 20, 21, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 464, 465, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 328, 329, -1, -1, -1, 231, 232, -1, -1, -1 }
upper_layer[28] = { -1, 464, -1, -1, -1, -1, -1, -1, -1, -1, 473, -1, 252, 215, 216, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 336, 305, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 312, 313, -1, -1, -1, 247, 248, -1, -1, -1 }
upper_layer[29] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 231, 232, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 352, 321, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 328, 329, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[30] = { 21, -1, 238, 239, -1, -1, -1, -1, -1, -1, -1, -1, -1, 247, 248, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 416, 337, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 344, 425, -1, -1, -1, -1, -1, 252, -1, -1 }
upper_layer[31] = { 37, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 432, 353, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 360, 441, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[32] = { 53, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 16, 17, 20, 21, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 448, 369, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 376, 457, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[33] = { 115, 21, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1, 112, 113, 36, 37, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 464, 465, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 472, 473, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[34] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 16, 17, 128, -1, 52, 53, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[35] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 215, 216, -1, -1, -1, -1, -1, -1, -1, 32, -1, -1, -1, 114, 115, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[36] = { -1, 115, 2, 3, 8, 9, -1, -1, -1, -1, 231, 232, -1, -1, -1, -1, -1, -1, -1, 48, -1, -1, -1, -1, 131, 24, 25, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 237, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[37] = { -1, 131, 18, 19, 24, 25, 8, 9, -1, -1, 233, 234, -1, -1, -1, -1, -1, -1, 1, 112, 113, -1, -1, -1, -1, -1, -1, 20, 21, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[38] = { -1, -1, -1, -1, 40, 41, 24, 25, 4, -1, -1, -1, -1, -1, -1, -1, -1, 16, 17, 128, 196, 197, 198, -1, -1, -1, -1, -1, 115, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[39] = { -1, -1, -1, -1, -1, -1, 40, 41, 20, 21, -1, -1, -1, -1, -1, -1, -1, 32, -1, -1, 212, 213, 214, -1, -1, -1, -1, -1, -1, 20, 21, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }

-- All, if any, existing contexts follow.
context_01 = { 0, 0, 0, -1, 0, 0, 1, -1, 0, 0, 2, -1, 0, 0, 3, -1, 0, 0, 4, -1, 0, 0, 5, -1, 0, 0, 6, -1, 0, 0, 7, -1, 0, 0, 8, -1, 0, 0, 9, -1, 0, 0, 10, -1, 0, 0, 11, -1, 0, 0, 12, -1, 0, 0, 13, -1, 0, 0, 14, -1, 0, 0, 15, -1, 0, 0, 16, -1, 0, 0, 17, -1, 0, 0, 18, -1, 0, 0, 19, -1, 0, 0, 20, -1, 0, 0, 21, -1, 0, 0, 22, -1, 0, 0, 23, -1, 0, 0, 24, -1, 0, 0, 25, -1, 0, 0, 26, -1, 0, 0, 27, -1, 0, 0, 28, -1, 0, 0, 29, -1, 0, 0, 30, -1, 0, 0, 31, -1, 0, 0, 32, -1, 0, 0, 33, -1, 0, 0, 34, -1, 0, 0, 35, -1, 0, 0, 36, -1, 0, 0, 37, -1, 0, 0, 38, -1, 0, 0, 39, -1, 0, 0, 40, -1, 0, 0, 41, -1, 0, 0, 42, -1, 0, 0, 43, -1, 0, 0, 44, -1, 0, 0, 45, -1, 0, 0, 46, -1, 0, 0, 47, -1, 0, 0, 48, -1, 0, 0, 49, -1, 0, 0, 50, -1, 0, 0, 51, -1, 0, 0, 52, -1, 0, 0, 53, -1, 0, 0, 54, -1, 0, 0, 55, -1, 0, 0, 56, -1, 0, 0, 57, -1, 0, 0, 58, -1, 0, 0, 59, -1, 0, 1, 0, -1, 0, 1, 1, -1, 0, 1, 2, -1, 0, 1, 3, -1, 0, 1, 4, -1, 0, 1, 5, -1, 0, 1, 6, -1, 0, 1, 7, -1, 0, 1, 8, -1, 0, 1, 9, -1, 0, 1, 10, -1, 0, 1, 11, -1, 0, 1, 12, -1, 0, 1, 13, -1, 0, 1, 14, -1, 0, 1, 15, -1, 0, 1, 16, -1, 0, 1, 17, -1, 0, 1, 18, -1, 0, 1, 19, -1, 0, 1, 20, -1, 0, 1, 21, -1, 0, 1, 22, -1, 0, 1, 23, -1, 0, 1, 24, -1, 0, 1, 25, -1, 0, 1, 26, -1, 0, 1, 27, -1, 0, 1, 28, -1, 0, 1, 29, -1, 0, 1, 30, -1, 0, 1, 31, -1, 0, 1, 32, -1, 0, 1, 33, -1, 0, 1, 34, -1, 0, 1, 35, -1, 0, 1, 36, -1, 0, 1, 37, -1, 0, 1, 38, -1, 0, 1, 39, -1, 0, 1, 40, -1, 0, 1, 41, -1, 0, 1, 42, -1, 0, 1, 43, -1, 0, 1, 44, -1, 0, 1, 45, -1, 0, 1, 46, -1, 0, 1, 47, -1, 0, 1, 48, -1, 0, 1, 49, -1, 0, 1, 50, -1, 0, 1, 51, -1, 0, 1, 52, -1, 0, 1, 53, -1, 0, 1, 54, -1, 0, 1, 55, -1, 0, 1, 56, -1, 0, 1, 57, -1, 0, 1, 58, -1, 0, 1, 59, -1, 0, 2, 0, -1, 0, 2, 1, -1, 0, 2, 2, -1, 0, 2, 3, -1, 0, 2, 4, -1, 0, 2, 5, -1, 0, 2, 6, -1, 0, 2, 7, -1, 0, 2, 8, -1, 0, 2, 9, -1, 0, 2, 10, -1, 0, 2, 11, -1, 0, 2, 12, -1, 0, 2, 13, -1, 0, 2, 14, -1, 0, 2, 15, -1, 0, 2, 16, -1, 0, 2, 17, -1, 0, 2, 18, -1, 0, 2, 19, -1, 0, 2, 20, -1, 0, 2, 21, -1, 0, 2, 22, -1, 0, 2, 23, -1, 0, 2, 24, -1, 0, 2, 25, -1, 0, 2, 26, -1, 0, 2, 27, -1, 0, 2, 28, -1, 0, 2, 29, -1, 0, 2, 30, -1, 0, 2, 31, -1, 0, 2, 32, -1, 0, 2, 33, -1, 0, 2, 34, -1, 0, 2, 35, -1, 0, 2, 36, -1, 0, 2, 37, -1, 0, 2, 38, -1, 0, 2, 39, -1, 0, 2, 40, -1, 0, 2, 41, -1, 0, 2, 42, -1, 0, 2, 43, -1, 0, 2, 44, -1, 0, 2, 45, -1, 0, 2, 46, -1, 0, 2, 47, -1, 0, 2, 48, -1, 0, 2, 49, -1, 0, 2, 50, -1, 0, 2, 51, -1, 0, 2, 52, -1, 0, 2, 53, -1, 0, 2, 54, -1, 0, 2, 55, -1, 0, 2, 56, -1, 0, 2, 57, -1, 0, 2, 58, -1, 0, 2, 59, -1, 0, 3, 0, -1, 0, 3, 1, -1, 0, 3, 2, -1, 0, 3, 3, -1, 0, 3, 4, -1, 0, 3, 5, -1, 0, 3, 6, -1, 0, 3, 7, -1, 0, 3, 8, -1, 0, 3, 9, -1, 0, 3, 10, -1, 0, 3, 11, -1, 0, 3, 12, -1, 0, 3, 13, -1, 0, 3, 14, -1, 0, 3, 15, -1, 0, 3, 16, -1, 0, 3, 17, -1, 0, 3, 18, -1, 0, 3, 19, -1, 0, 3, 20, -1, 0, 3, 21, -1, 0, 3, 22, -1, 0, 3, 23, -1, 0, 3, 24, -1, 0, 3, 25, -1, 0, 3, 26, -1, 0, 3, 27, -1, 0, 3, 28, -1, 0, 3, 29, -1, 0, 3, 30, -1, 0, 3, 31, -1, 0, 3, 32, -1, 0, 3, 33, -1, 0, 3, 34, -1, 0, 3, 35, -1, 0, 3, 36, -1, 0, 3, 37, -1, 0, 3, 38, -1, 0, 3, 39, -1, 0, 3, 40, -1, 0, 3, 41, -1, 0, 3, 42, -1, 0, 3, 43, -1, 0, 3, 44, -1, 0, 3, 45, -1, 0, 3, 46, -1, 0, 3, 47, -1, 0, 3, 48, -1, 0, 3, 49, -1, 0, 3, 50, -1, 0, 3, 51, -1, 0, 3, 52, -1, 0, 3, 53, -1, 0, 3, 54, -1, 0, 3, 55, -1, 0, 3, 56, -1, 0, 3, 57, -1, 0, 3, 58, -1, 0, 3, 59, -1, 0, 4, 0, -1, 0, 4, 1, -1, 0, 4, 2, -1, 0, 4, 3, -1, 0, 4, 4, -1, 0, 4, 5, -1, 0, 4, 6, -1, 0, 4, 7, -1, 0, 4, 8, -1, 0, 4, 9, -1, 0, 4, 10, -1, 0, 4, 11, -1, 0, 4, 12, -1, 0, 4, 13, -1, 0, 4, 14, -1, 0, 4, 15, -1, 0, 4, 16, -1, 0, 4, 17, -1, 0, 4, 18, -1, 0, 4, 19, -1, 0, 4, 20, -1, 0, 4, 21, -1, 0, 4, 22, -1, 0, 4, 23, -1, 0, 4, 24, -1, 0, 4, 25, -1, 0, 4, 26, -1, 0, 4, 27, -1, 0, 4, 28, -1, 0, 4, 29, -1, 0, 4, 30, -1, 0, 4, 31, -1, 0, 4, 32, -1, 0, 4, 33, -1, 0, 4, 34, -1, 0, 4, 35, -1, 0, 4, 36, -1, 0, 4, 37, -1, 0, 4, 38, -1, 0, 4, 39, -1, 0, 4, 40, -1, 0, 4, 41, -1, 0, 4, 42, -1, 0, 4, 43, -1, 0, 4, 44, -1, 0, 4, 45, -1, 0, 4, 46, -1, 0, 4, 47, -1, 0, 4, 48, -1, 0, 4, 49, -1, 0, 4, 50, -1, 0, 4, 51, -1, 0, 4, 52, -1, 0, 4, 53, -1, 0, 4, 54, -1, 0, 4, 55, -1, 0, 4, 56, -1, 0, 4, 57, -1, 0, 4, 58, -1, 0, 4, 59, -1, 0, 5, 0, -1, 0, 5, 1, -1, 0, 5, 2, -1, 0, 5, 3, -1, 0, 5, 4, -1, 0, 5, 5, -1, 0, 5, 6, -1, 0, 5, 7, -1, 0, 5, 8, -1, 0, 5, 9, -1, 0, 5, 10, -1, 0, 5, 11, -1, 0, 5, 12, -1, 0, 5, 13, -1, 0, 5, 14, -1, 0, 5, 15, -1, 0, 5, 16, -1, 0, 5, 17, -1, 0, 5, 18, -1, 0, 5, 19, -1, 0, 5, 20, -1, 0, 5, 21, -1, 0, 5, 22, -1, 0, 5, 23, -1, 0, 5, 24, -1, 0, 5, 25, -1, 0, 5, 26, -1, 0, 5, 27, -1, 0, 5, 28, -1, 0, 5, 29, -1, 0, 5, 30, -1, 0, 5, 31, -1, 0, 5, 32, -1, 0, 5, 33, -1, 0, 5, 34, -1, 0, 5, 35, -1, 0, 5, 36, -1, 0, 5, 37, -1, 0, 5, 38, -1, 0, 5, 39, -1, 0, 5, 40, -1, 0, 5, 41, -1, 0, 5, 42, -1, 0, 5, 43, -1, 0, 5, 44, -1, 0, 5, 45, -1, 0, 5, 46, -1, 0, 5, 47, -1, 0, 5, 48, -1, 0, 5, 49, -1, 0, 5, 50, -1, 0, 5, 51, -1, 0, 5, 52, -1, 0, 5, 53, -1, 0, 5, 54, -1, 0, 5, 55, -1, 0, 5, 56, -1, 0, 5, 57, -1, 0, 5, 58, -1, 0, 5, 59, -1, 0, 6, 0, -1, 0, 6, 1, -1, 0, 6, 2, -1, 0, 6, 3, -1, 0, 6, 4, -1, 0, 6, 5, -1, 0, 6, 6, -1, 0, 6, 7, -1, 0, 6, 8, -1, 0, 6, 9, -1, 0, 6, 10, -1, 0, 6, 11, -1, 0, 6, 12, -1, 0, 6, 13, -1, 0, 6, 14, -1, 0, 6, 15, -1, 0, 6, 16, -1, 0, 6, 17, -1, 0, 6, 18, -1, 0, 6, 19, -1, 0, 6, 20, -1, 0, 6, 21, -1, 0, 6, 22, -1, 0, 6, 23, -1, 0, 6, 24, -1, 0, 6, 25, -1, 0, 6, 26, -1, 0, 6, 27, -1, 0, 6, 28, -1, 0, 6, 29, -1, 0, 6, 30, -1, 0, 6, 31, -1, 0, 6, 32, -1, 0, 6, 33, -1, 0, 6, 34, -1, 0, 6, 35, -1, 0, 6, 36, -1, 0, 6, 37, -1, 0, 6, 38, -1, 0, 6, 39, -1, 0, 6, 40, -1, 0, 6, 41, -1, 0, 6, 42, -1, 0, 6, 43, -1, 0, 6, 44, -1, 0, 6, 45, -1, 0, 6, 46, -1, 0, 6, 47, -1, 0, 6, 48, -1, 0, 6, 49, -1, 0, 6, 50, -1, 0, 6, 51, -1, 0, 6, 52, -1, 0, 6, 53, -1, 0, 6, 54, -1, 0, 6, 55, -1, 0, 6, 56, -1, 0, 6, 57, -1, 0, 6, 58, -1, 0, 6, 59, -1, 0, 7, 0, -1, 0, 7, 1, -1, 0, 7, 2, -1, 0, 7, 3, -1, 0, 7, 4, -1, 0, 7, 5, -1, 0, 7, 6, -1, 0, 7, 7, -1, 0, 7, 8, -1, 0, 7, 9, -1, 0, 7, 10, -1, 0, 7, 11, -1, 0, 7, 12, -1, 0, 7, 13, -1, 0, 7, 14, -1, 0, 7, 15, -1, 0, 7, 16, -1, 0, 7, 17, -1, 0, 7, 18, -1, 0, 7, 19, -1, 0, 7, 20, -1, 0, 7, 21, -1, 0, 7, 22, -1, 0, 7, 23, -1, 0, 7, 24, -1, 0, 7, 25, -1, 0, 7, 26, -1, 0, 7, 27, -1, 0, 7, 28, -1, 0, 7, 29, -1, 0, 7, 30, -1, 0, 7, 31, -1, 0, 7, 32, -1, 0, 7, 33, -1, 0, 7, 34, -1, 0, 7, 35, -1, 0, 7, 36, -1, 0, 7, 37, -1, 0, 7, 38, -1, 0, 7, 39, -1, 0, 7, 40, -1, 0, 7, 41, -1, 0, 7, 42, -1, 0, 7, 43, -1, 0, 7, 44, -1, 0, 7, 45, -1, 0, 7, 46, -1, 0, 7, 47, -1, 0, 7, 48, -1, 0, 7, 49, -1, 0, 7, 50, -1, 0, 7, 51, -1, 0, 7, 52, -1, 0, 7, 53, -1, 0, 7, 54, -1, 0, 7, 55, -1, 0, 7, 56, -1, 0, 7, 57, -1, 0, 7, 58, -1, 0, 7, 59, -1, 0, 8, 0, -1, 0, 8, 1, -1, 0, 8, 2, -1, 0, 8, 3, -1, 0, 8, 4, -1, 0, 8, 5, -1, 0, 8, 6, -1, 0, 8, 7, -1, 0, 8, 8, -1, 0, 8, 9, -1, 0, 8, 10, -1, 0, 8, 11, -1, 0, 8, 12, -1, 0, 8, 13, -1, 0, 8, 14, -1, 0, 8, 15, -1, 0, 8, 16, -1, 0, 8, 17, -1, 0, 8, 18, -1, 0, 8, 19, -1, 0, 8, 20, -1, 0, 8, 21, -1, 0, 8, 22, -1, 0, 8, 23, -1, 0, 8, 24, -1, 0, 8, 25, -1, 0, 8, 26, -1, 0, 8, 27, -1, 0, 8, 28, -1, 0, 8, 29, -1, 0, 8, 30, -1, 0, 8, 31, -1, 0, 8, 32, -1, 0, 8, 33, -1, 0, 8, 34, -1, 0, 8, 35, -1, 0, 8, 36, -1, 0, 8, 37, -1, 0, 8, 38, -1, 0, 8, 39, -1, 0, 8, 40, -1, 0, 8, 41, -1, 0, 8, 42, -1, 0, 8, 43, -1, 0, 8, 44, -1, 0, 8, 45, -1, 0, 8, 46, -1, 0, 8, 47, -1, 0, 8, 48, -1, 0, 8, 49, -1, 0, 8, 50, -1, 0, 8, 51, -1, 0, 8, 52, -1, 0, 8, 53, -1, 0, 8, 54, -1, 0, 8, 55, -1, 0, 8, 56, -1, 0, 8, 57, -1, 0, 8, 58, -1, 0, 8, 59, -1, 0, 9, 0, -1, 0, 9, 1, -1, 0, 9, 2, -1, 0, 9, 3, -1, 0, 9, 4, -1, 0, 9, 5, -1, 0, 9, 6, -1, 0, 9, 7, -1, 0, 9, 8, -1, 0, 9, 9, -1, 0, 9, 10, -1, 0, 9, 11, -1, 0, 9, 12, -1, 0, 9, 13, -1, 0, 9, 14, -1, 0, 9, 15, -1, 0, 9, 16, -1, 0, 9, 17, -1, 0, 9, 18, -1, 0, 9, 19, -1, 0, 9, 20, -1, 0, 9, 21, -1, 0, 9, 22, -1, 0, 9, 23, -1, 0, 9, 24, -1, 0, 9, 25, -1, 0, 9, 26, -1, 0, 9, 27, -1, 0, 9, 28, -1, 0, 9, 29, -1, 0, 9, 30, -1, 0, 9, 31, -1, 0, 9, 32, -1, 0, 9, 33, -1, 0, 9, 34, -1, 0, 9, 35, -1, 0, 9, 36, -1, 0, 9, 37, -1, 0, 9, 38, -1, 0, 9, 39, -1, 0, 9, 40, -1, 0, 9, 41, -1, 0, 9, 42, -1, 0, 9, 43, -1, 0, 9, 44, -1, 0, 9, 45, -1, 0, 9, 46, -1, 0, 9, 47, -1, 0, 9, 48, -1, 0, 9, 49, -1, 0, 9, 50, -1, 0, 9, 51, -1, 0, 9, 52, -1, 0, 9, 53, -1, 0, 9, 54, -1, 0, 9, 55, -1, 0, 9, 56, -1, 0, 9, 57, -1, 0, 9, 58, -1, 0, 9, 59, -1, 0, 10, 0, -1, 0, 10, 1, -1, 0, 10, 2, -1, 0, 10, 3, -1, 0, 10, 4, -1, 0, 10, 5, -1, 0, 10, 6, -1, 0, 10, 7, -1, 0, 10, 8, -1, 0, 10, 9, -1, 0, 10, 10, -1, 0, 10, 11, -1, 0, 10, 12, -1, 0, 10, 13, -1, 0, 10, 14, -1, 0, 10, 15, -1, 0, 10, 16, -1, 0, 10, 17, -1, 0, 10, 18, -1, 0, 10, 19, -1, 0, 10, 20, -1, 0, 10, 21, -1, 0, 10, 22, -1, 0, 10, 23, -1, 0, 10, 24, -1, 0, 10, 25, -1, 0, 10, 26, -1, 0, 10, 27, -1, 0, 10, 28, -1, 0, 10, 29, -1, 0, 10, 30, -1, 0, 10, 31, -1, 0, 10, 32, -1, 0, 10, 33, -1, 0, 10, 34, -1, 0, 10, 35, -1, 0, 10, 36, -1, 0, 10, 37, -1, 0, 10, 38, -1, 0, 10, 39, -1, 0, 10, 40, -1, 0, 10, 41, -1, 0, 10, 42, -1, 0, 10, 43, -1, 0, 10, 44, -1, 0, 10, 45, -1, 0, 10, 46, -1, 0, 10, 47, -1, 0, 10, 48, -1, 0, 10, 49, -1, 0, 10, 50, -1, 0, 10, 51, -1, 0, 10, 52, -1, 0, 10, 53, -1, 0, 10, 54, -1, 0, 10, 55, -1, 0, 10, 56, -1, 0, 10, 57, -1, 0, 10, 58, -1, 0, 10, 59, -1, 0, 11, 0, -1, 0, 11, 1, -1, 0, 11, 2, -1, 0, 11, 3, -1, 0, 11, 4, -1, 0, 11, 5, -1, 0, 11, 6, -1, 0, 11, 7, -1, 0, 11, 8, -1, 0, 11, 9, -1, 0, 11, 10, -1, 0, 11, 11, -1, 0, 11, 12, -1, 0, 11, 13, -1, 0, 11, 14, -1, 0, 11, 15, -1, 0, 11, 16, -1, 0, 11, 17, -1, 0, 11, 18, -1, 0, 11, 19, -1, 0, 11, 20, -1, 0, 11, 21, -1, 0, 11, 22, -1, 0, 11, 23, -1, 0, 11, 24, -1, 0, 11, 25, -1, 0, 11, 26, -1, 0, 11, 27, -1, 0, 11, 28, -1, 0, 11, 29, -1, 0, 11, 30, -1, 0, 11, 31, -1, 0, 11, 32, -1, 0, 11, 33, -1, 0, 11, 34, -1, 0, 11, 35, -1, 0, 11, 36, -1, 0, 11, 37, -1, 0, 11, 38, -1, 0, 11, 39, -1, 0, 11, 40, -1, 0, 11, 41, -1, 0, 11, 42, -1, 0, 11, 43, -1, 0, 11, 44, -1, 0, 11, 45, -1, 0, 11, 46, -1, 0, 11, 47, -1, 0, 11, 48, -1, 0, 11, 49, -1, 0, 11, 50, -1, 0, 11, 51, -1, 0, 11, 52, -1, 0, 11, 53, -1, 0, 11, 54, -1, 0, 11, 55, -1, 0, 11, 56, -1, 0, 11, 57, -1, 0, 11, 58, -1, 0, 11, 59, -1, 0, 12, 0, -1, 0, 12, 1, -1, 0, 12, 2, -1, 0, 12, 3, -1, 0, 12, 4, -1, 0, 12, 5, -1, 0, 12, 6, -1, 0, 12, 7, -1, 0, 12, 8, -1, 0, 12, 9, -1, 0, 12, 10, -1, 0, 12, 11, -1, 0, 12, 12, -1, 0, 12, 13, -1, 0, 12, 14, -1, 0, 12, 15, -1, 0, 12, 16, -1, 0, 12, 17, -1, 0, 12, 18, -1, 0, 12, 19, -1, 0, 12, 20, -1, 0, 12, 21, -1, 0, 12, 22, -1, 0, 12, 23, -1, 0, 12, 24, -1, 0, 12, 25, -1, 0, 12, 26, -1, 0, 12, 27, -1, 0, 12, 28, -1, 0, 12, 29, -1, 0, 12, 30, -1, 0, 12, 31, -1, 0, 12, 32, -1, 0, 12, 33, -1, 0, 12, 34, -1, 0, 12, 35, -1, 0, 12, 36, -1, 0, 12, 37, -1, 0, 12, 38, -1, 0, 12, 39, -1, 0, 12, 40, -1, 0, 12, 41, -1, 0, 12, 42, -1, 0, 12, 43, -1, 0, 12, 44, -1, 0, 12, 45, -1, 0, 12, 46, -1, 0, 12, 47, -1, 0, 12, 48, -1, 0, 12, 49, -1, 0, 12, 50, -1, 0, 12, 51, -1, 0, 12, 52, -1, 0, 12, 53, -1, 0, 12, 54, -1, 0, 12, 55, -1, 0, 12, 56, -1, 0, 12, 57, -1, 0, 12, 58, -1, 0, 12, 59, -1, 0, 13, 0, -1, 0, 13, 1, -1, 0, 13, 2, -1, 0, 13, 3, -1, 0, 13, 4, -1, 0, 13, 5, -1, 0, 13, 6, -1, 0, 13, 7, -1, 0, 13, 8, -1, 0, 13, 9, -1, 0, 13, 10, -1, 0, 13, 11, -1, 0, 13, 12, -1, 0, 13, 13, -1, 0, 13, 14, -1, 0, 13, 15, -1, 0, 13, 16, -1, 0, 13, 17, -1, 0, 13, 18, -1, 0, 13, 19, -1, 0, 13, 20, -1, 0, 13, 21, -1, 0, 13, 22, -1, 0, 13, 23, -1, 0, 13, 24, -1, 0, 13, 25, -1, 0, 13, 26, -1, 0, 13, 27, -1, 0, 13, 28, -1, 0, 13, 29, -1, 0, 13, 30, -1, 0, 13, 31, -1, 0, 13, 32, -1, 0, 13, 33, -1, 0, 13, 34, -1, 0, 13, 35, -1, 0, 13, 36, -1, 0, 13, 37, -1, 0, 13, 38, -1, 0, 13, 39, -1, 0, 13, 40, -1, 0, 13, 41, -1, 0, 13, 42, -1, 0, 13, 43, -1, 0, 13, 44, -1, 0, 13, 45, -1, 0, 13, 46, -1, 0, 13, 47, -1, 0, 13, 48, -1, 0, 13, 49, -1, 0, 13, 50, -1, 0, 13, 51, -1, 0, 13, 52, -1, 0, 13, 53, -1, 0, 13, 54, -1, 0, 13, 55, -1, 0, 13, 56, -1, 0, 13, 57, -1, 0, 13, 58, -1, 0, 13, 59, -1, 0, 14, 0, -1, 0, 14, 1, -1, 0, 14, 2, -1, 0, 14, 3, -1, 0, 14, 4, -1, 0, 14, 5, -1, 0, 14, 6, -1, 0, 14, 7, -1, 0, 14, 8, -1, 0, 14, 9, -1, 0, 14, 10, -1, 0, 14, 11, -1, 0, 14, 12, -1, 0, 14, 13, -1, 0, 14, 14, -1, 0, 14, 15, -1, 0, 14, 16, -1, 0, 14, 17, -1, 0, 14, 18, -1, 0, 14, 19, -1, 0, 14, 20, -1, 0, 14, 21, -1, 0, 14, 22, -1, 0, 14, 23, -1, 0, 14, 24, -1, 0, 14, 25, -1, 0, 14, 26, -1, 0, 14, 27, -1, 0, 14, 28, -1, 0, 14, 29, -1, 0, 14, 30, -1, 0, 14, 31, -1, 0, 14, 32, -1, 0, 14, 33, -1, 0, 14, 34, -1, 0, 14, 35, -1, 0, 14, 36, -1, 0, 14, 37, -1, 0, 14, 38, -1, 0, 14, 39, -1, 0, 14, 40, -1, 0, 14, 41, -1, 0, 14, 42, -1, 0, 14, 43, -1, 0, 14, 44, -1, 0, 14, 45, -1, 0, 14, 46, -1, 0, 14, 47, -1, 0, 14, 48, -1, 0, 14, 49, -1, 0, 14, 50, -1, 0, 14, 51, -1, 0, 14, 52, -1, 0, 14, 53, -1, 0, 14, 54, -1, 0, 14, 55, -1, 0, 14, 56, -1, 0, 14, 57, -1, 0, 14, 58, -1, 0, 14, 59, -1, 0, 15, 0, -1, 0, 15, 1, -1, 0, 15, 2, -1, 0, 15, 3, -1, 0, 15, 4, -1, 0, 15, 5, -1, 0, 15, 6, -1, 0, 15, 7, -1, 0, 15, 8, -1, 0, 15, 9, -1, 0, 15, 10, -1, 0, 15, 11, -1, 0, 15, 12, -1, 0, 15, 13, -1, 0, 15, 14, -1, 0, 15, 15, -1, 0, 15, 16, -1, 0, 15, 17, -1, 0, 15, 18, -1, 0, 15, 19, -1, 0, 15, 20, -1, 0, 15, 21, -1, 0, 15, 22, -1, 0, 15, 23, -1, 0, 15, 24, -1, 0, 15, 25, -1, 0, 15, 26, -1, 0, 15, 27, -1, 0, 15, 28, -1, 0, 15, 29, -1, 0, 15, 30, -1, 0, 15, 31, -1, 0, 15, 32, -1, 0, 15, 33, -1, 0, 15, 34, -1, 0, 15, 35, -1, 0, 15, 36, -1, 0, 15, 37, -1, 0, 15, 38, -1, 0, 15, 39, -1, 0, 15, 40, -1, 0, 15, 41, -1, 0, 15, 42, -1, 0, 15, 43, -1, 0, 15, 44, -1, 0, 15, 45, -1, 0, 15, 46, -1, 0, 15, 47, -1, 0, 15, 48, -1, 0, 15, 49, -1, 0, 15, 50, -1, 0, 15, 51, -1, 0, 15, 52, -1, 0, 15, 53, -1, 0, 15, 54, -1, 0, 15, 55, -1, 0, 15, 56, -1, 0, 15, 57, -1, 0, 15, 58, -1, 0, 15, 59, -1, 0, 16, 0, -1, 0, 16, 1, -1, 0, 16, 2, -1, 0, 16, 3, -1, 0, 16, 4, -1, 0, 16, 5, -1, 0, 16, 6, -1, 0, 16, 7, -1, 0, 16, 8, -1, 0, 16, 9, -1, 0, 16, 10, -1, 0, 16, 11, -1, 0, 16, 12, -1, 0, 16, 13, -1, 0, 16, 14, -1, 0, 16, 15, -1, 0, 16, 16, -1, 0, 16, 17, -1, 0, 16, 18, -1, 0, 16, 19, -1, 0, 16, 20, -1, 0, 16, 21, -1, 0, 16, 22, -1, 0, 16, 23, -1, 0, 16, 24, -1, 0, 16, 25, -1, 0, 16, 26, -1, 0, 16, 27, -1, 0, 16, 28, -1, 0, 16, 29, -1, 0, 16, 30, -1, 0, 16, 31, -1, 0, 16, 32, -1, 0, 16, 33, -1, 0, 16, 34, -1, 0, 16, 35, -1, 0, 16, 36, -1, 0, 16, 37, -1, 0, 16, 38, -1, 0, 16, 39, -1, 0, 16, 40, -1, 0, 16, 41, -1, 0, 16, 42, -1, 0, 16, 43, -1, 0, 16, 44, -1, 0, 16, 45, -1, 0, 16, 46, -1, 0, 16, 47, -1, 0, 16, 48, -1, 0, 16, 49, -1, 0, 16, 50, -1, 0, 16, 51, -1, 0, 16, 52, -1, 0, 16, 53, -1, 0, 16, 54, -1, 0, 16, 55, -1, 0, 16, 56, -1, 0, 16, 57, -1, 0, 16, 58, -1, 0, 16, 59, -1, 0, 17, 0, -1, 0, 17, 1, -1, 0, 17, 2, -1, 0, 17, 3, -1, 0, 17, 4, -1, 0, 17, 5, -1, 0, 17, 6, -1, 0, 17, 7, -1, 0, 17, 8, -1, 0, 17, 9, -1, 0, 17, 10, -1, 0, 17, 11, -1, 0, 17, 12, -1, 0, 17, 13, -1, 0, 17, 14, -1, 0, 17, 15, -1, 0, 17, 16, -1, 0, 17, 17, -1, 0, 17, 18, -1, 0, 17, 19, -1, 0, 17, 20, -1, 0, 17, 21, -1, 0, 17, 22, -1, 0, 17, 23, -1, 0, 17, 24, -1, 0, 17, 25, -1, 0, 17, 26, -1, 0, 17, 27, -1, 0, 17, 28, -1, 0, 17, 29, -1, 0, 17, 30, -1, 0, 17, 31, -1, 0, 17, 32, -1, 0, 17, 33, -1, 0, 17, 34, -1, 0, 17, 35, -1, 0, 17, 36, -1, 0, 17, 37, -1, 0, 17, 38, -1, 0, 17, 39, -1, 0, 17, 40, -1, 0, 17, 41, -1, 0, 17, 42, -1, 0, 17, 43, -1, 0, 17, 44, -1, 0, 17, 45, -1, 0, 17, 46, -1, 0, 17, 47, -1, 0, 17, 48, -1, 0, 17, 49, -1, 0, 17, 50, -1, 0, 17, 51, -1, 0, 17, 52, -1, 0, 17, 53, -1, 0, 17, 54, -1, 0, 17, 55, -1, 0, 17, 56, -1, 0, 17, 57, -1, 0, 17, 58, -1, 0, 17, 59, -1, 0, 18, 0, -1, 0, 18, 1, -1, 0, 18, 2, -1, 0, 18, 3, -1, 0, 18, 4, -1, 0, 18, 5, -1, 0, 18, 6, -1, 0, 18, 7, -1, 0, 18, 8, -1, 0, 18, 9, -1, 0, 18, 10, -1, 0, 18, 11, -1, 0, 18, 12, -1, 0, 18, 13, -1, 0, 18, 14, -1, 0, 18, 15, -1, 0, 18, 16, -1, 0, 18, 17, -1, 0, 18, 18, -1, 0, 18, 19, -1, 0, 18, 20, -1, 0, 18, 21, -1, 0, 18, 22, -1, 0, 18, 23, -1, 0, 18, 24, -1, 0, 18, 25, -1, 0, 18, 26, -1, 0, 18, 27, -1, 0, 18, 28, -1, 0, 18, 29, -1, 0, 18, 30, -1, 0, 18, 31, -1, 0, 18, 32, -1, 0, 18, 33, -1, 0, 18, 34, -1, 0, 18, 35, -1, 0, 18, 36, -1, 0, 18, 37, -1, 0, 18, 38, -1, 0, 18, 39, -1, 0, 18, 40, -1, 0, 18, 41, -1, 0, 18, 42, -1, 0, 18, 43, -1, 0, 18, 44, -1, 0, 18, 45, -1, 0, 18, 46, -1, 0, 18, 47, -1, 0, 18, 48, -1, 0, 18, 49, -1, 0, 18, 50, -1, 0, 18, 51, -1, 0, 18, 52, -1, 0, 18, 53, -1, 0, 18, 54, -1, 0, 18, 55, -1, 0, 18, 56, -1, 0, 18, 57, -1, 0, 18, 58, -1, 0, 18, 59, -1, 0, 19, 0, -1, 0, 19, 1, -1, 0, 19, 2, -1, 0, 19, 3, -1, 0, 19, 4, -1, 0, 19, 5, -1, 0, 19, 6, -1, 0, 19, 7, -1, 0, 19, 8, -1, 0, 19, 9, -1, 0, 19, 10, -1, 0, 19, 11, -1, 0, 19, 12, -1, 0, 19, 13, -1, 0, 19, 14, -1, 0, 19, 15, -1, 0, 19, 16, -1, 0, 19, 17, -1, 0, 19, 18, -1, 0, 19, 19, -1, 0, 19, 20, -1, 0, 19, 21, -1, 0, 19, 22, -1, 0, 19, 23, -1, 0, 19, 24, -1, 0, 19, 25, -1, 0, 19, 26, -1, 0, 19, 27, -1, 0, 19, 28, -1, 0, 19, 29, -1, 0, 19, 30, -1, 0, 19, 31, -1, 0, 19, 32, -1, 0, 19, 33, -1, 0, 19, 34, -1, 0, 19, 35, -1, 0, 19, 36, -1, 0, 19, 37, -1, 0, 19, 38, -1, 0, 19, 39, -1, 0, 19, 40, -1, 0, 19, 41, -1, 0, 19, 42, -1, 0, 19, 43, -1, 0, 19, 44, -1, 0, 19, 45, -1, 0, 19, 46, -1, 0, 19, 47, -1, 0, 19, 48, -1, 0, 19, 49, -1, 0, 19, 50, -1, 0, 19, 51, -1, 0, 19, 52, -1, 0, 19, 53, -1, 0, 19, 54, -1, 0, 19, 55, -1, 0, 19, 56, -1, 0, 19, 57, -1, 0, 19, 58, -1, 0, 19, 59, -1, 0, 20, 0, -1, 0, 20, 1, -1, 0, 20, 2, 768, 0, 20, 3, 769, 0, 20, 4, 770, 0, 20, 5, 770, 0, 20, 6, 770, 0, 20, 7, 770, 0, 20, 8, 772, 0, 20, 9, 773, 0, 20, 10, -1, 0, 20, 11, -1, 0, 20, 12, -1, 0, 20, 13, -1, 0, 20, 14, -1, 0, 20, 15, -1, 0, 20, 16, -1, 0, 20, 17, -1, 0, 20, 18, -1, 0, 20, 19, -1, 0, 20, 20, -1, 0, 20, 21, -1, 0, 20, 22, -1, 0, 20, 23, -1, 0, 20, 24, -1, 0, 20, 25, -1, 0, 20, 26, -1, 0, 20, 27, -1, 0, 20, 28, -1, 0, 20, 29, -1, 0, 20, 30, -1, 0, 20, 31, -1, 0, 20, 32, -1, 0, 20, 33, -1, 0, 20, 35, 881, 0, 20, 36, 882, 0, 20, 37, 883, 0, 20, 38, 882, 0, 20, 39, 883, 0, 20, 40, 882, 0, 20, 41, 883, 0, 20, 42, 882, 0, 20, 43, 883, 0, 20, 44, 882, 0, 20, 45, 883, 0, 20, 46, 882, 0, 20, 47, 883, 0, 20, 48, 884, 0, 20, 50, -1, 0, 20, 51, -1, 0, 20, 52, -1, 0, 20, 53, -1, 0, 20, 54, -1, 0, 20, 55, -1, 0, 20, 56, -1, 0, 20, 57, -1, 0, 20, 58, -1, 0, 20, 59, -1, 0, 21, 0, -1, 0, 21, 1, -1, 0, 21, 2, 784, 0, 21, 3, 785, 0, 21, 4, 787, 0, 21, 5, 786, 0, 21, 6, 787, 0, 21, 7, 786, 0, 21, 8, 788, 0, 21, 9, 789, 0, 21, 10, -1, 0, 21, 11, -1, 0, 21, 12, -1, 0, 21, 13, -1, 0, 21, 14, -1, 0, 21, 15, -1, 0, 21, 16, -1, 0, 21, 17, -1, 0, 21, 18, -1, 0, 21, 19, -1, 0, 21, 20, -1, 0, 21, 21, -1, 0, 21, 22, -1, 0, 21, 23, -1, 0, 21, 24, -1, 0, 21, 25, -1, 0, 21, 26, -1, 0, 21, 27, -1, 0, 21, 28, -1, 0, 21, 29, -1, 0, 21, 30, -1, 0, 21, 31, -1, 0, 21, 32, -1, 0, 21, 33, -1, 0, 21, 35, 897, 0, 21, 36, 898, 0, 21, 37, 899, 0, 21, 38, 898, 0, 21, 39, 899, 0, 21, 40, 898, 0, 21, 41, 899, 0, 21, 42, 898, 0, 21, 43, 899, 0, 21, 44, 898, 0, 21, 45, 899, 0, 21, 46, 898, 0, 21, 47, 899, 0, 21, 48, 900, 0, 21, 50, -1, 0, 21, 51, -1, 0, 21, 52, -1, 0, 21, 53, -1, 0, 21, 54, -1, 0, 21, 55, -1, 0, 21, 56, -1, 0, 21, 57, -1, 0, 21, 58, -1, 0, 21, 59, -1, 0, 22, 0, -1, 0, 22, 1, -1, 0, 22, 2, 816, 0, 22, 3, 801, 0, 22, 4, 802, 0, 22, 5, 803, 0, 22, 6, 803, 0, 22, 7, 803, 0, 22, 8, 804, 0, 22, 9, 837, 0, 22, 10, -1, 0, 22, 11, -1, 0, 22, 12, -1, 0, 22, 13, -1, 0, 22, 14, -1, 0, 22, 15, -1, 0, 22, 16, -1, 0, 22, 17, -1, 0, 22, 18, -1, 0, 22, 19, -1, 0, 22, 20, -1, 0, 22, 21, -1, 0, 22, 22, -1, 0, 22, 23, -1, 0, 22, 24, -1, 0, 22, 25, -1, 0, 22, 26, -1, 0, 22, 27, -1, 0, 22, 28, -1, 0, 22, 29, -1, 0, 22, 30, -1, 0, 22, 31, -1, 0, 22, 32, -1, 0, 22, 33, -1, 0, 22, 35, 913, 0, 22, 36, 914, 0, 22, 37, 915, 0, 22, 38, 914, 0, 22, 39, 915, 0, 22, 40, 914, 0, 22, 41, 915, 0, 22, 42, 914, 0, 22, 43, 915, 0, 22, 44, 914, 0, 22, 45, 915, 0, 22, 46, 914, 0, 22, 47, 915, 0, 22, 48, 916, 0, 22, 50, -1, 0, 22, 51, -1, 0, 22, 52, -1, 0, 22, 53, -1, 0, 22, 54, -1, 0, 22, 55, -1, 0, 22, 56, -1, 0, 22, 57, -1, 0, 22, 58, -1, 0, 22, 59, -1, 0, 23, 0, -1, 0, 23, 1, -1, 0, 23, 2, 832, 0, 23, 3, 834, 0, 23, 4, 819, 0, 23, 5, 818, 0, 23, 6, 835, 0, 23, 7, 850, 0, 23, 8, 851, 0, 23, 9, 821, 0, 23, 10, -1, 0, 23, 11, -1, 0, 23, 12, -1, 0, 23, 13, -1, 0, 23, 14, -1, 0, 23, 15, -1, 0, 23, 16, -1, 0, 23, 17, -1, 0, 23, 18, -1, 0, 23, 19, -1, 0, 23, 20, -1, 0, 23, 21, -1, 0, 23, 22, -1, 0, 23, 23, -1, 0, 23, 24, -1, 0, 23, 25, -1, 0, 23, 26, -1, 0, 23, 27, -1, 0, 23, 28, -1, 0, 23, 29, -1, 0, 23, 30, -1, 0, 23, 31, -1, 0, 23, 32, -1, 0, 23, 33, -1, 0, 23, 35, 818, 0, 23, 36, 819, 0, 23, 37, 835, 0, 23, 38, 851, 0, 23, 39, 818, 0, 23, 40, 850, 0, 23, 41, 818, 0, 23, 42, 834, 0, 23, 43, 818, 0, 23, 44, 851, 0, 23, 45, 851, 0, 23, 46, 818, 0, 23, 47, 835, 0, 23, 48, 818, 0, 23, 50, -1, 0, 23, 51, -1, 0, 23, 52, -1, 0, 23, 53, -1, 0, 23, 54, -1, 0, 23, 55, -1, 0, 23, 56, -1, 0, 23, 57, -1, 0, 23, 58, -1, 0, 23, 59, -1, 0, 24, 0, -1, 0, 24, 1, -1, 0, 24, 2, 832, 0, 24, 3, 818, 0, 24, 4, 834, 0, 24, 5, 851, 0, 24, 6, 835, 0, 24, 7, 819, 0, 24, 8, 834, 0, 24, 9, 821, 0, 24, 10, -1, 0, 24, 11, -1, 0, 24, 12, -1, 0, 24, 13, -1, 0, 24, 14, -1, 0, 24, 15, -1, 0, 24, 16, -1, 0, 24, 17, -1, 0, 24, 18, -1, 0, 24, 19, -1, 0, 24, 20, -1, 0, 24, 21, -1, 0, 24, 22, -1, 0, 24, 23, -1, 0, 24, 24, -1, 0, 24, 25, -1, 0, 24, 26, -1, 0, 24, 27, -1, 0, 24, 28, -1, 0, 24, 29, -1, 0, 24, 30, -1, 0, 24, 31, -1, 0, 24, 32, -1, 0, 24, 33, -1, 0, 24, 34, -1, 0, 24, 35, 819, 0, 24, 36, 819, 0, 24, 37, 819, 0, 24, 38, 819, 0, 24, 39, 819, 0, 24, 40, 819, 0, 24, 41, 850, 0, 24, 42, 818, 0, 24, 43, 819, 0, 24, 44, 818, 0, 24, 45, 818, 0, 24, 46, 819, 0, 24, 47, 818, 0, 24, 48, 818, 0, 24, 50, -1, 0, 24, 51, -1, 0, 24, 52, -1, 0, 24, 53, -1, 0, 24, 54, -1, 0, 24, 55, -1, 0, 24, 56, -1, 0, 24, 57, -1, 0, 24, 58, -1, 0, 24, 59, -1, 0, 25, 0, -1, 0, 25, 1, -1, 0, 25, 2, 816, 0, 25, 3, 818, 0, 25, 4, 819, 0, 25, 5, 851, 0, 25, 6, 851, 0, 25, 7, 819, 0, 25, 8, 834, 0, 25, 9, 837, 0, 25, 10, -1, 0, 25, 11, -1, 0, 25, 12, -1, 0, 25, 13, -1, 0, 25, 14, -1, 0, 25, 15, -1, 0, 25, 16, -1, 0, 25, 17, -1, 0, 25, 18, -1, 0, 25, 19, -1, 0, 25, 20, -1, 0, 25, 21, -1, 0, 25, 22, -1, 0, 25, 23, -1, 0, 25, 24, -1, 0, 25, 25, -1, 0, 25, 26, -1, 0, 25, 27, -1, 0, 25, 28, -1, 0, 25, 29, -1, 0, 25, 30, -1, 0, 25, 31, -1, 0, 25, 32, -1, 0, 25, 33, -1, 0, 25, 41, 835, 0, 25, 42, 818, 0, 25, 43, 818, 0, 25, 44, 834, 0, 25, 45, 818, 0, 25, 46, 835, 0, 25, 47, 818, 0, 25, 48, 850, 0, 25, 50, -1, 0, 25, 51, -1, 0, 25, 52, -1, 0, 25, 53, -1, 0, 25, 54, -1, 0, 25, 55, -1, 0, 25, 56, -1, 0, 25, 57, -1, 0, 25, 58, -1, 0, 25, 59, -1, 0, 26, 0, -1, 0, 26, 1, -1, 0, 26, 2, 816, 0, 26, 3, 851, 0, 26, 4, 835, 0, 26, 5, 819, 0, 26, 6, 834, 0, 26, 7, 819, 0, 26, 8, 818, 0, 26, 9, 837, 0, 26, 10, -1, 0, 26, 11, -1, 0, 26, 12, -1, 0, 26, 13, -1, 0, 26, 14, -1, 0, 26, 15, -1, 0, 26, 16, -1, 0, 26, 17, -1, 0, 26, 18, -1, 0, 26, 19, -1, 0, 26, 20, -1, 0, 26, 21, -1, 0, 26, 22, -1, 0, 26, 23, -1, 0, 26, 24, -1, 0, 26, 25, -1, 0, 26, 26, -1, 0, 26, 27, -1, 0, 26, 28, -1, 0, 26, 29, -1, 0, 26, 30, -1, 0, 26, 31, -1, 0, 26, 32, -1, 0, 26, 33, -1, 0, 26, 34, -1, 0, 26, 35, -1, 0, 26, 36, -1, 0, 26, 37, -1, 0, 26, 38, -1, 0, 26, 39, -1, 0, 26, 41, 818, 0, 26, 42, 819, 0, 26, 43, 818, 0, 26, 44, 818, 0, 26, 45, 819, 0, 26, 46, 818, 0, 26, 47, 818, 0, 26, 48, 818, 0, 26, 50, -1, 0, 26, 51, -1, 0, 26, 52, -1, 0, 26, 53, -1, 0, 26, 54, -1, 0, 26, 55, -1, 0, 26, 56, -1, 0, 26, 57, -1, 0, 26, 58, -1, 0, 26, 59, -1, 0, 27, 0, -1, 0, 27, 1, -1, 0, 27, 2, -1, 0, 27, 3, 851, 0, 27, 4, 818, 0, 27, 5, 819, 0, 27, 6, 850, 0, 27, 7, 851, 0, 27, 8, -1, 0, 27, 9, 853, 0, 27, 10, -1, 0, 27, 11, -1, 0, 27, 12, -1, 0, 27, 13, -1, 0, 27, 14, -1, 0, 27, 15, -1, 0, 27, 16, -1, 0, 27, 17, -1, 0, 27, 18, -1, 0, 27, 19, -1, 0, 27, 20, -1, 0, 27, 21, -1, 0, 27, 22, -1, 0, 27, 23, -1, 0, 27, 24, -1, 0, 27, 25, -1, 0, 27, 26, -1, 0, 27, 27, -1, 0, 27, 28, -1, 0, 27, 29, -1, 0, 27, 30, -1, 0, 27, 31, -1, 0, 27, 32, -1, 0, 27, 33, -1, 0, 27, 34, -1, 0, 27, 35, -1, 0, 27, 36, -1, 0, 27, 37, -1, 0, 27, 38, -1, 0, 27, 39, -1, 0, 27, 41, 818, 0, 27, 42, 834, 0, 27, 43, 818, 0, 27, 44, 850, 0, 27, 45, 818, 0, 27, 46, 834, 0, 27, 47, 818, 0, 27, 48, 818, 0, 27, 50, -1, 0, 27, 51, -1, 0, 27, 52, -1, 0, 27, 53, -1, 0, 27, 54, -1, 0, 27, 55, -1, 0, 27, 56, -1, 0, 27, 57, -1, 0, 27, 58, -1, 0, 27, 59, -1, 0, 28, 0, -1, 0, 28, 1, -1, 0, 28, 2, -1, 0, 28, 3, -1, 0, 28, 4, 835, 0, 28, 5, -1, 0, 28, 6, -1, 0, 28, 7, 835, 0, 28, 8, -1, 0, 28, 9, -1, 0, 28, 10, -1, 0, 28, 11, -1, 0, 28, 12, -1, 0, 28, 13, -1, 0, 28, 14, -1, 0, 28, 15, -1, 0, 28, 16, -1, 0, 28, 17, -1, 0, 28, 18, -1, 0, 28, 19, -1, 0, 28, 20, -1, 0, 28, 21, -1, 0, 28, 22, -1, 0, 28, 23, -1, 0, 28, 24, -1, 0, 28, 25, -1, 0, 28, 26, -1, 0, 28, 27, -1, 0, 28, 28, -1, 0, 28, 29, -1, 0, 28, 30, -1, 0, 28, 31, -1, 0, 28, 32, -1, 0, 28, 33, -1, 0, 28, 34, -1, 0, 28, 35, -1, 0, 28, 36, -1, 0, 28, 37, -1, 0, 28, 38, -1, 0, 28, 39, -1, 0, 28, 41, 818, 0, 28, 42, 819, 0, 28, 43, 818, 0, 28, 44, 818, 0, 28, 45, 818, 0, 28, 46, 818, 0, 28, 47, 818, 0, 28, 48, 818, 0, 28, 50, -1, 0, 28, 51, -1, 0, 28, 52, -1, 0, 28, 53, -1, 0, 28, 54, -1, 0, 28, 55, -1, 0, 28, 56, -1, 0, 28, 57, -1, 0, 28, 58, -1, 0, 28, 59, -1, 0, 29, 0, -1, 0, 29, 1, -1, 0, 29, 2, -1, 0, 29, 3, -1, 0, 29, 4, 867, 0, 29, 5, -1, 0, 29, 6, -1, 0, 29, 7, 867, 0, 29, 8, -1, 0, 29, 9, -1, 0, 29, 10, -1, 0, 29, 11, -1, 0, 29, 12, -1, 0, 29, 13, -1, 0, 29, 14, -1, 0, 29, 15, -1, 0, 29, 16, -1, 0, 29, 17, -1, 0, 29, 18, -1, 0, 29, 19, -1, 0, 29, 20, -1, 0, 29, 21, -1, 0, 29, 22, -1, 0, 29, 23, -1, 0, 29, 24, -1, 0, 29, 25, -1, 0, 29, 26, -1, 0, 29, 27, -1, 0, 29, 28, -1, 0, 29, 29, -1, 0, 29, 30, -1, 0, 29, 31, -1, 0, 29, 32, -1, 0, 29, 33, -1, 0, 29, 34, -1, 0, 29, 35, -1, 0, 29, 36, -1, 0, 29, 37, -1, 0, 29, 38, -1, 0, 29, 39, -1, 0, 29, 41, 819, 0, 29, 42, 851, 0, 29, 43, 835, 0, 29, 44, 818, 0, 29, 45, 818, 0, 29, 46, 818, 0, 29, 47, 819, 0, 29, 48, 818, 0, 29, 50, -1, 0, 29, 51, -1, 0, 29, 52, -1, 0, 29, 53, -1, 0, 29, 54, -1, 0, 29, 55, -1, 0, 29, 56, -1, 0, 29, 57, -1, 0, 29, 58, -1, 0, 29, 59, -1, 0, 30, 0, -1, 0, 30, 1, -1, 0, 30, 2, -1, 0, 30, 3, -1, 0, 30, 4, -1, 0, 30, 7, -1, 0, 30, 8, -1, 0, 30, 9, -1, 0, 30, 10, -1, 0, 30, 11, -1, 0, 30, 12, -1, 0, 30, 13, -1, 0, 30, 14, -1, 0, 30, 15, -1, 0, 30, 16, -1, 0, 30, 17, -1, 0, 30, 18, -1, 0, 30, 19, -1, 0, 30, 20, -1, 0, 30, 21, -1, 0, 30, 22, -1, 0, 30, 23, -1, 0, 30, 24, -1, 0, 30, 25, -1, 0, 30, 26, -1, 0, 30, 27, -1, 0, 30, 28, -1, 0, 30, 29, -1, 0, 30, 30, -1, 0, 30, 31, -1, 0, 30, 32, -1, 0, 30, 33, -1, 0, 30, 34, -1, 0, 30, 35, -1, 0, 30, 36, -1, 0, 30, 37, -1, 0, 30, 38, -1, 0, 30, 39, -1, 0, 30, 46, 850, 0, 30, 47, 818, 0, 30, 50, -1, 0, 30, 51, -1, 0, 30, 52, -1, 0, 30, 53, -1, 0, 30, 54, -1, 0, 30, 55, -1, 0, 30, 56, -1, 0, 30, 57, -1, 0, 30, 58, -1, 0, 30, 59, -1, 0, 31, 0, -1, 0, 31, 1, -1, 0, 31, 2, -1, 0, 31, 3, -1, 0, 31, 4, -1, 0, 31, 5, -1, 0, 31, 6, -1, 0, 31, 7, -1, 0, 31, 8, -1, 0, 31, 9, -1, 0, 31, 10, -1, 0, 31, 11, -1, 0, 31, 12, -1, 0, 31, 13, -1, 0, 31, 14, -1, 0, 31, 15, -1, 0, 31, 16, -1, 0, 31, 17, -1, 0, 31, 18, -1, 0, 31, 19, -1, 0, 31, 20, -1, 0, 31, 21, -1, 0, 31, 22, -1, 0, 31, 23, -1, 0, 31, 24, -1, 0, 31, 25, -1, 0, 31, 26, -1, 0, 31, 27, -1, 0, 31, 28, -1, 0, 31, 29, -1, 0, 31, 30, -1, 0, 31, 31, -1, 0, 31, 32, -1, 0, 31, 33, -1, 0, 31, 34, -1, 0, 31, 35, -1, 0, 31, 36, -1, 0, 31, 37, -1, 0, 31, 38, -1, 0, 31, 39, -1, 0, 31, 40, -1, 0, 31, 41, -1, 0, 31, 42, -1, 0, 31, 43, -1, 0, 31, 44, -1, 0, 31, 46, 818, 0, 31, 47, 834, 0, 31, 49, -1, 0, 31, 50, -1, 0, 31, 51, -1, 0, 31, 52, -1, 0, 31, 53, -1, 0, 31, 54, -1, 0, 31, 55, -1, 0, 31, 56, -1, 0, 31, 57, -1, 0, 31, 58, -1, 0, 31, 59, -1, 0, 32, 0, -1, 0, 32, 1, -1, 0, 32, 2, -1, 0, 32, 3, -1, 0, 32, 4, -1, 0, 32, 5, -1, 0, 32, 6, -1, 0, 32, 7, -1, 0, 32, 8, -1, 0, 32, 9, -1, 0, 32, 10, -1, 0, 32, 11, -1, 0, 32, 12, -1, 0, 32, 13, -1, 0, 32, 14, -1, 0, 32, 15, -1, 0, 32, 16, -1, 0, 32, 17, -1, 0, 32, 18, -1, 0, 32, 19, -1, 0, 32, 20, -1, 0, 32, 21, -1, 0, 32, 22, -1, 0, 32, 23, -1, 0, 32, 24, -1, 0, 32, 25, -1, 0, 32, 26, -1, 0, 32, 27, -1, 0, 32, 28, -1, 0, 32, 29, -1, 0, 32, 30, -1, 0, 32, 31, -1, 0, 32, 32, -1, 0, 32, 33, -1, 0, 32, 34, -1, 0, 32, 35, -1, 0, 32, 36, -1, 0, 32, 37, -1, 0, 32, 38, -1, 0, 32, 39, -1, 0, 32, 40, -1, 0, 32, 41, -1, 0, 32, 42, -1, 0, 32, 43, -1, 0, 32, 44, -1, 0, 32, 45, -1, 0, 32, 46, 818, 0, 32, 47, 819, 0, 32, 48, -1, 0, 32, 49, -1, 0, 32, 50, -1, 0, 32, 51, -1, 0, 32, 52, -1, 0, 32, 53, -1, 0, 32, 54, -1, 0, 32, 55, -1, 0, 32, 56, -1, 0, 32, 57, -1, 0, 32, 58, -1, 0, 32, 59, -1, 0, 33, 0, -1, 0, 33, 1, -1, 0, 33, 2, -1, 0, 33, 3, -1, 0, 33, 4, -1, 0, 33, 5, -1, 0, 33, 6, -1, 0, 33, 7, -1, 0, 33, 8, -1, 0, 33, 9, -1, 0, 33, 10, -1, 0, 33, 11, -1, 0, 33, 12, -1, 0, 33, 13, -1, 0, 33, 14, -1, 0, 33, 15, -1, 0, 33, 16, -1, 0, 33, 17, -1, 0, 33, 18, -1, 0, 33, 19, -1, 0, 33, 20, -1, 0, 33, 21, -1, 0, 33, 22, -1, 0, 33, 23, -1, 0, 33, 24, -1, 0, 33, 25, -1, 0, 33, 26, -1, 0, 33, 27, -1, 0, 33, 28, -1, 0, 33, 29, -1, 0, 33, 30, -1, 0, 33, 31, -1, 0, 33, 32, -1, 0, 33, 33, -1, 0, 33, 34, -1, 0, 33, 35, -1, 0, 33, 36, -1, 0, 33, 37, -1, 0, 33, 38, -1, 0, 33, 39, -1, 0, 33, 40, -1, 0, 33, 41, -1, 0, 33, 42, -1, 0, 33, 43, -1, 0, 33, 44, -1, 0, 33, 45, -1, 0, 33, 46, -1, 0, 33, 47, -1, 0, 33, 48, -1, 0, 33, 49, -1, 0, 33, 50, -1, 0, 33, 51, -1, 0, 33, 52, -1, 0, 33, 53, -1, 0, 33, 54, -1, 0, 33, 55, -1, 0, 33, 56, -1, 0, 33, 57, -1, 0, 33, 58, -1, 0, 33, 59, -1, 0, 34, 0, -1, 0, 34, 1, -1, 0, 34, 2, -1, 0, 34, 3, -1, 0, 34, 4, -1, 0, 34, 5, -1, 0, 34, 6, -1, 0, 34, 7, -1, 0, 34, 8, -1, 0, 34, 9, -1, 0, 34, 10, -1, 0, 34, 11, -1, 0, 34, 12, -1, 0, 34, 13, -1, 0, 34, 14, -1, 0, 34, 15, -1, 0, 34, 16, -1, 0, 34, 17, -1, 0, 34, 18, -1, 0, 34, 19, -1, 0, 34, 20, -1, 0, 34, 21, -1, 0, 34, 22, -1, 0, 34, 23, -1, 0, 34, 24, -1, 0, 34, 25, -1, 0, 34, 26, -1, 0, 34, 27, -1, 0, 34, 28, -1, 0, 34, 29, -1, 0, 34, 30, -1, 0, 34, 31, -1, 0, 34, 32, -1, 0, 34, 33, -1, 0, 34, 34, -1, 0, 34, 35, -1, 0, 34, 36, -1, 0, 34, 37, -1, 0, 34, 38, -1, 0, 34, 39, -1, 0, 34, 40, -1, 0, 34, 41, -1, 0, 34, 42, -1, 0, 34, 43, -1, 0, 34, 44, -1, 0, 34, 45, -1, 0, 34, 46, -1, 0, 34, 47, -1, 0, 34, 48, -1, 0, 34, 49, -1, 0, 34, 50, -1, 0, 34, 51, -1, 0, 34, 52, -1, 0, 34, 53, -1, 0, 34, 54, -1, 0, 34, 55, -1, 0, 34, 56, -1, 0, 34, 57, -1, 0, 34, 58, -1, 0, 34, 59, -1, 0, 35, 0, -1, 0, 35, 1, -1, 0, 35, 2, -1, 0, 35, 3, -1, 0, 35, 4, -1, 0, 35, 5, -1, 0, 35, 6, -1, 0, 35, 7, -1, 0, 35, 8, -1, 0, 35, 9, -1, 0, 35, 10, -1, 0, 35, 11, -1, 0, 35, 12, -1, 0, 35, 13, -1, 0, 35, 14, -1, 0, 35, 15, -1, 0, 35, 16, -1, 0, 35, 17, -1, 0, 35, 18, -1, 0, 35, 19, -1, 0, 35, 20, -1, 0, 35, 21, -1, 0, 35, 22, -1, 0, 35, 23, -1, 0, 35, 24, -1, 0, 35, 25, -1, 0, 35, 26, -1, 0, 35, 27, -1, 0, 35, 28, -1, 0, 35, 29, -1, 0, 35, 30, -1, 0, 35, 31, -1, 0, 35, 32, -1, 0, 35, 33, -1, 0, 35, 34, -1, 0, 35, 35, -1, 0, 35, 36, -1, 0, 35, 37, -1, 0, 35, 38, -1, 0, 35, 39, -1, 0, 35, 40, -1, 0, 35, 41, -1, 0, 35, 42, -1, 0, 35, 43, -1, 0, 35, 44, -1, 0, 35, 49, -1, 0, 35, 50, -1, 0, 35, 51, -1, 0, 35, 52, -1, 0, 35, 53, -1, 0, 35, 54, -1, 0, 35, 55, -1, 0, 35, 56, -1, 0, 35, 57, -1, 0, 35, 58, -1, 0, 35, 59, -1, 0, 36, 0, -1, 0, 36, 1, -1, 0, 36, 2, -1, 0, 36, 3, -1, 0, 36, 4, -1, 0, 36, 5, -1, 0, 36, 6, -1, 0, 36, 7, -1, 0, 36, 8, -1, 0, 36, 9, -1, 0, 36, 10, -1, 0, 36, 11, -1, 0, 36, 12, -1, 0, 36, 13, -1, 0, 36, 14, -1, 0, 36, 15, -1, 0, 36, 16, -1, 0, 36, 17, -1, 0, 36, 18, -1, 0, 36, 19, -1, 0, 36, 20, -1, 0, 36, 21, -1, 0, 36, 22, -1, 0, 36, 23, -1, 0, 36, 24, -1, 0, 36, 25, -1, 0, 36, 26, -1, 0, 36, 27, -1, 0, 36, 28, -1, 0, 36, 29, -1, 0, 36, 30, -1, 0, 36, 31, -1, 0, 36, 32, -1, 0, 36, 33, -1, 0, 36, 34, -1, 0, 36, 35, -1, 0, 36, 36, -1, 0, 36, 37, -1, 0, 36, 38, -1, 0, 36, 39, -1, 0, 36, 40, -1, 0, 36, 41, -1, 0, 36, 42, -1, 0, 36, 43, -1, 0, 36, 44, -1, 0, 36, 45, -1, 0, 36, 46, -1, 0, 36, 47, -1, 0, 36, 48, -1, 0, 36, 49, -1, 0, 36, 50, -1, 0, 36, 51, -1, 0, 36, 52, -1, 0, 36, 53, -1, 0, 36, 54, -1, 0, 36, 55, -1, 0, 36, 56, -1, 0, 36, 57, -1, 0, 36, 58, -1, 0, 36, 59, -1, 0, 37, 0, -1, 0, 37, 1, -1, 0, 37, 2, -1, 0, 37, 3, -1, 0, 37, 4, -1, 0, 37, 5, -1, 0, 37, 6, -1, 0, 37, 7, -1, 0, 37, 8, -1, 0, 37, 9, -1, 0, 37, 10, -1, 0, 37, 11, -1, 0, 37, 12, -1, 0, 37, 13, -1, 0, 37, 14, -1, 0, 37, 15, -1, 0, 37, 16, -1, 0, 37, 17, -1, 0, 37, 18, -1, 0, 37, 19, -1, 0, 37, 20, -1, 0, 37, 21, -1, 0, 37, 22, -1, 0, 37, 23, -1, 0, 37, 24, -1, 0, 37, 25, -1, 0, 37, 26, -1, 0, 37, 27, -1, 0, 37, 28, -1, 0, 37, 29, -1, 0, 37, 30, -1, 0, 37, 31, -1, 0, 37, 32, -1, 0, 37, 33, -1, 0, 37, 34, -1, 0, 37, 35, -1, 0, 37, 36, -1, 0, 37, 37, -1, 0, 37, 38, -1, 0, 37, 39, -1, 0, 37, 40, -1, 0, 37, 41, -1, 0, 37, 42, -1, 0, 37, 43, -1, 0, 37, 44, -1, 0, 37, 45, -1, 0, 37, 46, -1, 0, 37, 47, -1, 0, 37, 48, -1, 0, 37, 49, -1, 0, 37, 50, -1, 0, 37, 51, -1, 0, 37, 52, -1, 0, 37, 53, -1, 0, 37, 54, -1, 0, 37, 55, -1, 0, 37, 56, -1, 0, 37, 57, -1, 0, 37, 58, -1, 0, 37, 59, -1, 0, 38, 0, -1, 0, 38, 1, -1, 0, 38, 2, -1, 0, 38, 3, -1, 0, 38, 4, -1, 0, 38, 5, -1, 0, 38, 6, -1, 0, 38, 7, -1, 0, 38, 8, -1, 0, 38, 9, -1, 0, 38, 10, -1, 0, 38, 11, -1, 0, 38, 12, -1, 0, 38, 13, -1, 0, 38, 14, -1, 0, 38, 15, -1, 0, 38, 16, -1, 0, 38, 17, -1, 0, 38, 18, -1, 0, 38, 19, -1, 0, 38, 20, -1, 0, 38, 21, -1, 0, 38, 22, -1, 0, 38, 23, -1, 0, 38, 24, -1, 0, 38, 25, -1, 0, 38, 26, -1, 0, 38, 27, -1, 0, 38, 28, -1, 0, 38, 29, -1, 0, 38, 30, -1, 0, 38, 31, -1, 0, 38, 32, -1, 0, 38, 33, -1, 0, 38, 34, -1, 0, 38, 35, -1, 0, 38, 36, -1, 0, 38, 37, -1, 0, 38, 38, -1, 0, 38, 39, -1, 0, 38, 40, -1, 0, 38, 41, -1, 0, 38, 42, -1, 0, 38, 43, -1, 0, 38, 44, -1, 0, 38, 45, -1, 0, 38, 46, -1, 0, 38, 47, -1, 0, 38, 48, -1, 0, 38, 49, -1, 0, 38, 50, -1, 0, 38, 51, -1, 0, 38, 52, -1, 0, 38, 53, -1, 0, 38, 54, -1, 0, 38, 55, -1, 0, 38, 56, -1, 0, 38, 57, -1, 0, 38, 58, -1, 0, 38, 59, -1, 0, 39, 0, -1, 0, 39, 1, -1, 0, 39, 2, -1, 0, 39, 3, -1, 0, 39, 4, -1, 0, 39, 5, -1, 0, 39, 6, -1, 0, 39, 7, -1, 0, 39, 8, -1, 0, 39, 9, -1, 0, 39, 10, -1, 0, 39, 11, -1, 0, 39, 12, -1, 0, 39, 13, -1, 0, 39, 14, -1, 0, 39, 15, -1, 0, 39, 16, -1, 0, 39, 17, -1, 0, 39, 18, -1, 0, 39, 19, -1, 0, 39, 20, -1, 0, 39, 21, -1, 0, 39, 22, -1, 0, 39, 23, -1, 0, 39, 24, -1, 0, 39, 25, -1, 0, 39, 26, -1, 0, 39, 27, -1, 0, 39, 28, -1, 0, 39, 29, -1, 0, 39, 30, -1, 0, 39, 31, -1, 0, 39, 32, -1, 0, 39, 33, -1, 0, 39, 34, -1, 0, 39, 35, -1, 0, 39, 36, -1, 0, 39, 37, -1, 0, 39, 38, -1, 0, 39, 39, -1, 0, 39, 40, -1, 0, 39, 41, -1, 0, 39, 42, -1, 0, 39, 43, -1, 0, 39, 44, -1, 0, 39, 45, -1, 0, 39, 46, -1, 0, 39, 47, -1, 0, 39, 48, -1, 0, 39, 49, -1, 0, 39, 50, -1, 0, 39, 51, -1, 0, 39, 52, -1, 0, 39, 53, -1, 0, 39, 54, -1, 0, 39, 55, -1, 0, 39, 56, -1, 0, 39, 57, -1, 0, 39, 58, -1, 0, 39, 59, -1, 1, 0, 4, -1, 1, 0, 5, -1, 1, 0, 10, -1, 1, 0, 11, -1, 1, 0, 19, -1, 1, 0, 20, -1, 1, 0, 22, -1, 1, 0, 23, -1, 1, 0, 24, -1, 1, 0, 25, -1, 1, 0, 26, -1, 1, 0, 27, -1, 1, 0, 28, -1, 1, 0, 29, -1, 1, 0, 30, -1, 1, 0, 31, -1, 1, 0, 32, -1, 1, 0, 33, -1, 1, 0, 34, -1, 1, 0, 35, -1, 1, 0, 36, -1, 1, 0, 37, -1, 1, 0, 38, -1, 1, 0, 39, -1, 1, 0, 40, -1, 1, 0, 41, -1, 1, 0, 42, -1, 1, 0, 45, -1, 1, 0, 46, -1, 1, 1, 0, -1, 1, 1, 1, -1, 1, 1, 2, -1, 1, 1, 3, -1, 1, 1, 4, -1, 1, 1, 10, -1, 1, 1, 11, -1, 1, 1, 14, -1, 1, 1, 17, -1, 1, 1, 18, -1, 1, 1, 19, -1, 1, 1, 20, -1, 1, 1, 21, -1, 1, 1, 22, -1, 1, 1, 23, -1, 1, 1, 24, -1, 1, 1, 25, -1, 1, 1, 30, -1, 1, 1, 31, -1, 1, 1, 32, -1, 1, 1, 33, -1, 1, 1, 34, -1, 1, 1, 35, -1, 1, 1, 36, -1, 1, 1, 37, -1, 1, 1, 38, -1, 1, 1, 39, -1, 1, 1, 40, -1, 1, 1, 41, -1, 1, 1, 42, -1, 1, 1, 43, -1, 1, 1, 44, -1, 1, 1, 45, -1, 1, 1, 46, -1, 1, 1, 47, -1, 1, 1, 48, -1, 1, 1, 49, -1, 1, 1, 50, -1, 1, 1, 51, -1, 1, 1, 52, -1, 1, 2, 0, -1, 1, 2, 1, -1, 1, 2, 2, -1, 1, 2, 3, -1, 1, 2, 4, -1, 1, 2, 5, -1, 1, 2, 6, -1, 1, 2, 11, -1, 1, 2, 14, -1, 1, 2, 16, -1, 1, 2, 17, -1, 1, 2, 18, -1, 1, 2, 19, -1, 1, 2, 20, -1, 1, 2, 21, -1, 1, 2, 22, -1, 1, 2, 23, -1, 1, 2, 24, -1, 1, 2, 25, -1, 1, 2, 31, -1, 1, 2, 34, -1, 1, 2, 35, -1, 1, 2, 36, -1, 1, 2, 37, -1, 1, 2, 38, -1, 1, 2, 39, -1, 1, 2, 40, -1, 1, 2, 41, -1, 1, 2, 42, -1, 1, 2, 43, -1, 1, 2, 44, -1, 1, 2, 45, -1, 1, 2, 46, -1, 1, 2, 47, -1, 1, 2, 48, -1, 1, 2, 49, -1, 1, 2, 50, -1, 1, 2, 51, -1, 1, 2, 52, -1, 1, 2, 53, -1, 1, 2, 54, -1, 1, 3, 0, -1, 1, 3, 1, -1, 1, 3, 2, -1, 1, 3, 3, -1, 1, 3, 4, -1, 1, 3, 5, -1, 1, 3, 6, -1, 1, 3, 7, -1, 1, 3, 8, -1, 1, 3, 14, -1, 1, 3, 15, -1, 1, 3, 16, -1, 1, 3, 17, -1, 1, 3, 18, -1, 1, 3, 19, -1, 1, 3, 20, -1, 1, 3, 21, -1, 1, 3, 22, -1, 1, 3, 23, -1, 1, 3, 24, -1, 1, 3, 33, -1, 1, 3, 34, -1, 1, 3, 35, -1, 1, 3, 36, -1, 1, 3, 37, -1, 1, 3, 38, -1, 1, 3, 39, -1, 1, 3, 40, -1, 1, 3, 42, -1, 1, 3, 43, -1, 1, 3, 44, -1, 1, 3, 45, -1, 1, 3, 46, -1, 1, 3, 47, -1, 1, 3, 48, -1, 1, 3, 49, -1, 1, 3, 50, -1, 1, 3, 51, -1, 1, 3, 52, -1, 1, 3, 53, -1, 1, 3, 54, -1, 1, 3, 55, -1, 1, 4, 1, -1, 1, 4, 4, -1, 1, 4, 5, -1, 1, 4, 6, -1, 1, 4, 7, -1, 1, 4, 9, -1, 1, 4, 10, -1, 1, 4, 11, -1, 1, 4, 12, -1, 1, 4, 13, -1, 1, 4, 14, -1, 1, 4, 15, -1, 1, 4, 16, -1, 1, 4, 17, -1, 1, 4, 20, -1, 1, 4, 21, -1, 1, 4, 22, -1, 1, 4, 23, -1, 1, 4, 24, -1, 1, 4, 25, -1, 1, 4, 26, -1, 1, 4, 28, -1, 1, 4, 29, -1, 1, 4, 30, -1, 1, 4, 31, -1, 1, 4, 32, -1, 1, 4, 33, -1, 1, 4, 34, -1, 1, 4, 35, -1, 1, 4, 36, -1, 1, 4, 37, -1, 1, 4, 38, -1, 1, 4, 39, -1, 1, 4, 40, -1, 1, 4, 41, -1, 1, 4, 47, -1, 1, 4, 48, -1, 1, 4, 52, -1, 1, 4, 53, -1, 1, 4, 54, -1, 1, 4, 55, -1, 1, 5, 0, -1, 1, 5, 6, -1, 1, 5, 7, -1, 1, 5, 8, -1, 1, 5, 9, -1, 1, 5, 10, -1, 1, 5, 11, -1, 1, 5, 12, -1, 1, 5, 13, -1, 1, 5, 14, -1, 1, 5, 15, -1, 1, 5, 16, -1, 1, 5, 20, -1, 1, 5, 21, -1, 1, 5, 22, -1, 1, 5, 23, -1, 1, 5, 24, -1, 1, 5, 25, -1, 1, 5, 26, -1, 1, 5, 27, -1, 1, 5, 28, -1, 1, 5, 29, -1, 1, 5, 30, -1, 1, 5, 31, -1, 1, 5, 32, -1, 1, 5, 33, -1, 1, 5, 34, -1, 1, 5, 35, -1, 1, 5, 36, -1, 1, 5, 37, -1, 1, 5, 38, -1, 1, 5, 39, -1, 1, 5, 40, -1, 1, 5, 41, -1, 1, 5, 42, -1, 1, 5, 43, -1, 1, 5, 54, -1, 1, 5, 55, -1, 1, 6, 1, -1, 1, 6, 6, -1, 1, 6, 7, -1, 1, 6, 8, -1, 1, 6, 9, -1, 1, 6, 10, -1, 1, 6, 11, -1, 1, 6, 12, -1, 1, 6, 13, -1, 1, 6, 14, -1, 1, 6, 15, -1, 1, 6, 24, -1, 1, 6, 25, -1, 1, 6, 26, -1, 1, 6, 27, -1, 1, 6, 28, -1, 1, 6, 29, -1, 1, 6, 30, -1, 1, 6, 31, -1, 1, 6, 32, -1, 1, 6, 33, -1, 1, 6, 40, -1, 1, 6, 41, -1, 1, 6, 42, -1, 1, 6, 43, -1, 1, 6, 44, -1, 1, 6, 45, -1, 1, 6, 46, -1, 1, 6, 54, -1, 1, 6, 55, -1, 1, 7, 0, -1, 1, 7, 3, -1, 1, 7, 4, -1, 1, 7, 5, -1, 1, 7, 6, -1, 1, 7, 7, -1, 1, 7, 8, -1, 1, 7, 9, -1, 1, 7, 10, -1, 1, 7, 11, -1, 1, 7, 14, -1, 1, 7, 26, -1, 1, 7, 27, -1, 1, 7, 28, -1, 1, 7, 29, -1, 1, 7, 31, -1, 1, 7, 32, -1, 1, 7, 33, -1, 1, 7, 38, -1, 1, 7, 39, -1, 1, 7, 40, -1, 1, 7, 42, -1, 1, 7, 43, -1, 1, 7, 44, -1, 1, 7, 45, -1, 1, 7, 46, -1, 1, 7, 47, -1, 1, 7, 48, -1, 1, 7, 49, -1, 1, 7, 50, -1, 1, 7, 54, -1, 1, 7, 55, -1, 1, 7, 56, -1, 1, 8, 1, -1, 1, 8, 26, -1, 1, 8, 27, -1, 1, 8, 28, -1, 1, 8, 29, -1, 1, 8, 31, -1, 1, 8, 32, -1, 1, 8, 33, -1, 1, 8, 42, -1, 1, 8, 43, -1, 1, 8, 44, -1, 1, 8, 45, -1, 1, 8, 46, -1, 1, 8, 47, -1, 1, 8, 48, -1, 1, 8, 49, -1, 1, 8, 50, -1, 1, 8, 51, -1, 1, 8, 54, -1, 1, 8, 55, -1, 1, 8, 56, -1, 1, 8, 57, -1, 1, 9, 36, -1, 1, 9, 37, -1, 1, 9, 46, -1, 1, 9, 47, -1, 1, 9, 48, -1, 1, 9, 49, -1, 1, 9, 50, -1, 1, 9, 51, -1, 1, 9, 54, -1, 1, 9, 55, -1, 1, 9, 56, -1, 1, 9, 57, -1, 1, 9, 58, -1, 1, 9, 59, -1, 1, 10, 45, -1, 1, 10, 46, -1, 1, 10, 50, -1, 1, 10, 51, -1, 1, 10, 56, -1, 1, 10, 57, -1, 1, 10, 58, -1, 1, 10, 59, -1, 1, 11, 8, -1, 1, 11, 9, -1, 1, 11, 10, -1, 1, 11, 11, -1, 1, 11, 12, -1, 1, 11, 13, -1, 1, 11, 48, -1, 1, 11, 49, -1, 1, 11, 50, -1, 1, 11, 51, -1, 1, 11, 52, -1, 1, 11, 53, -1, 1, 11, 54, -1, 1, 11, 55, -1, 1, 11, 56, -1, 1, 11, 57, -1, 1, 11, 58, -1, 1, 11, 59, -1, 1, 12, 7, -1, 1, 12, 8, -1, 1, 12, 9, -1, 1, 12, 10, -1, 1, 12, 11, -1, 1, 12, 12, -1, 1, 12, 13, -1, 1, 12, 14, -1, 1, 12, 50, -1, 1, 12, 51, -1, 1, 12, 52, -1, 1, 12, 53, -1, 1, 12, 54, -1, 1, 12, 55, -1, 1, 12, 56, -1, 1, 12, 57, -1, 1, 12, 58, -1, 1, 12, 59, -1, 1, 13, 7, -1, 1, 13, 8, -1, 1, 13, 9, -1, 1, 13, 10, -1, 1, 13, 11, -1, 1, 13, 12, -1, 1, 13, 13, -1, 1, 13, 14, -1, 1, 13, 50, -1, 1, 13, 51, -1, 1, 13, 52, -1, 1, 13, 53, -1, 1, 13, 54, -1, 1, 13, 55, -1, 1, 13, 56, -1, 1, 13, 57, -1, 1, 13, 58, -1, 1, 13, 59, -1, 1, 14, 7, -1, 1, 14, 8, -1, 1, 14, 9, -1, 1, 14, 10, -1, 1, 14, 11, -1, 1, 14, 12, -1, 1, 14, 13, -1, 1, 14, 14, -1, 1, 14, 56, -1, 1, 14, 57, -1, 1, 14, 58, -1, 1, 14, 59, -1, 1, 15, 2, -1, 1, 15, 3, -1, 1, 15, 7, -1, 1, 15, 8, -1, 1, 15, 9, -1, 1, 15, 10, -1, 1, 15, 11, -1, 1, 15, 12, -1, 1, 15, 13, -1, 1, 15, 14, -1, 1, 15, 32, -1, 1, 15, 33, -1, 1, 15, 34, -1, 1, 16, 2, -1, 1, 16, 3, -1, 1, 16, 7, -1, 1, 16, 8, -1, 1, 16, 9, -1, 1, 16, 10, -1, 1, 16, 11, -1, 1, 16, 12, -1, 1, 16, 13, -1, 1, 16, 14, -1, 1, 16, 54, -1, 1, 16, 56, -1, 1, 16, 58, -1, 1, 17, 2, -1, 1, 17, 3, -1, 1, 17, 7, -1, 1, 17, 8, -1, 1, 17, 9, -1, 1, 17, 10, -1, 1, 17, 11, -1, 1, 17, 12, -1, 1, 17, 13, -1, 1, 17, 14, -1, 1, 17, 39, -1, 1, 17, 40, -1, 1, 18, 2, -1, 1, 18, 3, -1, 1, 18, 7, -1, 1, 18, 8, -1, 1, 18, 9, -1, 1, 18, 10, -1, 1, 18, 11, -1, 1, 18, 12, -1, 1, 18, 13, -1, 1, 18, 14, -1, 1, 19, 1, -1, 1, 19, 2, -1, 1, 19, 3, -1, 1, 20, 0, -1, 1, 20, 1, -1, 1, 20, 2, -1, 1, 20, 3, 101, 1, 20, 34, 880, 1, 20, 49, 885, 1, 20, 54, -1, 1, 20, 56, -1, 1, 20, 58, -1, 1, 21, 0, -1, 1, 21, 1, -1, 1, 21, 2, -1, 1, 21, 3, -1, 1, 21, 33, -1, 1, 21, 34, 784, 1, 21, 35, -1, 1, 21, 36, -1, 1, 21, 37, -1, 1, 21, 38, -1, 1, 21, 39, -1, 1, 21, 40, -1, 1, 21, 41, -1, 1, 21, 42, -1, 1, 21, 43, 954, 1, 21, 44, 955, 1, 21, 45, 956, 1, 21, 46, -1, 1, 21, 47, -1, 1, 21, 48, -1, 1, 21, 49, 901, 1, 21, 55, -1, 1, 21, 56, -1, 1, 21, 57, -1, 1, 21, 58, -1, 1, 21, 59, -1, 1, 22, 0, -1, 1, 22, 1, -1, 1, 22, 3, -1, 1, 22, 4, -1, 1, 22, 5, -1, 1, 22, 6, -1, 1, 22, 7, -1, 1, 22, 8, -1, 1, 22, 33, -1, 1, 22, 34, 800, 1, 22, 35, -1, 1, 22, 36, -1, 1, 22, 37, -1, 1, 22, 38, -1, 1, 22, 39, -1, 1, 22, 40, -1, 1, 22, 41, -1, 1, 22, 42, -1, 1, 22, 43, 970, 1, 22, 44, 971, 1, 22, 45, 972, 1, 22, 46, -1, 1, 22, 47, -1, 1, 22, 48, -1, 1, 22, 49, 917, 1, 22, 50, -1, 1, 22, 54, -1, 1, 22, 55, -1, 1, 22, 56, -1, 1, 22, 57, -1, 1, 22, 58, -1, 1, 22, 59, -1, 1, 23, 0, -1, 1, 23, 1, -1, 1, 23, 2, -1, 1, 23, 3, -1, 1, 23, 4, -1, 1, 23, 5, -1, 1, 23, 6, 827, 1, 23, 7, 828, 1, 23, 8, 829, 1, 23, 9, -1, 1, 23, 33, -1, 1, 23, 34, 816, 1, 23, 35, 929, 1, 23, 36, -1, 1, 23, 37, 826, 1, 23, 38, -1, 1, 23, 39, -1, 1, 23, 40, -1, 1, 23, 41, -1, 1, 23, 42, -1, 1, 23, 43, 986, 1, 23, 44, 987, 1, 23, 45, 988, 1, 23, 46, -1, 1, 23, 47, -1, 1, 23, 48, 932, 1, 23, 49, 933, 1, 23, 50, -1, 1, 23, 54, -1, 1, 23, 55, -1, 1, 24, 0, -1, 1, 24, 2, -1, 1, 24, 3, -1, 1, 24, 4, -1, 1, 24, 5, -1, 1, 24, 6, -1, 1, 24, 7, -1, 1, 24, 8, 862, 1, 24, 9, -1, 1, 24, 33, -1, 1, 24, 34, 832, 1, 24, 35, -1, 1, 24, 36, -1, 1, 24, 37, -1, 1, 24, 38, -1, 1, 24, 39, -1, 1, 24, 40, -1, 1, 24, 41, 793, 1, 24, 42, -1, 1, 24, 43, 778, 1, 24, 44, 779, 1, 24, 45, 780, 1, 24, 46, 847, 1, 24, 47, -1, 1, 24, 48, -1, 1, 24, 49, 949, 1, 24, 50, -1, 1, 24, 54, -1, 1, 24, 55, -1, 1, 25, 0, -1, 1, 25, 2, -1, 1, 25, 3, -1, 1, 25, 4, -1, 1, 25, 5, -1, 1, 25, 6, -1, 1, 25, 7, -1, 1, 25, 8, -1, 1, 25, 9, -1, 1, 25, 33, -1, 1, 25, 34, 864, 1, 25, 35, 865, 1, 25, 36, 979, 1, 25, 37, 978, 1, 25, 38, 979, 1, 25, 39, 979, 1, 25, 40, 792, 1, 25, 41, -1, 1, 25, 42, -1, 1, 25, 43, 794, 1, 25, 44, 795, 1, 25, 45, 796, 1, 25, 46, 863, 1, 25, 47, -1, 1, 25, 48, -1, 1, 25, 49, 933, 1, 25, 50, -1, 1, 25, 54, -1, 1, 25, 55, -1, 1, 25, 57, -1, 1, 25, 58, -1, 1, 25, 59, -1, 1, 26, 0, -1, 1, 26, 2, -1, 1, 26, 3, -1, 1, 26, 4, -1, 1, 26, 5, -1, 1, 26, 6, -1, 1, 26, 7, -1, 1, 26, 8, -1, 1, 26, 9, -1, 1, 26, 33, -1, 1, 26, 34, -1, 1, 26, 35, -1, 1, 26, 36, -1, 1, 26, 37, -1, 1, 26, 38, -1, 1, 26, 39, -1, 1, 26, 40, 832, 1, 26, 41, -1, 1, 26, 42, -1, 1, 26, 43, 810, 1, 26, 44, 811, 1, 26, 45, 812, 1, 26, 46, -1, 1, 26, 47, -1, 1, 26, 48, -1, 1, 26, 49, 949, 1, 26, 50, -1, 1, 26, 54, -1, 1, 26, 55, -1, 1, 26, 57, -1, 1, 26, 58, -1, 1, 26, 59, -1, 1, 27, 0, -1, 1, 27, 2, -1, 1, 27, 3, -1, 1, 27, 4, -1, 1, 27, 5, -1, 1, 27, 6, -1, 1, 27, 7, -1, 1, 27, 8, -1, 1, 27, 9, -1, 1, 27, 34, -1, 1, 27, 35, -1, 1, 27, 36, -1, 1, 27, 37, -1, 1, 27, 38, -1, 1, 27, 39, -1, 1, 27, 40, 832, 1, 27, 41, -1, 1, 27, 42, -1, 1, 27, 43, -1, 1, 27, 44, -1, 1, 27, 45, -1, 1, 27, 46, -1, 1, 27, 47, -1, 1, 27, 48, -1, 1, 27, 49, 949, 1, 27, 50, -1, 1, 27, 54, -1, 1, 27, 55, -1, 1, 27, 57, -1, 1, 27, 58, -1, 1, 27, 59, -1, 1, 28, 2, -1, 1, 28, 3, -1, 1, 28, 4, -1, 1, 28, 5, -1, 1, 28, 6, -1, 1, 28, 7, -1, 1, 28, 8, -1, 1, 28, 9, -1, 1, 28, 11, -1, 1, 28, 12, -1, 1, 28, 15, -1, 1, 28, 16, -1, 1, 28, 33, -1, 1, 28, 34, -1, 1, 28, 35, -1, 1, 28, 36, -1, 1, 28, 37, -1, 1, 28, 38, -1, 1, 28, 39, -1, 1, 28, 40, 816, 1, 28, 41, -1, 1, 28, 42, -1, 1, 28, 43, -1, 1, 28, 44, -1, 1, 28, 45, -1, 1, 28, 46, -1, 1, 28, 47, -1, 1, 28, 48, -1, 1, 28, 49, 933, 1, 28, 50, -1, 1, 28, 54, -1, 1, 28, 55, -1, 1, 29, 2, -1, 1, 29, 3, -1, 1, 29, 4, -1, 1, 29, 5, -1, 1, 29, 6, -1, 1, 29, 7, -1, 1, 29, 8, -1, 1, 29, 9, -1, 1, 29, 11, -1, 1, 29, 12, -1, 1, 29, 15, -1, 1, 29, 16, -1, 1, 29, 33, -1, 1, 29, 34, -1, 1, 29, 35, -1, 1, 29, 36, -1, 1, 29, 37, -1, 1, 29, 38, -1, 1, 29, 39, -1, 1, 29, 40, 960, 1, 29, 41, 961, 1, 29, 42, -1, 1, 29, 43, -1, 1, 29, 44, -1, 1, 29, 45, -1, 1, 29, 46, -1, 1, 29, 47, 886, 1, 29, 48, 887, 1, 29, 49, 965, 1, 29, 50, -1, 1, 29, 54, -1, 1, 29, 55, -1, 1, 29, 56, -1, 1, 30, 2, -1, 1, 30, 3, -1, 1, 30, 4, -1, 1, 30, 5, -1, 1, 30, 6, -1, 1, 30, 7, -1, 1, 30, 8, -1, 1, 30, 9, -1, 1, 30, 11, -1, 1, 30, 12, -1, 1, 30, 14, -1, 1, 30, 15, -1, 1, 30, 16, -1, 1, 30, 39, -1, 1, 30, 40, 976, 1, 30, 41, 977, 1, 30, 42, 978, 1, 30, 43, 978, 1, 30, 44, 979, 1, 30, 45, 792, 1, 30, 46, -1, 1, 30, 47, 902, 1, 30, 48, 903, 1, 30, 49, 981, 1, 30, 50, -1, 1, 30, 54, -1, 1, 30, 55, -1, 1, 30, 56, -1, 1, 30, 57, -1, 1, 31, 1, -1, 1, 31, 2, -1, 1, 31, 3, -1, 1, 31, 11, -1, 1, 31, 12, -1, 1, 31, 13, -1, 1, 31, 14, -1, 1, 31, 15, -1, 1, 31, 16, -1, 1, 31, 39, -1, 1, 31, 40, -1, 1, 31, 41, -1, 1, 31, 42, -1, 1, 31, 43, -1, 1, 31, 44, -1, 1, 31, 45, 912, 1, 31, 46, -1, 1, 31, 47, -1, 1, 31, 48, 821, 1, 31, 49, -1, 1, 31, 50, -1, 1, 31, 54, -1, 1, 31, 55, -1, 1, 31, 56, -1, 1, 31, 57, -1, 1, 31, 58, -1, 1, 32, 0, -1, 1, 32, 11, -1, 1, 32, 12, -1, 1, 32, 13, -1, 1, 32, 14, -1, 1, 32, 15, -1, 1, 32, 16, -1, 1, 32, 39, -1, 1, 32, 40, -1, 1, 32, 41, -1, 1, 32, 42, -1, 1, 32, 43, -1, 1, 32, 44, -1, 1, 32, 45, -1, 1, 32, 46, -1, 1, 32, 47, -1, 1, 32, 48, -1, 1, 32, 49, -1, 1, 32, 50, -1, 1, 32, 56, -1, 1, 32, 57, -1, 1, 32, 58, -1, 1, 32, 59, -1, 1, 33, 11, -1, 1, 33, 12, -1, 1, 33, 13, -1, 1, 33, 14, -1, 1, 33, 39, -1, 1, 33, 40, -1, 1, 33, 41, -1, 1, 33, 42, -1, 1, 33, 43, -1, 1, 33, 44, -1, 1, 33, 45, 467, 1, 33, 46, -1, 1, 33, 47, -1, 1, 33, 49, -1, 1, 33, 50, -1, 1, 33, 56, -1, 1, 33, 57, -1, 1, 33, 58, -1, 1, 33, 59, -1, 1, 34, 0, -1, 1, 34, 1, -1, 1, 34, 39, -1, 1, 34, 40, -1, 1, 34, 41, -1, 1, 34, 42, -1, 1, 34, 43, -1, 1, 34, 44, -1, 1, 34, 45, 483, 1, 34, 46, -1, 1, 34, 47, -1, 1, 34, 49, -1, 1, 34, 50, -1, 1, 34, 58, -1, 1, 34, 59, -1, 1, 35, 0, -1, 1, 35, 1, -1, 1, 35, 20, -1, 1, 35, 39, -1, 1, 35, 40, -1, 1, 35, 41, -1, 1, 35, 42, -1, 1, 35, 43, -1, 1, 35, 44, -1, 1, 35, 46, -1, 1, 35, 47, -1, 1, 35, 49, -1, 1, 35, 50, -1, 1, 35, 58, -1, 1, 35, 59, -1, 1, 36, 0, -1, 1, 36, 20, -1, 1, 36, 58, -1, 1, 36, 59, -1, 1, 37, 25, -1, 1, 37, 26, -1, 1, 37, 39, -1, 1, 37, 58, -1, 1, 37, 59, -1, 1, 38, 10, -1, 1, 38, 11, -1, 1, 38, 27, -1, 1, 38, 57, -1, 1, 38, 58, -1, 1, 38, 59, -1, 1, 39, 18, -1, 1, 39, 28, -1, 1, 39, 56, -1, 1, 39, 57, -1, 1, 39, 58, -1, 2, 1, 31, -1, 2, 1, 47, -1, 2, 1, 48, -1, 2, 2, 28, -1, 2, 2, 29, -1, 2, 2, 47, -1, 2, 2, 48, -1, 2, 3, 28, -1, 2, 3, 29, -1, 2, 3, 36, -1, 2, 3, 47, -1, 2, 3, 48, -1, 2, 3, 51, -1, 2, 3, 52, -1, 2, 3, 53, -1, 2, 4, 3, -1, 2, 4, 4, -1, 2, 4, 5, -1, 2, 4, 51, -1, 2, 4, 52, -1, 2, 4, 53, -1, 2, 5, 1, -1, 2, 5, 3, -1, 2, 5, 4, -1, 2, 5, 5, -1, 2, 5, 10, -1, 2, 5, 11, -1, 2, 5, 31, -1, 2, 5, 32, -1, 2, 5, 33, -1, 2, 5, 38, -1, 2, 5, 39, -1, 2, 5, 40, -1, 2, 5, 51, -1, 2, 5, 52, -1, 2, 5, 53, -1, 2, 5, 56, -1, 2, 5, 57, -1, 2, 6, 3, -1, 2, 6, 4, -1, 2, 6, 5, -1, 2, 6, 10, -1, 2, 6, 11, -1, 2, 6, 14, -1, 2, 6, 31, -1, 2, 6, 32, -1, 2, 6, 33, -1, 2, 6, 36, -1, 2, 6, 37, -1, 2, 6, 38, -1, 2, 6, 39, -1, 2, 6, 40, -1, 2, 6, 47, -1, 2, 6, 51, -1, 2, 6, 52, -1, 2, 6, 53, -1, 2, 6, 56, -1, 2, 6, 57, -1, 2, 7, 0, -1, 2, 7, 36, -1, 2, 7, 37, -1, 2, 7, 56, -1, 2, 7, 57, -1, 2, 8, 0, -1, 2, 8, 36, -1, 2, 8, 37, -1, 2, 8, 45, -1, 2, 8, 46, -1, 2, 8, 48, -1, 2, 8, 49, -1, 2, 9, 0, -1, 2, 9, 7, -1, 2, 9, 8, -1, 2, 9, 10, -1, 2, 9, 11, -1, 2, 9, 13, -1, 2, 9, 45, -1, 2, 9, 46, -1, 2, 9, 48, -1, 2, 9, 49, -1, 2, 10, 0, -1, 2, 10, 1, -1, 2, 10, 6, -1, 2, 10, 7, -1, 2, 10, 8, -1, 2, 10, 9, -1, 2, 10, 10, -1, 2, 10, 11, -1, 2, 10, 12, -1, 2, 10, 13, -1, 2, 10, 14, -1, 2, 10, 15, -1, 2, 10, 48, -1, 2, 10, 49, -1, 2, 11, 0, -1, 2, 11, 1, -1, 2, 11, 6, -1, 2, 11, 7, -1, 2, 11, 14, -1, 2, 11, 15, -1, 2, 11, 56, -1, 2, 12, 0, -1, 2, 12, 1, -1, 2, 12, 6, -1, 2, 12, 7, -1, 2, 12, 14, -1, 2, 12, 15, -1, 2, 12, 32, -1, 2, 12, 33, -1, 2, 12, 34, -1, 2, 13, 0, -1, 2, 13, 1, -1, 2, 13, 2, -1, 2, 13, 6, -1, 2, 13, 7, -1, 2, 13, 14, -1, 2, 13, 15, -1, 2, 13, 32, -1, 2, 13, 33, -1, 2, 13, 34, -1, 2, 14, 1, -1, 2, 14, 2, -1, 2, 14, 3, -1, 2, 14, 6, -1, 2, 14, 7, -1, 2, 14, 14, -1, 2, 14, 15, -1, 2, 14, 32, -1, 2, 14, 33, -1, 2, 14, 34, -1, 2, 14, 39, -1, 2, 14, 40, -1, 2, 15, 6, -1, 2, 15, 7, -1, 2, 15, 14, -1, 2, 15, 15, -1, 2, 15, 39, -1, 2, 15, 40, -1, 2, 15, 54, -1, 2, 15, 56, -1, 2, 15, 58, -1, 2, 16, 6, -1, 2, 16, 15, -1, 2, 16, 39, -1, 2, 16, 40, -1, 2, 17, 6, -1, 2, 17, 15, -1, 2, 19, 33, -1, 2, 19, 34, -1, 2, 19, 36, -1, 2, 19, 37, -1, 2, 19, 38, -1, 2, 19, 39, -1, 2, 19, 42, -1, 2, 19, 43, -1, 2, 19, 44, -1, 2, 19, 45, -1, 2, 19, 46, -1, 2, 19, 47, -1, 2, 19, 49, -1, 2, 19, 50, -1, 2, 19, 54, -1, 2, 19, 56, -1, 2, 19, 58, -1, 2, 20, 2, -1, 2, 20, 3, -1, 2, 20, 5, -1, 2, 20, 6, -1, 2, 20, 8, -1, 2, 20, 9, -1, 2, 20, 32, -1, 2, 20, 33, -1, 2, 20, 34, -1, 2, 20, 35, -1, 2, 20, 36, -1, 2, 20, 37, -1, 2, 20, 38, -1, 2, 20, 39, -1, 2, 20, 40, -1, 2, 20, 41, -1, 2, 20, 42, -1, 2, 20, 43, -1, 2, 20, 44, -1, 2, 20, 45, -1, 2, 20, 46, -1, 2, 20, 47, -1, 2, 20, 48, -1, 2, 20, 49, -1, 2, 20, 50, -1, 2, 20, 51, -1, 2, 21, 1, -1, 2, 21, 2, -1, 2, 21, 3, -1, 2, 21, 4, -1, 2, 21, 5, -1, 2, 21, 6, -1, 2, 21, 7, -1, 2, 21, 8, -1, 2, 21, 9, -1, 2, 21, 10, -1, 2, 21, 32, -1, 2, 21, 33, -1, 2, 21, 50, -1, 2, 21, 51, -1, 2, 22, 1, -1, 2, 22, 2, -1, 2, 22, 9, -1, 2, 22, 10, -1, 2, 22, 32, -1, 2, 22, 33, -1, 2, 22, 50, -1, 2, 22, 51, -1, 2, 23, 1, -1, 2, 23, 2, -1, 2, 23, 8, 846, 2, 23, 9, -1, 2, 23, 10, -1, 2, 23, 32, -1, 2, 23, 33, -1, 2, 23, 50, -1, 2, 23, 51, -1, 2, 24, 1, -1, 2, 24, 2, -1, 2, 24, 9, -1, 2, 24, 10, -1, 2, 24, 32, -1, 2, 24, 33, -1, 2, 24, 50, -1, 2, 24, 51, -1, 2, 25, 1, -1, 2, 25, 2, -1, 2, 25, 9, -1, 2, 25, 10, -1, 2, 25, 32, -1, 2, 25, 33, -1, 2, 25, 50, -1, 2, 25, 51, -1, 2, 26, 1, -1, 2, 26, 2, 960, 2, 26, 3, 961, 2, 26, 8, 964, 2, 26, 9, 965, 2, 26, 10, -1, 2, 26, 12, -1, 2, 26, 13, -1, 2, 26, 14, -1, 2, 26, 15, -1, 2, 26, 32, -1, 2, 26, 33, -1, 2, 26, 50, -1, 2, 26, 51, -1, 2, 26, 55, -1, 2, 26, 56, -1, 2, 27, 1, -1, 2, 27, 2, 976, 2, 27, 3, 977, 2, 27, 4, 866, 2, 27, 7, 979, 2, 27, 8, 980, 2, 27, 9, 981, 2, 27, 10, -1, 2, 27, 11, -1, 2, 27, 12, -1, 2, 27, 13, -1, 2, 27, 14, -1, 2, 27, 15, -1, 2, 27, 16, -1, 2, 27, 32, -1, 2, 27, 33, -1, 2, 27, 50, -1, 2, 27, 51, -1, 2, 27, 55, -1, 2, 27, 56, -1, 2, 28, 1, -1, 2, 28, 4, 467, 2, 28, 5, 318, 2, 28, 6, 319, 2, 28, 7, 470, 2, 28, 10, -1, 2, 28, 12, -1, 2, 28, 13, -1, 2, 28, 14, -1, 2, 28, 38, -1, 2, 28, 39, -1, 2, 28, 50, -1, 2, 28, 51, -1, 2, 28, 55, -1, 2, 28, 56, -1, 2, 29, 4, 483, 2, 29, 5, 334, 2, 29, 6, 335, 2, 29, 7, 486, 2, 29, 13, -1, 2, 29, 14, -1, 2, 29, 38, -1, 2, 29, 39, -1, 2, 29, 50, -1, 2, 29, 51, -1, 2, 30, 0, -1, 2, 30, 2, -1, 2, 30, 3, -1, 2, 30, 4, 499, 2, 30, 7, 502, 2, 30, 13, -1, 2, 30, 14, -1, 2, 30, 38, -1, 2, 30, 39, -1, 2, 30, 50, -1, 2, 30, 51, -1, 2, 30, 57, -1, 2, 31, 0, -1, 2, 31, 22, -1, 2, 31, 23, -1, 2, 31, 38, -1, 2, 31, 39, -1, 2, 31, 50, -1, 2, 31, 51, -1, 2, 32, 0, -1, 2, 32, 21, -1, 2, 32, 22, -1, 2, 32, 23, -1, 2, 32, 24, -1, 2, 32, 38, -1, 2, 32, 39, -1, 2, 32, 45, 944, 2, 32, 48, 949, 2, 32, 50, -1, 2, 32, 51, -1, 2, 33, 0, -1, 2, 33, 1, -1, 2, 33, 20, -1, 2, 33, 21, -1, 2, 33, 22, -1, 2, 33, 23, -1, 2, 33, 24, -1, 2, 33, 38, -1, 2, 33, 39, -1, 2, 33, 46, 318, 2, 33, 47, 319, 2, 33, 50, -1, 2, 33, 51, -1, 2, 34, 19, -1, 2, 34, 20, -1, 2, 34, 21, -1, 2, 34, 23, -1, 2, 34, 24, -1, 2, 34, 46, 334, 2, 34, 47, 335, 2, 35, 10, -1, 2, 35, 11, -1, 2, 35, 19, -1, 2, 35, 23, -1, 2, 35, 24, -1, 2, 35, 25, -1, 2, 36, 1, -1, 2, 36, 2, -1, 2, 36, 3, -1, 2, 36, 4, -1, 2, 36, 5, -1, 2, 36, 10, -1, 2, 36, 11, -1, 2, 36, 19, -1, 2, 36, 24, -1, 2, 36, 25, -1, 2, 36, 26, -1, 2, 36, 27, -1, 2, 36, 39, -1, 2, 37, 1, -1, 2, 37, 2, -1, 2, 37, 3, -1, 2, 37, 4, -1, 2, 37, 5, -1, 2, 37, 6, -1, 2, 37, 7, -1, 2, 37, 10, -1, 2, 37, 11, -1, 2, 37, 18, -1, 2, 37, 19, -1, 2, 37, 20, -1, 2, 37, 27, -1, 2, 37, 28, -1, 2, 38, 4, -1, 2, 38, 5, -1, 2, 38, 6, -1, 2, 38, 7, -1, 2, 38, 8, -1, 2, 38, 17, -1, 2, 38, 18, -1, 2, 38, 19, -1, 2, 38, 20, -1, 2, 38, 21, -1, 2, 38, 22, -1, 2, 38, 28, -1, 2, 38, 29, -1, 2, 39, 6, -1, 2, 39, 7, -1, 2, 39, 8, -1, 2, 39, 9, -1, 2, 39, 17, -1, 2, 39, 20, -1, 2, 39, 21, -1, 2, 39, 22, -1, 2, 39, 29, -1, 2, 39, 30, -1 }

-- Allacrost map editor end. Do not edit this line. --


laila = nil; -- Pointer to Laila''s map sprite


function Load(m)
	-- First, record the current map in the "map" variable that is global to this script
	map = m;
	map.run_forever = true;
	dialogue_supervisor = m.dialogue_supervisor;
	event_supervisor = m.event_supervisor;

	local sprite;
	local dialogue;
	local event;
	local chest;
	local text;

	-- Create the player''s sprite
	sprite = ConstructSprite("Claudius", 1000, 100, 36);
	map:AddGroundObject(sprite);
	-- Set the camera to focus on the player''s sprite
	map:SetCamera(sprite);


	-- Create NPC sprites and actions

	-- Add NPC Laila
	laila = ConstructSprite("Laila", 2, 105, 32, 0.0, 0.0);
	-- If Laila previously joined the party in the saved game, remove her sprite
	if (map.map_event_group:DoesEventExist("laila_joined") == true) then
		map_functions[1]();
	end

	-- Dialogue with Laila
	dialogue = hoa_map.MapDialogue(1);

	text = hoa_system.Translate("Laila, what's wrong? You have a worried look on your face.");
	dialogue:AddText(text, 1000, 1, 0, false);
	text = hoa_system.Translate("You're going into the cave again, aren't you?");
	dialogue:AddText(text, 2, 2, 0, false);

	-- Are you going into the cave?
	text = hoa_system.Translate("Yes, I intend to...");
	dialogue:AddOption(text, 2, 0);
	text = hoa_system.Translate("No, of course not...");
	dialogue:AddOption(text, 8, 0);
	-- Additional options added for testing purposes
	text = hoa_system.Translate("Test Option #1");
	dialogue:AddOption(text, -1, 0);
	text = hoa_system.Translate("Test Option #2");
	dialogue:AddOption(text, -1, 0);
	text = hoa_system.Translate("Test Option #3");
	dialogue:AddOption(text, -1, 0);

	--Yes
	text = hoa_system.Translate("But why? Its dangerous in there!");
	dialogue:AddText(text, 2, 3, 0, false);
	text = hoa_system.Translate("Laila, if I want to be capable on the battlefield I have to fight real battles. You understand that, don't you?");
	dialogue:AddText(text, 1000, 4, 0, false);
	text = hoa_system.Translate("I know that you're worried about me and I appreciate it, but you need to stop doing this.");
	dialogue:AddText(text, 1000, 5, 0, false);
	text = hoa_system.Translate(".....Alright, I'm sorry. Just be careful in there, okay?");
	dialogue:AddText(text, 2, 6, 0, false);
	text = hoa_system.Translate("Will do. Thanks Laila.");
	dialogue:AddText(text, 1000, 7, 0, false);
	text = hoa_system.Translate("You know Claudius, I could be of assistance to you in the cave. May I come with you?");
	dialogue:AddText(text, 2, 10, 0, false);

	-- Allow Laila to join party?
	text = hoa_system.Translate("No way, you could be hurt!");
	dialogue:AddOption(text, 10, 0);
	text = hoa_system.Translate("Your help would be great!");
	dialogue:AddOption(text, 12, 0);
	--No
	text = hoa_system.Translate("Oh good. I was worried you were. Please tell me if you are Claudius, just so I can know...");
	dialogue:AddText(text, 2, 9, 0, false);
	text = hoa_system.Translate("Of course, I promise.");
	dialogue:AddText(text, 1000, -1, 0, false);

	-- Rejected
	text = hoa_system.Translate("Oh....ok then. You remember to be careful.");
	dialogue:AddText(text, 2, 11, 0, false);
	text = hoa_system.Translate("I will Laila.");
	dialogue:AddText(text, 1000, -1, 0, false);

	-- Add to party
	text = hoa_system.Translate("Great, I'll be sure to help you any way I can.");
	dialogue:AddText(text, 2, 13, 1, false); -- Laila added to party and map sprite removed
	text = hoa_system.Translate("Laila has joined the party.");
	dialogue:AddText(text, 2, -1, 0, false);

	laila:AddDialogueReference(1);
	dialogue_supervisor:AddDialogue(dialogue);

	-- Add Laila's movement events (up and down)
	event = hoa_map.AnimateSpriteEvent(10001, laila);
	event:AddFrame(hoa_map.MapMode.ANIM_STANDING_WEST, 1000);
	event:AddFrame(hoa_map.MapMode.ANIM_STANDING_NORTH, 1000);
	event:AddFrame(hoa_map.MapMode.ANIM_STANDING_EAST, 1000);
	event:AddFrame(hoa_map.MapMode.ANIM_STANDING_NORTH, 1000);
	event:AddFrame(hoa_map.MapMode.ANIM_STANDING_WEST, 1000);
	event:AddEventLink(10002, false, 0);
	event_supervisor:RegisterEvent(event);
	event = hoa_map.PathMoveSpriteEvent(10002, laila, 105, 44);
	event:AddEventLink(10003, false, 0);
	event_supervisor:RegisterEvent(event);
	event = hoa_map.AnimateSpriteEvent(10003, laila);
	event:AddFrame(hoa_map.MapMode.ANIM_STANDING_WEST, 1000);
	event:AddFrame(hoa_map.MapMode.ANIM_STANDING_SOUTH, 1000);
	event:AddFrame(hoa_map.MapMode.ANIM_STANDING_EAST, 1000);
	event:AddFrame(hoa_map.MapMode.ANIM_STANDING_SOUTH, 1000);
	event:AddFrame(hoa_map.MapMode.ANIM_STANDING_WEST, 1000);
	event:AddEventLink(10004, false, 0);
	event_supervisor:RegisterEvent(event);
	event = hoa_map.PathMoveSpriteEvent(10004, laila, 105, 32);
	event:AddEventLink(10001, false, 0);
	event_supervisor:RegisterEvent(event);

	map:AddGroundObject(laila);


	-- Add NPC Marcus
	sprite = ConstructSprite("Marcus", 3, 40, 35, 0.7, 0.2);

	-- Add Marcus Dialogue
	dialogue = hoa_map.MapDialogue(2);

	text = hoa_system.Translate("Hey there son, how's the training going?");
	dialogue:AddText(text, 3, 1, 0, false);
	text = hoa_system.Translate("Pretty well. The enemies in the cave aren't too tough.");
	dialogue:AddText(text, 1000, 2, 0, false);
	text = hoa_system.Translate("Good to hear. Don't let your guard down though. The deeper you go into that cave, the more likely it is that you'll face stronger opponents.");
	dialogue:AddText(text, 3, -1, 0, false);

	dialogue_supervisor:AddDialogue(dialogue);
	sprite:AddDialogueReference(2);

	-- Add Marcus movement events
	event = hoa_map.PathMoveSpriteEvent(10005, sprite, 50, 35);
	event:AddEventLink(10006, false, 0);
	event_supervisor:RegisterEvent(event);
	event = hoa_map.PathMoveSpriteEvent(10006, sprite, 40, 35);
	event:AddEventLink(10007, false, 0);
	event_supervisor:RegisterEvent(event);
	event = hoa_map.PathMoveSpriteEvent(10007, sprite, 88, 26);
	event:AddEventLink(10005, false, 0);
	event_supervisor:RegisterEvent(event);

	map:AddGroundObject(sprite);

	
	-- Add NPC Vanica
	sprite = ConstructSprite("Vanica", 4, 38, 60);

	-- Add Vanica's Dialogue #1
	dialogue = hoa_map.MapDialogue(3);
	dialogue:SetMaxViews(1);
	text = hoa_system.Translate("Oh, Claudius? You seemed puzzled.");
	dialogue:AddText(text, 4, 1, 0, false);
	text = hoa_system.Translate("There are odd little icons above people's heads. What do they mean?");
	dialogue:AddText(text, 1000, 2, 0, false);
	text = hoa_system.Translate("That is a new dialogue indicator. Any person that has something new to say that you haven't already heard will have that icon above their head. Once you've listened to everything that they have to say, the icon will disappear.");
	dialogue:AddText(text, 4, -1, 0, false);
	dialogue_supervisor:AddDialogue(dialogue);

	-- Add Vanica's Dialogue #2
	dialogue = hoa_map.MapDialogue(4);
	text = hoa_system.Translate("And remember that a person may have more thing to say, so if the icon doesn't disappear after speaking to a person, speak to them once more.");
	dialogue:AddText(text, 4, -1, 0, false);
	dialogue_supervisor:AddDialogue(dialogue);

	sprite:AddDialogueReference(3);
	sprite:AddDialogueReference(4);

	-- Add Vanica's movement events
	event = hoa_map.PathMoveSpriteEvent(10008, sprite, 38, 38);
	event:AddEventLink(10009, false, 0);
	event_supervisor:RegisterEvent(event);
	event = hoa_map.PathMoveSpriteEvent(10009, sprite, 38, 60);
	event:AddEventLink(10010, false, 0);
	event_supervisor:RegisterEvent(event);
	event = hoa_map.PathMoveSpriteEvent(10010, sprite, 35, 48);
	event:AddEventLink(10008, false, 0);
	event_supervisor:RegisterEvent(event);

	map:AddGroundObject(sprite);


	-- Add NPC Alexander
	sprite = ConstructSprite("Alexander", 5, 52, 35);

	-- Add Alexander's dialogue
	dialogue = hoa_map.MapDialogue(5);
	text = hoa_system.Translate("Choose your target wisely in battle. Its best to single out and take down one foe at a time. And don't be afraid to use a healing potion or two in battle if you're feeling weak.");
	dialogue:AddText(text, 5, -1, 12000, false);
	dialogue_supervisor:AddDialogue(dialogue);
	sprite:AddDialogueReference(5);

	-- Add Alexander's sound event
	event = hoa_map.SoundEvent(12000, "snd/coins.wav");
	event_supervisor:RegisterEvent(event);

	-- Add Alexander's movement events
	-- TEMP: path movement disabled temporarily for testing of new map mode features
--[[
	event = hoa_map.PathMoveSpriteEvent(10011, sprite, 52, 25);
	event:AddEventLink(10012, false, 0);
	event_supervisor:RegisterEvent(event);
	event = hoa_map.PathMoveSpriteEvent(10012, sprite, 52, 55);
	event:AddEventLink(10013, false, 0);
	event_supervisor:RegisterEvent(event);
	event = hoa_map.PathMoveSpriteEvent(10013, sprite, 31, 25);
	event:AddEventLink(10014, false, 0);
	event_supervisor:RegisterEvent(event);
	event = hoa_map.PathMoveSpriteEvent(10014, sprite, 40, 55);
	event:AddEventLink(10011, false, 0);
	event_supervisor:RegisterEvent(event);
--]]
	map:AddGroundObject(sprite);


	-- Add NPC Laine
	sprite = ConstructSprite("Laine", 6, 84, 57);
	sprite:SetContext(2);

	-- Add Laine's Dialogue
	dialogue = hoa_map.MapDialogue(6);
	text = hoa_system.Translate("The interior of my home is finally finished. Not too bad is it?");
	dialogue:AddText(text, 6, 1, 0, false);
	text = hoa_system.Translate("After its fully furnished I'm sure it will look quite nice.");
	dialogue:AddText(text, 1000, -1, 0, false);
	dialogue_supervisor:AddDialogue(dialogue);
	sprite:AddDialogueReference(6);

	-- Add Laine's movement events
	event = hoa_map.PathMoveSpriteEvent(10015, sprite, 94, 57);
	event:AddEventLink(10016, false, 0);
	event_supervisor:RegisterEvent(event);
	event = hoa_map.AnimateSpriteEvent(10016, sprite);
	event:AddFrame(hoa_map.MapMode.ANIM_STANDING_EAST, 1500);
	event:AddFrame(hoa_map.MapMode.ANIM_STANDING_NORTH, 8500);
	event:AddEventLink(10017, false, 0);
	event_supervisor:RegisterEvent(event);
	event = hoa_map.PathMoveSpriteEvent(10017, sprite, 84, 57);
	event:AddEventLink(10018, false, 0);
	event_supervisor:RegisterEvent(event);
	event = hoa_map.AnimateSpriteEvent(10018, sprite);
	event:AddFrame(hoa_map.MapMode.ANIM_STANDING_WEST, 2000);
	event:AddFrame(hoa_map.MapMode.ANIM_STANDING_SOUTH, 4000);
	event:AddFrame(hoa_map.MapMode.ANIM_STANDING_NORTH, 4000);
	event:AddEventLink(10016, false, 0);
	event_supervisor:RegisterEvent(event);

	map:AddGroundObject(sprite);


	-- Add NPC Torl
	sprite = ConstructSprite("Torl", 7, 40, 20);

	-- Add Torl's Dialogue
	dialogue = hoa_map.MapDialogue(7);
	text = hoa_system.Translate("This village is boring! There's no one I can play with here!");
	dialogue:AddText(text, 7, -1, 0, false);
	dialogue_supervisor:AddDialogue(dialogue);
	sprite:AddDialogueReference(7);

	-- Add Torl's movement event (moving very fast)
	event = hoa_map.RandomMoveSpriteEvent(10019, sprite, 10000, 2000);
	event:AddEventLink(10019, false, 0);
	event_supervisor:RegisterEvent(event);

	map:AddGroundObject(sprite);


	-- Add NPC Female Merchant
	sprite = ConstructSprite("Female Merchant", 8, 10, 50);
	sprite:SetContext(2);

	-- Add Female Merchant's Dialogue
	dialogue = hoa_map.MapDialogue(8);
	text = hoa_system.Translate("I have merchandise for sale at affordable prices. Take a look.");
	dialogue:AddText(text, 8, -1, 2, false); -- Go to shop mode
	dialogue_supervisor:AddDialogue(dialogue);
	sprite:AddDialogueReference(8);

	-- Add Female Merchant's movemnt events (turning from side to side)
	event = hoa_map.AnimateSpriteEvent(10020, sprite);
	event:AddFrame(hoa_map.MapMode.ANIM_STANDING_WEST, 1250);
	event:AddFrame(hoa_map.MapMode.ANIM_STANDING_SOUTH, 2500);
	event:AddFrame(hoa_map.MapMode.ANIM_STANDING_EAST, 1250);
	event:AddFrame(hoa_map.MapMode.ANIM_STANDING_SOUTH, 2500);
	event:SetLoopCount(-1);
	event:AddEventLink(10020, false, 0);
	event_supervisor:RegisterEvent(event);

	map:AddGroundObject(sprite);


	-- Add Livia
	sprite = ConstructSprite("Livia", 9, 32, 29);

	-- Add Livia's Dialogue
	dialogue = hoa_map.MapDialogue(9);
	text = hoa_system.Translate("I'm looking for my brother Torl. I sure hope he doesn't get into any trouble.");
	dialogue:AddText(text, 9, -1, 0, false);
	dialogue_supervisor:AddDialogue(dialogue);
	sprite:AddDialogueReference(9);

	-- Add Livia's movement events
	event = hoa_map.RandomMoveSpriteEvent(10021, sprite, 10000, 2000);
	event:AddEventLink(10021, false, 0);
	event_supervisor:RegisterEvent(event);

	map:AddGroundObject(sprite);


	-- Add NPC Octavia
	sprite = ConstructSprite("Octavia", 10, 9, 35);

	-- Add Octavia's dialogue
	dialogue = hoa_map.MapDialogue(10);
	text = hoa_system.Translate("So much work to do!");
	dialogue:AddText(text, 10, -1, 0, false);
	dialogue_supervisor:AddDialogue(dialogue);
	sprite:AddDialogueReference(10);

	-- Add Octavia's movement events
	event = hoa_map.RandomMoveSpriteEvent(10022, sprite, 10000, 2000);
	event:AddEventLink(10022, false, 0);
	event_supervisor:RegisterEvent(event);

	map:AddGroundObject(sprite);


	-- Add a treasure near the town''s exit zone
	chest = hoa_map.MapTreasure("img/misc/chest1.png", 4);
	chest:SetObjectID(11);
	chest:SetContext(1);
	chest:SetXPosition(111, 0);
	chest:SetYPosition(34, 0);
	chest:AddDrunes(100);
	chest:AddObject(1, 2); -- Adds 2 Healing Potions
	-- Objects below this line were added for testing purposes
	chest:AddObject(30001, 1);
	chest:AddObject(30002, 1);
	chest:AddObject(30501, 1);
	chest:AddObject(20001, 1);
	chest:AddObject(20002, 1);
	chest:AddObject(20501, 1);
	map:AddGroundObject(chest);

	-- Add a treasure inside the merchant''s house
	chest = hoa_map.MapTreasure("img/misc/chest1.png", 4);
	chest:SetObjectID(12);
	chest:SetContext(2);
	chest:SetXPosition(8, 0);
	chest:SetYPosition(52, 0);
	chest:AddDrunes(400);
	map:AddGroundObject(chest);

	


	-- Create a zone for exiting the map, to be used as a trigger
	exit_zone = hoa_map.MapZone();
	-- Add a section to the zone that goes from (20, 10) to (50, 40) in map grid coordinates
	exit_zone:AddSection(hoa_map.ZoneSection(118, 30, 119, 40));
	map:AddZone(exit_zone);

	-- Create two zones for switching the map context
	context_zone = hoa_map.ContextZone(1, 2);
	context_zone:AddSection(hoa_map.ZoneSection(92, 70, 95, 72), false);
	context_zone:AddSection(hoa_map.ZoneSection(92, 73, 95, 74), true);
	context_zone:AddSection(hoa_map.ZoneSection(90, 70, 91, 73), true);
	context_zone:AddSection(hoa_map.ZoneSection(96, 70, 97, 73), true);
	map:AddZone(context_zone);

	context_zone = hoa_map.ContextZone(1, 2);
	context_zone:AddSection(hoa_map.ZoneSection(10, 60, 13, 62), false);
	context_zone:AddSection(hoa_map.ZoneSection(10, 63, 13, 64), true);
	context_zone:AddSection(hoa_map.ZoneSection(8, 60, 9, 62), true);
	context_zone:AddSection(hoa_map.ZoneSection(14, 60, 15, 62), true);
	map:AddZone(context_zone);

	event_supervisor:StartEvent(10001);
	event_supervisor:StartEvent(10005);
	event_supervisor:StartEvent(10008);
	event_supervisor:StartEvent(10011);
	event_supervisor:StartEvent(10015);
	event_supervisor:StartEvent(10019);
	event_supervisor:StartEvent(10020);
	event_supervisor:StartEvent(10021);
	event_supervisor:StartEvent(10022);

	event = hoa_map.ScriptedEvent(1, 1, 0);
	event_supervisor:RegisterEvent(event);
	event = hoa_map.ScriptedEvent(2, 2, 0);
	event_supervisor:RegisterEvent(event);

	event = hoa_map.MapTransitionEvent(22111, "dat/maps/demo_cave.lua");
	event_supervisor:RegisterEvent(event);
end -- function Load()


function Update()
	-- Check if the map camera is in the exit zone
	if (exit_zone:IsInsideZone(map.camera.x_position, map.camera.y_position) == true) then
		if (event_supervisor:IsEventActive(22111) == false) then
			event_supervisor:StartEvent(22111);
		end
	end
end


-- Add dialogue functions

-- Adds Laila to the party and removes her sprite from the map
map_functions[1] = function()
	if (map.map_event_group:DoesEventExist("laila_joined") == false) then
		map.map_event_group:AddNewEvent("laila_joined", 1);
		GlobalManager:AddCharacter(LAILA);
	end

	laila:SetVisible(false);
	laila:SetNoCollision(true);
	laila:SetUpdatable(false);
end

-- Creates a new shop mode instance
map_functions[2] = function()
	LoadNewShop(1, 4, 3001, 3002, 10002, 10502, 20002, 30002, 40002, 50502);
end
