local ns = {}
setmetatable(ns, {__index = _G})
demo_cave = ns;
setfenv(1, ns);

-- The map name and location graphic
map_name = "Cave"
location_filename = "desert_cave.png"

enemy_ids = { 1, 2, 3, 4, 5, 101, 102, 103, 104, 105, 106 }

-- Allacrost map editor begin. Do not edit this line. --

-- A reference to the C++ MapMode object that was created with this file
map = {}
dialogue_supervisor = {}

-- The number of rows and columns of tiles that compose the map
num_map_contexts = 1
num_tile_cols = 40
num_tile_rows = 60

-- The sound files used on this map.
sound_filenames = {}

-- The music files used as background music on this map.
music_filenames = {}
music_filenames[1] = "mus/Venturing_Dragons_in_the_Dark.ogg"

-- The names of the contexts used to improve Editor user-friendliness
context_names = {}

-- The names of the tilesets used, with the path and file extension omitted
tileset_filenames = {}
tileset_filenames[1] = "desert_cave_ground"
tileset_filenames[2] = "desert_cave_walls"
tileset_filenames[3] = "desert_cave_walls2"
tileset_filenames[4] = "desert_cave_water"

-- The map grid to indicate walkability. The size of the grid is 4x the size of the tile layer tables
-- Walkability status of tiles for 32 contexts. Zero indicates walkable. Valid range: [0:2^32-1]
map_grid = {}
map_grid[0] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[1] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[2] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[3] = { 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[4] = { 0, 0, 0, 0, 1, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[5] = { 0, 0, 0, 0, 1, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[6] = { 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[7] = { 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1 }
map_grid[8] = { 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1 }
map_grid[9] = { 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1 }
map_grid[10] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1 }
map_grid[11] = { 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1 }
map_grid[12] = { 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1 }
map_grid[13] = { 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1 }
map_grid[14] = { 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1 }
map_grid[15] = { 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 1, 1, 1 }
map_grid[16] = { 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1 }
map_grid[17] = { 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1 }
map_grid[18] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1 }
map_grid[19] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[20] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1 }
map_grid[21] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1 }
map_grid[22] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[23] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[24] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1 }
map_grid[25] = { 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1 }
map_grid[26] = { 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1 }
map_grid[27] = { 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1 }
map_grid[28] = { 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1 }
map_grid[29] = { 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1 }
map_grid[30] = { 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[31] = { 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[32] = { 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0 }
map_grid[33] = { 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0 }
map_grid[34] = { 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0 }
map_grid[35] = { 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0 }
map_grid[36] = { 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0 }
map_grid[37] = { 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0 }
map_grid[38] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 1, 1 }
map_grid[39] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 1, 1 }
map_grid[40] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0 }
map_grid[41] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0 }
map_grid[42] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0 }
map_grid[43] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0 }
map_grid[44] = { 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1 }
map_grid[45] = { 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1 }
map_grid[46] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[47] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1 }
map_grid[48] = { 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1 }
map_grid[49] = { 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1 }
map_grid[50] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1 }
map_grid[51] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1 }
map_grid[52] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[53] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[54] = { 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0 }
map_grid[55] = { 0, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0 }
map_grid[56] = { 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[57] = { 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[58] = { 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[59] = { 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[60] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[61] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[62] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1 }
map_grid[63] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1 }
map_grid[64] = { 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1 }
map_grid[65] = { 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1 }
map_grid[66] = { 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0 }
map_grid[67] = { 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0 }
map_grid[68] = { 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0 }
map_grid[69] = { 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1 }
map_grid[70] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1 }
map_grid[71] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[72] = { 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1 }
map_grid[73] = { 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[74] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0 }
map_grid[75] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0 }
map_grid[76] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0 }
map_grid[77] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0 }
map_grid[78] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1 }
map_grid[79] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0 }
map_grid[80] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1 }
map_grid[81] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1 }
map_grid[82] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0 }
map_grid[83] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0 }
map_grid[84] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0 }
map_grid[85] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0 }
map_grid[86] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0 }
map_grid[87] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0 }
map_grid[88] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0 }
map_grid[89] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0 }
map_grid[90] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0 }
map_grid[91] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0 }
map_grid[92] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1 }
map_grid[93] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1 }
map_grid[94] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1 }
map_grid[95] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1 }
map_grid[96] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1 }
map_grid[97] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 }
map_grid[98] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[99] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1 }
map_grid[100] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0 }
map_grid[101] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0 }
map_grid[102] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0 }
map_grid[103] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0 }
map_grid[104] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0 }
map_grid[105] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0 }
map_grid[106] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0 }
map_grid[107] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0 }
map_grid[108] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0 }
map_grid[109] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0 }
map_grid[110] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0 }
map_grid[111] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0 }
map_grid[112] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0 }
map_grid[113] = { 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0 }
map_grid[114] = { 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0 }
map_grid[115] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0 }
map_grid[116] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 0, 1, 1, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[117] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[118] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[119] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 }

-- The lower tile layer. The numbers are indeces to the tile_mappings table.
lower_layer = {}
lower_layer[0] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
lower_layer[1] = { 23, 23, 23, 23, 23, 23, 23, 27, 23, 23, 23, 24, 16, 1, 0, 22, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, -1 }
lower_layer[2] = { -1, -1, 23, 23, 27, 28, 3, 4, 5, 3, 4, 40, 32, 6, 8, 38, 4, 5, 27, 23, 11, 42, 42, 23, 41, 3, 4, 5, 10, 41, 23, 42, 11, 23, 41, 43, 23, 41, 23, -1 }
lower_layer[3] = { -1, -1, 23, 23, 42, 23, 19, 6, 3, 40, 2, 6, 8, 38, 40, 1, 20, 22, 26, 41, 23, 23, 3, 4, 4, 5, 36, 37, 9, 219, 42, 41, 23, 25, 23, 42, 11, 23, 42, -1 }
lower_layer[4] = { -1, -1, 23, 23, 23, 23, 36, 37, 19, 6, 7, 23, 40, 2, 0, 17, 18, 38, 5, 12, 42, 3, 4, 6, 8, 21, 23, 43, 222, 235, 223, 221, 220, 27, 25, 9, 10, 41, 23, -1 }
lower_layer[5] = { -1, -1, -1, 23, 23, 23, 23, 23, 35, 37, 28, 35, 8, 1, 2, 6, 7, 8, 22, 41, 25, 35, 36, 38, 40, 38, 23, 222, 238, 251, 239, 237, 236, 187, 27, 9, 42, 23, 23, -1 }
lower_layer[6] = { -1, -1, -1, -1, 80, -1, -1, -1, -1, 80, -1, -1, 35, 7, 7, 37, 26, 35, 37, 43, 23, 23, 35, 36, 8, 6, 188, 238, 254, -1, 255, 253, 252, 223, 221, 27, 41, 42, 23, -1 }
lower_layer[7] = { -1, -1, -1, -1, 80, -1, -1, -1, -1, 80, -1, -1, -1, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 254, -1, -1, -1, -1, 80, 239, 237, 42, 23, 221, 23, -1 }
lower_layer[8] = { -1, -1, -1, -1, 80, -1, -1, -1, -1, 80, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 23, 23, 174, -1, -1, 156, 205, 202, 23, 23, 188, 237, 187, -1 }
lower_layer[9] = { -1, 23, 23, 23, 80, 23, 23, 23, 23, 80, 23, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 23, 23, 188, 111, 80, 187, 41, 23, 41, 23, 222, 253, 171, -1 }
lower_layer[10] = { -1, -1, 23, 23, 23, 23, 44, 41, 23, 23, 23, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 23, 222, 156, 205, 43, 23, 11, 43, 188, 238, 111, 235, 23 }
lower_layer[11] = { -1, -1, 23, 23, 23, 41, 10, 11, 23, 23, 23, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 188, 238, 223, 25, 23, 10, 44, 41, 10, 254, 80, 251, 23 }
lower_layer[12] = { 23, 23, 23, 23, 23, 23, 41, 23, 41, 23, 23, -1, -1, -1, -1, -1, -1, 23, 23, -1, -1, -1, -1, -1, -1, -1, -1, 188, 254, 239, 187, 12, 43, 11, 23, 42, 10, 205, 205, 23 }
lower_layer[13] = { -1, -1, 23, 23, 12, 43, 12, 23, 27, 28, 12, 23, -1, -1, -1, 23, 23, 42, 41, 23, -1, -1, -1, -1, -1, -1, -1, 172, 80, 255, 204, 23, 3, 4, 4, 4, 41, 23, 23, 23 }
lower_layer[14] = { -1, -1, 23, 23, 42, 43, 10, 42, 25, 23, 12, 23, -1, -1, -1, 23, 23, 23, 11, 23, -1, -1, -1, -1, -1, -1, -1, 23, 205, 11, 42, 12, 19, 6, 8, 1, 38, 23, 23, 23 }
lower_layer[15] = { -1, -1, 23, 23, 23, 11, 42, 41, 41, 42, 41, 23, -1, -1, -1, 23, 23, 41, 23, 23, -1, -1, -1, -1, -1, -1, -1, 23, 23, 23, 41, 10, 19, 38, 40, 0, 2, 21, 23, 23 }
lower_layer[16] = { -1, -1, 23, 23, 42, 41, 23, 25, 23, 11, 23, 23, 23, -1, -1, 23, 23, 12, 41, 23, -1, -1, -1, -1, -1, -1, -1, 4, 4, 4, 5, 23, 40, 2, 1, 0, 6, 23, 23, 23 }
lower_layer[17] = { -1, -1, 23, 23, 41, 10, 41, 43, 41, 23, 12, 23, 23, -1, -1, 23, 23, 23, 44, 23, 23, -1, -1, -1, -1, -1, -1, 0, 768, 770, 38, 19, 2, 768, 769, 770, 21, 43, 41, 41 }
lower_layer[18] = { -1, -1, -1, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 11, 23, 23, 23, -1, -1, -1, -1, -1, -1, 0, 784, 786, 6, 24, 1, 784, 785, 786, 21, 23, 41, 23 }
lower_layer[19] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, 23, 23, 43, 42, 23, 43, 23, 44, 41, 41, 23, 23, -1, -1, -1, -1, -1, -1, 0, 784, 786, 38, 40, 2, 800, 801, 802, 21, 25, 41, 23 }
lower_layer[20] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, 23, 23, 23, 23, 25, 23, 41, 11, 10, 23, 23, 23, 23, 23, 23, 23, -1, -1, 0, 784, 780, 770, 0, 0, 6, 36, 24, 22, 23, 41, 23 }
lower_layer[21] = { -1, -1, -1, -1, -1, -1, -1, 23, 23, 23, 23, 23, 11, 23, 42, 12, 23, 23, 41, 23, 23, 23, 23, 23, 23, -1, -1, 23, 800, 785, 780, 770, 6, 37, 23, 35, 37, 12, 41, 41 }
lower_layer[22] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, 23, 23, 23, 23, 41, 23, 27, 23, 25, 23, 23, 23, 23, 23, 23, 23, -1, -1, 23, 0, 800, 801, 802, 22, 23, 23, 23, 23, 10, 23, 41 }
lower_layer[23] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 23, 23, 42, 11, 10, 27, 42, 12, 23, 23, 23, 23, 23, 23, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 23, 23, 23, 23 }
lower_layer[24] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26, 12, 23, 43, 12, 23, 23, 12, 23, 12, 23, 23, 23, 23, -1, -1, -1, -1, 23, 23, 23, 23, 23, 23, -1, 23, 44, 23, 23 }
lower_layer[25] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26, 42, 23, 42, 43, 42, 44, 25, 23, 43, 12, 23, 23, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 23, 23, 23, 23 }
lower_layer[26] = { 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 28, 12, 23, 23, 23, 23, 23, 23, 44, 11, 23, 23, 23, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 23, 23, 23, 23 }
lower_layer[27] = { 41, 42, 44, 12, 11, 23, 43, 23, 23, 23, 100, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 42, 23, 42 }
lower_layer[28] = { 25, 27, 11, 10, 44, 23, 23, 23, 23, -1, 116, 1, 2, 21, 41, 42, 43, 44, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 44, 41, 12, 41 }
lower_layer[29] = { 38, 39, 5, 26, 2, -1, 23, -1, 32, 6, 40, 20, 6, 37, 27, 25, 12, 41, 23, 23, 23, 23, 23, 23, 42, 41, 43, 23, 41, 23, 23, 23, 23, 23, 41, 43, 43, 28, 41, 23 }
lower_layer[30] = { 0, 0, 38, 5, 3, 39, 864, 1, 0, 38, 7, 8, 4, 5, 41, 23, 41, 41, 23, 42, 23, 41, 23, 23, 23, 23, 12, 42, 23, 23, 23, 23, 23, 23, 42, 12, 42, 41, 23, 23 }
lower_layer[31] = { 1, 1, 0, 38, 40, 768, 880, 769, 770, 1, 38, 23, 8, 21, 41, 41, 3, 4, 10, 11, 41, 10, 23, 23, 23, 23, 23, 41, 23, 23, 23, 23, 23, 23, 23, 23, 41, 23, 23, 23 }
lower_layer[32] = { 0, 0, 2, 1, 768, 812, 785, 785, 786, 1, 16, 6, 7, 37, 42, 19, 38, 8, 38, 23, 27, 28, 12, 23, 23, 23, 41, 41, 23, 42, 42, 41, 23, 23, 23, 41, 23, 23, -1, 23 }
lower_layer[33] = { 1, 1, 1, 0, 784, 785, 785, 785, 786, 2, 32, 22, 10, 43, 10, 35, 6, 40, 6, 43, 23, 25, 43, 11, 41, 23, 23, 23, 23, 42, 12, 43, 42, 23, 23, 23, 23, 23, 23, 42 }
lower_layer[34] = { 2, 17, 18, 2, 800, 801, 785, 785, 780, 770, 1, 22, 42, 27, 25, 25, 43, 37, 37, 42, 23, 41, 43, 10, 41, 23, 23, 23, 23, 41, 23, 25, 41, 23, 23, 23, 23, 23, 23, -1 }
lower_layer[35] = { 1, 0, 2, 1, 2, 2, 784, 785, 785, 802, 1, 22, 23, 41, 42, 42, 23, 23, 23, 42, 42, 12, 41, 42, 42, 41, 23, 41, 41, 12, 41, 44, 42, 41, 11, 42, 42, 23, -1, -1 }
lower_layer[36] = { 769, 770, 1, 0, 768, 769, 812, 785, 786, 2, 2, 38, 39, 5, 23, -1, -1, -1, -1, -1, 23, 10, 23, 23, 25, 23, 43, 43, 23, 23, 43, 43, 12, 10, 44, 23, 23, -1, -1, -1 }
lower_layer[37] = { 785, 780, 769, 769, 812, 849, 849, 849, 802, 17, 18, 1, 2, 21, 23, -1, -1, -1, -1, -1, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 10, 23, 41, 42, 43, 23, 23, -1, -1, -1 }
lower_layer[38] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 23, 12, 43, 42, 25, 23, 23, -1, -1, -1, -1 }
lower_layer[39] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 23, 41, 41, 41, 41, 27, 28, -1, 80, 80, -1 }
lower_layer[40] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, 266, 267, 262, 263, 264, 265, 266, 267, 262, 263, 264, 265, 266, 267, 23, 23, 23, -1, -1, 23, 23, 41, 11, 10, 23, 12, 43, 41, 26, 26, 23 }
lower_layer[41] = { -1, -1, -1, -1, -1, -1, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, -1, -1, 23, 23, -1, -1, 23, 23, 43, 41, 42, 10, 41, 10, 41, 23, 23, 23 }
lower_layer[42] = { -1, -1, -1, -1, -1, -1, 23, 23, 23, 23, 23, 23, 292, 23, 23, 301, 23, 23, 23, 23, 23, 23, -1, -1, 23, 23, -1, -1, 23, 23, 41, 23, 41, 25, 26, 11, 43, 41, 23, -1 }
lower_layer[43] = { -1, -1, -1, -1, -1, -1, 23, 23, 41, 23, 23, 41, 308, 23, 41, 317, 220, 221, 11, 23, 23, 23, 23, 12, 12, 23, -1, -1, 23, 23, 23, 25, 26, 41, 42, 41, 10, 23, 23, -1 }
lower_layer[44] = { -1, -1, -1, -1, -1, -1, 23, 23, 25, 10, 23, 43, 41, 12, 23, 188, 236, 237, 223, 10, 12, 26, 10, 27, 28, 11, -1, -1, 23, 23, 12, 23, 42, 42, 12, 10, 42, 41, 23, -1 }
lower_layer[45] = { -1, -1, -1, -1, -1, -1, 204, 23, 26, 12, 26, 221, 204, 220, 218, 204, 252, 253, 239, 23, 3, 5, 12, 41, 23, 41, -1, -1, 23, 23, 43, 42, 11, 23, 42, 41, 23, 23, 23, 23 }
lower_layer[46] = { -1, -1, -1, -1, -1, -1, 188, 223, 218, 219, 188, 237, 187, 173, 234, 188, 222, 156, 23, 44, 19, 21, 3, 5, 23, 10, 23, 23, 23, 26, 42, 10, 41, 41, 11, 23, 25, 23, 23, 23 }
lower_layer[47] = { -1, -1, -1, -1, -1, -1, 188, 239, 234, 173, 206, 253, 223, 218, 220, 222, 238, 223, 204, 41, 36, 37, 35, 37, 41, 23, 10, 23, 23, 23, 10, 42, 12, 23, 27, 28, 23, 43, 23, 23 }
lower_layer[48] = { -1, -1, -1, -1, -1, -1, 222, 255, 250, 250, 190, 80, 239, 234, 236, 238, 254, 239, 206, 23, 3, 5, 23, 11, 23, 23, 23, 23, 23, 10, 23, 44, 41, 10, 23, 25, 41, 44, 23, 23 }
lower_layer[49] = { -1, -1, -1, -1, -1, -1, 238, 80, 80, 156, 12, 174, 255, 250, 252, 254, 187, 23, 27, 3, 40, 38, 5, 23, 23, 23, 25, 44, 23, 23, 23, 23, 42, 10, 41, 23, 23, 23, 23, 23 }
lower_layer[50] = { -1, -1, -1, -1, -1, -1, -1, 202, 205, 23, 12, 204, 202, 205, 202, 205, 11, 12, 19, 17, 18, 6, 25, 27, 3, 4, 5, 23, 23, 23, 23, 42, 10, 27, 28, 42, 23, 23, -1, -1 }
lower_layer[51] = { -1, -1, -1, -1, -1, -1, -1, 23, 23, 11, 23, 23, 12, 41, 41, 10, 41, 23, 221, 36, 36, 37, 23, 44, 36, 36, 37, 42, 11, 23, 23, 23, 11, 23, 23, 23, 23, 23, -1, -1 }
lower_layer[52] = { -1, -1, -1, -1, -1, -1, -1, 23, 23, 23, 12, 23, 26, 41, 10, 23, 10, 222, 237, 223, 23, 23, 12, 23, 41, 25, 26, 42, 10, 23, 10, 42, 10, 23, 44, 44, 23, 23, -1, -1 }
lower_layer[53] = { -1, -1, -1, -1, -1, -1, 23, 23, 23, 23, 41, 12, 23, 44, 42, 10, 188, 238, 253, 239, 223, 218, 23, 42, 10, 27, 28, 23, 41, 23, 10, 23, 23, 219, 11, 23, 23, 23, -1, -1 }
lower_layer[54] = { -1, -1, -1, -1, -1, -1, -1, -1, 23, 12, 42, 23, 41, 10, 23, 221, 222, 254, -1, 255, 239, 234, 171, 41, 23, 11, 23, 25, 23, 12, 204, 221, 222, 235, 223, 12, 23, 23, -1, -1 }
lower_layer[55] = { -1, -1, -1, -1, -1, -1, -1, -1, 23, 23, 12, 23, 44, 23, 222, 237, 238, -1, -1, -1, 255, 250, 187, 42, 12, 42, 23, 41, 188, 223, 222, 237, 238, 251, 239, 187, 23, 23, -1, -1 }
lower_layer[56] = { -1, -1, -1, -1, -1, -1, -1, -1, 23, 23, 41, 41, 41, 188, 238, 253, 254, -1, -1, -1, -1, 156, 23, 41, 23, 10, 27, 28, 222, 239, 170, 253, 254, 158, 157, 204, 23, 23, -1, -1 }
lower_layer[57] = { -1, 27, 23, 23, 23, 23, 23, 23, 23, 44, 12, 23, 28, 26, 254, 41, 188, -1, -1, -1, -1, 187, 23, 23, 23, 23, 23, 188, 238, 255, 186, 223, 221, 222, 173, 223, 23, -1, -1, -1 }
lower_layer[58] = { 23, 27, 23, 25, 27, 28, 11, 27, 23, 23, 23, 10, 23, 23, 23, 42, 23, 174, -1, -1, -1, 223, 23, -1, -1, -1, -1, 188, 254, 111, 111, 239, 237, 238, 189, 239, -1, -1, -1, -1 }
lower_layer[59] = { 386, 27, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 12, 174, -1, -1, 239, 23, -1, -1, -1, -1, -1, -1, 111, 111, 255, 253, 254, -1, 255, -1, -1, -1, -1 }

-- The middle tile layer. The numbers are indeces to the tile_mappings table.
middle_layer = {}
middle_layer[0] = { 294, 295, 296, 297, 298, 299, 388, 389, 390, 391, 392, 393, 294, 295, 296, 297, 298, 299, 292, 293, 300, 301, 392, 393, 298, 299, 294, 295, 388, 389, 392, 393, 296, 297, 292, 293, 264, 265, 292, 293 }
middle_layer[1] = { 310, 311, 312, 313, 314, 315, 404, 405, 406, 407, 408, 409, 310, 311, 312, 313, 314, 315, 308, 289, 316, 317, 408, 409, 314, 315, 310, 311, 404, 405, 408, 409, 312, 313, 308, 337, 280, 281, 308, 309 }
middle_layer[2] = { -1, -1, -1, -1, 86, -1, -1, 66, 80, 85, 82, -1, 68, -1, -1, -1, 248, 249, 304, 305, 306, 307, -1, 86, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 352, 353, 296, 297, -1, 293 }
middle_layer[3] = { -1, -1, -1, -1, -1, 65, -1, 64, -1, 83, 67, 65, -1, 67, -1, -1, -1, -1, 320, 321, 322, 323, -1, -1, -1, -1, -1, -1, 23, -1, -1, -1, -1, -1, 368, 369, 312, 313, 308, 309 }
middle_layer[4] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 80, 336, 337, 338, 339, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[5] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 84, 352, 353, 354, 355, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[6] = { -1, -1, -1, -1, 111, -1, -1, -1, -1, 111, -1, -1, -1, -1, -1, -1, -1, -1, 368, 369, 370, 371, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[7] = { -1, -1, -1, -1, 111, -1, -1, -1, -1, 111, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 207, -1, -1, -1, -1, 111, -1, 191, -1, -1, -1, -1, -1 }
middle_layer[8] = { -1, -1, -1, -1, 111, -1, -1, -1, -1, 111, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 85, 86, -1, -1, -1, 82, -1, 67, -1, -1, -1, -1, -1 }
middle_layer[9] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 111, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[10] = { 285, 280, 281, 282, 283, -1, -1, -1, -1, 278, 279, 276, 277, -1, -1, -1, -1, 280, 281, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[11] = { 301, 296, 297, 298, 299, 548, -1, -1, -1, 294, 295, 292, 293, -1, -1, -1, 301, 296, 297, 292, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 207, 111, -1, -1 }
middle_layer[12] = { 317, 312, 313, 314, 315, 564, -1, -1, -1, 310, 311, 308, 309, -1, -1, -1, 317, 312, 313, 308, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[13] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 68, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 111, 191, -1, -1, -1, -1, -1, -1, -1, -1, 336, 337 }
middle_layer[14] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 352, 353 }
middle_layer[15] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 320, 321, -1, -1, 322, 323, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 68, -1, -1, -1, -1, -1, -1, -1, -1, 368, 369 }
middle_layer[16] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 336, 337, 426, 427, 338, 339, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 130, 134 }
middle_layer[17] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 352, 353, 442, 443, 354, 355, -1, -1, 64, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 145, -1 }
middle_layer[18] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 368, 369, 314, 315, 370, 371, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 145, 70 }
middle_layer[19] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 68, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 145, 86 }
middle_layer[20] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 336, 337, 278, 279, 276, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 86, -1, -1, -1, 145, -1 }
middle_layer[21] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 352, 353, 294, 295, 292, -1, -1, -1, -1, -1, -1, -1, -1, -1, 80, 86, -1, -1, 104, 104, 64 }
middle_layer[22] = { 328, 329, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 368, 369, 310, 311, 308, -1, -1, -1, -1, -1, -1, -1, -1, -1, 80, -1, -1, -1, 119, 120, 102 }
middle_layer[23] = { 344, 345, 319, 319, 319, 319, 319, 319, 319, -1, -1, -1, -1, -1, -1, 248, 249, -1, -1, -1, -1, 81, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 80, 135, 151, 119 }
middle_layer[24] = { 360, 361, 260, 261, 319, 319, 319, 319, 319, 377, 338, 339, -1, -1, -1, -1, 68, 83, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 135, 151 }
middle_layer[25] = { 376, 377, 276, 277, 319, 319, 319, 319, 319, 393, 354, 355, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 320, 321, 260, -1, 306, 269, -1, -1, -1, -1, -1, -1, -1, -1, 29, 30, 135 }
middle_layer[26] = { 392, 393, 292, 293, 305, 319, 319, 319, 319, 306, 370, 371, 133, 97, 100, 99, 103, 133, -1, -1, -1, -1, -1, 336, 337, 276, 277, 322, 285, 372, 373, 374, 375, 376, 377, 338, 339, 45, 46, 47 }
middle_layer[27] = { 408, 409, 308, 320, 321, 264, 265, 266, 267, 322, 323, 100, 100, 113, 116, 115, 119, 100, 103, 133, -1, 133, 133, 352, 353, 292, 337, 338, 301, 388, 389, 390, 391, 392, 393, 354, 355, 65, 80, 83 }
middle_layer[28] = { -1, -1, -1, 336, 337, 280, 281, 282, 283, 338, 339, 116, 116, 136, -1, -1, 135, 116, 120, 99, 137, 100, 103, 368, 369, 308, 353, 354, 317, 404, 405, 406, 407, 408, 409, 370, 371, -1, 67, 82 }
middle_layer[29] = { -1, -1, -1, 352, 353, 296, 297, 298, 299, 354, 355, -1, -1, -1, -1, -1, -1, -1, 135, 115, 169, 116, 119, 103, 248, 368, 369, 370, 371, 133, 133, 133, 133, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[30] = { -1, -1, -1, 368, 369, 312, -1, 314, 315, 370, 371, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 135, 119, 102, 133, -1, -1, 128, 100, 101, 100, 100, 102, -1, -1, -1, -1, -1, 133 }
middle_layer[31] = { -1, -1, 70, -1, -1, -1, 880, -1, -1, -1, -1, 39, 85, -1, -1, -1, -1, -1, 67, -1, -1, -1, -1, 135, 119, 100, 129, -1, 128, 116, 117, 115, 116, 119, 129, -1, -1, -1, 97, 101 }
middle_layer[32] = { -1, -1, 86, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 82, -1, -1, 68, -1, -1, 84, 135, 116, 145, -1, 97, 86, -1, -1, -1, 135, 104, 133, 133, 97, 112, 117 }
middle_layer[33] = { 64, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 66, 83, -1, 216, 217, -1, -1, -1, 104, 97, 113, -1, -1, -1, -1, -1, 120, 100, 100, 113, 136, -1 }
middle_layer[34] = { -1, -1, -1, 67, -1, -1, -1, -1, -1, -1, 68, -1, -1, -1, -1, -1, 84, -1, -1, -1, -1, 67, 85, 68, -1, -1, 119, 112, 136, -1, -1, -1, -1, -1, 135, 116, 116, 136, 220, 218 }
middle_layer[35] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 135, 136, -1, -1, -1, -1, -1, -1, -1, 248, 249, 222, 236, 234 }
middle_layer[36] = { -1, -1, 65, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 222, 238, 252, 250 }
middle_layer[37] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 172, 238, 254, -1, -1 }
middle_layer[38] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 188, 254, -1, -1, -1 }
middle_layer[39] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 174, 111, 111, 158 }
middle_layer[40] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 260, 261, 268, 269, 264, 265, 262, 263, 264, 265, 266, 267, 260, 261, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 205, 205, 86 }
middle_layer[41] = { -1, -1, -1, -1, -1, -1, 285, 278, 279, 282, 283, 278, 276, 277, 284, 285, 280, 281, 278, 279, 280, 281, 426, 427, 276, 277, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 130, 134 }
middle_layer[42] = { -1, -1, -1, -1, -1, 300, 301, 294, 295, 298, 299, 294, 288, 289, 290, 291, 296, 297, 294, 295, 296, 297, 442, 443, 292, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 145, 3 }
middle_layer[43] = { -1, -1, -1, -1, -1, 316, 317, 310, 311, 314, 315, 310, 304, 305, 306, 307, 312, 313, 310, 311, 312, 313, 314, 315, 308, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 145, 24 }
middle_layer[44] = { -1, -1, -1, -1, -1, -1, 423, -1, -1, 66, -1, -1, 320, 321, 322, 323, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 145, 19 }
middle_layer[45] = { -1, -1, -1, -1, -1, -1, 439, -1, 66, -1, -1, -1, 336, 337, 338, 339, 207, -1, 191, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 104, 35 }
middle_layer[46] = { -1, -1, -1, -1, -1, -1, 419, -1, -1, -1, -1, -1, 352, 353, 354, 355, 222, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 120, 103 }
middle_layer[47] = { -1, -1, -1, -1, -1, -1, 435, -1, -1, -1, -1, -1, 368, 369, 370, 371, 238, -1, -1, -1, -1, -1, -1, -1, 336, 337, 280, 281, 338, 339, -1, -1, -1, -1, -1, -1, -1, -1, 135, 119 }
middle_layer[48] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 111, -1, -1, -1, -1, 191, 207, -1, -1, -1, 80, -1, -1, 352, 353, 296, 297, 354, 355, -1, -1, -1, -1, -1, -1, -1, -1, -1, 135 }
middle_layer[49] = { -1, -1, -1, -1, -1, -1, -1, 111, 111, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 64, 84, -1, -1, 368, 369, 312, 313, 370, 371, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[50] = { -1, -1, -1, -1, -1, -1, -1, -1, 387, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 66, 65, -1, -1, -1, -1, -1, -1, 80, -1, 84, -1, -1, -1, -1, -1, 420, -1, -1, -1 }
middle_layer[51] = { -1, -1, -1, -1, -1, -1, -1, -1, 403, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 82, 86, 68, -1, -1, -1, 68, -1, 436, -1, -1, -1 }
middle_layer[52] = { -1, -1, -1, -1, -1, -1, -1, -1, 419, -1, 64, -1, -1, -1, -1, 65, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 64, -1, 66, 81, -1, -1, -1, -1, -1, -1, 384, -1, -1, -1 }
middle_layer[53] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 83, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 400, -1, -1, -1 }
middle_layer[54] = { 520, 521, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 248, 249, -1, -1, -1, -1, -1, -1, 216, 217, 67, -1, -1, -1, -1, -1, 65, -1, -1, -1, -1, 416, -1, -1, -1 }
middle_layer[55] = { 536, 537, -1, 537, -1, -1, -1, -1, -1, -1, -1, 133, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 84, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[56] = { 552, 553, 294, 295, 296, 297, 298, 299, 355, -1, -1, -1, -1, -1, -1, 191, 207, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 191, 207, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[57] = { 568, 569, 310, 311, 312, 313, 314, 315, 371, -1, -1, -1, -1, -1, 175, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
middle_layer[58] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 86, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 111, 111, -1, -1, -1, -1, 111, 111, 111, -1, -1, -1, -1 }
middle_layer[59] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 111, 111, 111, -1, -1, -1, -1 }

-- The upper tile layer. The numbers are indeces to the tile_mappings table.
upper_layer = {}
upper_layer[0] = { -1, -1, 258, 259, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 272, 273, 274, 275, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 320, 321, -1, -1, 260, 261 }
upper_layer[1] = { 380, 381, 274, 275, 70, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 232, 233, 288, -1, 290, 291, -1, 70, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 336, -1, -1, -1, 276, 277 }
upper_layer[2] = { -1, -1, 418, 419, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 292, -1 }
upper_layer[3] = { -1, -1, 434, 435, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[4] = { -1, -1, 270, 271, -1, -1, -1, -1, -1, -1, -1, -1, 258, 259, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 384, 385 }
upper_layer[5] = { -1, -1, -1, 287, 382, 580, 581, 582, 583, 415, 382, 383, 274, 275, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 400, 401 }
upper_layer[6] = { -1, -1, -1, -1, -1, 111, 111, 111, 111, -1, -1, -1, 270, 271, -1, -1, -1, -1, -1, -1, 398, -1, -1, -1, 334, -1, 258, 259, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 416, 417 }
upper_layer[7] = { -1, -1, -1, -1, -1, 111, 111, 111, 111, -1, -1, -1, 286, 287, 348, 349, 382, 383, 380, 381, 414, 415, 380, 381, 350, 351, 274, 275, 70, -1, -1, -1, -1, -1, -1, -1, -1, -1, 432, 433 }
upper_layer[8] = { -1, -1, -1, -1, -1, 111, 111, 111, 111, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 386, 387, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 420, 421 }
upper_layer[9] = { 269, 264, 265, 266, 267, 516, 517, 518, 519, 262, 263, -1, -1, -1, -1, 268, 269, 264, 265, 260, -1, -1, -1, -1, -1, -1, 402, 403, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 436, 437 }
upper_layer[10] = { -1, -1, -1, -1, -1, 532, 533, 534, 535, -1, -1, -1, -1, -1, -1, 284, 285, -1, -1, 276, 277, -1, -1, -1, -1, -1, 418, 419, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 288, 289 }
upper_layer[11] = { 398, -1, 258, 259, -1, -1, -1, -1, 551, -1, -1, -1, -1, -1, -1, 300, -1, -1, -1, -1, 293, -1, -1, -1, -1, -1, 434, 435, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 304, 305 }
upper_layer[12] = { 414, 415, 274, 275, -1, -1, -1, -1, 567, -1, -1, -1, -1, -1, -1, 316, -1, -1, -1, -1, 309, -1, -1, -1, -1, -1, 422, 423, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 320, 321 }
upper_layer[13] = { -1, -1, 418, 419, -1, -1, -1, -1, -1, -1, -1, 288, 289, -1, -1, 290, 291, -1, -1, 384, 385, -1, -1, -1, -1, -1, 438, 439, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[14] = { -1, -1, 434, 435, -1, -1, -1, -1, -1, -1, -1, 304, 305, -1, -1, 306, 307, -1, -1, 400, 401, -1, -1, -1, -1, -1, 386, 387, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[15] = { -1, -1, 422, 423, -1, -1, -1, -1, -1, -1, -1, -1, -1, 266, 267, -1, -1, -1, -1, 416, 417, -1, -1, -1, -1, -1, 402, 403, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[16] = { -1, -1, 438, 439, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 432, 433, -1, -1, -1, -1, -1, 418, 419, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[17] = { -1, -1, 270, 271, -1, -1, -1, -1, 258, 259, -1, -1, -1, -1, -1, -1, -1, -1, -1, 288, 289, -1, -1, -1, -1, -1, 434, 435, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[18] = { -1, -1, 286, 287, 380, 381, 348, 349, 274, 275, -1, -1, -1, -1, -1, -1, -1, -1, -1, 304, 305, -1, -1, -1, -1, -1, 386, 387, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[19] = { -1, -1, -1, -1, -1, -1, -1, -1, 270, 271, 258, 259, -1, -1, -1, -1, -1, -1, -1, 320, 321, 262, 263, 260, 261, -1, 402, 403, -1, -1, -1, -1, -1, -1, 70, -1, -1, -1, -1, -1 }
upper_layer[20] = { -1, -1, -1, -1, -1, -1, -1, -1, 286, 287, 274, 275, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 277, -1, 418, 419, -1, -1, -1, -1, -1, -1, 70, -1, -1, 130, -1, -1 }
upper_layer[21] = { -1, -1, -1, -1, -1, -1, -1, 319, 319, 329, 290, 291, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 293, -1, -1, 270, 271, -1, -1, -1, -1, 396, 397, 258, 259, -1, -1, -1 }
upper_layer[22] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, 319, 306, 307, -1, -1, -1, 232, 233, -1, -1, -1, -1, -1, -1, -1, 309, -1, 111, 286, 287, 380, 381, 382, 383, 412, 413, 274, 275, -1, -1, -1 }
upper_layer[23] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, 284, 322, 323, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 288, 289, -1, -1, -1, -1, 324, 325, 326, 327, 328, 329, 290, 291, 65, -1, -1 }
upper_layer[24] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, 402, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 304, 305, -1, -1, -1, -1, 340, 341, 342, 343, 344, 345, 306, 307, 13, 14, 15 }
upper_layer[25] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, 290, 291, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 356, 357, 358, 359, 360, 361, 322, 323, -1, -1, 31 }
upper_layer[26] = { -1, -1, -1, 304, -1, -1, -1, -1, -1, -1, 307, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 80, -1, -1 }
upper_layer[27] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[28] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 232, 233, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[29] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 249, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[30] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[31] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 184, 185, -1, -1, -1, 80, -1, -1, 70, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[32] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 200, 201, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[33] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[34] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 256, 257, -1, -1, -1, -1, 258, 259, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 232, 233, -1, -1, -1 }
upper_layer[35] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 272, 273, 348, 349, 382, 383, 274, 275, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[36] = { -1, -1, 398, -1, -1, -1, 334, -1, -1, -1, -1, -1, -1, -1, 302, 303, -1, -1, -1, -1, 270, 271, 398, -1, -1, -1, 334, -1, 258, 259, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[37] = { 382, 383, 414, 415, 380, 381, 350, 351, 382, 383, 380, 381, 382, 383, 318, 319, -1, -1, -1, -1, 286, 287, 414, 415, 380, 381, 350, 351, 274, 275, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[38] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 386, 387, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[39] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 402, 403, -1, -1, -1, -1, -1, -1, -1, -1, -1, 70 }
upper_layer[40] = { -1, -1, -1, -1, -1, 268, 269, 262, 263, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 422, 423, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[41] = { -1, -1, -1, -1, -1, 284, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 438, 439, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[42] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 293, -1, -1, 418, 419, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[43] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 309, -1, -1, 434, 435, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[44] = { -1, -1, -1, -1, -1, 422, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 288, 289, -1, -1, 290, 291, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[45] = { -1, -1, -1, -1, -1, 438, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 304, 305, -1, -1, 306, 307, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[46] = { -1, -1, -1, -1, -1, 418, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 320, 321, 264, 265, 322, 323, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[47] = { -1, -1, -1, -1, -1, 434, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[48] = { -1, -1, -1, -1, -1, 270, 271, 258, 259, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 70, -1, -1, -1, -1, -1, -1, -1, 256, -1, 334, -1 }
upper_layer[49] = { -1, -1, -1, -1, -1, -1, 287, 274, 275, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 86, 80, -1, -1, -1, -1, -1, -1, 272, 273, 350, 351 }
upper_layer[50] = { -1, -1, -1, -1, -1, -1, -1, 386, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 70, -1, -1, -1, -1, -1, -1, 420, 421, -1, -1 }
upper_layer[51] = { -1, -1, -1, -1, -1, -1, -1, 402, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 436, 437, -1, -1 }
upper_layer[52] = { -1, -1, -1, -1, -1, -1, -1, 418, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 184, 185, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 384, 385, -1, -1 }
upper_layer[53] = { -1, -1, -1, -1, -1, -1, 319, 306, 307, -1, -1, -1, -1, -1, -1, 232, 233, -1, -1, -1, -1, -1, -1, 200, 201, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 400, 401, -1, -1 }
upper_layer[54] = { 520, 521, 262, 263, 264, 265, 266, 267, 323, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 416, 417, -1, -1 }
upper_layer[55] = { 536, 537, 278, 279, 280, 281, 282, 283, 339, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 432, 433, -1, -1 }
upper_layer[56] = { 554, 555, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 256, 257, 258, 259, 256, 257, -1, -1, 396, 397, -1, -1, 258, 259, 256, 257, 398, -1, -1, 302, 303, -1, -1 }
upper_layer[57] = { 570, 571, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 70, -1, -1, 272, 273, 274, 275, 272, 273, 380, 381, 412, 413, 382, 383, 274, 275, 272, 273, 414, 415, 380, 318, 319, -1, -1 }
upper_layer[58] = { 586, 571, -1, -1, -1, -1, -1, -1, -1, 334, -1, 396, 397, 398, -1, -1, -1, 302, 303, 418, 291, 302, 303, -1, -1, -1, -1, -1, -1, 270, 271, 302, 303, -1, -1, -1, -1, -1, -1, -1 }
upper_layer[59] = { 287, 351, 382, 380, 381, 382, 383, 348, 349, 350, 383, 412, 413, 414, 415, 382, 383, 318, 319, 319, 418, 318, 319, -1, -1, -1, -1, -1, -1, 286, 287, 318, 319, -1, -1, -1, -1, -1, -1, -1 }

-- All, if any, existing contexts follow.
-- Allacrost map editor end. Do not edit this line. --

dialogue_text = {}
-- Dialogue #1
dialogue_text[0] = hoa_system.Translate("Claudius, what are you doing here?");
dialogue_text[1] = hoa_system.Translate("I came in this cave for training.");
dialogue_text[2] = hoa_system.Translate("Well, good job getting this far all by yourself. This is a pretty dangerous place for someone as inexperienced as yourself.");
dialogue_text[3] = hoa_system.Translate("Yes well, I have to train hard if I want to be able to spar with you evenly one day, Jonas. By the way, what were you doing?");
dialogue_text[4] = hoa_system.Translate("The cave goes deeper than this, but it appears a collapse here has blocked the way. I was trying to find an alternative passage, but it appears that the inner chambers are now completely inaccessible.");
dialogue_text[5] = hoa_system.Translate("In any case, this is as far as you can go in this demo, so thanks for.....");
dialogue_text[6] = hoa_system.Translate("Wait, what was that noise? Hey, look out!");
-- Dialogue #2
dialogue_text[7] = hoa_system.Translate("Phew, that was a shock. I've never seen such foes wandering in this cave. Nice job taking care of them Claudius, I can definitely tell that your swordsmanship has improved.");
dialogue_text[8] = hoa_system.Translate("Thank you. By the way...why didn't you fight with me in that battle?");
dialogue_text[9] = hoa_system.Translate("Ah, err...well you see, you'll never reach your full potential if you always have your seniors stepping in for you.");
dialogue_text[10] = hoa_system.Translate("I see.");
dialogue_text[11] = hoa_system.Translate("And besides, I don't even have my own battle sprite graphics yet! The development team needs more artists to help move the game along!");
dialogue_text[12] = hoa_system.Translate(".....");
-- Dialogue #3
dialogue_text[13] = hoa_system.Translate("Well, this truly is the end of the demo. Thanks for playing.");


function Load(m)
	-- First, record the current map in the "map" variable that is global to this script
	map = m;
	dialogue_supervisor = m.dialogue_supervisor;
	event_supervisor = m.event_supervisor;

	local sprite;
	local dialogue;
	local event;
	local chest;

	-- Create the player''s sprite
	sprite = hoa_map.MapSprite();
	sprite:SetName(hoa_system.Translate("Claudius"));
	sprite:SetObjectID(1000);
	sprite:SetContext(1);
	sprite:SetXPosition(5, 0.5);
	sprite:SetYPosition(118, 0.0);
	sprite:SetCollHalfWidth(0.95);
	sprite:SetCollHeight(1.9);
	sprite:SetImgHalfWidth(1.0);
	sprite:SetImgHeight(4.0);
	sprite:SetMovementSpeed(hoa_map.MapMode.NORMAL_SPEED);
	sprite:SetDirection(hoa_map.MapMode.EAST);
	sprite:LoadStandardAnimations("img/sprites/map/claudius_walk.png");
	sprite:LoadRunningAnimations("img/sprites/map/claudius_run.png");
	sprite:LoadFacePortrait("img/portraits/map/claudius.png");
	map:AddGroundObject(sprite);

	-- Set the camera to focus on the player''s sprite
	map:SetCamera(sprite);

	sprite = hoa_map.MapSprite();
	sprite:SetName(hoa_system.Translate("Jonas"));
	sprite:SetObjectID(1);
	sprite:SetContext(1);
	sprite:SetXPosition(74, 0.0);
	sprite:SetYPosition(40, 0.0);
	sprite:SetCollHalfWidth(0.95);
	sprite:SetCollHeight(1.9);
	sprite:SetImgHalfWidth(1.0);
	sprite:SetImgHeight(4.0);
	sprite:SetMovementSpeed(hoa_map.MapMode.NORMAL_SPEED);
	sprite:SetDirection(hoa_map.MapMode.SOUTH);
	sprite:LoadStandardAnimations("img/sprites/map/soldier_npc01_walk.png");

	sprite:AddDialogueReference(1);
	sprite:AddDialogueReference(2);
	sprite:AddDialogueReference(3);

	event = hoa_map.AnimateSpriteEvent(10000, sprite);
	event:AddFrame(hoa_map.MapMode.ANIM_STANDING_SOUTH, 1000);
	event:AddFrame(hoa_map.MapMode.ANIM_STANDING_WEST, 1500);
	event:AddFrame(hoa_map.MapMode.ANIM_STANDING_SOUTH, 1000);
	event:AddFrame(hoa_map.MapMode.ANIM_STANDING_EAST, 1500);
	event:SetLoopCount(-1);
	event:AddEventLink(10000, false, 0);
	event_supervisor:RegisterEvent(event);
	map:AddGroundObject(sprite);

	dialogue = hoa_map.MapDialogue(1);
	dialogue:AddText(dialogue_text[0], 1, 1, 0, false); --line 0
	dialogue:AddText(dialogue_text[1], 1000, 2, 0, false); --line 1
	dialogue:AddText(dialogue_text[2], 1, 3, 0, false); --line 2
	dialogue:AddText(dialogue_text[3], 1000, 4, 0, false); --line 3
	dialogue:AddText(dialogue_text[4], 1, 5, 0, false); --line 4
	dialogue:AddText(dialogue_text[5], 1, 6, 1, false); -- line 5: Creepy sound plays here
	dialogue:AddText(dialogue_text[6], 1, -1, 2, false); -- line 6: Boss battle occurs
	dialogue_supervisor:AddDialogue(dialogue);

	dialogue = hoa_map.MapDialogue(2);
	dialogue:AddText(dialogue_text[7], 1, 1, 0, false); --line 7
	dialogue:AddText(dialogue_text[8], 1000, 2, 0, false); --line 8
	dialogue:AddText(dialogue_text[9], 1, 3, 0, false); --line 9
	dialogue:AddText(dialogue_text[10], 1000, 4, 0, false); --line 10
	dialogue:AddText(dialogue_text[11], 1, 5, 0, false); -- line 11
	dialogue:AddText(dialogue_text[12], 1000, -1, 0, false); -- line 12
	dialogue_supervisor:AddDialogue(dialogue);

	dialogue = hoa_map.MapDialogue(3);
	dialogue:AddText(dialogue_text[13], 1, -1, 0, false); -- line 13
	dialogue_supervisor:AddDialogue(dialogue);

	-- Create an EnemyZone (2000 ms between respawns, monsters restricted to zone area)
	local ezone = hoa_map.EnemyZone(2000, true);
	-- Add a section to the zone that goes from (101, 10) to (117, 40) in map grid coordinates
	ezone:AddSection(hoa_map.ZoneSection(34, 88, 46, 96));

	-- Create a sprite representation of a monster attached to this zone
	local enemy = hoa_map.EnemySprite();
	enemy:SetObjectID(map.object_supervisor:GenerateObjectID());
	enemy:SetContext(1);
	enemy:SetCollHalfWidth(1.0);
	enemy:SetCollHeight(2.0);
	enemy:SetImgHalfWidth(1.0);
	enemy:SetImgHeight(4.0);
	enemy:SetMovementSpeed(hoa_map.MapMode.SLOW_SPEED);
	enemy:LoadStandardAnimations("img/sprites/map/scorpion_walk.png");
	enemy:NewEnemyParty();
	enemy:AddEnemy(5);
	enemy:AddEnemy(2);
	enemy:NewEnemyParty();
	enemy:AddEnemy(5);
	enemy:AddEnemy(5);
	-- Add the enemy to the zone two times (it also gets added to the ground objects) 
	ezone:AddEnemy(enemy, map, 2);

	-- Finally, add the zone to the map
	map:AddZone(ezone);


	local ezone = hoa_map.EnemyZone(2000, true);
	ezone:AddSection(hoa_map.ZoneSection(60, 76, 70, 96));

	local enemy = hoa_map.EnemySprite();
	enemy:SetObjectID(map.object_supervisor:GenerateObjectID());
	enemy:SetContext(1);
	enemy:SetCollHalfWidth(1.0);
	enemy:SetCollHeight(2.0);
	enemy:SetImgHalfWidth(1.0);
	enemy:SetImgHeight(4.0);
	enemy:SetMovementSpeed(hoa_map.MapMode.SLOW_SPEED);
	enemy:LoadStandardAnimations("img/sprites/map/scorpion_walk.png");
	enemy:NewEnemyParty();
	enemy:AddEnemy(5);
	enemy:AddEnemy(2);
	ezone:AddEnemy(enemy, map, 1);

	enemy = hoa_map.EnemySprite();
	enemy:SetObjectID(map.object_supervisor:GenerateObjectID());
	enemy:SetContext(1);
	enemy:SetCollHalfWidth(1.0);
	enemy:SetCollHeight(2.0);
	enemy:SetImgHalfWidth(1.0);
	enemy:SetImgHeight(4.0);
	enemy:SetMovementSpeed(hoa_map.MapMode.VERY_SLOW_SPEED);
	enemy:LoadStandardAnimations("img/sprites/map/slime_walk.png");
	enemy:NewEnemyParty();
	enemy:AddEnemy(1);
	enemy:AddEnemy(1);
	enemy:AddEnemy(1);
	ezone:AddEnemy(enemy, map, 1);

	map:AddZone(ezone);


	-- Create an EnemyZone (2000 ms between respawns, monsters restricted to zone area)
	local ezone = hoa_map.EnemyZone(2000, true);
	ezone:AddSection(hoa_map.ZoneSection(20, 62, 32, 72));

	local enemy = hoa_map.EnemySprite();
	enemy:SetObjectID(map.object_supervisor:GenerateObjectID());
	enemy:SetContext(1);
	enemy:SetCollHalfWidth(1.0);
	enemy:SetCollHeight(2.0);
	enemy:SetImgHalfWidth(1.0);
	enemy:SetImgHeight(4.0);
	enemy:SetMovementSpeed(hoa_map.MapMode.NORMAL_SPEED);
	enemy:LoadStandardAnimations("img/sprites/map/snake_walk.png");
	enemy:NewEnemyParty();
	enemy:AddEnemy(3);
	enemy:AddEnemy(3);
	enemy:AddEnemy(4);
	enemy:NewEnemyParty();
	enemy:AddEnemy(3);
	enemy:AddEnemy(3);
	enemy:AddEnemy(3);
	ezone:AddEnemy(enemy, map, 1);

	enemy = hoa_map.EnemySprite();
	enemy:SetObjectID(map.object_supervisor:GenerateObjectID());
	enemy:SetContext(1);
	enemy:SetCollHalfWidth(1.0);
	enemy:SetCollHeight(2.0);
	enemy:SetImgHalfWidth(1.0);
	enemy:SetImgHeight(4.0);
	enemy:SetMovementSpeed(hoa_map.MapMode.VERY_SLOW_SPEED);
	enemy:LoadStandardAnimations("img/sprites/map/slime_walk.png");
	enemy:NewEnemyParty();
	enemy:AddEnemy(1);
	enemy:AddEnemy(2);
	enemy:AddEnemy(4);
	enemy:AddEnemy(1);
	enemy:NewEnemyParty();
	enemy:AddEnemy(1);
	enemy:AddEnemy(4);
	enemy:AddEnemy(1);
	enemy:AddEnemy(3);
	ezone:AddEnemy(enemy, map, 1);
	-- Finally, add the zone to the map
	map:AddZone(ezone);


	-- Create an EnemyZone (2000 ms between respawns, monsters restricted to zone area)
	local ezone = hoa_map.EnemyZone(2000, true);
	ezone:AddSection(hoa_map.ZoneSection(8, 26, 21, 35));

	local enemy = hoa_map.EnemySprite();
	enemy:SetObjectID(map.object_supervisor:GenerateObjectID());
	enemy:SetContext(1);
	enemy:SetCollHalfWidth(1.0);
	enemy:SetCollHeight(2.0);
	enemy:SetImgHalfWidth(1.0);
	enemy:SetImgHeight(4.0);
	enemy:SetMovementSpeed(hoa_map.MapMode.NORMAL_SPEED);
	enemy:LoadStandardAnimations("img/sprites/map/scorpion_walk.png");
	enemy:NewEnemyParty();
	enemy:AddEnemy(5);
	enemy:AddEnemy(5);
	enemy:AddEnemy(4);
	enemy:AddEnemy(4);
	enemy:AddEnemy(2);
	enemy:NewEnemyParty();
	enemy:AddEnemy(5);
	enemy:AddEnemy(2);
	enemy:AddEnemy(4);
	enemy:AddEnemy(4);
	enemy:AddEnemy(5);
	enemy:AddEnemy(5);
	ezone:AddEnemy(enemy, map, 1);

	enemy = hoa_map.EnemySprite();
	enemy:SetObjectID(map.object_supervisor:GenerateObjectID());
	enemy:SetContext(1);
	enemy:SetCollHalfWidth(1.0);
	enemy:SetCollHeight(2.0);
	enemy:SetImgHalfWidth(1.0);
	enemy:SetImgHeight(4.0);
	enemy:SetMovementSpeed(hoa_map.MapMode.SLOW_SPEED);
	enemy:LoadStandardAnimations("img/sprites/map/snake_walk.png");
	enemy:NewEnemyParty();
	enemy:AddEnemy(4);
	enemy:AddEnemy(2);
	enemy:AddEnemy(2);
	enemy:AddEnemy(101);
	enemy:AddEnemy(3);
	enemy:NewEnemyParty();
	enemy:AddEnemy(3);
	enemy:AddEnemy(4);
	enemy:AddEnemy(5);
	enemy:AddEnemy(102);
	enemy:AddEnemy(4);
	ezone:AddEnemy(enemy, map, 1);
	-- Finally, add the zone to the map
	map:AddZone(ezone);


	-- Create an EnemyZone (2000 ms between respawns, monsters restricted to zone area)
	local ezone = hoa_map.EnemyZone(2000, true);
	ezone:AddSection(hoa_map.ZoneSection(44, 6, 51, 13));

	local enemy = hoa_map.EnemySprite();
	enemy:SetObjectID(map.object_supervisor:GenerateObjectID());
	enemy:SetContext(1);
	enemy:SetCollHalfWidth(1.0);
	enemy:SetCollHeight(2.0);
	enemy:SetImgHalfWidth(1.0);
	enemy:SetImgHeight(4.0);
	enemy:SetMovementSpeed(hoa_map.MapMode.SLOW_SPEED);
	enemy:LoadStandardAnimations("img/sprites/map/scorpion_walk.png");
	enemy:NewEnemyParty();
	enemy:AddEnemy(4);
	enemy:AddEnemy(1);
	enemy:AddEnemy(4);
	enemy:AddEnemy(101);
	enemy:AddEnemy(2);
	enemy:NewEnemyParty();
	enemy:AddEnemy(5);
	enemy:AddEnemy(1);
	enemy:AddEnemy(2);
	enemy:AddEnemy(4);
	enemy:AddEnemy(102);
	enemy:AddEnemy(3);
	ezone:AddEnemy(enemy, map, 1);
	-- Finally, add the zone to the map
	map:AddZone(ezone);

	-- Add a treasure about half-way through the cave
	chest = hoa_map.MapTreasure("img/misc/chest1.png", 4);
	chest:SetObjectID(500);
	chest:SetContext(1);
	chest:SetXPosition(20, 0);
	chest:SetYPosition(62, 0);
	chest:AddDrunes(175);
	chest:AddObject(1, 1); -- Adds 1 Healing Potion
	chest:AddObject(30002, 1); -- Adds 1 Leather Chain Mail
	map:AddGroundObject(chest);

	-- Add a second treasure with a few potions just before the boss encounter
	chest = hoa_map.MapTreasure("img/misc/chest1.png", 4);
	chest:SetObjectID(501);
	chest:SetContext(1);
	chest:SetXPosition(62, 0);
	chest:SetYPosition(40, 0);
	chest:AddObject(1, 3); -- Adds 3 Healing Potions
	map:AddGroundObject(chest);

	-- Create a zone for exiting the map, to be used as a trigger
	exit_zone = hoa_map.MapZone();
	-- Add a section to the zone to enable the user to exit the map
	exit_zone:AddSection(hoa_map.ZoneSection(2, 116, 4, 118));
	map:AddZone(exit_zone);

	event = hoa_map.ScriptedEvent(1, 1, 0);
	event_supervisor:RegisterEvent(event);
	event = hoa_map.ScriptedEvent(1, 2, 0);
	event_supervisor:RegisterEvent(event);

	event = hoa_map.MapTransitionEvent(22111, "dat/maps/demo_town.lua");
	event_supervisor:RegisterEvent(event);

	event_supervisor:StartEvent(10000);
end


function Update()
	-- Check if the map camera is in the exit zone
	if (exit_zone:IsInsideZone(map.camera.x_position, map.camera.y_position) == true) then
		if (event_supervisor:IsEventActive(22111) == false) then
			event_supervisor:StartEvent(22111);
		end
	end
end



function Draw()
	map:DrawMapLayers();
end


map_functions = {}

-- Empty do-nothing function for events
map_functions[0] = function()
	return true;
end

-- Plays a ground-rumbling sound
map_functions[1] = function()
	AudioManager:PlaySound("snd/rumble.wav");
end

-- Throws player into a boss battle
map_functions[2] = function()
	local enemy = hoa_map.EnemySprite();
	enemy:SetObjectID(map.object_supervisor:GenerateObjectID());
	enemy:SetContext(1);
	enemy:SetXPosition(71, 0.0);
	enemy:SetYPosition(28, 0.0);
	enemy:SetCollHalfWidth(1.0);
	enemy:SetCollHeight(2.0);
	enemy:SetImgHalfWidth(2.0);
	enemy:SetImgHeight(4.0);
	enemy:SetMovementSpeed(hoa_map.MapMode.SLOW_SPEED);
	enemy:LoadStandardAnimations("img/sprites/map/gigas_walk.png");
	enemy:NewEnemyParty();
	enemy:AddEnemy(103);
	enemy:AddEnemy(104);
	enemy:AddEnemy(105);
	enemy:AddEnemy(106);
	enemy:ChangeStateHostile();
	enemy:SetBattleMusicTheme("mus/The_Creature_Awakens.ogg");
	map:AddGroundObject(enemy); 
	local event = hoa_map.PathMoveSpriteEvent(10001, enemy, 74, 40);
	event_supervisor:RegisterEvent(event);
	event_supervisor:BeginEvent(event);
end
