/*
 * Decompiled with CFR 0.152.
 */
package xap.resources;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.util.XMLUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import xap.Game;
import xap.resources.InstructionResource;

public class HelpResource
extends Resource {
    public static final long serialVersionUID = 1L;
    private static HelpResource helpFull;
    private static HelpResource helpDemo;
    private static int current;
    private static final HashMap instructionMap;
    private InstructionResource[] instructionFeature;
    private boolean registered;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("xap.resources.HelpResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        instructionMap = new HashMap();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("xap.resources.InstructionResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        instructionMap.put("instruction", clazz2);
    }

    public HelpResource(String name) {
        super(name);
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        int i = 0;
        while (i < this.instructionFeature.length) {
            this.instructionFeature[i].create();
            ++i;
        }
    }

    protected void doDestroy() {
        super.doDestroy();
        int i = 0;
        while (i < this.instructionFeature.length) {
            this.instructionFeature[i].destroy();
            ++i;
        }
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.registered = XMLUtil.getBoolean((Element)element, (String)"registered");
        try {
            loader.pushMap((Map)instructionMap);
            NodeList childTagList = element.getChildNodes();
            if (childTagList.getLength() > 0) {
                ArrayList<Resource> children = new ArrayList<Resource>(childTagList.getLength());
                int i = 0;
                while (i < childTagList.getLength()) {
                    if (childTagList.item(i) instanceof Element) {
                        Element childElement = (Element)childTagList.item(i);
                        Resource childResource = loader.load(childElement);
                        if (!(childResource instanceof InstructionResource)) {
                            throw new Exception("Only InstructionFeatures are allowed inside the HelpFeature");
                        }
                        children.add(childResource);
                    }
                    ++i;
                }
                this.instructionFeature = new InstructionResource[children.size()];
                children.toArray(this.instructionFeature);
            }
        }
        finally {
            loader.popMap();
        }
    }

    public void register() {
        super.register();
        if (this.registered) {
            if (!$assertionsDisabled && helpFull != null) {
                throw new AssertionError((Object)"Help already specified.");
            }
            helpFull = this;
        } else {
            if (!$assertionsDisabled && helpDemo != null) {
                throw new AssertionError((Object)"Help already specified.");
            }
            helpDemo = this;
        }
    }

    public void deregister() {
        super.deregister();
        if (this.registered) {
            helpFull = null;
        } else {
            helpDemo = null;
        }
    }

    public static void reset() {
        current = -1;
    }

    private static HelpResource getHelp() {
        if (Game.isRegistered()) {
            return helpFull;
        }
        return helpDemo;
    }

    public static void next(HelpViewer viewer) {
        if (current == HelpResource.getHelp().instructionFeature.length) {
            return;
        }
        viewer.clear();
        HelpResource.getHelp().instructionFeature[++current].draw(viewer.getInstructionViewer());
    }

    public static void prev(HelpViewer viewer) {
        if (current == 0) {
            return;
        }
        viewer.clear();
        HelpResource.getHelp().instructionFeature[--current].draw(viewer.getInstructionViewer());
    }

    public static boolean hasMoreInstructions() {
        return current < HelpResource.getHelp().instructionFeature.length - 1;
    }

    public static boolean hasLessInstructions() {
        return current > 0;
    }

    public static interface HelpViewer {
        public InstructionResource.InstructionViewer getInstructionViewer();

        public void clear();
    }
}

