/*
 * Decompiled with CFR 0.152.
 */
package xap.resources;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.Util;
import com.shavenpuppy.jglib.util.XMLUtil;
import com.shavenpuppy.jglib.vector.Vector3i;
import org.w3c.dom.Element;
import xap.BattleZone;
import xap.Game;
import xap.Gidrah;
import xap.resources.HVMovement;

public class HVMovementResource
extends Resource {
    public static final long serialVersionUID = 1L;
    private static final int MARGIN = FPMath.fpValue((int)256);
    static final int MOVE_TYPE_HOMING_SHORTEST = 0;
    static final int MOVE_TYPE_HOMING_RANDOM = 1;
    static final int MOVE_TYPE_WANDERING = 2;
    private int speed;
    private int duration;
    private int type;
    private int accuracy;
    private int moveSpeedDifficultyThreshold;

    public HVMovementResource() {
    }

    public HVMovementResource(String name) {
        super(name);
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.speed = FPMath.fpValue((int)XMLUtil.getInt((Element)element, (String)"hv_movement_speed"));
        this.duration = XMLUtil.getInt((Element)element, (String)"hv_movement_duration");
        String typeS = XMLUtil.getString((Element)element, (String)"hv_movement_type");
        if (typeS.equals("wandering")) {
            this.type = 2;
        } else if (typeS.equals("homing_random")) {
            this.type = 1;
            this.accuracy = XMLUtil.getInt((Element)element, (String)"hv_movement_accuracy");
        } else if (typeS.equals("homing_shortest")) {
            this.type = 0;
        } else {
            throw new Exception("Unknown movement type " + this.type);
        }
        this.moveSpeedDifficultyThreshold = XMLUtil.getInt((Element)element, (String)"hv_movespeeddifficultythreshold", (int)0);
    }

    public HVMovement spawn(Gidrah gidrah) {
        return new HVMovementInstance(gidrah);
    }

    private class HVMovementInstance
    implements HVMovement {
        private Gidrah gidrah;
        private int tick;
        private final int adjustedSpeed;
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("xap.resources.HVMovementResource$HVMovementInstance");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        HVMovementInstance(Gidrah gidrah) {
            this.adjustedSpeed = HVMovementResource.this.speed >> (Game.getCurrentLevel() < HVMovementResource.this.moveSpeedDifficultyThreshold ? 1 : 0) << Game.getOptions().getSpeedShift();
            this.gidrah = gidrah;
        }

        public void tick() {
            Vector3i pos = this.gidrah.getPosition();
            Vector3i vel = this.gidrah.getVelocity();
            if (this.tick == 0) {
                switch (HVMovementResource.this.type) {
                    case 1: {
                        if (Util.random((int)0, (int)100) < HVMovementResource.this.accuracy) {
                            Vector3i playerPos = Game.getPlayer().getLastKnownPosition();
                            if (Util.random((int)0, (int)1) == 0) {
                                if (pos.getX() < playerPos.getX()) {
                                    vel.set(this.adjustedSpeed, 0, 0);
                                    break;
                                }
                                vel.set(-this.adjustedSpeed, 0, 0);
                                break;
                            }
                            if (pos.getY() < playerPos.getY()) {
                                vel.set(0, this.adjustedSpeed, 0);
                                break;
                            }
                            vel.set(0, -this.adjustedSpeed, 0);
                            break;
                        }
                        int mul = (Util.random((int)0, (int)1) << 1) - 1;
                        if (Util.random((int)0, (int)1) == 0) {
                            vel.set(this.adjustedSpeed * mul, 0, 0);
                            break;
                        }
                        vel.set(0, this.adjustedSpeed * mul, 0);
                        break;
                    }
                    case 0: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                        break;
                    }
                    case 2: {
                        if (pos.getX() < MARGIN) {
                            vel.set(this.adjustedSpeed, 0, 0);
                            break;
                        }
                        if (pos.getX() > BattleZone.FPWIDTH - MARGIN) {
                            vel.set(-this.adjustedSpeed, 0, 0);
                            break;
                        }
                        if (pos.getY() < MARGIN) {
                            vel.set(0, this.adjustedSpeed, 0);
                            break;
                        }
                        if (pos.getY() > BattleZone.FPHEIGHT - MARGIN) {
                            vel.set(0, -this.adjustedSpeed, 0);
                            break;
                        }
                        int mul = (Util.random((int)0, (int)1) << 1) - 1;
                        if (Util.random((int)0, (int)1) == 0) {
                            vel.set(this.adjustedSpeed * mul, 0, 0);
                            break;
                        }
                        vel.set(0, this.adjustedSpeed * mul, 0);
                        break;
                    }
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                        break;
                    }
                }
                this.tick = HVMovementResource.this.duration >> Game.getOptions().getSpeedShift();
            }
            --this.tick;
            pos.translate(vel.getX(), vel.getY(), 0);
        }
    }
}

