/*
 * Decompiled with CFR 0.152.
 */
package xap.particles;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.interpolators.Interpolator;
import com.shavenpuppy.jglib.interpolators.InterpolatorBase;
import com.shavenpuppy.jglib.resources.ColorSequenceResource;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.Util;
import com.shavenpuppy.jglib.util.XMLUtil;
import com.shavenpuppy.jglib.vector.Vector3i;
import org.lwjgl.util.Color;
import org.w3c.dom.Element;
import xap.ParticleMovement;
import xap.ParticleSpawning;
import xap.features.ParticleFeature;
import xap.particles.SpriteParticleFeature;
import xap.resources.ParticleMovementResource;
import xap.resources.ParticleSpawningResource;

public class SimpleSpriteParticleFeature
extends SpriteParticleFeature {
    public static final long serialVersionUID = 1L;
    protected static final Vector3i tempVector = new Vector3i();
    protected static final Color tempColor = new Color();
    protected String colorSequence;
    protected int initialSizeRange;
    protected int initialSize;
    protected int finalSize;
    protected String sizeInterpolator;
    protected ParticleMovementResource movementFeature;
    protected ParticleSpawningResource spawningFeature;
    protected transient ColorSequenceResource colorSequenceResource;
    protected transient Interpolator sizeInterpolatorInstance;

    public SimpleSpriteParticleFeature() {
    }

    public SimpleSpriteParticleFeature(String name) {
        super(name);
    }

    protected ParticleFeature.ParticleInstance createParticle() {
        return new SimpleSpriteParticleInstance();
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.sizeInterpolator = XMLUtil.getString((Element)element, (String)"sizeinterpolator", null);
        if (this.sizeInterpolator != null) {
            this.initialSizeRange = FPMath.fpValue((float)XMLUtil.getFloat((Element)element, (String)"initialsizerange", (float)0.0f));
            this.initialSize = FPMath.fpValue((float)XMLUtil.getFloat((Element)element, (String)"initialsize"));
            this.finalSize = FPMath.fpValue((float)XMLUtil.getFloat((Element)element, (String)"finalsize"));
        }
        this.colorSequence = XMLUtil.getString((Element)element, (String)"colorsequence", null);
        this.movementFeature = new ParticleMovementResource();
        this.movementFeature.load(element, loader);
        this.spawningFeature = new ParticleSpawningResource();
        this.spawningFeature.load(element, loader);
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        if (this.sizeInterpolator != null) {
            this.sizeInterpolatorInstance = InterpolatorBase.decode((String)this.sizeInterpolator);
        }
        if (this.colorSequence != null) {
            this.colorSequenceResource = (ColorSequenceResource)Resources.get((String)this.colorSequence);
        }
    }

    protected class SimpleSpriteParticleInstance
    extends SpriteParticleFeature.SpriteParticleInstance {
        private final ParticleMovement movement;
        private final ParticleSpawning spawning;
        private final int startSize;
        private final int endSize;

        protected SimpleSpriteParticleInstance() {
            super(SimpleSpriteParticleFeature.this);
            this.movement = SimpleSpriteParticleFeature.this.movementFeature.spawn();
            this.spawning = SimpleSpriteParticleFeature.this.spawningFeature.spawn();
            this.startSize = SimpleSpriteParticleFeature.this.initialSize + Util.random((int)(-SimpleSpriteParticleFeature.this.initialSizeRange >> 1), (int)(SimpleSpriteParticleFeature.this.initialSizeRange >> 1));
            this.endSize = SimpleSpriteParticleFeature.this.finalSize + Util.random((int)(-SimpleSpriteParticleFeature.this.initialSizeRange >> 1), (int)(SimpleSpriteParticleFeature.this.initialSizeRange >> 1));
        }

        protected final void doSpriteParticleSpawn() {
            this.movement.init(this);
            this.spawning.init(this);
            this.doSimpleSpriteParticleSpawn();
        }

        protected void doSimpleSpriteParticleSpawn() {
        }

        protected void doSpriteParticleTick() {
            int tick = this.getTick();
            int ratio = FPMath.div((int)FPMath.fpValue((int)tick), (int)FPMath.fpValue((int)this.getDuration()));
            Sprite sprite = this.getSprite();
            if (SimpleSpriteParticleFeature.this.sizeInterpolatorInstance != null) {
                sprite.setScale(SimpleSpriteParticleFeature.this.sizeInterpolatorInstance.interpolate(this.startSize, this.endSize, ratio));
            }
            if (SimpleSpriteParticleFeature.this.colorSequenceResource != null) {
                SimpleSpriteParticleFeature.this.colorSequenceResource.getColor(tick, tempColor);
                sprite.setColors(tempColor.getRed(), tempColor.getGreen(), tempColor.getBlue(), tempColor.getAlpha());
            }
            this.movement.tick();
        }

        protected void doSpriteParticleDeallocate() {
        }
    }
}

