/*
 * Decompiled with CFR 0.152.
 */
package xap.particles;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.resources.ColorSequenceResource;
import com.shavenpuppy.jglib.util.XMLUtil;
import com.shavenpuppy.jglib.vector.Vector3i;
import org.lwjgl.util.Color;
import org.w3c.dom.Element;
import xap.ParticleMovement;
import xap.ParticleSpawning;
import xap.features.ParticleFeature;
import xap.particles.PointParticleFeature;
import xap.resources.ParticleMovementResource;
import xap.resources.ParticleSpawningResource;

public class SimplePointParticleFeature
extends PointParticleFeature {
    public static final long serialVersionUID = 1L;
    protected static final Vector3i tempVector = new Vector3i();
    protected static final Color tempColor = new Color();
    private String colorSequence;
    private ParticleSpawningResource spawnHandler;
    private ParticleMovementResource movementHandler;
    private transient ColorSequenceResource colorSequenceResource;

    public SimplePointParticleFeature() {
    }

    public SimplePointParticleFeature(String name) {
        super(name);
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.colorSequence = XMLUtil.getString((Element)element, (String)"colorsequence");
        this.spawnHandler = new ParticleSpawningResource();
        this.spawnHandler.load(element, loader);
        this.movementHandler = new ParticleMovementResource();
        this.movementHandler.load(element, loader);
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        this.colorSequenceResource = (ColorSequenceResource)Resources.get((String)this.colorSequence);
    }

    protected ParticleFeature.ParticleInstance createParticle() {
        return new SimplePointParticleInstance();
    }

    protected class SimplePointParticleInstance
    extends PointParticleFeature.PointParticleInstance {
        protected final ParticleMovement movement;
        protected final ParticleSpawning spawning;

        SimplePointParticleInstance() {
            this.movement = SimplePointParticleFeature.this.movementHandler.spawn();
            this.spawning = SimplePointParticleFeature.this.spawnHandler.spawn();
        }

        protected void doTick() {
            if (SimplePointParticleFeature.this.colorSequenceResource != null) {
                SimplePointParticleFeature.this.colorSequenceResource.getColor(this.getTick(), this.color);
            }
            this.movement.tick();
        }

        protected final void doPointParticleSpawn() {
            this.spawning.init(this);
            this.movement.init(this);
            this.doSimplePointParticleSpawn();
        }

        protected void doSimplePointParticleSpawn() {
        }

        protected void doPointParticleDeallocate() {
        }
    }
}

