/*
 * Decompiled with CFR 0.152.
 */
package xap.particles;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.sprites.Animation;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.sprites.SpriteImage;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.XMLUtil;
import org.w3c.dom.Element;
import xap.Game;
import xap.features.ParticleFeature;
import xap.particles.SimpleSpriteParticleFeature;

public class ShadowedSpriteParticleFeature
extends SimpleSpriteParticleFeature {
    public static final long serialVersionUID = 1L;
    private String shadowAnimation;
    private String shadowImage;
    private transient Animation shadowAnimationResource;
    private transient SpriteImage shadowImageResource;

    public ShadowedSpriteParticleFeature() {
    }

    public ShadowedSpriteParticleFeature(String name) {
        super(name);
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.shadowAnimation = XMLUtil.getString((Element)element, (String)"shadowanimation", null);
        this.shadowImage = XMLUtil.getString((Element)element, (String)"shadowimage", null);
        if (this.shadowAnimation == null && this.shadowImage == null) {
            throw new Exception("Particle feature " + this + " has no shadow animation or shadow image.");
        }
        if (this.shadowAnimation != null && this.shadowImage != null) {
            throw new Exception("Particle feature " + this + " must have either a shadow animation or shadow image but not both.");
        }
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        if (this.shadowAnimation != null) {
            this.shadowAnimationResource = (Animation)Resources.get((String)this.shadowAnimation);
        } else {
            this.shadowImageResource = (SpriteImage)Resources.get((String)this.shadowImage);
        }
    }

    protected ParticleFeature.ParticleInstance createParticle() {
        return new ShadowedSpriteParticleInstance();
    }

    protected class ShadowedSpriteParticleInstance
    extends SimpleSpriteParticleFeature.SimpleSpriteParticleInstance {
        protected Sprite shadowSprite;

        protected ShadowedSpriteParticleInstance() {
            super(ShadowedSpriteParticleFeature.this);
        }

        protected void doSpriteParticleTick() {
            super.doSpriteParticleTick();
            int tick = this.getTick();
            int ratio = FPMath.div((int)FPMath.fpValue((int)tick), (int)FPMath.fpValue((int)this.getDuration()));
            if (ShadowedSpriteParticleFeature.this.sizeInterpolatorInstance != null) {
                this.shadowSprite.setScale(ShadowedSpriteParticleFeature.this.sizeInterpolatorInstance.interpolate(ShadowedSpriteParticleFeature.this.initialSize, ShadowedSpriteParticleFeature.this.finalSize, ratio));
            }
            if (ShadowedSpriteParticleFeature.this.colorSequenceResource != null) {
                ShadowedSpriteParticleFeature.this.colorSequenceResource.getColor(tick, tempColor);
                this.shadowSprite.setAlpha(tempColor.getAlpha());
            }
            this.shadowSprite.setLocation(FPMath.intValue((int)this.position.getX()) + 8, FPMath.intValue((int)this.position.getY()) - 8, FPMath.intValue((int)this.position.getZ()));
        }

        protected void doSimpleSpriteParticleSpawn() {
            this.shadowSprite = Game.allocateSprite(this);
            if (ShadowedSpriteParticleFeature.this.shadowAnimationResource != null) {
                this.shadowSprite.setAnimation(ShadowedSpriteParticleFeature.this.shadowAnimationResource);
            } else {
                this.shadowSprite.setImage(ShadowedSpriteParticleFeature.this.shadowImageResource);
            }
            this.shadowSprite.setActive(true);
            this.shadowSprite.setLayer(1);
            this.shadowSprite.setScale(FPMath.TWO);
        }

        protected void doSpriteParticleDeallocate() {
            if (this.shadowSprite != null) {
                this.shadowSprite.deallocate();
                this.shadowSprite = null;
            }
        }
    }
}

