/*
 * Decompiled with CFR 0.152.
 */
package xap.particles;

import com.shavenpuppy.jglib.Memory;
import com.shavenpuppy.jglib.MultiBuffer;
import com.shavenpuppy.jglib.opengl.nvidia.AGPMemory;
import com.shavenpuppy.jglib.opengl.nvidia.GLFence;
import com.shavenpuppy.jglib.util.FPMath;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBPointParameters;
import org.lwjgl.opengl.EXTPointParameters;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.Color;
import xap.features.ParticleFeature;

public abstract class PointParticleFeature
extends ParticleFeature {
    public static final long serialVersionUID = 1L;
    private static final int MAX_POINTS = 2048;
    private static final int VERTEX_SIZE = 32;
    private static final int VERTEX_SHIFT = 5;
    private static final int FLOAT_VERTEX_SHIFT = 3;
    private static final int COLOR_OFFSET = 12;
    private static Memory memory;
    private static MultiBuffer buffer;
    private static FloatBuffer vertexBuffer;
    private static ByteBuffer colorBuffer;
    private static int numPoints;
    private static final ArrayList registry;
    private static int count;
    private static GLFence fence;
    private static FloatBuffer distanceAtten;

    static {
        registry = new ArrayList(4);
        distanceAtten = BufferUtils.createFloatBuffer((int)16);
        distanceAtten.put(new float[]{1.0f, 0.1f, 0.001f});
        distanceAtten.rewind();
    }

    public PointParticleFeature() {
    }

    public PointParticleFeature(String name) {
        super(name);
    }

    public static void renderPointParticles() {
        if (fence != null) {
            fence.finish();
        }
        count = 0;
        vertexBuffer.clear();
        colorBuffer.clear();
        int n = registry.size();
        int i = 0;
        while (i < n && count < 2048) {
            PointParticleFeature ppf = (PointParticleFeature)registry.get(i);
            ppf.write();
            ++i;
        }
        if (count == 0) {
            return;
        }
        GL11.glEnableClientState((int)32884);
        GL11.glEnableClientState((int)32886);
        if (GLContext.getCapabilities().GL_ARB_point_parameters) {
            ARBPointParameters.glPointParameterfARB((int)33062, (float)1.0f);
            ARBPointParameters.glPointParameterfARB((int)33063, (float)200.0f);
            ARBPointParameters.glPointParameterARB((int)33065, (FloatBuffer)distanceAtten);
            GL11.glPointSize((float)32.0f);
        } else if (GLContext.getCapabilities().GL_EXT_point_parameters) {
            EXTPointParameters.glPointParameterfEXT((int)33062, (float)1.0f);
            EXTPointParameters.glPointParameterfEXT((int)33063, (float)200.0f);
            EXTPointParameters.glPointParameterEXT((int)33065, (FloatBuffer)distanceAtten);
            GL11.glPointSize((float)32.0f);
        } else {
            GL11.glPointSize((float)3.0f);
        }
        GL11.glEnable((int)2832);
        GL11.glHint((int)3153, (int)4354);
        GL11.glEnable((int)3042);
        vertexBuffer.flip();
        colorBuffer.flip();
        GL11.glVertexPointer((int)3, (int)32, (FloatBuffer)vertexBuffer);
        GL11.glColorPointer((int)4, (boolean)true, (int)32, (ByteBuffer)colorBuffer);
        if (GLContext.getCapabilities().GL_NV_vertex_array_range2) {
            GL11.glEnableClientState((int)34099);
        } else if (GLContext.getCapabilities().GL_NV_vertex_array_range) {
            GL11.glEnableClientState((int)34077);
        }
        GL11.glDrawArrays((int)0, (int)0, (int)count);
        if (fence != null) {
            fence.set(34034);
        }
        if (GLContext.getCapabilities().GL_NV_vertex_array_range2) {
            GL11.glDisableClientState((int)34099);
        } else if (GLContext.getCapabilities().GL_NV_vertex_array_range) {
            GL11.glDisableClientState((int)34077);
        }
        GL11.glDisableClientState((int)32886);
        GL11.glDisableClientState((int)32884);
        GL11.glDisable((int)3042);
    }

    private void write() {
        int n = this.getNumParticles();
        ParticleFeature.ParticleInstance[] p = this.getParticles();
        int i = 0;
        while (i < n) {
            if (count >= 2048) {
                return;
            }
            ((PointParticleInstance)p[i]).write();
            ++i;
        }
    }

    public void register() {
        super.register();
        registry.add(this);
    }

    public void deregister() {
        super.deregister();
        registry.remove(this);
    }

    public static void init() throws Exception {
        if (buffer == null) {
            memory = AGPMemory.allocate((int)65536);
            buffer = new MultiBuffer(memory.getBuffer());
            vertexBuffer = Memory.chop((ByteBuffer)PointParticleFeature.buffer.bytes, (int)0).asFloatBuffer();
            colorBuffer = Memory.chop((ByteBuffer)PointParticleFeature.buffer.bytes, (int)12);
            if (GLContext.getCapabilities().GL_NV_vertex_array_range || GLContext.getCapabilities().GL_NV_vertex_array_range2) {
                fence = new GLFence();
                fence.create();
            }
        }
    }

    public static void cleanup() {
        buffer = null;
        vertexBuffer = null;
        colorBuffer = null;
        memory = null;
        fence = null;
    }

    protected abstract class PointParticleInstance
    extends ParticleFeature.ParticleInstance {
        protected final Color color = new Color();

        protected PointParticleInstance() {
        }

        private void write() {
            buffer.floats.position(count << 3);
            buffer.floats.put(FPMath.floatValue((int)this.position.getX()));
            buffer.floats.put(FPMath.floatValue((int)this.position.getY()));
            buffer.floats.put(FPMath.floatValue((int)this.position.getZ()));
            buffer.bytes.position((count << 5) + 12);
            this.color.writeRGBA(buffer.bytes);
            count = count + 1;
        }

        protected final void doDeallocate() {
            numPoints = numPoints - 1;
            this.doPointParticleDeallocate();
        }

        protected abstract void doPointParticleDeallocate();

        protected final void doSpawn() {
            numPoints = numPoints + 1;
            this.doPointParticleSpawn();
        }

        protected abstract void doPointParticleSpawn();

        protected boolean isActive() {
            return true;
        }
    }
}

