/*
 * Decompiled with CFR 0.152.
 */
package xap.particles;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.util.XMLUtil;
import org.w3c.dom.Element;
import xap.Emitter;
import xap.features.EmitterFeature;
import xap.features.ParticleFeature;
import xap.particles.SimplePointParticleFeature;

public class ExplosionParticleFeature
extends SimplePointParticleFeature {
    public static final long serialVersionUID = 1L;
    private String smokeEmitter;
    private float fractionSmoky;
    private transient EmitterFeature smokeEmitterFeature;

    public ExplosionParticleFeature() {
    }

    public ExplosionParticleFeature(String name) {
        super(name);
    }

    protected ParticleFeature.ParticleInstance createParticle() {
        return new ExplosionParticleInstance();
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.smokeEmitter = XMLUtil.getString((Element)element, (String)"smokeemitter", null);
        if (this.smokeEmitter != null) {
            this.fractionSmoky = XMLUtil.getFloat((Element)element, (String)"fractionsmoky");
        }
    }

    protected void doCreate() throws Exception {
        super.doCreate();
        if (this.smokeEmitter != null) {
            this.smokeEmitterFeature = (EmitterFeature)Resources.get((String)this.smokeEmitter);
        }
    }

    private class ExplosionParticleInstance
    extends SimplePointParticleFeature.SimplePointParticleInstance {
        private Emitter smokeEmitterInstance;

        ExplosionParticleInstance() {
            super(ExplosionParticleFeature.this);
        }

        protected void doPointParticleDeallocate() {
            if (this.smokeEmitterInstance != null) {
                this.smokeEmitterInstance.remove();
                this.smokeEmitterInstance = null;
            }
        }

        protected void doSimplePointParticleSpawn() {
            if (ExplosionParticleFeature.this.smokeEmitterFeature != null && Math.random() < (double)ExplosionParticleFeature.this.fractionSmoky) {
                this.smokeEmitterInstance = ExplosionParticleFeature.this.smokeEmitterFeature.spawn(this.position.getX(), this.position.getY(), this.position.getZ(), 0, 0, 0);
            }
        }

        protected void doTick() {
            super.doTick();
            if (this.smokeEmitterInstance != null) {
                this.smokeEmitterInstance.setPosition(this.position.getX(), this.position.getY(), this.position.getZ());
                if (!this.smokeEmitterInstance.isActive()) {
                    this.smokeEmitterInstance.remove();
                    this.smokeEmitterInstance = null;
                }
            }
        }
    }
}

