/*
 * Decompiled with CFR 0.152.
 */
package xap.modes.standard;

import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.opengl.GLFont;
import com.shavenpuppy.jglib.resources.ColorSequenceResource;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import org.lwjgl.util.Color;
import xap.Game;
import xap.gui.Component;
import xap.gui.Label;
import xap.gui.Panel;
import xap.modes.standard.StandardHiScoreTable;

public class StandardHiScoreComponent
extends Component
implements StandardHiScoreTable.Display {
    private static final NumberFormat nf = new DecimalFormat("#,###");
    public static final int MAX_SCORES = 10;
    private Label scoreTitle;
    private Label levelTitle;
    private Label accuracyTitle;
    private Row[] row;
    private final ArrayList rows = new ArrayList();

    public StandardHiScoreComponent() throws Exception {
        this.setSize(550, 300);
        this.scoreTitle = new Label("Score");
        this.levelTitle = new Label("Level");
        this.accuracyTitle = new Label("Acc %");
        this.addChild(this.scoreTitle);
        this.addChild(this.levelTitle);
        this.addChild(this.accuracyTitle);
        this.scoreTitle.setAlignment(1).setFont((GLFont)Resources.get((String)"impact-plain-12.glfont")).pack().setLocation(412, 285);
        this.levelTitle.setAlignment(1).setFont((GLFont)Resources.get((String)"impact-plain-12.glfont")).pack().setLocation(455, 285);
        this.accuracyTitle.setAlignment(1).setFont((GLFont)Resources.get((String)"impact-plain-12.glfont")).pack().setLocation(490, 285);
    }

    public void setHiScore(int rank, String name, int score, int level, int accuracy, int rescues, int style, int fluffies, int murders, int bungles) {
        Row row = (Row)this.rows.get(rank - 1);
        row.rankLabel.setText(String.valueOf(rank));
        row.nameLabel.setText(name);
        row.scoreLabel.setText(nf.format(score));
        row.levelLabel.setText(String.valueOf(level));
        row.accuracyLabel.setText(String.valueOf(accuracy));
    }

    public void setNumberOfHiscores(int n) {
        try {
            int i = 0;
            while (i < n) {
                Row row = new Row(i);
                this.rows.add(row);
                row.pack();
                row.setWidth(row.getWidth() + 4);
                row.setLocation(0, this.getHeight() - 10 - row.getHeight() * (i + 1));
                this.addChild(row);
                ++i;
            }
        }
        catch (Exception e) {
            Game.handleException(e);
        }
    }

    private class Row
    extends Panel {
        private Label rankLabel = new Label();
        private Label nameLabel = new Label();
        private Label scoreLabel = new Label();
        private Label levelLabel = new Label();
        private Label accuracyLabel = new Label();
        private Color color = new Color(255, 255, 255, 255);
        private ColorSequenceResource colorSeq;
        private int tick;

        Row(int n) throws Exception {
            this.tick = n * 8;
            this.colorSeq = (ColorSequenceResource)Resources.get((String)"hiscore.colorsequence");
            this.addChild(this.rankLabel);
            this.addChild(this.nameLabel);
            this.addChild(this.scoreLabel);
            this.addChild(this.levelLabel);
            this.addChild(this.accuracyLabel);
            Label[] labels = new Label[]{this.rankLabel, this.nameLabel, this.scoreLabel, this.levelLabel, this.accuracyLabel};
            int[] widths = new int[]{30, 350, 60, 30, 30};
            int pos = 0;
            int i = 0;
            while (i < labels.length) {
                labels[i].setShadow(2, -2, new Color(0, 0, 0, 224));
                labels[i].setForegroundColor(this.color);
                int w = widths[i];
                labels[i].pack().setWidth(w).setX(pos);
                pos += w + 5;
                ++i;
            }
            this.rankLabel.setAlignment(2);
            this.scoreLabel.setAlignment(2);
            this.accuracyLabel.setAlignment(2);
            this.levelLabel.setAlignment(2);
            this.setBorder(5, 0, 5, 5);
            this.pack();
        }

        protected boolean doTick() {
            super.doTick();
            ++this.tick;
            this.colorSeq.getColor(this.tick, this.color);
            this.rankLabel.setForegroundColor(this.color);
            this.nameLabel.setForegroundColor(this.color);
            this.scoreLabel.setForegroundColor(this.color);
            this.levelLabel.setForegroundColor(this.color);
            this.rankLabel.setForegroundColor(this.color);
            return true;
        }
    }
}

