/*
 * Decompiled with CFR 0.152.
 */
package xap.modes.standard;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.util.XMLUtil;
import java.util.ArrayList;
import java.util.Iterator;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import xap.Gidrah;
import xap.features.EncounterFeature;
import xap.features.GidrahFeature;

public class StandardAttackWave
extends Resource {
    public static final long serialVersionUID = 1L;
    private String bubbles;
    private ArrayList gidrahNames = new ArrayList();
    private transient ArrayList gidrahs;
    private transient GidrahFeature bubbleFeature;

    public StandardAttackWave() {
    }

    public StandardAttackWave(ArrayList aliens, String bubbles) {
        this.gidrahNames.addAll(aliens);
        this.bubbles = bubbles;
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        NodeList childTagList = element.getElementsByTagName("gidrah");
        int i = 0;
        while (i < childTagList.getLength()) {
            if (childTagList.item(i) instanceof Element) {
                Element childElement = (Element)childTagList.item(i);
                this.gidrahNames.add(childElement.getAttribute("type"));
            }
            ++i;
        }
        this.bubbles = XMLUtil.getString((Element)element, (String)"bubbles", null);
    }

    protected void doCreate() throws Exception {
        if (this.bubbles != null) {
            this.bubbleFeature = (GidrahFeature)Resources.get((String)this.bubbles);
        }
        this.gidrahs = new ArrayList(this.gidrahNames.size());
        Iterator i = this.gidrahNames.iterator();
        while (i.hasNext()) {
            String gidrahName = (String)i.next();
            this.gidrahs.add(Resources.get((String)gidrahName));
        }
    }

    protected void doDestroy() {
        this.gidrahs = null;
        this.bubbleFeature = null;
    }

    public void spawnGidrahs() {
        int i;
        if (this.bubbleFeature != null) {
            i = 0;
            while (i < 8) {
                Gidrah gidrah = (Gidrah)this.bubbleFeature.spawn();
                if (gidrah != null) {
                    gidrah.resIn();
                }
                ++i;
            }
        }
        i = 0;
        while (i < this.gidrahs.size()) {
            GidrahFeature gidrahFeature = (GidrahFeature)this.gidrahs.get(i);
            Gidrah gidrah = (Gidrah)gidrahFeature.spawn();
            if (gidrah != null) {
                gidrah.resIn();
            }
            EncounterFeature.addEncounter(gidrahFeature);
            ++i;
        }
    }
}

