/*
 * Decompiled with CFR 0.152.
 */
package xap.menu;

import xap.menu.WizardAction;
import xap.menu.WizardDialog;

public class Wizard {
    private final String title;
    private final int numSteps;
    private int currentStep;
    private final WizardAction action;
    private final WizardDialog[] dialogs;

    public Wizard(String title, WizardDialog[] dialogs, WizardAction action) {
        this.title = title;
        this.action = action;
        this.dialogs = dialogs;
        this.numSteps = dialogs.length;
        int i = 0;
        while (i < dialogs.length) {
            dialogs[i].setWizard(this);
            dialogs[i].setTitle(String.valueOf(title) + " - Step " + (i + 1) + " of " + this.numSteps);
            dialogs[i].setPrevWizard(i > 0 ? dialogs[i - 1] : null);
            dialogs[i].setNextWizard(i < dialogs.length - 1 ? dialogs[i + 1] : null);
            dialogs[i].setVisible(i == 0);
            ++i;
        }
    }

    public void finish() {
        this.action.doAction(this.dialogs);
    }
}

