/*
 * Decompiled with CFR 0.152.
 */
package xap.menu;

import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.opengl.GLFont;
import com.shavenpuppy.jglib.opengl.GLTexture;
import com.shavenpuppy.jglib.sprites.Animation;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.sprites.SpriteImage;
import com.shavenpuppy.jglib.sprites.StaticSpriteEngine;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.Util;
import java.util.ArrayList;
import net.puppygames.gamecommerce.shared.RegistrationDetails;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;
import xap.EffectPanel;
import xap.Game;
import xap.features.GameModeFeature;
import xap.gui.CommandButton;
import xap.gui.CommandButtonListener;
import xap.gui.Component;
import xap.gui.Dialog;
import xap.gui.Label;
import xap.menu.AboutWindow;
import xap.menu.ControlsSetupDialog;
import xap.menu.HelpWindow;
import xap.menu.HiScoreDialog;
import xap.menu.NagWindow;
import xap.menu.OptionsDialog;
import xap.menu.RegisterWindow;

public class MainMenu
extends Dialog {
    private final EffectPanel titleScreen;
    private final StaticSpriteEngine spriteEngine;
    private final Animation jellyAnimation;
    private final Animation jellyShadowAnimation;
    private final Animation blobAnimation;
    private final Animation blobShadowAnimation;
    private final Sprite logoSprite;
    private final Label registration;
    private final Label copyright;
    private GLTexture roundedRectangle;
    private GLFont reallyBigFont = (GLFont)Resources.get((String)"impact-plain-32.glfont");
    private GLFont bigFont = (GLFont)Resources.get((String)"impact-plain-24.glfont");
    private GLFont smallFont = (GLFont)Resources.get((String)"impact-plain-18.glfont");
    private static boolean initialNagShown;
    private final SpriteButton newGameButton;
    private final SpriteButton hiScoresButton;
    private final SpriteButton optionsButton;
    private final SpriteButton setupButton;
    private final SpriteButton aboutButton;
    private SpriteButton buyNowButton;
    private final SpriteButton helpButton;
    private final SpriteButton exitButton;
    private final EventHandler eventHandler = new EventHandler();
    private static final int MAX_SPRITES = 32;
    private final ArrayList allocatedSprites = new ArrayList(32);
    private transient boolean registrationShown = false;
    boolean wasActive;

    public MainMenu() throws Exception {
        super("Main Menu");
        this.titleScreen = new EffectPanel("title.effect", 400, 430);
        this.setClipped(false);
        this.spriteEngine = new StaticSpriteEngine(true, 32, Game.getOptions().getTicksPerFrame());
        this.spriteEngine.create();
        this.jellyAnimation = (Animation)Resources.get((String)"blob.animation");
        this.jellyShadowAnimation = (Animation)Resources.get((String)"blob_shadow.animation");
        this.blobAnimation = (Animation)Resources.get((String)"blob.animation");
        this.blobShadowAnimation = (Animation)Resources.get((String)"blob_shadow.animation");
        this.logoSprite = this.allocateSprite();
        this.logoSprite.setImage((SpriteImage)Resources.get((String)"puppygames_small.imagebank.0"));
        this.logoSprite.setLocation(672, -100, 0);
        int[] nArray = new int[8];
        nArray[0] = 144;
        nArray[1] = 144;
        nArray[2] = 144;
        nArray[3] = 144;
        int[] ypos = nArray;
        int i = 0;
        while (i < 8) {
            Sprite s = this.allocateSprite();
            s.setImage((SpriteImage)Resources.get((String)("spriteimage.intro_0" + (i + 1))));
            s.setLocation(i % 4 * 256, ypos[i], 0);
            s.setLayer(-2);
            ++i;
        }
        this.copyright = new Label("\u00a9 2003 Shaven Puppy Ltd - All Rights Reserved - Puppy Games is a trademark of Shaven Puppy Ltd");
        RegistrationDetails rd = Game.getRegistrationDetails();
        this.registration = new Label(rd != null ? rd.toTitleScreen() : "Unregistered");
        this.registration.setFont((GLFont)Resources.get((String)"impact-plain-12.glfont"));
        this.registration.setForegroundColor(new Color(255, 255, 255, 255));
        this.newGameButton = new SpriteButton("Play Game", this.reallyBigFont, this.jellyAnimation, this.jellyShadowAnimation, 2, FPMath.fpValue((float)1.5f));
        this.helpButton = new SpriteButton("Instructions", this.smallFont, this.jellyAnimation, this.jellyShadowAnimation, 0, FPMath.HALF);
        this.hiScoresButton = new SpriteButton("Hiscores", this.smallFont, this.jellyAnimation, this.jellyShadowAnimation, 0, FPMath.HALF);
        this.aboutButton = new SpriteButton("Credits", this.smallFont, this.jellyAnimation, this.jellyShadowAnimation, 0, FPMath.HALF);
        this.optionsButton = new SpriteButton("Options", this.smallFont, this.jellyAnimation, this.jellyShadowAnimation, 1, FPMath.HALF);
        this.setupButton = new SpriteButton("Controls", this.smallFont, this.jellyAnimation, this.jellyShadowAnimation, 1, FPMath.HALF);
        this.exitButton = new SpriteButton("Exit", this.smallFont, this.jellyAnimation, this.jellyShadowAnimation, 1, FPMath.HALF);
        this.createGUI();
        this.initEvents();
    }

    private Sprite allocateSprite() {
        Sprite ret = this.spriteEngine.allocate((Object)this);
        this.allocatedSprites.add(ret);
        return ret;
    }

    public void open() {
        super.open();
        if (!Game.isRegistered() && !this.registrationShown) {
            try {
                new RegisterWindow().open();
                this.registrationShown = true;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    private void createGUI() throws Exception {
        this.setBackgroundColor(new Color(60, 40, 100, 255));
        this.addChild(this.titleScreen);
        if (!Game.isRegistered()) {
            this.buyNowButton = new SpriteButton("Buy Alien Flux NOW!", this.reallyBigFont, this.blobAnimation, this.blobShadowAnimation, 2, FPMath.TWO);
            this.buyNowButton.setDefaultColor(0, 0, 224, 255);
            this.buyNowButton.setHighlightColor(90, 90, 255, 255);
            this.addChild(this.buyNowButton);
        }
        this.addChild(this.newGameButton);
        this.registration.setAlignment(1).setBounds(0, 0, 800, 20).layout();
        this.registration.setShadow(-2, 2, new Color(0, 0, 0, 224));
        this.addChild(this.registration);
        this.addChild(this.hiScoresButton);
        this.addChild(this.optionsButton);
        this.addChild(this.setupButton);
        this.addChild(this.aboutButton);
        this.addChild(this.helpButton);
        this.addChild(this.exitButton);
        this.addChild(this.copyright);
        this.copyright.setBounds(0, -64, 800, 16);
        this.copyright.setClipped(false);
        this.copyright.setFont((GLFont)Resources.get((String)"impact-plain-12.glfont"));
        this.copyright.setAlignment(1);
        this.copyright.setForegroundColor(new Color(255, 255, 255, 255));
        this.newGameButton.setLocation(400 - this.newGameButton.getSize(null).getWidth() / 2, 168);
        if (!Game.isRegistered()) {
            this.buyNowButton.setLocation(400 - this.buyNowButton.getSize(null).getWidth() / 2, 49);
        }
        this.helpButton.setBounds(160, 172, 120, this.helpButton.getHeight());
        this.hiScoresButton.setBounds(130, 114, 120, this.hiScoresButton.getHeight());
        this.aboutButton.setBounds(100, 54, 120, this.aboutButton.getHeight());
        this.setupButton.setBounds(520, 172, 120, this.setupButton.getHeight());
        this.optionsButton.setBounds(550, 114, 120, this.optionsButton.getHeight());
        this.exitButton.setBounds(580, 54, 120, this.exitButton.getHeight());
        this.setSize(800, 400);
        this.centre();
        if (Game.isRegistered()) {
            this.newGameButton.requestFocus();
        } else {
            this.buyNowButton.requestFocus();
        }
    }

    private void initEvents() {
        this.newGameButton.addCommandButtonListener(this.eventHandler);
        this.hiScoresButton.addCommandButtonListener(this.eventHandler);
        this.aboutButton.addCommandButtonListener(this.eventHandler);
        this.helpButton.addCommandButtonListener(this.eventHandler);
        this.exitButton.addCommandButtonListener(this.eventHandler);
        if (!Game.isRegistered()) {
            this.buyNowButton.addCommandButtonListener(this.eventHandler);
        }
        this.setupButton.addCommandButtonListener(this.eventHandler);
        this.optionsButton.addCommandButtonListener(this.eventHandler);
    }

    protected boolean doTick() {
        if (this.isActive() != this.wasActive) {
            this.wasActive = this.isActive();
            int alpha = this.wasActive ? 255 : 64;
            int n = this.allocatedSprites.size();
            int i = 0;
            while (i < n) {
                ((Sprite)this.allocatedSprites.get(i)).setAlpha(alpha);
                ++i;
            }
        }
        this.spriteEngine.setTickRate(Game.getOptions().getTicksPerFrame());
        super.doTick();
        this.spriteEngine.tick();
        return true;
    }

    protected void renderBackground() {
        GL11.glDisable((int)3089);
        this.spriteEngine.render();
        GL11.glEnable((int)3089);
    }

    public Component setVisible(boolean newVisible) {
        super.setVisible(newVisible);
        if (this.titleScreen != null) {
            this.titleScreen.setVisible(newVisible);
        }
        return this;
    }

    public void updateRegistrationDetails(RegistrationDetails details) {
        this.registration.setText(details.toTitleScreen());
        this.buyNowButton.setVisible(false);
        this.newGameButton.setText("Play Game");
        this.newGameButton.requestFocus();
    }

    private class SpriteButton
    extends CommandButton {
        private Sprite sprite;
        private Sprite shadowSprite;
        private int spritePosition;
        private static final int LEFT = 0;
        private static final int RIGHT = 1;
        private static final int ABOVE = 2;

        public SpriteButton(String text, GLFont font, Animation animation, Animation shadowAnimation, int spritePosition, int scale) throws Exception {
            super(text);
            this.label.setFont(font);
            this.sprite = MainMenu.this.allocateSprite();
            this.sprite.setAnimation(animation);
            this.sprite.setScale(scale);
            this.shadowSprite = MainMenu.this.allocateSprite();
            this.shadowSprite.setAnimation(shadowAnimation);
            this.shadowSprite.setLayer(-1);
            this.shadowSprite.setScale(scale << 1);
            this.spritePosition = spritePosition;
            int seq = Util.random((int)0, (int)16) << 1;
            this.sprite.setSequence(seq);
            this.shadowSprite.setSequence(seq >> 1);
            this.setDefaultColor(196, 196, 196, 255);
            this.setHighlightColor(255, 255, 255, 255);
            this.setBackgroundColor(null);
            this.label.setShadow(-2, 2, new Color(0, 0, 0, 224));
            this.label.revalidate();
            this.label.pack();
            this.pack();
            this.revalidate();
        }

        private void setSpritePosition() {
            int yy;
            int xx;
            if (this.sprite == null || this.shadowSprite == null) {
                return;
            }
            switch (this.spritePosition) {
                case 0: {
                    xx = this.getX() - 16;
                    yy = this.getY() + (this.getHeight() >> 1);
                    break;
                }
                case 1: {
                    xx = this.getX() + this.getWidth() + 16;
                    yy = this.getY() + (this.getHeight() >> 1);
                    break;
                }
                default: {
                    xx = this.getX() + (this.getWidth() >> 1);
                    yy = this.getY() + this.getHeight() + FPMath.intValue((int)(12 * this.sprite.getScale()));
                }
            }
            this.sprite.setLocation(xx, yy, 0);
            this.shadowSprite.setLocation(xx, yy, 0);
        }

        protected boolean doTick() {
            boolean ret = super.doTick();
            this.setSpritePosition();
            return ret;
        }

        public Component setVisible(boolean newVisible) {
            if (this.sprite != null) {
                this.sprite.setVisible(newVisible);
            }
            if (this.shadowSprite != null) {
                this.shadowSprite.setVisible(newVisible);
            }
            return super.setVisible(newVisible);
        }
    }

    private class EventHandler
    implements CommandButtonListener {
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("xap.menu.MainMenu$EventHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        EventHandler() {
        }

        public boolean selected(CommandButton button) {
            try {
                if (button == MainMenu.this.newGameButton) {
                    GameModeFeature.beginNewGame();
                } else if (button == MainMenu.this.hiScoresButton) {
                    new HiScoreDialog(null).open();
                } else if (button == MainMenu.this.optionsButton) {
                    new OptionsDialog(Game.getOptions());
                } else if (button == MainMenu.this.setupButton) {
                    new ControlsSetupDialog();
                } else if (button == MainMenu.this.aboutButton) {
                    new AboutWindow();
                } else if (button == MainMenu.this.buyNowButton) {
                    Game.buy();
                } else if (button == MainMenu.this.helpButton) {
                    new HelpWindow();
                } else if (button == MainMenu.this.exitButton) {
                    if (!Game.isRegistered()) {
                        try {
                            Runnable continueCode = new Runnable(this){
                                final /* synthetic */ EventHandler this$1;
                                {
                                    this.this$1 = eventHandler;
                                }

                                public void run() {
                                    EventHandler.access$0(this.this$1).close();
                                    Game.finish();
                                }
                            };
                            new NagWindow("Maybe later...", continueCode).open();
                        }
                        catch (Exception e) {
                            Game.handleException(e);
                        }
                    } else {
                        MainMenu.this.close();
                        Game.finish();
                    }
                } else if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            catch (Exception e) {
                Game.handleException(e);
            }
            return false;
        }

        static /* synthetic */ MainMenu access$0(EventHandler eventHandler) {
            return eventHandler.MainMenu.this;
        }
    }
}

